/******************************************************************

Description:    DeScribe 3.0 Run Exec.

Details:        This exec is used to run the DeScribe program.

                It checks to see if the Local.Directory structure
                exists.  If it doesn't the user is told to run
                the install program.  If it does exist the TMP
                environment variable is set to the TEMP subdirectory
                below the Local.Directory.  The exec then switches
                to the Local.Directory and prepends the current
                vendor drive to the PATH and DPATH.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
                HIDEWIN.EXE - Part of VENDOR package.
   Drive(s):    Must be run from same drive to preserve path
                information for layouts and macros.
   Directories: Tutorial files should be copied locally during install
                for easier use of workbook lessons.
   Window Type: FS/WIN
   App Title:   DeScribe

Last Updated:   9/23/92
******************************************************************/
'@ECHO OFF'
trace 'o'

call RxFuncAdd 'RXDIREXIST',  'RXUTILS', 'RXDIREXIST'
call RxFuncAdd 'RXBOOTDRIVE', 'RXUTILS', 'RXBOOTDRIVE'
call RxFuncAdd 'RXMKDIR',     'RXUTILS', 'RXMKDIR'
call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'
call RxFuncAdd 'RXPAUSE',     'RXUTILS', 'RXPAUSE'

/* Give header */
say
say ' DeScribe'
say ' --------'
say

/* Parse args */
parse source . . exec
path=left(exec, lastpos('\', exec))
drive=left(path,2)
BootDrive = RxBootDrive()

/***************************************************************************/
/** Check if Local Directory exists, if not tell user to run installation **/
/***************************************************************************/

Local.Directory = RxOS2Ini(, 'Directories', 'DScribe3')

if rxDirExist(Local.Directory'\temp')=0 then do
   say
   say d2c(7)|| ' Local DeScribe directories not set.'
   say ' You must run the installation program.'
   say
   call RxPause
   'exit 10'
end  /* Do */

/*****************************************/
/** Set up the TMP Environment Variable **/
/*****************************************/

call value 'TMP', Local.Directory'\temp', 'OS2ENVIRONMENT'

/*******************************/
/** Change to local directory **/
/*******************************/

call directory Local.Directory

/****************************************************/
/** Prepend remote drive to current PATH and DPATH **/
/****************************************************/

Env = 'OS2ENVIRONMENT'
parse source . . drv
drv = left(drv,3)
call value 'PATH',  drv';'||value('PATH',,Env), Env
call value 'DPATH', drv';'||value('DPATH',,Env), Env

/** Run DeScribe **/
say
say ' Starting DeScribe...'
say
say ' Local directory = 'Local.Directory
say
say ' Please wait a moment while DeScribe is loaded.'
say '       ( This may take more than a minute )'
say
say ' Once DeScribe has started this window will be'
say ' hidden...'

'START HIDEWIN /D=20 DeScribe'
'DESCRIBE'
'exit'
