/******************************************************************

Description:    DeScribe 3.0 Installation Exec.

Details:        This exec is used to install DeScribe.

                Installation consists of asking the user for a
                local directory in which to store local files
                This info is stored in OS2.INI.  It also creates
                several subdirectories below the Local Directory
                and allows the user to copy the tutorial files to
                his or her local directory.

Dependencies:
   Externals:   RXUTILS.DLL  - Part of VENDOR package.
                PMBROWSE.EXE - Part of VENDOR package.
   Drive(s):    Must be run from same drive to preserve path
                information for layouts and macros.
   Directories: Tutorial files can be copied locally for use with
                the workbook.
   Window Type: FS/WIN
   App Title:   DeScribe

Last Updated:   5/13/92
******************************************************************/
'@ECHO OFF'
trace 'o'

call RxFuncAdd 'RXDIREXIST',  'RXUTILS', 'RXDIREXIST'
call RxFuncAdd 'RXPAUSE',     'RXUTILS', 'RXPAUSE'
call RxFuncAdd 'RXMKDIR',     'RXUTILS', 'RXMKDIR'
call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'
call RxFuncAdd 'RXFILEEXIST', 'RXUTILS', 'RXFILEEXIST'

say
say ' DeScribe Installation'
say ' ---------------------'
say

/* Parse args */
parse source . . exec
path=left(exec, lastpos('\', exec))
drive=left(path,2)
BootDrive=RxBootDrive()

/***********************************************/
/** Check if a Local.Directory already exists **/
/***********************************************/

Local.Directory = RxOS2Ini(, 'Directories', 'DScribe3')

if rxDirExist(Local.Directory)=1 then do
   say ' Current DeScribe local directory = 'Local.Directory
   say
end  /* if rxDirExist... */

/***************************************************************/
/** Get the valid local drives, remove the VDISK, prompt user **/
/***************************************************************/

DrvMap = RxDriveMap('C:', 'LOCAL' )
parse upper value RxDriveInfo( right(DrvMap,2)) with . 'LABEL='label .
if pos('VDISK', label)<>0 then DrvMap=left(DrvMap, length(DrvMap)-3)

/********************************************************/
/** Prompt user for Local Directory.  Do until a valid **/
/** local drive is used.                               **/
/********************************************************/

say
say ' Enter a local directory where your DeScribe files will be saved:'
say ' Valid local Drives:' DrvMap
say ' i.e. C:\DESCRIBE'
say

/*****************************************************/
/** Create Local Directory.  Add entry to OS2.INI.  **/
/*****************************************************/

OK=0
do until OK=1
   Local.Directory = translate( LINEIN('STDIN') )
   if POS( left(Local.Directory,2), DrvMap) <> 0 then
      OK=1
   else do
      say
      say d2c(7)||' Cannot create directory.  Try again...'
      say
      OK=0
   end /* do */
   if OK=1 then do
      if Local.Directory<>'' then do
         call rxMkDir Local.Directory
         call rxMkDir Local.Directory'\temp'
         call rxMkDir Local.Directory'\usrdicts'
         call rxMkDir Local.Directory'\data'
         if RxDirExist(Local.Directory) then
            call RxOS2Ini , 'Directories', 'DScribe3', Local.Directory
         if RxDirExist(Local.Directory)=0 then do
            OK=0
            say
            say d2c(7)||' Cannot create directory.  Try again...'
            say
         end  /* do */
      end /* do */
   end /* do */
end /* do until */

/**********************************************************/
/** Delete describe.dat so that a new one can be created **/
/**********************************************************/

if rxFileExist(BootDrive'\os2\describe.dat') then do
  call rxDelete BootDrive'\os2\describe.dat'
end  /* Do */

/*****************************************************************/
/** Ask if User wants to copy tutorial files to Local.Directory **/
/*****************************************************************/

say
say ' DeScribe comes with some tutorial files which are used'
say ' in the DeScribe Workbook exercises.  They take up'
say ' approxiamately 510KB of disk space.  Some of these files'
say ' cannot be opened as described in the workbook across the'
say ' network.  Therefore you may copy all of the tutorial'
say ' files to your hard disk now.  If you choose not to, you'
say ' may copy the files later by rerunning the install program.'
say
say ' Do you want to copy these files to your hard disk?  (Y/N)'
say

do until conv='Y' | conv='N'
   conv = translate(left(linein(STDIN),1))
end  /* do until... */

if (conv='Y') then do
  call rxMkDir Local.Directory'\tutorial'
  call rxMkDir Local.Directory'\tutorial\art'
  call rxMkDir Local.Directory'\tutorial\examples'
  call rxMkDir Local.Directory'\tutorial\layouts'
  call rxMkDir Local.Directory'\tutorial\text'
  call rxMkDir Local.Directory'\tutorial\Working'
    'copy 'path'tutorial\art\*.*' Local.Directory'\tutorial\art\'
    'copy 'path'tutorial\examples\*.*' Local.Directory'\tutorial\examples\'
    'copy 'path'tutorial\layouts\*.*' Local.Directory'\tutorial\layouts\'
    'copy 'path'tutorial\text\*.*' Local.Directory'\tutorial\text\'
end  /* if (conv='Y')... */

/**************************************************************************/
/** Start PMBrowse to tell user to modify Global Preferences in DeScribe **/
/** spellchk.inf tells user to set user dictionary to a local directory  **/
/**************************************************************************/

'call pmbrowse spellchk.inf'

/* Give message */
say
say ' DeScribe is now ready to run.'
say ' A reboot is not necessary.'
say
call RxPause
'exit'
