/******************************************************************

Description:    CorelDRAW! 2.00a run exec.

Details:        This exec checks to see if Corel Draw! has been
                installed by looking for C:\COREL20\CDCONFIG.SYS.
                If the file is not found it tells the user to run
                the installation program.  If the file exists it
                prompts the user for the companion programs which
                should be started when the main CorelDRAW! program
                is started.  If C:\COREL20\CDCONFIG.SYS is not found
                the user is told to run the installation program.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR PACKAGE.
                HIDEWIN.EXE - Part of VENDOR PACKAGE.

   Drive(s):    Corel Draw! must be run from the R: drive
   Directories: C:\COREL20 - See install exec for this package.
   Window Type: FS/Win
   App Title:   CorelDRAW! for OS/2

Last Updated:   9/23/92
******************************************************************/
 trace 'O'
 '@echo off'

call RxFuncAdd 'RXFILEEXIST', 'RXUTILS', 'RXFILEEXIST'

parse source . . exec
path=left(exec, lastpos('\', exec))
UserDrive = value('USER.DRIVE',,'OS2ENVIRONMENT')

/***************************************************/
/** Check for local CorelDRAW! configuration file **/
/***************************************************/

if \RxFileExist('C:\COREL20\CDCONFIG.SYS') then do
  say
  say 'CorelDRAW! has not been set up to run on your system.'
  say 'Please run the installation program'
  say
  'pause'
  'exit'
end
else

say
say ' CorelDRAW! for OS/2'
say ' -------------------'
say

/** Run CorelDraw! **/
say
say ' Starting CorelDRAW!....'
say ' Please wait a moment while CorelDRAW! is loaded.'
say '       ( This may take a short while. )'

'START HIDEWIN /D=20 CorelDRAW! for OS/2'
'CORELDRW'
'exit'
