/******************************************************************

Description:    CorelDRAW! 2.00a Install Exec

Details:        This exec creates the directory C:\COREL20 if it
                does not already exist.  It then copies ~490K  of
                files.  This is necessary for CorelDRAW! to run
                from a file server.  The file CDCONFIG.SYS is
                a personal configuration file that is modified with
                each use of Corel Draw!  The other files are
                additional configuration files which CorelDRAW!
                requires to be in the same place as CDCONFIG.SYS.

Dependencies:
   Externals:   RXUTILS.DLL  - Part of VENDOR package.
   Drive(s):    CorelDRAW! must be run from the R: drive
   Directories: C:\COREL20 - This directory contains ~490K of files
                which must be stored locally for CorelDRAW! to run
                on a LAN.
   Window Type: FS/Win
   App Title:   CorelDraw! for OS/2

Last Updated:   2/12/92
******************************************************************/
 trace 'O'
 '@echo off'

call RxFuncAdd 'RXDIREXIST',  'RXUTILS', 'RXDIREXIST'
call RxFuncAdd 'RXMKDIR',     'RXUTILS', 'RXMKDIR'
call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'

parse source . . exec
path=left(exec, lastpos('\', exec))
UserDrive = value('USER.DRIVE',,'OS2ENVIRONMENT')

Local.Directory = RxOS2Ini(, 'Directories', 'CorelDraw20')
     say
     say 'In order to run CorelDRAW! 2.0 certain configuration files'
     say 'must be copied to your hard disk.  These files will take up'
     say 'approxiamately 490K of disk space and they must be copied to'
     say 'the C:\COREL20 subdirectory.  If this directory does not'
     say 'already exist it will be created.'
     say
     say 'Do you want to continue? (Y/N)'
     do until Continue='Y' | Continue='N'
       Continue = translate(left(linein(STDIN),1))
       end
     if Continue='N' then
       'exit'

     Local.Directory = 'C:\COREL20'
     call rxMkDir Local.Directory
       'copy 'path'cdconfig.sys' Local.Directory
       'copy 'path'coreldrw.bpt' Local.Directory
       'copy 'path'coreldrw.dot' Local.Directory
       'copy 'path'coreldrw.end' Local.Directory
       'copy 'path'coreldrw.ink' Local.Directory
       'copy 'path'coreldrw.ipl' Local.Directory
       'copy 'path'coreldrw.pal' Local.Directory
       'copy 'path'*.pat' Local.Directory

     if rxDirExist(Local.Directory) then do
        call RxOS2Ini , 'Directories', 'CorelDraw20', Local.Directory
     end  /* if rxDirExist */

/* Give completed message */
say
say 'CorelDRAW! is ready to run.  A reboot is not required.'
say
'pause'
'exit'

