/******************************************************************
Description:    Corel DRAW! version 1.00 run exec

Details:        This exec prompts the user for a local directory
                which is then created and and added to OS2.INI.
                It then starts the Corel DRAW! program.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
                HIDEWIN.EXE - Part of VENDOR package.
   Drive(s):    None
   Directories: none
   Window Type: FS/WIN
   App Title:   Corel DRAW! for OS/2 

Last Updated:   8/27/92
******************************************************************/

 trace 'O'
 '@echo off'

call RxFuncAdd 'RXDIREXIST',  'RXUTILS', 'RXDIREXIST'
call RxFuncAdd 'RXMKDIR',     'RXUTILS', 'RXMKDIR'
call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'
call RxFuncAdd 'RXDRIVEMAP' , 'RXUTILS', 'RXDRIVEMAP'

parse source . . exec
Cdr=left(exec, lastpos('\', exec))
UserDrive = value('USER.DRIVE',,'OS2ENVIRONMENT')

say
say ' CorelDraw! for OS/2'
say ' -------------------'
say

/***********************************************/
/** Check if a Local.Directory already exists **/
/***********************************************/

Local.Directory = RxOS2Ini(, 'Directories', 'COREL')
if Local.Directory = '$RXERROR' then do
   Local.Directory = RxOS2Ini(, 'COREL', 'WORKDIR')
   if Local.Directory <> '$RXERROR' then do
      call RxOS2Ini , 'Directories', 'COREL', Local.Directory
      call RxOS2Ini , 'COREL', 'WORKDIR', '$RXDEL'
   end
end

/***************************************************************/
/** Get the valid local drives, remove the VDISK, prompt user **/
/***************************************************************/

Do Forever
   If RxDirExist(Local.Directory)=0 then do

      DrvMap = RxDriveMap('C:', 'LOCAL' )
      parse upper value RxDriveInfo( right(DrvMap,2)) with . 'LABEL='label .
      if pos('VDISK', label)<>0 then DrvMap=left(DrvMap, length(DrvMap)-3)


/********************************************************/
/** Prompt user for Local Directory.  Do until a valid **/
/** local drive is used.                               **/
/********************************************************/

      say
      say ' Please enter a subdirectory where your Corel DRAW! files'
      say ' will be saved on your workstation.  This subdirectory will'
      say ' be created if it does not already exist.'
      say
      say ' Valid local Drives:' DrvMap
      say ' for example; D:\COREL'
      say

/*****************************************************/
/** Create Local Directory.  Add entry to OS2.INI.  **/
/*****************************************************/

      OK=0
      do until OK=1
         Local.Directory = translate( LINEIN('STDIN') )
         if POS( left(Local.Directory,2), DrvMap) <> 0 then
            OK=1
         else do
            say
            say d2c(7)||' Cannot create directory.  Try again...'
            say
            OK=0
         end /* do */
      
         if OK=1 then do
            if Local.Directory<>'' then do
               call rxMkDir Local.Directory
      
               if RxDirExist(Local.Directory)=1 then
                  call RxOS2Ini , 'Directories', 'COREL', Local.Directory
      
               if RxDirExist(Local.Directory)=0 then do
                  OK=0
                  say
                  say d2c(7)||' Cannot create directory.  Try again...'
                  say
               end  /* do */
            end /* do */
         end /* do */
      end /* do until */
   end /* if RxDirExist */
   else leave
end /* do forever */

/********************/
/** Run CorelDraw! **/
/********************/

say
say ' Starting Corel Draw!....'
say ' Please wait a moment while Corel Draw! is loaded into memory.'
say '       ( This may take a short while. )'

'START HIDEWIN /D=30 CorelDraw! for OS/2'
'CORELDRW'

'exit 0'
