/******************************************************************

Description:    CorelDraw Installation Exec.

Details:        This exec asks the user what local directory
                should be used for the Corel.  The directory
                spec is created and recorded in OS2.INI.

                The root directory of the remote drive is added
                to the user's LIBPATH if needed.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
                LIBEDIT.CMD - Part of VENDOR package.
   Drive(s):    Always use same drive.
   Directories: DLLs and EXEs in current directory.
   Window Type: FS/Win
   App Title:   CorelDraw! for OS/2

Last Updated:   9/23/92
******************************************************************/
'@echo off'
trace 'o'

/* Load externals */
call RxFuncAdd 'RXDIREXIST',  'RXUTILS', 'RXDIREXIST'
call RxFuncAdd 'RXMKDIR',     'RXUTILS', 'RXMKDIR'
call RxFuncAdd 'RXPAUSE',     'RXUTILS', 'RXPAUSE'
call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'

say
say ' CorelDraw Installation:'
say ' -----------------------'
say

/*  Get drive letter being used */
parse upper source . . drv
drv = left(drv,2)

/***********************************************/
/** Check if a Local.Directory already exists **/
/***********************************************/

Local.Directory = RxOS2Ini(, 'Directories', 'COREL')
if rxDirExist(Local.Directory)=1 then do
   say ' Current Corel Draw! local directory = 'Local.Directory
   say
end  /* if rxDirExist... */

/***************************************************************/
/** Get the valid local drives, remove the VDISK, prompt user **/
/***************************************************************/

DrvMap = RxDriveMap('C:', 'LOCAL' )
parse upper value RxDriveInfo( right(DrvMap,2)) with . 'LABEL='label .
if pos('VDISK', label)<>0 then DrvMap=left(DrvMap, length(DrvMap)-3)

/********************************************************/
/** Prompt user for Local Directory.  Do until a valid **/
/** local drive is used.                               **/
/********************************************************/

say
say ' Corel Draw! drawings will be saved on your workstation.'
say ' Valid local Drives:' DrvMap
say
say ' Enter a local directory where your Corel Draw! files'
say ' will be saved, i.e. C:\COREL'
say

/*****************************************************/
/** Create Local Directory.  Add entry to OS2.INI.  **/
/*****************************************************/

OK=0
do until OK=1
   Local.Directory = translate( LINEIN('STDIN') )
   if POS( left(Local.Directory,2), DrvMap) <> 0 then
      OK=1
   else do
      say
      say d2c(7)||' Cannot create directory.  Try again...'
      say
      OK=0
   end /* do */
   if OK=1 then do
      if Local.Directory<>'' then do
         call rxMkDir Local.Directory
         if RxDirExist(Local.Directory)=1 then
            call RxOS2Ini , 'Directories', 'COREL', Local.Directory
         if RxDirExist(Local.Directory)=0 then do
            OK=0
            say
            say d2c(7)||' Cannot create directory.  Try again...'
            say
         end  /* do */
      end /* do */
   end /* do */
end /* do until */

/****************************************************/
/** Add drive entry to LIBPATH statement if needed **/
/****************************************************/

call LIBEDIT drv'\' 'A'    /* External Rexx Exec */
LibEditRC = value('LIBEDIT.RC',,'OS2ENVIRONMENT')
if LibEditRC=0 then do
  say d2c(7)
  say ' Important Note:'
  say ' ---------------'; say
  say ' The 'drv'\ entry has just been added to the LIBPATH statement'
  say ' of your CONFIG.SYS file.  You must reboot before Corel Draw'
  say ' will run correctly.'
  say
end
else do
  say
  say ' Corel Draw is ready to run on your PC.'
  say
end
call RxPause
'exit'
