/******************************************************************
Description:    IBM READ/2 Run Exec.

Details:        This exec sets up the appropriate IBM READ/2 Env.
                READ/2 requires that the HELP, PATH, DPATH and
                IOPL statements be set correctly. The BOOKMGR
                Env Var must point to all the Book Shelves.
                This exec sets all Env Vars and builds the BOOKMGR
                path dynamically.

                This LAN Version requires that all of the Books be
                placed in a BOOKS alias on some Network resource.

                So as to find its appropiate DLLs, the BOOKMGR.EXE
                must be run from the current drive if the assigned
                drive is not in the LIBPATH.  Since our READ2 alias
                is on a READ ONLY network resource all NoteFiles
                will be placed on the C:\ of the user's machine.

Dependencies:
   Externals:   HIDEWIN.EXE  - Part of VENDOR package.
                GIME.EXE     - Part of VENDOR package.
                RXUTILS.DLL  - Part of VENDOR package.
   Drive(s):    BOOKS network alias containing your BookManager Repository
   Directories: None
   Window Type: FS/Win
   App Title:   Book Manager READ/2

Last Updated:   9/23/92
******************************************************************/
 trace 'O'
 '@echo off'

/* Add external funcs */
 call RxFuncAdd 'RXTREE',      'RXUTILS', 'RXTREE'
 call RxFuncAdd 'RXGREP',      'RXUTILS', 'RXGREP'
 call RxFuncAdd 'RXBOOTDRIVE', 'RXUTILS', 'RXBOOTDRIVE'

 parse source . . exec
 CurDr=left(exec, lastpos('\', exec))
 boot=RxBootDrive()

 if (value('B.DRIVE',,'OS2ENVIRONMENT')<>CurDr) then do
/*  Give greetings messages  */
   say;
   say ' Book Manager READ/2'
   say ' -------------------'
   say;

/* Set up so its non-entrant */
   call value 'B.DRIVE', CurDr, 'OS2ENVIRONMENT'

/* 7 Aug 91 - start additions */
/* Test for IOPL=YES */
call rxGrep 'IOPL', boot'\CONFIG.SYS', 'TEMP.'
Ok = 0
do I = 1 to Temp.0 until Ok
  parse var Temp.I A '=' B
  Ok = (A = 'IOPL' & B = 'YES')
end
if \Ok
  then do
    say d2c(7)'IOPL=YES must be specified in CONFIG.SYS.'
    say 'You must add this line and reboot before using READ/2.'
    exit 2
  end
/* teb - end additions */

/* Set up the HELP Statement */
   oldhelp = value('HELP',,'OS2ENVIRONMENT')
   newhelp =CurDr';'oldhelp
   call value 'HELP',   newhelp, 'OS2ENVIRONMENT'

/* Set up the PATH Statement */
   oldpath = value('PATH',,'OS2ENVIRONMENT')
   newpath =CurDr';'oldpath
   call value 'PATH',   newpath, 'OS2ENVIRONMENT'

/* Set up the DPATH Statement */
   olddpath = value('DPATH',,'OS2ENVIRONMENT')
   newdpath =CurDr';'olddpath
   call value 'DPATH',   newdpath, 'OS2ENVIRONMENT'

/* Access the BookManager Repository in the BOOKS alias */
   Bdr=GetBookDrive()

   OutC = RxTree(BDr'*', 'DIRS.', 'DO')
   if OutC <> 0
     then say 'Error' OutC 'reading book directories.'
   Env = 'OS2ENVIRONMENT'
   BKS = value('BOOKMGR',,Env)
   if BKS <> '' & right(BKS, 1) <> ';'
     then BKS = BKS';'
   do I = 1 to Dirs.0
     BKS = BKS||Dirs.I';'
   end
   BKS = BKS||BDr';'
   call value 'BOOKMGR', BKS, Env
 end

/* Start the BookManager READ/2 Application, Display BookShelves Only */
 say ' Loading Book Manager....'
 say
 say ' This can take up to 30 seconds.  Please Wait...'
 'START HIDEWIN /D=30 Book Manager READ/2'
 'BOOKMGR /ds'

/* Drop BOOKS Repository Alias and Exit */
 'GIME BOOKS /D>NUL 2>&1'
'exit 0'


/**************************************************/
/** GetBookDrive()                               **/
/**                                              **/
/** Uses GIME to attach the BOOKS alias as a drv **/
/**                                              **/
/** Requires a NETALIAS.LST in users DPATH       **/
/** which contains a BOOKS alias definition      **/
/** which points to the BOOKS alias on some      **/
/** server.  See GIME documentation if needed.   **/
/**                                              **/
/** The drive letter is returned.                **/
/**************************************************/
GetBookDrive: procedure
do queued(); pull .; end
call RxSay ' Assigning Book Repository Drive.....'
'GIME BOOKS | RXQUEUE'
parse pull line 'The netname' . 'assigned to drive 'Drive .
if Right(Drive,1)=':' then
  say 'Done.'
else
  say d2c(7)'Error!'
return Drive
