/******************************************************************
Description:    Ami Pro for Windows 3.0 Run Exec

Details:        This exec is used to run the Ami Pro for Windows program.

                It checks to see if the Local.Directory exists.
                If it doesn't the user is told to run the install.
                It also checks to make sure that OS/2 2.0 is
                running.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
                HIDEWIN.EXE - Part of VENDOR package.
   Drive(s):    Must be run from the M: drive
   Directories:
   Window Type: FS/WIN
   App Title:   Ami Pro for Windows

Last Updated:   10/1/92
******************************************************************/
'@ECHO OFF'
trace 'o'

call RxFuncAdd 'RXDIREXIST',  'RXUTILS', 'RXDIREXIST'
call RxFuncAdd 'RXOS2VER',    'RXUTILS', 'RXOS2VER'
call RxFuncAdd 'RXPAUSE',     'RXUTILS', 'RXPAUSE'
call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'

/* Give header */
say
say ' Ami Pro for Windows run exec'
say ' ----------------------------'
say

/* Parse args */
parse source . . exec
path=left(exec, lastpos('\', exec))
drive=left(path,2)

/*****************************************/
/** Determine if OS/2 2.0 is being used **/
/*****************************************/

if (RxOS2Ver() < 2.0) then do
  say
  say d2c(7)|| 'Error!'
  say 'You must be using OS/2 2.0 or later in order to'
  say 'run Ami Pro for Windows.  Windows programs'
  say 'cannot be run on versions of OS/2 prior to 2.0'
  say
  call RxPause 'Press any key to exit.'
  'exit 10'
end /* do */

/***************************************************************************/
/** Check if Local Directory exists, if not tell user to run installation **/
/***************************************************************************/

Local.Directory = RxOS2Ini(, 'Directories', 'AMIPRO')
if rxDirExist(Local.Directory)=0 then do
   say
   say d2c(7)|| ' Local Ami Pro for Windows directory not set.'
   say ' You must run the installation program.'
   say
   call RxPause 'Press any key to exit.'
   'exit 10'
end  /* Do */

/** Start Ami Pro **/
say
say ' Please wait while Ami Pro is loaded.'
say ' ( This may take more than a minute )'
say
say ' Local directory = 'Local.Directory
say
say ' Once Ami Pro has started this window will be hidden.'
say
'START HIDEWIN /D=20 Ami Pro for Windows'
'AMIPRO'
'exit'
