/******************************************************************
Description:    Aldus PageMaker 3.01 Run Exec.

Details:        This exec is used to run the PageMaker program.

                The first time this exec is run, the user will
                be prompted for a local directory to store
                configuration files.  This directory spec is
                required and is used as command params to PageMaker.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
   Drive(s):    None
   Directories: All DLL and EXE files in same directory.
   Window Type: FS/WIN
   App Title:   Aldus PageMaker

Last Updated:   9/23/92
******************************************************************/

'@ECHO OFF'
trace 'o'

call RxFuncAdd 'RXDIREXIST',  'RXUTILS', 'RXDIREXIST'
call RxFuncAdd 'RXMKDIR',     'RXUTILS', 'RXMKDIR'
call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'


/* Give header */
say
say ' Aldus PageMaker run exec'
say ' ------------------------'
say

/************************************************************************/
/** Check if a Local.Directory exists, if not tell user to run install **/
/************************************************************************/

Local.Directory = RxOS2Ini(, 'Directories', 'AldusPM')
if rxDirExist(Local.Directory)=0 then do
   say
   say ' Local PageMaker directory not set.'
   say ' You must run the installation program.'
   say
   call RxPause 'Press any key to exit.'
   'exit 0'
end

/*******************************/
/** Set up PageMaker Env Vars **/
/*******************************/

parse source . . dir
dir = left(dir, lastpos('\', dir)-1)
Env = 'OS2ENVIRONMENT'

call value 'PATH', dir';'value('PATH',,Env), Env
call value 'DPATH', dir';'value('DPATH',,Env), Env
call value 'PMCONFIG', Local.Directory, Env
call value 'PMDICT', Local.Directory, Env
if value('TEMP',,Env)='' then
  call value 'TEMP', Local.Directory, Env

/** Run Aldus PageMaker **/
say
say ' Starting Aldus PageMaker...'
say
say ' Local directory = 'Local.Directory
say
say ' Please wait a moment while PageMaker is loaded.'
say '       ( This may take more than a minute )'
say
say ' Once PageMaker has started this window will be'
say ' hidden...'
'START HIDEWIN /D=20 Aldus PageMaker'
'PMPM'
'exit'
