/******************************************************************
Description:    AutoDesk AutoCAD Run Exec.

Details:        This exec is used to run the ACAD.EXE program.
                It checks that a math coprocessor is in the
                workstation and reads Autocad local directory
                information from OS2.INI.  If either is not
                present the user will be told to run the install.

                It also copies the ACAD.CFG locally if the file
                doesn't already exist.  The environment
                variables ACAD and ACADCFG which are used
                by the ACAD program are also set.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package
                HIDEWIN.EXE - Part of VENDOR package
   Drive(s):    Sample files must be copied locally to use them.
   Directories: All DLL and EXE files in same directory.
   Window Type: FS/WIN
   App Title:   AutoCAD for OS/2 Rel. 10

Last Updated:   9/23/92
******************************************************************/
trace 'O'
'@echo off'

call RxFuncAdd 'RXPAUSE',     'RXUTILS', 'RXPAUSE'
call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'
call RxFuncAdd 'RXDIREXIST',  'RXUTILS', 'RXDIREXIST'
call RxFuncAdd 'RXFILEEXIST', 'RXUTILS', 'RXFILEEXIST'
call RxFuncAdd 'RXDEVCONFIG', 'RXUTILS', 'RXDEVCONFIG'
call RxFuncAdd 'RXSLEEP',     'RXUTILS', 'RXSLEEP'

say
say ' AutoCAD run exec'
say ' ----------------'

/* Parse args */
parse source . . exec
path=left(exec, lastpos('\', exec))
drive=left(path,2)

/**************************************************/
/** Determine if a math coprocessor is installed **/
/**************************************************/

mathco = RxDevConfig('MATHCO')

if mathco = 0 then do
   say
   say d2c(7)
   say ' A Math Coprocessor is not present in this machine.'
   say ' AutoCAD requires a Math Coprocessor to run properly.'
   say
   call RxPause 'Press any key to exit.'
   'exit 0'
end

/************************************************************************/
/** Check if a Local.Directory exists, if not tell user to run install **/
/************************************************************************/

Local.Directory = RxOS2Ini(, 'Directories', 'AUTOCAD')
if rxDirExist(Local.Directory)=0 then do
   say
   say ' Local AutoCAD directory not set.'
   say ' You must run the installation program.'
   say
   call RxPause 'Press any key to exit.'
   'exit 0'
end

/******************************************************/
/** Copy AutoCAD configuration file if doesn't exist **/
/******************************************************/

if rxFileExist( Local.Directory'\ACAD.CFG' )=0 then do
   say 'Copying default ACAD.CFG file to 'Local.Directory
   'COPY ACAD.CFG 'Local.Directory'\ACAD.CFG > NUL'
end

/***************************************/
/** Set AutoCAD Environment Variables **/
/***************************************/

call value 'ACAD',    Local.Directory, 'OS2ENVIRONMENT'
call value 'ACADCFG', Local.Directory, 'OS2ENVIRONMENT'

/*******************/
/** Start AutoCAD **/
/*******************/

say
say ' You will not be able to use the sample drawing files'
say ' listed under the 'drive' drive in the FILE/OPEN menu.'
say ' Trying to do so will result in an error which may'
say ' cause AutoCAD to exit.'
say
say ' If you selected to copy these files to your local'
say ' AutoCAD directory during the AutoCAD installation,'
say ' you can open them from there without any problem.'
say
say ' Local AutoCAD directory = 'Local.Directory
say
call RxSleep 10
say ' Once AutoCAD has started, this window will be hidden.'
say ' This window must be present for AutoCAD to run.....'
say
say
say ' Loading AutoCAD'
say ' This can take up to 30 seconds.  Please Wait...'

'START HIDEWIN /D=20 AutoCAD for OS/2 Rel. 10'
'ACAD'
'exit 0'
