/******************************************************************
Description:    Lotus Installation Exec.

Details:        This exec is used to install 123/G and FLG

                It really only runs the Lotus supplied install
                program, but before doing so gives the user
                some useful info.

Dependencies:
   Externals:   RXUTILS - Part of VENDOR package.
   Drive(s):    None
   Directories: All DLL and EXE files in same directory.
   Window Type: FS/WIN
   App Title:   None

Last Updated:   7/27/92
******************************************************************/

/** Setup vars **/
'@echo off'
Env = 'OS2ENVIRONMENT'

/** Give header **/
call RxCls
say
say ' LOTUS Pre-Installation Info (Please Read):'
say ' ------------------------------------------'
say
say 'The Lotus install program will ask you various questions about your personal'
say 'directories.  If you need help from within the installation program, press F1.'
say ''
say 'Lotus 123/G and FLG are designed to run together.  During the installation'
say 'program, you will be asked if you want to install either one or both.  It is'
say 'recommended that you select both.'
say ''
say 'If you have your own copy of Lotus 123G and/or FLG, then this install process'
say 'will disable their use.  The Lotus install process assumes that these programs'
say 'are stored together (as they are on CORE).  If you do not want to disable your'
say 'local copy of 123G or FLG, then you should abort the install process.'
say ''
say 'Important information about installing Lotus will be displayed when'
call RxPause ' you press any key to continue...'
call RxCls
say ''
say ' IMPORTANT Notes on Lotus Installation Program:'
say ' ______________________________________________'
say ''
say
say ' 1)  Let the installation program modify your CONFIG.SYS'
say ''
say ' 2)  Do not have the installation add the program to you desktop'
say '     group.  The installation program does not know you need to'
say '     use Vendor.  If you want to access Lotus without going '
say '     through the Vendor panels, select the option within Vendor to'
say '     add it to a program group.'
say ''
say ' 3)  Lotus will be ready to run from VENDOR immediately after'
say '     completing the installation program; no reboot is required.'
say ''
say ' The INSTALL program for LOTUS will be executed when press any key'
call RxPause ' to continue...'

/******************************************/
/* Search for a local copy of 123G or FLG */
/******************************************/

CurrDir = Directory()
TempDir = Directory('C:\')
Found = RxSearchPath('LIBPATH','LDCCORE.DLL')
if (Found <> '') then
   if (left(Found,2) <> left(CurrDir,2)) then do
      call RxCls
      say ''
      say 'A local copy of Lotus was found on 'left(Found,2)'!'
      say 'If you continue with the install, this local copy will be disabled!'
      say ''
      call RxSay 'Do you want to abort the install? [Y/N] > '
      do until resp='Y' | resp='N'
         resp = translate(RxGetKey('NOECHO'))
         if resp<>'Y' & resp<>'N' then call RxSay D2C(7)
      end
      if (resp = 'Y')  then
         'exit 100'
   end
CurrDir = Directory(CurrDir)

pdir=GetPersonal() /* Get personal Lotus dir var if  exists  */
'install'
call RxCls
say
say 'Lotus is ready to run.'
say
call RxPause
'exit'

/************************************************************
** GetPersonal()                                           **
**                                                         **
** Returns the Lotus Personal Env Var as specified in      **
** the CONFIG.SYS.  This is needed as the user may change  **
** this and we would rather not force a reboot to activate **
** it.                                                     **
**                                                         **
** Also sets the current LOTUSPERSONAL to that set in the  **
** CONFIG.SYS (JIC).                                       **
************************************************************/
GetPersonal:
 if RxGrep('SET LOTUSPERSONAL=',RxBootDrive()'\CONFIG.SYS','grep')=0 then
   if grep.0>0 then
     pdir=space(substr(grep.1, pos('=', grep.1)+1))
   else
     pdir=''
 call value 'LOTUSPERSONAL', pdir, Env
return pdir

