// setprops.cpp : implementation file
//

#include "stdafx.h"
#include "vctest.h"
#include "setprops.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern "C" LPSTR GetLastErrorString(void);
extern "C" int GetLastErrorCode(void);

extern CVBControl *BarCodeVBX;
/////////////////////////////////////////////////////////////////////////////
// CSetProps dialog

CSetProps::CSetProps(CWnd* pParent /*=NULL*/)
   : CDialog(CSetProps::IDD, pParent)
{
   //{{AFX_DATA_INIT(CSetProps)
   m_Text = "";
   m_BarCodeType = -1;
   m_Ratio = -1;
   m_Width = "";
   m_Checksum = "";
   m_CurrentChecksum = "";
   //}}AFX_DATA_INIT
}

void CSetProps::DoDataExchange(CDataExchange* pDX)
{
   CDialog::DoDataExchange(pDX);
   //{{AFX_DATA_MAP(CSetProps)
   DDX_Control(pDX, IDD_RATIO, m_RatioCTL);
   DDX_Control(pDX, IDD_BARTYPE, m_BarCodeTypeCTL);
   DDX_Text(pDX, IDD_TEXT, m_Text);
   DDX_CBIndex(pDX, IDD_BARTYPE, m_BarCodeType);
   DDX_CBIndex(pDX, IDD_RATIO, m_Ratio);
   DDX_Text(pDX, IDD_WIDTH, m_Width);
   DDX_Text(pDX, IDD_CHECKSUM, m_Checksum);
   DDX_Text(pDX, IDD_CURCHECKSUM, m_CurrentChecksum);
   //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSetProps, CDialog)
   //{{AFX_MSG_MAP(CSetProps)
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSetProps message handlers

BOOL CSetProps::OnInitDialog()
{  
   long value;
   char Buf[5];
   CString Buf2;
   
   CDialog::OnInitDialog();
   
   CenterWindow();
   
   Buf2 = BarCodeVBX->GetStrProperty("Text");   
   m_Text = Buf2;
      
   m_BarCodeType = (int)BarCodeVBX->GetNumProperty("BarCodeType");
   
   m_Ratio = (int)BarCodeVBX->GetNumProperty("Ratio");
   
   value = BarCodeVBX->GetNumProperty("NarrowBarWidth");
   _ltoa(value,Buf,10);
   m_Width = Buf; 
                     
   value = BarCodeVBX->GetNumProperty("Checksum");                     
   _ltoa(value,Buf,10);
   m_Checksum = Buf; 

   Buf2 = BarCodeVBX->GetStrProperty("ChecksumString");   
   m_CurrentChecksum = Buf2; 
  
   UpdateData(FALSE);
   
   return TRUE;
}


void CSetProps::OnOK()
{
   UpdateData();
   
   BarCodeVBX->SetStrProperty("Text",m_Text);   
   BarCodeVBX->SetNumProperty("BarCodeType",(long)m_BarCodeType);
   m_Ratio = (int)BarCodeVBX->SetNumProperty("Ratio",(long)m_Ratio);
   BarCodeVBX->SetNumProperty("NarrowBarWidth",atol(m_Width));
   BarCodeVBX->SetNumProperty("Checksum",atol(m_Checksum));

   if(GetLastErrorCode())
      AfxMessageBox(GetLastErrorString());
      
   CDialog::OnOK();
}
