' From WINAPI.TXT:-
'  Device Parameters for GetDeviceCaps()
Global Const DRIVERVERSION = 0  '  Device driver version
Global Const TECHNOLOGY = 2     '  Device classification
Global Const HORZSIZE = 4       '  Horizontal size in millimeters
Global Const VERTSIZE = 6       '  Vertical size in millimeters
Global Const HORZRES = 8        '  Horizontal width in pixels
Global Const VERTRES = 10       '  Vertical width in pixels
Global Const BITSPIXEL = 12     '  Number of bits per pixel
Global Const PLANES = 14        '  Number of planes
Global Const NUMBRUSHES = 16    '  Number of brushes the device has
Global Const NUMPENS = 18       '  Number of pens the device has
Global Const NUMMARKERS = 20    '  Number of markers the device has
Global Const NUMFONTS = 22      '  Number of fonts the device has
Global Const NUMCOLORS = 24     '  Number of colors the device supports
Global Const PDEVICESIZE = 26   '  Size required for device descriptor
Global Const CURVECAPS = 28     '  Curve capabilities
Global Const LINECAPS = 30      '  Line capabilities
Global Const POLYGONALCAPS = 32 '  Polygonal capabilities
Global Const TEXTCAPS = 34      '  Text capabilities
Global Const CLIPCAPS = 36      '  Clipping capabilities
Global Const RASTERCAPS = 38    '  Bitblt capabilities
Global Const ASPECTX = 40       '  Length of the X leg
Global Const ASPECTY = 42       '  Length of the Y leg
Global Const ASPECTXY = 44      '  Length of the hypotenuse

Global Const LOGPIXELSX = 88    '  Logical pixels/inch in X
Global Const LOGPIXELSY = 90    '  Logical pixels/inch in Y

Global Const SIZEPALETTE = 104  '  Number of entries in physical palette
Global Const NUMRESERVED = 106  '  Number of reserved entries in palette
Global Const COLORRES = 108     '  Actual color resolution


'  Device Capability Masks:

'  Device Technologies
Global Const DT_PLOTTER = 0     '  Vector plotter
Global Const DT_RASDISPLAY = 1  '  Raster display
Global Const DT_RASPRINTER = 2  '  Raster printer
Global Const DT_RASCAMERA = 3   '  Raster camera
Global Const DT_CHARSTREAM = 4  '  Character-stream, PLP
Global Const DT_METAFILE = 5    '  Metafile, VDM
Global Const DT_DISPFILE = 6    '  Display-file

'  Curve Capabilities
Global Const CC_NONE = 0        '  Curves not supported
Global Const CC_CIRCLES = 1     '  Can do circles
Global Const CC_PIE = 2         '  Can do pie wedges
Global Const CC_CHORD = 4       '  Can do chord arcs
Global Const CC_ELLIPSES = 8    '  Can do ellipese
Global Const CC_WIDE = 16       '  Can do wide lines
Global Const CC_STYLED = 32     '  Can do styled lines
Global Const CC_WIDESTYLED = 64 '  Can do wide styled lines
Global Const CC_INTERIORS = 128 '  Can do interiors

'  Line Capabilities
Global Const LC_NONE = 0        '  Lines not supported
Global Const LC_POLYLINE = 2    '  Can do polylines
Global Const LC_MARKER = 4      '  Can do markers
Global Const LC_POLYMARKER = 8  '  Can do polymarkers
Global Const LC_WIDE = 16       '  Can do wide lines
Global Const LC_STYLED = 32     '  Can do styled lines
Global Const LC_WIDESTYLED = 64 '  Can do wide styled lines
Global Const LC_INTERIORS = 128 '  Can do interiors

'  Polygonal Capabilities
Global Const PC_NONE = 0        '  Polygonals not supported
Global Const PC_POLYGON = 1     '  Can do polygons
Global Const PC_RECTANGLE = 2   '  Can do rectangles
Global Const PC_WINDPOLYGON = 4 '  Can do winding polygons
Global Const PC_TRAPEZOID = 4   '  Can do trapezoids
Global Const PC_SCANLINE = 8    '  Can do scanlines
Global Const PC_WIDE = 16       '  Can do wide borders
Global Const PC_STYLED = 32     '  Can do styled borders
Global Const PC_WIDESTYLED = 64 '  Can do wide styled borders
Global Const PC_INTERIORS = 128 '  Can do interiors

'  Polygonal Capabilities
Global Const CP_NONE = 0        '  No clipping of output
Global Const CP_RECTANGLE = 1   '  Output clipped to rects

'  Text Capabilities
Global Const TC_OP_CHARACTER = &H1  '  Can do OutputPrecision   CHARACTER
Global Const TC_OP_STROKE = &H2 '  Can do OutputPrecision   STROKE
Global Const TC_CP_STROKE = &H4 '  Can do ClipPrecision STROKE
Global Const TC_CR_90 = &H8     '  Can do CharRotAbility    90
Global Const TC_CR_ANY = &H10   '  Can do CharRotAbility    ANY
Global Const TC_SF_X_YINDEP = &H20  '  Can do ScaleFreedom  X_YINDEPENDENT
Global Const TC_SA_DOUBLE = &H40    '  Can do ScaleAbility  DOUBLE
Global Const TC_SA_INTEGER = &H80   '  Can do ScaleAbility  INTEGER
Global Const TC_SA_CONTIN = &H100   '  Can do ScaleAbility  CONTINUOUS
Global Const TC_EA_DOUBLE = &H200   '  Can do EmboldenAbility   DOUBLE
Global Const TC_IA_ABLE = &H400 '  Can do ItalisizeAbility  ABLE
Global Const TC_UA_ABLE = &H800 '  Can do UnderlineAbility  ABLE
Global Const TC_SO_ABLE = &H1000    '  Can do StrikeOutAbility  ABLE
Global Const TC_RA_ABLE = &H2000    '  Can do RasterFontAble    ABLE
Global Const TC_VA_ABLE = &H4000    '  Can do VectorFontAble    ABLE
Global Const TC_RESERVED = &H8000

'  Raster Capabilities
Global Const RC_BITBLT = 1      '  Can do standard BLT.
Global Const RC_BANDING = 2     '  Device requires banding support
Global Const RC_SCALING = 4     '  Device requires scaling support
Global Const RC_BITMAP64 = 8    '  Device can support >64K bitmap
Global Const RC_GDI20_OUTPUT = &H10 '  has 2.0 output calls
Global Const RC_DI_BITMAP = &H80    '  supports DIB to memory
Global Const RC_PALETTE = &H100 '  supports a palette
Global Const RC_DIBTODEV = &H200    '  supports DIBitsToDevice
Global Const RC_BIGFONT = &H400 '  supports >64K fonts
Global Const RC_STRETCHBLT = &H800  '  supports StretchBlt
Global Const RC_FLOODFILL = &H1000  '  supports FloodFill
Global Const RC_STRETCHDIB = &H2000 '  supports StretchDIBits

