
'   This is the test case for SortStrings()
'
'   The test output will show up in the immediate
'   panel.

'   The test program generates an array of strings
'   filled with short strings of random characters
'   in the range "A" to "Z", in both upper case and
'   lower case. It then sorts them in ascending and
'   descending order, first respecting the letters'
'   case then ignoring it (sorting lexically).

'   Remember that upper case letters A-Z all appear
'   before the lower case letters, so if you respect
'   the case of the strings, "Z" sorts before "a".


Sub TestSorts ()
'
'   Runs the test case for SortStrings()
'
    Const ARRAYSIZE = 5         'ubound of the test array
    Const LOWINDEX  = 0         'first array index for sort
    Const HIGHINDEX = ARRAYSIZE 'last array index for sort

    Dim firstCode As Integer
    Dim lastCode  As Integer
    Dim thisChar  As String
    ReDim a(ARRAYSIZE) As String

    Randomize Timer         'seed the random number generator

    firstCode = Asc("A")
    lastCode = Asc("Z")

    For i = LOWINDEX To HIGHINDEX
        thisChar = Chr$(TestSortRandomInt(firstCode, lastCode))
        If TestSortRandomInt(0, 1) = 1 Then     'about half the time,
            thisChar = LCase$(thisChar)         '   change case
        End If
        a(i) = String$(8, thisChar)             'make a short string of char
    Next i

    Debug.Print ""
    Debug.Print "Initially:"
    For i = LOWINDEX To HIGHINDEX
        Debug.Print a(i)
    Next i
    Debug.Print ""

    Debug.Print "Ascending sort:"
    Debug.Print ""

    SortStrings a(), LOWINDEX, HIGHINDEX, SORTASCENDING

    Debug.Print "Respecting case:"
    For i = LOWINDEX To HIGHINDEX
        Debug.Print a(i)
    Next i
    Debug.Print ""

    SortStrings a(), LOWINDEX, HIGHINDEX, SORTASCENDING Or SORTIGNORECASE

    Debug.Print "Ignoring case:"
    For i = LOWINDEX To HIGHINDEX
        Debug.Print a(i)
    Next i
    Debug.Print ""

    Debug.Print ""
    Debug.Print "Descending sort:"
    Debug.Print ""

    SortStrings a(), LOWINDEX, HIGHINDEX, SORTDESCENDING

    Debug.Print "Respecting case:"
    For i = LOWINDEX To HIGHINDEX
        Debug.Print a(i)
    Next i
    Debug.Print ""

    SortStrings a(), LOWINDEX, HIGHINDEX, SORTDESCENDING Or SORTIGNORECASE

    Debug.Print "Ignoring case:"
    For i = LOWINDEX To HIGHINDEX
        Debug.Print a(i)
    Next i
    Debug.Print ""

End Sub

Function TestSortRandomInt (ByVal lowerBound As Integer, ByVal upperBound As Integer) As Integer
'
'   Returns a random integer in specified range.
'   The range includes the end points.
'
   TestSortRandomInt = Int((upperBound - lowerBound + 1) * Rnd + lowerBound)

End Function

