
'   STRTOK.BAS

'   Implementation of the C runtime library function StrTok(),
'   a string tokenizer.
'
'   When you call the routine the first time for a string, you
'   pass the text string as the first argument, and in subsequent
'   calls for the other tokens in the string you signal that you
'   want more tokens from the same string by passing a null
'   string as the first argument. When you do this, StrTok
'   continues to work on the copy that it saved the first time
'   you called it.
'
'   For all calls, the second argument is a string consisting
'   of the delimiter characters.  They don't have to be the same
'   for all calls, but there must be at least one delimiter char
'   in the string every time you call.  The basic technique is:
'
'   text$ = "some text string, with embedded delimiters"
'   delims$ = " ,"   'in this case, one blank character
'                    'and a comma
'
'   token$ = StrTok$(text$, delims$)
'   Do While token$ <> ""
'       'do something with the token...
'       token$ = StrTok$("", delims$)
'   Loop
'
'   In this case, each of the words would be returned, one at
'   a time, until the string was exhausted, and StrTok$ would
'   return a null string to show that there was no more.
'
'   StrTok$ is not reentrant; so you can't nest StrTok loops
'   inside one another; when you pass a non=null string as the
'   first argument, the function forgets about any previous
'   string.  Likewise, if in the first call the string you pass
'   happens to be a null string, the behavior is unpredictable,
'   and depends on whatever use you had previously made of the
'   function. If there was an unfinished string in its static
'   storage, you'd probably get something off that string.
'
'   Also, this routine will do you no good if you have nested
'   delimiters, such as ((a + b) * c); you need a better parser
'   with some look-ahead capability to parse strings like this.
'   But for simple cases, it works just fine.
'
    
    DefInt A-Z

Function StrTok$ (Srce$, Delim$)
'
'   Visual Basic implementation of the C function Strtok().
'
'   Input:
'       Srce$  - text string to be parsed (first time)
'                a null string (subsequent calls)
'       Delim$ - string of delimiter characters
'
'   Function return:    next token, or null string if no more
'
'   Restrictions:       not reentrant
'

    Static Start%, SaveStr$

    ' If first call, make a copy of the string.

    If Srce$ <> "" Then
        Start% = 1
        SaveStr$ = Srce$
    End If

    BegPos% = Start%
    Ln% = Len(SaveStr$)

    ' Look for start of a token (character that isn't delimiter).

    Do While (BegPos% <= Ln%) And (InStr(Delim$, Mid$(SaveStr$, BegPos%, 1)) <> 0)
        BegPos% = BegPos% + 1
    Loop

    ' Test for token start found.

    If BegPos% > Ln% Then

        StrTok$ = ""                     'no more string to search

    Else

        ' Find the end of the token.

        EndPos% = BegPos%
        While EndPos% <= Ln% And InStr(Delim$, Mid$(SaveStr$, EndPos%, 1)) = 0
            EndPos% = EndPos% + 1
        Wend

        StrTok$ = Mid$(SaveStr$, BegPos%, EndPos% - BegPos%)

        ' Set starting point for search for next token.

        Start% = EndPos%

    End If

End Function

