/*
 *  egscrpt2.c
 *
 *  Example CGI Script file for use with HTTPS.  Assumes it is invoked from a form.
 *  This one writes the information to a file defined by PATH_INFO.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <io.h>

#define TRUE 1
#define FALSE 0

char InputBuffer[4096];

/*
 *  Convert all cOld characters in cStr into cNew characters
 */
void strcvrt(char * cStr,char cOld,char cNew) {
int i;

    i = 0;
    while (cStr[i]) {
        if (cStr[i]==cOld) cStr[i] = cNew;
        i++;
    }
}

/*
 *  The string starts with two hex characters.  Return an integer formed from them.
 */
static int TwoHex2Int(char *pC) {
int Hi;
int Lo;
int Result;

    Hi = pC[0];
    if ('0'<=Hi && Hi<='9') {
        Hi -= '0';
    } else
    if ('a'<=Hi && Hi<='f') {
        Hi -= ('a'-10);
    } else
    if ('A'<=Hi && Hi<='F') {
        Hi -= ('A'-10);
    }
    Lo = pC[1];
    if ('0'<=Lo && Lo<='9') {
        Lo -= '0';
    } else
    if ('a'<=Lo && Lo<='f') {
        Lo -= ('a'-10);
    } else
    if ('A'<=Lo && Lo<='F') {
        Lo -= ('A'-10);
    }
    Result = Lo + 16*Hi;
    return Result;
}


/*
 *  Save all the CGI environment variables
 */
void StoreEnvVars(FILE *f) {
int i;

    i = 0;
    while (_environ[i]) {
        fprintf(f,"%s\r\n",_environ[i]);
        i++;
    }
}


/*
 *  Decode the given string in-place by expanding %XX escapes
 */
void urlDecode(char *p) {
char *pD;

    pD = p;
    while (*p) {
        if (*p=='%') {
            /* Escape: next 2 chars are hex representation of the actual character */
            p++;
            if (isxdigit(p[0]) && isxdigit(p[1])) {
                *pD++ = (char) TwoHex2Int(p);
                p += 2;
            }
        } else {
            *pD++ = *p++;
        }
    }
    *pD = '\0';
}


/*
 *  Return TRUE if the file is within or below the current directory.
 *  It must have a .HFO extension.
 */
static int FileNameIsSafe(char *FileName) {
char *p;

    p = FileName;
    while (*p==' '||*p=='\t') p++;
    if (*p=='\\') return FALSE;
    if (strstr(p,"..")!=NULL) return FALSE;
    if (strchr(p,':')!=NULL) return FALSE;
    if (strlen(FileName)<5) return FALSE;
    if (_stricmp(".HFO",FileName+strlen(FileName)-4)!=0) return FALSE;
    return TRUE;
}


/*
 *  Parse out and store field=value items.  Don't use strtok!
 */
void StoreField(FILE *f,char *Item) {
char *p;

    p = strchr(Item,'=');
    *p++='\0';
    urlDecode(Item);
    urlDecode(p);
    strcvrt(p,'\n',' ');
    strcvrt(p,'\r',' ');
    fprintf(f,"%s = %s\n",Item,p);
}


/*
 *  Main program
 */
int main(int argc, char *argv[]) {
int ContentLength;
int x;
int i;
char *p;
char *q;
char *FileName;
char *pRequestMethod;
FILE *f;

    /* Turn buffering off for stdin */
    setvbuf(stdin,NULL,_IONBF,0);

    /* Tell the client what we're going to send */
    printf("Content-type: text/html\n\n");

    /* Get the PATH_INFO */
    FileName = getenv("PATH_INFO");
    if (FileName==NULL) {
        /* Does not exist */
        printf("<HEAD><TITLE>Error - no filename</TITLE></HEAD>\n");
        printf("<BODY><H1>Error - no filename</H1>\n");
        printf("There is no PATH_INFO supplied.  Please modify the action parameter in your form.\n");
        printf("</BODY>\n");
        exit(0);
    }

    /* Convert PATH_INFO to a filename */
    q = FileName;
    while (*q) {
        if (*q=='/') *q = '\\';
        q++;
    }
    if (*FileName=='\\') FileName++;
    urlDecode(FileName);

    /* Is it safe to use? */
    if (!FileNameIsSafe(FileName)) {
        printf("<HEAD><TITLE>Error - Filename unacceptable</TITLE></HEAD>\n");
        printf("<BODY><H1>Error - Filename unacceptable</H1>\n");
        printf("The file %s is not acceptable.\n",FileName);
        printf("</BODY>\n");
        exit(0);
    }

    /* Does the file exist? */
    if (_access(FileName,2)<0) {
        /* Does not exist or cannot access for write */
        printf("<HEAD><TITLE>Error - cannot access file</TITLE></HEAD>\n");
        printf("<BODY><H1>Error - cannot access file</H1>\n");
        printf("The file %s could not be accessed.\n",FileName);
        printf("</BODY>\n");
        exit(0);
    }
    
    /* Open the file */
    f = fopen(FileName,"a");
    if (f==NULL) {
        /* Can't open */
        printf("<HEAD><TITLE>Error - cannot open file</TITLE></HEAD>\n");
        printf("<BODY><H1>Error - cannot open file</H1>\n");
        printf("The file %s could not be opened.\n",FileName);
        printf("</BODY>\n");
        exit(0);
    }

    /* Indicate start of next entry in the file */
    fprintf(f,"======\n");
    
    /* Store the environment variables */
    StoreEnvVars(f);

    /* Separate out the form fields */
    fprintf(f,"------\n");

    /* What method were we invoked through? */
    pRequestMethod = getenv("REQUEST_METHOD");
    if (pRequestMethod==NULL) {
        return 0;
    }

    /* Get the data from the client according to the requested method */
    if (_stricmp(pRequestMethod,"POST")==0) {
        /* Read in the data from the client */
        p = getenv("CONTENT_LENGTH");
        if (p!=NULL) {
            ContentLength = atoi(p);
        } else {
            ContentLength = 0;
        }
        if (ContentLength>sizeof(InputBuffer)-1) {
            ContentLength = sizeof(InputBuffer)-1;
        }
        i = 0;
        while (i<ContentLength) {
            x = fgetc(stdin);
            if (x==EOF) break;
            InputBuffer[i++] = x;
        }
        InputBuffer[i] = '\0';
        ContentLength = i;

        p = getenv("CONTENT_TYPE");
        if (p==NULL) {
            return 0;
        }
        if (_stricmp(p,"application/x-www-form-urlencoded")==0) {
            /* Parse the data */
            p = strtok(InputBuffer,"&");
            while (p!=NULL) {
                StoreField(f,p);
                p = strtok(NULL,"&");
            }
        } else {
            /* Display the data */
            fprintf(f,"Input = %s\n",InputBuffer);
        }

    } else 
    if (_stricmp(pRequestMethod,"GET")==0) {

        /* Parse the data in the search term */
        p = getenv("QUERY_STRING");
        if (p!=NULL) {
            strncpy(InputBuffer,p,sizeof(InputBuffer));
            p = strtok(InputBuffer,"&");
            while (p!=NULL) {
                StoreField(f,p);
                p = strtok(NULL,"&");
            }
        }

    }

    /* Confirm to client */
    if (!ferror(f)) {
        printf("<HEAD><TITLE>Submitted OK</TITLE></HEAD>\n");
        printf("<BODY>The information you supplied has been accepted.</BODY>\n");
    } else {
        printf("<HEAD><TITLE>Server file I/O error</TITLE></HEAD>\n");
        printf("<BODY>The information you supplied could not be\n");
        printf("accepted due to a file I/O error at the server.</BODY>\n");
    }

    /* Close the file */
    fclose(f);

    return 0;
}

