cls
@if "%1"=="" goto need_directory 
@if exist %1\aspi2dos.sys goto HAVESCSIDIR
@if exist %1\aspi4dos.sys goto HAVESCSIDIR
@if exist %1\aspi7dos.sys goto HAVESCSIDIR
@if exist %1\aspi8dos.sys goto HAVESCSIDIR
@if exist %1\aspiedos.sys goto HAVESCSIDIR
@if exist %1\aspicd.sys   goto HAVESCSIDIR
@if not exist %1\nul      goto NOSCSIDIR

:havescsidir
@if "%2"=="" goto NOWINDIR
@if not exist %2\win.ini goto NOWINDIR

:start
cls
@echo *********************************************************************
@echo *                                                                   *
@echo *                 EZ-SCSI 3.13 - Upgrade Program                    *
@echo *                 ------------------------------                    *
@echo *                                                                   *
@echo *      Welcome to the EZ-SCSI 3.13 Upgrade Program.  This program   *
@echo *      will upgrade any previous ( non-OEM ) version of Adaptec     *
@echo *      EZ-SCSI.                                                     *
@echo *                                                                   *
@echo *      In order for this upgrade program to run successfully you    *
@echo *      need to have a previous version of EZ-SCSI already           *
@echo *      installed on your system.                                    *
@echo *                                                                   *
@echo *      This program will create the directory \OLDSYS where         *
@echo *      the older version of your software will be stored.           * 
@echo *      Consult the READMEUP.TXT file for further information        *
@echo *      on this upgrade program.                                     *
@echo *                                                                   *
@echo *********************************************************************
@pause
@rem
@rem ----------------------------------------------------------------------
@rem Note: %1 = user's path for where ezscsi is installed on their drive.
@rem       We redirect the output of the upgrade procedure to the file
@rem       UPINFO.TXT.  
@rem       Currently this file contains nothing more than the header for
@rem       the RTPatch program,  but we can allow it to contain all of the
@rem       information regarding the upgrade procedure by rebuilding the
@rem       patch with NOMESSAGE and QUITE eliminated from the configuration
@rem       set.
@rem Note: %2 = user's WINDOWS directory location. For example, the user will
@rem       type in " C:>UPGRADE C:\SCSI C:\WINDOWS " to upgrade the old
@rem       EZSCSI files in the C:\SCSI directory.  The extra parameter
@rem       C:\WINDOWS indicates to this upgrade program where to look in
@rem       order to copy the new VASPID.386 and WINASPI.DLL files.
@rem 
@rem -----------------------------------------------------------------------
@echo Performing upgrade...please wait
@echo (This process can take up to 5 minutes depending on your system.)
@echo ...working...
@rem
@rem
@rem -----------------------------------------------------------------------
@rem   PATCH.EXE and PATCH.RTP, the two files necessary to carry out the
@rem   patch program are renamed to reduce confusion for customer to *.inc.
@rem   Here is where we rename them back to their executable extensions to
@rem   allow the patch to operate.  We rename them back to *.inc at the end
@rem   of this program.
@rem -----------------------------------------------------------------------
@rename patch1.inc patch.exe
@rename patch2.inc patch.rtp
@copy   patch3.inc %1\readme.txt > UPINFO.TXT
@patch %1 > UPINFO.TXT
@if ERRORLEVEL 1 goto failed_upgrade

@rem -----------------------------------------------------------------------
@rem If the user did not enter a windows path, or if they entered the
@rem wrong path,  DO NOT copy the ASPI for Windows files.  Instead, simply
@rem continue on with the upgrade program and copy the README files to
@rem the destination directory and exit.
@rem 
@rem If the use has correctly input the WINDOWS directory, we will copy
@rem the ASPI for Windows files into the WINDOWS\SYSTEM directory and delete
@rem them from the C:\SCSI directory.  We delete them from the C:\SCSI
@rem directory because users running WIN 95 will run into errors if the
@rem 16-Bit EZ-SCSI applications attempt to load WINASPI.DLL instead of the
@rem 32-Bit DLL, WNASPI32.DLL, which is resident in the WIN 95 SYSTEM area.
@rem 
@rem -----------------------------------------------------------------------
@if "%2"=="" goto DEL_WIN1
@if not exist %2\win.ini goto DEL_WIN

@goto vaspid

:DEL_WIN1
@goto DEL_WIN

:vaspid
@copy %1\vaspid.386  %2\SYSTEM  > UPINFO.TXT
@if ERRORLEVEL 1 goto fail_vaspid

:fastscsi
@REM This next line will copy the user's old version of FASTSCSI.386 to
@REM    the filename: FASTSCSI.OLD
@rename %2\SYSTEM\fastscsi.386 fastscsi.old > UPINFO.TXT
@copy %1\fastscsi.386 %2\SYSTEM > UPINFO.TXT
@if ERRORLEVEL 1 goto fail_fastscsi
@copy %1\aha1540.386 %2\SYSTEM > UPINFO.TXT
@if ERRORLEVEL 1 goto fail_fastscsi
@copy %1\aha1740.386 %2\SYSTEM > UPINFO.TXT
@if ERRORLEVEL 1 goto fail_fastscsi
@copy %1\aic7770.386 %2\SYSTEM > UPINFO.TXT
@if ERRORLEVEL 1 goto fail_fastscsi
@copy %1\aic7870.386 %2\SYSTEM > UPINFO.TXT
@if ERRORLEVEL 1 goto fail_fastscsi

:winaspi
@copy %1\winaspi.dll %2\SYSTEM  > UPINFO.TXT
@if ERRORLEVEL 1 goto fail_winaspi

:DEL_WIN
@del %1\vaspid.386   > UPINFO.TXT
@del %1\winaspi.dll  > UPINFO.TXT
@del %1\fastscsi.386 > UPINFO.TXT
@del %1\aha1540.386 > UPINFO.TXT
@del %1\aha1740.386 > UPINFO.TXT
@del %1\aic7770.386 > UPINFO.TXT
@del %1\aic7870.386 > UPINFO.TXT
@goto README

:NOSCSIDIR
cls
@echo **********************************************************************
@echo **                          ATTENTION!                              **
@echo **********************************************************************
@echo The path entered as the location of your old ASPI Managers: 
@echo. 
@echo                   Path specified:  %1
@echo. 
@echo does not exist on the drive specified.  Please double check the true 
@echo location of your ASPI Managers and run this upgrade program again.
@echo. 
@echo For further information regarding the details of this upgrade program
@echo please read the file "READMEUP.TXT" which was unzipped along with 
@echo this upgrade program.
@echo. 
@echo The UPGRADE procedure has now been terminated.  Please restart with
@echo the proper directory locations.
@echo **********************************************************************
@goto failed

:NOWINDIR
cls
@echo **********************************************************************
@echo **                          ATTENTION!                              **
@echo **********************************************************************
@echo Either you did not specify a WINDOWS directory when you started this 
@echo upgrade program or the path entered for the location of WINDOWS on
@echo your system is not correct. Without specifying the proper WINDOWS 
@echo directory this program will not upgrade your ASPI for WINDOWS drivers
@echo or copy the 32-Bit Disk Access driver and utility to your 
@echo WINDOWS\SYSTEM directory.
@echo. 
@echo. 
@echo The upgrade program will now continue to upgrade the files listed in 
@echo the READMEUP.TXT file with the exception of the ASPI for Windows 
@echo drivers and the new 32-Bit Disk Access application and drivers.  If you  
@echo wish to have this program upgrade your ASPI for Windows and copy the
@echo 32-Bit Disk Access files to your hard drive, please run this program 
@echo again with the proper paths.
@echo. 
@echo Please refer to the readme file "READMEUP.TXT" for further information
@echo on running this program.
@echo. 
@echo **********************************************************************
@pause          
@goto start

:README
@rem -----------------------------------------------------------------------
@rem Here we copy the upgrade readme file to the user's EZ-SCSI directory.
@rem -----------------------------------------------------------------------
@del UPINFO.TXT
@echo Copying READMEUP.TXT to %1 ...
@copy *.txt %1 
@if ERRORLEVEL 1 goto failed_readme_copy
@goto end

:need_directory
@echo *******************************************************************
@echo *                                                                 *
@echo *     You need to type the directory of your current EZ-SCSI      *
@echo *     installation after UPGRADE as follows:                      *
@echo *                                                                 *
@echo *                 UPGRADE C:\SCSI                                 *
@echo *                                                                 *
@echo *                                                                 *
@echo *     If you run Windows and would like to upgrade your ASPI for  *
@echo *     Windows drivers automatically, you will need to type the    *
@echo *     following (indicating the proper location of your WINDOWS   *
@echo *     directory):                                                 *
@echo *                                                                 *
@echo *                 UPGRADE C:\SCSI C:\WINDOWS                      *
@echo *                                                                 *
@echo *     where "C:\WINDOWS" is the location of your Windows. For     *
@echo *     further information on the upgrade procedure please refer   *
@echo *     to the READMEUP.TXT file included with the upgrade program. *
@echo *                                                                 *
@echo *******************************************************************
@pause
@goto failed



:fail_vaspid
@echo.
@echo **************************** ERROR ***********************************
@echo Unable to move VASPID.386 into your WINDOWS\SYSTEM directory. Probably
@echo because the directory specified for your WINDOWS directory is 
@echo incorrect. Refer to READMEUP.TXT for additional information on the
@echo upgrade procedure.
@echo **********************************************************************
@pause
@goto fastscsi

:fail_winaspi
@echo.
@echo **************************** ERROR ************************************
@echo Unable to move WINASPI.DLL into your WINDOWS\SYSTEM directory. Probably
@echo because the directory specified for your WINDOWS directory is
@echo incorrect.  Refer to READMEUP.TXT for additional information on the
@echo upgrade procedure.
@echo ***********************************************************************
@pause
@goto DEL_WIN

:fail_fastscsi
@echo.
@echo **************************** ERROR ************************************
@echo Unable to move FASTSCSI.386 into your WINDOWS\SYSTEM directory. This
@echo error is probably caused by an incorrect path for your WINDOWS\SYSTEM
@echo directory. Refer to the READMEUP.TXT file for additional information
@echo on this upgrade procedure.
@echo ***********************************************************************
goto winaspi

:failed_upgrade
cls
@echo Upgrade failed!
@rem --------------------------------------------------------------------
@rem Renaming patch files back to non-executable extensions
@rem --------------------------------------------------------------------
@rename patch.exe patch1.inc
@rename patch.rtp patch2.inc
@goto need_directory

:end
:failed_readme_copy
@rem --------------------------------------------------------------------
@rem Renaming patch files back to non-executable extensions
@rem --------------------------------------------------------------------
@rename patch.exe patch1.inc
@rename patch.rtp patch2.inc
@echo *******************************************************************
@echo **                   Upgrade was successful!                     **
@echo *******************************************************************
@goto failed


:failed
