#define STRICT

#include <windows.h>
#include <stdio.h>
#include <mmsystem.h>
#include <time.h>
#include <stdlib.h>
#include <dir.h>
#include <dos.h>
#include <string.h>

#define TRUE                           1
#define FALSE                          0
#define NONE                           0
#define IN                             1
#define OUT                            2

#define IDS_NAME                       1

#define IDBT_CLEAR                     10
#define IDBT_SNDPLAY                   20
#define IDBT_MCICMD                    30
#define IDBT_MCISTR                    40
#define IDBT_TEXT                      50
#define IDBT_STAMP                     60
#define IDBT_MISC                      70
#define IDBT_UNDO                      80

// COLORS
#define RED         RGB(255,0,0)
#define RED1        RGB(192,0,0)
#define RED2        RGB(255,95,95) 
#define DKRED       RGB(128,0,0)     // 4
#define BLUE        RGB(0,0,255)
#define BLUE1       RGB(0,0,192)  
#define DKBLUE      RGB(0,0,128)     // 7
#define GREEN       RGB(0,255,0)
#define GREEN1      RGB(0,192,0)
#define DKGREEN     RGB(0,128,0)     // 10
#define CYAN        RGB(0,255,255)
#define CYAN1       RGB(0,192,192)
#define DKCYAN      RGB(0,128,128)   // 13
#define MAGENTA     RGB(255,0,255)
#define MAGENTA1    RGB(192,0,192)
#define DKMAGENTA   RGB(128,0,128)   // 16
#define YELLOW      RGB(255,255,0)
#define YELLOW1     RGB(192,192,0)
#define DKYELLOW    RGB(128,128,0)   // 19
#define WHITE       RGB(255,255,255)
#define GRAY        RGB(192,192,192)
#define DKGRAY      RGB(128,128,128)  
#define BLACK       RGB(0,0,0)       // 23
#define BROWN       RGB(138,90,48)
#define BROWN1      RGB(170,106,64)
#define DKBROWN     RGB(202,127,79)   // 26
#define TURQUOISE   RGB(43,199,139)
#define TURQUOISE1  RGB(43,199,183)
#define DKTURQUOISE RGB(43,171,199)   // 29
#define ORANGE      RGB(255,207,176)
#define ORANGE1     RGB(255,186,144)
#define DKORANGE    RGB(255,165,112)   // 32
#define ORANGE2     RGB(255,127,0)

// TOOLS
#define PENCIL           1
#define SPRAYCAN         2
#define BUCKET           3
#define RECTANGLE        4
#define CIRCLE           5
#define LINE             6
#define MULTIPOLY        7
#define SCISSORS         8
#define FILLEDRECTANGLE  9
#define FILLEDCIRCLE    10
#define TRIANGLE        11
#define FILLEDTRIANGLE  12
#define QUILLPEN        13
#define CHARCOALPENCIL  14
#define GOOFYLINE       15
#define SMALLERASER     16
#define LARGEERASER     17
#define ZIGZAG          18
#define COLORDOT        19
#define CHALK           20
#define LINEA           21
#define LINEB           22
#define LINEC           23
#define LINED           24
#define PROPELLER       25
#define KNIFE           26
#define FLIPV           27
#define FLIPH           28
#define MOVE            29
#define ICONDRAW        30
#define COLORBOOK1      31
#define COLORBOOK2      32


// data initialized by first instance
typedef struct tagSETUPDATA
	{
		char   szAppName[20]; // name of application
	} SETUPDATA;

SETUPDATA SetUpData;

// Data that can be referenced throughout the
// program but not passed to other instances

HANDLE    hInst;                              // hInstance of application
HWND      hWndMain;                           // hWnd of main window
HWND      phwnd;                              // hWnd of picture window
char      szAppName[10];                      // name of application


// General globals
COLORREF  aColor[34];                         // color array
POINT     polypoint[5000];                    // polygon array
COLORREF  CurrentColor;
HICON     TheIcon;
HBITMAP   kabitmap;
HDC       newhdc;                  
HPEN      hOurPen;                       // how we're drawing now.
HPALETTE  hwndpal;                       // our palette
HWND      hwnd8;                         // undo button


     // PAINTING VARS
int       oldx, oldy,                         // Position of Cursor at MOUSEDOWN
	  xwas, ywas,                         // a Saved X/Y position
	  buttondown,                         // if we're drawing
	  DrawTool,                           // what tool to use
	  DrawWidth,                          // how big to make the line
	  ToolSet,                            // what tools are shown on screen
	  CurrentBoxPos,                      // outline current tool for user
	  LineSet,                            // BOOL to show if lines are on
	  polycount;                          // count of polygon points

     // TEXT VARS
int	  ReadyToDoText,
	  DoingText,
	  TextX,
	  TextY;
HDC       savebitmapDC;
HBITMAP   hsavebitmap;
char      globaltextbuf[255];
LOGFONT   MainFontRec;                        // our font record
HFONT     hfont;                              // our font handle

    // DIRECTORY and FILE CONTROL VARS
int       numfiles,                           // how many paintings in our directory.
	  firstfileshown,                     // what we are showing to the user
	  lastfileshown,                      // since we can show 5 at a time
          Thumbnails;                         // flag if we're in Thumbnail mode
char      ourdir[100];                        // our directory
char      outdir[100];                        // output directory (for Ari Schindler Oct. 94)
char      filearray[80][15];                  // list of paintings as file names
char      commandline[255];                   // commandline

   // APPEARANCE and BEHAVIOUR CONTROL VARS
int       hres,
	  vres,
	  colorbook,
          kabitmapID;
char      colorbmpname[15][15];

  // ADDED FOR K.A. 8/8/94 -- 11/7/94
HDC       undodc;
HBITMAP   undobmp;
int       trashit, firstpaint, colorset,
	  firsttime, indrive, outdrive,
	  stupidpointer, stampsmear, aflag;

FILE         *fp;
char         far stampwav[8][2500];
char         far spraywav[2500];
long         savelevel;
 

// function prototypes

int      PASCAL        WinMain(HINSTANCE,HINSTANCE,LPSTR,int);
void                   InitPaint(HINSTANCE,HINSTANCE,LPSTR,int);
void                   InitPaintFirst(HINSTANCE);
void                   InitPaintAdded(HINSTANCE);
void                   InitPaintEvery(HINSTANCE,int);
LRESULT CALLBACK       PaintWndProc(HWND,UINT,WPARAM,LPARAM);
LRESULT CALLBACK       PWinProc(HWND,UINT,WPARAM,LPARAM);
void                   DoPaint(void);                 // main win WM_PAINT routine
void                   Line(HDC, int, int, int, int); // graphics primitive
void                   Box(HDC, int, int, int, int);  // graphics primitive
void                   BoxAroundTool(int);            // draws red box around current tool
void                   DrawLineSet(void);             // draws line sizes display
void                   DrawNoSet(void);               // invalidates line sizes display
                                                      //     and any mouse hit testing
void                   NextToolSet(void);             // determine which tool set to use
void                   PreviousToolSet(void);         //             DITTO
void                   DrawTools1(void);              // drawing tools
void                   DrawTools2(void);              // drawing tools
void                   DrawTools3(void);              // drawing tools
void                   DrawTools4(void);              // screen erasers
void                   DrawTools5(void);              // effects
void                   DrawTools6(void);              // computer ops
void                   ExecuteErase(int);             // used to perform an erasure
void                   ExecuteDisk(int);              // do a disk activity
void                   BlankIconArea(int);            // blank top and draw arrow as needed 
void                   InvertPic(void);               // color inversion
void                   StretchPic(void);              // magnify +
void                   ShrinkPic(void);               // magnify -
void                   FindOurDirectory(void);        // where the faquarwe?
void                   TheFileList(void);             // gets the list of painting files
void                   DiskToPicSelected(void);       // user wants to select files
void                   DisplayPics(void);             // show up to 5 pictures at top
void                   MorePicsSelected(void);        // we have > 5 pics to show and the
                                                      //     user wants to see them
void                   UserPickedMe(int);             // show the picture that got picked
						      // in the main picture window
void                   PicToDiskSelected(void);       // SAVE picture
void                   initpic(void);
void                   ShowText(unsigned char);
void                   cleanuptext(void);

void                   ParseCommandLine(void);
void                   ColorBookPics(int);
void                   ColorBookPicked(int);
void                   DrawIcons(int);
void                   TransmogrifyColor(void);
void                   SaveToUndoPic(void);
void                   PrintIt(void);
void                   ColorTool(int);
void                   HorizDitherPattern(void);
void                   HorizDitherPattern2(void);
void                   ColorAssign(void);
void                   PlaySound(int);
int                    DiskOK(void);
void                   chthedir(int);
void                   DrawLine(int, int, int, int, int, COLORREF);


int PASCAL WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpszCmdLine,int cmdShow)
{
    MSG   msg;


    strcpy(commandline,lpszCmdLine);
    ParseCommandLine();
    InitPaint(hInstance, hPrevInstance, lpszCmdLine, cmdShow);  

    while (GetMessage(&msg, NULL, 0, 0)){
           TranslateMessage(&msg);
	   DispatchMessage(&msg);
    }

    return(msg.wParam);
}

// get the names of the bitmaps!
void ParseCommandLine(void)
{
     int     i, j, placehold, thelen;
     char    c, kabitmapname[15];


     // reset the colorbook bitmap name char arrays
     for(i = 0; i < 15; i++)
	 memset(colorbmpname[i],'\0',15);

     thelen = lstrlen(commandline);
     if(lstrlen(commandline) < 5){
	strncpy(kabitmapname,commandline,thelen);
	colorbook = FALSE;
        }
     else{
	colorbook = TRUE;
	for(i = 0; i <= thelen; i++){
	    c = commandline[i];
	    if(c == ' ') break;
	    kabitmapname[i] = c;
	}
	placehold = ++i;

	for(i = placehold, j = 0; i <= thelen; i++, j++){
	    c = commandline[i];
	    if(c == ' ') break;
	    colorbmpname[0][j] = c;
	}
	placehold = ++i;

	for(i = placehold, j = 0; i <= thelen; i++, j++){
	    c = commandline[i];
	    if(c == ' ') break;
	    colorbmpname[1][j] = c;
	}
	placehold = ++i;

	for(i = placehold, j = 0; i <= thelen; i++, j++){
	    c = commandline[i];
	    if(c == ' ') break;
	    colorbmpname[2][j] = c;
	}
	placehold = ++i;

	for(i = placehold, j = 0; i <= thelen; i++, j++){
	    c = commandline[i];
	    if(c == ' ') break;
	    colorbmpname[3][j] = c;
	}
	placehold = ++i;

	for(i = placehold, j = 0; i <= thelen; i++, j++){
	    c = commandline[i];
	    if(c == ' ') break;
	    colorbmpname[4][j] = c;
	}
	placehold = ++i;

        // more than 5 colorbook pictures

	for(i = placehold, j = 0; i <= thelen; i++, j++){
	    c = commandline[i];
	    if(c == ' ') break;
	    colorbmpname[5][j] = c;
	}
	placehold = ++i;

	for(i = placehold, j = 0; i <= thelen; i++, j++){
	    c = commandline[i];
	    if(c == ' ') break;
	    colorbmpname[6][j] = c;
	}
	placehold = ++i;

	for(i = placehold, j = 0; i <= thelen; i++, j++){
	    c = commandline[i];
	    if(c == ' ') break;
	    colorbmpname[7][j] = c;
	}
	placehold = ++i;

	for(i = placehold, j = 0; i <= thelen; i++, j++){
	    c = commandline[i];
	    if(c == ' ') break;
	    colorbmpname[8][j] = c;
	}
	placehold = ++i;

	for(i = placehold, j = 0; i <= thelen; i++, j++){
	    c = commandline[i];
	    if(c == ' ') break;
	    colorbmpname[9][j] = c;
	}
	placehold = ++i;

	for(i = placehold, j = 0; i <= thelen; i++, j++){
	    c = commandline[i];
	    if(c == ' ') break;
	    colorbmpname[10][j] = c;
	}
	placehold = ++i;

	for(i = placehold, j = 0; i <= thelen; i++, j++){
	    c = commandline[i];
	    if(c == ' ') break;
	    colorbmpname[11][j] = c;
	}
	placehold = ++i;

	for(i = placehold, j = 0; i <= thelen; i++, j++){
	    c = commandline[i];
	    if(c == ' ') break;
	    colorbmpname[12][j] = c;
	}
	placehold = ++i;

	for(i = placehold, j = 0; i <= thelen; i++, j++){
	    c = commandline[i];
	    if(c == ' ') break;
	    colorbmpname[13][j] = c;
	}
	placehold = ++i;

	for(i = placehold, j = 0; i <= thelen; i++, j++){
	    c = commandline[i];
	    if(c == ' ') break;
	    colorbmpname[14][j] = c;
	}
	placehold = ++i;

     } // else
     kabitmapID = 1;       // default
     c = kabitmapname[0];
     if(c == '1') kabitmapID = 1;
     if(c == '2') kabitmapID = 2;
     if(c == '3') kabitmapID = 3;
     if(c == '4') kabitmapID = 4;
     if(c == '5') kabitmapID = 5;
     if(c == '6') kabitmapID = 6;
     if(c == '7') kabitmapID = 7;
     if(c == '8') kabitmapID = 8;
     if(c == '9') kabitmapID = 9;
     if(c == 'A') kabitmapID = 10;
     firsttime = TRUE;
     aflag = FALSE;
}

#pragma argsused
void InitPaint(HINSTANCE hInstance,HINSTANCE hPrevInstance, LPSTR lpszCmdLine,int cmdShow)
{
    if (!hPrevInstance)                  // if no previous instance, this is first
        InitPaintFirst(hInstance);
    else
        InitPaintAdded(hPrevInstance);   // this is not first instance

    InitPaintEvery(hInstance, cmdShow);  // initialization for all instances
}

void InitPaintFirst(HINSTANCE hInstance)
{
     WNDCLASS wcPaintClass;

     LoadString(hInstance, IDS_NAME, (LPSTR) SetUpData.szAppName, 10);

     wcPaintClass.lpszClassName = SetUpData.szAppName;
     wcPaintClass.hInstance     = hInstance;
     wcPaintClass.lpfnWndProc   = PaintWndProc;
     wcPaintClass.hCursor       = LoadCursor(NULL, IDC_ARROW);
     wcPaintClass.hIcon         = NULL;
     wcPaintClass.lpszMenuName  = NULL;
     wcPaintClass.hbrBackground = GetStockObject(LTGRAY_BRUSH);
     wcPaintClass.style         = CS_HREDRAW | CS_VREDRAW;
     wcPaintClass.cbClsExtra    = 0;
     wcPaintClass.cbWndExtra    = 0;

     RegisterClass(&wcPaintClass);    
}

//*******************************************************************
//                 done only for added instances
//*******************************************************************
void InitPaintAdded(
HINSTANCE hPrevInstance)
{
    GetInstanceData(hPrevInstance, (BYTE*)&SetUpData, sizeof(SETUPDATA));
}

//*******************************************************************
//                    done for every instance
//*******************************************************************
void InitPaintEvery(HINSTANCE hInstance,int cmdShow)
{
     
     HWND    thescreen;
     HDC     hdc;
     RECT    arect;
     

     hInst = hInstance;
     // Create applications main window.
     thescreen = GetDesktopWindow();
     hdc = GetDC(thescreen);
     hres = GetDeviceCaps(hdc,HORZRES);
     vres = GetDeviceCaps(hdc,VERTRES);
     ReleaseDC(thescreen, hdc);
     arect.top = 0;
     arect.left = 0;
     arect.right = hres;
     arect.bottom = vres;
     AdjustWindowRect(&arect,WS_BORDER|WS_POPUP,FALSE);

     hWndMain = CreateWindow(
		             SetUpData.szAppName,     // window class name
			     SetUpData.szAppName,     // window title
			     WS_BORDER|WS_POPUP,   // type of window
			     0,         // x  window location
			     0,         // y
			     arect.right,           // cx and size
			     arect.bottom,           // cy
			     NULL,                    // no parent for this window
			     NULL,                    // use the class menu
			     hInstance,               // who created this window
			     NULL                     // no parms to pass on
     );

      // Update display of main window.
     ShowWindow(hWndMain, cmdShow);
     UpdateWindow(hWndMain);
}


#pragma argsused
LRESULT CALLBACK PWinProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
   PAINTSTRUCT  ps;
   HDC          hdc;
   POINT        pCursor;
   HBRUSH       hBrush, hBrush1, hobr;
   HPEN         hPen1, hop;
   RECT         rect;
   int          i, j, k, x, y, halfx;
   LOGBRUSH     logbrush;
   char         c, buf[100], buf2[255];
   HPALETTE     oldpal, oldpal2;
   COLORREF     acolour;


   switch(message){
       case WM_CREATE:
            // create font...
	    MainFontRec.lfHeight = 36;
            MainFontRec.lfWidth = 16;
            MainFontRec.lfEscapement = 0;
	    MainFontRec.lfOrientation = 0;
            MainFontRec.lfWeight = FW_BOLD;
            MainFontRec.lfItalic = 0;
            MainFontRec.lfUnderline = 0;
            MainFontRec.lfStrikeOut = 0;
            MainFontRec.lfCharSet = ANSI_CHARSET;
	    MainFontRec.lfOutPrecision = OUT_DEFAULT_PRECIS;
            MainFontRec.lfClipPrecision = CLIP_DEFAULT_PRECIS;
            MainFontRec.lfQuality = PROOF_QUALITY;
            MainFontRec.lfPitchAndFamily = VARIABLE_PITCH | FF_ROMAN;
	    strcpy(MainFontRec.lfFaceName,"Times New Roman");
	    hdc = GetDC(hWnd);
	    undodc = CreateCompatibleDC(hdc);
	    undobmp = CreateCompatibleBitmap(hdc,hres-50,vres-50);
	    SelectObject(undodc,undobmp);
	    ReleaseDC(hWnd,hdc);
	    break;
       case WM_DESTROY:
	    DeleteDC(undodc);
	    DeleteObject(undobmp);
	    memset(buf,100,'\0');
	    strcpy(buf,"close midi");   
	    mciSendString(buf, buf2, 255, hWnd);
	    break;
       case WM_PAINT:
	    if(firsttime == TRUE){
	       hdc = GetDC(hWnd);
	       BitBlt(undodc,0,0,hres-50,vres-50,NULL,0,0,WHITENESS);
	       ReleaseDC(hWnd,hdc);
	       firsttime = FALSE;
	       memset(buf,100,'\0');               // get the buffer ready
	       chthedir(IN);                      // make sure we're in our directory
	       switch(kabitmapID){
                   case 1:
		      strcpy(buf,"rm0cboot.wav");            
		      break;
		   case 3:
		      strcpy(buf,"rm3cboot.wav");
		      break;
		   case 4:
		      strcpy(buf,"rm4cboot.wav");
		      break;
		   case 5:
		      strcpy(buf,"rm4dboot.wav");
		      break;
		   case 6:
		      strcpy(buf,"rm6cboot.wav");
		      break;
		   case 7:
		      strcpy(buf,"rm7cboot.wav");
		      break;
               }     
	       sndPlaySound(buf,SND_ASYNC);         // and play it...
	       if(kabitmapID == 5){
		  chthedir(IN);                          // we're in the right directory...
	          memset(buf,100,'\0');                   // clear out the buffer
	          strcpy(buf,"Open painter.mid alias midi");  // (this is simple enough, eh?)

	          mciSendString(buf, buf2, 255, hWnd);    // buf2 is a message buffer
						    // in case MMSYSTEM complains.
						    // you don't really need to look
						    // at it unless you want to do
                                                    // something upon failure.
	          memset(buf,100,'\0');
	          strcpy(buf,"Play midi from 0 notify");         // and then tell it to play.
	          mciSendString(buf, buf2, 255, hWnd);
	       }
	       else{
	          chthedir(IN);                          // we're in the right directory...
	          memset(buf,100,'\0');                   // clear out the buffer
	          strcpy(buf,"Open crayonme.mid alias midi");  // (this is simple enough, eh?)

	          mciSendString(buf, buf2, 255, hWnd);    // buf2 is a message buffer
						    // in case MMSYSTEM complains.
						    // you don't really need to look
						    // at it unless you want to do
                                                    // something upon failure.
	          memset(buf,100,'\0');
	          strcpy(buf,"Play midi from 0 notify");         // and then tell it to play.
	          mciSendString(buf, buf2, 255, hWnd);
	       }
	    }
            // This is what we get in a normal paint...
	    BeginPaint(hWnd,&ps);
	    oldpal = SelectPalette(ps.hdc, hwndpal, FALSE);
	    RealizePalette(ps.hdc);
	    BitBlt(ps.hdc,0,0,hres-50,vres-50,undodc,0,0,SRCCOPY);
	    SelectPalette(ps.hdc, oldpal, FALSE);
	    EndPaint(hWnd,&ps);
	    if(colorbook == FALSE) DrawTools1();
	    break;
       case MM_MCINOTIFY:
	    if(wParam != MCI_NOTIFY_FAILURE){  // if not nfg
	       memset(buf,100,'\0');
	       strcpy(buf,"Play midi from 0 notify");   
	       mciSendString(buf, buf2, 255, hWnd);
	    }
            break;
       case WM_RBUTTONDOWN:
	    buttondown = FALSE;
	    break;
       case WM_LBUTTONDOWN:
	    pCursor = MAKEPOINT(lParam);
	    oldx = pCursor.x;
	    oldy = pCursor.y;
	    if(DoingText == TRUE){
	       cleanuptext();
	       break;
	    }
	    if(ReadyToDoText == TRUE){
	       TextX = pCursor.x;
	       TextY = pCursor.y;
	       ReadyToDoText = FALSE;
	       DoingText = TRUE;
	       hdc = GetDC(hWnd);
	       oldpal = SelectPalette(hdc, hwndpal, FALSE);
	       RealizePalette(hdc);
	       memset(globaltextbuf,'\0',255);
	       savebitmapDC = CreateCompatibleDC(hdc);
	       hsavebitmap = CreateCompatibleBitmap(hdc,hres-50,vres-50);
	       SelectObject(savebitmapDC,hsavebitmap);
	       oldpal2 = SelectPalette(savebitmapDC, hwndpal, FALSE);
	       RealizePalette(savebitmapDC);
	       BitBlt(savebitmapDC,0,0,hres-50,vres-50,hdc,0,0,SRCCOPY);
	       SelectPalette(savebitmapDC, oldpal2, FALSE);
	       SelectPalette(hdc, oldpal, FALSE);
	       ReleaseDC(hWnd,hdc);
               BlankIconArea(0);
	       SetFocus(hWndMain);
	       ShowText(' ');
               break;
	    }
	    if(colorbook == TRUE){
	       hdc = GetDC(hWnd);
	       oldpal = SelectPalette(hdc, hwndpal, FALSE);
	       RealizePalette(hdc);
	       if(DrawTool == COLORBOOK1){
		  hBrush = CreateSolidBrush(CurrentColor | 0x2000000L);
		  j = 1;
               }
	       else{
		  hBrush = CreateSolidBrush(WHITE);
		  j = 2;
               }
	       hobr = SelectObject(hdc,hBrush);
	       if(GetPixel(hdc,oldx,oldy) != BLACK){
                  if(j == 1)
		     PlaySound(14); // paint sound if painting
		  else
                     PlaySound(1);  // vacuum sound otherwise
		  ExtFloodFill(hdc,oldx,oldy,GetPixel(hdc,oldx,oldy) | 0x2000000L,FLOODFILLSURFACE);
	       }
	       SelectObject(hdc,hobr);
	       SelectPalette(hdc, oldpal, FALSE);
	       ReleaseDC(hWnd,hdc);
	       DeleteObject(hBrush);
	       break;
	    }
	    switch(DrawTool){
	       case ICONDRAW:
		    hdc = GetDC(hWnd);
		    oldpal = SelectPalette(hdc, hwndpal, FALSE);
		    RealizePalette(hdc);
		    j = random(8);
		    sndPlaySound(stampwav[j],SND_MEMORY);
		    DrawIcon(hdc,oldx - 16,oldy-16,TheIcon);
		    SelectPalette(hdc, oldpal, FALSE);
		    ReleaseDC(hWnd,hdc);
                    if(stampsmear == TRUE)
		       buttondown = TRUE;
		    break;
	       case PENCIL:
                    DrawLine(oldx, oldy,oldx+1,oldy,DrawWidth,CurrentColor);
		    buttondown = TRUE;
		    break;
	       case COLORDOT:
		    hdc = GetDC(hWnd);
		    oldpal = SelectPalette(hdc, hwndpal, FALSE);
		    RealizePalette(hdc);
		    j = random(15);
                    k = random(20);
		    hOurPen = CreatePen(PS_SOLID,1,aColor[j] | 0x2000000L);
		    hop = SelectObject(hdc,hOurPen);
		    hBrush = CreateSolidBrush(aColor[j] | 0x2000000L);
		    hobr = SelectObject(hdc,hBrush);
		    Ellipse(hdc,oldx - k,oldy - k,oldx + k,oldy + k);
		    SelectObject(hdc,hop);
		    SelectObject(hdc,hobr);
		    SelectPalette(hdc, oldpal, FALSE);
		    ReleaseDC(hWnd,hdc);
		    DeleteObject(hOurPen);
		    DeleteObject(hBrush);
		    buttondown = TRUE;
		    break;
	       case ZIGZAG:
		    PlaySound(12);
	            DrawLine(oldx,oldy,oldx,oldy,DrawWidth,CurrentColor);
		    buttondown = TRUE;
		    break;
	       case LINEA:
		    PlaySound(107);
		    k = DrawWidth * 2;
		    DrawLine(oldx - k,oldy + k,oldx + k,oldy - k,DrawWidth,CurrentColor);
		    buttondown = TRUE;
		    break;
	       case LINEB:
		    PlaySound(47);
		    k = DrawWidth * 2;
		    DrawLine(oldx - k,oldy - k,oldx + k,oldy + k,DrawWidth,CurrentColor);
		    buttondown = TRUE;
		    break;
	       case LINEC:
		    PlaySound(57);
		    k = DrawWidth * 2;
		    DrawLine(oldx,oldy - k,oldx,oldy + k,DrawWidth,CurrentColor);
		    buttondown = TRUE;
		    break;
	       case LINED:
		    PlaySound(20);
		    k = DrawWidth * 2;
		    DrawLine(oldx - k,oldy,oldx + k,oldy,DrawWidth,CurrentColor);
		    buttondown = TRUE;
		    break;
	       case QUILLPEN:
		    PlaySound(67);
		    DrawLine(oldx,oldy,oldx,oldy,4,CurrentColor);
		    buttondown = TRUE;
		    break;
	       case CHARCOALPENCIL:
		    PlaySound(108);
		    DrawLine(oldx,oldy,oldx,oldy,2,CurrentColor);
		    buttondown = TRUE;
		    break;
	       case SPRAYCAN:
		    PlaySound(83);
		    hdc = GetDC(hWnd);
		    SelectPalette(hdc, hwndpal, FALSE);
		    RealizePalette(hdc);
		    for(i = 0;i < 25; i++){
			j = random(DrawWidth * 8);
			k = random(DrawWidth * 8);
			if(j%2 == 0) j = j * -1;
			if(k%2 != 0) k = k * -1;
			SetPixel(hdc,oldx + j, oldy + k,CurrentColor | 0x2000000L);
		    }
		    ReleaseDC(hWnd,hdc);
		    buttondown = TRUE;
		    break;
	       case CHALK:
		    hdc = GetDC(hWnd);
		    oldpal = SelectPalette(hdc, hwndpal, FALSE);
		    RealizePalette(hdc);
                    PlaySound(5);
		    for(i = 0;i < 25; i++){
			j = random(7);
			k = random(8);
			if(j%2 == 0) j = j * -1;
			if(k%2 != 0) k = k * -1;
			SetPixel(hdc,oldx + j, oldy + k,CurrentColor | 0x2000000L);
		    }
		    SelectPalette(hdc, oldpal, FALSE);
		    ReleaseDC(hWnd,hdc);
		    DrawLine(oldx,oldy,oldx,oldy,DrawWidth,CurrentColor);
		    buttondown = TRUE;
		    break;
	       case GOOFYLINE:
		    PlaySound(3);
		    for(i = 0;i < 10; i++){
			j = random(DrawWidth * 8);
			k = random(DrawWidth * 8);
			if(j%2 == 0) j *= -1;
			if(k%2 != 0) k *= -1;
			DrawLine(oldx,oldy,oldx + j, oldy + k,DrawWidth,CurrentColor);
		    }
		    buttondown = TRUE;
		    break;
	       case BUCKET:
		    hdc = GetDC(hWnd);
		    oldpal = SelectPalette(hdc, hwndpal, FALSE);
		    RealizePalette(hdc);
		    acolour = GetPixel(hdc,oldx,oldy);
		    if(acolour == CurrentColor){
		       SelectPalette(hdc, oldpal, FALSE);
		       ReleaseDC(hWnd,hdc);
		       break;
		    }
		    hBrush = CreateSolidBrush(CurrentColor | 0x2000000L);
		    hobr = SelectObject(hdc,hBrush);
		    PlaySound(14);
		    ExtFloodFill(hdc,oldx,oldy,GetPixel(hdc,oldx,oldy)| 0x2000000L, FLOODFILLSURFACE);
		    SelectObject(hdc, hobr);
		    SelectPalette(hdc, oldpal, FALSE);
		    ReleaseDC(hWnd,hdc);
		    DeleteObject(hBrush);
		    break;
	       case SMALLERASER:
		    PlaySound(41);
		    hdc = GetDC(hWnd);
		    oldpal = SelectPalette(hdc, hwndpal, FALSE);
		    RealizePalette(hdc);
		    hOurPen = CreatePen(PS_SOLID,1,WHITE);
                    hPen1 = CreatePen(PS_SOLID,1,BLACK);
		    hop = SelectObject(hdc,hOurPen);
		    hBrush = CreateSolidBrush(WHITE);
		    hobr = SelectObject(hdc,hBrush);
		    x = oldx - 10;
		    y = oldy - 10;
		    Rectangle(hdc,x,y,x+20,y+20);
		    SelectObject(hdc, hop);
                    hop = SelectObject(hdc,hPen1);
		    Box(hdc,x,y,x+20,y+20);
		    SelectObject(hdc, hobr);
		    SelectObject(hdc, hop);
		    SelectPalette(hdc, oldpal, FALSE);
		    ReleaseDC(hWnd,hdc);
		    DeleteObject(hBrush);
		    DeleteObject(hOurPen);
		    DeleteObject(hPen1);
		    buttondown = TRUE;
		    break;
	       case LARGEERASER:
		    hdc = GetDC(hWnd);
		    oldpal = SelectPalette(hdc, hwndpal, FALSE);
		    RealizePalette(hdc);
		    PlaySound(1);
		    hOurPen = CreatePen(PS_SOLID,1,WHITE);
		    hPen1 = CreatePen(PS_SOLID,1,BLACK);
		    hop = SelectObject(hdc,hOurPen);
		    hBrush = CreateSolidBrush(WHITE);
		    hobr = SelectObject(hdc,hBrush);
		    x = oldx - 20;
		    y = oldy - 20;
		    Rectangle(hdc,x,y,x+40,y+40);
		    SelectObject(hdc, hop);
		    hop = SelectObject(hdc,hPen1);
		    Box(hdc,x,y,x+40,y+40);
		    SelectObject(hdc, hobr);
		    SelectObject(hdc, hop);
		    SelectPalette(hdc, oldpal, FALSE);
		    ReleaseDC(hWnd,hdc);
		    DeleteObject(hOurPen);
		    DeleteObject(hBrush);
		    DeleteObject(hPen1);
		    buttondown = TRUE;
		    break;
	       case MULTIPOLY:
                    polycount = 0;
		    xwas = oldx;
		    ywas = oldy;
		    polypoint[polycount].x = oldx;
		    polypoint[polycount++].y = oldy;
		    buttondown = TRUE;
		    break;
	       case KNIFE:
                    polycount = 0;
		    xwas = oldx;
		    ywas = oldy;
		    polypoint[polycount].x = oldx;
		    polypoint[polycount++].y = oldy;
		    buttondown = TRUE;
		    break;
	       case SCISSORS:
                    PlaySound(80);
		    xwas = oldx;
		    ywas = oldy;
		    buttondown = TRUE;
		    break;
	       case PROPELLER:
		    PlaySound(43);
		    xwas = oldx;
		    ywas = oldy;
		    buttondown = TRUE;
		    break;
	       case LINE:
	       case RECTANGLE:
	       case FLIPH:
	       case FLIPV:
	       case CIRCLE:
	       case FILLEDCIRCLE:
	       case FILLEDRECTANGLE:
	       case TRIANGLE:
               case FILLEDTRIANGLE:
		    xwas = oldx;
		    ywas = oldy;
		    buttondown = TRUE;
		    break;
            } // DrawTool switch
            SetCapture(phwnd);
	    break;
       case WM_MOUSEMOVE:
	    if(buttondown){
	       pCursor = MAKEPOINT(lParam);
	       switch(DrawTool){
		  case ICONDRAW:
		       hdc = GetDC(hWnd);
		       oldpal = SelectPalette(hdc, hwndpal, FALSE);
		       RealizePalette(hdc);
		       j = random(8);
		       sndPlaySound(stampwav[j],SND_MEMORY);
		       DrawIcon(hdc,pCursor.x - 16,pCursor.y-16,TheIcon);
		       SelectPalette(hdc, oldpal, FALSE);
		       ReleaseDC(hWnd,hdc);
                       break;
		  case LINEA:
		       k = DrawWidth * 2;
		       for(i = (k * -1); i < k; i++)
			   DrawLine(oldx + i,oldy + (i * -1),pCursor.x + i,pCursor.y + (i * -1),DrawWidth,CurrentColor);
		       oldx = pCursor.x;
		       oldy = pCursor.y;
		       break;
		  case LINEB:
		       k = DrawWidth * 2;
		       for(i = (k * -1); i < k; i++)
			   DrawLine(oldx + i, oldy + i, pCursor.x + i, pCursor.y + i,DrawWidth,CurrentColor);
		       oldx = pCursor.x;
		       oldy = pCursor.y;
		       break;
		  case LINEC:
		       k = DrawWidth * 2;
		       for(i = (k * -1); i < k; i++)
		           DrawLine(oldx,pCursor.y - i,pCursor.x,pCursor.y + i,DrawWidth,CurrentColor);
		       oldx = pCursor.x;
		       oldy = pCursor.y;
		       break;
		  case LINED:
		       k = DrawWidth * 2;
		       for(i = (k * -1); i < k; i++)
		           DrawLine(pCursor.x - i,oldy,pCursor.x + i,pCursor.y,DrawWidth,CurrentColor);
		       oldx = pCursor.x;
		       oldy = pCursor.y;
		       break;
		  case COLORDOT:
		       j = random(8);
		       sndPlaySound(stampwav[j],SND_MEMORY);
		       hdc = GetDC(hWnd);
		       oldpal = SelectPalette(hdc, hwndpal, FALSE);
		       RealizePalette(hdc);
		       j = random(15);
                       k = random(20);
		       hOurPen = CreatePen(PS_SOLID,1,aColor[j] | 0x2000000L);
		       hop = SelectObject(hdc,hOurPen);
		       hBrush = CreateSolidBrush(aColor[j] | 0x2000000L);
		       hop = SelectObject(hdc,hBrush);
		       Ellipse(hdc,pCursor.x - k,pCursor.y - k,pCursor.x + k,pCursor.y + k);
		       SelectObject(hdc,hop);
		       SelectObject(hdc,hobr);
		       SelectPalette(hdc, oldpal, FALSE);
		       ReleaseDC(hWnd,hdc);
		       DeleteObject(hOurPen);
		       DeleteObject(hBrush);
		       break;
		  case SMALLERASER:
		       hdc = GetDC(hWnd);
		       oldpal = SelectPalette(hdc, hwndpal, FALSE);
		       RealizePalette(hdc);
		       hOurPen = CreatePen(PS_SOLID,1,WHITE);
		       hPen1 = CreatePen(PS_SOLID,1,BLACK);
		       x = oldx - 10;
		       y = oldy - 10;
		       hop = SelectObject(hdc,hOurPen);
		       Box(hdc,x,y,x+20,y+20);
		       hBrush = CreateSolidBrush(WHITE);
		       hobr = SelectObject(hdc,hBrush);
		       x = pCursor.x - 10;
		       y = pCursor.y - 10;
		       Rectangle(hdc,x,y,x+20,y+20);
		       SelectObject(hdc,hop);
		       hop = SelectObject(hdc,hPen1);
		       Box(hdc,x,y,x+20,y+20);
		       oldx = pCursor.x;
		       oldy = pCursor.y;
		       SelectObject(hdc,hop);
		       SelectObject(hdc,hobr);
		       SelectPalette(hdc, oldpal, FALSE);
		       ReleaseDC(hWnd,hdc);
		       DeleteObject(hBrush);
		       DeleteObject(hOurPen);
		       DeleteObject(hPen1);
		       break;
	          case LARGEERASER:
		       hdc = GetDC(hWnd);
		       oldpal = SelectPalette(hdc, hwndpal, FALSE);
		       RealizePalette(hdc);
		       hOurPen = CreatePen(PS_SOLID,1,WHITE);
		       hPen1 = CreatePen(PS_SOLID,1,BLACK);
		       x = oldx - 20;
		       y = oldy - 20;
		       hop = SelectObject(hdc,hOurPen);
		       Box(hdc,x,y,x+40,y+40);
		       hBrush = CreateSolidBrush(WHITE);
		       hobr = SelectObject(hdc,hBrush);
		       x = pCursor.x - 20;
		       y = pCursor.y - 20;
		       Rectangle(hdc,x,y,x+40,y+40);
		       SelectObject(hdc,hop);
		       hop = SelectObject(hdc,hPen1);
		       Box(hdc,x,y,x+40,y+40);
		       oldx = pCursor.x;
		       oldy = pCursor.y;
		       SelectObject(hdc,hop);
		       SelectObject(hdc,hobr);
		       SelectPalette(hdc, oldpal, FALSE);
		       ReleaseDC(hWnd,hdc);
		       DeleteObject(hBrush);
		       DeleteObject(hOurPen);
		       DeleteObject(hPen1);
		       break;
                  case PENCIL:
		       DrawLine(oldx,oldy,pCursor.x,pCursor.y,DrawWidth,CurrentColor);
	               oldx = pCursor.x;
		       oldy = pCursor.y;
		       break;
		  case QUILLPEN:
		       if(pCursor.x > oldx) x = pCursor.x - oldx;
		       else                 x = oldx - pCursor.x;

		       if(pCursor.y > oldy) y = pCursor.y - oldy;
		       else                 y = oldy - pCursor.y;

		       if(x > y)            j = x;
		       else                 j = y;

		       if(j < 5) k = 4;
		       if(j >= 5 && j < 10) k = 3;
		       if(j >= 10 && j < 20) k = 2;
		       if(j >= 20) k = 1;
		       DrawLine(oldx,oldy,pCursor.x,pCursor.y,k,CurrentColor);
	               oldx = pCursor.x;
	               oldy = pCursor.y;
		       break;
		  case CHARCOALPENCIL:
		       if(pCursor.x > oldx)
			  x = pCursor.x - oldx;
		       else
			  x = oldx - pCursor.x;
		       if(pCursor.y > oldy)
			  y = pCursor.y - oldy;
		       else
			  y = oldy - pCursor.y;
		       if(x > y)
			  j = x;
		       else
			  j = y;
		       if(j < 5) k = 2;
		       if(j >= 5 && j < 10) k = 3;
		       if(j >= 10 && j < 20) k = 4;
		       if(j >= 20) k = 5;        
		       DrawLine(oldx,oldy,pCursor.x,pCursor.y,k,CurrentColor);
	               oldx = pCursor.x;
	               oldy = pCursor.y;
		       break;
		  case MULTIPOLY:
		       DrawLine(oldx,oldy,pCursor.x,pCursor.y,1,CurrentColor);
	               oldx = pCursor.x;
		       oldy = pCursor.y;
		       polypoint[polycount].x = oldx;
		       polypoint[polycount++].y = oldy;
		       break;
		  case KNIFE:
		       DrawLine(oldx,oldy,pCursor.x,pCursor.y,1,WHITE);
	               oldx = pCursor.x;
		       oldy = pCursor.y;
		       polypoint[polycount].x = oldx;
		       polypoint[polycount++].y = oldy;
		       break;
		  case SPRAYCAN:
		       hdc = GetDC(hWnd);
		       oldpal = SelectPalette(hdc, hwndpal, FALSE);
		       RealizePalette(hdc);
		       for(i = 0;i < 25; i++){
			   j = random(DrawWidth * 8);
		           k = random(DrawWidth * 8);
			   if(j%2 != 0) j *= -1;
			   if(k%2 == 0) k *= -1;
			   SetPixel(hdc,pCursor.x + j, pCursor.y + k,CurrentColor | 0x2000000L);
		       }
		       SelectPalette(hdc, oldpal, FALSE);
		       ReleaseDC(hWnd,hdc);
		       break;
		  case CHALK:
		       hdc = GetDC(hWnd);
		       oldpal = SelectPalette(hdc, hwndpal, FALSE);
		       RealizePalette(hdc);
		       for(i = 0;i < 25; i++){
		           j = random(7);
		           k = random(8);
			   if(j%2 == 0) j *= -1;
			   if(k%2 != 0) k *= -1;
			   SetPixel(hdc,oldx + j, oldy + k,CurrentColor | 0x2000000L);
		       }
		       SelectPalette(hdc, oldpal, FALSE);
		       ReleaseDC(hWnd,hdc);
		       DrawLine(oldx,oldy,pCursor.x,pCursor.y,10,CurrentColor);
		       oldx = pCursor.x;
		       oldy = pCursor.y;
		       break;
		  case GOOFYLINE:
		       for(i = 0;i < 10; i++){
		           j = random(DrawWidth * 12);
			   k = random(DrawWidth * 12);
			   if(j%2 == 0) j *= -1;
			   if(k%2 != 0) k *= -1;
			   DrawLine(pCursor.x,pCursor.y,pCursor.x + j, pCursor.y + k,DrawWidth,CurrentColor);
		       }
                       break;
		  case LINE:
		       hdc = GetDC(hWnd);
		       oldpal = SelectPalette(hdc, hwndpal, FALSE);
		       RealizePalette(hdc);
		       SetROP2(hdc,R2_XORPEN);
		       hOurPen = CreatePen(PS_SOLID,1,WHITE);
		       hop = SelectObject(hdc,hOurPen);
		       Line(hdc,oldx,oldy,xwas,ywas);
		       Line(hdc,oldx,oldy,pCursor.x,pCursor.y);
		       xwas = pCursor.x;
		       ywas = pCursor.y;
		       SelectPalette(hdc, oldpal, FALSE);
		       SelectObject(hdc,hop);
		       ReleaseDC(hWnd,hdc);
		       DeleteObject(hOurPen);
		       break;
		  case PROPELLER:
		       if(pCursor.x > oldx)
			  x = oldx - (pCursor.x - oldx);
		       else
			  x = oldx + (oldx - pCursor.x);
		       if(pCursor.y > oldy)
			  y = oldy - (pCursor.y - oldy);
		       else
			  y = oldy + (oldy - pCursor.y);
		       DrawLine(oldx,oldy,x,y,1,CurrentColor);
		       DrawLine(oldx,oldy,pCursor.x,pCursor.y,1,CurrentColor);
		       break;
		  case RECTANGLE:
		  case SCISSORS:
		  case FLIPV:
                  case FLIPH:
                  case FILLEDRECTANGLE:
		       hdc = GetDC(hWnd);
		       oldpal = SelectPalette(hdc, hwndpal, FALSE);
		       RealizePalette(hdc);
		       SetROP2(hdc,R2_XORPEN);
		       hOurPen = CreatePen(PS_SOLID,1,WHITE);
		       hop = SelectObject(hdc,hOurPen);
		       Box(hdc,oldx,oldy,xwas,ywas);
		       Box(hdc,oldx,oldy,pCursor.x,pCursor.y);
		       xwas = pCursor.x;
		       ywas = pCursor.y;
		       SelectPalette(hdc, oldpal, FALSE);
		       SelectObject(hdc,hop);
		       ReleaseDC(hWnd,hdc);
		       DeleteObject(hOurPen);
		       break;
		  case CIRCLE:
		  case FILLEDCIRCLE:
		       hdc = GetDC(hWnd);
		       oldpal = SelectPalette(hdc, hwndpal, FALSE);
		       RealizePalette(hdc);
		       SetROP2(hdc,R2_XORPEN);
		       hOurPen = CreatePen(PS_SOLID,1,WHITE);
		       logbrush.lbStyle = BS_HOLLOW;
		       hBrush = CreateBrushIndirect(&logbrush);
		       hobr = SelectObject(hdc,hBrush);
		       hop = SelectObject(hdc,hOurPen);
		       Ellipse(hdc,oldx,oldy,xwas,ywas);
		       Ellipse(hdc,oldx,oldy,pCursor.x,pCursor.y);
		       xwas = pCursor.x;
		       ywas = pCursor.y;
		       SelectPalette(hdc, oldpal, FALSE);
		       SelectObject(hdc,hop);
		       SelectObject(hdc,hobr);
		       ReleaseDC(hWnd,hdc);
		       DeleteObject(hOurPen);
                       DeleteObject(hBrush);
		       break;
		  case ZIGZAG:
		       if(pCursor.x > oldx)
			  halfx = ((pCursor.x - oldx) / 2) + oldx;
		       else
			  halfx = ((oldx - pCursor.x) / 2) + pCursor.x;
		       j = random(DrawWidth * 3);
		       if(j%2 != 0) j *= -1;
		       DrawLine(oldx,oldy,halfx,pCursor.y + j,DrawWidth,CurrentColor);
		       DrawLine(halfx, pCursor.y + j, pCursor.x, pCursor.y,DrawWidth,CurrentColor);
		       oldx = pCursor.x;
	               oldy = pCursor.y;
                       break;
		  case TRIANGLE:
                  case FILLEDTRIANGLE:
		       hdc = GetDC(hWnd);
		       oldpal = SelectPalette(hdc, hwndpal, FALSE);
		       RealizePalette(hdc);
		       SetROP2(hdc,R2_XORPEN);
		       hOurPen = CreatePen(PS_SOLID,1,WHITE);
		       hop = SelectObject(hdc,hOurPen);
                       // old triangle
		       if(oldx > xwas)
			  halfx = ((oldx - xwas) / 2) + xwas;
		       else
			  halfx = ((xwas - oldx) / 2) + oldx;
		       Line(hdc,oldx,ywas,xwas,ywas);
		       Line(hdc,oldx, ywas, halfx, oldy);
		       Line(hdc,halfx,oldy,xwas,ywas);
                       // new one
		       if(pCursor.x > oldx)
			  halfx = ((pCursor.x - oldx) / 2) + oldx;
		       else
			  halfx = ((oldx - pCursor.x) / 2) + pCursor.x;
		       Line(hdc,oldx,pCursor.y,pCursor.x,pCursor.y);
		       Line(hdc,oldx, pCursor.y, halfx, oldy);
		       Line(hdc,halfx,oldy,pCursor.x,pCursor.y);
		       SelectPalette(hdc, oldpal, FALSE);
		       SelectObject(hdc,hop);
		       xwas = pCursor.x;
	               ywas = pCursor.y;
		       ReleaseDC(hWnd,hdc);
		       DeleteObject(hOurPen);
		       break;
		} // switch DrawTool
            } // if buttondown
	    break;
       case WM_LBUTTONUP:
	    buttondown = FALSE;
	    ReleaseCapture();
	    switch(DrawTool){
	       case SPRAYCAN:
		    sndPlaySound("spray2.wav",SND_ASYNC);
                    break;
	       case LINE:
                    PlaySound(16);
		    pCursor = MAKEPOINT(lParam);
		    hdc = GetDC(hWnd);
		    oldpal = SelectPalette(hdc, hwndpal, FALSE);
		    RealizePalette(hdc);
		    SetROP2(hdc,R2_XORPEN);
		    hOurPen = CreatePen(PS_SOLID,1,WHITE);
		    hPen1 = CreatePen(PS_SOLID,DrawWidth,CurrentColor | 0x2000000L);
		    hop = SelectObject(hdc,hOurPen);
		    Line(hdc,oldx,oldy,xwas,ywas);
		    SelectObject(hdc,hop);
		    hop = SelectObject(hdc,hPen1);
		    SetROP2(hdc,R2_COPYPEN);
		    Line(hdc,oldx,oldy,pCursor.x,pCursor.y);
		    SelectPalette(hdc, oldpal, FALSE);
		    SelectObject(hdc,hop);
		    ReleaseDC(hWnd,hdc);
		    DeleteObject(hOurPen);
		    DeleteObject(hPen1);
		    break;
	       case RECTANGLE:
		    PlaySound(21);
		    pCursor = MAKEPOINT(lParam);
		    hdc = GetDC(hWnd);
		    oldpal = SelectPalette(hdc, hwndpal, FALSE);
		    RealizePalette(hdc);
		    SetROP2(hdc,R2_XORPEN);
		    hOurPen = CreatePen(PS_SOLID,1,WHITE);
		    hPen1 = CreatePen(PS_SOLID,DrawWidth,CurrentColor | 0x2000000L);
		    hop = SelectObject(hdc,hOurPen);
		    Box(hdc,oldx,oldy,xwas,ywas);
		    SelectObject(hdc,hop);
		    hop = SelectObject(hdc,hPen1);
		    SetROP2(hdc,R2_COPYPEN);
		    Box(hdc,oldx,oldy,pCursor.x,pCursor.y);
		    SelectPalette(hdc, oldpal, FALSE);
		    SelectObject(hdc,hop);
		    ReleaseDC(hWnd,hdc);
		    DeleteObject(hOurPen);
		    DeleteObject(hPen1);
		    break;
	       case SCISSORS:
		    pCursor = MAKEPOINT(lParam);
		    hdc = GetDC(hWnd);
		    oldpal = SelectPalette(hdc, hwndpal, FALSE);
		    RealizePalette(hdc);
		    SetROP2(hdc,R2_XORPEN);
		    hOurPen = CreatePen(PS_SOLID,1,WHITE);
		    hPen1 = CreatePen(PS_SOLID,DrawWidth,WHITE);
		    hop = SelectObject(hdc,hOurPen);
		    Box(hdc,oldx,oldy,xwas,ywas);
		    SelectObject(hdc,hop);
		    hop = SelectObject(hdc,hPen1);
		    SetROP2(hdc,R2_COPYPEN);
		    hBrush = CreateSolidBrush(WHITE);
		    hobr = SelectObject(hdc, hBrush);
		    Rectangle(hdc,oldx,oldy,pCursor.x,pCursor.y);
		    SelectObject(hdc,hop);
		    SelectObject(hdc,hobr);
		    SelectPalette(hdc, oldpal, FALSE);
		    ReleaseDC(hWnd,hdc);
		    DeleteObject(hOurPen);
		    DeleteObject(hPen1);
		    DeleteObject(hBrush);
		    break;
	       case FLIPH:
		    PlaySound(74);
		    pCursor = MAKEPOINT(lParam);
		    hdc = GetDC(hWnd);
		    oldpal = SelectPalette(hdc, hwndpal, FALSE);
		    RealizePalette(hdc);
		    SetROP2(hdc,R2_XORPEN);
		    hOurPen = CreatePen(PS_SOLID,1,WHITE);
		    hop = SelectObject(hdc,hOurPen);
		    Box(hdc,oldx,oldy,xwas,ywas);
		    SetROP2(hdc,R2_COPYPEN);
		    x = pCursor.x - oldx;
		    y = pCursor.y - oldy;
		    StretchBlt(hdc,oldx,oldy,x,y, hdc, oldx + x, oldy, x * -1,y,SRCCOPY);
		    SelectObject(hdc,hop);
		    SelectPalette(hdc, oldpal, FALSE);
		    ReleaseDC(hWnd,hdc);
		    DeleteObject(hOurPen);
		    break;
	       case FLIPV:
		    PlaySound(75);
		    pCursor = MAKEPOINT(lParam);
		    hdc = GetDC(hWnd);
		    oldpal = SelectPalette(hdc, hwndpal, FALSE);
		    RealizePalette(hdc);
		    SetROP2(hdc,R2_XORPEN);
		    hOurPen = CreatePen(PS_SOLID,1,WHITE);
		    hop = SelectObject(hdc,hOurPen);
		    Box(hdc,oldx,oldy,xwas,ywas);
		    SetROP2(hdc,R2_COPYPEN);
		    x = pCursor.x - oldx;
		    y = pCursor.y - oldy;
		    StretchBlt(hdc,oldx,oldy,x, y, hdc, oldx, oldy + y, x, y * -1,SRCCOPY);
		    SelectObject(hdc,hop);
		    SelectPalette(hdc, oldpal, FALSE);
		    ReleaseDC(hWnd,hdc);
		    DeleteObject(hOurPen);
		    break;
	       case CIRCLE:
		    PlaySound(27);
		    pCursor = MAKEPOINT(lParam);
		    hdc = GetDC(hWnd);
		    oldpal = SelectPalette(hdc, hwndpal, FALSE);
		    RealizePalette(hdc);
		    SetROP2(hdc,R2_XORPEN);
		    hOurPen = CreatePen(PS_SOLID,1,WHITE);
		    hPen1 = CreatePen(PS_SOLID,DrawWidth,CurrentColor | 0x2000000L);
		    hop = SelectObject(hdc,hOurPen);
		    logbrush.lbStyle = BS_HOLLOW;
		    hBrush = CreateBrushIndirect(&logbrush);
		    hobr = SelectObject(hdc,hBrush);
		    Ellipse(hdc,oldx,oldy,xwas,ywas);
		    SelectObject(hdc,hop);
		    hop = SelectObject(hdc,hPen1);
		    SetROP2(hdc,R2_COPYPEN);
		    Ellipse(hdc,oldx,oldy,pCursor.x,pCursor.y);
		    SelectObject(hdc,hop);
		    SelectObject(hdc,hobr);
		    SelectPalette(hdc, oldpal, FALSE);
		    ReleaseDC(hWnd,hdc);
		    DeleteObject(hOurPen);
		    DeleteObject(hPen1);
                    DeleteObject(hBrush);
		    break;
	       case FILLEDRECTANGLE:
		    PlaySound(22);
		    pCursor = MAKEPOINT(lParam);
		    hdc = GetDC(hWnd);
		    oldpal = SelectPalette(hdc, hwndpal, FALSE);
		    RealizePalette(hdc);
		    SetROP2(hdc,R2_XORPEN);
		    hOurPen = CreatePen(PS_SOLID,1,WHITE);
		    hPen1 = CreatePen(PS_SOLID,1,CurrentColor | 0x2000000L);
		    hop = SelectObject(hdc,hOurPen);
		    Box(hdc,oldx,oldy,xwas,ywas);
		    SelectObject(hdc,hop);
		    hop = SelectObject(hdc,hPen1);
		    SetROP2(hdc,R2_COPYPEN);
		    hBrush = CreateSolidBrush(CurrentColor | 0x2000000L);
		    hobr = SelectObject(hdc, hBrush);
		    Rectangle(hdc,oldx,oldy,pCursor.x,pCursor.y);
		    SelectObject(hdc,hop);
		    SelectObject(hdc,hobr);
		    SelectPalette(hdc, oldpal, FALSE);
		    ReleaseDC(hWnd,hdc);
		    DeleteObject(hOurPen);
		    DeleteObject(hPen1);
		    DeleteObject(hBrush);
		    break;
	       case FILLEDCIRCLE:
		    PlaySound(28);
		    pCursor = MAKEPOINT(lParam);
		    hdc = GetDC(hWnd);
		    oldpal = SelectPalette(hdc, hwndpal, FALSE);
		    RealizePalette(hdc);
		    SetROP2(hdc,R2_XORPEN);
		    hOurPen = CreatePen(PS_SOLID,1,WHITE);
		    hPen1 = CreatePen(PS_SOLID,1,CurrentColor | 0x2000000L);
		    hop = SelectObject(hdc,hOurPen);
		    logbrush.lbStyle = BS_HOLLOW;
		    hBrush = CreateBrushIndirect(&logbrush);
		    hobr = SelectObject(hdc,hBrush);
		    Ellipse(hdc,oldx,oldy,xwas,ywas);
		    SelectObject(hdc,hop);
		    SelectObject(hdc,hobr);
		    hop = SelectObject(hdc,hPen1);
		    SetROP2(hdc,R2_COPYPEN);
		    hBrush1 = CreateSolidBrush(CurrentColor | 0x2000000L);
                    hobr = SelectObject(hdc, hBrush1);
		    Ellipse(hdc,oldx,oldy,pCursor.x,pCursor.y);
		    SelectObject(hdc,hop);
		    SelectObject(hdc,hobr);
		    SelectPalette(hdc, oldpal, FALSE);
		    ReleaseDC(hWnd,hdc);
		    DeleteObject(hOurPen);
		    DeleteObject(hPen1);
		    DeleteObject(hBrush);
		    DeleteObject(hBrush1);
		    break;
	       case TRIANGLE:
		    PlaySound(16);
		    pCursor = MAKEPOINT(lParam);
		    hdc = GetDC(hWnd);
		    oldpal = SelectPalette(hdc, hwndpal, FALSE);
		    RealizePalette(hdc);
		    SetROP2(hdc,R2_XORPEN);
		    hOurPen = CreatePen(PS_SOLID,1,WHITE);
		    hop = SelectObject(hdc,hOurPen);
                    // old triangle
		    if(oldx > xwas)
		       halfx = ((oldx - xwas) / 2) + xwas;
		    else
		       halfx = ((xwas - oldx) / 2) + oldx;
		    Line(hdc,oldx,ywas,xwas,ywas);
		    Line(hdc,oldx, ywas, halfx, oldy);
		    Line(hdc,halfx,oldy,xwas,ywas);
		    SelectObject(hdc,hop);

                    // new one
		    if(pCursor.x > oldx)
		       halfx = ((pCursor.x - oldx) / 2) + oldx;
		    else
		       halfx = ((oldx - pCursor.x) / 2) + pCursor.x;
		    SetROP2(hdc,R2_COPYPEN);
		    hPen1 = CreatePen(PS_SOLID,DrawWidth,CurrentColor | 0x2000000L);
		    hop = SelectObject(hdc,hPen1);
		    Line(hdc,oldx,pCursor.y,pCursor.x,pCursor.y);
		    Line(hdc,oldx, pCursor.y, halfx, oldy);
		    Line(hdc,halfx,oldy,pCursor.x,pCursor.y);
		    SelectObject(hdc,hop);
		    SelectPalette(hdc, oldpal, FALSE);
		    ReleaseDC(hWnd,hdc);
		    DeleteObject(hOurPen);
		    DeleteObject(hPen1);
		    break;
	       case FILLEDTRIANGLE:
		    PlaySound(94);
		    pCursor = MAKEPOINT(lParam);
		    hdc = GetDC(hWnd);
		    oldpal = SelectPalette(hdc, hwndpal, FALSE);
		    RealizePalette(hdc);
		    SetROP2(hdc,R2_XORPEN);
		    hOurPen = CreatePen(PS_SOLID,1,WHITE);
		    hop = SelectObject(hdc,hOurPen);
                    // old triangle
		    if(oldx > xwas)
		       halfx = ((oldx - xwas) / 2) + xwas;
		    else
		       halfx = ((xwas - oldx) / 2) + oldx;
		    Line(hdc,oldx,ywas,xwas,ywas);
		    Line(hdc,oldx, ywas, halfx, oldy);
		    Line(hdc,halfx,oldy,xwas,ywas);
                    // new one
		    if(pCursor.x > oldx)
		       halfx = ((pCursor.x - oldx) / 2) + oldx;
		    else
		       halfx = ((oldx - pCursor.x) / 2) + pCursor.x;
		    SetROP2(hdc,R2_COPYPEN);
		    SelectObject(hdc,hop);
		    hPen1 = CreatePen(PS_SOLID,DrawWidth,CurrentColor | 0x2000000L);
		    hop = SelectObject(hdc,hPen1);
		    polypoint[0].x = oldx;
		    polypoint[0].y = pCursor.y;
		    polypoint[1].x = halfx;
		    polypoint[1].y = oldy;
		    polypoint[2].x = pCursor.x;
		    polypoint[2].y = pCursor.y;
		    polypoint[3].x = oldx;
		    polypoint[3].y = pCursor.y;
		    hBrush = CreateSolidBrush(CurrentColor | 0x2000000L);
                    hobr = SelectObject(hdc, hBrush);
		    Polygon(hdc,polypoint,4);
		    SelectObject(hdc,hop);
		    SelectObject(hdc,hobr);
		    SelectPalette(hdc, oldpal, FALSE);
		    ReleaseDC(hWnd,hdc);
		    DeleteObject(hOurPen);
		    DeleteObject(hPen1);
		    DeleteObject(hBrush);
		    break;
	       case SMALLERASER:
		    hdc = GetDC(hWnd);
		    oldpal = SelectPalette(hdc, hwndpal, FALSE);
		    RealizePalette(hdc);
		    hOurPen = CreatePen(PS_SOLID,1,WHITE);
		    x = oldx - 10;
		    y = oldy - 10;
		    hop = SelectObject(hdc,hOurPen);
		    Box(hdc,x,y,x+20,y+20);
		    SelectObject(hdc,hop);
		    SelectPalette(hdc, oldpal, FALSE);
		    ReleaseDC(hWnd,hdc);
		    DeleteObject(hOurPen);
		    break;
	       case LARGEERASER:
		    hdc = GetDC(hWnd);
		    oldpal = SelectPalette(hdc, hwndpal, FALSE);
		    RealizePalette(hdc);
		    hOurPen = CreatePen(PS_SOLID,1,WHITE);
		    x = oldx - 20;
		    y = oldy - 20;
		    hop = SelectObject(hdc,hOurPen);
		    Box(hdc,x,y,x+40,y+40);
		    SelectObject(hdc,hop);
		    SelectPalette(hdc, oldpal, FALSE);
		    ReleaseDC(hWnd,hdc);
		    DeleteObject(hOurPen);
		    break;
	       case MULTIPOLY:
		    PlaySound(59);
		    pCursor = MAKEPOINT(lParam);
		    hdc = GetDC(hWnd);
		    oldpal = SelectPalette(hdc, hwndpal, FALSE);
		    RealizePalette(hdc);
		    hOurPen = CreatePen(PS_SOLID,1,CurrentColor | 0x2000000L);
		    hop = SelectObject(hdc,hOurPen);
		    Line(hdc,oldx,oldy,pCursor.x,pCursor.y);
	            oldx = pCursor.x;
		    oldy = pCursor.y;
		    polypoint[polycount].x = oldx;
		    polypoint[polycount].y = oldy;
		    hBrush = CreateSolidBrush(CurrentColor | 0x2000000L);
                    hobr = SelectObject(hdc, hBrush);
		    Polygon(hdc,polypoint,polycount);
		    SelectObject(hdc,hop);
		    SelectObject(hdc,hobr);
		    SelectPalette(hdc, oldpal, FALSE);
		    ReleaseDC(hWnd,hdc);
		    DeleteObject(hOurPen);
		    DeleteObject(hBrush);
		    break;
	       case KNIFE:
		    pCursor = MAKEPOINT(lParam);
		    hdc = GetDC(hWnd);
		    oldpal = SelectPalette(hdc, hwndpal, FALSE);
		    RealizePalette(hdc);
	            hOurPen = CreatePen(PS_SOLID,1,WHITE);
		    hop = SelectObject(hdc,hOurPen);
		    Line(hdc,oldx,oldy,pCursor.x,pCursor.y);
	            oldx = pCursor.x;
		    oldy = pCursor.y;
		    polypoint[polycount].x = oldx;
		    polypoint[polycount].y = oldy;
		    hBrush = CreateSolidBrush(WHITE);
                    hobr = SelectObject(hdc, hBrush);
		    Polygon(hdc,polypoint,polycount);
		    SelectObject(hdc,hop);
		    SelectObject(hdc,hobr);
		    SelectPalette(hdc, oldpal, FALSE);
		    ReleaseDC(hWnd,hdc);
		    DeleteObject(hOurPen);
		    DeleteObject(hBrush);
		    break;
	    }
	    break;
      default:
	   return(DefWindowProc(hWnd, message, wParam, lParam));
   }
   return(0L);
}


void ColorAssign(void)
{
     aColor[0] = RED2;
     aColor[1] = RED;
     aColor[2] = RED1;
     aColor[3] = DKRED;
     aColor[4] = BLUE; 
     aColor[5] = BLUE1;
     aColor[6] = DKBLUE;
     aColor[7] = GREEN;
     aColor[8] = GREEN1;
     aColor[9] = DKGREEN;
     aColor[10] = CYAN;
     aColor[11] = CYAN1;
     aColor[12] = DKCYAN;
     aColor[13] = MAGENTA;
     aColor[14] = MAGENTA1;
     aColor[15] = DKMAGENTA;
     aColor[16] = YELLOW;
     aColor[17] = YELLOW1;
     aColor[18] = DKYELLOW;
     aColor[19] = WHITE;
     aColor[20] = GRAY;
     aColor[21] = DKGRAY;
     aColor[22] = BLACK;
     aColor[23] = BROWN;
     aColor[24] = BROWN1;
     aColor[25] = DKBROWN;
     aColor[26] = TURQUOISE;
     aColor[27] = TURQUOISE1;
     aColor[28] = DKTURQUOISE;
     aColor[29] = ORANGE;
     aColor[30] = ORANGE1;
     aColor[31] = DKORANGE;
     aColor[32] = ORANGE2;
}

//*******************************************************************
//                handles messages for this application
//*******************************************************************
LRESULT CALLBACK PaintWndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
    HDC              hdc;
    RECT             rct;
    DWORD            res;
    WORD             wDeviceID;
    POINT            pCursor;
    HBRUSH           hBrush, hobr;
    WNDCLASS         secondclass;
    int              i,j;
    static HWND      hwnd1, hwnd2, hwnd3, hwnd4, hwnd5, hwnd6, hwnd7;
    char             buf[20], savethreshtext[80], cindrive, coutdrive;
    unsigned char    c;
    PLOGPALETTE      plp;
    LOCALHANDLE      lh;
    HPALETTE         oldpal;
    HPEN             hop;
    static HICON     hIcon1, hIcon2, hIcon3, hIcon4, hIcon5, hIcon6, hIcon7;


    switch (message){
	case WM_CREATE:
	     ColorAssign();
	     lh = LocalAlloc(LMEM_MOVEABLE,sizeof(LOGPALETTE) * 33 * sizeof(PALETTEENTRY));
	     plp = (PLOGPALETTE)LocalLock(lh);
	     plp->palVersion = 0x300;
	     plp->palNumEntries = 33;
	     for(i = 0; i < 33; i++){
		 plp->palPalEntry[i].peRed = GetRValue(aColor[i]);
		 plp->palPalEntry[i].peGreen = GetGValue(aColor[i]);
		 plp->palPalEntry[i].peBlue =  GetBValue(aColor[i]);
		 plp->palPalEntry[i].peFlags = 0;
	     }
	     hwndpal = CreatePalette(plp);
	     LocalUnlock(lh);
	     LocalFree(lh);

             savelevel = 6000000L;      // default to 6 megs

	     // look for the INI file showing us where we'll be
	     // working from. The install program will need to be
             // smart enough to set this up...
	     GetPrivateProfileString("PAINT","directoryin","n",ourdir,80,"KA.INI");
	     GetPrivateProfileString("PAINT","directoryout","n",outdir,80,"KA.INI");
	     GetPrivateProfileString("PAINT","savethreshold","n",savethreshtext,80,"KA.INI");
	     // Determine the minimum amount of memory one must have to
	     // legally save a picture. We let K.A. determine their optimum
	     // setting via the INI file and follow this. Their value
	     // will be an integer that represents 'K'.  
	     savelevel = atol(savethreshtext) * 1024;
	     cindrive = toupper(ourdir[0]);
	     coutdrive = toupper(outdir[0]);

	     indrive = cindrive - 65;
             outdrive = coutdrive - 65;

	     i = lstrlen(ourdir);
	     // ...but never trust ANYONE. If the install screwed up, we have
             // to figure out where we were launched from.
	     if(i < 2) FindOurDirectory();

             // the CLOSE button ALWAYS gets drawn.
	     hwnd1 = CreateWindow ("button", "&Close",
			   WS_CHILD| WS_VISIBLE| BS_PUSHBUTTON | BS_OWNERDRAW,
			   hres - 66, 0, 66, 50,
			   hWnd, (HMENU)IDBT_CLEAR, hInst, NULL);

	     if(colorbook == FALSE){
                // these get drawn when not in colorbook mode
	        hwnd2 = CreateWindow ("button", "Draw",
			   WS_CHILD| WS_VISIBLE| BS_PUSHBUTTON | BS_OWNERDRAW,
			   0, 180, 50, 50,
			   hWnd, (HMENU)IDBT_SNDPLAY, hInst, NULL);

	        hwnd3 = CreateWindow ("button", "Erase",
			   WS_CHILD| WS_VISIBLE| BS_PUSHBUTTON | BS_OWNERDRAW,
			   0, 230, 50, 50,
	                   hWnd, (HMENU)IDBT_MCICMD, hInst, NULL);

	        hwnd4 = CreateWindow ("button", "F/X",
			   WS_CHILD| WS_VISIBLE| BS_PUSHBUTTON | BS_OWNERDRAW,
			   0, 280, 50, 50,
			   hWnd, (HMENU)IDBT_MCISTR, hInst, NULL);

	        hwnd5 = CreateWindow ("button", "Text",
			   WS_CHILD| WS_VISIBLE| BS_PUSHBUTTON | BS_OWNERDRAW,
			   0, 330, 50, 50,
			   hWnd, (HMENU)IDBT_TEXT, hInst, NULL);

	        hwnd6 = CreateWindow ("button", "Misc.",
			   WS_CHILD| WS_VISIBLE| BS_PUSHBUTTON | BS_OWNERDRAW,
			   0, 380, 50, 50,
			   hWnd, (HMENU)IDBT_STAMP, hInst, NULL);

	        hwnd7 = CreateWindow ("button", "Stamps",
			   WS_CHILD| WS_VISIBLE| BS_PUSHBUTTON | BS_OWNERDRAW,
			   0, 430, 50, 50,
			   hWnd, (HMENU)IDBT_MISC, hInst, NULL);

		if(hres < 680){
		   j = 33;
                }
		else{
                   j = 66;
		}
		hwnd8 = CreateWindow ("button", "undo",
			   WS_CHILD| WS_VISIBLE| BS_PUSHBUTTON | BS_OWNERDRAW,
			   541, 0, j, 50,
			   hWnd, (HMENU)IDBT_UNDO, hInst, NULL);


     	        hIcon1 = LoadIcon(hInst,"ICON_42");
                hIcon2 = LoadIcon(hInst,"ICON_43");
                hIcon3 = LoadIcon(hInst,"ICON_44");
                hIcon4 = LoadIcon(hInst,"ICON_45");
                hIcon5 = LoadIcon(hInst,"ICON_46");
		hIcon6 = LoadIcon(hInst,"ICON_47");
		hIcon7 = LoadIcon(hInst,"ICON_125");
	     }

	     // choose the return button image shown to the user

	     switch(kabitmapID){
		case 1:
		     kabitmap = LoadBitmap(hInst,"BITMAP_1");
		     break;
		case 2:
		     kabitmap = LoadBitmap(hInst,"BITMAP_2");
		     break;
		case 3:
		     kabitmap = LoadBitmap(hInst,"BITMAP_3");
		     break;
		case 4:
		     kabitmap = LoadBitmap(hInst,"BITMAP_4");
		     break;
		case 5:
		     kabitmap = LoadBitmap(hInst,"BITMAP_5");
		     break;
		case 6:
		     kabitmap = LoadBitmap(hInst,"BITMAP_6");
		     break;
		case 7:
		     kabitmap = LoadBitmap(hInst,"BITMAP_7");
		     break;
		case 8:
		     kabitmap = LoadBitmap(hInst,"BITMAP_8");
		     break;
		case 9:
		     kabitmap = LoadBitmap(hInst,"BITMAP_9");
		     break;
		case 10:
		     kabitmap = LoadBitmap(hInst,"BITMAP_10");
		     break;
             }

             // define various variables we'll be using
	     buttondown = FALSE;
	     DrawTool = SPRAYCAN;
	     DrawWidth = 1;
	     numfiles = 1;
	     Thumbnails = FALSE;
	     DoingText = FALSE;
	     ReadyToDoText = FALSE;
             firstpaint = TRUE;
	     randomize();
	     CurrentColor = RED1;
	     stupidpointer = FALSE;
             stampsmear = TRUE;

	     // sound resources

	     chthedir(IN);
	     fp=fopen("stamp1.wav","r");
	     fgets(stampwav[0],1500,fp);
	     fclose(fp);
	     fp=fopen("stamp2.wav","r");
	     fgets(stampwav[1],1500,fp);
	     fclose(fp);
	     fp=fopen("stamp3.wav","r");
	     fgets(stampwav[2],1500,fp);
	     fclose(fp);
	     fp=fopen("stamp4.wav","r");
	     fgets(stampwav[3],1500,fp);
	     fclose(fp);
	     fp=fopen("stamp5.wav","r");
	     fgets(stampwav[4],1500,fp);
	     fclose(fp);
	     fp=fopen("stamp6.wav","r");
	     fgets(stampwav[5],1500,fp);
	     fclose(fp);
	     fp=fopen("stamp7.wav","r");
	     fgets(stampwav[6],1500,fp);
	     fclose(fp);
	     fp=fopen("stamp8.wav","r");
	     fgets(stampwav[7],1500,fp);
	     fclose(fp);
	     fp=fopen("spray2.wav","r");
	     fgets(spraywav,1500,fp);
	     fclose(fp);

             // create the window we actually paint in
	     secondclass.style         = CS_HREDRAW | CS_VREDRAW;
	     secondclass.lpfnWndProc   = PWinProc;
	     secondclass.cbClsExtra    = 0;
             secondclass.cbWndExtra    = 0;
             secondclass.hInstance     = hInst;
	     secondclass.hIcon         = NULL;
             secondclass.hCursor       = LoadCursor(hInst,IDC_ARROW);
	     secondclass.hbrBackground = GetStockObject(WHITE_BRUSH);
             secondclass.lpszClassName = "secondclass";
	     secondclass.lpszMenuName  = NULL;

	     RegisterClass(&secondclass);

	     phwnd = CreateWindow("secondclass",    // window class name
                        "title",                       //  window title
			WS_BORDER | WS_CHILD | WS_VISIBLE,
			50,                      // upper left x
			50,                      // upper left y
			hres - 50,                    // width
			vres - 50,                    // height
			hWnd,               // parent for this window
			NULL,                   // use the class menu
			hInst,             // who created this window
                        NULL                    // no parms to pass on
			);
	     ShowWindow(phwnd, SW_SHOW);

	     return(DefWindowProc(hWnd, message, wParam, lParam));

	case WM_DRAWITEM:
	     if(((LPDRAWITEMSTRUCT)lParam)->CtlID == IDBT_SNDPLAY)
		  WndDrawIconButton((LPDRAWITEMSTRUCT)lParam,hIcon1);
	     if(((LPDRAWITEMSTRUCT)lParam)->CtlID == IDBT_MCICMD)
		  WndDrawIconButton((LPDRAWITEMSTRUCT)lParam,hIcon2);
	     if(((LPDRAWITEMSTRUCT)lParam)->CtlID == IDBT_MCISTR)
		  WndDrawIconButton((LPDRAWITEMSTRUCT)lParam,hIcon3);
	     if(((LPDRAWITEMSTRUCT)lParam)->CtlID == IDBT_TEXT)
		  WndDrawIconButton((LPDRAWITEMSTRUCT)lParam,hIcon4);
	     if(((LPDRAWITEMSTRUCT)lParam)->CtlID == IDBT_STAMP)
		  WndDrawIconButton((LPDRAWITEMSTRUCT)lParam,hIcon5);
	     if(((LPDRAWITEMSTRUCT)lParam)->CtlID == IDBT_MISC)
		  WndDrawIconButton((LPDRAWITEMSTRUCT)lParam,hIcon6);
	     if(((LPDRAWITEMSTRUCT)lParam)->CtlID == IDBT_CLEAR)
		  WndDrawBitmapButton((LPDRAWITEMSTRUCT)lParam,kabitmap);
	     if(((LPDRAWITEMSTRUCT)lParam)->CtlID == IDBT_UNDO)
		  WndDrawIconButton((LPDRAWITEMSTRUCT)lParam,hIcon7);
             Thumbnails = FALSE;
	     break;
	    case WM_CHAR:
                 if(DoingText == TRUE){
		    c = wParam;
		    if(c > 96 && c < 123) c -= 32;    // make sure it's a capital letter,
					   // per Amory Gabel 9/14/94
		    if((c > 31 && c < 127) || c == 13 || c == 8)
		       ShowText(c);
		 }
		 break;
	    case WM_COMMAND:
		 if(DoingText == TRUE) cleanuptext();
		 ReadyToDoText = FALSE;
		 if(colorbook == FALSE) ShowWindow(hwnd8,SW_SHOWNA);
	         switch (wParam){
		      case IDBT_CLEAR:
			   PlaySound(42);
                           if(colorbook == FALSE){
			      DestroyIcon(hIcon7);
			      DestroyIcon(hIcon6);
			      DestroyIcon(hIcon5);
			      DestroyIcon(hIcon4);
			      DestroyIcon(hIcon3);
			      DestroyIcon(hIcon2);
			      DestroyIcon(hIcon1);
                           }
			   DestroyWindow(hWnd);
		           break;
		      case IDBT_SNDPLAY:
			   DrawTools1();
			   SaveToUndoPic();
		           break;
		      case IDBT_MCISTR:
			   DrawTools5();
			   SaveToUndoPic();
		           break;
		      case IDBT_MCICMD:
			   DrawTools4();
			   SaveToUndoPic();
		           break;
		      case IDBT_MISC:
			   DrawTools6();
                           LineSet = FALSE;
			   ShowWindow(hwnd8,SW_HIDE);
			   SaveToUndoPic();
			   break;
		      case IDBT_TEXT:
			   PlaySound(7);
                           HorizDitherPattern();
			   ReadyToDoText = TRUE;
                           DrawTool = NONE;
			   SaveToUndoPic();
			   break;
		      case IDBT_STAMP:
			   DrawIcons(random(7) + 7);
			   SaveToUndoPic();
			   break;
		      case IDBT_UNDO:
			   hdc = GetDC(phwnd);
			   oldpal = SelectPalette(hdc, hwndpal, FALSE);
			   RealizePalette(hdc);
                           PlaySound(2);
			   BitBlt(hdc,0,0,hres-50,vres-50,undodc,0,0,SRCCOPY);
                           SelectPalette(hdc, oldpal, FALSE);
			   ReleaseDC(phwnd,hdc);
                           break;
		      default:
		           break;
	         }
		 break;
	    case WM_PAINT:
		 DoPaint();
		 if(colorbook == FALSE){
                    if(firstpaint == TRUE){
		       DrawTools1();
		       firstpaint = FALSE;
		    }
		 }
		 else{
		    // If there are more than 5 colorbook pictures,
		    // colorbmpname[5] will have a valid name inside.
		    // In that case, what we want to do is show the
		    // change icon...
		    if(strlen(colorbmpname[5]) < 4)
		       BlankIconArea(0);
		    else
		       BlankIconArea(1);
		    ColorTool(0);
		    DrawTool = COLORBOOK1;
                    colorset = 1;
		    ColorBookPics(1);
		    LineSet = FALSE;
		 }
		 break;
	    case WM_LBUTTONDOWN:
		 if(DoingText == TRUE){
		    cleanuptext();
		    break;
		 }
                 if(ReadyToDoText == TRUE){
		    ReadyToDoText = FALSE;
                    DrawTools1();
		    break;
		 }
                 // Look for the user to choose a color...
		 pCursor = MAKEPOINT(lParam);
                 if(colorbook == FALSE){
    	            if((pCursor.x < 50) && (pCursor.y < 160)){
			hdc = GetDC(hWnd);
		        oldpal = SelectPalette(hdc, hwndpal, FALSE);
			RealizePalette(hdc);
		        CurrentColor = GetPixel(hdc,pCursor.x,pCursor.y) | 0x2000000L;
                        // and then draw the color picked.
		        hBrush = CreateSolidBrush(CurrentColor | 0x2000000L);
		        hOurPen = CreatePen(PS_SOLID,1,WHITE);
                        hop = SelectObject(hdc, hOurPen);
		        hobr = SelectObject(hdc,hBrush);
			Rectangle(hdc,3,163,47,177);
			SelectObject(hdc,hop);
		        SelectObject(hdc,hobr);
		        SelectPalette(hdc, oldpal, FALSE);
		        ReleaseDC(hWnd,hdc);
		        DeleteObject(hBrush);
			DeleteObject(hOurPen);
		        SaveToUndoPic();
		        break;
		    }
                 }
		 else{
		    if((pCursor.x < 50) && (pCursor.y < 320)){
		        hdc = GetDC(hWnd);
		        oldpal = SelectPalette(hdc, hwndpal, FALSE);
			RealizePalette(hdc);
                        if(GetPixel(hdc,pCursor.x,pCursor.y) != BLACK){
		           CurrentColor = GetPixel(hdc,pCursor.x,pCursor.y) | 0x2000000L;
                           // and then draw the color picked.
		           hBrush = CreateSolidBrush(CurrentColor | 0x2000000L);
		           hOurPen = CreatePen(PS_SOLID,1,WHITE);
                           hop = SelectObject(hdc, hOurPen);
		           hobr = SelectObject(hdc,hBrush);
			   Rectangle(hdc,3,323,47,337);
			}
			SelectObject(hdc,hop);
		        SelectObject(hdc,hobr);
			SelectPalette(hdc, oldpal, FALSE);
		        ReleaseDC(hWnd,hdc);
			DeleteObject(hBrush);
                        DeleteObject(hOurPen);
		        SaveToUndoPic();
		        break;
		    }
		 }
		 if(colorbook == TRUE){
		    if(pCursor.y > 5 && pCursor.y < 40){
		       if(pCursor.x > 60 && pCursor.x < 120){
			  ColorBookPicked(0);
		          break;
		       }
		       if(pCursor.x > 140 && pCursor.x < 200){
			  ColorBookPicked(1);
		          break;
		       }
		       if(pCursor.x > 220 && pCursor.x < 280){
			  ColorBookPicked(2);
		          break;
		       }
		       if(pCursor.x > 300 && pCursor.x < 360){
			  ColorBookPicked(3);
			  break;
		       }
		       if(pCursor.x > 380 && pCursor.x < 440){
			  ColorBookPicked(4);
		          break;
		       }
		    } // if pCursor.y
		    if(pCursor.x > 5 && pCursor.x < 45){
		       if(pCursor.y > 340 && pCursor.y < 380){
			  ColorTool(0);
			  break;
		       }
		       if(pCursor.y > 380 && pCursor.y < 420){
			  ColorTool(1);
			  break;
                       }
		    }
		    if(pCursor.x > 475 && pCursor.x <= 515 &&
		       pCursor.y > 5 && pCursor.y < 45){
		       if(strlen(colorbmpname[5]) > 4){
			  BlankIconArea(1);
			  if(colorset == 1){
			     ColorBookPics(2);
			     colorset = 2;
			     break;
			  }
			  else{

			     ColorBookPics(1);
			     colorset = 1;
			     break;
                          }
		       }
		    }
		    // allow color books to print...
		    if(pCursor.x > 540 && pCursor.x < 580 &&
		       pCursor.y > 10 && pCursor.y < 40){
		       PrintIt();
		       break;
		    }
                    break;
		 } // if colorbook = true
                 if(Thumbnails == FALSE){
                    // look for a tool to be chosen
		    for(i = 58, j = 1; i < 341; i += 40, j++){
		        if(pCursor.x >= i && pCursor.x < i + 36 &&
		           pCursor.y >= 8 && pCursor.y < 44){
			   if(ToolSet == 1 || ToolSet == 2 ||
			      ToolSet == 3 || ToolSet == 5 || ToolSet > 6)
			      BoxAroundTool(j);
			   if(ToolSet == 4){
			      ExecuteErase(j);
			      break;
                           }
			   if(ToolSet == 6){
			      if(j < 6)
				 ExecuteDisk(j);
			      else
				 break;
                           }
                           break;
		        }
		    }

                    // look to choose a drawing linesize
                    if(LineSet == TRUE){
    		       for(i = 425, j = 1; i < 535; i += 20, j++){
			   if(pCursor.x >= i && pCursor.x < i + 10 &&
			      pCursor.y >= 10 && pCursor.y < 41){
			      DrawWidth = j;
			      DrawLineSet();
			      SaveToUndoPic();
                              memset(buf,20,'\0');                // get the buffer ready
			      chthedir(IN);
                              switch(DrawWidth){
            	                   case 1:
	                               strcpy(buf,"pencil1.wav");
	                               break;
	                           case 2:
	                               strcpy(buf,"pencil2.wav");
	                               break;
	                           case 3:
	                               strcpy(buf,"pencil3.wav");
	                               break;
	                           case 4:
	                               strcpy(buf,"pencil4.wav");
	                               break;
	                           case 5:
	                               strcpy(buf,"pencil5.wav");
	                               break;
	                           case 6:
	                               strcpy(buf,"pencil6.wav");
	                               break;
                              }
                              sndPlaySound(buf,SND_ASYNC);
			      break;
		           }
		       }  // for
		    }
                    if(ToolSet < 4 || ToolSet > 6){
		       if(pCursor.x > 370 && pCursor.x <= 390 &&
			  pCursor.y > 5 && pCursor.y < 45){
			  PlaySound(101);
			  PreviousToolSet();
			  break;
                       }
		       if(pCursor.x > 390 && pCursor.x < 410 &&
			  pCursor.y > 5 && pCursor.y < 45){
			  PlaySound(101);
			  NextToolSet();
			  break;
		       }
		    }
                    SaveToUndoPic();
                 }
		 else{
		    if(pCursor.y > 5 && pCursor.y < 40){
		       if(pCursor.x > 60 && pCursor.x < 120){
			  UserPickedMe(firstfileshown);
		          break;
		       }
		       if(pCursor.x > 140 && pCursor.x < 200){
		          UserPickedMe(firstfileshown + 1);
		          break;
		       }
		       if(pCursor.x > 220 && pCursor.x < 280){
		          UserPickedMe(firstfileshown + 2);
			  break;
		       }
		       if(pCursor.x > 300 && pCursor.x < 360){
		          UserPickedMe(firstfileshown + 3);
		          break;
		       }
		       if(pCursor.x > 380 && pCursor.x < 440){
		          UserPickedMe(firstfileshown + 4);
		          break;
		       }
		       if(pCursor.x > 480 && pCursor.x < 515){
			  MorePicsSelected();
		          break;
		       }
                    } // if pCursor.y
		 }
		 break;
	    case WM_SYSCOMMAND:
		 aflag = TRUE;
		 SaveToUndoPic();
		 return(DefWindowProc(hWnd, message, wParam, lParam));
	    case WM_DESTROY:
		 DeleteObject(kabitmap);
		 DeleteObject(hwndpal);
		 PostQuitMessage(0);   // this is the end...
		 break;
	    case WM_SETFOCUS:
		 if(aflag == TRUE){
		    if(colorbook == FALSE)
		       DrawTools1();
                    else
		       SendMessage(hWnd,WM_PAINT,NULL,NULL);
                    aflag = FALSE;
		 }
		 break;
	    case WM_CLOSE:
		 // Tell windows to destroy our window.
		 DestroyWindow(hWnd);
		 break;
	    default:
   	         // Let windows handle all messages we choose to ignore.
		 return(DefWindowProc(hWnd, message, wParam, lParam));
	}
	return(0L);
}

//*************************************************************************
// DoPaint -- this is the WM_PAINT action routine for the main window.
//*************************************************************************

void DoPaint()
{
    PAINTSTRUCT       PaintInfo;
    HDC               hDC;
    HBRUSH            hBrush, hBrush2, hBrush1[32], hobr;
    HPEN              hWhite, hpen, hBlack, hop;
    register int      i;
    COLORREF          tempcolor;
    HPALETTE          oldpal;
    

    BeginPaint(hWndMain, &PaintInfo);
    hDC = PaintInfo.hdc;
    oldpal = SelectPalette(hDC, hwndpal, FALSE);
    RealizePalette(hDC);
    hBrush = CreateSolidBrush(CurrentColor | 0x2000000L);
    hBrush2 = CreateSolidBrush(TURQUOISE1 | 0x2000000L);
    hobr = SelectObject(hDC,hBrush2);
    hpen = CreatePen(PS_SOLID,1,TURQUOISE1 | 0x2000000L);
    hop = SelectObject(hDC,hpen);
    Rectangle(hDC,0,0,hres,vres);
    SelectObject(hDC,hop);
    hBlack = CreatePen(PS_SOLID,1,BLACK);
    hop = SelectObject(hDC,hBlack);
    SelectObject(hDC,hobr);
    // create some brushes to paint the color boxes
    if(colorbook == FALSE){
       // AMORY! this is where you get to put in whatever colors you want.
       hBrush1[0] = CreateSolidBrush(aColor[0] | 0x2000000L);
       hBrush1[1] = CreateSolidBrush(aColor[2] | 0x2000000L);
       hBrush1[2] = CreateSolidBrush(aColor[4] | 0x2000000L);
       hBrush1[3] = CreateSolidBrush(aColor[6] | 0x2000000L);
       hBrush1[4] = CreateSolidBrush(aColor[8] | 0x2000000L);
       hBrush1[5] = CreateSolidBrush(aColor[10] | 0x2000000L);
       hBrush1[6] = CreateSolidBrush(aColor[32] | 0x2000000L);
       hBrush1[7] = CreateSolidBrush(aColor[14] | 0x2000000L);
       hBrush1[8] = CreateSolidBrush(aColor[16] | 0x2000000L);
       hBrush1[9] = CreateSolidBrush(aColor[18] | 0x2000000L);
       hBrush1[10] = CreateSolidBrush(aColor[20] | 0x2000000L);
       hBrush1[11] = CreateSolidBrush(aColor[22] | 0x2000000L);
       hBrush1[12] = CreateSolidBrush(aColor[24] | 0x2000000L);
       hBrush1[13] = CreateSolidBrush(aColor[26] | 0x2000000L);
       hBrush1[14] = CreateSolidBrush(aColor[28] | 0x2000000L);
       hBrush1[15] = CreateSolidBrush(aColor[30] | 0x2000000L);
       for(i = 0; i <= 7; i++){
           hobr = SelectObject(hDC,hBrush1[i]);
	   Rectangle(hDC,0,i * 20,25,(i * 20) + 20);
	   SelectObject(hDC,hobr);
	   hobr = SelectObject(hDC,hBrush1[i + 8]);
	   Rectangle(hDC,25,i * 20,50,(i * 20) + 20);
	   SelectObject(hDC,hobr);
       }
       // and the current color
       SelectObject(hDC,hop);
       hWhite = CreatePen(PS_SOLID,1,WHITE);
       hop = SelectObject(hDC, hWhite);
       hobr = SelectObject(hDC,hBrush);
       Rectangle(hDC,3,163,47,177);
       SelectObject(hDC,hop);
       SelectObject(hDC,hobr);
       SelectPalette(hDC, oldpal, FALSE);
       EndPaint(hWndMain, &PaintInfo);
       // and get rid of all the brushes
       DeleteObject(hBrush);
       DeleteObject(hBrush2);
       DeleteObject(hWhite);
       DeleteObject(hBlack);
       DeleteObject(hpen);
       for(i = 0; i < 16; i++) DeleteObject(hBrush1[i]);
    }
    else{
       tempcolor = aColor[22];       // save black
       aColor[22] = aColor[32];      // substitute orange
       aColor[32] = tempcolor;       // set 32 == black
       for(i = 0; i < 32; i++)
	   hBrush1[i] = CreateSolidBrush(aColor[i] | 0x2000000L);
       // fill the color boxes
       for(i = 0; i <= 15; i++){
           hobr = SelectObject(hDC,hBrush1[i]);
	   Rectangle(hDC,0,i * 20,25,(i * 20) + 20);
	   SelectObject(hDC,hobr);
	   hobr = SelectObject(hDC,hBrush1[i + 16]);
	   Rectangle(hDC,25,i * 20,50,(i * 20) + 20);
	   SelectObject(hDC,hobr);
       }
       // and the current color
       SelectObject(hDC,hop);
       hWhite = CreatePen(PS_SOLID,1,WHITE);
       hop = SelectObject(hDC, hWhite);
       hobr = SelectObject(hDC,hBrush);
       Rectangle(hDC,3,323,47,337);
       SelectObject(hDC,hop);
       SelectObject(hDC,hobr);
       tempcolor = aColor[22];      // save orange
       aColor[22] = aColor[32];     // restore black
       aColor[32] = tempcolor;      // and so on...
       SelectPalette(hDC, oldpal, FALSE);
       EndPaint(hWndMain, &PaintInfo);
       // and get rid of all the brushes
       DeleteObject(hBrush);
       DeleteObject(hBrush2);
       DeleteObject(hWhite);
       DeleteObject(hBlack);
       DeleteObject(hpen);
       for(i = 0; i < 32; i++) DeleteObject(hBrush1[i]);
    }
    if(firsttime == FALSE){
        hDC = GetDC(phwnd);
        oldpal = SelectPalette(hDC, hwndpal, FALSE);
	RealizePalette(hDC);
	BitBlt(hDC,0,0,hres-50,vres-50,undodc,0,0,SRCCOPY);
	SelectPalette(hDC, oldpal, FALSE);
	ReleaseDC(phwnd, hDC);
    }
}

// Primitive to draw a line
void Line(HDC hdc, int X1, int Y1, int X2, int Y2)
{
     MoveTo(hdc,X1,Y1);
     LineTo(hdc,X2,Y2);
}

// Primitive to draw an unfilled box
void Box(HDC hdc, int X1, int Y1, int X2, int Y2)
{
     Line(hdc, X1,Y1,X2,Y1);
     Line(hdc, X1,Y1,X1,Y2);
     Line(hdc, X1,Y2,X2,Y2);
     Line(hdc, X2,Y1,X2,Y2);
}

//*******************************************************************
// BoxAroundTool -- this routine is responsible for responding to
// a request to select a new tool. First, we draw a gray box around
// the currently selected tool. Second, we draw a red box around the
// tool we wish to use. Third, we determine from the toolset selected
// what to do, such as changing the drawing tool and so on.
//********************************************************************
 
void BoxAroundTool(int NewBoxPos)
{

#define BACKCOLOR      TURQUOISE1

     HDC               hDC;
     HPEN              hPen1, hPen2, hop;
     int               X1;
     HPALETTE          oldpal;

     if(NewBoxPos == CurrentBoxPos) return;
     if(aflag == FALSE) SaveToUndoPic();
     hDC = GetDC(hWndMain);
     oldpal = SelectPalette(hDC, hwndpal, FALSE);
     RealizePalette(hDC);
     hPen1 = CreatePen(PS_SOLID,2,BACKCOLOR | 0x2000000L);
     hop = SelectObject(hDC,hPen1);
     // draw a new box around the old tool
     X1 = ((CurrentBoxPos - 1) * 40) + 58;
     Box(hDC,X1,8,X1 + 36,44);
     SelectObject(hDC,hop);
     hPen2 = CreatePen(PS_SOLID,2,RED | 0x2000000L);
     hop = SelectObject(hDC,hPen2);
     // draw a new RED box around the new tool
     X1 = ((NewBoxPos - 1) * 40) + 58;
     Box(hDC,X1,8,X1 + 36,44);
     SelectObject(hDC,hop);
     // and clean up
     SelectPalette(hDC, oldpal, FALSE);
     ReleaseDC(hWndMain,hDC);
     DeleteObject(hPen1);
     DeleteObject(hPen2);
     CurrentBoxPos = NewBoxPos;
     switch(ToolSet){
	case 1:         // drawing tools #1
	   switch(NewBoxPos){
	      case 1:
		 DrawTool = PENCIL;
                 DrawLineSet();
		 break;
	      case 2:
		 DrawTool = BUCKET;
                 DrawNoSet();
		 break;
	      case 3:
		 DrawTool = SPRAYCAN;
                 DrawLineSet();
		 break;
	      case 4:
		 DrawTool = LINE;
		 DrawLineSet();
		 break;
	      case 5:
		 DrawTool = RECTANGLE;
                 DrawLineSet();
		 break;
	      case 6:
		 DrawTool = CIRCLE;
		 DrawLineSet();
                 break;
	      case 7:
		 DrawTool = FILLEDRECTANGLE;
		 DrawNoSet();
                 break;
	      case 8:
		 DrawTool = FILLEDCIRCLE;
		 DrawNoSet();
		 break;
	   } // switch NewBoxPos
	   break;
	case 3:         // drawing tools #3
	   switch(NewBoxPos){
	      case 1:
		 DrawTool = ZIGZAG;
                 DrawLineSet();
		 break;
	      case 2:
		 DrawTool = COLORDOT;
                 DrawNoSet();
		 break;
	      case 3:
		 DrawTool = CHALK;
                 DrawNoSet();
		 break;
	      case 4:
		 DrawTool = LINEA;
                 DrawLineSet();
		 break;
	      case 5:
		 DrawTool = LINEB;
                 DrawLineSet();
		 break;
	      case 6:
		 DrawTool = LINEC;
		 DrawLineSet();
                 break;
	      case 7:
		 DrawTool = LINED;
		 DrawLineSet();
                 break;
	      case 8:
		 DrawTool = PROPELLER;
		 DrawNoSet();
		 break;
	   }
           break;
	case 2:         // drawing tools #2
	   switch(NewBoxPos){
	      case 1:
		 DrawTool = TRIANGLE;
		 DrawLineSet();
		 break;
	      case 2:
		 DrawTool = FILLEDTRIANGLE;
                 DrawNoSet();
		 break;
	      case 3:
		 DrawTool = QUILLPEN;
                 DrawNoSet();
		 break;
	      case 4:
		 DrawTool = CHARCOALPENCIL;
                 DrawNoSet();
		 break;
	      case 5:
		 DrawTool = GOOFYLINE;
                 DrawLineSet();
		 break;
	      case 6:
		 DrawTool = MULTIPOLY;
		 DrawNoSet();
                 break;
	      case 7:
		 DrawTool = SMALLERASER;
		 DrawNoSet();
                 break;
	      case 8:
		 DrawTool = LARGEERASER;
		 DrawNoSet();
		 break;
	   } // switch NewBoxPos
           break;
        case 5:         // FX tools
	   switch(NewBoxPos){
	      case 1:
		 DrawTool = SCISSORS;
		 DrawNoSet();
		 break;
	      case 2:
		 DrawTool = KNIFE;
                 DrawNoSet();
		 break;
	      case 3:
		 DrawTool = FLIPH;
                 DrawNoSet();
		 break;
	      case 4:
		 DrawTool = FLIPV;
                 DrawNoSet();
		 break;
	      case 5:
		 DrawTool = NONE;
		 DrawNoSet();
		 InvertPic();
		 DrawTools1();
		 break;
	      case 6:
		 DrawTool = NONE;
		 DrawNoSet();
		 StretchPic();
		 DrawTools1();
                 break;
	      case 7:
		 DrawTool = NONE;
		 DrawNoSet();
		 ShrinkPic();
		 DrawTools1();
                 break;
	      case 8:
		 DrawTool = NONE;
		 DrawNoSet();
		 TransmogrifyColor();
                 DrawTools1();
		 break;
	   } // switch NewBoxPos
	   break;
	case 7:         // icon stamps #1
	   switch(NewBoxPos){
	      case 1:
		 TheIcon = LoadIcon(hInst,"ICON_52");
		 DrawNoSet();
		 PlaySound(79);
		 break;
	      case 2:
		 TheIcon = LoadIcon(hInst,"ICON_53");
		 DrawNoSet();
		 PlaySound(54);
		 break;
	      case 3:
		 TheIcon = LoadIcon(hInst,"ICON_54");
		 DrawNoSet();
		 PlaySound(49);
		 break;
	      case 4:
		 TheIcon = LoadIcon(hInst,"ICON_55");
		 DrawNoSet();
		 PlaySound(73);
		 break;
	      case 5:
		 TheIcon = LoadIcon(hInst,"ICON_56");
		 DrawNoSet();
		 PlaySound(76);
		 break;
	      case 6:
		 TheIcon = LoadIcon(hInst,"ICON_57");
		 DrawNoSet();
		 PlaySound(81);
                 break;
	      case 7:
		 TheIcon = LoadIcon(hInst,"ICON_58");
		 DrawNoSet();
		 PlaySound(39);
                 break;
	      case 8:
		 TheIcon = LoadIcon(hInst,"ICON_59");
		 DrawNoSet();
		 PlaySound(78);
		 break;
	   } // switch NewBoxPos
	   break;
	case 8:         // icon stamps #2
	   switch(NewBoxPos){
	      case 1:
		 TheIcon = LoadIcon(hInst,"ICON_60");
		 DrawNoSet();
		 PlaySound(19);
		 break;
	      case 2:
		 TheIcon = LoadIcon(hInst,"ICON_61");
		 DrawNoSet();
		 PlaySound(70);
		 break;
	      case 3:
		 TheIcon = LoadIcon(hInst,"ICON_62");
		 DrawNoSet();
		 PlaySound(26);
		 break;
	      case 4:
		 TheIcon = LoadIcon(hInst,"ICON_63");
		 DrawNoSet();
		 PlaySound(72);
		 break;
	      case 5:
		 TheIcon = LoadIcon(hInst,"ICON_64");
		 DrawNoSet();
		 PlaySound(79);
		 break;
	      case 6:
		 TheIcon = LoadIcon(hInst,"ICON_65");
		 DrawNoSet();
		 PlaySound(88);
                 break;
	      case 7:
		 TheIcon = LoadIcon(hInst,"ICON_66");
		 DrawNoSet();
		 PlaySound(87);
                 break;
	      case 8:
		 TheIcon = LoadIcon(hInst,"ICON_67");
		 DrawNoSet();
		 PlaySound(34);
		 break;
	   } // switch NewBoxPos
           break;
	case 9:         // icon stamps #1
	   switch(NewBoxPos){
	      case 1:
		 TheIcon = LoadIcon(hInst,"ICON_68");
		 DrawNoSet();
		 PlaySound(90);
		 break;
	      case 2:
		 TheIcon = LoadIcon(hInst,"ICON_69");
		 DrawNoSet();
		 PlaySound(69);
		 break;
	      case 3:
		 TheIcon = LoadIcon(hInst,"ICON_70");
		 DrawNoSet();
		 PlaySound(56);
		 break;
	      case 4:
		 TheIcon = LoadIcon(hInst,"ICON_71");
		 DrawNoSet();
		 PlaySound(53);
		 break;
	      case 5:
		 TheIcon = LoadIcon(hInst,"ICON_72");
		 DrawNoSet();
		 PlaySound(52);
		 break;
	      case 6:
		 TheIcon = LoadIcon(hInst,"ICON_73");
		 DrawNoSet();
		 PlaySound(95);
                 break;
	      case 7:
		 TheIcon = LoadIcon(hInst,"ICON_74");
		 DrawNoSet();
		 PlaySound(50);
                 break;
	      case 8:
		 TheIcon = LoadIcon(hInst,"ICON_75");
		 DrawNoSet();
		 PlaySound(102);
		 break;
	   } // switch NewBoxPos
           break;
	case 10:         // icon stamps #1
	   switch(NewBoxPos){
	      case 1:
		 TheIcon = LoadIcon(hInst,"ICON_76");
		 DrawNoSet();
		 PlaySound(35);
		 break;
	      case 2:
		 TheIcon = LoadIcon(hInst,"ICON_77");
		 DrawNoSet();
		 PlaySound(47);
		 break;
	      case 3:
		 TheIcon = LoadIcon(hInst,"ICON_78");
		 DrawNoSet();
		 PlaySound(47);
		 break;
	      case 4:
		 TheIcon = LoadIcon(hInst,"ICON_79");
		 DrawNoSet();
		 PlaySound(103);
		 break;
	      case 5:
		 TheIcon = LoadIcon(hInst,"ICON_80");
		 DrawNoSet();
		 PlaySound(104);
		 break;
	      case 6:
		 TheIcon = LoadIcon(hInst,"ICON_81");
		 DrawNoSet();
		 PlaySound(105);
                 break;
	      case 7:
		 TheIcon = LoadIcon(hInst,"ICON_82");
		 DrawNoSet();
		 PlaySound(102);
                 break;
	      case 8:
		 TheIcon = LoadIcon(hInst,"ICON_83");
		 DrawNoSet();
		 PlaySound(89);
		 break;
	   } // switch NewBoxPos
	   break;
	case 11:         // icon stamps #1
	   switch(NewBoxPos){
	      case 1:
		 TheIcon = LoadIcon(hInst,"ICON_84");
		 DrawNoSet();
		 PlaySound(103);
		 break;
	      case 2:
		 TheIcon = LoadIcon(hInst,"ICON_85");
		 DrawNoSet();
		 PlaySound(104);
		 break;
	      case 3:
		 TheIcon = LoadIcon(hInst,"ICON_86");
		 DrawNoSet();
		 PlaySound(93);
		 break;
	      case 4:
		 TheIcon = LoadIcon(hInst,"ICON_87");
		 DrawNoSet();
		 PlaySound(38);
		 break;
	      case 5:
		 TheIcon = LoadIcon(hInst,"ICON_88");
		 DrawNoSet();
		 PlaySound(32);
		 break;
	      case 6:
		 TheIcon = LoadIcon(hInst,"ICON_89");
		 DrawNoSet();
		 PlaySound(51);
                 break;
	      case 7:
		 TheIcon = LoadIcon(hInst,"ICON_90");
		 DrawNoSet();
		 PlaySound(30);
                 break;
	      case 8:
		 TheIcon = LoadIcon(hInst,"ICON_91");
		 DrawNoSet();
		 PlaySound(36);
		 break;
	   } // switch NewBoxPos
	   break;
	case 12:         // icon stamps #1
	   switch(NewBoxPos){
	      case 1:
		 TheIcon = LoadIcon(hInst,"ICON_92");
		 DrawNoSet();
		 PlaySound(67);
		 break;
	      case 2:
		 TheIcon = LoadIcon(hInst,"ICON_93");
		 DrawNoSet();
		 PlaySound(29);
		 break;
	      case 3:
		 TheIcon = LoadIcon(hInst,"ICON_94");
		 DrawNoSet();
		 PlaySound(18);
		 break;
	      case 4:
		 TheIcon = LoadIcon(hInst,"ICON_95");
		 DrawNoSet();
		 PlaySound(85);
		 break;
	      case 5:
		 TheIcon = LoadIcon(hInst,"ICON_96");
		 DrawNoSet();
		 PlaySound(61);
		 break;
	      case 6:
		 TheIcon = LoadIcon(hInst,"ICON_97");
		 DrawNoSet();
		 PlaySound(82);
                 break;
	      case 7:
		 TheIcon = LoadIcon(hInst,"ICON_98");
		 DrawNoSet();
		 PlaySound(63);
                 break;
	      case 8:
		 TheIcon = LoadIcon(hInst,"ICON_99");
		 DrawNoSet();
		 PlaySound(68);
		 break;
	   } // switch NewBoxPos
	   break;
	case 13:         // icon stamps #1
	   switch(NewBoxPos){
	      case 1:
		 TheIcon = LoadIcon(hInst,"ICON_100");
		 DrawNoSet();
		 PlaySound(31);
		 break;
	      case 2:
		 TheIcon = LoadIcon(hInst,"ICON_101");
		 DrawNoSet();
		 PlaySound(45);
		 break;
	      case 3:
		 TheIcon = LoadIcon(hInst,"ICON_102");
		 DrawNoSet();
		 PlaySound(33);
		 break;
	      case 4:
		 TheIcon = LoadIcon(hInst,"ICON_103");
		 DrawNoSet();
		 PlaySound(100);
		 break;
	      case 5:
		 TheIcon = LoadIcon(hInst,"ICON_104");
		 DrawNoSet();
		 PlaySound(64);
		 break;
	      case 6:
		 TheIcon = LoadIcon(hInst,"ICON_105");
		 DrawNoSet();
                 PlaySound(98);
                 break;
	      case 7:
		 TheIcon = LoadIcon(hInst,"ICON_106");
		 DrawNoSet();
		 PlaySound(60);
                 break;
	      case 8:
		 TheIcon = LoadIcon(hInst,"ICON_107");
		 DrawNoSet();
		 PlaySound(84);
		 break;
	   } // switch NewBoxPos
	   break;
	case 14:         // icon stamps #1
	   switch(NewBoxPos){
	      case 1:
		 TheIcon = LoadIcon(hInst,"ICON_108");
		 DrawNoSet();
		 PlaySound(86);
		 break;
	      case 2:
		 TheIcon = LoadIcon(hInst,"ICON_109");
		 DrawNoSet();
		 PlaySound(37);
		 break;
	      case 3:
		 TheIcon = LoadIcon(hInst,"ICON_110");
		 DrawNoSet();
		 PlaySound(65);
		 break;
	      case 4:
		 TheIcon = LoadIcon(hInst,"ICON_111");
		 DrawNoSet();
		 PlaySound(58);
		 break;
	      case 5:
		 TheIcon = LoadIcon(hInst,"ICON_112");
		 DrawNoSet();
		 PlaySound(97);
		 break;
	      case 6:
		 TheIcon = LoadIcon(hInst,"ICON_113");
		 DrawNoSet();
		 PlaySound(99);
                 break;
	      case 7:
		 TheIcon = LoadIcon(hInst,"ICON_114");
		 DrawNoSet();
		 PlaySound(44);
                 break;
	      case 8:
		 TheIcon = LoadIcon(hInst,"ICON_115");
		 DrawNoSet();
		 PlaySound(77);
		 break;
	   } // switch NewBoxPos
	   break;
       case 15:         // icon stamps #1
	   switch(NewBoxPos){
	      case 1:
		 TheIcon = LoadIcon(hInst,"ICON_116");
		 DrawNoSet();
		 PlaySound(48);
		 break;
	      case 2:
		 TheIcon = LoadIcon(hInst,"ICON_117");
		 DrawNoSet();
		 PlaySound(25);
		 break;
	      case 3:
		 TheIcon = LoadIcon(hInst,"ICON_118");
		 DrawNoSet();
		 PlaySound(89);
		 break;
	      case 4:
		 TheIcon = LoadIcon(hInst,"ICON_119");
		 DrawNoSet();
		 PlaySound(96);
		 break;
	      case 5:
		 TheIcon = LoadIcon(hInst,"ICON_120");
		 DrawNoSet();
		 PlaySound(71);
		 break;
	      case 6:
		 TheIcon = LoadIcon(hInst,"ICON_121");
		 DrawNoSet();
		 PlaySound(55);
                 break;
	      case 7:
		 TheIcon = LoadIcon(hInst,"ICON_122");
		 DrawNoSet();
		 PlaySound(24);
                 break;
	      case 8:
		 TheIcon = LoadIcon(hInst,"ICON_123");
		 DrawNoSet();
		 PlaySound(17);
		 break;
	   } // switch NewBoxPos
	break;
     } // switch ToolSet
}


void ColorTool(int which)
{
     HDC               hDC;
     HICON             hicon1, hicon2, hicon3;
     HBRUSH            hBrush, hobr;
     HPEN              hPen, hPen1, hop;
     HPALETTE          oldpal;


     hDC = GetDC(hWndMain);
     oldpal = SelectPalette(hDC, hwndpal, FALSE);
     RealizePalette(hDC);
      // blank out whatever toolextra is there
     hPen1 = CreatePen(PS_SOLID,1,TURQUOISE1 | 0x2000000L);
     hop = SelectObject(hDC,hPen1);
     hBrush = CreateSolidBrush(TURQUOISE1 | 0x2000000L);
     hobr = SelectObject(hDC,hBrush);
     Rectangle(hDC,3,339,48,430);
     // draw the tool icons
     hicon1 = LoadIcon(hInst,"ICON_3");
     hicon2 = LoadIcon(hInst,"ICON_17");
     hicon3 = LoadIcon(hInst,"ICON_50");
     DrawIcon(hDC,9,343,hicon1);
     DrawIcon(hDC,9,383,hicon2);
     DrawIcon(hDC,540,10,hicon3);
     // now draw a line around the chosen tool
     SelectObject(hDC,hop);
     hPen = CreatePen(PS_SOLID,2,RED | 0x2000000L);
     hop = SelectObject(hDC,hPen);
     if(which == 0)
	Box(hDC,5,341,45,380);
     else
	Box(hDC,5,380,45,420);
     // and clean up
     SelectObject(hDC,hop);
     SelectObject(hDC,hobr);
     SelectPalette(hDC, oldpal, FALSE);
     ReleaseDC(hWndMain,hDC);
     DeleteObject(hBrush);
     DeleteObject(hPen);
     DeleteObject(hPen1);
     DestroyIcon(hicon1);
     DestroyIcon(hicon2);
     DestroyIcon(hicon3);
     // remember to show which tool
     if(which == 0) 
	DrawTool = COLORBOOK1;
     else
        DrawTool = COLORBOOK2;
}


void ExecuteDisk(int which)
{
     HDC          hdc;
     HPALETTE     oldpal;

       switch(which){
	      case 1:
		 DrawTool = NONE;
                 trashit = FALSE;
		 DrawNoSet();
		 DiskToPicSelected();
		 break;
	      case 2:
		 DrawTool = NONE;
		 DrawNoSet();
		 PicToDiskSelected();
		 DrawTools1();
		 ShowWindow(hwnd8,SW_SHOWNA);
		 hdc = GetDC(phwnd);
		 oldpal = SelectPalette(hdc, hwndpal, FALSE);
                 RealizePalette(hdc);
		 BitBlt(hdc,0,0,hres-50,vres-50,undodc,0,0,SRCCOPY);
		 SelectPalette(hdc, oldpal, FALSE);
		 ReleaseDC(phwnd,hdc);
		 break;
	      case 3:
	         DrawTool = NONE;
	         DrawNoSet();
		 PrintIt();
		 DrawTools1();
		 ShowWindow(hwnd8,SW_SHOWNA);
		 break;
	      case 4:
		 PlaySound(92);
		 DrawTool = NONE;
                 trashit = TRUE;
		 DrawNoSet();
		 DiskToPicSelected();
		 break;
	      case 5:
		 if(stampsmear == TRUE)
		    stampsmear = FALSE;
		 else
		    stampsmear = TRUE;
		 DrawTools1();
		 ShowWindow(hwnd8,SW_SHOWNA);
                 break;
	      case 6:
	      case 7:
	      case 8:
		 DrawTools6();
		 ShowWindow(hwnd8,SW_SHOWNA);
                 break;
	   }   
}

void ExecuteErase(int which)
{
     HDC      hdc;
     HBRUSH   hBrush, hobr;
     HPEN     hPen, hop;
     LOGBRUSH logbrush;
     HPALETTE oldpal;

     int      h, i, j, k;

     hdc = GetDC(phwnd);
     oldpal = SelectPalette(hdc, hwndpal, FALSE);
     RealizePalette(hdc);
     switch(which){
	 case 1:    // Blackboard
              PlaySound(40);
	      hBrush = CreateSolidBrush(DKGREEN | 0x2000000L);
	      hobr = SelectObject(hdc,hBrush);
	      hPen = CreatePen(PS_SOLID,1,DKGREEN | 0x2000000L);
	      hop = SelectObject(hdc,hPen);
	      Rectangle(hdc,0,0,hres - 50,vres - 50);
	      break;
	 case 2:   // Wipe Right
              PlaySound(8);
	      hBrush = CreateSolidBrush(WHITE);
	      hobr = SelectObject(hdc,hBrush);
	      hPen = CreatePen(PS_SOLID,1,WHITE);
	      hop = SelectObject(hdc,hPen);
	      for(i = 0; i < hres - 50; i++) Line(hdc,i,0,i,vres - 50);
	      break;
	 case 3:   // Claws
              PlaySound(13);
	      hBrush = CreateSolidBrush(WHITE);
	      hobr = SelectObject(hdc,hBrush);
	      hPen = CreatePen(PS_SOLID,7,WHITE);
	      hop = SelectObject(hdc,hPen);
	      for(i = 0; i < 200; i++){
		  j = random(hres - 50);
		  k = random(hres - 50);
		  Line(hdc,j,0,k,vres - 50);
	      }
	      BitBlt(hdc, 0,0,hres - 50,vres - 50,NULL,0,0,WHITENESS);
	      break;
	 case 4:  // Curtains A
              PlaySound(9);
	      hBrush = CreateSolidBrush(WHITE);
	      hobr = SelectObject(hdc,hBrush);
	      hPen = CreatePen(PS_SOLID,1,WHITE);
	      hop = SelectObject(hdc,hPen);
              h = (hres - 52) / 2;
	      for(i = h, j = h; i >= 0; i--, j++){
		  Line(hdc,i,0,i,vres - 50);
		  Line(hdc,j,0,j,vres - 50);
	      }
	      break;
	 case 5:  // Curtains B
              PlaySound(10);
	      hBrush = CreateSolidBrush(BLACK);
	      hobr = SelectObject(hdc,hBrush);
	      hPen = CreatePen(PS_SOLID,1,BLACK);
	      hop = SelectObject(hdc,hPen);
	      for(i = 0, j = hres - 50; i < ((hres - 50) / 2) + 2; i++, j--){
		  Line(hdc,i,0,i,vres - 50);
		  Line(hdc,j,0,j,vres - 50);
	      }
	      break;
	 case 6:  // Toilet
	      SaveToUndoPic();
              PlaySound(15);
	      hBrush = CreateSolidBrush(WHITE);
	      hobr = SelectObject(hdc,hBrush);
	      hPen = CreatePen(PS_SOLID,1,WHITE);
	      hop = SelectObject(hdc,hPen);
	      for(i = 0; i < (vres - 50); i += 20){
	          Rectangle(hdc,0,0,hres - 50,i + 1);
		  BitBlt(hdc, 0,i,hres - 50,vres - 50,undodc,0,0,SRCCOPY);
	      }
	      BitBlt(hdc, 0,0,hres - 50,vres - 50,NULL,0,0,WHITENESS);
              break;
	 case 7:  // Bombe'
              PlaySound(6);
	      logbrush.lbStyle = BS_HOLLOW;
	      hBrush = CreateBrushIndirect(&logbrush);
	      hobr = SelectObject(hdc,hBrush);
	      hPen = CreatePen(PS_SOLID,1,BLACK);
	      hop = SelectObject(hdc,hPen);
	      h = (hres - 50) / 2;
	      j = (vres - 50) / 2;
	      for(i = 1; i < 400; i+=3)
		  Ellipse(hdc, h- i, j -i, h + i, j + i);
	      BitBlt(hdc, 0,0,hres - 50,vres - 50,NULL,0,0,WHITENESS);
	      break;
	 case 8:  // Starry Nite
              PlaySound(11);
	      hBrush = CreateSolidBrush(BLACK);
	      hobr = SelectObject(hdc,hBrush);
	      hPen = CreatePen(PS_SOLID,1,BLACK);
	      hop = SelectObject(hdc,hPen);
	      Rectangle(hdc,0,0,hres - 50,vres - 50);
              for(i = 0; i < 1500; i++){
		  h = random(hres - 50);
		  k = random(vres - 50);
		  j = random(15);
		  SetPixel(hdc,h,k,aColor[j] | 0x2000000L);
              }
	      break;
     } // switch
     SelectObject(hdc,hobr);
     SelectObject(hdc,hop);
     SelectPalette(hdc, oldpal, FALSE);
     ReleaseDC(phwnd,hdc);
     DeleteObject(hBrush);
     DeleteObject(hPen);
     DrawTools1();
}

void InvertPic(void)
{
     HDC             hdc;
     HPALETTE        oldpal;

     hdc = GetDC(phwnd);
     oldpal = SelectPalette(hdc, hwndpal, FALSE);
     RealizePalette(hdc);
     BitBlt(hdc,0,0,hres - 50,vres - 50,NULL,0,0,DSTINVERT);
     SelectPalette(hdc, oldpal, FALSE);
     ReleaseDC(phwnd,hdc);
}

void StretchPic(void)
{
     HDC          hdc;
     int          x,y,i,j,k,m;
     HPALETTE     oldpal;

     PlaySound(62);
     x = hres - 53;
     y = vres - 53;
     i = x / 10;
     j = y / 10;
     k = x - (i * 2);
     m = y - (j * 2);
     hdc = GetDC(phwnd);
     oldpal = SelectPalette(hdc, hwndpal, FALSE);
     RealizePalette(hdc);
     StretchBlt(hdc,0,0,x,y,hdc,i,j,k,m,SRCCOPY);
     SelectPalette(hdc, oldpal, FALSE);
     ReleaseDC(phwnd,hdc);
}

void ShrinkPic(void)
{
     HDC          hdc;
     int          x,y,i,j,k,m;
     HPALETTE     oldpal;


     x = hres - 53;
     y = vres - 53;
     i = x / 10;
     j = y / 10;
     k = x - (i * 2);
     m = y - (j * 2);
     hdc = GetDC(phwnd);
     oldpal = SelectPalette(hdc, hwndpal, FALSE);
     RealizePalette(hdc);
     StretchBlt(hdc,i,j,k,m,hdc,0,0,x, y,SRCCOPY);
     SelectPalette(hdc, oldpal, FALSE);
     ReleaseDC(phwnd,hdc);
}

void SaveToUndoPic(void)
{
     HDC          hdc;
     HPALETTE     oldpal, op1;

     hdc = GetDC(phwnd);
     oldpal = SelectPalette(hdc, hwndpal, FALSE);
     RealizePalette(hdc);
     op1 = SelectPalette(undodc, hwndpal, FALSE);
     RealizePalette(undodc);
     BitBlt(undodc,0,0,hres-50,vres-50,hdc,0,0,SRCCOPY);
     SelectPalette(hdc, oldpal, FALSE);
     SelectPalette(hdc, op1, FALSE);
     ReleaseDC(phwnd,hdc);
}

void TransmogrifyColor(void)
{
     HDC         hdc;
     HBRUSH      hBrush[16], hobr;
     int         i, x, y;
     HPALETTE    oldpal;

     hdc = GetDC(phwnd);
     oldpal = SelectPalette(hdc, hwndpal, FALSE);
     RealizePalette(hdc);
     for(i = 0; i < 16; i++)
	 hBrush[i] = CreateSolidBrush(aColor[i] | 0x2000000L);

     for(i = 0; i < 3; i++){
	 x = random(hres - 50);
	 y = random(vres - 50);
	 hobr = SelectObject(hdc,hBrush[i]);
	 ExtFloodFill(hdc,x,y,GetPixel(hdc,x,y) | 0x2000000L,FLOODFILLSURFACE);
	 SelectObject(hdc,hobr);
     }
     SelectPalette(hdc, oldpal, FALSE);
     ReleaseDC(phwnd,hdc);
     for(i = 0; i < 16; i++)
         DeleteObject(hBrush[i]);
}
/*************************************************************************
       Draw 8 tools and the Arrow...
***************************************************************************/

void NextToolSet(void)
{
    switch(ToolSet){
       case 1:
	  DrawTools2();
	  break;
       case 2:
	  DrawTools3();
	  break;
       case 3:
	  DrawTools1();
	  break;
       case 7:
	  DrawIcons(8);
          break;
       case 8:
	  DrawIcons(9);
          break;
       case 9:
	  DrawIcons(10);
          break;
       case 10:
	  DrawIcons(11);
          break;
       case 11:
	  DrawIcons(12);
          break;
       case 12:
	  DrawIcons(13);
          break;
       case 13:
	  DrawIcons(14);
          break;
       case 14:
	  DrawIcons(15);
          break;
       case 15:
	  DrawIcons(7);
	  break;
    }
}

void PreviousToolSet(void)
{
    switch(ToolSet){
       case 1:
	  DrawTools3();
	  break;
       case 2:
	  DrawTools1();
	  break;
       case 3:
	  DrawTools2();
	  break;
       case 7:
	  DrawIcons(15);
          break;
       case 8:
	  DrawIcons(7);
          break;
       case 9:
	  DrawIcons(8);
          break;
       case 10:
	  DrawIcons(9);
          break;
       case 11:
	  DrawIcons(10);
          break;
       case 12:
	  DrawIcons(11);
          break;
       case 13:
	  DrawIcons(12);
          break;
       case 14:
	  DrawIcons(13);
          break;
       case 15:
	  DrawIcons(14);
	  break;
    }
}

void DrawTools1(void)
{
     HDC               hDC;
     HICON             hicon1, hicon2, hicon3,
		       hicon4, hicon5, hicon6,
		       hicon7, hicon8, hicon9;
     HPALETTE          oldpal;

     HorizDitherPattern();
     hDC = GetDC(hWndMain);
     oldpal = SelectPalette(hDC, hwndpal, FALSE);
     RealizePalette(hDC);
     hicon1 = LoadIcon(hInst,"ICON_1");
     hicon2 = LoadIcon(hInst,"ICON_3");
     hicon3 = LoadIcon(hInst,"ICON_5");
     hicon4 = LoadIcon(hInst,"ICON_6");
     hicon5 = LoadIcon(hInst,"ICON_7");
     hicon6 = LoadIcon(hInst,"ICON_8");
     hicon7 = LoadIcon(hInst,"ICON_2");
     hicon8 = LoadIcon(hInst,"ICON_9");
     hicon9 = LoadIcon(hInst,"ICON_4");
     DrawIcon(hDC,60,10,hicon1);
     DrawIcon(hDC,100,10,hicon2);
     DrawIcon(hDC,140,10,hicon3);
     DrawIcon(hDC,180,10,hicon4);
     DrawIcon(hDC,220,10,hicon5);
     DrawIcon(hDC,260,10,hicon6);
     DrawIcon(hDC,300,10,hicon7);
     DrawIcon(hDC,340,10,hicon8);
     DrawIcon(hDC,380,10,hicon9);
     SelectPalette(hDC, oldpal, FALSE);
     ReleaseDC(hWndMain,hDC);
     DestroyIcon(hicon1);
     DestroyIcon(hicon2);
     DestroyIcon(hicon3);
     DestroyIcon(hicon4);
     DestroyIcon(hicon5);
     DestroyIcon(hicon6);
     DestroyIcon(hicon7);
     DestroyIcon(hicon8);
     DestroyIcon(hicon9);
     // remember to show which tool
     ToolSet = 1;
     DrawTool = PENCIL;
     CurrentBoxPos = 2;
     BoxAroundTool(1);
     DrawLineSet();
}

void DrawTools2(void)
{
     HDC               hDC;
     HICON             hicon1, hicon2, hicon3,
		       hicon4, hicon5, hicon6,
		       hicon7, hicon8, hicon9;
     HPALETTE          oldpal;

     HorizDitherPattern();
     hDC = GetDC(hWndMain);
     oldpal = SelectPalette(hDC, hwndpal, FALSE);
     RealizePalette(hDC);
     hicon1 = LoadIcon(hInst,"ICON_10");
     hicon2 = LoadIcon(hInst,"ICON_11");
     hicon3 = LoadIcon(hInst,"ICON_12");
     hicon4 = LoadIcon(hInst,"ICON_13");
     hicon5 = LoadIcon(hInst,"ICON_14");
     hicon6 = LoadIcon(hInst,"ICON_15");
     hicon7 = LoadIcon(hInst,"ICON_16");
     hicon8 = LoadIcon(hInst,"ICON_17");
     hicon9 = LoadIcon(hInst,"ICON_4");
     DrawIcon(hDC,60,10,hicon1);
     DrawIcon(hDC,100,10,hicon2);
     DrawIcon(hDC,140,10,hicon3);
     DrawIcon(hDC,180,10,hicon4);
     DrawIcon(hDC,220,10,hicon5);
     DrawIcon(hDC,260,10,hicon6);
     DrawIcon(hDC,300,10,hicon7);
     DrawIcon(hDC,340,10,hicon8);
     DrawIcon(hDC,380,10,hicon9);
     SelectPalette(hDC, oldpal, FALSE);
     ReleaseDC(hWndMain,hDC);
     DestroyIcon(hicon1);
     DestroyIcon(hicon2);
     DestroyIcon(hicon3);
     DestroyIcon(hicon4);
     DestroyIcon(hicon5);
     DestroyIcon(hicon6);
     DestroyIcon(hicon7);
     DestroyIcon(hicon8);
     DestroyIcon(hicon9);
     // remember to show which tool
     ToolSet = 2;
     DrawTool = TRIANGLE;
     CurrentBoxPos = 2;
     BoxAroundTool(1);
     DrawLineSet();
}

void DrawTools3(void)
{
     HDC               hDC;
     HICON             hicon1, hicon2, hicon3,
		       hicon4, hicon5, hicon6,
		       hicon7, hicon8, hicon9;
     HPALETTE          oldpal;

     HorizDitherPattern();
     hDC = GetDC(hWndMain);
     oldpal = SelectPalette(hDC, hwndpal, FALSE);
     RealizePalette(hDC);
     hicon1 = LoadIcon(hInst,"ICON_18");
     hicon2 = LoadIcon(hInst,"ICON_19");
     hicon3 = LoadIcon(hInst,"ICON_20");
     hicon4 = LoadIcon(hInst,"ICON_21");
     hicon5 = LoadIcon(hInst,"ICON_22");
     hicon6 = LoadIcon(hInst,"ICON_24");
     hicon7 = LoadIcon(hInst,"ICON_23");
     hicon8 = LoadIcon(hInst,"ICON_25");
     hicon9 = LoadIcon(hInst,"ICON_4");
     DrawIcon(hDC,60,10,hicon1);
     DrawIcon(hDC,100,10,hicon2);
     DrawIcon(hDC,140,10,hicon3);
     DrawIcon(hDC,180,10,hicon4);
     DrawIcon(hDC,220,10,hicon5);
     DrawIcon(hDC,260,10,hicon6);
     DrawIcon(hDC,300,10,hicon7);
     DrawIcon(hDC,340,10,hicon8);
     DrawIcon(hDC,380,10,hicon9);
     SelectPalette(hDC, oldpal, FALSE);
     ReleaseDC(hWndMain,hDC);
     DestroyIcon(hicon1);
     DestroyIcon(hicon2);
     DestroyIcon(hicon3);
     DestroyIcon(hicon4);
     DestroyIcon(hicon5);
     DestroyIcon(hicon6);
     DestroyIcon(hicon7);
     DestroyIcon(hicon8);
     DestroyIcon(hicon9);
     // remember to show which tool
     ToolSet = 3;
     DrawTool = ZIGZAG;
     CurrentBoxPos = 2;
     BoxAroundTool(1);
     DrawLineSet();
}


void DrawTools4(void)
{
     HDC               hDC;
     HICON             hicon1, hicon2, hicon3,
		       hicon4, hicon5, hicon6,
		       hicon7, hicon8;
     HPALETTE          oldpal;

     HorizDitherPattern();
     hDC = GetDC(hWndMain);
     oldpal = SelectPalette(hDC, hwndpal, FALSE);
     RealizePalette(hDC);
     hicon1 = LoadIcon(hInst,"ICON_26");
     hicon2 = LoadIcon(hInst,"ICON_27");
     hicon3 = LoadIcon(hInst,"ICON_28");
     hicon4 = LoadIcon(hInst,"ICON_29");
     hicon5 = LoadIcon(hInst,"ICON_30");
     hicon6 = LoadIcon(hInst,"ICON_127");
     hicon7 = LoadIcon(hInst,"ICON_32");
     hicon8 = LoadIcon(hInst,"ICON_33");
     DrawIcon(hDC,60,10,hicon1);
     DrawIcon(hDC,100,10,hicon2);
     DrawIcon(hDC,140,10,hicon3);
     DrawIcon(hDC,180,10,hicon4);
     DrawIcon(hDC,220,10,hicon5);
     DrawIcon(hDC,260,10,hicon6);
     DrawIcon(hDC,300,10,hicon7);
     DrawIcon(hDC,340,10,hicon8);
     // and clean up
     SelectPalette(hDC, oldpal, FALSE);
     ReleaseDC(hWndMain,hDC);
     DestroyIcon(hicon1);
     DestroyIcon(hicon2);
     DestroyIcon(hicon3);
     DestroyIcon(hicon4);
     DestroyIcon(hicon5);
     DestroyIcon(hicon6);
     DestroyIcon(hicon7);
     DestroyIcon(hicon8);
     // remember to show which tool
     ToolSet = 4;
     DrawTool = NONE;
     CurrentBoxPos = 1;
     DrawNoSet();     // make sure there's no line set...
}

void DrawTools5(void)
{
     HDC               hDC;
     HICON             hicon1, hicon2, hicon3,
		       hicon4, hicon5, hicon6,
		       hicon7, hicon8;
     HPALETTE          oldpal;

     HorizDitherPattern();
     hDC = GetDC(hWndMain);
     oldpal = SelectPalette(hDC, hwndpal, FALSE);
     RealizePalette(hDC);
     hicon1 = LoadIcon(hInst,"ICON_34");
     hicon2 = LoadIcon(hInst,"ICON_35");
     hicon3 = LoadIcon(hInst,"ICON_37");
     hicon4 = LoadIcon(hInst,"ICON_38");
     hicon5 = LoadIcon(hInst,"ICON_36");
     hicon6 = LoadIcon(hInst,"ICON_39");
     hicon7 = LoadIcon(hInst,"ICON_40");
     hicon8 = LoadIcon(hInst,"ICON_41");
     DrawIcon(hDC,60,10,hicon1);
     DrawIcon(hDC,100,10,hicon2);
     DrawIcon(hDC,140,10,hicon3);
     DrawIcon(hDC,180,10,hicon4);
     DrawIcon(hDC,220,10,hicon5);
     DrawIcon(hDC,260,10,hicon6);
     DrawIcon(hDC,300,10,hicon7);
     DrawIcon(hDC,340,10,hicon8);
     SelectPalette(hDC, oldpal, FALSE);
     ReleaseDC(hWndMain,hDC);
     DestroyIcon(hicon1);
     DestroyIcon(hicon2);
     DestroyIcon(hicon3);
     DestroyIcon(hicon4);
     DestroyIcon(hicon5);
     DestroyIcon(hicon6);
     DestroyIcon(hicon7);
     DestroyIcon(hicon8);
     // remember to show which tool
     ToolSet = 5;
     DrawTool = SCISSORS;
     CurrentBoxPos = 2;
     BoxAroundTool(1);
     DrawNoSet();
}


void HorizDitherPattern(void)
{
     HDC               hDC;
     HBRUSH            hBrush1, hobr;
     HPEN              hBorderPen, hop;
     int               i, acyan;
     HPALETTE          oldpal;

     hDC = GetDC(hWndMain);
     oldpal = SelectPalette(hDC, hwndpal, FALSE);
     RealizePalette(hDC);
     hBorderPen = CreatePen(PS_SOLID, 1,TURQUOISE1 | 0x2000000L);
     hBrush1 = CreateSolidBrush(TURQUOISE1 | 0x2000000L);
     hop = SelectObject(hDC, hBorderPen);
     hobr = SelectObject(hDC, hBrush1);
     Rectangle(hDC,50,0,540,50);
     SelectObject(hDC, hop);
     SelectObject(hDC, hobr);
     SelectPalette(hDC, oldpal, FALSE);
     ReleaseDC(hWndMain,hDC);
     DeleteObject(hBorderPen);
     DeleteObject(hBrush1);
}

void HorizDitherPattern2(void)
{
     HDC               hDC;
     HBRUSH            hBrush1, hobr;
     HPEN              hBorderPen, hop;
     int               i, acyan;
     HPALETTE          oldpal;

     hDC = GetDC(hWndMain);
     oldpal = SelectPalette(hDC, hwndpal, FALSE);
     RealizePalette(hDC);
     hBorderPen = CreatePen(PS_SOLID, 1,TURQUOISE1 | 0x2000000L);
     hBrush1 = CreateSolidBrush(TURQUOISE1 | 0x2000000L);
     hop = SelectObject(hDC, hBorderPen);
     hobr = SelectObject(hDC, hBrush1);
     Rectangle(hDC,592,0,hres-66,50);
     SelectObject(hDC, hop);
     SelectObject(hDC, hobr);
     SelectPalette(hDC, oldpal, FALSE);
     ReleaseDC(hWndMain,hDC);
     DeleteObject(hBorderPen);
     DeleteObject(hBrush1);
}

void DrawTools6(void)       // computer ops
{
     HDC               hDC;
     HICON             hicon1, hicon2, hicon3, hicon4, hicon5;
     HPALETTE          oldpal;

     HorizDitherPattern();
     hDC = GetDC(hWndMain);
     oldpal = SelectPalette(hDC, hwndpal, FALSE);
     RealizePalette(hDC);
     hicon1 = LoadIcon(hInst,"ICON_49");
     hicon2 = LoadIcon(hInst,"ICON_48");
     hicon3 = LoadIcon(hInst,"ICON_50");
     hicon4 = LoadIcon(hInst,"ICON_126");
     if(stampsmear == TRUE) 
	hicon5 = LoadIcon(hInst,"ICON_129");
     else
	hicon5 = LoadIcon(hInst,"ICON_130");
     DrawIcon(hDC,60,10,hicon1);
     DrawIcon(hDC,100,10,hicon2);
     DrawIcon(hDC,140,10,hicon3);
     DrawIcon(hDC,180,10,hicon4);
     DrawIcon(hDC,220,10,hicon5);
     // and clean up
     SelectPalette(hDC, oldpal, FALSE);
     ReleaseDC(hWndMain,hDC);
     DestroyIcon(hicon1);
     DestroyIcon(hicon2);
     DestroyIcon(hicon3);
     DestroyIcon(hicon4);
     DestroyIcon(hicon5);
     // remember to show which tool
     ToolSet = 6;
     DrawTool = NONE;
     CurrentBoxPos = 1;
     DrawNoSet();
}

void DrawIcons(int whichset)
{
     HDC               hDC;
     HICON             hicon1, hicon2, hicon3,
		       hicon4, hicon5, hicon6,
		       hicon7, hicon8, hicon9;
     HPALETTE          oldpal;

     HorizDitherPattern();
     hDC = GetDC(hWndMain);
     oldpal = SelectPalette(hDC, hwndpal, FALSE);
     RealizePalette(hDC);
     hicon9 = LoadIcon(hInst,"ICON_4");
     switch(whichset){
         case 7:
              hicon1 = LoadIcon(hInst,"ICON_52");
              hicon2 = LoadIcon(hInst,"ICON_53");
              hicon3 = LoadIcon(hInst,"ICON_54");
              hicon4 = LoadIcon(hInst,"ICON_55");
              hicon5 = LoadIcon(hInst,"ICON_56");
              hicon6 = LoadIcon(hInst,"ICON_57");
              hicon7 = LoadIcon(hInst,"ICON_58");
	      hicon8 = LoadIcon(hInst,"ICON_59");
              break;
          case 8:
	      hicon1 = LoadIcon(hInst,"ICON_60");
              hicon2 = LoadIcon(hInst,"ICON_61");
              hicon3 = LoadIcon(hInst,"ICON_62");
              hicon4 = LoadIcon(hInst,"ICON_63");
              hicon5 = LoadIcon(hInst,"ICON_64");
              hicon6 = LoadIcon(hInst,"ICON_65");
              hicon7 = LoadIcon(hInst,"ICON_66");
	      hicon8 = LoadIcon(hInst,"ICON_67");
              break;
          case 9:
              hicon1 = LoadIcon(hInst,"ICON_68");
	      hicon2 = LoadIcon(hInst,"ICON_69");
              hicon3 = LoadIcon(hInst,"ICON_70");
              hicon4 = LoadIcon(hInst,"ICON_71");
              hicon5 = LoadIcon(hInst,"ICON_72");
              hicon6 = LoadIcon(hInst,"ICON_73");
              hicon7 = LoadIcon(hInst,"ICON_74");
	      hicon8 = LoadIcon(hInst,"ICON_75");
              break;
          case 10:
              hicon1 = LoadIcon(hInst,"ICON_76");
              hicon2 = LoadIcon(hInst,"ICON_77");
	      hicon3 = LoadIcon(hInst,"ICON_78");
              hicon4 = LoadIcon(hInst,"ICON_79");
              hicon5 = LoadIcon(hInst,"ICON_80");
              hicon6 = LoadIcon(hInst,"ICON_81");
              hicon7 = LoadIcon(hInst,"ICON_82");
	      hicon8 = LoadIcon(hInst,"ICON_83");
              break;
          case 11:
              hicon1 = LoadIcon(hInst,"ICON_84");
              hicon2 = LoadIcon(hInst,"ICON_85");
              hicon3 = LoadIcon(hInst,"ICON_86");
	      hicon4 = LoadIcon(hInst,"ICON_87");
              hicon5 = LoadIcon(hInst,"ICON_88");
              hicon6 = LoadIcon(hInst,"ICON_89");
              hicon7 = LoadIcon(hInst,"ICON_90");
	      hicon8 = LoadIcon(hInst,"ICON_91");
              break;
          case 12:
              hicon1 = LoadIcon(hInst,"ICON_92");
              hicon2 = LoadIcon(hInst,"ICON_93");
              hicon3 = LoadIcon(hInst,"ICON_94");
              hicon4 = LoadIcon(hInst,"ICON_95");
	      hicon5 = LoadIcon(hInst,"ICON_96");
              hicon6 = LoadIcon(hInst,"ICON_97");
              hicon7 = LoadIcon(hInst,"ICON_98");
	      hicon8 = LoadIcon(hInst,"ICON_99");
              break;
          case 13:
              hicon1 = LoadIcon(hInst,"ICON_100");
              hicon2 = LoadIcon(hInst,"ICON_101");
              hicon3 = LoadIcon(hInst,"ICON_102");
              hicon4 = LoadIcon(hInst,"ICON_103");
              hicon5 = LoadIcon(hInst,"ICON_104");
	      hicon6 = LoadIcon(hInst,"ICON_105");
              hicon7 = LoadIcon(hInst,"ICON_106");
	      hicon8 = LoadIcon(hInst,"ICON_107");
              break;
          case 14: 
              hicon1 = LoadIcon(hInst,"ICON_108");
              hicon2 = LoadIcon(hInst,"ICON_109");
              hicon3 = LoadIcon(hInst,"ICON_110");
              hicon4 = LoadIcon(hInst,"ICON_111");
              hicon5 = LoadIcon(hInst,"ICON_112");
              hicon6 = LoadIcon(hInst,"ICON_113");
	      hicon7 = LoadIcon(hInst,"ICON_114");
	      hicon8 = LoadIcon(hInst,"ICON_115");
              break;
          case 15:
              hicon1 = LoadIcon(hInst,"ICON_116");
              hicon2 = LoadIcon(hInst,"ICON_117");
              hicon3 = LoadIcon(hInst,"ICON_118");
              hicon4 = LoadIcon(hInst,"ICON_119");
              hicon5 = LoadIcon(hInst,"ICON_120");
              hicon6 = LoadIcon(hInst,"ICON_121");
              hicon7 = LoadIcon(hInst,"ICON_122");
	      hicon8 = LoadIcon(hInst,"ICON_123");
	      break;
     }  // switch whichset
     DrawIcon(hDC,60,10,hicon1);
     DrawIcon(hDC,100,10,hicon2);
     DrawIcon(hDC,140,10,hicon3);
     DrawIcon(hDC,180,10,hicon4);
     DrawIcon(hDC,220,10,hicon5);
     DrawIcon(hDC,260,10,hicon6);
     DrawIcon(hDC,300,10,hicon7);
     DrawIcon(hDC,340,10,hicon8);
     DrawIcon(hDC,380,10,hicon9);
     SelectPalette(hDC, oldpal, FALSE);
     ReleaseDC(hWndMain,hDC);
     DestroyIcon(hicon1);
     DestroyIcon(hicon2);
     DestroyIcon(hicon3);
     DestroyIcon(hicon4);
     DestroyIcon(hicon5);
     DestroyIcon(hicon6);
     DestroyIcon(hicon7);
     DestroyIcon(hicon8);
     DestroyIcon(hicon9);
     // remember to show which tool
     ToolSet = whichset;
     DrawTool = ICONDRAW;
     CurrentBoxPos = 2;
     BoxAroundTool(1);
}


void ShowText(unsigned char c)
{
     HDC               hDC;
     RECT              arect;
     int               i;
     HFONT             hfont;
     HPALETTE          oldpal;

     SetRect(&arect,TextX,TextY,hres-50,vres-50);
     hDC = GetDC(phwnd);
     oldpal= SelectPalette(hDC, hwndpal, FALSE);
     RealizePalette(hDC);
     BitBlt(hDC,0,0,hres - 50,vres - 50,savebitmapDC,0,0,SRCCOPY);
     hfont = CreateFontIndirect(&MainFontRec);
     SelectObject(hDC, hfont);
     SetBkMode(hDC,TRANSPARENT);
     SetTextColor(hDC,CurrentColor | 0x2000000L);
     i = lstrlen(globaltextbuf);
     if(c == 0x08){      // backspace
	if(i > 0){
	   globaltextbuf[i] = '\0';
	   globaltextbuf[i - 1] = '\0';
	   globaltextbuf[i - 2] = '|';
	 }
     }
     else{
	if(i > 253){
	   SelectPalette(hDC, oldpal, FALSE);
	   ReleaseDC(phwnd,hDC);
           DeleteObject(hfont);
	   return;
        }
	if(i > 0){
	   globaltextbuf[i - 1] = c;
	   globaltextbuf[i] = '|';
	}
	else{
	   globaltextbuf[i] = c;
	   globaltextbuf[++i] = '|';
        }
     }
     DrawText(hDC,globaltextbuf,lstrlen(globaltextbuf),&arect,DT_NOPREFIX|DT_LEFT|DT_WORDBREAK);
     SetBkMode(hDC,OPAQUE);
     SelectPalette(hDC, oldpal, FALSE);
     ReleaseDC(phwnd,hDC);
     DeleteObject(hfont);
}

void cleanuptext(void)
{
     HDC               hDC;
     RECT              arect;
     int               i;
     HFONT             hfont;
     HPALETTE          oldpal;

     SetRect(&arect,TextX,TextY,hres-50,vres-50);
     hDC = GetDC(phwnd);
     oldpal = SelectPalette(hDC, hwndpal, FALSE);
     RealizePalette(hDC);
     BitBlt(hDC,0,0,hres - 50,vres - 50,savebitmapDC,0,0,SRCCOPY);
     hfont = CreateFontIndirect(&MainFontRec);
     SelectObject(hDC, hfont);
     SetBkMode(hDC,TRANSPARENT);
     SetTextColor(hDC,CurrentColor | 0x2000000L);
     i = lstrlen(globaltextbuf);
     globaltextbuf[i - 1] = '\0';
     globaltextbuf[i] = '\0';
     DrawText(hDC,globaltextbuf,lstrlen(globaltextbuf),&arect,DT_NOPREFIX|DT_LEFT|DT_WORDBREAK);
     SetBkMode(hDC,OPAQUE);
     SelectPalette(hDC, oldpal, FALSE);
     ReleaseDC(phwnd,hDC);
     DeleteObject(hfont);
     DeleteDC(savebitmapDC);
     DeleteObject(hsavebitmap);
     DoingText = FALSE;
     ReadyToDoText = FALSE;
     DrawTools1();
}

void DrawLineSet(void)
{
     HDC               hDC;
     HPEN              hPen2, hPen3, hop;
     int               i;
     char              buf[20];
     HPALETTE          oldpal;

     DrawNoSet();
     hDC = GetDC(hWndMain);
     oldpal = SelectPalette(hDC, hwndpal, FALSE);
     RealizePalette(hDC);
     // create pens
     hPen2 = CreatePen(PS_SOLID,1,BLACK | 0x2000000L);
     hPen3 = CreatePen(PS_SOLID,2,RED | 0x2000000L);
     // now draw lines into place
     hop = SelectObject(hDC,hPen2);
     // single pixel wide
     Line(hDC, 430, 10, 430, 40);
     // 2 pixel wide
     Line(hDC, 449, 10, 449, 40);
     Line(hDC, 450, 10, 450, 40);
     // 3 pixel wide
     for(i = 469; i < 472; i++)
	 Line(hDC, i, 10, i, 40);
     // 4 pixel wide
     for(i = 488; i < 492; i++)
	 Line(hDC, i, 10, i, 40);
     // 5 pixel wide
     for(i = 507; i < 512; i++)
	 Line(hDC, i, 10, i, 40);
     // 6 pixel wide
     for(i = 527; i < 533; i++)
	 Line(hDC, i, 10, i, 40);
     // And now, draw the box around the current line!!!!!!!
     SelectObject(hDC,hop);
     SelectObject(hDC,hPen3);
     i = ((DrawWidth - 1) * 20) + 425;
     Box(hDC, i, 7,i + 10, 42); 
     // and clean up
     SelectObject(hDC,hop);
     SelectPalette(hDC, oldpal, FALSE);
     ReleaseDC(hWndMain,hDC);
     DeleteObject(hPen2);
     DeleteObject(hPen3);
     LineSet = TRUE;
}

    
void DrawNoSet(void)
{
     HDC               hDC;
     HBRUSH            hBrush1, hobr;
     HPEN              hBorderPen, hop;
     int               i, acyan;
     HPALETTE          oldpal;


     hDC = GetDC(hWndMain);
     oldpal = SelectPalette(hDC, hwndpal, FALSE);
     RealizePalette(hDC);
     hBorderPen = CreatePen(PS_SOLID, 1,TURQUOISE1 | 0x2000000L);
     hBrush1 = CreateSolidBrush(TURQUOISE1 | 0x2000000L);
     hop = SelectObject(hDC, hBorderPen);
     hobr = SelectObject(hDC, hBrush1);
     Rectangle(hDC,418,0,540,50);
     SelectObject(hDC,hop);
     SelectObject(hDC,hobr);
     SelectPalette(hDC, oldpal, FALSE);
     ReleaseDC(hWndMain,hDC);
     DeleteObject(hBorderPen);
     DeleteObject(hBrush1);
     LineSet = FALSE;
}

void BlankIconArea(int icondraw)  // used in picture routines
{
     HDC               hDC;
     HICON             hicon;
     HPALETTE          oldpal;

     HorizDitherPattern();
     hDC = GetDC(hWndMain);
     oldpal = SelectPalette(hDC, hwndpal, FALSE);
     RealizePalette(hDC);
     if(icondraw){
	hicon = LoadIcon(hInst,"ICON_128");
	DrawIcon(hDC,480,10,hicon);
     }
     SelectPalette(hDC, oldpal, FALSE);
     ReleaseDC(hWndMain,hDC);
     if(icondraw) DestroyIcon(hicon);
}

/*

    File and Directory stuff

    These routines allow us to to work with data files (paintings) directly
    rather than rely strictly on the "normal" Win3 file system. Essentially
    what happens here is to present a series of pictures on screen that are
    mini-paintings (i.e. thumbnails) that a child can choose from. 

    The object of doing things this way is simply due to the target audience.
    We don't need 6 year olds trying to navigate Windows dialogs and the
    file system. It is also in keeping with the UI mapped out for this program;
    everything is consistent.

    We call FindOurDirectory in the WM_PAINT procedure of the main app window
    as we start the app. TheFileList() is called as needed; it fills filearray[]
    with a list of valid filenames.
     
*/

void FindOurDirectory(void)
{
     HANDLE     us;
     char       buffer[100];
     int        bufflen, i;
     struct ffblk f;

     // this is a trick we play to find our directory so that
     // we can load/save files. First, we look for our name
     // and we use this to get Windows to pass us the directory
     // we started from.
     us = GetModuleHandle("paint.exe");
     bufflen = GetModuleFileName(us,buffer,100);
     // this returns the full path!
     // parse for first backslash (i.e. get rid of the filename)
     for(i = bufflen; i > 0; i--){
	 if(buffer[i] == '\\') break;
     }
     memset(ourdir,'\0',100);   // NULL it out first!
     strncpy(ourdir,buffer,i);
}
        
void TheFileList(void)
{
     char   buf[15];
     int    done, i;
     struct ffblk f;

     chthedir(OUT);                        // put us in our own directory/folder
     for(i = 0; i < 79; i++)               // reset file array to NULLs
	 memset(filearray[i],'\0',15);
     memset(buf,'\0',15);                  // make sure this is NULLs, too
     numfiles = 1;
     // the "look" routine
     done = findfirst("*.dib",&f,0);
     while(!done){                         // get all DATA files 
	   sprintf(buf,"%s", f.ff_name);
           if(strlen(buf) > 1){
	      strncat(filearray[numfiles],buf,strlen(buf)); 
	      strupr(filearray[numfiles++]);
           }
	   memset(buf,'\0',15);            // reset to NULLs
	   done = findnext(&f);
           if(numfiles > 78) break;        // at least up to 80 
     }
     // numfiles is actually 1 greater than the number of files since the
     // filearray[] base we really use is 1 and not 0.
}

/************************************************************************

    This group of routines is responsible for OPENing a picture to edit.

*************************************************************************/     


/*
    Respond to the young user wanting to OPEN a file. At this point the
    DISK/PRINT button has been pressed and the DISK->PICTURE icon has been
    selected.
*/


void DiskToPicSelected(void)
{

     numfiles = 1;
     firstfileshown = 1;
     lastfileshown = 1;

     TheFileList();              // get valid picture file list
     if(numfiles < 2){           // none available
        DrawTools1();            // reset to default drawing conditions
	return;
     }    
     firstfileshown = 1;
     if(numfiles > 5)
	lastfileshown = 5;
     else
	lastfileshown = numfiles;
     DisplayPics();
     Thumbnails = TRUE;
}


 // we have more than 5 pictures to see and the user wants to see more

void MorePicsSelected(void)
{
     int       first,last;

     first = lastfileshown + 1;
     if(first > numfiles){      // we have cycled all the way, so restart.
	firstfileshown = 1;
	lastfileshown = 5;
     }
     else{
        firstfileshown = first;   // reset the pointer
        if((firstfileshown + 4) < numfiles)
	    lastfileshown = firstfileshown + 4;
        else
	    lastfileshown = numfiles;
     }
     DisplayPics();
}

void DisplayPics(void)
{
     int         i,j, x;
     OFSTRUCT    of;
     HFILE       fh;
     HDC         hdc;
     HANDLE      dh;
     HPALETTE    oldpal;

     if(numfiles > 6)
	BlankIconArea(1);      // draw an arrow (MORE) icon
     else
	BlankIconArea(0);      // don't need a more icon

     hdc = GetDC(hWndMain);
     oldpal = SelectPalette(hdc, hwndpal, FALSE);
     RealizePalette(hdc);
     SetStretchBltMode(hdc,COLORONCOLOR);
     for(i = firstfileshown, j = 0; i <= lastfileshown; i++, j++){
	 (HFILE)fh= OpenFile(filearray[i],&of,OF_READ); // open the file
         if((HFILE)fh != -1){
	    (HANDLE)dh = OpenDIB((HFILE)fh);                 // read the DIB
	    _lclose((HFILE)fh);
	    x = (j * 80) + 60;
	    StretchDibBlt(hdc,x,5,60,40,(HANDLE)dh,0,0,-1,-1,SRCCOPY,0);
	    GlobalFree((HANDLE)dh);
         }
     }
     SelectPalette(hdc, oldpal, FALSE);
     ReleaseDC(hWndMain,hdc);
}


void ColorBookPics(int setnum)
{
     int         i,j, x;
     OFSTRUCT    of;
     HFILE       fh;
     HDC         hdc;
     HANDLE      dh;
     char        bmpname[20];
     HPALETTE    oldpal;

     hdc = GetDC(hWndMain);
     oldpal = SelectPalette(hdc, hwndpal, FALSE);
     RealizePalette(hdc);
     SetStretchBltMode(hdc,COLORONCOLOR);
     if(setnum == 1){
        for(i = 0; i <= 4; i++){
	    // This section is to allow a bmp to be read in as a
	    // color book module picture that is sized to the
	    // thumbnail. Essentially, the idea is to have the
	    // tiny little picture the same name as the BMP to read
	    // EXCEPT that the thumbnail will have a slightly
	    // different file extension... e.g. if the BMP to read
	    // was ANIMAL1.BMP, the thumbnail would be stored as
	    // ANIMAL1.BM1...
	    memset(bmpname,'\0',20);           // reset the char array
	    strcpy(bmpname, colorbmpname[i]);  // copy the name
	    x = lstrlen(bmpname);              // find the length
	    if(x > 4) bmpname[--x] = '1';      // if long enough, add a "1" to the end.
	    fh= OpenFile(bmpname,&of,OF_READ); // open the file
            if(fh != -1){
	       (HANDLE)dh = OpenDIB(fh);          // read the Bitmap
	       _lclose(fh);
	       x = (i * 80) + 60;
	       StretchDibBlt(hdc,x,5,60,40,(HANDLE)dh,0,0,-1,-1,SRCCOPY,0);
	       GlobalFree((HANDLE)dh);
            }
	}
     }
     else{
	for(i = 5; i <= 9; i++){
	    memset(bmpname,'\0',20);           // reset the char array
	    strcpy(bmpname, colorbmpname[i]);  // copy the name
	    x = lstrlen(bmpname);              // find the length
	    if(x > 4) bmpname[--x] = '1';      // if long enough, add a "1" to the end.
	    fh= OpenFile(bmpname,&of,OF_READ); // open the file
            if(fh != -1){
	       (HANDLE)dh = OpenDIB(fh);          // read the Bitmap
	       _lclose(fh);
	       x = ((i - 5) * 80) + 60;
	       StretchDibBlt(hdc,x,5,60,40,(HANDLE)dh,0,0,-1,-1,SRCCOPY,0);
	       GlobalFree((HANDLE)dh);
            }
	}
     }
     SelectPalette(hdc, oldpal, FALSE);
     ReleaseDC(hWndMain,hdc);
}

void ColorBookPicked(int whoIam)
{
     OFSTRUCT    of;
     HFILE       filehandle;
     HDC         hdc;
     HANDLE      dibhandle;
     HPALETTE    oldpal;

     hdc = GetDC(phwnd);
     oldpal = SelectPalette(hdc, hwndpal, FALSE);
     RealizePalette(hdc);
     if(colorset == 1)
	filehandle = OpenFile(colorbmpname[whoIam],&of,OF_READ); // open the file
     else
	filehandle = OpenFile(colorbmpname[whoIam + 5],&of,OF_READ); // open the file
     if(filehandle != -1){
	dibhandle = OpenDIB(filehandle);                 // read the DIB
        _lclose(filehandle);
        StretchDibBlt(hdc,0,0,hres - 50,vres - 50,dibhandle,0,0,-1,-1,SRCCOPY,0);
	GlobalFree(dibhandle);
     }
     SelectPalette(hdc, oldpal, FALSE);
     ReleaseDC(phwnd,hdc);
}


// we now know that the user has selected a picture, and we have a number
// that ought to point to the proper picture file

void UserPickedMe(int whoIam)
{
     OFSTRUCT    of;
     HFILE       filehandle;
     HDC         hdc;
     HANDLE      dibhandle;
     HPALETTE    oldpal;

     if(whoIam > numfiles) return; 
     hdc = GetDC(phwnd);
     oldpal = SelectPalette(hdc, hwndpal, FALSE);
     RealizePalette(hdc);
     if(trashit == FALSE){
	(HFILE)filehandle = OpenFile(filearray[whoIam],&of,OF_READ); // open the file
        (HANDLE)dibhandle = OpenDIB((HFILE)filehandle);                 // read the DIB
        _lclose((HFILE)filehandle);
	StretchDibBlt(hdc,0,0,hres - 50,vres - 50,(HANDLE)dibhandle,0,0,-1,-1,SRCCOPY,0);
	GlobalFree((HANDLE)dibhandle);
     }
     else{    // trash can was selected, so kill the file
	remove(filearray[whoIam]);
	MessageBox(hWndMain,"PICTURE DELETED!"," ", MB_OK | MB_ICONINFORMATION | MB_SYSTEMMODAL);
     }
     SelectPalette(hdc, oldpal, FALSE);
     ReleaseDC(phwnd,hdc);
     trashit = FALSE;
     Thumbnails = FALSE;
     ShowWindow(hwnd8,SW_SHOWNA);  // show undo window
     DrawTools1();
}

/********************* End of Picture Open Routines *****************************/

/*
     The user wants to save the current picture.

*/

void PicToDiskSelected(void)
{
     char     afilename[200], tempbuffer[100], namebuffer[100];
     HDC      hdc, memdc;
     int      i, j, nbpointer;
     HFILE    fh;
     OFSTRUCT of;
     HANDLE   hdib;
     HBITMAP  hbitmap;
     HPALETTE oldpal, op1;


     SaveToUndoPic();          // make a copy of the picture
     chthedir(OUT);            // make sure we're looking at the right place
     if(DiskOK() == 0) return; // complain and quit if not enough room!
     hdc = GetDC(phwnd);
     oldpal = SelectPalette(hdc, hwndpal, FALSE);
     RealizePalette(hdc);
     // First, we need to create a filename to use. Since the UI
     // doesn't rely on filenames we can name it anything we like.
     // This keeps the user from having to worry about having to name things.

     memset(afilename,'\0',200);               // make sure buffers are clean
     memset(namebuffer,'\0',100);
     memset(tempbuffer,'\0',100);
     GetTempFileName(0,"A",0,afilename);     // create a unique name
     // name will look like d:\path\name.tmp, so....
     // parse to get first backslash 
     for(i = 200; i > 0; i--){
	 if(afilename[i] == '\\') break;
     }
     // i now points to the backslash that separates the
     // filename from the path, so......
     // copy char by char into tempbuffer
     nbpointer = 0;
     for(j = (i + 1); j < (i + 16); j++){
         if(afilename[j] == '\0') break;
	 tempbuffer[nbpointer++] = afilename[j];
     }
     tempbuffer[0] = 'K';
     // namebuffer now has a copy of the filename to use...
     // and we copy all but the extension.
     strncpy(namebuffer,tempbuffer,lstrlen(tempbuffer) - 4);
     // now we append our own DIB extension to it...
     // and we have the COMPLETE filename to use. Next we
     // need to get a File Handle.
     strcat(namebuffer,".DIB");
     chthedir(OUT);
     (HFILE)fh = OpenFile(namebuffer,&of,OF_CREATE);
     //
     // look for us to bomb out
     //
     // per Amory Gabel 9/94
     //
     if((HFILE)fh == -1){   // disk too full error
	 MessageBox(hWndMain,"Write Error!"," ", MB_OK | MB_ICONEXCLAMATION | MB_SYSTEMMODAL);
	 DeleteDC(memdc);
         DeleteObject(hbitmap);
	 DeleteObject((HFILE)fh);
	 SelectPalette(hdc, oldpal, FALSE);
	 ReleaseDC(phwnd,hdc);
	 return;
     }

     // Second, we need to capture phwnd's picture and create a DIB for
     // it which we will then write to the disk.
     memdc = CreateCompatibleDC(hdc);
     hbitmap = CreateCompatibleBitmap(hdc,hres - 53,vres - 53);
     SelectObject(memdc,hbitmap);
     op1 = SelectPalette(memdc, hwndpal, FALSE);
     RealizePalette(memdc);
     BitBlt(memdc,0,0,hres - 53,vres - 53,hdc,0,0,SRCCOPY);

     // hbitmap now has a copy of the screen pic.
     (HANDLE)hdib = DibFromBitmap(hbitmap,BI_RLE8,8,hwndpal,DIB_RGB_COLORS);
     SelectPalette(hdc, op1, FALSE);
     //BitBlt(hdc,0,0,hres - 53,vres - 53,memdc,0,0,SRCCOPY);
     WriteDIB((HFILE)fh,(HANDLE)hdib);
     _lclose((HFILE)fh);
     SelectPalette(hdc, op1, FALSE);
     DeleteDC(memdc);
     DeleteObject(hbitmap);
     GlobalFree((HANDLE)hdib);
     MessageBox(hWndMain,"PICTURE SAVED!"," ", MB_OK | MB_ICONINFORMATION | MB_SYSTEMMODAL);
     SelectPalette(hdc, oldpal, FALSE);
     ReleaseDC(phwnd,hdc);
}


void PrintIt(void)
{
     HDC       hdc, prdc,memdc;
     HBITMAP   hbitmap;
     HANDLE    hdib;
     char      buf[60], cprn[64], *cdrv, *cdev, *cop;
     int       pw,ph,tst;
     HPALETTE  oldpal, op1;

     SaveToUndoPic();
     hdc = GetDC(phwnd);
     SelectPalette(hdc, hwndpal, FALSE);
     oldpal = RealizePalette(hdc);
     memdc = CreateCompatibleDC(hdc);
     hbitmap = CreateCompatibleBitmap(hdc,hres - 53,vres - 53);
     SelectObject(memdc,hbitmap);
     op1 = SelectPalette(memdc, hwndpal, FALSE);
     RealizePalette(memdc);
     BitBlt(memdc,0,0,hres - 53,vres - 53,hdc,0,0,SRCCOPY);
     hdib = DibFromBitmap(hbitmap,BI_RGB,8,hwndpal,DIB_RGB_COLORS);
     GetProfileString("Windows","device","",cprn,64);
     cdev = strtok(cprn,",");
     cdrv = strtok(NULL,",");
     cop =  strtok(NULL,",");
     prdc = CreateDC(cdrv,cdev,cop,NULL);
     pw = GetDeviceCaps(prdc,HORZRES);
     ph = GetDeviceCaps(prdc,VERTRES);
     if(ph > pw){
	ph /= 2;
	ph += (ph / 5);
     }
     tst = Escape(prdc,STARTDOC,7,"KAPRINT",NULL);
     if(tst){
	memset(buf,'\0',50);
	sprintf(buf," ");
	TextOut(prdc,50,50,buf,lstrlen(buf));
	StretchDibBlt(prdc,0,0,pw,ph,
		      hdib, 0,0,-1,-1,SRCCOPY,DIB_RGB_COLORS);
	Escape(prdc,NEWFRAME,NULL,NULL,NULL);
	Escape(prdc,  ENDDOC,NULL,NULL,NULL);
     }
     SelectPalette(memdc, op1, FALSE);
     DeleteDC(memdc);
     DeleteObject(hbitmap);
     GlobalFree(hdib);
     DeleteDC(prdc);
     MessageBox(hWndMain,"PICTURE PRINTED!"," ", MB_OK | MB_ICONINFORMATION | MB_SYSTEMMODAL);
     BitBlt(hdc,0,0,hres-50,vres-50,undodc,0,0,SRCCOPY);
     SelectPalette(hdc, oldpal, FALSE);
     ReleaseDC(phwnd,hdc);

}


void PlaySound(int which)
{
    char       buf[20];

    memset(buf,20,'\0');                // get the buffer ready
    chthedir(IN);                      // make sure we're in our directory
    switch(which){
       case 1:
	    strcpy(buf,"vacuum.wav");      
	    break;
       case 2:
	    strcpy(buf,"uhoh.wav");
	    break;
       case 3:
	    strcpy(buf,"splat.wav");
	    break;
       case 4:
	    strcpy(buf,"spray.wav");
	    break;
       case 5:
	    strcpy(buf,"plop.wav");
	    break;
       case 6:
	    strcpy(buf,"bomb.wav");
	    break;
       case 7:
	    strcpy(buf,"typewrit.wav");
	    break;
       case 8:
	    strcpy(buf,"erase1.wav");
	    break;
       case 9:
	    strcpy(buf,"erase2.wav");
	    break;
       case 10:
	    strcpy(buf,"erase3.wav");
	    break;
       case 11:
	    strcpy(buf,"erase4.wav");
	    break;
       case 12:
	    strcpy(buf,"radio.wav");
	    break;
       case 13:
	    strcpy(buf,"tear.wav");
	    break;
       case 14:
	    strcpy(buf,"bucket.wav");
	    break;
       case 15:
	    strcpy(buf,"toilet.wav");
	    break;
       case 16:
	    strcpy(buf,"thud.wav");
	    break;
       case 17:
	    strcpy(buf,"bell.wav");
	    break;
       case 18:
	    strcpy(buf,"black.wav");
	    break;
       case 19:
	    strcpy(buf,"bottle.wav");
	    break;
       case 20:
	    strcpy(buf,"bowtie.wav");
	    break;
       case 21:
	    strcpy(buf,"box.wav");
	    break;
       case 22:
	    strcpy(buf,"boxfill.wav");
	    break;
       case 23:
	    strcpy(buf,"brown.wav");
	    break;
       case 24:
	    strcpy(buf,"buterfly.wav");
	    break;
       case 25:
	    strcpy(buf,"candican.wav");
	    break;
       case 26:
	    strcpy(buf,"cat.wav");
	    break;
       case 27:
	    strcpy(buf,"circle.wav");
	    break;
       case 28:
	    strcpy(buf,"circle2.wav");
	    break;
       case 29:
	    strcpy(buf,"clock.wav");
	    break;
       case 30:
	    strcpy(buf,"cloud.wav");
	    break;
       case 31:
	    strcpy(buf,"clover.wav");
	    break;
       case 32:
	    strcpy(buf,"colrsphr.wav");
	    break;
       case 33:
	    strcpy(buf,"column.wav");
	    break;
       case 34:
	    strcpy(buf,"cow.wav");
	    break;
       case 35:
	    strcpy(buf,"cowboots.wav");
	    break;
       case 36:
	    strcpy(buf,"dino.wav");
	    break;
       case 37:
	    strcpy(buf,"dino2.wav");
	    break;
       case 38:
	    strcpy(buf,"dog.wav");
	    break;
       case 39:
	    strcpy(buf,"duck.wav");
	    break;
       case 40:
	    strcpy(buf,"erascree.wav");
	    break;
       case 41:
	    strcpy(buf,"eraser.wav");
	    break;
       case 42:
	    strcpy(buf,"exit.wav");
	    break;
       case 43:
	    strcpy(buf,"fan.wav");
	    break;
       case 44:
	    strcpy(buf,"fire.wav");
	    break;
       case 45:
	    strcpy(buf,"flagpole.wav");
	    break;
       case 46:
	    strcpy(buf,"flesh.wav");
	    break;
       case 47:
	    strcpy(buf,"flower.wav");
	    break;
       case 48:
	    strcpy(buf,"goldchst.wav");
	    break;
       case 49:
	    strcpy(buf,"goose.wav");
	    break;
       case 50:
	    strcpy(buf,"grass.wav");
	    break;
       case 51:
	    strcpy(buf,"gray.wav");
	    break;
       case 52:
	    strcpy(buf,"green.wav");
	    break;
       case 53:
	    strcpy(buf,"green2.wav");
	    break;
       case 54:
	    strcpy(buf,"hay.wav");
	    break;
       case 55:
	    strcpy(buf,"heart.wav");
	    break;
       case 56:
	    strcpy(buf,"horse.wav");
	    break;
       case 57:
	    strcpy(buf,"hourglas.wav");
	    break;
       case 58:
	    strcpy(buf,"jelifish.wav");
	    break;
       case 59:
	    strcpy(buf,"linefill.wav");
	    break;
       case 60:
	    strcpy(buf,"lips.wav");
	    break;
       case 61:
	    strcpy(buf,"lock.wav");
	    break;
       case 62:
	    strcpy(buf,"magnify.wav");
	    break;
       case 63:
	    strcpy(buf,"mailbox.wav");
	    break;
       case 64:
	    strcpy(buf,"moon.wav");
	    break;
       case 65:
	    strcpy(buf,"octopus.wav");
	    break;
       case 66:
	    strcpy(buf,"paintstk.wav");
	    break;
       case 67:
	    strcpy(buf,"penguin.wav");
	    break;
       case 68:
	    strcpy(buf,"phone.wav");
	    break;
       case 69:
	    strcpy(buf,"pig.wav");
	    break;
       case 70:
	    strcpy(buf,"pink.wav");
	    break;
       case 71:
	    strcpy(buf,"planet.wav");
	    break;
       case 72:
	    strcpy(buf,"pumpkin.wav");
	    break;
       case 73:
	    strcpy(buf,"rabbit.wav");
	    break;
       case 74:
	    strcpy(buf,"recycle.wav");
	    break;
       case 75:
	    strcpy(buf,"recycle2.wav");
	    break;
       case 76:
	    strcpy(buf,"red.wav");
	    break;
       case 77:
	    strcpy(buf,"ring.wav");
	    break;
       case 78:
	    strcpy(buf,"royalblu.wav");
	    break;
       case 79:
	    strcpy(buf,"scarecro.wav");
	    break;
       case 80:
	    strcpy(buf,"scissor.wav");
	    break;
       case 81:
	    strcpy(buf,"shark.wav");
	    break;
       case 82:
	    strcpy(buf,"spacship.wav");
	    break;
       case 83:
	    strcpy(buf,"spray.wav");
	    break;
       case 84:
	    strcpy(buf,"star.wav");
	    break;
       case 85:
	    strcpy(buf,"sun.wav");
	    break;
       case 86:
	    strcpy(buf,"sunglass.wav");
	    break;
       case 87:
	    strcpy(buf,"teepee.wav");
	    break;
       case 88:
	    strcpy(buf,"tools.wav");
	    break;
       case 89:
	    strcpy(buf,"toywagon.wav");
	    break;
       case 90:
	    strcpy(buf,"tractor.wav");
	    break;
       case 91:
	    strcpy(buf,"transtoo.wav");
	    break;
       case 92:
	    strcpy(buf,"trashca2.wav");
	    break;
       case 93:
	    strcpy(buf,"trashcan.wav");
	    break;
       case 94:
	    strcpy(buf,"trifill.wav");
	    break;
       case 95:
	    strcpy(buf,"turkey.wav");
	    break;
       case 96:
	    strcpy(buf,"turtle.wav");
	    break;
       case 97:
	    strcpy(buf,"umbrela.wav");
	    break;
       case 98:
	    strcpy(buf,"wicker.wav");
	    break;
       case 99:
	    strcpy(buf,"yellobox.wav");
	    break;
       case 100:
	    strcpy(buf,"yellow.wav");
	    break;
       case 101:
	    strcpy(buf,"thud2.wav");
	    break;
       case 102:
	    strcpy(buf,"thikpen1.wav");
	    break;
       case 103:
	    strcpy(buf,"thikpen2.wav");
	    break;
       case 104:
	    strcpy(buf,"thikpen3.wav");
	    break;
       case 105:
	    strcpy(buf,"thikpen4.wav");
	    break;
       case 106:
	    strcpy(buf,"thikpen5.wav");
	    break;
       case 107:
	    strcpy(buf,"clink.wav");
	    break;
       case 108:
	    strcpy(buf,"w2.wav");
	    break;

    }
    sndPlaySound(buf,SND_ASYNC);         // and play it...
}

int DiskOK(void)
{
    struct  dfree   df;
    long    bavail, picsize, xdim, ydim;

    xdim = hres - 50;
    ydim = vres - 50;
    // double the x*y dimension just to be safe in case
    // the RLE compression algorithm screws up.
    picsize = (xdim * ydim) * 2;
    // default disk...
    getdfree(0,&df);
    bavail = ((long)(df.df_bsec * df.df_sclus)) * df.df_avail;
    if(bavail < (savelevel + picsize)){
       MessageBox(hWndMain,"Not enough space to Save!","Uh Oh!", MB_OK | MB_ICONEXCLAMATION | MB_SYSTEMMODAL);
       return (0);
    }
    return (1);
}

void chthedir(int thedir)
{
     if(thedir == IN){
	setdisk(indrive);
	chdir(ourdir);
     }
     else{
        setdisk(outdrive);
	chdir(outdir);
     }
}


void DrawLine(int x1, int y1, int x2, int y2, int Width, COLORREF Color)
{
     HDC          hdc;
     HPALETTE     oldpal;
     HPEN         hPen, oldpen;
     int          i, j, k;


     hdc = GetDC(phwnd);
     oldpal = SelectPalette(hdc, hwndpal, FALSE);
     RealizePalette(hdc);
     hPen = CreatePen(PS_SOLID, Width, Color | 0x2000000L);
     oldpen = SelectObject(hdc,hPen);
     Line(hdc,x1,y1,x2,y2);
     SelectObject(hdc,oldpen);
     SelectPalette(hdc, oldpal, FALSE);
     ReleaseDC(phwnd,hdc);
     DeleteObject(hPen);
}

