
typedef unsigned char xByte;
typedef unsigned int  xWord;
typedef unsigned long xDword;
typedef int           xFid;

const long xSector=512;

class xdfFile
{
       private:
           xFid    f;
       public:
           xdfFile(const char*);
           ~xdfFile();

           long seek(long);
           long write(void *, long);
           long read(void *, long);
};

class xdfFAT
{
       private:
           xByte   b[512*11];
           xdfFile& f;
       public:
           xdfFAT(xdfFile&);
           xdfFAT(xdfFile&, int media);

           void read(void);
           void write(void);

           int  allocate(int num);
           void set(int num, int v);
           int  get(int num);

           void out(void);
};

struct xDirEntry
{
       xByte  name[11];
       xByte  attrib;
       xByte  reserv[10];
       xWord  time;
       xWord  date;
       xWord  clu;
       xDword len;
};


const int aRead=1;
const int aHidden=2;
const int aSystem=4;
const int aLabel=8;
const int aDir=16;
const int aArc=32;

class xdfRoot
{
       private:
           xDirEntry d[224];
           xdfFile& f;
       public:
           xdfRoot(xdfFile&);
           xdfRoot(xdfFile&,const char* );

           void read(void);
           void write(void);

           void create(const char*,int attr,long len,int clu);

           void out(void);
};

class xFile
{
       private:
           char _name[16];
           char _xname[12];
           xdfFile &f;

       public:
           xFile(xdfFile&, const char*);

           char *name(void);
           int  attr(void);
           long len(void);
           int  clust(void);

           void write(int c);
};
//  [c] BPC productions '95!         