#include <io.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys\stat.h>
#include "xdf.h"

// ===========================================
// XDF File class members
// ==========================================

xdfFile::xdfFile(const char* fname)
{
       f=open(fname,O_RDWR|O_CREAT,S_IWRITE| S_IREAD);
}

long xdfFile::seek(long l)
{
       return ::lseek(f,l*xSector,SEEK_SET);
}

long xdfFile::read(void *v, long l)
{
       return ::read(f,v,l);
}

long xdfFile::write(void *v, long l)
{
       return ::write(f,v,l);
}

xdfFile::~xdfFile()
{
       close(f);
}



// ===============================================
// XDFRoot class members
// ==============================================

xdfRoot::xdfRoot(xdfFile &_f): f(_f)
{
       for(int i=0;i<224;i++)
           d[i].name[0]=0;
}

xdfRoot::xdfRoot(xdfFile &_f, const char* label): f(_f)
{
       for(int i=0;i<224;i++)
       {
           for(int j=0;j<sizeof(xDirEntry);j++)
               ((xByte*)&d[i])[j]=0;
       }
       create(label,aLabel,0,0);
}

void xdfRoot::read(void)
{
       f.seek(23);
       f.read(d,224*sizeof(xDirEntry));
}

void xdfRoot::write(void)
{
       f.seek(23);
       f.write(d,224*sizeof(xDirEntry));
}

void xdfRoot::out(void)
{
       for(int i=0;i<224;i++)
       {
               printf("%.11s %x\n",d[i].name,d[i].clu);
       }
}

void xdfRoot::create(const char* n,int attr, long len, int clu)
{
       for(int i=0;i<224;i++)
       if(d[i].name[0]==0)
       {
               for(int j=0;j<11;j++)
                   d[i].name[j]=n[j];
               d[i].attrib=attr;
               d[i].clu=clu;
               d[i].len=len;
               break;
       }
}


// ======================================
// XDF FAT class members
// ========================================


void xdfFAT::read(void)
{
       f.seek(1);
       f.read(b,11*xSector);
}

void xdfFAT::write(void)
{
       f.seek(1);
       f.write(b,xSector*11);
       f.seek(20);
       f.write(b+xSector*8,xSector*3);
}

xdfFAT::xdfFAT(xdfFile& _f): f(_f)
{
//       read();
}

xdfFAT::xdfFAT(xdfFile& _f, int media): f(_f)
{
       for(int i=0;i<xSector*11;i++)
           b[i]=0;
       b[0]=media;
       b[1]=0xFF;
       b[2]=0xFF;
       set(2, 0xFF7);
       set(3, 0xFF7);
       set(4, 0xFF7);
       set(5, 0xFF7);
       set(6, 0xFF7);

}

void xdfFAT::set(int n, int m)
{
       if(n%2==0)
       {
               xWord t=*(xWord *)(b+n/2*3);
               t&=0xF000;
               t|=(m&0x0FFF);
               *(xWord *)(b+n/2*3)=t;
       }
       else
       {
               xWord t=*(xWord *)(b+n/2*3+1);
               t&=0x000F;
               t|=((m&0x0FFF)<<4);
               *(xWord *)(b+n/2*3+1)=t;
       }
}

int xdfFAT::get(int n)
{
       if(n%2==0)
       {
               xWord t=*(xWord *)(b+n/2*3);
               t&=0x0FFF;
               return t;
       }
       else
       {
               xWord t=*(xWord *)(b+n/2*3+1);
               t&=0xFFF0;
               return t>>4;
       }
}


int xdfFAT::allocate(int num)
{
   if(num>0)
   {
       for(int i=2;i<11*xSector*2/3-num;i++)
       if(get(i)==0)
       {
               int l=i;
               for(int j=0;j<num-1;j++)
                   set(i+j,i+j+1);
               set(i+num-1,0xFFF);
               return l;
       }
    }
    return 0;
}


void xdfFAT::out(void)
{
       for(int i=0;i<11*xSector-1;i+=3)
       {
               xWord t;
               t=*(xWord *)(b+i);
               printf("%.3x ", t&0xFFF);
               t=*(xWord *)(b+i+1);
               printf("%.3x ", t>>4);
       }
}



// ================================================
// XDF disk file class members
// ================================================

xFile::xFile(xdfFile& _f, const char* n): f(_f)
{
       for(int j=0;j<16;j++) _name[j]=n[j];
       for(j=0;j<12;j++) _xname[j]=' ';

       int i=0; j=0;
       while((n[i]<>'.')&&(j<8)&&(n[i]))
            _xname[j++]=n[i++];

     if(n[i])
     {
       i++; j=8;
       while((j<11)&&(n[i]))
            _xname[j++]=n[i++];
     }
}

char * xFile::name(void) { return _xname; }
int xFile::attr(void) { return 0; }
long xFile::len(void) { return filesize(_name); }
int xFile::clust(void) { return (len()+xSector-1)/xSector; }

void xFile::write(int sect)
{
       int p=open(_name, O_RDONLY);
       static xByte buff[xSector];
       int i=0;
       while(1)
       {
               int r;
               r=read(p,buff,xSector);
               f.seek(sect+i);
               f.write(buff,xSector);
               i++;
               if(r<xSector) break;
       }
       close(p);
}

//  [c] '95 BPC productions         