macro_file WINDOW;

// $Header: /MEWIN/SRC/WINDOW.S 66    2/06/95 6:15p Todd $


#include windows.sh
#include window.sh
#include metools.sh
#include mew_dlgs.sh
#include mewlist2.sh
#include mew_btn.sh
#include dialog.sh
#include mewhelp.sh
#include mew.sh
#include menus.sh

#DEFINE SPLIT_MODE Global_Int( 'SPLIT_EDGE_MODE' )
#DEFINE AUTO_ARRANGE_ICONS Global_Int('AUTO_ARRANGE_ICONS')
#define SAVEFILE_HELPLINK "SAVE"
#define LINKWIN_HELPLINK "LINK"
#define WINLIST_HELPLINK "LIST"
#define WINCOPY_HELPLINK "WINDOW COPY"
#define WINMOVE_HELPLINK "WINDOW MOVE"

/*******************************************************************************
												MULTI-EDIT MACRO FILE

NAME: WINDOW

This file contains all of the window oriented macros.

WINMENU				- The general purpose window list (menu) routine
SELECT_WINDOW _ Takes the current window and makes it non hidden/minimized
FINDWIN				- If the current window is hidden, finds one that isn't
NEXTWIN				- Switches to the next non hidden window.
LASTWIN				- Switches to the preceding non hidden window.
ADJACENT_WIN	- Switches to an adjacent window
SCREEN_SHARE	- Routine used by ADJACENT_WIN.
SWITWIN				- The SWITCH WINDOW menu.  Uses WINMENU.
COPYBL				- Interwindow copy menu.  Uses WINMENU.
MOVEBL				- Interwindow move menu.  Uses WINMENU.
LINKWIN				- Link window menu.  Uses WINMENU.
DELWIN				- Delete window with verify.
MAKEWIN				- Creates a new window.
ZOOM					- ZOOMs a window.
SPLITWIN			- Creates a new window and splits it vertically  or horizontally
WORGANIZE			- Organizes windows by tiling, cascading or icons.
WIN_OP				- Performs various window operations.

										Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

#DEFINE _WL_SELECT_BUTTON   1
#DEFINE _WL_CANCEL_BUTTON   2
#DEFINE _WL_CLOSE_BUTTON    1003
#DEFINE _WL_CLOSE_ALL_BTN   1008
#DEFINE _WL_HIDE_BUTTON     1004
#DEFINE _WL_UNHIDE_BTN      1005
#DEFINE _WL_SAVE_BUTTON     1006
#DEFINE _WL_SAVE_ALL_BTN    1007
#DEFINE _WL_MINIMIZE_BUTTON 1009
#DEFINE _WL_RESTORE_BTN     1010
#DEFINE _WL_RESTORE_BUTTON  1011
#DEFINE _WL_RESTORE_ALL_BTN 1012
//#DEFINE _WL_ALL_BTN 1020
//#DEFINE _WL_NONE_BTN 1021


#DEFINE _WL_HELP_BUTTON    1100

void WinMenu( int wparent = parse_int("/PAR=", mparm_str ))
{
  int main_dlg, list_hwnd,
      list_win_num, list_win_id, record_count,
      line_height, font_height, font_width, dfont,
      field_count = 0,
      jx,jy,jz,
      temp_window,
      tr = refresh,
      all_hidden = 0,
      all_minimized = 0,
      start_win_id = window_id,
      active_win_id = window_id,
      active_win_num = cur_window,
      active_win_line = 1;

  int Letter_First = (Global_Int('@WINDOW_LIST_MODE@') != 0);

  int Hide_Enable = Parse_Int('/HE=',MParm_Str);
  int Display_Current = Parse_Int('/DC=',MParm_Str);
  int Display_Blocked_Only = Parse_Int('/DB=',MParm_Str);
  int show_system_windows = parse_int("/SYSTEM=",mparm_str);

  int xstyle;
  int button_height;
  int button_space;
  int th,ell, half_line;


//  display_current = 1;
  str attr_str[40], temp_str,
      Help_Str[40] = Parse_Str('/HS=',MParm_Str),
      title[132] = Parse_Str('/WT=',MParm_Str);

  if ( !wparent )
  {
    wparent = frame_handle;
  }

  refresh = false;
  create_window;
  list_win_num = cur_window;
  list_win_id = window_id;


   // Build the window list
  call build_wlist;

	if (record_count < 1) {
		str error_msg;
		if (display_blocked_only) {
			error_msg = "No other windows with marked blocks available.";
		} else {
			error_msg = "No other windows available.";
		}
		RM("MEERROR^MESSAGEBOX /B=1/T=" + title + "/M=" + error_msg);

		return_int = 0;
		goto ABORT;
	}

  if(!svl(title))
  {
    title = "Window List";
  }

  if( !svl(help_str))
  {
    help_str = "WINLIST";
  }
   // Create the main dialog
  main_dlg = Create_MEW_Dlg( title, help_str, wparent, DLG_NOSIZE | DLG_NOCENTER );
  Get_MEW_Dlg_Metrics( main_dlg, line_height, font_height, font_width, dfont );

  xstyle = bs_pushbutton | ws_tabstop | ws_visible;
  button_height = ((DLG_DefBtnHeight * font_height) / 8) + 1; //line_height + ( font_height / 4 );
  button_space = button_height / 9;
  half_line = button_height / 2;

  struct trect rcDlg;
  struct tmsg msg;

  int origin_x = 5, origin_y = line_height + line_height;

  int select_min;

  int btn_width = font_width * 14;

  BuildMEWButton( main_dlg, MEWBTN_RT_RESNAME, "BT_WN_104",
            ws_visible | ws_child, MEWBTN_STATICBUTTON | MEWBTN_SIZETOBITMAP,
            2500, origin_x + (btn_width / 2) - 13, 9, 0, 0 );

    // Build the reference line
  jy = font_height;
  jz = origin_x + btn_width + font_width + 1;

  Create_MEW_Ctrl( "STATIC", "", ws_visible | ws_child | ss_blackframe,jz,jy - (font_height / 2),
      (font_width  * 72) + 50,line_height + (font_height / 2),main_dlg,2002 , app_handle, 0);

  jz += font_width;
  BuildMEWButton( main_dlg, MEWBTN_RT_RESNAME, "WINDOW_HIDDEN",
            ws_visible | ws_child, MEWBTN_STATICBUTTON | MEWBTN_SIZETOBITMAP,
            2001, jz, jy - 3, 0, 0 );

  jz += 18;
  Create_MEW_Ctrl( "STATIC", "Hidden", ws_visible | ws_child,jz,jy,font_width  * 10,font_height,main_dlg,2002 , app_handle, 0);

  jz += (font_width * 10);
  BuildMEWButton( main_dlg, MEWBTN_RT_RESNAME, "WINDOW_CHANGED",
            ws_visible | ws_child, MEWBTN_STATICBUTTON | MEWBTN_SIZETOBITMAP,
            2003, jz, jy - 3, 0, 0 );
  jz += 18;
  Create_MEW_Ctrl( "STATIC", "Modified", ws_visible | ws_child,jz,jy,font_width  * 10,font_height,main_dlg,2004 , app_handle, 0);

  jz += (font_width * 11);
  BuildMEWButton( main_dlg, MEWBTN_RT_RESNAME, "WINDOW_LINKED",
            ws_visible | ws_child, MEWBTN_STATICBUTTON | MEWBTN_SIZETOBITMAP,
            2005, jz, jy - 3, 0, 0 );
  jz += 18;
  Create_MEW_Ctrl( "STATIC", "Linked", ws_visible | ws_child,jz,jy,font_width  * 10,font_height,main_dlg,2006 , app_handle, 0);

  jz += (font_width * 10);
  BuildMEWButton( main_dlg, MEWBTN_RT_RESNAME, "WINDOW_READONLY",
            ws_visible | ws_child, MEWBTN_STATICBUTTON | MEWBTN_SIZETOBITMAP,
            2007, jz, jy - 3, 0, 0 );
  jz += 18;
  Create_MEW_Ctrl( "STATIC", "Read-only", ws_visible | ws_child,jz,jy,font_width  * 10,font_height,main_dlg,2008 , app_handle, 0);

  jz += (font_width * 12);
  BuildMEWButton( main_dlg, MEWBTN_RT_RESNAME, "BT_FL_102_S",
            ws_visible | ws_child, MEWBTN_STATICBUTTON | MEWBTN_SIZETOBITMAP,
            2009, jz, jy - 3, 0, 0 );
  jz += 18;
  Create_MEW_Ctrl( "STATIC", "Minimized", ws_visible | ws_child,jz,jy,font_width  * 10,font_height,main_dlg,2010 , app_handle, 0);

  if(show_system_windows)
  {
    jz += (font_width * 12);
    BuildMEWButton( main_dlg, MEWBTN_RT_RESNAME, "WINDOW_SYSTEM",
              ws_visible | ws_child, MEWBTN_STATICBUTTON | MEWBTN_SIZETOBITMAP,
              2011, jz, jy - 3, 0, 0 );
    jz += 18;
    Create_MEW_Ctrl( "STATIC", "System", ws_visible | ws_child,jz,jy,font_width  * 10,font_height,main_dlg,2012 , app_handle, 0);
  }

    // Build the command buttons
  jy = origin_y + 5;
  jz = origin_x;

  int delete_button = Create_MEW_Ctrl( "BUTTON", "&Close File",
      xstyle | ws_tabstop,jz,jy,btn_width,button_height,main_dlg,_WL_CLOSE_BUTTON , app_handle, 0);

  if(!hide_enable)
  {
// hide_enable actually affects more than just hiding.
    EnableWindow( delete_button, FALSE );
  }

  jy += button_height + half_line;

  int hide_button = Create_MEW_Ctrl( "BUTTON", "H&ide", xstyle | ws_tabstop,jz,jy,btn_width,
    button_height,main_dlg,_WL_HIDE_BUTTON , app_handle, 0);

  jy += button_height + button_space;
  int hide_all_button = Create_MEW_Ctrl( "BUTTON", "&Un-Hide", xstyle | ws_tabstop,jz,jy,btn_width,
   button_height,main_dlg,_WL_UNHIDE_BTN , app_handle, 0);

  jy += button_height + half_line;

  int minimize_button = Create_MEW_Ctrl( "BUTTON", "&Minimize", xstyle | ws_tabstop,jz,jy,btn_width,
    button_height,main_dlg,_WL_MINIMIZE_BUTTON , app_handle, 0);

  jy += button_height + button_space;
  int minimize_all_button = Create_MEW_Ctrl( "BUTTON", "&Restore", xstyle | ws_tabstop,jz,jy,btn_width,
    button_height,main_dlg,_WL_RESTORE_BTN , app_handle, 0);


  jy += button_height + half_line;

  int save_button = Create_MEW_Ctrl( "BUTTON", "&Save", xstyle | ws_tabstop,jz,jy,btn_width,button_height,
      main_dlg,_WL_SAVE_BUTTON , app_handle, 0);

  jy += 2*(button_height + button_space);

  select_min = jy + button_height;
  jy += button_height + half_line;

  int disp_height = font_height + 1;
  if( disp_height < 15)
  {
    disp_height = 15;
  }

  ell = record_count;
  if ( ell > 15 )
  {
    ell = 15;
  }
  ell = (ell * disp_height) + 10;
  if( (origin_y + ell) < select_min )
    ell = select_min - origin_y;

  jy = origin_y;

  str disp_str = "I1=/W=15/T=3I2=/W=15/T=3I3=/W=15/T=3";
  if ( !letter_first )
  {
    disp_str += "FN=/IS=1/W=17/T=0L=/W=15/T=0";
  }
  else
  {
    disp_str += "L=/IS=1/W=15/T=0FN=/W=17/T=0";
  }

  disp_str += "P=/W=40/T=0";

  list_hwnd =
    ListBoxCreate( list_win_num,          // The edit buffer/window number
                    1,                    // The starting line in the buffer
                   record_count,          // The number of lines
                   origin_x + btn_width + font_width, jy, 0, ell  + 7 + (button_height + button_space),
                   100,                   // Ctrl id
                   _LB_FLAG_EXTENDEDSEL | // MNB-adding this causes 1st item to always be seleccted upon init.
                   _LB_FLAG_HSCROLL |
                   _LB_FLAG_INCSEARCH +
                   _LB_FLAG_AUTOWIDTH,    // Flag bits. See _LB_FLAG_xxxx
                   1,                     // Field number to use for  inc search
                   main_dlg,              // Parent window
                   disp_str               // display string
                   );

  jy = origin_y + ell + line_height + (button_height + button_space);

  int select_button = Create_MEW_Ctrl( "BUTTON", "Se&lect", xstyle | ws_tabstop | bs_defpushbutton,
    jz,jy,btn_width,button_height,main_dlg,_WL_SELECT_BUTTON , app_handle, 0);

  jz +=  btn_width + font_width;
  int cancel_button = Create_MEW_Ctrl( "BUTTON", "Cancel", xstyle | ws_tabstop,jz,jy,btn_width,
    button_height,main_dlg,_WL_CANCEL_BUTTON , app_handle, 0);

  Auto_Size_MEW_Dlg( main_dlg, 10, 10 );
  GetClientRect(main_dlg, &rcDlg);

  jz =  (rcdlg.right)  - (font_width * 12);
  int help_button = Create_MEW_Ctrl( "BUTTON", "&Help", xstyle | ws_tabstop,jz,jy,font_width  * 11,button_height,main_dlg,_WL_HELP_BUTTON , app_handle, 0);

  // Enable Delete key
  sendmessage( list_hwnd, WM_ML2_SETKEYWCMD, _WL_CLOSE_BUTTON , 1);



  Center_MEW_Dlg( main_dlg, false );

  EnableWindow( main_dlg, TRUE );


  BringWindowToTop( main_dlg );
  //sendmessage( list_hwnd, LB_SETCURSEL, active_win_line - 1, 0);
  senddlgitemmessage( main_dlg, 100, WM_ML2_SETCARET, 0, active_win_line - 1 );
  goto_line(active_win_line);
  goto_col(1);

  ShowWindow( main_dlg, TRUE );

  SetDefaultButton( main_dlg, _WL_SELECT_BUTTON );

  SetFocus( list_hwnd );
  update_status_line;

  int old_hide_line = 0;
  int hide_button_stat = 0;
  int minimize_button_stat = 0, tint = 0, j = 0;
  int maxitems = 0;
  int maxlength = 0;

  mark_pos;
  tof;
  while ( !at_eof ) {
    if ( length(parse_str("P=", get_line) ) > maxlength) {
      maxlength = length(parse_str("P=", get_line));
    }
    down;
  }
  goto_mark;
  maxlength = maxlength + 57;
  SendMessage (list_hwnd, LB_SetHorizontalExt, maxlength * font_width, 0);
  //tint = SendDlgItemMessage(main_dlg, 100, LB_GETCURSEL, 0, 0);
  SendDlgItemMessage(main_dlg, 100, LB_SETSEL, true, active_win_line - 1);

      return_int = -1;
      while(getmessage( &msg, 0, 0, 0 ) && (return_int == -1))
      {
        if ( msg.message == WM_USER )
        {
          switch ( msg.wparam )
          {
            case _WL_CANCEL_BUTTON :
            case 999 :
              return_int = 0;
              break;

            case 998 :
            case _WL_SELECT_BUTTON :
              return_int = 1;
              active_win_id = parse_int("ID=", get_line);
              break;

            case _WL_CLOSE_BUTTON :
              //maxitems = SendDlgItemMessage(main_dlg, 100, LB_GETCOUNT, 0, 0);
              for ( j=0; j < record_count; ++j )
              {
                if ( LBIsItemSelected(list_hwnd, j) > 0) {
                  if ( !tint )
                    tint = j;
                  goto_line(j + 1);
                  jx = parse_int("ID=", get_line );
                  if( switch_win_id( jx ))
                  {
                    DelWin( 0, 0, 0 );
                    update_status_line;
                    jy = window_id;
                    switch_win_id( list_win_id );
                    list_win_num = cur_window;
                    if(jy != jx)
                    {
                      del_line;
                      --record_count;
                      goto_col(1);
                      if(at_eof)
                        up;
                      //call reset_list;
                      SendMessage( list_hwnd, LB_DELETESTRING, j, 0 );
                      --j;
                      call redraw_list;
                      old_hide_line = 0;
                      active_win_id = parse_int("ID=", get_line );
                    }
                  }
                }
              }
              if ( (tint + 1) > record_count )
                tint = record_count - 1;
              SendDlgItemMessage(main_dlg, 100, LB_SETCARETINDEX, tint, 0);
              for ( j=0; j < record_count; ++j )
              {
                SendMessage(list_hwnd, LB_SETSEL, false, j);
              }
              SendMessage(list_hwnd, LB_SETSEL, true, tint);
              tint = 0;
              call redraw_list;
              return_int = -1;
              break;

            case _WL_HELP_BUTTON :
              MewHelp_Context (); //(help_str);
							return_int = -1;
							break;
            case _WL_SAVE_BUTTON :
              maxitems = SendDlgItemMessage(main_dlg, 100, LB_GETCOUNT, 0, 0);
              for ( j=0; j < maxitems; ++j )
              {
                if ( LBIsItemSelected(GetDlgItem(main_dlg, 100), j) ) {
                  goto_line(j + 1);
                  jx = parse_int("ID=", get_line );
                  if(switch_win_id(jx))
                  {
                    RM("SAVEFILE /NP=1");
                    call rebuild_win_line;
                  }
                }
              }
              break;

            case _WL_MINIMIZE_BUTTON :
            case _WL_RESTORE_BTN :
              //maxitems = SendDlgItemMessage(main_dlg, 100, LB_GETCOUNT, 0, 0);
              for ( j=0; j < record_count; ++j )
              {
                if ( LBIsItemSelected(list_hwnd, j) > 0) {
                  goto_line (j +1);
                  jx = parse_int("ID=", get_line );
                  if(switch_win_id(jx))
                  {
                    //if ( window_attr & 0x40 )
                    if ( msg.wparam == _WL_RESTORE_BTN )
                    {
                      rm("WINOP /T=8");
                    }
                    else
                    {
                      rm("WINOP /T=10");
                    }
                    call rebuild_win_line;
                    old_hide_line = 0;
                  }
                }
              }
              return_int = -1;
              break;

            case _WL_HIDE_BUTTON :
            case _WL_UNHIDE_BTN :
              maxitems = SendDlgItemMessage(main_dlg, 100, LB_GETCOUNT, 0, 0);
              for ( j=0; j < maxitems; ++j )
              {
                if ( LBIsItemSelected(GetDlgItem(main_dlg, 100), j) ) {
                  goto_line (j +1);
                  jx = parse_int("ID=", get_line );
                  if(switch_win_id(jx))
                  {
                    //if ( window_attr & 0x01 )
                    if ( msg.wparam == _WL_UNHIDE_BTN )
                      window_attr &= 0xfe;
                    else
                      window_attr |= 0x01;
                    Make_Window_Visible( ((window_attr & 0x01) == 0));
                    call rebuild_win_line;
                    old_hide_line = 0;
                  }
                }
              }
              return_int = -1;
              break;

            default:
              goto do_isdialog;
          }
          SetFocus(List_hwnd);
          SetDefaultButton( main_dlg, _WL_SELECT_BUTTON );
          refresh = false;
        }
        else
        {
          do_isdialog:
          if( !IsDialogMessage( main_dlg, &msg) )
          {
              translatemessage( &msg );
              dispatchmessage( &msg );
          }
        }

        if ( record_count < 1 ) {
          EnableWindow (GetDlgItem (main_dlg, _WL_CLOSE_BUTTON), FALSE);
          //EnableWindow (GetDlgItem (main_dlg, _WL_CLOSE_ALL_BTN), FALSE);
          EnableWindow (GetDlgItem (main_dlg, _WL_HIDE_BUTTON), FALSE);
          //EnableWindow (GetDlgItem (main_dlg, _WL_HIDE_ALL_BTN), FALSE);
          EnableWindow (GetDlgItem (main_dlg, _WL_MINIMIZE_BUTTON), FALSE);
          //EnableWindow (GetDlgItem (main_dlg, _WL_MINIMIZE_ALL_BTN), FALSE);
          EnableWindow (GetDlgItem (main_dlg, _WL_SAVE_BUTTON), FALSE);
          //EnableWindow (GetDlgItem (main_dlg, _WL_SAVE_ALL_BTN), FALSE);
          EnableWindow (GetDlgItem (main_dlg, _WL_SELECT_BUTTON), FALSE);
        } else {
          EnableWindow (GetDlgItem (main_dlg, _WL_CLOSE_BUTTON), TRUE);
          //EnableWindow (GetDlgItem (main_dlg, _WL_CLOSE_ALL_BTN), TRUE);
          EnableWindow (GetDlgItem (main_dlg, _WL_HIDE_BUTTON), TRUE);
          //EnableWindow (GetDlgItem (main_dlg, _WL_HIDE_ALL_BTN), TRUE);
          EnableWindow (GetDlgItem (main_dlg, _WL_MINIMIZE_BUTTON), TRUE);
          //EnableWindow (GetDlgItem (main_dlg, _WL_MINIMIZE_ALL_BTN), TRUE);
          EnableWindow (GetDlgItem (main_dlg, _WL_SAVE_BUTTON), TRUE);
          //EnableWindow (GetDlgItem (main_dlg, _WL_SAVE_ALL_BTN), TRUE);
          EnableWindow (GetDlgItem (main_dlg, _WL_SELECT_BUTTON), TRUE);
        }

        if(hide_enable)
          if( c_line != old_hide_line )
          {
            old_hide_line = c_line;
          }
      }
 message_exit:

  destroy_mew_dlg( main_dlg );
  while ( PeekMessage( &msg, 0,WM_USER,WM_USER, PM_REMOVE ))
  {
  }

ABORT:
  switch_win_id( list_win_id );
  delete_window;
  switch_win_id( active_win_id );
  if(return_int == 1)
  {
    return_int = cur_window;
  }
  switch_win_id( start_win_id );
  if ( !show_system_windows ) {
    rm('findwin');
  }

  refresh = tr;
  return();

reset_list:
  jx = SendMessage( list_hwnd, LB_GETCOUNT, 0, 0 );
  while(  jx < record_count )
  {
    SendMessage( list_hwnd, LB_ADDSTRING, 0, 0 );
    ++jx;
  }
  while(  jx > record_count )
  {
    SendMessage( list_hwnd, LB_DELETESTRING, jx - 1, 0 );
    --jx;
  }
  sendmessage( list_hwnd, LB_SETCURSEL, c_line - 1, 0);
  ret;

redraw_list:
  RedrawWindow( list_hwnd, 0, 0, rdw_Invalidate );
  ret;

rebuild_win_line:
  switch_win_id( list_win_id );
  list_win_num = cur_window;
  switch_win_id(jx);
  call build_win_line;
  switch_win_id(list_win_id)
  call redraw_list;
  return_int = -1;
  ret;

build_wlist:
  int tx;
  active_win_line = 1;
  switch_win_id( list_win_id );
  list_win_num = cur_window;
  window_attr = 0x81;
  tof;
	Switch_Window(1);
	Working;
	do {
		Temp_Window = Cur_Window;
    if ( Window_Id != list_win_id )
		{
      if ((((Display_Current == True) || (Window_Id != Active_Win_ID)) &
						((Display_Blocked_Only == False) || (Block_Stat != False)))
						&& (((window_attr & $80) == 0) || (show_system_windows))
						) {
        jy = window_id;
        call build_win_line;
        if ( jy == active_win_id )
        {
          active_win_line = c_line;
        }
				Down;
			}
		}
		Switch_Window(Temp_Window + 1);
	} while ( Cur_Window!=1 );

  Switch_Window(list_win_num);
  record_count = c_line - 1;
  tof;

  ret;


build_win_line:
  attr_str = '';
  tx = 0;
  if (Read_Only) {
    ++tx;
    Attr_str = 'I' + str(tx) + '=WINDOW_READONLY';
  } else if (File_Changed) {
    ++tx;
    attr_str = 'I' + str(tx) + '=WINDOW_CHANGED';
  }
  if (Link_Stat) {
    ++tx;
    attr_str = attr_str + 'I' + str(tx) + '=WINDOW_LINKED';
  }
  if (Window_Attr & 0x80) {
    ++tx;
    attr_str = attr_str + 'I' + str(tx) + '=WINDOW_SYSTEM';
  } else if (Window_Attr & $01) {
    ++tx;
    attr_str = attr_str + 'I' + str(tx) + '=WINDOW_HIDDEN';
  }

  if (window_attr & 0x40) { // minimized
    ++tx;
    attr_str = attr_str + 'I' + str(tx) + '=BT_FL_102_S';
	}

  temp_str = "FN=" + truncate_path(file_name) +
                "L=" + window_name
                + attr_str +
                "ATTR=" + str(window_attr) +
                "P=" + get_path(file_name)  +
                "ID=" + str(window_id);
  Switch_Window(list_Win_num);
  Put_Line( Temp_Str );
  ret;


}

/****************************Multi-Edit Macro********************************

 NAME:         Select_Window

 DESCRIPTION:  Takes the current window and makes it non-hidden and
							 non-minimized

 PARAMETERS:   /MAX=1

 RETURNS:      Nothing

*****************************06-30-93 05:29pm*******************************/
macro Select_Window
{
  window_attr = window_attr & 0xFE;

  if(parse_int("/MAX=", mparm_str))
  {
    make_window_visible(3);
  }
  else
  {
    make_window_visible (1);
  }

  if(window_attr & 0x40)
  {
    rm("ZOOM");
  }
}


void CreateNoFileWin()
{
  if( nofile_hidden )
  {
    create_window;
    window_attr = $81;
  }
  else
  {
    rm("CREATEWINDOW");
    RM('EXTSETUP /PRE=1');
  }
}

macro FINDWIN trans2 {
/*******************************************************************************
																MULTI_EDIT MACRO
Name: FINDWIN

Description:	Finds the next non hidden window

Flags:  /B= Finds the previous non hidden window

					Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int JX;
	int
					no_min = parse_int('/NM=', mparm_str ),
					m = $81,
          error_win_id, // = Global_Int('~MEERR_ID')
          tr = refresh,
          back = parse_int('/B=', mparm_str)
					;
  if ( global_int('!AutoArrangErrSrc') ) {
    error_win_id = Global_Int('~Meerr_ID');
  }

	if (parse_int("/HIDDEN=",mparm_str)) {
		m = $80;
	}
	if (no_min) {
		m = m | $40;
	}
  refresh = false;
again:
	JX = Cur_Window;
  while ((window_handle == 0) || ((Window_Attr & m) != 0) || (window_id == error_win_id)) {
		if( window_id == error_win_id )
		{
			error_win_id = 0;
		}
    if ( back ) {
      switch_window(cur_window - 1);
    } else {
      switch_window(cur_window + 1);
    }
		if (jx == cur_window) {
			if (no_min) {
				m = $81;
				no_min = FALSE;
				goto again;
			}
			if ((window_attr & $80) == 0) {
				Window_Attr = Window_Attr & $FE;
				Redraw;
			}
      for ( jx = 1; jx <= window_count; jx++ )
      {
        switch_window(jx);
        if(  (caps(file_name) == '?NO-FILE?') & (file_changed == FALSE)  ) {
          if((lines_in_mem == 0) && (eof_in_mem))
          {
            goto exit;
          }
        }
      }
      CreateNoFileWin();

		}
	}


EXIT:
  refresh = tr;
}

macro NEXTWIN TRANS2 {
/*******************************************************************************
																MULTI-EDIT MACRO
Name: NEXTWIN

Description:	Switch to next window

					Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	int  tr, old_win, nw ;
	old_win = cur_window;
	TR = REFRESH;
	REFRESH = FALSE;
	SWITCH_WINDOW(CUR_WINDOW + 1);
	RM( 'FINDWIN /NM=1' + MParm_Str);
	if (cur_window == old_win)
			RM('FINDWIN');
	nw = cur_window;
	switch_window(old_win);
	REFRESH = TRUE;
	switch_window(nw);
	refresh = tr;
}

macro LASTWIN TRANS2 {
/*******************************************************************************
															MULTI-EDIT MACRO
Name: LASTWIN

Description:	Switch to last window

									Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int  tr, old_win, nw ;
	old_win = cur_window;
	TR = REFRESH;
	REFRESH = FALSE;
  SWITCH_WINDOW(CUR_WINDOW - 1);
  RM( 'FINDWIN /NM=1/B=1' + MParm_Str);
	if (cur_window == old_win)
      RM('FINDWIN /B=1');
	nw = cur_window;
	switch_window(old_win);
	switch_window(nw);
	REFRESH = TRUE;
	refresh = tr;
}

 /* int  tr, nw, ow, error_win_id = Global_Int('~MEERR_ID');
	TR = REFRESH;
	ow = cur_window;
	nw = cur_window;
	REFRESH = FALSE;
	SWITCH_WINDOW(CUR_WINDOW - 1);
	while ((cur_window != ow) && (((Window_Attr & $C1) != 0) || (window_id == error_win_id))) {
		switch_window(cur_window - 1);
	}
	if (cur_window ==  ow) {
		SWITCH_WINDOW(CUR_WINDOW - 1);
		while ((cur_window != ow) && (((Window_Attr & $81) != 0) || (window_id == error_win_id))) {
			switch_window(cur_window - 1);
		}
	}
	nw = cur_window;
EXIT:
	SWITCH_WINDOW( ow );
	REFRESH = TRUE;
	SWITCH_WINDOW( nw );
	REFRESH = TR;
}  */

#ifdef Windows
int abs(int t_int) {
  if (t_int < 0) {
    t_int = 0 - t_int;
  }
  return(t_int);
}

global {
  int h_adjacent_dlg "!H_ADJACENT_DLG";
  int h_adjacent_up "!H_ADJACENT_UP";
  int h_adjacent_dn "!H_ADJACENT_DN";
  int h_adjacent_lf "!H_ADJACENT_LF";
  int h_adjacent_rt "!H_ADJACENT_RT";
}

int ADJ_BTN_PROC(int &retval, int window, message, wparam, lparam, str parms ) {
  int result = 0;
  switch (message) {
    case WM_GETDLGCODE :
      retval = DLGC_WANTARROWS;
      result = 1;
      break;

    case WM_KEYDOWN :
      switch (wParam) {
        case vk_up :  // up arrow
          if (IsWindowEnabled(h_adjacent_up)) {
            PostMessage(h_adjacent_dlg, WM_COMMAND , 1401,((BN_CLICKED) << 16) | h_adjacent_up);
          }
        break;
        case vk_down :  // down arrow
          if (IsWindowEnabled(h_adjacent_dn)) {
            PostMessage(h_adjacent_dlg, WM_COMMAND , 1402,((BN_CLICKED) << 16) | h_adjacent_dn);
          }
        break;
        case vk_left :  // left arrow
          if (IsWindowEnabled(h_adjacent_lf)) {
            PostMessage(h_adjacent_dlg, WM_COMMAND , 1403,((BN_CLICKED) << 16) | h_adjacent_lf);
          }
        break;
        case vk_right :  // right arrow
          if (IsWindowEnabled(h_adjacent_rt)) {
            PostMessage(h_adjacent_dlg, WM_COMMAND , 1404,((BN_CLICKED) << 16) | h_adjacent_rt);
          }
        break;
      }

    break;
	}
  return(result);
}

int ADJACENT_HOOK(int &retval, int window, message, wparam, lparam, str parms ) {
  switch (message) {
    case WM_COMMAND :
      switch( wparam ) {
        case DLG_WCMD_INIT :
// this message is similar to WM_INITDIALOG
          h_adjacent_dlg = window;
          h_adjacent_up = GetDlgItem(window, 1401);
          h_adjacent_dn = GetDlgItem(window, 1402);
          h_adjacent_lf = GetDlgItem(window, 1403);
          h_adjacent_rt = GetDlgItem(window, 1404);
          Subclass_With_Macro(h_adjacent_up, "ADJ_BTN_PROC", "");
          Subclass_With_Macro(h_adjacent_dn, "ADJ_BTN_PROC", "");
          Subclass_With_Macro(h_adjacent_lf, "ADJ_BTN_PROC", "");
          Subclass_With_Macro(h_adjacent_rt, "ADJ_BTN_PROC", "");
          Subclass_With_Macro(GetDlgItem(window, 101), "ADJ_BTN_PROC", "");
				break;
      }
		break;
	}
  return(DlgMessageProc(retval, window,message,wparam,lparam, parms ));
}

void ADJACENT_WIN TRANS2() {
/*******************************************************************************
															MULTI-EDIT MACRO
Name: ADJACENT_WIN

Description:	On a split window, prompts for and switches to an adjacent
							window.

									Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
  int Active_Window,
      New_Window,
      Active_Screen,
      Active_X1,
      Active_Y1,
      Active_X2,
      Active_Y2,
      T_Refresh,
      Common=0,
      T_Common=0,
      Ev_Count=0,
      T_Update_Time = 0,
      h_dlg,
      h_uparrow;

	T_Refresh = Refresh;
	Refresh = False;
	Active_Window = Window_Id;
	Active_Screen = Screen_Num;
	New_Window = Active_Window;
	Active_X1 = Win_X1;
	Active_Y1 = Win_Y1;
	Active_X2 = Win_X2;
	Active_Y2 = Win_Y2;

	RM('SCREEN_SHARE');

//make_message(hex_str(return_int));
//  Put_Box(26,2, 55, 13, 0, m_b_color, 'Switch to window', true);

	if ((Return_Int & $7F) == 0) {
    RM("MESSAGEBOX /B=2/T=Switch To Window/M=No adjacent windows to switch to!");
    Return();
//    DlgAddCtrl( h_dlg, DLG_Static,"No adjacent windows to switch to!", 1, 1, 0, 0, 1401, 0, "/R=10" );
//    DlgAddCtrl( h_dlg, DLG_Static,"to switch to!", Dlg_PosOffset ,dlg_PosOffset | 1, 0, 0, 1401, 0, "/R=10" );
//    DlgAddCtrl( h_dlg, DLG_PushButton, "OK", 6, DLG_PosOffset | 1, DLG_StanBtnWidth, 0, 101, 0, "/R=0");
  } else {
    dlgcreate(h_dlg);
    DlgAddCtrl( h_dlg, DLG_BitmapBtn,"~obm_UpArrow", DLG_Units | 38, 1, 0, 0, 1401, !(return_int & 1), "/R=13" );
    DlgAddCtrl( h_dlg, DLG_BitmapBtn,"~obm_DnArrow", Dlg_PosOffset, Dlg_Units | 40, 20, 20, 1402, !((return_int & 2) >> 1), "/R=14" );
    DlgAddCtrl( h_dlg, DLG_BitmapBtn,"~obm_LfArrow", 1, Dlg_units | 20, 20, 20, 1403, !((return_int & 4)>> 2), "/R=12" );
    DlgAddCtrl( h_dlg, DLG_BitmapBtn,"~obm_RGArrow", 20, DLg_PosOffset, 20, 20, 1404, !((return_int & 8) >> 3), "/R=11" );
    DlgAddCtrl( h_dlg, DLG_PushButton, "Cancel", Dlg_units | 27, DLG_PosOffset, DLG_StanBtnWidth, 0, 101, 0, "/R=0");
  }

  if (return_int = DlgExecute( h_dlg, 101, "Switch To Window", "", "/HOOK=ADJACENT_HOOK" , 0 )) {
/*
make_message(str(Parse_Int('/' + Str(return_int) + '=',
                  Global_Str('!SCREEN_SHARE'))));
*/
    New_Window = Parse_Int('/' + Str(return_int - 10) + '=',
									Global_Str('!SCREEN_SHARE'));

  }


EXIT:
//  RM('USERIN^CheckEvents /M=3/G=@WSEV#/#=' + Str(Ev_Count));
  dlgKill(h_dlg);
	Set_Global_Str('!SCREEN_SHARE','');
	Refresh = TRUE;
	Switch_Win_Id(New_Window);
}


int WIN_IS_VISIBLE() {

// if the window is minimized or hidden, no need to check any further
  if (window_attr & 1) {
    RETURN(0);
  }
  if (IsIconic(Window_Handle)) {
    RETURN(0);
  }

  int ret_value = 1,
      t_win_num = cur_window,
      t_win_x1,
      t_win_x2,
      t_win_y1,
      t_win_y2,
      t_win_update_time,
      obscure_x1,
      obscure_x2,
      obscure_y1,
      obscure_y2,
      win_count,
      t_refresh = refresh
      ;

struct trect cur_window_rect;

/*
int XX = window_id;
switch_file("C:\\MEWIN\\SRC\\ASCII2.S");
t_win_num = cur_window;
*/
  t_win_update_time = last_update_time;
  GetWindowRect(window_handle,&cur_window_rect);
  t_win_x1 = cur_window_rect.left;
  t_win_x2 = cur_window_rect.right;
  t_win_y1 = cur_window_rect.top;
  t_win_y2 = cur_window_rect.bottom;
  obscure_x1 = 65535;
  obscure_x2 = 0;
  obscure_y1 = 65535;
  obscure_y2 = 0;
  refresh = false;

  for (win_count = 1; win_count <= window_count; win_count++) {
// Create a composite set of coordinates
    if (win_count != t_win_num) {
      switch_window( win_count );
      if (!(window_attr & 0x81)) {
        if (last_update_time > t_win_update_time) {
          GetWindowRect(window_handle,&cur_window_rect);
          if ((cur_window_rect.right > t_win_x1) &&
              (cur_window_rect.left <= t_win_x1) &&
              (cur_window_rect.left < obscure_x1) &&
              (cur_window_rect.top <= t_win_y1) &&
              (cur_window_rect.bottom >= t_win_y2)
              ) {
/*
make_message("X1 " + truncate_path(file_name));
read_key;
*/
            obscure_x1 = cur_window_rect.left;
          }
          if ((cur_window_rect.left < t_win_x2) &&
              (cur_window_rect.right >= t_win_x2) &&
              (cur_window_rect.right > obscure_x2) &&
              (cur_window_rect.top <= t_win_y1) &&
              (cur_window_rect.bottom >= t_win_y2)
              ) {
/*
make_message("X2 " + truncate_path(file_name));
read_key;
*/
            obscure_x2 = cur_window_rect.right;
          }
          if ((cur_window_rect.bottom > t_win_y1) &&
              (cur_window_rect.top <= t_win_y1) &&
              (cur_window_rect.top < obscure_y1) &&
              (cur_window_rect.left <= t_win_x1) &&
              (cur_window_rect.right >= t_win_x2)
              ) {
/*
make_message("Y1 " + truncate_path(file_name));
read_key;
*/
            obscure_y1 = cur_window_rect.top;
          }
          if ((cur_window_rect.top < t_win_y2) &&
              (cur_window_rect.bottom >= t_win_y2) &&
              (cur_window_rect.bottom > obscure_y2) &&
              (cur_window_rect.left <= t_win_x1) &&
              (cur_window_rect.right >= t_win_x2)
              ) {
/*
make_message("Y2 " + truncate_path(file_name));
read_key;
*/
            obscure_y2 = cur_window_rect.bottom;
          }
        }
      }
    }
  }

  if ((obscure_x1 <= t_win_x1) && (obscure_x2 >= t_win_x2) &&
      (obscure_y1 <= t_win_y1) && (obscure_y2 >= t_win_y2)) {
    ret_value = 0;
  }

  refresh = t_refresh;

  switch_window(t_win_num);
/*
make_message("WIN_IS_VISIBLE: " + truncate_path(file_name) + " " + str(ret_value));
read_key;
switch_win_id(xx);
*/

  RETURN(Ret_value);
}

macro screen_share trans2 {
/*******************************************************************************
															MULTI-EDIT MACRO
Name: SCREEN_SHARE

Description:	Determines if the current window's screen is shared by another
							window.

Returns:
							Return_Int := 0, window is not shared
								OTHERWISE:
								Bit 0 = We can switch to window above
								Bit 1 = We can switch to window below
								Bit 2 = We can switch to window left
								Bit 3 = We can switch to window right
								BIT 7 = This is the ONLY available window

									Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int upw = 0, downw = 0, leftw = 0, rightw = 0,
			upt = 0, downt = 0, leftt = 0, rightt = 0,
			upl = 0, downl = 0, leftl = 0, rightl = 0,
			ups = 0, downs = 0, lefts = 0, rights = 0,
			visible_count = 0,
			sn = screen_num,
			jx = 0,
			jy,
      jz,
			tr = refresh,
			tw = cur_window,
      x1, x2, y1, y2,
//      maybe_count = 0,
      maybe_win,
      maybe_update_time,
      maybe_x1,
      maybe_x2,
      maybe_y1,
      maybe_y2,
      obscure_x1,
      obscure_x2,
      obscure_y1,
      obscure_y2,
      distance_to_caret
			;
struct trect cur_window_rect;
struct tpoint cur_caret_pos;

  if (IsZoomed(window_handle)) {
    goto NONE;
  }

  GetCaretPos(&cur_caret_pos);
  ClientToScreen(window_handle,&cur_caret_pos);
  GetWindowRect(window_handle,&cur_window_rect);
  x1 = cur_window_rect.left;
  x2 = cur_window_rect.right;
  y1 = cur_window_rect.top;
  y2 = cur_window_rect.bottom;

	refresh = false;
	return_int = 0;

/*
 proposed logic:
 example is for looking for a window to the right

 the premise is that we will create a list of possible candidates,
 then decide which candidate is the best choice

STEP ONE: Find the candidates
  if the new window's right border is to the right of old window

STEP TWO: eliminate the ones that are not currently visible
  based on coordinates and last_update_time, we can find out which
  windows are obscured by others
    get coordinates of candidate.
    create a composite set of coordinates based on all other
    windows that have last_update_time greater that the candidate

STEP THREE: Find the one who's right border is closest to the right
border of the old window.  If two windows are identical in this
respect, check the caret position against the coordinates to
determine which is better.

*/

// **************** RIGHT DIRECTION
  maybe_x2 = 65535;
  maybe_win = 0;
  maybe_y1 = 65535;
  maybe_y2 = -65534;
	for (jx = 1; jx <= window_count; jx++) {
		if (jx != tw) {
			switch_window( jx );
			if (!(window_attr & 0x81)) {
				++visible_count;
        GetWindowRect(window_handle,&cur_window_rect);
        if (cur_window_rect.right > x2) {
          if (Win_Is_Visible()) {
            if (cur_window_rect.right <= maybe_x2){
              if (cur_window_rect.right == maybe_x2) {
                call GET_BEST_X;
              } else {
                maybe_x2 = cur_window_rect.right;
                maybe_y1 = cur_window_rect.top;
                maybe_y2 = cur_window_rect.bottom;
                maybe_win = window_id;
              }
            }
          }
        }
			}
		}
	}
/*
beep;
make_message("MAYBE_WIN=" + str(maybe_win));
read_key;
*/
  rightw = maybe_win;

// ****************** LEFT DIRECTION
  maybe_x1 = -65534;
  maybe_win = 0;
  maybe_y1 = 65535;
  maybe_y2 = -65534;
	for (jx = 1; jx <= window_count; jx++) {
		if (jx != tw) {
			switch_window( jx );
			if (!(window_attr & 0x81)) {
//        ++visible_count;
        GetWindowRect(window_handle,&cur_window_rect);
        if (cur_window_rect.left < x1) {
          if (Win_Is_Visible()) {
            if (cur_window_rect.left >= maybe_x1){
              if (cur_window_rect.left == maybe_x1) {
                call GET_BEST_X;
              } else {
                maybe_x1 = cur_window_rect.left;
                maybe_y1 = cur_window_rect.top;
                maybe_y2 = cur_window_rect.bottom;
                maybe_win = window_id;
              }
            }
          }
        }
			}
		}
	}

  leftw = maybe_win;

// **************** DOWN DIRECTION
  maybe_y2 = 65535;
  maybe_win = 0;
  maybe_x1 = 65535;
  maybe_x2 = -65534;
	for (jx = 1; jx <= window_count; jx++) {
		if (jx != tw) {
			switch_window( jx );
			if (!(window_attr & 0x81)) {
//        ++visible_count;
        GetWindowRect(window_handle,&cur_window_rect);
        if (cur_window_rect.bottom > y2) {
          if (Win_Is_Visible()) {
            if (cur_window_rect.bottom <= maybe_y2){
              if (cur_window_rect.bottom == maybe_y2) {
                call GET_BEST_Y;
              } else {
                maybe_y2 = cur_window_rect.bottom;
                maybe_x1 = cur_window_rect.left;
                maybe_x2 = cur_window_rect.right;
                maybe_win = window_id;
              }
            }
          }
        }
			}
		}
	}
/*
beep;
make_message("MAYBE_WIN=" + str(maybe_win));
read_key;
*/
  downw = maybe_win;

// ****************** TOP DIRECTION
  maybe_y1 = -65534;
  maybe_win = 0;
  maybe_x1 = 65535;
  maybe_x2 = -65534;
	for (jx = 1; jx <= window_count; jx++) {
		if (jx != tw) {
			switch_window( jx );
			if (!(window_attr & 0x81)) {
//        ++visible_count;
        GetWindowRect(window_handle,&cur_window_rect);
        if (cur_window_rect.top < y1) {
          if (Win_Is_Visible()) {
            if (cur_window_rect.top >= maybe_y1){
              if (cur_window_rect.top == maybe_y1) {
                call GET_BEST_Y;
              } else {
                maybe_y1 = cur_window_rect.top;
                maybe_x1 = cur_window_rect.left;
                maybe_x2 = cur_window_rect.right;
                maybe_win = window_id;
              }
            }
          }
        }
			}
		}
	}

  upw = maybe_win;

 NONE:
	switch_window( tw );
	if (upw)
			return_int |= 0x01;
	if (downw)
			return_int |= 0x02;
	if (leftw)
			return_int |= 0x04;
	if (rightw)
			return_int |= 0x08;
	if (visible_count == 0)
			return_int |= 0x80;
	Set_Global_Str('!SCREEN_SHARE',
									'/3=' + Str(UpW) +
									'/4=' + Str(DownW) +
									'/2=' + Str(LeftW) +
									'/1=' + Str(RightW)
									);
	goto exit;

GET_BEST_X:
  distance_to_caret = 65535;
/*
make_message("Maybe_win=" + str(maybe_win) +
" cur_window=" + str(cur_window));
read_key;
make_message("");
*/
  if ((maybe_y1 < cur_caret_pos.y) && (maybe_y2 > cur_caret_pos.y)) {
    distance_to_caret = abs(cur_caret_pos.y - maybe_y1);
    if (abs(cur_caret_pos.y - maybe_y2) < distance_to_caret) {
      distance_to_caret = abs(cur_caret_pos.y - maybe_y2);
    }
  }
  if ((cur_window_rect.top < cur_caret_pos.y) && (cur_window_rect.bottom > cur_caret_pos.y)) {
    if (abs(cur_caret_pos.y - cur_window_rect.top) < distance_to_caret) {
      distance_to_caret = abs(cur_caret_pos.y - cur_window_rect.top);
      maybe_win = window_id;
    }
    if (abs(cur_caret_pos.y - cur_window_rect.bottom) < distance_to_caret) {
      distance_to_caret = abs(cur_caret_pos.y - cur_window_rect.bottom);
      maybe_win = window_id;
    }
  }
  if (maybe_win == window_id) {
    maybe_x1 = cur_window_rect.left;
    maybe_x2 = cur_window_rect.right;
    maybe_y1 = cur_window_rect.top;
    maybe_y2 = cur_window_rect.bottom;
  }
  RET;

GET_BEST_Y:
  distance_to_caret = 65535;
/*
make_message("Maybe_win=" + str(maybe_win) +
" cur_window=" + str(cur_window));
read_key;
make_message("");
*/
  if ((maybe_x1 < cur_caret_pos.x) && (maybe_x2 > cur_caret_pos.x)) {
    distance_to_caret = abs(cur_caret_pos.x - maybe_x1);
    if (abs(cur_caret_pos.x - maybe_x2) < distance_to_caret) {
      distance_to_caret = abs(cur_caret_pos.x - maybe_x2);
    }
  }
  if ((cur_window_rect.left < cur_caret_pos.x) && (cur_window_rect.right > cur_caret_pos.x)) {
    if (abs(cur_caret_pos.x - cur_window_rect.left) < distance_to_caret) {
      distance_to_caret = abs(cur_caret_pos.x - cur_window_rect.left);
      maybe_win = window_id;
    }
    if (abs(cur_caret_pos.x - cur_window_rect.right) < distance_to_caret) {
      distance_to_caret = abs(cur_caret_pos.x - cur_window_rect.right);
      maybe_win = window_id;
    }
  }
  if (maybe_win == window_id) {
    maybe_x1 = cur_window_rect.left;
    maybe_x2 = cur_window_rect.right;
    maybe_y1 = cur_window_rect.top;
    maybe_y2 = cur_window_rect.bottom;
  }
  RET;


/*
calc_y: {
  if (cur_window_rect.bottom <  y2) {
    if (cur_window_rect.top > y1) {
      jy = cur_window_rect.bottom - cur_window_rect.top + 1;
		} else {
      jy = cur_window_rect.bottom - y1 + 1;
		}
	} else {
    if (y1 > cur_window_rect.top) {
			jy = y2 - y1 + 1;
		} else {
      jy = y2 - cur_window_rect.top + 1;
		}
	}
	ret;
}

calc_x: {
  if (cur_window_rect.right <  x2) {
    if (cur_window_rect.left > x1) {
      jy = cur_window_rect.right - cur_window_rect.left + 1;
		} else {
      jy = cur_window_rect.right - x1 + 1;
		}
	} else {
    if (x1 > cur_window_rect.left) {
			jy = x2 - x1 + 1;
		} else {
      jy = x2 - cur_window_rect.left + 1;
		}
	}
	ret;
}

set_left: {
	leftt = jy;
	leftw = window_id;
	leftl = last_update_time;
	lefts = screen_num;
	ret;
}

set_right: {
	rightt = jy;
	rightw = window_id;
	rightl = last_update_time;
	rights = screen_num;
	ret;
}

set_up: {
	upt = jy;
	upw = window_id;
	upl = last_update_time;
	ups = screen_num;
	ret;
}

set_down: {
	downt = jy;
	downw = window_id;
	downl = last_update_time;
	downs = screen_num;
	ret;
}
*/
exit:
	refresh = tr;
}
#else

macro ADJACENT_WIN TRANS2 {
/*******************************************************************************
															MULTI-EDIT MACRO
Name: ADJACENT_WIN

Description:	On a split window, prompts for and switches to an adjacent
							window.

									Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	int Active_Window,New_Window,Active_Screen,Active_X1,Active_Y1,Active_X2,
					Active_Y2,T_Refresh,Common=0,T_Common=0,Ev_Count=0,T_Update_Time = 0;

	T_Refresh = Refresh;
	Refresh = False;
	Active_Window = Window_Id;
	Active_Screen = Screen_Num;
	New_Window = Active_Window;
	Active_X1 = Win_X1;
	Active_Y1 = Win_Y1;
	Active_X2 = Win_X2;
	Active_Y2 = Win_Y2;

	RM('SCREEN_SHARE');

	Put_Box(26,2, 55, 13, 0, m_b_color, 'Switch to window', true);

	if ((Return_Int & $7F) == 0) {
/* We stuck the checking of return_int from SCREEN_SHARE down here to minimize
the delay between the PUT_BOX and this message */
		RM('MEERROR^Beeps /C=1');
		Write('No adjacent windows',30,5,0,m_b_color);
		Write('to switch to!',33,6,0,m_b_color);
		Write('PRESS ANY KEY' ,34,10,0,m_b_color);
		Read_Key;
		Kill_Box;
		Goto EXIT;
	}

	if (Return_Int & 1) {
/* Enable up movement */
		++Ev_Count;
		Set_Global_Str('@WSEV#' + Str(Ev_Count), '/3D=1/T=/KC=  |30  /K1=0/K2=72/R=3/W=5/X=37/Y=4');
	}
	if (Return_Int & 2) {
/* Enable down movement */
		++Ev_Count;
		Set_Global_Str('@WSEV#' + Str(Ev_Count), '/3D=1/T=/KC=  |31  /K1=0/K2=80/R=4/W=5/X=37/Y=8');
	}
	if (Return_Int & 4) {
/* Enable left movement */
		++Ev_Count;
		Set_Global_Str('@WSEV#' + Str(Ev_Count), '/3D=1/T=/KC=  |17  /K1=0/K2=75/R=2/W=5/X=29/Y=6');
	}
	if (Return_Int & 8) {
/* Enable right movement */
		++Ev_Count;
		Set_Global_Str('@WSEV#' + Str(Ev_Count), '/3D=1/T=/KC=  |16  /K1=0/K2=77/R=1/W=5/X=44/Y=6');
	}
	++Ev_Count;
	Set_Global_Str('@WSEV#' + Str(Ev_Count), '/3D=1/T=Cancel/KC=<ESC>/K1=27/K2=1/R=0/W=11/X=35/Y=10');
	RM('USERIN^CheckEvents /M=2/G=@WSEV#/#=' + Str(Ev_Count));
	Read_Key;

	if ((key1 == 0) && (key2 == 250)) {
		RM('CheckEvents /G=@WSEV#/M=1/#=' + Str(Ev_Count));
	} else {
		RM('CheckEvents /G=@WSEV#/M=0/#=' + Str(Ev_Count));
	}
	Kill_Box;
	if (return_int != 0) {
		New_WIndow = Parse_Int('/' + Str(parse_int('/R=', return_str)) + '=',
									Global_Str('!SCREEN_SHARE'));
	}

EXIT:
	RM('USERIN^CheckEvents /M=3/G=@WSEV#/#=' + Str(Ev_Count));
	Set_Global_Str('!SCREEN_SHARE','');
	Refresh = TRUE;
	Switch_Win_Id(New_Window);
}

macro screen_share trans2 {
/*******************************************************************************
															MULTI-EDIT MACRO
Name: SCREEN_SHARE

Description:	Determines if the current window's screen is shared by another
							window.

Returns:
							Return_Int := 0, window is not shared
								OTHERWISE:
								Bit 0 = We can switch to window above
								Bit 1 = We can switch to window below
								Bit 2 = We can switch to window left
								Bit 3 = We can switch to window right
								BIT 7 = This is the ONLY available window

									Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int upw = 0, downw = 0, leftw = 0, rightw = 0,
			upt = 0, downt = 0, leftt = 0, rightt = 0,
			upl = 0, downl = 0, leftl = 0, rightl = 0,
			ups = 0, downs = 0, lefts = 0, rights = 0,
			visible_count = 0,
			sn = screen_num,
			jx = 0,
			jy,
			tr = refresh,
			tw = cur_window,
			x1 = win_x1, x2 = win_x2, y1 = win_y1, y2 = win_y2
			;

	refresh = false;
	return_int = 0;

	for (jx = 1; jx <= window_count; jx++) {
		if (jx != tw) {
			switch_window( jx );
			if (!(window_attr & 0x81)) {
				++visible_count;
				if (((x1 == win_x2) || (x1 == (win_x2 + 1))) &&
						(win_y2 > y1) && (win_y1 < y2)) {
					call calc_y;
					if (screen_num == sn) {
						if ((jy > leftt) || (lefts != sn))
								call set_left;
					} else if (last_update_time > leftl) {
						call set_left;
					}
				} else if (((x2 == win_x1) || (x2 == (win_x1 - 1))) &&
						(win_y2 > y1) && (win_y1 < y2)) {
					call calc_y;
					if (screen_num == sn) {
						if ((jy > rightt) || (rights != sn))
								call set_right;
					} else if (last_update_time > rightl) {
						call set_right;
					}
				} else if (((y2 == win_y1) || (y2 == (win_y1 - 1))) &&
						(win_x2 > x1) && (win_x1 < x2)) {
					call calc_x;
					if (screen_num == sn) {
						if ((jy > downt) || (downs != sn))
								call set_down;
					} else if (last_update_time > downl) {
						call set_down;
					}
				} else if (((y1 == win_y2) || (y1 == (win_y2 + 1))) &&
						(win_x2 > x1) && (win_x1 < x2)) {
					call calc_x;
					if (screen_num == sn) {
						if ((jy > upt) || (ups != sn))
								call set_up;
					} else if (last_update_time > upl) {
						call set_up;
					}
				}
			}
		}
	}

	switch_window( tw );
	if (upw)
			return_int |= 0x01;
	if (downw)
			return_int |= 0x02;
	if (leftw)
			return_int |= 0x04;
	if (rightw)
			return_int |= 0x08;
	if (visible_count == 0)
			return_int |= 0x80;
	Set_Global_Str('!SCREEN_SHARE',
									'/3=' + Str(UpW) +
									'/4=' + Str(DownW) +
									'/2=' + Str(LeftW) +
									'/1=' + Str(RightW)
									);
	goto exit;

calc_y: {
	if (win_y2 <  y2) {
		if (win_y1 > y1) {
			jy = win_y2 - win_y1 + 1;
		} else {
			jy = win_y2 - y1 + 1;
		}
	} else {
		if (y1 > win_y1) {
			jy = y2 - y1 + 1;
		} else {
			jy = y2 - win_y1 + 1;
		}
	}
	ret;
}

calc_x: {
	if (win_x2 <  x2) {
		if (win_x1 > x1) {
			jy = win_x2 - win_x1 + 1;
		} else {
			jy = win_x2 - x1 + 1;
		}
	} else {
		if (x1 > win_x1) {
			jy = x2 - x1 + 1;
		} else {
			jy = x2 - win_x1 + 1;
		}
	}
	ret;
}

set_left: {
	leftt = jy;
	leftw = window_id;
	leftl = last_update_time;
	lefts = screen_num;
	ret;
}

set_right: {
	rightt = jy;
	rightw = window_id;
	rightl = last_update_time;
	rights = screen_num;
	ret;
}

set_up: {
	upt = jy;
	upw = window_id;
	upl = last_update_time;
	ups = screen_num;
	ret;
}

set_down: {
	downt = jy;
	downw = window_id;
	downl = last_update_time;
	downs = screen_num;
	ret;
}

exit:
	refresh = tr;
}
#endif

macro SWITWIN TRANS2 {
/*******************************************************************************
															MULTI-EDIT MACRO
Name: SWITWIN

Description:	Brings up a menu of all windows for the purpose of switching
							directly to a new window without toggling through those in
							between

 Parameters:

                Copyright 1994 by American Cybernetics, Inc.
*******************************************************************************/

  RM( 'WINMENU /WT=Window List' +
      '/WH=Press <ENTER> to select window, <ESC> to return to original window.' +
      '/HS=' + WINLIST_HELPLINK +
      '/HE=1/DB=0/DC=1' + MParm_Str);
	if (Return_Int != 0) {
		Switch_Window(Return_Int);
    Rm ("Select_WINDOW");
	}
	redraw;
}

macro COPYBL TRANS2 {
/*******************************************************************************
															MULTI-EDIT MACRO
Name: COPYBL

Description:	Brings up a menu of all windows who have a block defined for
							inter-window block copying

								Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

  RM( 'WINMENU /WT=Inter-Window Copy/WH=Select window to copy from and press <ENTER>, or <ESC> to abort/HS=' +
			WINCOPY_HELPLINK + '/HE=0/DB=1/DC=0' + MParm_Str);
	Window_Attr = Window_Attr & $FE;
	if (Return_Int != 0) {
		Window_Copy(Return_Int);
    if( global_int("BlockOffAfterPaste"))
    {
      block_off;
    }
  }
}

macro MOVEBL TRANS2 {
/*******************************************************************************
															MULTI-EDIT MACRO
Name: MOVEBL

Description:	Brings up a menu of all windows who have a block defined for
							inter-window block moving

								Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

  RM( 'WINMENU /WT=Inter-Window Move/WH=Select window to move from and press <ENTER>, or <ESC> to abort/HS=' +
			WINMOVE_HELPLINK + '/EM=No windows with marked blocks available/HE=0/DB=1/DC=0' + MParm_Str);
	Window_Attr = Window_Attr & $FE;
	if (Return_Int != 0) {
		Window_Move(Return_Int);
    if( global_int("BlockOffAfterPaste"))
    {
      block_off;
    }
	}
}

void LinkWin TRANS2 {
/*******************************************************************************
															MULTI-EDIT MACRO
Name: LINKWIN

Description:	Brings up a menu of all windows for linking

Parameters:

								Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int jx, mr;

	MR = Parse_Int('/Y=',MParm_Str);
	if (MR == 0) {
		MR = 2;
	}
	if (link_stat == 0) {
		if (global_str('@DEL_VERIFY_MACRO') != '') {
			rm( global_str('@DEL_VERIFY_MACRO'));
		}
		if (File_Changed) {
			RM('USERIN^CHECKFILE /H=' + LINKWIN_HELPLINK + '/Y=' + str(mr) + '/X=' +
					parse_str('/X=',mparm_str));
			if (return_int <= 0) {
				Return_Int = 0;
				GOTO Exit;
			}
		}
	}

	RM( 'WINMENU /WT=Link Window/WH=Select window to link to and press <ENTER>, or <ESC> to abort/HS=' +
			LINKWIN_HELPLINK + '/HE=0/DB=0/DC=0' + MParm_Str);
	if (Return_Int != 0) {
		Link_Window(Return_Int);
		Return_Int = 1;
		RM('SetWindowNames');
	}
	Window_Attr = Window_Attr & $FE;

	return_int = 100;
EXIT:

}

int DELWIN (int no_del = parse_int("/NODEL=", mparm_str),
            int MR = parse_int("/Y=",mparm_str),
            int BC = parse_int("/BC=",mparm_str)) TRANS2 {
/*******************************************************************************
															MULTI-EDIT MACRO
Name: DELWIN

Description:	Deletes a window after checking to see if file has been saved

Parameters:
							/BC=	Number of boxes leave upon exit
							/NODEL=1  Perform all operations as if the window was
												deleted (like resizing other windows) but do not
												actually delete the window.

								Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
  int   jx, x1,y1, x2,y2, ts, new_win, new_ts, tr;
  int   w_id, mx1, mx2, my1, my2;

	Return_Int = False;
	tr = refresh;
  if (MR == 0) {
    MR = 2;
  }
	new_win = 0;

	if (!( no_del ) && (link_stat == 0)) {
		RM('USERIN^CHECKFILE /H=');
		if (return_int <= 0) {
			return_int = false;
			GOTO Exit;
		}
	}

	Return_Int = True;
  Working;
	refresh = FALSE;
	if ( !no_del && (window_id == global_int('~MEERR_SPLIT_ID')) ) {
		jx = window_id;
		if( switch_win_id( global_int('~MEERR_ID' ) ) ) {
			if( !file_changed ) {
        DELWIN(0,0,0);
			}
			switch_win_id( jx );
		}
	}
	ts = screen_num;
	w_id = window_id;
	Refresh = False;

/* If the window we are about to delete shares the screen with another, choose
   the first shared window we find, otherwise choose according to sequence

  RM("SCREEN_SHARE");
  if (return_int & 0x7F) {
    switch (return_int) {
      case 1 :
        return_int = 3;
        break;
      case 2 :
        return_int = 4;
        break;
      case 4 :
        return_int = 2;
        break;
      case 8 :
        return_int = 1;
        break;
    }
    New_Win = Parse_Int('/' + Str(return_int) + '=',
              Global_Str('!SCREEN_SHARE'));
  } else {
 */
  if (Cur_Window == Window_Count) {
    switch_window( cur_window - 1);
    new_win = window_id;
    switch_window( cur_window + 1);
  } else {
    switch_window( cur_window + 1);
    new_win = window_id;
    switch_window( cur_window - 1);
  }

	if (no_del == 0) {
		set_global_str('!WINZOOM#' + str(window_id), '');
    Delete_window;
	}

out:
	if (no_del) {
		switch_win_id( w_id );
	} else {
    switch_win_id(new_win);
	}

  RM( 'FINDWIN /NM=1' );
  /*
  if( window_attr & $80 )
  {
    int nofile_ok = FALSE;
    if(  (caps(file_name) == '?NO-FILE?') & (file_changed == FALSE)  ) {
      if((lines_in_mem == 0) && (eof_in_mem))
      {
        nofile_ok = TRUE;
      }
    }
    if (!nofile_ok || ((window_attr & $80) != 0))
    {
      RM('CREATEWINDOW /ND=' + str(nofile_hidden == 1));
      RM('EXTSETUP /PRE=1');
    }
    if( nofile_hidden )
    {
      make_window_visible( 0 );
      window_attr = $81;
    }
  }
   */
  RM( 'SetWindowNames');
  New_Screen;
	if (auto_arrange_icons)
    WIN_ICON_ARRANGE();

  return_int = new_win;
	refresh = TR;
EXIT:
  RETURN(return_int);
}

void Win_Icon_Arrange () {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: WIN_ICON_ARRANGE

Description:  Arranges window icons at the bottom of the screen.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
  SendMessage (client_handle, WM_MDIICONARRANGE, 0, 0);
  return();
}

void MakeWin TRANS2 {
/*******************************************************************************
															MULTI-EDIT MACRO
Name: MAKEWIN

Description:	Creates a new window after checking to see if the window limit
							has been reached

Parameters:
							/NL=1		Will not load a file or attempt a link.  Use this if you
											just want to create a window with a window name and you'll
											take care of loading a file yourself.

							/L=1		Will cause the new window to be linked to the
											original window if the file is already loaded AND
											the user has requested the file NOT be reloaded.

							/NC=1		Will bypass the creation of the window, and just prompt for
											loading a file and taking care of linking if the file is already
											loaded.

								Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

  int  tw1, tw2, jx;

	if (Window_Count >= 100) {
		Error_Level = 1001;
		Goto Exit;
	}
  int nc = parse_int('/NC=', mparm_str);
  int nl = parse_int ('/NL=', mparm_str);

	refresh = FALSE;
	if (nc == 0) {
		tw2 = window_id;
		RM('CreateWindow');
		tw1 = cur_window;
		switch_win_id( tw2);
		refresh = true;
		switch_window( tw1 );
		tw1 = window_id;
		RM('EXTSETUP /PRE=1');
	} else {
		tw1 = window_id;
	}

  if (nl) {
		Goto NL_EXIT;
	}
Bypass_Create:
	RM('MEUTIL1^LOADFILE /X=' + Str(win_x1) + '/Y=' + str(win_y1) + '/E=' + Str(nc == 0));
	tw2 = window_id;
	if (tw2 != tw1) {
		refresh = false;
		jx = cur_window;
		if (switch_win_id( tw1 )) {
			if (caps(file_name) == '?NO-FILE?') {
				if (parse_int('/L=',mparm_str)) {
					link_window( jx );
					make_message('Window linked.');
				} else if (nc == 0) {
					delete_window;
					new_screen;
					if (switch_win_id( tw2 )) {
					}
				}
			}
		}
	}
NL_EXIT:
	RM('SetWindowNames');
Exit:
}

void Zoom () TRANS2 {
/*******************************************************************************
															 MULTI-EDIT MACRO

NAME:  ZOOM

DESCRIPTION:  Replaces the ZOOM macro command.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
  if ((window_attr & $40) != 0) {
    SendMessage (client_handle, WM_MDIRESTORE, window_handle, 0);
  }
  else
  {
    int temp = SendMessage (client_handle, WM_MDIGETACTIVE, 0, 0 ) ;
    if ( temp & $ffff0000 )
    {
      SendMessage (client_handle, WM_MDIRESTORE, window_handle, 0);
    }
    else
    {
      SendMessage (client_handle, WM_MDIMAXIMIZE, window_handle, 0);
    }
  }
  return();
}

void Minimize ()
{
  ShowWindow  (window_handle, SW_MINIMIZE);
}

void Maximize ()
{
  SendMessage (client_handle, WM_MDIMAXIMIZE, window_handle, 0);
  return ();
}

/****************** Multi-Edit INTEGER Macro Function ***********************

 NAME:         WinViewCount()

 DESCRIPTION:  Returns the total number of windows that are NOT defined with
							 the $80 attribute.

*****************************07-19-93 10:25am*******************************/
int WinViewCount()
{
	int r = refresh, tw = cur_window,
			count = 0;
	refresh = false;

	do
	{
		switch_window( cur_window + 1 );
		if(!(window_attr & $80))
			++count;
	} while ( cur_window != tw );

	refresh = r;
	return(count);
}

void SplitWin (int split_size = parse_int("/LN#=",mparm_str),
                str direction[10] = caps(parse_str('/DIR=', mparm_str)),
                int win2_id = parse_int("/ID=",mparm_str)
              ) TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: SPLITWIN

Description: Splits a window horizontally or vertically.

Parameters:  Prompts the user if no parameters are passed.

						/DIR=str	Direction (str is NOT case sensitive)
									str = Up
									str = Down
									str = Left
									str = Right
						/LN#=n   Number of lines (or columns) in the new window.
									 0 means use half of the original window.
						/ID=     ID of window to split with, bypasses user in put of file
										 name to split with.
            /WL=1 Show window list.
							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
  int cur_window_width,
      cur_window_height,
      cur_window_left,
      cur_window_top,
      t_int,
      new_window_left,
      new_window_top,
      window1_left,
      window1_top,
      window1_width,
      window1_height,
      window2_left,
      window2_top,
      window2_width,
      window2_height,
      dlg_handle,
      line_height, font_height, font_width, dfont,
      cur_screen,
      x_offset,
      y_offset,
      tw1,
      tw2,
      j1,
      old_win = cur_window
      ;


  struct TRECT cur_window_rect, client_rect;

  struct TMsg msg;


  if (direction == "") {
    dlg_handle = Create_MEW_Dlg("Split Window", "", client_handle, 0);

    Get_MEW_Dlg_Metrics( dlg_handle, line_height, font_height, font_width, dfont );

    BuildMEWButton(dlg_handle,
                      MEWBTN_RT_WIN31OEM,
                      "obm_UpArrow",
                      bs_pushbutton,
                      MEWBTN_PUSHBUTTON | MEWBTN_SIZETOBITMAP,
                      1010,
                      int_r(real_i(font_width) * 9.5),
                      1,
                      0,
                      0 );

    BuildMEWButton(dlg_handle,
                      MEWBTN_RT_WIN31OEM,
                      "obm_DnArrow",
                      bs_pushbutton,
                      MEWBTN_PUSHBUTTON | MEWBTN_SIZETOBITMAP,
                      1011,
                      int_r(real_i(font_width) * 9.5),
                      line_height * 4,
                      0,
                      0 );

    BuildMEWButton(dlg_handle,
                      MEWBTN_RT_WIN31OEM,
                      "obm_LfArrow",
                      bs_pushbutton,
                      MEWBTN_PUSHBUTTON | MEWBTN_SIZETOBITMAP,
                      1012,
                      1,
                      line_height * 2,
                      0,
                      0 );

    BuildMEWButton(dlg_handle,
                      MEWBTN_RT_WIN31OEM,
                      "obm_RgArrow",
                      bs_pushbutton,
                      MEWBTN_PUSHBUTTON | MEWBTN_SIZETOBITMAP,
                      1013,
                      font_width * 19,
                      line_height * 2,
                      0,
                      0 );

      t_int = Create_MEW_Ctrl( "BUTTON", "Cancel",
                  ws_child | bs_pushbutton | ws_visible | bs_defpushbutton,
                  font_width * 7,
                  line_height * 2,
                  font_width * 8,
                  line_height + 2,
                  dlg_handle,1002,
                  app_handle,  0
                );


      EnableWindow( dlg_handle, TRUE );
      ShowWindow( dlg_handle, sw_show );


      SetFocus(t_int);


kloop:
          if (getmessage( &msg,0,0,0)) {
            if (msg.message == wm_user) {
              switch( msg.wparam ) {
                case 2 :
                case 1002 :
                  goto kdone;
                  break;
                case 1010 : // up
  // messagebeep(-1);
                  direction = "UP";
                  goto kdone;
                  break;
                case 1011 : // down
  // messagebeep(-1);
                  direction = "DOWN";
                  goto kdone;
                  break;
                case 1012 : // left
  // messagebeep(-1);
                  direction = "LEFT";
                  goto kdone;
                  break;
                case 1013 : // right
  // messagebeep(-1);
                  direction = "RIGHT";
                  goto kdone;
                  break;
              }
            } else if (msg.message == WM_KEYDOWN) {
              switch (msg.wParam) {
                case vk_up :  // up arrow
  // messagebeep(-1);
                  direction = "UP";
                  goto kdone;
                  break;
                case vk_down :  // down arrow
  // messagebeep(-1);
                  direction = "DOWN";
                  goto kdone;
                  break;
                case vk_left :  // left arrow
  // messagebeep(-1);
                  direction = "LEFT";
                  goto kdone;
                  break;
                case vk_right :  // right arrow
  // messagebeep(-1);
                  direction = "RIGHT";
                  goto kdone;
                  break;
              }
            } else if (msg.message == WM_SYSCOMMAND) {
              if (msg.wparam == SC_CLOSE) {
                goto KDONE;
              }
            }
            if (!IsDialogMessage(dlg_handle, &msg)) {
                translatemessage( &msg );
                dispatchmessage( &msg );
            }
          }
          goto kloop;
kdone:


    Destroy_Mew_Dlg( dlg_handle );

  }


  if (direction != "") {
    if (IsZoomed(window_handle)) {
  //  messagebeep(-1);
      SendMessage(client_handle,WM_MDIRESTORE,window_handle,0);
      GetClientRect(client_handle,&client_rect);
      cur_window_width = client_rect.right - client_rect.left;
      cur_window_height = client_rect.bottom - client_rect.top;
      cur_window_left = client_rect.left;
      cur_window_top = client_rect.top;
    } else {
      GetWindowRect(window_handle,&cur_window_rect);
      cur_window_width = cur_window_rect.right - cur_window_rect.left;
      cur_window_height = cur_window_rect.bottom - cur_window_rect.top;

  // convert coordinates for MoveWindow function
      ScreenToClient(client_handle, &cur_window_rect);
      cur_window_left = cur_window_rect.left;
      cur_window_top = cur_window_rect.top;
    }

    if (split_size > 0) {
      if ((direction == "LEFT") || (direction == "RIGHT")) {
        ++split_size;  // this is to sort of compensate for the space at the left of the window
      }
      int tfont, xdc;
      struct TTextMetric xTextMetrics;

      fonts_get(0,tfont,xdc,xdc);
      xdc = GetDc( window_handle );
      SelectObject( xdc, tfont );
      GetTextMetrics(xDC, &xTextMetrics);
      ReleaseDC(window_handle, xDC);
//      font_height = xTextMetrics.tmHeight;
//      font_width = xTextMetrics.tmAveCharWidth;


      GetClientRect(window_handle,&client_rect);

      y_offset = ((cur_window_height - (client_rect.bottom - client_rect.top)) +
                  (xTextMetrics.tmHeight * split_size));

      x_offset = ((cur_window_width - (client_rect.right - client_rect.left)) +
                  (xTextMetrics.tmAveCharWidth * split_size));



      switch (direction) {
        case "UP" :
          window1_left = cur_window_left;
          window1_top = cur_window_top + y_offset;
          window1_width = cur_window_width;
          window1_height = cur_window_height - y_offset;

          window2_left = cur_window_left;
          window2_top = cur_window_top;
          window2_width = cur_window_width;
          window2_height = y_offset;
          break;
        case "DOWN" :
          window1_left = cur_window_left;
          window1_top = cur_window_top;
          window1_width = cur_window_width;
          window1_height = cur_window_height - y_offset;

          window2_left = cur_window_left;
          window2_top = cur_window_top + cur_window_height - y_offset;
          window2_width = cur_window_width;
          window2_height = y_offset;
          break;
        case "LEFT" :
          window1_left = cur_window_left + x_offset;
          window1_top = cur_window_top;
          window1_width = cur_window_width - x_offset;
          window1_height = cur_window_height;

          window2_left = cur_window_left;
          window2_top = cur_window_top;
          window2_width = x_offset;
          window2_height = cur_window_height;
          break;
        case "RIGHT" :
          window1_left = cur_window_left;
          window1_top = cur_window_top;
          window1_width = cur_window_width - x_offset;
          window1_height = cur_window_height;

          window2_left = cur_window_left + cur_window_width - x_offset;
          window2_top = cur_window_top;
          window2_width = x_offset;
          window2_height = cur_window_height;
          break;
        default:
          goto EXIT;
          break;
      }

    } else {

      switch (direction) {
        case "UP" :
          window1_left = cur_window_left;
          window1_top = cur_window_top + (cur_window_height / 2);
          window1_width = cur_window_width;
          window1_height = cur_window_height / 2;

          window2_left = cur_window_left;
          window2_top = cur_window_top;
          window2_width = cur_window_width;
          window2_height = cur_window_height / 2;
          break;
        case "DOWN" :
          window1_left = cur_window_left;
          window1_top = cur_window_top;
          window1_width = cur_window_width;
          window1_height = cur_window_height / 2;

          window2_left = cur_window_left;
          window2_top = cur_window_top + (cur_window_height / 2);
          window2_width = cur_window_width;
          window2_height = cur_window_height / 2;
          break;
        case "LEFT" :
          window1_left = cur_window_left + (cur_window_width / 2);
          window1_top = cur_window_top;
          window1_width = cur_window_width / 2;
          window1_height = cur_window_height;

          window2_left = cur_window_left;
          window2_top = cur_window_top;
          window2_width = cur_window_width / 2;
          window2_height = cur_window_height;
          break;
        case "RIGHT" :
          window1_left = cur_window_left;
          window1_top = cur_window_top;
          window1_width = cur_window_width / 2;
          window1_height = cur_window_height;

          window2_left = cur_window_left + (cur_window_width / 2);
          window2_top = cur_window_top;
          window2_width = cur_window_width / 2;
          window2_height = cur_window_height;
          break;
        default:
          goto EXIT;
          break;
      }
    }


    if (
        (window1_width < GetSystemMetrics(SM_CXMIN)) ||
        (window2_width < GetSystemMetrics(SM_CXMIN)) ||
        (window1_height < GetSystemMetrics(SM_CYMIN)) ||
        (window2_height < GetSystemMetrics(SM_CYMIN))
        ) {
      RM("MESSAGEBOX /B=1/T=Split Window/M=Window too small to split");
    } else {

      if (screen_num == 0) {
        screen_num = global_int('@SCREEN_COUNT') + 1;
        if (screen_num <= 1) {
          screen_num = 2;
        }
        set_global_int('@SCREEN_COUNT', screen_num );
      }
      cur_screen = screen_num;

      MoveWindow(window_handle,
        window1_left,
        window1_top,
        window1_width,
        window1_height,
        true
        );

      if (win2_id) {
        switch_win_id(win2_id);
      } else {
        RM("CreateWindow /ND=1");
      }


      MoveWindow(window_handle,
        window2_left,
        window2_top,
        window2_width,
        window2_height,
        true
        );
      screen_num = cur_screen;

      if (win2_id) {
        RETURN();
      }

		tw1 = window_id;
		return_int = 0;
		if (parse_int('/WL=', mparm_str)) {
			if( WinViewCount() > 2 )
			{
				RM( 'WINMENU /WT=Link Window/WH=Select window to link to and press <ENTER>, or <ESC> to abort/HS=' +
						LINKWIN_HELPLINK + '/HE=0/DB=0/DC=0' + MParm_Str);
				if (Return_Int != 0) {
					Link_Window(Return_Int);

/*
 This is a work-around for a bug in link_window that sets screen num to the
 same as the window you are linking to.  It should not do this.
*/
screen_num = cur_screen;

					Return_Int = 1;
					RM('SetWindowNames');
					Return_Int = 1;
				}
			}
		}
		if (return_int == 0) {
			RM('MEUTIL1^LOADFILE /X=' + str(win_x1) + '/Y=' + str(win_y1));
			if (return_int == 0) {
				link_window(old_win);
				make_message( 'Window linked.');
			} else {
				tw2 = window_id;
				j1 = cur_window;
				if (tw2 != tw1) {
					refresh = false;
					if (switch_win_id( tw1 )) {
						if (caps(file_name) == '?NO-FILE?') {
							link_window( j1 );
							make_message( 'Window linked.');
						}
					}
				}
			}
		}
		refresh = false;
		RM('SetWindowNames');
    }
    return_int = 1;
  } else
    return_int = 0;

EXIT:

}

/********************************************************************************
 * Allow  for customization of the MDI window for attached to current ME Buffer
 *
 *
 ********************************************************************************/
void WinCustomize  ()
{
  int jx, jy, id;
  int flags, k1, k2;
  str tstr1, tstr2;
  int numItems;
  int hMenu, hSysMenu;
  str sMenuText [80];
  str passedstr = global_str('ACTIVE_MDI');

  if ( passedstr == '' )
    passedstr = 'MDI';

  if ( window_handle )
  {
    hMenu    = CreateMenuFromDB (WCmdMapName, passedstr, MENU_PopUp);
    if ( hMenu != 0 )
    {
      hSysMenu = GetSystemMenu (window_handle, FALSE);

      if ( hSysMenu != 0)
      {
        numItems =  GetMenuItemCount (hSysMenu);
        if((numItems > 0) && (numItems < 32000))
        {
          jy = 0;
          for ( jx = 0; jx < numItems; jx++ )
          {
            id = GetMenuItemID (hSysMenu, jy);
            switch (id )
            {
              case SC_CLOSE :
                if (Wcmd_Find (0, Global_Int ("~CLOSE_WCMD_ID"), flags, k1, k2, tstr1, tstr2)) {
                  if ( k1 | k2 )
                  {
                    tstr1 = "&Close\t" + Make_Key_Name (k1 | (k2 << 8));
                    ModifyMenu (hSysMenu, jy, MF_STRING | MF_BYPOSITION, id, tstr1);
                  }
                }
                jy++;
                break;
              case SC_MINIMIZE :
                if (Wcmd_Find (0, Global_Int ("~MIN_WCMD_ID"), flags, k1, k2, tstr1, tstr2)) {
                  if ( k1 | k2 )
                  {
                    tstr1 = "Mi&nimize\t" + Make_Key_Name (k1 | (k2 << 8));
                    ModifyMenu (hSysMenu, jy, MF_STRING | MF_BYPOSITION, id, tstr1);
                  }
                }
                jy++;
                break;
              case SC_MAXIMIZE :
                if (Wcmd_Find (0, Global_Int ("~MAX_WCMD_ID"), flags, k1, k2, tstr1, tstr2)) {
                  if ( k1 | k2 )
                  {
                    tstr1 = "Ma&ximize\t" + Make_Key_Name (k1 | (k2 << 8));
                    ModifyMenu (hSysMenu, jy, MF_STRING | MF_BYPOSITION, id, tstr1);
                  }
                }
                jy++;
                break;
              case SC_RESTORE :
                if (Wcmd_Find (0, Global_Int ("~RESTORE_WCMD_ID"), flags, k1, k2, tstr1, tstr2)) {
                  if ( k1 | k2 )
                  {
                    tstr1 = "&Restore\t" + Make_Key_Name (k1 | (k2 << 8));
                    ModifyMenu (hSysMenu, jy, MF_STRING | MF_BYPOSITION, id, tstr1);
                  }
                }
                jy++;
                break;
              case SC_MOVE :
                if (Wcmd_Find (0, Global_Int ("~MOVE_WCMD_ID"), flags, k1, k2, tstr1, tstr2)) {
                  if ( k1 | k2 )
                  {
                    tstr1 = "&Move\t" + Make_Key_Name (k1 | (k2 << 8));
                    ModifyMenu (hSysMenu, jy, MF_STRING | MF_BYPOSITION, id, tstr1);
                  }
                }
                jy++;
                break;
              case SC_SIZE :
                if (Wcmd_Find (0, Global_Int ("~SIZE_WCMD_ID"), flags, k1, k2, tstr1, tstr2)) {
                  if ( k1 | k2 )
                  {
                    tstr1 = "&Size\t" + Make_Key_Name (k1 | (k2 << 8));
                    ModifyMenu (hSysMenu, jy, MF_STRING | MF_BYPOSITION, id, tstr1);
                  }
                }
                jy++;
                break;
              case 0 :
                jy++;
                break;
              default:
                DeleteMenu ( hSysMenu, jy, MF_BYPOSITION);
            }
          }

          numItems = GetMenuItemCount (hMenu);
          if((numItems > 0) && (numItems < 32000))
          {
            for ( jx = 0; jx < numItems; jx++ )
            {
              GetMenuString (hMenu, jx, sMenuText, 80, MF_BYPOSITION);
              AppendMenu (hSysMenu,
                GetMenuState(hMenu, jx, MF_BYPOSITION),
                GetMenuItemID (hMenu, jx),
                sMenuText);
            }
          }
          else
          {
            beep;
          }
        }
      //  DrawMenuBar (hSysMenu);
      }
      else
      {
        beep;
      }
      DestroyMenu (hMenu);
    }
  }
}


void WOrganize  ( int op = parse_int ("/M=", mparm_str)) TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name:				WOrganize

Description:	Organizes all non hidden windows on the screen by either
							cascading, tiling or minimizing them.

Parameters:   /M=0		Cascade
              /M=1    Tile vertical
							/M=2		Minimize
              /M=3    Tile horizontal

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
  switch (op)
  {
    case 0 :
      SendMessage (client_handle, WM_MDICASCADE, 0, 0);
      break;
    case 1 :
      SendMessage (client_handle, WM_MDITILE, MDITILE_VERTICAL, 0);
      break;
    case 2 :
      break;
    case 3 :
      SendMessage (client_handle, WM_MDITILE, MDITILE_HORIZONTAL, 0);
      break;
  }
}

void WinOp (int op = parse_int ("/T=", mparm_str)) TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: WINOP

Description:  Performs various window operations

Parameters:		/T=0	Create window
							/T=1  Delete window
							/T=2  Hide window
							/T=3  Window list
							/T=4  Split window
							/T=5  Resize window
							/T=6  Link window
							/T=7  Unlink window
							/T=8  Zoom window
							/T=9  Delete all windows
              /T=10 Minimize Window

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	int  tt ;

	switch (Parse_Int('/T=', mparm_str)) {
		case 0 :
      RM('MakeWin');
			break;
		case 1 :
      RM('DelWin ' + mparm_str);
			make_message("");
			break;
		case 2 :
      Window_Attr |= $01;
      Make_Window_Visible(0);

			RM( 'FindWin /NM=1' );
			New_Screen;
			break;
		case 3 :
			RM( 'SwitWin' );
			break;
		case 4 :
      RM( 'SplitWin /WL=1' );
			break;
		case 5 :
      // Mod_Win(0,0,0);
			break;
		case 6 :
      RM('Linkwin ' + mparm_str);
			break;
		case 7 :
			unlink_window;
			break;
		case 8 :
      Zoom ();
			break;
		case 9 :
      do {
				tt = window_count;
        DelWin (0, 0, 0);
			}	while (tt > window_count);
			make_message("");
			break;
    case 10 :
      Minimize ();
      break;
    case 11 :
      Maximize ();
      break;
    case 15 :
      WinCustomize ();
      break;
	}
}