//+++keyword+++ "@(#)%v %n, %f, %w"
// "@(#)15 VCS.SH, 04-Feb-95,01:40:12, LDH"

// #define _DEBUG_
// #define _BETA_

#ifdef  _BETA_
  #define _VCS_DB       "VCS_BETA"
  #define _VCS_VERSION  "7.00p(0.09a)"
#else
  #define _VCS_DB       "MECONFIG"
  #define _VCS_VERSION  "7.00p(0.09a)"
#endif

struct VcsCfgInfo {
  str Pkg[ 12 ];
  int Enable;
  int ShowCL;
  int Prompt;
  int BSave;
  int XitStat;
  int FReload;
  int CDifOn;
  int GFMode;
  int MLineCmt;
  int VRst;
  int WDMode;
  str XMac;
}

prototype Vcs {
  int  VcsShowWin( str FName, int Reload );
  str  VcsXlate( str Path, str FName, str LFile );
  str  VcsGetFName( str LFile );
  int  VcsChkLib( str Path, str Fname, int Pm );
  str  VcsLookup( str FName, str Field1, str Field2 );
  str  VcsCfgFile( str FName, str Param );
  int  VcsGetPath( str Path, str FName, str Ext, int Pm );
  int  VcsFileOut( str FName, int Put );
  int  VcsGetLib( str FName );
  void VcsPushPos( );
  void VcsPopPos( int Restore );
  int  VcsGetCmt( int Prompt, int Keep );
  void VcsPutCmt( int Prompt );
  int  VcsChkVer( str Vers );
  int  IIf( int Expr, int Texpr, int Fexpr );
  str  SIf( int Expr, str Texpr, str Fexpr );
  void GetDrives( );
  void VcsUpdate( );
  // Dialog macros in VCS.SWI
  int  VcsGetFileDlg( str Title, str Msg, str File );
  int  VcsCUSDlg( str Title, str Msg, str File, int RO );
  int  VcsCUMsgProc( int &RetVal, int Dlg, int Message, int WParam, int LParam,
          str Parms );
  int  VcsCULstDlg( str Title, int NoXit, int OutCnt );
  void VcsGetPkg( );
  int  VcsCfgDlg( str Title, struct VcsCfgInfo CfgDat );
  int  VcsEditStrDlg( str Title, str &EString, int MLE );
  int  VcsViewWinDlg( str Title, int Width, int Height, str Bitmap, str HelpCtx );
  int  VcsLoginDlg( str Title, str &User, str &Pwd );
  int  VcsFileSelDir( str &FileMask );
  int  VcsFileSetLst( str &FileMask, int hDWin, int hFWin, int Flags );
  int  VcsFileChgView( str &View, int Dlg );
  void VcsFileBtnProc( );
  void VcsFileCmds( );
  void VcsFileSetCtrls( int hDlg, int Func );
  int  VcsFileMsgProc( int &RetVal, int Window, int Message, int WParam,
          int LParam, str Parms );
  void VcsFileDlg( str Title, str FileMask, str User );
}

global {
  int vcsEnable     "&vcsEnable";
  int vcsDoLogin    "!vcsDoLogin";

  str vcs_history;
  str vcs_history0;
  str vcs_wrk_history;
  str vcs_wrk_history0;
  str vcs_prj_history;
  str vcs_prj_history0;

  int vcsRInt         "!vcsRInt";
  str vcsRStr         "!vcsRStr";

  str vcsCFG          "!vcsCFG";
  str vcsID           "!vcsID";
  str vcsGFM          "!vcsGFM";
  str vcsPrjDir       "!vcsPrjDir";
  str vcsName         "!vcsName";
  str vcsAFile        "!vcsAFile";
  str vcsFName        "!vcsFName";
  str vcsCmtFile      "!vcsCmtFile";
  str vcsChkMod       "!vcsChkMod";
  str vcsMsg          "!vcsMsg";
  str vcsDlgMsg       "!vcsDlgMsg";
  str vcsCmd          "!vcsCmd";
  str vcsVerStr       "!vcsVerStr";
  str vcsRevStr       "!vcsRevStr";
  int vcsCmdNo        "!vcsCmdNo";
  int vcsLibFnd       "!vcsLibFnd";
  int vcsSNP          "!vcsSNP";
  int vcsSNCL         "!vcsSNCL";
  int vcsChgFlg       "!vcsChgFlg";
  int vcsOutWin       "!vcsOutWin";
  int vcsDF           "!vcsDF";         // directory of library file call
  int vcsNameLoaded   "!vcsNameLoaded";

  int vcsFileDefBtn   "!vcsFileDefBtn";
  int vcsFileDefWin   "!vcsFileDefWin";
  int vcsDirLstWin    "!vcsDirLstWin";
  int vcsFileLstWin   "!vcsFileLstWin";
  int vcsFileView     "!vcsFileView";
  int vcsSaveWin      "!vcsSaveWin";
  int vcsWrkTrackArc  "vcsWrkTrackArc";
}

#define _VCS3_TMP     User_Id + "VCS3.TMP"

#define _SHOW_CMD     Parse_Int( "/SCL=", vcsCfg )
#define _DISP_WIN     Parse_Int( "/DW=", vcsCfg )
#define _DO_CD        Parse_Int( "/UCD=", vcsCfg )
#define _BSAV         Parse_Int( "/BS=", vcsCfg )
#define _CDIF         Parse_Int( "/CD=", vcsCfg )
#define _MLC          Parse_Int( "/MLC=", vcsCfg )
#define _XIT_STAT     Parse_Int( "/XIT=", vcsCfg )
#define _U_XLAT_MAC   Parse_Str( "/UXM=", vcsCfg )
#define _V_RESTORE    Parse_Int( "/VRS=", vcsCfg )
#define _RES_FILE     Parse_Int( "/FRL=", vcsCfg )

#define _LIB_PATH     Parse_Str( "PATH=", Global_Str( "!" + vcsID + "Cfg" ) )
#define _LIB_EXT      Parse_Str( "LIBEXT=", Global_Str( "!" + vcsID + "Cfg" ) )
#define _VCS_USERID   Parse_Str( "USERID=", Global_Str( "!" + vcsID + "Cfg" ) )
#define _DEL_SRC      Parse_Int( "DSRC=", Global_Str( "!" + vcsID + "Cfg" ) )
#define _RVC          Parse_Int( "RVC=", Global_Str( "!" + vcsID + "Cfg" ) )
#define _CHG_SUPPORT  Parse_Int( "CSP=", Global_Str( "!" + vcsID + "Cfg" ) )
#define _CHG_FSTART   Parse_Str( "CFS=", Global_Str( "!" + vcsID + "Cfg" ) )
#define _CHG_FEND     Parse_Str( "CFE=", Global_Str( "!" + vcsID + "Cfg" ) )
#define _BROWSE_CMDL  Parse_Str( "BC=", Global_Str( "!" + vcsID + "Cfg" ) )
#define _CREATE_CMDL  Parse_Str( "CC=", Global_Str( "!" + vcsID + "Cfg" ) )
#define _GET_CMDL     Parse_Str( "GC=", Global_Str( "!" + vcsID + "Cfg" ) )
#define _LIST_CMDL    Parse_Str( "LC=", Global_Str( "!" + vcsID + "Cfg" ) )
#define _LOCK_CMDL    Parse_Str( "OC=", Global_Str( "!" + vcsID + "Cfg" ) )
#define _PUT_CMDL     Parse_Str( "PC=", Global_Str( "!" + vcsID + "Cfg" ) )
#define _UNLOCK_CMDL  Parse_Str( "UC=", Global_Str( "!" + vcsID + "Cfg" ) )
#define _VIEW_CMDL    Parse_Str( "DC=", Global_Str( "!" + vcsID + "Cfg" ) )
#define _MENU_CMDL    Parse_Str( "MC=", Global_Str( "!" + vcsID + "Cfg" ) )

// VcsCULstDlg control ids
#define id_vcu_OutLst     1000
#define id_vcu_Checkin    2010
#define id_vcu_Remove     2011
#define id_vcu_Unlock     2012
#define id_vcu_Exit       2013
#define id_vcu_SelAll     2020
#define id_vcu_SelNone    2021

// VcsCfgDlg control id's
#define id_vcfg_Pkg       1000
#define id_vcfg_ShowCL    1001
#define id_vcfg_Prompt    1002
#define id_vcfg_BSave     1003
#define id_vcfg_XStat     1004
#define id_vcfg_FRL       1005
#define id_vcfg_CDif      1006
#define id_vcfg_GFM       1007
#define id_vcfg_MLC       1008
#define id_vcfg_VRst      1009
#define id_vcfg_WDir      1010
#define id_vcfg_XMac      1011
#define id_vcfg_Enable    1012

// VcsFileDlg control id's
#define id_vcsf_Hist      2010
#define id_vcsf_Get       2011
#define id_vcsf_Lock      2012
#define id_vcsf_ChkOut    2013
#define id_vcsf_Update    2014
#define id_vcsf_UnChk     2015
#define id_vcsf_NPrj      2016
#define id_vcsf_Refrsh    2017
#define id_vcsf_Views     2018
#define id_vcsf_Dirs      2019
#define id_vcsf_Files     2020
#define id_vcsf_WrkSet    2021
#define id_vcsf_WrkDir    2022
#define id_vcsf_ChgUsr    2023
#define id_vcsf_SelAll    2024
#define id_vcsf_SelNone   2025
#define id_vcsf_TrackArc  2026

// VcsFileDlg flags
#define _vcsf_NoUpdDWin   0x0001
#define _vcsf_NoUpdFWin   0x0002
#define _vcsf_ChgDir      0x0004
#define _vcsf_ScanDir     0x0008

// Help context strings
#define hc_vcs_Configure  "VCS Configuration Dialog"
#define hc_vcs_Admin      "VCS Administer Projects"
#define hc_vcs_ArchiveDir "VCS Directory of Archives"
#define hc_vcs_VcsPkgCfg  "VCS Package Configuration Dialog"
#define hc_vcs_ChkoutLst  "Using Multi-Edit Files From VCS Archives Dialog"
#define hc_vcs_GetFile    "Using The File Open And Close Interface"
#define hc_vcs_SetupChk   "Understanding Setup Verification"

#define hc_vcs_Verify     "VCS Verify Dialog"
#define hc_vcs_EditStr    "VCS EditStr Dialog"
#define hc_vcs_Login      "VCS Login Dialog"

#define hc_vcs_Error      "VCS Errors List"
#define hc_vcs_View       "VCS Difference List"
#define hc_vcs_List       "VCS History List"
