//+++keyword+++ "@(#)%v %n, %f, %w"
// "@(#)61 VCS.S, 04-Feb-95,01:38:50, LDH"

#include WINSMALL.SH
#include EXIT.SH
#include DIALOG.SH
#include METOOLS.SH
#include DB.SH
#include VCSCHK.SH
#include VCS.SH

#ifdef   _DEBUG_
  #include DBUG.SH                        // Dbug macros
  #include SPRINTF.SH
#endif

#ifdef _BETA_
  macro_file VCS_BETA;
#else
  macro_file VCS;
#endif

#include VCS.SWI                        // Include dialog macros

/******************************************************************************
                             Multi-Edit Macro File
                               27-Jul-93  14:37

  Interfaces to the following Version Control Software packages are supported.

    TLIB by Burton Systems Software
    PVCS by Intersolv
    RCS by Mortice Kern Systems or GNU
    Sourcerers Apprentice by Borland ( Solution Systems )
    SourceSafe by One Tree Software

  VCS          - Main VCS menu.
  VcsCmds      - The main VCS independent command interface.
  VcsGetFile   - Allows retrieval of latest revision of VCS file.
  VcsDir       - Displays and allows selection of VCS log files.
  VCSCleanup   - Makes sure user is aware of checked out files.
  VcsXlate     - Translates Return_Str to expand <LPATH>, and so on.
  VcsStatus    - Saves current VCS status ( files checked out, etc. )
  VcsRestore   - Restores VCS status ( files checked out, etc. )
  VcsLFile     - Search for a archive file in a given path.
  VcsConfigure - Displays a dialog box to allow configuring the VCS interface.
  VcsInit      - Initializes the VCS System.
  VcsChgCmt    -
  VcsFile      - Creates a file dialog box for the the other VCS packages.
  VcsXMacro    - Sample user written xlate macro.

                Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

macro Vcs Trans {
/******************************************************************************
                               Multi-Edit Macro
                               15-Sep-94  21:24

  Name    : vcs  ( Version Control System ).

  Function: Run setup verification and show main VCS menu.

  Syntax  : Rm( "Vcs /CK" );

  Entry   : /CK       = Run setup check instead of showing menu.

  Exit    : None.  Executes selected menu item when /CK not passed.

  Globals : gstr !vcsID      - The name of the selected vcs package.
            gstr !{vcsID}Cfg - The config info for the {vcsID} macro package.
            gstr !vcsVerStr  -
            gstr !vcsRevStr  -

  Macros  : mac LocateDbPage
            mac PathSearch
            mac {vcsID}   specific vcs macro ( Tlib, Pvcs, Rcs, Sap, SSafe )
            mac Menu

                Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

//+++keyword+++ "@(#)%v %n, %f, %w"
  str Rev_Id = "@(#)61 VCS.S, 04-Feb-95,01:38:50, LDH";

  if ( vcsEnable == True ) {
    if ( XPos( "/CK", MParm_Str, 1 ) ) {

      str TStr;
			str VStr;
      str Pkg[ 8 ];
      str SavID = vcsID;
      str SavCfg[ 1024 ];

      int Ow = Window_Id;
      int Stat_Win;
      int Vcs_Win;
      int Srf = Refresh;
      int Jx;

      Refresh = False;
      Switch_Window( Window_Count );
      Create_Window;
      Window_Attr = 0x81;
      Stat_Win = Window_Id;
      File_Name = "!VcsChkWin!";
      TStr = "         Mac Ver EXE  Version       Revision Information";
      Put_Line( TStr );
      Down;
      TStr = "Macro    Chk Chk Chk                Executable Path";
      Put_Line( TStr );
      Down;
      TStr = "";
      Pad_Str( TStr, 75, "=" );
      Put_Line( TStr );
      Down;
      TStr = "VCS";
      Pad_Str( TStr, 22, " " );
      TStr += _VCS_VERSION;
      Pad_Str( TStr, 36, " " );
      TStr += Rev_Id;
      Put_Line( TStr );

      if ( LocateDbPage( _VCS_DB, "VCS.CFG", False ) ) {
        Vcs_Win = Window_Id;
        Down;
        while ( !At_Eof && ( Cur_Char != "\f" ) ) {
          TStr = Parse_Str( "\x7F" + "ID=", Get_Line );
          if ( TStr == "NONE" ) {
            Down;
            continue;
          }
          if ( !( Jx = XPos( " ", TStr, 1 ) ) ) {
            Jx = Svl( TStr ) + 1;
          }
          if ( Jx > 6 ) {
            Jx = 6;
          }
          vcsID = Copy( TStr, 1, Jx - 1 );
          SavCfg = Global_Str( "!" + vcsId + "CFG" );
          Set_Global_Str( "!" + vcsId + "CFG", Get_Line( ) );

          Switch_Win_Id( Stat_Win );
          Down;
          Down;
          Return_Str = "<MAC_PATH>;<ME_PATH>MAC";
          Rm( "PathSearch /F=" + vcsId + ".MAC" );
          if ( Return_Int ) {           // Macro found
            Return_Str = "";
            Rm( vcsId );
            if ( ( vcsId == Copy( vcsVerStr, 1, Pos( " ", vcsVerStr ) - 1 ) ) &&
                !Error_Level ) {
              Pad_Str( TStr, 10, " " );
              TStr += "x";
            }
            VStr = Copy( vcsVerStr, Pos( " ", vcsVerStr ) + 1, 12 );
            if ( VcsChkVer( VStr ) ) {
              Pad_Str( TStr, 14, " " );
              TStr += "x";
            }
            Pad_Str( TStr, 22, " " );
						TStr += VStr;
            Pad_Str( TStr, 36, " " );
            TStr += vcsRevStr;
            Put_Line( TStr );
            Down;
            TStr = "";
            if ( Return_Str != "" ) {
              Pad_Str( TStr, 18, " " );
              TStr += "x";
              Pad_Str( TStr, 36, " " );
              TStr += Return_Str;
            }
            Put_Line( TStr );
          }
          else {
            Put_Line( TStr );
            Down;
          }
//           if ( !Return_Int ) {
//             Set_Global_Str( "!" + vcsID + "CFG", "" );
//           }
          vcsVerStr = "";
          vcsRevStr = "";

          Switch_Win_Id( Vcs_Win );
          Down;
          Goto_Col( 1 );
          Error_Level = 0;
          Set_Global_Str( "!" + vcsID + "CFG", SavCfg );
        }
      }
      if ( Switch_Win_Id( Stat_Win ) ) {
        Tof;
        VcsViewWinDlg( "Vcs Setup Verification", 100, 18, "", hc_vcs_SetupChk );
        Delete_Window;
      }
      Switch_Win_Id( Ow );
      vcsID = SavID;
      Refresh = Srf;
    }
  }
}  // Vcs

macro VcsCmds Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               01-Apr-94  17:37

  Name    : VcsCmds

  Function: The main VCS independent command interface

  Syntax  : Rm( "VcsCmds /C=str/F=str/P=str/W=str/PD=str/DF/NO_EXT=1/ND=1" );

  Entry   : /C=str    Command string
              BROWSE  Get file out of archive for browsing.
              GET     Get file out of archive for modifications.
              LIST    List file revisions.
              LOCK    Lock a archive file without checking it out.
              PUT     Put file back in archive.
              UNLOCK  Unlock and delete a checked out file.
              VIEW    View the changes to the current file.
            /F=str    File name
            /A=str    Archive path for output files
            /WD=str   Work directory override
            /PD=str   Project directory override
            /CM=str   ChkOut mode
            /ON=int   ChkOut entry number
            /DF       Called from VcsDir.
            /ND=1     NO deletion of the current window will take place
            /NO_EXT=1 NO Rm( "EXTSETUP" ) after loading file TMJ 10-02-91 12:12pm

  Exit    : Return_Int
              True    No Error
              False   ( Error_Level == 0 ) Cmd Cancelled
                      ( Error_Level != 0 ) Error

  Globals :

  Macros  :

                Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

  Return_Int = False;
  if ( vcsNoPkg( ) == False ) {

    str Pkg[ 8 ] = vcsID;
    str Cmd[ 20 ] = Caps( Shorten_Str( Parse_Str( "/C=", MParm_Str ) ) );
    str WrkDir = Parse_Str( "/WD=", MParm_Str );

    int Org_Win = Window_Id;
    int Old_Win;
    int Vcs_Win;
    int Out_Num = Parse_Int( "/ON=", MParm_Str );
    int Out_Cnt = Global_Int( "!VCS_" + Pkg + "_COUNT!" );
    int Srf = Refresh;                  // save refresh variable

    Refresh = False;

    vcsMsg = "";
    Make_Message( vcsMsg );

    vcsLibFnd = Parse_Int( "/LPOS=", MParm_Str );  // setup globals
    vcsDF = XPos( "/DF", MParm_Str, 1 );  // called from VcsDir
    vcsFName = Parse_Str( "/F=", MParm_Str );  // set global File Name
    vcsAFile = Parse_Str( "/A=", MParm_Str );  // set global ArchiveFile
    vcsPrjDir = Parse_Str( "/PD=", MParm_Str );
    vcsChkMod = Parse_Str( "/CM=", MParm_Str );

    if ( vcsAFile == "" ) {
      if ( vcsFName == "" ) {
        vcsFName = File_Name;
      }
      else {
        vcsFName = FExpand( vcsFName );
      }
      vcsLibFnd = VcsChkLib( _LIB_PATH, vcsFName, -1 );
//       DBug( "VcsLibFnd=%d FN=%s AF=%s", vcsLibFnd, vcsFName, vcsAFile );
      Return_Int = True;
    }
    else {
      if ( vcsFName == "" ) {
        vcsFName = VcsGetFName( vcsAFile );
      }
      Return_Int = True;
      if ( vcsFName == "" ) {
        vcsMsg = "Can't derive workfile from archive \"" + vcsAFile + "\".";
        Return_Int = False;
      }
    }
    if ( Return_Int ) {
      if ( !_DO_CD ) {                   // Current dir
        vcsFName = FExpand( Truncate_Path( vcsFName ) );
      }
      else if ( _DO_CD == 1 ) {          // File dir
        if ( WrkDir == "" ) {
          if ( _LIB_PATH == "<LOOKUP>" ) {
            WrkDir = VcsLookup( vcsFName, "FD", "WD" );
          }
        }
        if ( WrkDir != "" ) {
          vcsFName = WrkDir + Truncate_Path( vcsFName );
        }
        vcsPrjDir = Get_Path( vcsFName );
      }
      else {                            // Project dir
        if ( WrkDir == "" ) {
          WrkDir = VcsLookup( vcsFName, "FD", "WD" );
        }
        if ( WrkDir != "" ) {
          vcsFName = WrkDir + Truncate_Path( vcsFName );
        }
        if ( vcsPrjDir == "" ) {
          WrkDir = VcsLookup( vcsFName, "FD", "PD" );
          if ( vcsPrjDir == "" ) {
            vcsPrjDir = Get_Path( vcsFName );
          }
        }
      }
      if ( Switch_File( vcsName ) ) {
        Erase_Window;
      }
      else {
        Switch_Window( Window_Count );
        Create_Window;
      }
      Window_Attr = 0x81;
      Vcs_Win = Window_Id;
      File_Name = vcsName;
      vcsNameLoaded = False;
      Switch_Win_Id( Org_Win );
//       DBug( "VcsLibFnd=%d FN=%s AF=%s", vcsLibFnd, vcsFName, vcsAFile );
      switch ( Cmd ) {
        case "VIEW":
          Old_Win = Window_Id;
          Rm( Pkg + "View" );           // run specific VIEW
          if ( Return_Int ) {
            if ( Window_Id != Old_Win ) {
              Org_Win = Window_Id;
            }
          }
          break;

        case "LIST":
          Rm( Pkg + "List" );           // run specific LIST
          break;

        case "LOCK":
          if ( vcsDF ) {
            Switch_File( "?No-File?" );  // find empty window
            if ( File_Name != "?No-File?" ) {
              Switch_Window( Window_Count );
              Create_Window;
            }
          }
          Old_Win = Window_Id;
          Rm( Pkg + "Lock" );           // run specific LOCK
          if ( Return_Int ) {
            vcsChkMod = "L";
            VcsFileOut( vcsFName, 1 );
            vcsMsg = "Locked \"" + Truncate_Path( vcsFName ) + "\" out of \"" +
                vcsAFile + "\".";
          }
          if ( Return_Int || vcsDF ) {
            if ( Switch_Win_Id( Old_Win ) && ( File_Name == "?No-File?" ) ) {
              Delete_Window;
            }
          }
          break;

        case "BROWSE":
        case    "GET":
          if ( vcsDF ) {
            Switch_File( "?No-File?" );  // find empty window
            if ( File_Name != "?No-File?" ) {
              Switch_Window( Window_count );
              Create_Window;
            }
          }
          Old_Win = Window_Id;
          Rm( Pkg + "Get /C=" + Cmd );  // Run specific GET or BROWSE
          if ( Return_Int ) {
            if ( Cmd == "GET" ) {
              vcsMsg = "Modify \"";
              vcsChkMod = "M";
            }
            else {
              vcsMsg = "View \"";
              vcsChkMod = "V";
              Read_Only = True;
            }
            if ( !( ( vcsChkMod == "V" ) && ( !_BSAV ) ) ) {
              VcsFileOut( vcsFName, 1 );
            }
            vcsMsg = vcsMsg + Truncate_Path( vcsFName ) + "\" out of \"" +
                vcsAFile + "\".";
            Org_Win = Window_Id;
            if ( Org_Win != Old_Win ) {
              if ( Switch_Win_Id( Old_Win ) ) {
                Delete_Window;
                Switch_Win_Id( Org_Win );
              }
            }
            Window_Attr = 0;            // force to a standard window
            Load_File( vcsFName );
            if ( !Parse_Int( "/NO_EXT=", MParm_Str ) ) {
              Rm( "ExtSetup" );
            }
            VcsPopPos( 1 );
            Return_Int = True;
          }
          else {
            if ( vcsDF && Switch_Win_Id( Old_Win ) &&
                ( File_Name == "?No-File?" ) ) {
              Delete_Window;
            }
            Return_Int = False;
          }
          break;

        case    "PUT":
        case "UNLOCK":
          if ( !Out_Num ) {
            Out_Num = VcsFileOut( vcsFName, 0 );
          }
          Rm( Pkg + "Put /C=" + Cmd );  // run specific PUT or UNLOCK
          if ( Return_Int ) {             // no vcs_exec errors
            if ( vcsChkMod == "V" ) {
              vcsMsg = "\"" + Truncate_Path( vcsFName ) + "\" deleted.";
            }
            else if ( Cmd == "UNLOCK" ) {
              vcsMsg = "\"" + vcsAFile + "\" unlocked.";
            }
            else if ( vcsLibFnd ) {
              vcsMsg = "\"" + Truncate_Path( vcsFName ) +
                  "\" checked into \"" + vcsAFile + "\".";
            }
            else {
              vcsMsg = "\"" + vcsAFile + Truncate_Path( vcsFName ) +
                  "\" created.";
            }
            if ( Out_Num ) {
              Return_Int = Out_Num;
              Rm( "DeleteItem /G=!VCS_" + Pkg + "_OUT#/#=" + Str( Out_Cnt ) );
              Set_Global_Int( "!VCS_" + Pkg + "_COUNT!", --Out_Cnt );
            }
            Out_Num = False;
            if ( File_Name == "?No-File?" ) {
              if ( _RES_FILE && File_Exists( vcsFName ) ) {
                Error_Level = 0;
                Load_File( vcsFName );
                if ( !Error_Level ) {
                  Rm( "ExtSetup" );
                }
                Out_Num = True;
              }
              else if ( !Parse_Int( "/ND=", MParm_Str ) ) {
                Old_Win = Window_Id;
                Refresh = True;
                Rm( "DelWin" );
                Refresh = False;
                if ( Org_Win == Old_Win ) {
                  Org_Win = Window_Id;
                }
              }
            }
            VcsPopPos( Out_Num );
            Return_Int = True;
          }
          else {
            VcsPopPos( True );
            Return_Int = False;
          }
          break;
      }
    }
    if ( Return_Int == 0 ) {            // errors or cancelled
      if ( Error_Level != 0 ) {
        if ( Error_Level > 9000 ) {     // DOS VCS pkg errors
          Beep;
          Switch_Win_Id( Vcs_Win );
          Error_Level = 0;
          if ( vcsNameLoaded == False ) {
            Load_File( vcsName );
          }
          if ( Error_Level == 0 ) {
            Tof;
            VcsViewWinDlg( Pkg + " Error!", 100, 18, "BT_GN_109", hc_vcs_Error );
            Return_Int = False;
          }
          vcsMsg = "Error occurred during " + Pkg + " operation.";
        }
      }
      else {
        vcsMsg = Pkg + " " + Cmd + " command cancelled.";
      }
    }
//     else {
//       Set_File_Attr( vcsName, 0 );
//       Del_File( vcsName );
//     }
//     if ( Switch_Win_Id( Vcs_Win ) ) {
//       Delete_Window;
//     }
    Switch_Win_Id( Org_Win );
    if ( vcsDF == 0 ) {
      Rm( "FindWin" );
      Rm( "SetWindowNames" );
    }
    Refresh = Srf;
    Make_Message( vcsMsg );
    Error_Level = 0;
    vcsDF = False;                        // cleanup globals
    vcsLibFnd = False;
    vcsChgFlg = False;
    vcsNameLoaded = False;
    vcsMsg = "";
    vcsAFile = "";
    vcsFName = "";
    vcsChkMod = "";
    vcsPrjDir = "";
  }
}  // VcsCmds

macro VcsGetFile Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               15-Aug-93  00:45

  Name    : VcsGetFile

  Function: Called from the LDFILES macro if the file was not found.  This
            will search for a VCS log file, and ask the user if they wants to
            retrieve the latest revision.  If file name was not passed then
            the current file is used if it is loaded readonly, this allows
            extracting a file for modification after the file was loaded for
            viewing only.

  Syntax  : Rm( "VcsGetFile /F=str/C=Cmd" );

  Entry   : gint !vcsNoMenu -
            /F=str          - File name to extract.
            /C=str          - The desired command to execute ( ie GET or BROWSE ).

  Exit    : Return_Int
              True          - Successful extraction.
              False         - No File to extract.

  Globals : int !vcsNoMenu  -
            int !vcsSNCL    -
            int !vcsSNP     -

  Macros  : int VcsChkLib
            mac CheckEvents
            int VcsGetFileDlg
            mac VcsCmds

                Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

  Return_Int = False;
  if ( vcsNoPkg( ) == False ) {

    str Pkg[ 8 ] = vcsID;
    str OFile[ 128 ] = Parse_Str( "/F=", MParm_Str );
    str Cmd[ 8 ] = Shorten_Str( Parse_Str( "/C=", MParm_Str ) );
    str Title = "( " + Pkg + " )";
    str Msg;

    int LibPos;
    int No_Ext = ( Cmd == "" );
    int Sp;
    int Snp = vcsSNP;

    if ( OFile == "" ) {
      OFile = File_Name;
      Title += " File Already Loaded!";
    }
    else {
      Title += "File Not Found!";
    }
    if ( Return_Int = VcsChkLib( _LIB_PATH, OFile, -2 ) ) {
      LibPos = Return_Int;
      if ( Cmd == "" ) {
        Sp = ( ( Cmd = Caps( vcsGFM ) ) == "PROMPT" );
        if ( Sp ) {
          Msg = "Extract from \"" + vcsAFile + "\"? ";
          Return_Int = VcsGetFileDlg( Title, Msg, OFile );
          switch ( Return_Int ) {
            case 1:
              Cmd = "GET";
              break;
            case 3:
              Cmd = "BROWSE";
              break;
            case 4:
              Cmd = "LOCK";
              break;
            default:
              Return_Int = False;
          }
        }
        else {
          vcsSNP = !Sp;
        }
      }
      if ( Return_Int ) {
        vcsSNCL = vcsSNP;
        Rm( "VcsCmds /NO_EXT=" + Str( No_Ext ) + "/C=" + Cmd +
            "/A=" + vcsAFile + "/F=" + OFile + "/LPOS=" + str( LibPos ) );
        vcsSNP = Snp;
        vcsSNCL = False;
      }
    }
    else {
      if ( Cmd != "" ) {
        Make_Message( Pkg + " archive file not found." );
      }
    }
  }
}  // VcsGetFile

macro VcsCleanup Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               14-Mar-94  14:42

  Name    : VcsCleanup

  Function: Checks to see if there are any checked out files and presents
            a menu giving the user the option to check them back in.

  Syntax  : Rm( "VcsCleanup" );

  Entry   : /NX=1   NO Exit message flag.
            /CF=1   Current file ONLY.
            /ND=1   NO deletion of window being checked in.

  Exit    : Selected files written to Libraries.

                Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

  int NoXit = Parse_Int( "/NX=", MParm_Str );

  Make_Message( "" );

  if ( NoXit || _XIT_STAT ) {
    if ( vcsNoPkg( ) == False ) {

      str Pkg[ 8 ] = vcsId;
      str GStr = "!vcs_" + Pkg;

      int OutCnt = Global_Int( GStr + "_COUNT!" );
      int Cfo = Parse_Int( "/CF=", MParm_Str );

      if ( OutCnt == 0 ) {              // No files checked out?
        if ( NoXit && !Cfo ) {
          Make_Message( "No " + Pkg + " files checked out." );
        }
        Return_Int = True;
      }
      else if ( Cfo ) {                 // Current file only?

        str Cmd;
        str TStr;

        int NoDelWin = Parse_Int( "/ND=", MParm_Str );
        int OutNo = VcsFileOut( File_Name, False );
        int ROFile = vcsChkMod == "V";
        int Jx = 1;

        NoXit = True;
        Return_Int = True;
        if ( OutNo ) {
          Return_Int = id_vcu_Checkin;
          if ( !vcsSNP ) {
            TStr = SIf( ROFile, "Delete file?", "Check into archive?" );
            Return_Int = VcsCUSDlg( "( " + vcsId + " ) File Checked Out!", TStr,
                File_Name, ROFile );
          }
          if ( Return_Int ) {
            if ( Return_Int == id_vcu_Exit ) {
              Return_Int = True;
            }
            else {
              Cmd = "Put";
              if ( Return_Int == id_vcu_Unlock ) {
                Cmd = "UNLOCK";
              }
              TStr = Global_Str( GStr + "_OUT#" + Str( OutNo ) );
              while ( Jx = XPos( "\x7F", TStr, Jx ) ) {
                TStr = Str_Del( TStr, Jx, 1 );
                TStr = Str_Ins( "/", TStr, Jx );
              }
              Jx = XPos( "/FP=", TStr, 1 );
              TStr = Str_Del( TStr, Jx +  2, 1 );
              Jx = XPos( "/F=", TStr, Jx + 1 );
              TStr = Str_Del( TStr, Jx, 3 ) + "/ON=" + Str( OutNo );
              Rm( "VcsCmds /LPOS=-1/C=" + Cmd + "/ND=" + Str( NoDelWin ) +
                  TStr );
            }
          }
        }
      }
      else {                            // Show checked out file list
        Return_Int = VcsCULstDlg( "(" + Pkg + ") Files Checked Out!", NoXit,
            OutCnt );
        if ( Return_Int == 0 ) {
          NoXit = True;
        }
      }
    }
  }
  if ( NoXit == False ) {
    Rm( "VcsStatus" );
  }
}  // VcsCleanup

macro VcsDir Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               01-Apr-94  17:37

  Name    : VcsDir

  Function: Displays directory listing of VCS log files.  Allows user to
            select a file to be retrieved for modification, viewing only,
            or listing the version history.

  Syntax  : Rm( "VcsDir /C=cmd" );

  Entry   : /C=str          Command to execute ( ie GET, BROWSE or LIST ).
            /RC             Repeat command until <ESC>.

  Exit    : Runs VcsCmds with the selected file.

  Globals : int !vcsNoMenu - Disables mo
            str !vcsID     - Contains the name of the selected vcs package.

  Macros  : mac [vcsID]Dir
            mac FindWin
            mac SetWindowNames

                Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

  if ( vcsNoPkg( ) == False ) {

    int Srf = Refresh;

    Refresh = False;
    Rm( vcsID + "Dir " + MParm_Str );
    Rm( "FindWin" );
    if ( Window_Attr & 0x81 ) {         // system or hidden windows?
      Switch_Window( Window_Count );    // create a new visible window
      Create_Window;
    }
    Rm( "SetWindowNames" );
    Refresh = Srf;
  }
}  // VcsDir

int VcsShowWin(
        str FName = Parse_Str( "/F=", MParm_Str ),
        int Reload = XPos( "/R", MParm_Str, 1 )
    ) Trans2
{
/******************************************************************************
                               Multi-Edit Macro
                               19-Dec-94  22:30

  Name    : VcsShowWin

  Function: View the results of the previously run VCS command.

  Syntax  : Result = VcsShowWin( FName, Reload );

  Entry   :
  Exit    :
  Globals :
  Macros  :

                 Copyright (C) 1994 by Small Systems Support.
********************************************************************( ldh )***/

  int TRefresh = Refresh;
  int OrgWin = Window_Id;
  int Result = False;

  Refresh = False;
  if ( FName == "" ) {
    if ( Reload == 0 ) {
      if ( Switch_Win_Id( vcsSaveWin ) ) {
        Window_Attr &= 0xFE;
        Result = True;
      }
    }
  }
  else {
    FName = TranslateCmdLine( FName, "" );
    if ( !Switch_File( FName ) ) {
      Switch_Window( Window_Count );
      Create_Window;
    }
    Mark_Pos;
    Eof;
    if ( ( C_Line == 1 ) && ( C_Col == 1 ) ) {
      Reload = True;
    }
    Goto_Mark;
    Error_Level = 0;
    if ( Reload ) {
      Load_File( FName );
    }
    if ( Error_Level != 0 ) {
      Delete_Window;
      Switch_Win_Id( OrgWin );
    }
    else {
      Rm( "Select_Window" );
      Window_Attr = 0x80;
      Result = True;
    }
  }
  vcsSaveWin = OrgWin;
  Refresh = TRefresh;
  return ( Result );

}  // VcsShowWin

str VcsXlate(
        str Path = Return_Str,
        str FName = Parse_Str( "/F=", MParm_Str ),
        str LPath = Parse_Str( "/P=", MParm_Str )
    ) Trans2
{
/******************************************************************************
                               Multi-Edit Macro
                               24-Apr-93  13:41

  Name    : VcsXlate

  Function: Translates path ( Return_Str ) so that any occurrences of <LPATH>,
            <FILE>, <NAME>, <EXT>, <PATH>, <ME_PATH>, <USER_PATH>, <RCSDIR>,
            <OPATH>, <COMNT>, <SAPCMT> are expanded out.

  Syntax  : XCmd = VcsXlate( Path, FName, LPath );

  Entry   : Path  ( Return_Str )  - The command line to be translated.
            FName ( /F=str )      - The file name to use.
            LPath ( /P=str )      - The path to use for <LPATH>.

  Exit    : str ( Return_Str )    - The expanded command line.

  Calls   : XlateCmdLine

                Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

  int   Jx;
  str   T_Path;
  str   X_Mac;

  if ( LPath == "" ) {
    LPath = Get_Path( FName );
  }

  while ( Jx = XPos( "<LOOKUP>", Caps( Path ), 1 ) ) {
    Path = Str_Del( Path, Jx, 8 );
    Path = Str_Ins( VcsLookup( FName, "FD", "AD" ), Path, Jx );
  }

  while ( Jx = XPos( "<CFGFILE>", Caps( Path ), 1 ) ) {
    Path = Str_Del( Path, Jx, 9 );
    Path = Str_Ins( VcsCfgFile( FName, "ARCDIR" ), Path, Jx );
  }

  while ( Jx = XPos( "<LPATHX>", caps( path ), 1 ) ) {
    Path = Str_Del( Path, Jx, 8 );
    T_Path = Get_Path( LPath );
    if ( ( Svl( T_Path ) > 0 ) && ( Copy( T_Path, Svl( T_Path ), 1 ) ==
        "\\" ) ) {
      T_Path = Str_Del( T_Path, Svl( T_Path ), 1 );
    }
    Path = Str_Ins( T_Path, Path, Jx );
  }

  while ( Jx = XPos( "<LPATH>", Caps( Path ), 1 ) ) {
    Path = Str_Del( Path, Jx, 7 );
    Path = Str_Ins( Get_Path( LPath ), Path, Jx );
  }

  while ( Jx = XPos( "<OPATH>", Caps( Path ), 1 ) ) {
    Path = Str_Del( Path, Jx, 7 );
    T_Path = Get_Path( FName );
    if ( ( Svl( T_Path ) > 2 ) && ( Copy( T_Path, 2, 1 ) == ":" ) ) {
      T_Path = Str_Del( T_Path, 1, 2 );
    }
    Path = Str_Ins( T_Path, Path, Jx );
  }

  while ( Jx = XPos( "<COMNT>", Caps( Path ), 1 ) ) {
    Path = Str_Del( Path, Jx, 7 );
    Path = Str_Ins( vcsCmtFile, Path, Jx );
  }

  while ( Jx = XPos( "<%TMP>", Caps( Path ), 1 ) ) {
    Path = Str_Del( Path, Jx, 6 );
    T_Path = Get_Environment( "TMP" );
    if ( ( Svl( T_Path ) > 0 ) && ( Copy( T_Path, Svl( T_Path ), 1 ) !=
        "\\" ) ) {
      T_Path += "\\";
    }
    Path = Str_Ins( T_Path, Path, Jx );
  }

  while ( Jx = XPos( "<TMP_PATH>", Caps( Path ), 1 ) ) {
    Path = Str_Del( Path, Jx, 10 );
    T_Path = TempFileName( Truncate_Path( FName ) );
    Path = Str_Ins( Get_Path( T_Path ), Path, Jx );
  }

  while ( Jx = XPos( "<TMP_PATHX>", Caps( Path ), 1 ) ) {
    Path = Str_Del( Path, Jx, 11 );
    T_Path = Get_Path( TempFileName( Truncate_Path( FName ) ) );
    if ( ( Svl( T_Path ) > 0 ) && ( Copy( T_Path, Svl( T_Path ), 1 ) ==
        "\\" ) ) {
      T_Path = Str_Del( T_Path, Svl( T_Path ), 1 );
    }
    Path = Str_Ins( T_Path, Path, Jx );
  }

  Return_Str = Path;
  X_Mac = _U_XLAT_MAC;
  while ( X_Mac != "" ) {
    if ( ( Jx = XPos( ";", X_Mac, 1 ) ) == 0 ) {
      Jx = Svl( X_Mac ) + 1;
    }
    if ( Jx > 1 ) {
      Rm( Copy( X_Mac, 1, Jx - 1 ) + " /F=" + FName );
    }
    X_Mac = Str_Del( X_Mac, 1, Jx );
  }
  return ( TranslateCmdLine( Return_Str, FName ) );

}  // VcsXlate

macro VcsStatus Trans {
/******************************************************************************
                               Multi-Edit Macro
                               14-Mar-94  14:45

  Name    : VcsStatus
  Function: If the "Restore Status" box is checked in the configuration screen
            then the VCS system status is save in the file "VCS_STAT.ME".
  Syntax  : Rm( "VcsStatus" );
  Entry   : None.
  Exit    : VCS status saved in "VCS_STAT.ME" if restore status is on.
  Credit  : To Michael Crowe for defining and writing a similar function.

                Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

//+++keyword+++ "%n #%v, %d"
  str Rev_Id = "VCS.S #61, 04-Feb-95";

  int Jx;
  int Old_Window;
  int Vcs_Restore = _V_RESTORE;
  int Sbk = Backups;
  int Srf = Refresh;

  str TStr = Fix_Cmd_Param( Global_Str( "!Session_Name" ) );

  Backups = False;
  Undo_Stat = False;
  Refresh = False;
  Messages = False;
  if ( Vcs_Restore ) {
    if ( Svl( TStr ) ) {
      TStr = "0:" + TStr;
    }
    TStr = Make_Restr_Name( Vcs_Restore, TStr ) + ".VCS";
    Set_File_Attr( TStr, 0 );
    Del_File( TStr );
    Old_Window = Cur_Window;
    Switch_Window( Window_Count );
    Create_Window;
    File_Name = TStr;
    Put_Line( "@" + Rev_Id + "    " + FExpand( "" ) );
    Down;
    TStr = first_global( Jx );
    while ( TStr != "" ) {
      if ( XPos( "!VCS_", TStr, 1 ) ) {
        if ( !XPos( "KEY", TStr, 1 ) ) {
          if ( Jx == 1 ) {
            Put_Line( "/G_INT=" + TStr );
            Down;
            Put_Line( Str( Global_Int( TStr ) ) );
            Down;
          }
          else {
            Put_Line( "/G_STR=" + TStr );
            Down;
            Put_Line( convert_string( Global_Str( TStr ) ) );
            Down;
          }
        }
      }
      TStr = next_global( Jx );
    }
    if ( C_Line > 2 ) {
      Save_File;
    }
    Delete_Window;
    Switch_Window( Old_Window );
  }
  Refresh = Srf;
  Messages = True;
  Undo_Stat = True;
  Backups = Sbk;

}  // VcsStatus

macro VcsRestore Trans {
/******************************************************************************
                               Multi-Edit Macro
                               15-Mar-94  00:33

  Name    : VcsRestore
  Function: Restores status of the VCS system from the status file
            "VCS_STAT.ME".
  Syntax  : Rm( "VcsRestore" );
  Entry   : None.
  Exit    : The VCS system is restored to last defined state.
  Credit  : To Michael Crowe for defining and writing a similar function.

                Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

  int Vcs_Restore;

  vcsName = TempFileName( "VCS.TMP" );
  vcsCmtFile = TempFileName( "VCS2.TMP" );

  Rm( "VcsInit" );                      // Initialize vcs system

  if ( Vcs_Restore = _V_RESTORE ) {

    int Jx;
    int Srf = Refresh;
    int Ow = Cur_Window;

    str TStr = Fix_Cmd_Param( Global_Str( "!Session_Name" ) );

    Undo_Stat = False;
    Messages = False;
    Refresh = False;
    Switch_Window( Window_Count );
    Create_Window;
    File_Name = "!VcsRstWin!";
    Error_Level = 0;
    Working;
    if ( Svl( TStr ) ) {
      TStr = "0:" + TStr;
    }
    TStr = Make_Restr_Name( Vcs_Restore, TStr ) + ".VCS";
    if ( File_Exists( TStr ) ) {
      Load_File( TStr );
      if ( Error_Level == 0 ) {
//         Rm( "MessageBox /NW=1/M=Restoring VCS Status..." );
        Make_Message( "Restoring VCS Status..." );
        Down;
        while ( !At_Eof ) {
          TStr = Copy( Get_Line, 1, 7 );
          if ( TStr == "/G_INT=" ) {
            TStr = Copy( Get_Line, 8, 20 );
            Down;
            if ( val( Jx, Get_Line ) == 0 ) {
              set_global_int( TStr, Jx );
            }
          }
          else if ( TStr == "/G_STR=" ) {
            TStr = Copy( Get_Line, 8, 20 );
            Down;
            Set_Global_Str( TStr, Reconvert_String( Get_Line ) );
          }
          Down;
        }
        Make_Message( "VCS status restored." );
      }
    }
    Delete_Window;
    Switch_Window( Ow );
    Refresh = Srf;
    Messages = True;
    Undo_Stat = True;
  }
}  // VcsRestore

macro VcsInit Trans {
/******************************************************************************
                               Multi-Edit Macro
                               27-Mar-94  02:01

  Name    : VcsInit
  Function: Initializes the VCS System.
  Syntax  : Rm( "VcsInit" );
  Entry   : None.
  Exit    : The following global variables are setup:

              !VCSCFG - Contains the VCS ID and general options.
              !VCSID  - Contains the specific VCS options and commands.
              !VCSGFM - Contains the default Mode for the VcsGetFile macro.
              !VCSSNP - Set to 1 to disable most prompts.

              @FNF_LOAD_MACRO@  - Contains the macro to run when the macro
                                  LdFiles can not find a file.
              @ME_EXIT_MACRO@   - Contains the macro to run when exiting ME.
              @DEL_VERIFY_MACRO - Contains the macro to run when deleting a
                                  window.

                Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

  if ( vcsCfg == "" ) {

    str Vcs_Id;

    int Ow = Window_Id;
    int Srf = Refresh;
    int Jx;

    vcsDoLogin = False;               // Disable change user id menu
    Refresh = False;
//       Rm( "MessageBox /NW=1/M=Initializing VCS..." );
    Make_Message( "Initializing VCS..." );
    if ( !( Return_Int = LocateDbPage( _VCS_DB, "VCS.CFG", False ) ) ) {
      VcsUpdate( );
      Return_Int = LocateDbPage( _VCS_DB, "VCS.CFG", False );
    }
    if ( Return_Int ) {
      vcsCFG = Get_Line;

    #ifdef BETA
      Set_Global_Str( "!VCS", vcsCFG );
    #endif

      Vcs_Id = Shorten_Str( Parse_Str( "/VCS=", vcsCfg ) );
      Down;
      while ( !At_Eof && ( Cur_Char != "\f" ) ) {
        if ( Parse_Str( "\x7F" + "ID=", Get_Line ) == Vcs_Id ) {
          if ( !( Jx = XPos( " ", Vcs_Id, 1 ) ) ) {
            Jx = Svl( Vcs_Id ) + 1;
          }
          if ( Jx > 6 ) {
            Jx = 6;
          }
          Vcs_Id = Copy( Vcs_Id, 1, Jx - 1 );
          Set_Global_Str( "!" + Vcs_Id + "CFG", Get_Line );
          vcsID = Vcs_Id;
          break;
        }
        Down;
        Goto_Col( 1 );
      }
      vcsGFM = Parse_Str( "/GFM=", vcsCFG );
      vcsSNP = Parse_Int( "/SNP=", vcsCFG );
      if ( Global_Str( "@FNF_LOAD_MACRO@" ) == "" ) {
        Set_Global_Str( "@FNF_LOAD_MACRO@", "Vcs^VcsGetFile" );
        Set_Global_Str( "@ME_EXIT_MACRO@", Global_Str( "@ME_EXIT_MACRO@" ) +
            ";Vcs^VcsCleanup" );
        Set_Global_Str( "@DEL_VERIFY_MACRO", "Vcs^VcsCleanup /CF=1/ND=1/NX=1" );
      }
      Return_Str = "<MAC_PATH>;<ME_PATH>MAC";
      Rm( "PathSearch /F=" + Vcs_Id + ".MAC" );
      if ( Return_Int ) {
        Error_Level = 0;
        Rm( Vcs_Id + " /I" );          // Run specific _init
        if ( ( Vcs_Id != Copy( vcsVerStr, 1, Pos( " ", vcsVerStr ) - 1 ) ) ||
            Error_Level ) {
          Error_Level = 0;
          Return_Int = False;
        }
      }
      if ( !Return_Int ) {
        Make_Message( Vcs_Id + " support not available." );
        Set_Global_Str( "!" + Vcs_Id + "CFG", "" );
        Vcs_Id = "NONE";
        vcsID = "";
      }
      else {
        Make_Message( "VCS Initialization Successful." );
      }
      if ( File_Changed ) {
        Save_File;
      }
      Switch_Win_Id( Ow );
    }
    Refresh = Srf;
    vcsVerStr = "";
    vcsRevStr = "";
  }
}  // VcsInit

Macro VcsConfigure Trans No_Break {
/******************************************************************************
                               Multi-Edit Macro
                               15-Mar-94  00:34

  Name    : VcsConfigure
  Function: Displays a dialog box to allow configuring the VCS interface.
  Syntax  : Rm( "VcsConfigure" );
  Entry   : None.
  Exit    : VCS System Configured.

                Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

  if ( vcsName == "" ) {
    Rm( "VcsRestore" );
  }

  int Ow = Window_Id;
  int Jx;
  int Restore_Mode;
  int Srf = Refresh;
  int Gfm;

  str TStr = vcsCFG;
  str Pkg[ 12 ] = Parse_Str( "\x7FID=", Global_Str( "!" + vcsId + "Cfg" ) );
  str Gfm_Str = "PROMPTGET   BROWSELOCK  ";

  struct VcsCfgInfo CfgDat;

  Refresh = False;

  if ( Pkg == "" ) {
    Pkg = "NONE";
  }
  Gfm = ( ( XPos( Parse_Str( "/GFM=", TStr ), Gfm_Str, 1 ) - 1 ) / 6 ) + 1;
  CfgDat.Pkg = Pkg;
  CfgDat.Enable = vcsEnable;
  CfgDat.ShowCL = Parse_Int( "/SCL=", TStr );
  CfgDat.Prompt = Parse_Int( "/SNP=", TStr );
  CfgDat.BSave = Parse_Int( "/BS=", TStr );
  CfgDat.XitStat = Parse_Int( "/XIT=", TStr );
  CfgDat.FReload = Parse_Int( "/FRL=", TStr );
  CfgDat.CDifOn = Parse_Int( "/CD=", TStr );
  CfgDat.GFMode = Gfm;
  CfgDat.MLineCmt = Parse_Int( "/MLC=", TStr ) + 1;
  CfgDat.VRst = Parse_Int( "/VRS=", TStr ) + 1;
  CfgDat.WDMode = Parse_Int( "/UCD=", TStr ) + 1;
  CfgDat.XMac = _U_XLAT_MAC;

  if ( Return_Int = VcsCfgDlg( "VCS Configuration", CfgDat ) ) {
    vcsEnable = CfgDat.Enable;
    Set_Global_Int( "SETUP_CHANGED", Global_Int( "SETUP_CHANGED" ) | 0x01 );
    if ( LocateDbPage( _VCS_DB, "VCS.CFG", False ) ) {
      Gfm = ( ( CfgDat.GFMode - 1 ) * 6 ) + 1;
      Put_Line( "\fVCS.CFG /VCS=" + CfgDat.Pkg +
          "/SCL=" + Str( CfgDat.ShowCL ) +
          "/SNP=" + Str( CfgDat.Prompt ) +
          "/BS=" + Str( CfgDat.BSave ) +
          "/XIT=" + Str( CfgDat.XitStat ) +
          "/FRL=" + Str( CfgDat.FReload ) +
          "/CD=" + Str( CfgDat.CDifOn ) +
          "/GFM=" + Shorten_Str( Copy( Gfm_Str, Gfm, 6 ) ) +
          "/MLC=" + Str( CfgDat.MLineCmt - 1 ) +
          "/VRS=" + Str( CfgDat.VRst - 1 ) +
          "/UCD=" + Str( CfgDat.WDMode - 1 ) +
          "/UXM=" + CfgDat.XMac );
      vcsCFG = "";
    }
    Rm( "VcsInit" );
    Switch_Win_Id( Ow );
  }
  Refresh = Srf;

}  // VcsConfigure

macro VcsIActive Trans {
/******************************************************************************
                               Multi-Edit Macro
                               27-Mar-94  02:01

  Name    : VcsIActive

  Function: Runs the selected vcs specific "run interactive" macro.

  Syntax  : Rm( "VcsIActive" );

  Entry   : None.

  Exit    : None.

               Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

  if ( vcsNoIAct( ) == False ) {
    Rm( vcsID + "IActive" );
  }
}  // VcsIActive

macro VcsLogin Trans {
/******************************************************************************
                               Multi-Edit Macro
                               27-Mar-94  02:01

  Name    : VcsLogin
  Function: Runs the selected vcs specific login macro.
  Syntax  : Rm( "VcsLogin /CU" );
  Entry   : /CU   - Force a change user ID.
  Exit    : None.

                 Copyright (C) 1994 by Small Systems Support.
********************************************************************( ldh )***/

  if ( vcsNoLogin( ) == False ) {
    Rm( vcsID + "Login " + MParm_Str );
  }
}  // VcsLogin

macro VcsAdminPrj Trans {
/******************************************************************************
                               Multi-Edit Macro
                               07-Apr-94  19:39

  Name    : VcsAdminPrj

  Function: Runs the vcsID specific administer project macro to
            create/delete/edit the user <LOOKUP> database.

  Syntax  : Rm( "VcsAdminPrj" );

  Entry   : gint !vcsNoMenu - Run the specific admin_prj if False.
            gstr !vcsID     - The name of the currently selected vcs package.

  Exit    : none.

  Globals : int !vcsNoMenu - Global ( True ) to disable most of the menu items.
            str !vcsID     - The name of the currently selected vcs package.

  Macros  : mac [!vcsID]AdminPrj

                 Copyright (C) 1994 by Small Systems Support.
********************************************************************( ldh )***/

  if ( vcsNoPkg( ) == False ) {
    Set_Global_Str( "WALKD_HISTORY0", FExpand( "" ) );
    Rm( vcsID + "AdminPrj" );
    Set_Global_Str( "WALKD_HISTORY0", "" );
  }
}  // VcsAdminPrj

str VcsGetFName( str LFile ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               22-Nov-93  22:33

  Name    : VcsGetFName

  Function: Runs the selected vcs specific get_fname macro to return the name
            of the workfile derived from the passed archive file name.

  Syntax  : FName_Str = VcsGetFName( LFile );

  Entry   : gstr !vcsID - The name of the currently selected vcs package.
            str  lfile  - archive file name

  Exit    : str         - The work_file name

  Globals : str !vcsID   - The name of the currently selected vcs package.
            str !vcsRStr - The value returned from the called macro

  Macros  : str [!vcsID]GetFname

                Copyright (C) 1993-94 by Small Systems Support.
********************************************************************( ldh )***/

  str Cmd = vcsID + "GetFName /P=" + LFile,
      RetVal;

  Make_Message( "Checking for file..." );
  Rm( Cmd );
  RetVal = vcsRStr;
  vcsRStr = "";
  return ( RetVal );

}  // VcsGetFName

int VcsChkLib( str Path, str FName, int Pm ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               22-Nov-93  22:33

  Name    : VcsChkLib

  Function: Run the !vcsID specific chk_lib macro to search "Path" for the
            archive for "FName" based upon the Path mode "pm".

  Syntax  : LibFnd = VcsChkLib( Path, FName, Pm );

  Entry   : gstr !vcsID - The name of the currently selected vcs package.
            str  Path   - Contains the search Path.
            str  FName  - The filename for which to find archive.
            int  Pm     - Path Mode.
              -2        - Check for and return archive file only.
              -1        - Check for and return archive file,
                            iff no file return 1st lib Path.
               0        - Return full archive Path.
              +#        - Return # directory from archive Path.

  Exit    : int
              #                 - File was found in # Path.
                gstr !vcsAFile  - The found archive filename or Path.
              0                 - File NOT found.
                gstr !vcsAFile  - The archive Path based upon pm.
                                   ( Not set if pm == -2 ).

  Globals : str !vcsID    - The name of the currently selected vcs package.
            int !vcsRInt  - The value returned from the called macro.
            str !vcsAFile - The found archive filename or Path.

  Macros  : int [!vcsID]ChkLib

                Copyright (C) 1993-94 by Small Systems Support.
********************************************************************( ldh )***/

  int RetVal;

  str Cmd = vcsID + "ChkLib /P=" + Path + "/F=" + FName + "/M=" + Str( Pm );

  Rm( Cmd );
  RetVal = vcsRInt;
  vcsRInt = 0;
  return ( RetVal );

}  // VcsChkLib

str VcsLookup( str FName, str Field1, str Field2 ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               08-Apr-94  23:09

  Name    : VcsLookup
  Function:
  Syntax  :
  Entry   :
  Exit    :
  Globals :
  Macros  :

                 Copyright (C) 1994 by Small Systems Support.
********************************************************************( ldh )***/

  str Cmd = vcsID + "Lookup /F=" + FName + "/F1=" + Field1 + "/F2=" + Field2;
  str RetVal;

  Rm( Cmd );
  RetVal = vcsRStr;
  vcsRStr = "";
  return ( RetVal );

}  // VcsLookup

str VcsCfgFile( str FName, str Param ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               20-Dec-94  00:01

  Name    : VcsCfgFile

  Function: Parse a specific VCS package config file for Param and return its
            value.

  Syntax  : Path = VcsCfgFile( FName, "ARCDIR" );

  Entry   : str FName   - The file name used to locate specific CFG file
            str Param   - The parameter to return the value for.
                          Note: currently only the following are supported:
                          "ARCDIR" - will return the archive path for specified
                                      file FName

                          "ARCEXT"  - will return the library extension pattern
                          "USER"    - will return the current user
                          "WORKDIR" - will return the working directory for
                                      specified file FName

  Exit    : str     - Found parameter or "" when parameter not found

  Globals : str !vcsRStr

  Macros  : str [!vcsID]CfgFile

                 Copyright (C) 1994 by Small Systems Support.
********************************************************************( ldh )***/

  str Cmd = vcsID + "CfgFile /F=" + FName + "/P=" + Param;
  str RetVal;

  Rm( Cmd );
  RetVal = vcsRStr;
  vcsRStr = "";
  return ( RetVal );

}  // VcsCfgFile

int VcsGetPath( str Path, str FName, str Ext, int Pm ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               16-Aug-93  00:20

  Name    : VcsGetPath

  Function: Search for an archive file in a given Path or return the archive
            Path.

  Syntax  : LibFnd = VcsGetPath( Path, FName, Ext, Pm );

  Entry   : str Path  - contains the search Path. ( ie ";C:\TLIB\ME\;C:\TLIB\VCS" )
            stt FName - the filename for which to find archive.
            str ext   - the VCS package archive extension
            int pm    - Path Mode
              -2      - Check for and return archive file only.
              -1      - Check for and return archive file,
                          iff no file return 1st lib Path.
               0      - Return full archive Path.
              +#      - Return # directory from archive Path.

  Exit    : int
              #                 - File was found in # Path.
                gstr !vcsAFile  - The found archive file name or Path.
              0                 - File NOT found.
                gstr !vcsAFile  - The archive Path based upon pm.
                                    ( Not set if pm == -2 ).


  Globals : str !vcsAFile - The found archive filename or Path.

  Macros  : VcsXlate

                Copyright (C) 1993-94 by Small Systems Support.
********************************************************************( ldh )***/

  str FPath[ 128 ] = "",
      LPath[ 128 ];

  int Jx,
      Jy = 0,
      Cnt = 0,
      RetVal = False;

  Path = VcsXlate( Path, FName, "" );
  FName = Truncate_Path( Truncate_Extension( FName ) ) + "." + Ext;
  if ( Pm ) {
    while ( True ) {
      if ( Jy > Svl( Path ) ) {
        if ( Pm != -2 ) {
          vcsAFile = LPath;
        }
        break;
      }
      Jx = XPos( ";", Path, Jy + 1 );
      if ( Jx == 0 ) {
        Jx = Svl( Path ) + 1;
      }
      FPath = Copy( Path, Jy + 1, Jx - Jy - 1 );
      if ( ( Svl( Path ) > 0 ) && ( Copy( FPath, Svl( FPath ), 1 ) != "\\" ) ) {
        FPath += "\\";
      }
      Jy = Jx;
      if ( Pm == ++Cnt ) {
        vcsAFile = FPath;
        RetVal = Cnt;
        break;
      }
      if ( Pm < 0 ) {
        if ( File_Exists( FPath + FName ) ) {
          vcsAFile = FExpand( FPath + FName );
          RetVal = Cnt;
          break;
        }
      }
      if ( Cnt == 1 ) {
        LPath = FPath;
      }
    }
  }
  else {
    vcsAFile = Path;
  }
  return ( RetVal );

}  // VcsGetPath

int VcsFileOut( str FName, int Put ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               22-Nov-93  22:27

  Name    : VcsFileOut

  Function: Checks the global checkout history for file "FName" and if found
            ( put == 0 ) sets globals vcsAFile and vcsChkMod.
            ( put != 0 ) updates global checkout history.

  Syntax  : Int_Var = VcsFileOut( FName, Put );

  Entry   : str FName - the filename for which to find archive.
            int put   - put mode
              0       - update vcsAFile/vcsChkMod from history globals.
              1       - put vcsAFile/vcsChkMod into history globals.

  Exit    : int ( put == 0 )
              0                 - FName not found.
              #                 - FName found at history item #.
                gstr !vcsAFile  - Set to archive Path and filename.
                gstr !vcsChkMod - Set to checkout mode.

            int ( put != 0 )
              #                 - FName libray history stored at history item #

  Globals : str !vcsAFile  - Archive Path and filename.
            str !vcsChkMod - Archive file checkout mode.

  Macros  : none.

                Copyright (C) 1993-94 by Small Systems Support.
********************************************************************( ldh )***/

  str Pkg[ 8 ] = vcsID;
  str OStr = "!VCS_" + Pkg + "_OUT#";
  str TStr;

  int RetVal = 0;
  int Jx = 1;
  int Out_Cnt = Global_Int( "!VCS_" + Pkg + "_COUNT!" ) + 1;

  while ( Jx < Out_Cnt ) {
    TStr = Global_Str( OStr + Str( Jx ) );
    TStr = Parse_Str( "\x7F" + "FP=", TStr ) + Parse_Str( "\x7F" + "F=", TStr );
    if ( FName == TStr ) {
      break;
    }
    ++Jx;
  }
  if ( Put ) {
    if ( Parse_Str( "\x7F" + "CM=", Global_Str( OStr + Str( Jx ) ) ) != "M" ) {
      Set_Global_Str( OStr + Str( Jx ), "\x7F" + "CM=" + vcsChkMod +
          "\x7F" + "FP=" + Get_Path( FName ) +
          "\x7F" + "F=" + Truncate_Path( FName ) +
          "\x7F" + "A=" + vcsAFile +
          "\x7F" + "WD=" + Get_Path( FName ) +
          "\x7F" + "PD=" + vcsPrjDir );
    }
    if ( Jx == Out_Cnt ) {
      Set_Global_Int( "!VCS_" + Pkg + "_COUNT!", Out_Cnt );
    }
    RetVal = Jx;
  }
  else if ( Jx < Out_Cnt ) {
    TStr = Global_Str( OStr + Str( Jx ) );
    vcsAFile = Parse_Str( "\x7F" + "A=", TStr );
    vcsPrjDir = Parse_Str( "\x7F" + "PD=", TStr );
    vcsChkMod = Parse_Str( "\x7F" + "CM=", TStr );
    RetVal = Jx;
  }
  return ( RetVal );

}  // VcsFileOut

int VcsGetLib( str FName ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               29-Mar-94  23:40

  Name    : VcsGetLib

  Function: Get the archive Path and filename for the file "FName".  If it
            doesn't exist in the checkout list and the "No Prompts" options is
            not enabled then a dialog prompting for archive Path is given and
            then checked to see if the archive exists.

  Syntax  : LibFnd = VcsGetLib( FName );

  Entry   : str   FName     - the filename to archive information for.
            gint  !vcsSNP    - global_int used to disable prompts when set.
            gstr  !vcsDlgMsg - global_str with prompt dialog title.

  Exit    : int
              True                - Archive exists.
                Error_Level       - Set to 0.
                gstr !vcsChkMod   - Set to checkout mode if found else cleared.
                gstr !vcsAFile    - Set to archvie path\filename.
              False               - Archive does not exists or <ESC> at prompt.
                Error_Level       - 0 except when <ESC> hit
                                    then Error_Level = 9000.
                gstr !vcsAFile    - Set to selected archive Path
                                    if prompt accepted.

            gstr !vcsDlgMsg        - cleared.

  Globals : int !vcsSNP     - Show No Prompts option.  True no prompt.
            str !vcsDlgMsg  - Prompt for archive Path message.
            str !vcsChkMod  - Archive file checkout mode.
            str !vcsAFile   - The archive Path and filename.

  Macros  : int VcsFileOut
            int VcsGetPath
            int VcsChkLib
            mac VcsEditStrDlg

                Copyright (C) 1993-94 by Small Systems Support.
********************************************************************( ldh )***/

  int Result;

  str Path;

  Error_Level = 0;
  if ( !( Result = VcsFileOut( FName, 0 ) ) && !vcsSNP ) {
    VcsGetPath( _LIB_PATH, FName, "", 1 );
    Path = vcsAFile;
    Result = VcsEditStrDlg( vcsDlgMsg, Path, False );
    if ( Result ) {
      if ( ( Svl( Path ) > 0 ) && ( Copy( Path, Svl( Path ), 1 ) != "\\" ) ) {
        Path += "\\";
      }
      if ( Result = VcsChkLib( Path, FName, -2 ) ) {
        vcsChkMod = "";
      }
      Error_Level = 0;
    }
    else {
      Error_Level = 9000;
    }
  }
  vcsDlgMsg = "";
  return ( Result );

}  // VcsGetLib

void VcsPushPos( ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               19-Mar-94  02:14

  Name    : VcsPushPos

  Function:

  Syntax  :

  Entry   :

  Exit    :

  Globals :

  Macros  :

                Copyright (C) 1993-94 by Small Systems Support.
********************************************************************( ldh )***/

  str GName = "@vcsFP_",
      FName = File_Name;

  int Ow = Window_Id,
      Cnt = Link_Stat + 1,
      Srf = Refresh;

  Refresh = False;
  Set_Global_Int( GName + "#", Cnt );
  Set_Global_Str( GName + Str( Cnt ), "/W=" + Str( Window_Id ) +
      "/R=" + Str( C_Row ) + "/L=" + Str( C_Line ) + "/C=" + Str( C_Col ) );
  while ( --Cnt ) {
    while ( True ) {
      Switch_Window( Cur_Window + 1 );
      if ( ( File_Name == FName ) && Link_Stat ) {
        break;
      }
    }
    Set_Global_Str( GName + Str( Cnt ), "/W=" + Str( Window_Id )
        + "/R=" + Str( C_Row ) + "/L=" + Str( C_Line ) + "/C=" + Str( C_Col ) );
    Erase_Window;
  }
  Switch_Win_Id( Ow );
  Refresh = Srf;

}  // VcsPushPos

void VcsPopPos( int Restore = Pos( "/R", MParm_Str ) ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               19-Mar-94  02:14

  Name    : VcsPopPos

  Function:

  Syntax  :

  Entry   :

  Exit    :

  Globals :

  Macros  :

                Copyright (C) 1993-94 by Small Systems Support.
********************************************************************( ldh )***/

  str GName = "@vcsFP_",
      TStr[ 128 ];

  int Cnt = Global_Int( GName + "#" ),
      Ow = Window_Id,
      LRow,
      Lw,
      Srf = Refresh;

  if ( Cnt ) {
    Refresh = False;
    TStr = Global_Str( GName + Str( Cnt ) );
    Set_Global_Str( GName + Str( Cnt ), "" );
    if ( Restore ) {
      LRow = Parse_Int( "/R=", TStr );
      while ( C_Row < LRow ) {
        Down;
      }
      while ( C_Row > LRow ) {
        Up;
      }
      Goto_Line( Parse_Int( "/L=", TStr ) );
      Goto_Col( Parse_Int( "/C=", TStr ) );
      Lw = Cur_Window;
      while ( --Cnt ) {
        TStr = Global_Str( GName + Str( Cnt ) );
        Set_Global_Str( GName + Str( Cnt ), "" );
        if ( Switch_Win_Id( Parse_Int( "/W=", TStr ) ) ) {
          Link_Window( Lw );
          LRow = Parse_Int( "/R=", TStr );
          while ( C_Row < LRow ) {
            Down;
          }
          while ( C_Row > LRow ) {
            Up;
          }
          Goto_Line( Parse_Int( "/L=", TStr ) );
          Goto_Col( Parse_Int( "/C=", TStr ) );
        }
      }
    }
    else {
      while ( --Cnt ) {
        TStr = Global_Str( GName + Str( Cnt ) );
        Set_Global_Str( GName + Str( Cnt ), "" );
        if ( Switch_Win_Id( Parse_Int( "/W=", TStr ) ) ) {
          Delete_Window;
        }
      }
    }
    Set_Global_Int( GName + "#", 0 );
    Switch_Win_Id( Ow );
    Refresh = Srf;
  }
}  // VcsPopPos

int VcsGetCmt( int Prompt, int Keep ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               22-Nov-93  22:33

  Name    : VcsGetCmt

  Function:

  Syntax  :

  Entry   :

  Exit    :

  Globals :

  Macros  :

                Copyright (C) 1993-94 by Small Systems Support.
********************************************************************( ldh )***/

  int Org_Win = Window_Id;
  int Result = True;

  str TStr;

  vcsChgFlg = False;
  if ( ( _CHG_FSTART != "" ) && ( _CHG_FEND != "" ) ) {
    Tof;
    Goto_Col( 1 );
    if ( Find_Text( _CHG_FSTART, 1, 0 ) ) {
      Block_Begin;
      Right;
      if ( vcsChgFlg = Find_Text( _CHG_FEND, 25, 0 ) ) {
        Block_End;
        if ( !_CHG_SUPPORT ) {
          Rm( "Cut /B=1" );
        }
        else {
          Block_Off;
        }
      }
    }
  }
  if ( !( _CHG_SUPPORT && vcsChgFlg ) ) {
    Switch_Window( Window_Count );
    Create_Window;
    File_Name = vcsCmtFile;
    if ( vcsChgFlg ) {
      Rm( "Paste /B=1/O=1" );
      Tof;
      Del_Line;
      Eof;
      Del_Line;
    }
    else if ( File_Exists( File_Name ) ) {
      Load_File( File_Name );
    }
    TStr = Get_Line;
    if ( Prompt ) {
      if ( _MLC ) {
        Result = VcsEditStrDlg( vcsDlgMsg, TStr, _MLC );
      }
      else {
        Return_Str = File_Name;
        Erase_Window;
        File_Name = Return_Str;
        Result = VcsEditStrDlg( vcsDlgMsg, TStr, _MLC );
        Text( TStr );
      }
    }
    if ( Result ) {
      Set_Global_Str( "@VCS_MESSAGE!", TStr );
      Save_File;
      if ( Keep == False ) {
        Delete_Window;
      }
      if ( Switch_Win_Id( Org_Win ) ) {
        if ( vcsChgFlg && Block_Stat ) {
          Delete_Block;
        }
        if ( File_Changed ) {
          Save_File;
        }
      }
    }
    else {
      vcsChgFlg = False;
      Delete_Window;
      if ( Switch_Win_Id( Org_Win ) ) {
        Block_Off;
      }
    }
  }
  vcsDlgMsg = "";
  return ( Result );

}  // VcsGetCmt

void VcsPutCmt( int Prompt ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               03-Nov-94  08:59

  Name    :

  Function:

  Syntax  :

  Entry   :

  Exit    :

  Globals :

  Macros  :

                  Copyright (C) 1994 by Small Systems Support
********************************************************************( ldh )***/

  Tof;
  NewClipboardData = False;
  Rm( "Paste /B=1/O=1" );
  if ( File_Changed ) {
    Save_File;
  }
}

macro VcsXMacro Trans {
/******************************************************************************
                               Multi-Edit Macro
                               12-May-93  23:10

  Name    : VcsXMacro
  Function: Translates user defined aliases. <PRJ> and <SUBSYS> are expanded
            out.
  Syntax  : Rm( "VcsXMacro /F=str/P=str" );
  Entry   : /F=str  The file name to use.
            /P=str  The Path to use for <LPATH>.
  Exit    : Return_Str  The expanded command line.
  Calls   : None

                Copyright (C) 1993-94 by Small Systems Support.
********************************************************************( ldh )***/

/*
  If the /F=filename is as follows  D:\PRJ\SUBSYS\FILENAME.EXT the translation
  will be as follows.

  <PRJ> = \PRJ\
  <SUBSYS> = \SUBSYS\

  Now if the Libary Path is as follows  Y:\PROJ<PRJ>REPO<SUBSYS> it will be
  translated to the following.

  Y:\PROJ\PRJ\REPO\SUBSYS\.
*/

  str FName[ 128 ],
      LPath[ 128 ],
      T_Path;

  int Jx,
      Offset;

  FName = Parse_Str( "/F=", MParm_Str );
  LPath = Parse_Str( "/P=", MParm_Str );
  if ( LPath == "" ) {
    LPath = Get_Path( FName );
  }
  while ( Jx = XPos( "<PRJ>", Caps( Return_Str ), 1 ) ) {
    Return_Str = Str_Del( Return_Str, Jx, 5 );
    T_Path = Get_Path( FName );
    if ( ( Svl( T_Path ) > 2 ) && ( Copy( T_Path, 2, 1 ) == ":" ) ) {
      T_Path = Str_Del( T_Path, 1, 2 );
    }
    Offset = XPos( "\\", T_Path, 2 );
    T_Path = Str_Del( T_Path, Offset + 1, Svl( T_Path ) - Offset );
    Return_Str = Str_Ins( T_Path, Return_Str, Jx );
  }

  while ( Jx = XPos( "<SUBSYS>", Caps( Return_Str ), 1 ) ) {
    Return_Str = Str_Del( Return_Str, Jx, 8 );
    T_Path = Get_Path( FName );
    if ( ( Svl( T_Path ) > 2 ) && ( Copy( T_Path, 2, 1 ) == ":" ) ) {
      T_Path = Str_Del( T_Path, 1, 2 );
    }
    T_Path = Str_Del( T_Path, 1, XPos( "\\", T_Path, 2 ) - 1 );
    Return_Str = Str_Ins( T_Path, Return_Str, Jx );
  }
}  // VcsXMacro

int VcsChkVer( str Vers ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               13-Apr-94  02:41

  Name    : VcsChkVer

  Function: Returns True if the passed version number "vers" matches the vcs
            macro version number.

  Syntax  : Int_Val = VcsChkVer( Vers );

  Entry   : str vers - Version number string.

  Exit    : int - True when "vers" matches the vcs version.
                  False when "vers" dosen't match the vcs version.

  Globals : none.

  Macros  : none.

                 Copyright (C) 1994 by Small Systems Support.
********************************************************************( ldh )***/

  int Jx,
      Jy;

  str VVers,
      NVers;

  Jx = XPos( "(", _VCS_VERSION, 1 );
  Jy = XPos( ")", _VCS_VERSION, Jx );
  Vvers = Copy( _VCS_VERSION, Jx + 1, Jy - Jx - 1 );
  if ( ( ( Jy = Svl( VVers ) ) > 1 ) && ( Copy( VVers, Jy, 1 ) > "9" ) ) {
    VVers = Copy( VVers, 1, Jy - 1 );
  }
  Jx = XPos( "(", Vers, 1 );
  Jy = XPos( ")", Vers, Jx );
  NVers = Copy( Vers, Jx + 1, Jy - Jx - 1 );
  if ( ( ( Jy = Svl( NVers ) ) > 1 ) && ( Copy( NVers, Jy, 1 ) > "9" ) ) {
    NVers = Copy( NVers, 1, Jy - 1 );
  }
  return ( VVers == NVers );

}  // VcsChkVer

int IIf( int Expr, int Texpr, int Fexpr ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               22-Nov-93  22:33

  Name    : Iif

  Function: Evaluate an int expression "expr" and return int "texpr" when True,
            else return int "fexpr".

  Syntax  : Int_Val = Iif( Expr, Texpr, Fexpr );

  Entry   : int Expr  - An int expression evaluated to either T/F.
            int Texpr - Integer returned when "expr" evaluates True.
            int Fexpr - Integer returned when "expr" evaluates False.

  Exit    : int - Integer based upon the evaluation of "expr".

  Globals : none.

  Macros  : none.

                Copyright (C) 1993-94 by Small Systems Support.
********************************************************************( ldh )***/

  if ( Expr ) {
    return ( Texpr );
  }
  else {
    return ( Fexpr );
  }
}  // Iif

str SIf( int Expr, str Texpr, str Fexpr ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               22-Nov-93  22:33

  Name    : SIf

  Function: Evaluate an int expression "expr" and return str "texpr" when True,
            else return str "fexpr".

  Syntax  : Str_Val = SIf( Expr, "TVAL", "FVAL" );

  Entry   : int Expr  - An int expression evaluated to either T/F.
            str Texpr - String returned when "expr" evaluats True.
            str Fexpr - String returned when "expr" evaluates False.

  Exit    : str - String based upon the evaluation of "expr"

  Globals : none.

  Macros  : none.

                Copyright (C) 1993-94 by Small Systems Support.
********************************************************************( ldh )***/

  if ( Expr ) {
    return ( Texpr );
  }
  else {
    return ( Fexpr );
  }
}  // SIf

void GetDrives( ) {
/******************************************************************************
                               Multi-Edit Macro
                               29-Sep-94  12:38

  Name    :
  Function:
  Syntax  :
  Entry   :
  Exit    :
  Globals :
  Macros  :

                  Copyright (C) 1994 by Small Systems Support
********************************************************************( ldh )***/

  int Jy;
  int Jx;
  int Cnt;
  str DriveStr;

  R_AX = 0x1900;
  Intr( 0x21 );
  Jy = R_AX & 0x00FF;
  R_DX = Jy;
  R_AX = 0x0E00;
  Intr( 0x21 );
  Jx = 0;
  Cnt = R_AX & 0x00FF;
  DriveStr = "";
  while ( Jx < Cnt ) {
    R_DX = Jx;
    R_AX = 0x0E00;
    Intr( 0x21 );
    R_AX = 0x1900;
    Intr( 0x21 );
    if ( ( R_AX & 0x00FF ) == Jx ) {
      DriveStr += Char( Jx + 0x41 );
		}
    ++Jx;
	}
  R_DX = Jy;
	R_AX = $0E00;
	Intr($21);

  Set_Global_Str( "&Drives", DriveStr );
}  // GetDrives

void VcsUpdate( ) {
/******************************************************************************
                               Multi-Edit Macro
                               01-Nov-94  16:37

  Name    : VcsUpdate

  Function: Used to update the VCS support files while maintaining the user's
            configurations changes. The SourceSafe support has been changed to
            be known as SSAFE and will be changed in VCS.DB and all of the
            *.VCS restore files. Also the data in VCS.DB will be moved into
            MECONFIG.DB.

  Syntax  : VcsUpdate( );

  Entry   : None.

  Exit    : None.

  Globals :

  Macros  :

                  Copyright (C) 1994 by Small Systems Support
********************************************************************( ldh )***/

  int Srf = Refresh;
  int Sbk = Backups;
  int Jx;
  int CfgWin = Window_Id;
  int DatWin;

  str TStr[2048];
  str FStr;

  Refresh = False;
  if ( LocateDbPage( "VCS", "VCS.CFG", False ) ) {

    // Update VCS.DB
    if ( Find_Text( "/VCS=SS/", 1, 0 ) ) {
      Replace( "/VCS=SSAFE/");
    }
    Down;
    FStr = "\x7F" + "ID=SS" + "\x7F";
    if ( Find_Text( "\f|(" + FStr + ")", 0, _RegExp ) ) {
      if ( Found_Str != "\f" ) {
        TStr = Get_Line;
        if ( Jx = XPos( FStr, TStr, 1 ) ) {
          TStr = Str_Ins( "AFE", TStr, Jx + 6 );
          while ( Jx = XPos( "<LPATH>", TStr, Jx ) ) {
            TStr = Str_Ins( "\"", TStr, Jx );
            Jx += 8;
            while ( Copy( TStr, Jx, 1 ) == "<" ) {
              Jx = XPos( ">", TStr, Jx ) + 1;
              if ( Copy( TStr, Jx, 1 ) == "." ) {
                ++Jx;
              }
            }
            TStr = Str_Ins( "\"", TStr, Jx );
            Put_Line( TStr );
          }
        }
      }
    }
    if ( Find_Text( "\fSS.VAD", 0, 0 ) ) {
      Replace( "\fSSAFE.VAD" );
    }

    // Copy VCS.DB into MECONFIG.DB
    Tof;
    Block_Begin;
    Eof;
    DatWin = Cur_Window;
    Switch_Win_Id( CfgWin );
    if ( XPos( "MECONFIG.DB", File_Name, 1 ) ) {
      Eof;
      Down;
      Window_Copy( DatWin );
      Block_Off;
      Backups = 1;
      Save_File;
      Backups = Sbk;
    }
    Switch_Window( DatWin );
    Delete_Window;

    // Update *.VCS restore files
    TStr = TranslateCmdLine( Global_Str( "@RESTORE_PATH" ), "" );
    if ( TStr != "" ) {
      Switch_Window( Window_Count );
      Create_Window;
      if ( Copy( TStr, Svl( TStr ), 1 ) != "\\" ) {
        TStr += "\\";
      }
      File_Search_Attr = 0x37;
      Jx = First_File( TStr + "*.VCS" );
      while ( Jx == 0 ) {
        if ( ( Last_File_Attr & 0x10 ) == 0 ) {
          Load_File( TStr + Last_File_Name );
          if ( Error_Level == 0 ) {
            while ( Find_Text( "_SS_", 0, 0 ) ) {
              Replace( "_SSAFE_" );
            }
            if ( File_Changed ) {
              Save_File;
            }
          }
          Error_Level = 0;
        }
        Jx = Next_File;
      }
      Delete_Window;
    }
  }
  Refresh = Srf;

}  // VcsUpdate