//+++keyword+++ "@(#)%v %n, %f, %w"
// "@(#)14 TLIB.S, 04-Feb-95,01:37:24, LDH"

macro_file TLIB;
/******************************************************************************
                             Multi-Edit Macro File
                               12-Aug-94  23:31

  This macro is the specific interface code for the TLIB package from Burton
  Systems Software.

                Copyright (C) 1993-94 by Small Systems Support.
********************************************************************( ldh )***/

#include DIALOG.SH
#include WINEXEC.SH
#include IDEXE.SH
#include METOOLS.SH
#include DBTOOLS.SH
#include DB.SH
#include VCS.SH

#ifdef   _DEBUG_
  #include DBUG.SH                      // Dbug macros
  #include SPRINTF.SH
#endif

#ifdef  _BETA_
  #define _TLIB_VER  "7.00p(0.09b)"
#else
  #define _TLIB_VER  "7.00p(0.09b)"
#endif

prototype Tlib {
  int  TlibExec( str CmdLine, int Show_Win, int Chg_Dir );
  str  TlibXlate( str Path, str FName, str LFile );
  str  TlibExt( str FName, int Lok );
  int  TlibChkLib( str Path, str FName, int Pm );
  str  TlibGetFName( str LibFile );
  int  TlibChkLock( );
  str  TlibLookup( str FName, str Field1, str Field2 );
  str  TlibCfgFile( str FName, str Param );
  void TlibParseErr( );
  str  TLibGetUser( );
}

global {
  str tlibCfg         "!tlibCfg";       // Contains the command/setup options
  str tlibLUT         "!tlibLUT";       // Contains the LOOKUP data record
  str tlibLokPath     "!tlibLokPath";   // Contains the LOK path name
}

#define _LOK_EXT      Parse_Str( "\x7F" + "LOKEXT=", tlibCfg )

macro Tlib Trans {
/******************************************************************************
                               Multi-Edit Macro
                               15-Sep-94  21:24

  Name    : Tlib

  Function: Checks that the GET executable is found and initilizes TLIB
            support.

  Syntax  : Rm( "Tlib /I" );

  Entry   : /I              - Initialize the system if checks pass.

  Exit    : Return_Int
              False         - TLIB support not installed and checks failed.
              True          - TLIB support installed and checks passed.

            gstr !vcsVerStr   - "TLIB " + macro version number.
            gstr !vcsRevStr   - macro revision number.
            gstr !vcsDoLogin  - False.

  Globals : str !vcsVerStr  - Returns the string "TLIB " + macro version no.
            str !vcsRevStr  - Returns the macro revision number.
            str !vcsDoLogin - Set True to enable changing username and passwd.

  Macros  : int VcsChkVer
            mac PathSearch

                 Copyright (C) 1994 by Small Systems Support.
********************************************************************( ldh )***/

//+++keyword+++ "@(#)%v %n, %f, %w"
  str Rev_Id = "@(#)14 TLIB.S, 04-Feb-95,01:37:24, LDH";
  str Cmd = Copy( _GET_CMDL, 1, XPos( " ", _GET_CMDL, 1 ) - 1 );

  // Check for get command EXE file
  Return_Str = ExecSearchPath( Cmd, "<%PATH>" );
  Return_Int = ( Return_Str != "" );
  if ( Return_Int ) {
    if ( VcsChkVer( _TLIB_VER )) {
      if ( XPos( "/I", MParm_Str, 1 )) {  // Initialize?
        vcsDoLogin = False;             // Disable change user ID menu item
      }
    }
    else {
      Error_Level = 9011;               // Set version error
    }
  }
  else {
    Error_Level = 9010;                 // Set no EXE found error
  }
  vcsVerStr = "TLIB " + _TLIB_VER;
  vcsRevStr = Rev_Id;

}  // Tlib

macro TlibView Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               12-Aug-94  23:31

  Name    : TlibView

  Function: The TLIB specific view macro to view the changes to the current
            work file compared to the latest revision in the archive.

  Syntax  : Rm( "TlibView" );

  Entry   : gstr !vcsFName  - Filename of file to compare
            gint !vcsLibFnd - Set True if archive found.

  Exit    : Return_Int
              True          - No Error
              False         - ( Error_Level == 0 ) Cancelled
                              ( Error_Level != 0 ) Error

  Globals : str !vcsFName   - The work file name.
            int !vcsLibFnd  - The archive found status (True = found).
            str !vcsDlgMsg  - The dialog message when calling VcsGetLib.
            str !vcsMsg     - The status line message when exec is run.
            str !tlibCfg    - The TLIB specific command/setup options.
            str !vcsName    - The vcs temp file name.


  Macros  : int  VcsGetLib
            int  TlibExec
            mac  CDiff
            void VcsViewWinDlg

                Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

  str FName = Truncate_Path( vcsFName );
  str TFName = TempFileName( FName );

  int Frn = False;

  if ( !vcsLibFnd ) {
    vcsDlgMsg = "(TLIB) VIEW Archive File Path.";
    if ( !vcsLibFnd = VcsGetLib( vcsFName )) {
      vcsMsg = "TLIB archive file for \"" + FName + "\" not found.";
      Error_Level = 3002;
      Return_Int = False;
    }
  }
  if ( vcsLibFnd ) {
    Working;
    if ( Switch_File( vcsFName )) {
      if ( File_Changed ) {
        Rm( "SaveFile /NP=1" );
      }
    }
    if ( _RVC ) {
      if ( File_Exists( TFName )) {
        Set_File_Attr( _VCS3_TMP, 0 );
        Del_File( _VCS3_TMP );
        Rename_File( TFName, _VCS3_TMP );
        Frn = True;
      }
    }
    vcsMsg = "Viewing changes made to \"" + FName + "\"...";
    vcsDlgMsg = "(TLIB) VIEW Command Line.";
    if ( Return_Int = TlibExec( _VIEW_CMDL, _DISP_WIN, _DO_CD )) {
      if ( _RVC ) {
        Rm( "CDiff /F=" + TFName + "/D=" + str( !_CDIF ));
        if ( Return_Int == 1 ) {
          vcsMsg = "Files the same.";
        }
        else {
          vcsMsg = "CDiff complete.";
        }
        Set_File_Attr( TFName, 0 );
        Del_File( TFName );
        Return_Int = True;
      }
      else if ( Switch_File( vcsName )) {
        Return_Int = False;
        Error_Level = 0;
        Load_File( vcsName );
        if ( !Error_Level ) {
          VcsViewWinDlg( "(TLIB) Differences of " + Truncate_Path( vcsFName ),
              100, 18, "", hc_vcs_View );
          vcsMsg = "TLIB VIEW command complete.";
          Return_Int = True;
        }
      }
    }
    if ( Frn ) {
      Rename_File( _VCS3_TMP, TFName );
    }
  }
}  // TlibView

macro TlibList Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               12-Aug-94  23:31

  Name    : TlibList

  Function:

  Syntax  :

  Entry   :

  Exit    : Return_Int
              True          - No Error
              False         - ( Error_Level == 0 ) Cancelled
                              ( Error_Level != 0 ) Error

  Globals :

  Macros  :

                Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

  str FName = Truncate_Path( vcsFName );

  if ( !vcsLibFnd ) {
    vcsDlgMsg = "(TLIB) LIST Archive File Path.";
    if ( !vcsLibFnd = VcsGetLib( vcsFName )) {
      vcsMsg = "TLIB archive file for \"" + FName + "\" not found.";
      Error_Level = 3002;
      Return_Int = False;
    }
  }
  if ( vcsLibFnd ) {
    vcsMsg = "Listing versions of \"" + Truncate_Path( vcsFName ) + "\"...";
    vcsDlgMsg = "(TLIB) LIST Command Line.";
    if ( Return_Int = TlibExec( _LIST_CMDL, _DISP_WIN, False )) {  // No vcs errors
      if ( Switch_File( vcsName )) {
        Return_Int = False;
        Error_Level = 0;
        Load_File( vcsName );
        if ( !Error_Level ) {
          VcsViewWinDlg( "(TLIB) Versions of " + Truncate_Path( vcsFName ),
              100, 18, "BT_VCS_109", hc_vcs_List );
          vcsMsg = "TLIB LIST command complete.";
          Return_Int = True;
        }
      }
    }
  }
}  // TlibList

macro TlibLock Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               12-Aug-94  23:31

  Name    : TlibLock

  Function:

  Syntax  :

  Entry   :

  Exit    : Return_Int
              True          - No Error
              False         - ( Error_Level == 0 ) Cancelled
                              ( Error_Level != 0 ) Error

  Globals :

  Macros  :

                Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

  str FName = Truncate_Path( vcsFName );

  int Frn = False;

  if ( !vcsLibFnd ) {
    vcsDlgMsg = "(TLIB) LOCK Archive File Path.";
    if ( !vcsLibFnd = VcsGetLib( vcsFName ) ) {
      vcsMsg = "TLIB archive file for \"" + FName + "\" not found.";
      Error_Level = 3002;
      Return_Int = False;
    }
  }
  if ( vcsLibFnd ) {
    if ( Return_Int = !TlibChkLock( ) ) {
      if ( File_Exists( vcsFName ) ) {
        Set_File_Attr( _VCS3_TMP, 0 );
        Del_File( _VCS3_TMP );
        Rename_File( vcsFName, _VCS3_TMP );
        Frn = True;
      }
      vcsMsg = "Locking \"" + vcsFName + "\"...";
      vcsDlgMsg = "(TLIB) LOCK Command Line.";
      Return_Int = TlibExec( _LOCK_CMDL, _DISP_WIN, _DO_CD );
      if ( Frn ) {
        if ( Return_Int ) {
          Rename_File( _VCS3_TMP, vcsFName );
        }
        else {
          int Sel = Error_Level;

          Set_File_Attr( _VCS3_TMP, 0 );
          Del_File( _VCS3_TMP );
          Error_Level = Sel;
        }
      }
    }
  }
}  // TlibLock

macro TlibGet Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               12-Aug-94  23:31

  Name    : TlibGet

  Function:

  Syntax  :

  Entry   :

  Exit    : Return_Int
              True          - No Error
              False         - ( Error_Level == 0 ) Cancelled
                              ( Error_Level != 0 ) Error

  Globals :

  Macros  :

                Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

  str Vcs_Cmd[ 128 ];
  str FName = Truncate_Path( vcsFName );
  str Cmd[ 20 ] = Parse_Str( "/C=", MParm_Str );

  int Fw = 0;
  int Frn = False;
  int Sel;

  if ( !vcsLibFnd ) {
    vcsDlgMsg = "(TLIB) " + Cmd + " Archive File Path.";
    if ( !vcsLibFnd = VcsGetLib( vcsFName ) ) {
      vcsMsg = "TLIB archive file for \"" + FName + "\" not found.";
      Error_Level = 3002;
      Return_Int = False;
    }
  }
  if ( vcsLibFnd ) {
    Return_Int = True;
    if ( Cmd == "GET" ) {
      Return_Int = !TlibChkLock( );
      Vcs_Cmd = _GET_CMDL;
    }
    else {
      Vcs_Cmd = _BROWSE_CMDL;
    }
    if ( Return_Int ) {
      if ( File_Name == vcsFName ) {
        Frn = True;
      }
      else if ( Switch_File( vcsFName ) ) {
        Frn = True;
      }
      if ( Frn ) {
        if ( !Read_Only || vcsDF || ( Truncate_Path( File_Name ) != FName ) ) {
          Rm( "Verify /H=" + hc_vcs_Verify + "/T=" + vcsFName +
              " Already loaded, OVERWRITE? /BL= ARE YOU SURE? " );
        }
        if ( Return_Int ) {
          Fw = Window_Id;
          VcsPushPos( );
          Erase_Window;
        }
      }
      else if ( File_Exists( vcsFName ) ) {
        Rm( "Verify /H=" + hc_vcs_Verify + "/T=" + vcsFName +
            " Already exists, OVERWRITE? /BL= ARE YOU SURE? " );
      }
    }
    if ( Return_Int ) {
      Frn = False;
      if ( File_Exists( vcsFName ) ) {
        Set_File_Attr( _VCS3_TMP, 0 );
        Del_File( _VCS3_TMP );
        Rename_File( vcsFName, _VCS3_TMP );
        Frn = True;
      }
      vcsMsg = "Retrieving \"" + vcsFName + "\"...";
      vcsDlgMsg = "(TLIB) " + Cmd + " Command Line.";
      if ( Return_Int = TlibExec( Vcs_Cmd, _DISP_WIN, _DO_CD ) ) {
        if ( Frn ) {
          Sel = Error_Level;
          Set_File_Attr( _VCS3_TMP, 0 );
          Del_File( _VCS3_TMP );
          Error_Level = Sel;
        }
      }
      else {                            // error, restore file
        if ( Frn ) {
          Rename_File( _VCS3_TMP, vcsFName );
        }
        if ( Switch_Win_Id( Fw ) ) {
          Sel = Error_Level;
          Error_Level = 0;
          Load_File( vcsFName );
          if ( !Error_Level ) {
            Rm( "ExtSetup" );
          }
          VcsPopPos( True );
          Error_Level = Sel;
          Return_Int = False;
        }
      }
    }
  }
}  // TlibGet

macro TlibPut Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               12-Aug-94  23:31

  Name    : TlibPut

  Function: The TLIB specific CREATE/PUT/UNLOCK commands.

  Syntax  :

  Entry   :

  Exit    : Return_Int
              True          - No Error
              False         - ( Error_Level == 0 ) Cancelled
                              ( Error_Level != 0 ) Error
  Globals :

  Macros  :

                Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

  str Vcs_Cmd[ 128 ];
  str Cmd[ 20 ] = Parse_Str( "/C=", MParm_Str );
  str FName[ 12 ] = Truncate_Path( vcsFName );

  int Sel;
  int Fw = 0;
  int Ow = 0;
  int Get_Cmt = False;

  Return_Int = True;
  if ( vcsChkMod != "V" ) {
    Return_Int = !TlibChkLock( );
  }
  if ( Return_Int ) {
    if ( File_Name == vcsFName ) {
      Fw = Window_Id;
    }
    else if ( Switch_File( vcsFName ) ) {
      Fw = Window_Id;
    }
    if ( Fw ) {
      VcsPushPos( );
    }
    if ( vcsChkMod == "V" ) {
      if ( Window_Id == Fw ) {
        Erase_Window;
      }
      if ( File_Exists( vcsFName ) ) {
        Set_File_Attr( vcsFName, 0 );
        Del_File( vcsFName );
      }
    }
    else {
      if ( !vcsLibFnd ) {
        vcsDlgMsg = "(TLIB) " + Cmd + " Archive File Path.";
        vcsLibFnd = VcsGetLib( vcsFName );
        Return_Int = !Error_Level;
        Error_Level = 0;
      }
      if ( Return_Int ) {
        if ( Cmd == "PUT" ) {
          Get_Cmt = True;
          if ( !vcsLibFnd ) {
            Cmd = "CREATE";
          }
          if ( !Fw ) {
            Ow = Window_Id;
            Switch_Window( Window_Count );
            Create_Window;
            Load_File( vcsFName );
            Fw = Window_Id;
          }
        }
        switch ( Cmd ) {
          case "CREATE":
            Vcs_Cmd = _CREATE_CMDL;
            vcsMsg = "Creating \"" + Get_Path( vcsAFile ) + FName + "\" ...";
            vcsDlgMsg = "(TLIB) Describe \"" + FName + "\".";
            break;

          case "PUT":
            Vcs_Cmd = _PUT_CMDL;
            vcsMsg = "Storing \"" + FName + "\" in \"" + Get_Path( vcsAFile ) +
                FName + "\"...";
            vcsDlgMsg = "(TLIB) Describe changes to \"" + FName + "\".";
            break;

          case "UNLOCK":
            Vcs_Cmd = _UNLOCK_CMDL;
            vcsMsg = "Unlocking \"" + Get_Path( vcsAFile ) + FName + "\"...";
            break;
        }
        if ( Get_Cmt ) {
          Return_Int = VcsGetCmt( True, False );
        }
        if ( Return_Int ) {
          if ( Fw ) {
            Erase_Window;
          }
          vcsDlgMsg = "(TLIB) " + Cmd + " Command Line.";
          if ( Return_Int = TlibExec( Vcs_Cmd, _DISP_WIN, _DO_CD ) ) {
            if ( File_Exists( vcsFName ) ) {
              if ( _DEL_SRC ) {
                Sel = Error_Level;
                Set_File_Attr( vcsFName, 0 );
                Del_File( vcsFName );
                Error_Level = Sel;
              }
            }
            if ( Ow ) {
              Delete_Window;
              Switch_Win_Id( Ow );
            }
          }
          else {                        // error, reload file
            if ( Switch_Win_Id( Fw ) ) {
              Sel = Error_Level;
              Error_Level = 0;
              Load_File( vcsFName );
              if ( Error_Level == 0 ) {
                if ( Get_Cmt && vcsChgFlg ) {
                  VcsPutCmt( False );
                }
                Rm( "ExtSetup" );
              }
              Get_Cmt = True;
              if ( Ow ) {
                Delete_Window;
                Switch_Win_Id( Ow );
                Get_Cmt = False;
              }
              VcsPopPos( Get_Cmt );
              Error_Level = Sel;
              Return_Int = False;
            }
          }
        }
      }
    }
  }
}  // TlibPut

int TlibExec( str CmdLine, int Show_Win, int Chg_Dir ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               15-Sep-94  17:56

  Name    : TlibExec

  Function: Execute the TLIB command in cmdline.

  Syntax  : pass = TlibExec( CmdLine, Show_Win, Chg_Dir );

  Entry   : str CmdLine
            int Show_Win
            int Chg_Dir
            gstr !vcsFName
            gstr !vcsAFile
            gint !vcsSNCL

  Exit    : int
              True            - No Error.
              False           - ( Error_Level == 0 ) Cancelled
                                ( Error_Level = Error number ) Error
                gstr !vcsMsg  - Error message  ( Only when Error_Level != 0 )

            gstr !vcsDlgMsg   - Cleared.
            gstr !vcsLokPath  - Cleared.

  Globals : str !vcsFName   - Contains the work file name.
            str !vcsAFile   - Contains the archive file name.
            int !vcsSNCL    - Flag to not show cmdline dialog ( True ).
            str !vcsCfg     - Contains the main vcs config options.
            str !vcsMsg     - Contains the status line message.
            str !vcsName    - Contains the vcs temp file name.
            str !vcsDlgMsg  - Contains the show cmdline dialog message.
            str !vcsLokPath - Contains the TLIB LOK file path.

  Macros  : str TlibXlate
            int VcsEditStrDlg
            int ExecProg

                Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

  int Result = True;

  CmdLine = TlibXlate( CmdLine, vcsFName, vcsAFile );
  Error_Level = 0;
  if ( vcsSNCL ) {
    if ( Check_Key && ( ( Key1 == 27 ) && ( Key2 == 1 ) ) ) {
      Result = False;
    }
  }
  else if ( _SHOW_CMD ) {
    Result = VcsEditStrDlg( vcsDlgMsg, CmdLine, False );
  }
  if ( Result ) {
    Set_File_Attr( vcsName, 0 );
    Del_File( vcsName );                // Erase tmp capture file
    Result = False;
    Working;
    Make_Message( vcsMsg );
    Error_Level = ExecProg( CmdLine, vcsPrjDir, vcsName, vcsName,
        _EP_FLAGS_NOBYPASS );
    switch ( Error_Level ) {

      case _Exec_Abort :
        Error_Level = 0;
        break;

      case _Exec_Error :
        Error_Level = ExecErrorCode;
        break;

      case _Exec_Success :
        Error_Level = 0;
        switch ( ExecId ) {

          case _Exe_Id_Windows :
            TlibParseErr( );

          case _Exe_Id_Dos :
          case _Exe_Id_Os2 :
            Error_Level = ExecReturnCode;
            if ( Error_Level == 0 ) {
              Result = True;
              break;
            }

          default :
            Error_Level += 9000;
        }
    }
  }
  vcsDlgMsg = "";
  tlibLokPath = "";
  return ( Result );

}  // TlibExec

str TlibXlate(
        str Path = Return_Str,
        str FName = Parse_Str( "/F=", MParm_Str ),
        str LPath = Parse_Str( "/P=", MParm_Str )
    ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               12-Aug-94  23:31

  Name    : TlibXlate

  Function: Translates any occurrences of <LPATH> in "path" to include the LOK
            path if the global string "!tlibLokPath" contains a path and then
            call VcsXlate to finish the translations.

  Syntax  : path = TlibXlate( path, FName, lpath );

  Entry   : str Path            - The string to be translated.
            str FName           - The work file name.
            str LPath           - The TLIB archive path to use for <LPATH>.
            gstr !tlibLokPath   - The TLIB LOK file path.

  Exit    : str ( Return_Str )  - The expanded command line.

  Globals : str !tlibLokPath    - The file path for TLIB LOK files.

  Macros  : str VcsXlate

                Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

  if ( tlibLokPath != "" ) {

    int Jx;

    if ( LPath == "" ) {
      LPath = FName;
    }
    while ( Jx = XPos( "<LPATH>", Caps( Path ), 1 ) ) {
      Path = Str_Del( Path, Jx, 7 );
      Path = Str_Ins( Get_Path( LPath ) + "/" + tlibLokPath, Path, Jx );
    }
  }
  return ( VcsXlate( Path, vcsFName, vcsAFile ) );

}  // TlibXlate

str TlibExt(
        str FName = Parse_Str( "/F=", MParm_Str ),
        int Lok = Parse_Int( "/LOK=", MParm_Str )
    ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               12-Aug-94  23:31

  Name    : TlibExt

  Function: Takes a filename extension and converts it to the equivalent TLIB
            LIBEXT or LOKEXT extension.

  Syntax  : TlibExt( str FName, int Lok );

  Entry   : str FName     - Filename for which the extension is translated.
            int Lok       - 0 for LIBEXT
                            1 for LOKEXT

  Exit    : str           - The vcs file extent based upon LIBEXT or LOKEXT

  Globals : str !tlibCfg  - The Tlib specific command/setup options.

  Macros  : none.

                Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

  str New_Ext[ 3 ];
  str Ext = Get_Extension( FName );

  int Jx;

  if ( Lok ) {
    New_Ext = _LOK_EXT;
  }
  else {
    New_Ext = _LIB_EXT;
  }
  if ( New_Ext != "" ) {
    Jx = 1;
    while ( Jx = XPos( "?", New_Ext, Jx ) ) {
      if ( ( Copy( Ext, Jx, 1 ) == "" ) && ( Jx != 3 ) ) {
        New_Ext = Str_Ins( "_", Str_Del( New_Ext, Jx, 1 ), Jx );
      }
      else {
        New_Ext = Str_Ins( Copy( Ext, Jx, 1 ), Str_Del( New_Ext, Jx, 1 ), Jx );
      }
      ++Jx;
    }
    Ext = New_Ext;
  }
  return ( Ext );

}  // TlibExt

int TlibChkLib(
        str Path = Parse_Str( "/P=", MParm_Str ),
        str FName = Parse_Str( "/F=", MParm_Str ),
        int Pm = Parse_Int( "/M=", MParm_Str )
    ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               12-Aug-94  23:31

  Name    : TlibChkLib

  Function: Search "Path" for the TLIB archive for "FName" based upon "Pm".

  Syntax  : LibFnd = TlibChkLib( Path, FName, Pm );

  Entry   : gstr !vcsID - The name of the currently selected vcs package.
            str  Path   - Contains the search path.
            str  FName  - The filename for which to find archive.
            int  Pm     - Path Mode.
              -2        - Check for and return archive file only.
              -1        - Check for and return archive file,
                          iff no file return 1st lib path.
               0        - Return full archive path.
              +#        - Return # directory from archive path.

  Exit    : int ( gint !vcsRInt )
              #                 - File was found in # path.
                gstr !vcsAFile  - The found archive filename or path.
              0                 - File NOT found.
                gstr !vcsAFile  - The archive path based upon pm.
                                  ( Not set if Pm == -2 ).

  Globals : str !vcsID    - The name of the currently selected vcs package.
            int !vcsRInt  - The return integer.
            str !vcsAFile - The found archive filename or path.

  Macros  : int VcsGetPath

                Copyright (C) 1993-94 by Small Systems Support.
********************************************************************( ldh )***/

  vcsRInt = False;
  if ( ( Path == _LIB_PATH ) && ( _DO_CD == 2 ) ) {
    Path = "<LOOKUP>";
  }
  return ( vcsRInt = VcsGetPath( Path, FName, TlibExt( FName, 0 ), Pm ) );

}  // TlibChkLib

str TlibGetFName( str LibFile = Parse_Str( "/P=", MParm_Str ) ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               12-Aug-94  23:31

  Name    : TlibGetFName

  Function: Returns the work file name extracted from the archive "LibFile" or
            "" when archive doesn't exist.

  Syntax  : FName = TlibGetFName( LibFile );

  Entry   : str LibFile           - archive file name

  Exit    : str ( gstr !vcsRStr ) - The workfile_name or "".

  Globals : str !vcsRStr          - The return string.

  Macros  : none

                Copyright (C) 1993-94 by Small Systems Support.
********************************************************************( ldh )***/

  int Hn;
  int Jx;

  str Buf[ 128 ];

  vcsRStr = "";
  if ( !S_Open_File( LibFile, 0x00, Hn ) ) {
    if ( !S_Read_Bytes( Buf, Hn, 128 ) ) {
      if ( Jx = XPos( " ", Buf, 1 ) ) {
        vcsRStr = Copy( Buf, ++Jx, XPos( " ", Buf, Jx ) - Jx );
      }
    }
    S_Close_File( Hn );
  }
  return ( vcsRStr );

}  // TlibGetFName

int TlibChkLock( ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               12-Aug-94  23:31

  Name    : TlibChkLock

  Function: Returns True if work file name in "!vcsFName" has it's archive
            locked by another user.

  Syntax  : Locked = TlibChkLock( );

  Entry   : gstr !vcsFName    - Contains the work file name.
            gstr !vcsAFile    - Contains the archive file name.

  Exit    : int
              True            - Archive file locked.
              False           - Archive file not locked.

  Globals : str !vcsFName     - The name of the work file.
            str !vcsAFile     - The name of the archive file.
            str !tlibLokPath  - The path name for LOK files.
            str !TlibCfg      - Contains the command/setup options for TLIB.

  Macros  : str TlibExt
            str TlibLookup
            mac MessageBox

                Copyright (C) 1990-94 by Small Systems Support.
********************************************************************( ldh )***/

  int Hn;
  int Jx;
  int RetVal = False;

  str LokFile;
  str LokExt = TlibExt( vcsFName, 1 );
  str User = TlibGetUser( );
  str Buf[ 128 ];
  str Lok[ 20 ];
  str TStr;

  if ( ( _LIB_PATH == "<LOOKUP>" ) || ( _DO_CD == 2 ) ) {
    tlibLokPath = TlibLookup( vcsFName, "FD", "LD" );
    if ( vcsLibFnd == -1 ) {
      TStr = vcsAFile;
      LokFile = TlibLookup( vcsFName, "FD", "AD" );
      Jx = VcsGetPath( LokFile, TStr, Get_Extension( TStr ), -2 );
      if ( Jx ) {
        vcsLibFnd = Jx;
      }
      else {
        tlibLokPath = "";
      }
      vcsAFile = TStr;
    }
  }
  if ( tlibLokPath == "" ) {
    LokFile = vcsAFile;
  }
  else {
    TStr = vcsAFile;
    if ( VcsGetPath( tlibLokPath, "", "", vcsLibFnd ) ) {
      tlibLokPath = vcsAFile;
    }
    vcsAFile = TStr;
    LokFile = tlibLokPath + Truncate_Path( vcsAFile );
  }
  LokFile = Truncate_Extension( LokFile ) + "." + LokExt;
  RetVal = False;
  if ( File_Exists( LokFile ) ) {
    if ( !S_Open_File( LokFile, 0x00, Hn ) ) {
      if ( !S_Read_Bytes( Buf, Hn, 128 ) ) {
        Jx = XPos( " ", Buf, 1 ) - 1;
        if ( Jx < 1 ) {
          Jx = Svl( Buf ) - 2;
        }
        if ( Caps( User ) != ( Lok = Caps( Copy( Buf, 1, Jx ) ) ) ) {
          Rm( "MessageBox /B=1/T=TLIB Error/M=" + vcsAFile +
              " is locked by \"" + Lok + "\"" );
          RetVal = True;
        }
      }
      S_Close_File( Hn );
    }
  }
  return ( RetVal );

}  // TlibChkLock

macro TlibDir Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               12-Aug-94  23:31

  Name    : TlibDir

  Function: Displays directory listing of TLIB archive files.  Allows user to
            select a file to be retrieved for modification, viewing only, or
            listing the version history.

  Syntax  : Rm( "TlibDir /C=Cmd/RC" );

  Entry   : /C=str        - Command to execute ( ie GET, BROWSE or LIST ).
            /RC           - Repeat command until <ESC>.

  Exit    : none.

  Globals : str !tlibCfg  - Contains the command/setup options for TLIB.

  Macros  : mac VcsFile

                Copyright (C) 1993-94 by Small Systems Support.
********************************************************************( ldh )***/

  str User = TlibGetUser( );
  VcsGetPath( _LIB_PATH, FExpand( "*.*" ), "", 1 );
  VcsFileDlg( "(TLIB) Archive Files", vcsAFile + "*." + _LIB_EXT, User );

}  // TlibDir

macro TlibIActive Trans {
/******************************************************************************
                               Multi-Edit Macro
                               12-Aug-94  23:31

  Name    : TlibIActive

  Function: Runs the "menu command line" that is contained in "!tlibCfg" global
            variable.

  Syntax  : Rm( "TlibIActive" );

  Entry   : none.

  Exit    : none.

  Globals : str !tlibCfg - Contains the commands/setup options for TLIB.

  Macros  : int WinExecAndWait

                Copyright (C) 1993-94 by Small Systems Support.
********************************************************************( ldh )***/

  str CmdLine = _MENU_CMDL;

  if ( _SHOW_CMD ) {
    vcsDlgMsg = "(TLIB) Run Interactive Command Line";
    Return_Int = VcsEditStrDlg( vcsDlgMsg, CmdLine, False );
  }
  if ( Return_Int ) {
    WinExecAndWait( CmdLine, "", _EP_Flags_DontWait, "", "" );
  }
}  // TlibIActive

macro TlibLogin Trans {
/******************************************************************************
                               Multi-Edit Macro
                               12-Aug-94  23:31

  Name    : TlibLogin

  Function: Check if a user is logged in ( Not supported in TLIB ).

  Syntax  : Rm( "TlibLogin" );

  Entry   : none.

  Exit    : none.

  Globals : none.

  Macros  : none.

                 Copyright (C) 1994 by Small Systems Support.
********************************************************************( ldh )***/

}  // TlibLogin

macro TlibAdminPrj Trans {
/******************************************************************************
                               Multi-Edit Macro
                               12-Aug-94  23:31

  Name    : TlibAdminPrj

  Function: Create, edit and delete entries in the user's administer project
            database for Tlib.

  Syntax  : Rm( "TlibAdminPrj" );

  Entry   : none.

  Exit    : none.

  Globals : str !tlibLUT - The contents of the current db record.

  Macros  : mac TlibChkAdmin

                 Copyright (C) 1994 by Small Systems Support.
********************************************************************( ldh )***/

  tlibLUT = "";                         // clear global lookup variable
  Db( _VCS_DB, "TLIB.VAD", "MEWHDRS.DB", "TLIBVAD.HDR",
      "(TLIB) Associate Directories",
      "(TLIB) Associate Directories Setup",
      "!VAD", 0,
      "/BMP=BT_VCS_102/NDF=1/PRE=!VAD/H=" + hc_vcs_Admin +
          "/CP=New File Directory:/MOVE=1/MACRO=TLibChkAdmin" );

}  // TlibAdminPrj

str TlibLookup(
        str FName = Parse_Str( "/F=", MParm_Str ),
        str Field1 = Parse_Str( "/F1=", MParm_Str ),
        str Field2 = Parse_Str( "/F2=", MParm_Str )
    ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               12-Aug-94  23:31

  Name    : TlibLookup

  Function: Returns the string in "Field2" of the TLIB administer project
            database when the directory of "FName" matches a string in
            "Field1".

  Syntax  : Str_Val = TlibLookup( FName, Field1, Field2 );

  Entry   : str FName  - The filename to extract the directory name from.
            str Field1 - The field name of the field to match the directory to.
            str Field2 - The field name fo the field to return the string from.

  Exit    : str ( gstr !vcsRStr )
              ""          - Empty string if no match or Field2 empty.
              [Field2]    - Contents of Field2 when match found.

            gstr !tlibLUT - Contains the found record.

  Globals : str !vcsRStr  - The return string.
            str !tlibLUT  - The contents of the matched db record.

  Macros  : int DbGetRecord

                 Copyright (C) 1994 by Small Systems Support.
********************************************************************( ldh )***/

  int Result = True;

  vcsRStr = "";
  FName = Caps( Get_Path( FName ) );
  if ( FName != Parse_Str( "\x7F" + Field1 + "=", tlibLUT ) ) {

    int Cnt = 0;
    int OrgWin = Window_Id;
    int TRefresh = Refresh;
    int Flags = _dbf_NoDelWin | _dbf_NoSwitchWin;

    str ADField = "\x7F" + "AD=";
    str LDField = "\x7F" + "LD=";
    str DbName = _VCS_DB;
    str TStr;
    str SFName = FName;

    Result = False;
    Refresh = False;
    tlibLUT = "";
    while ( DbGetRecord( DbName, "TLIB.VAD", Field1, FName, Cnt, Flags, "" ) ==
        _NoError ) {
      if ( tlibLUT != "" ) {
        TStr =  Parse_Str( ADField, tlibLUT ) + ";" +
            Parse_Str( ADField, FName );
        Return_Str = ADField;
        Rm( "ChngParm /G=!tlibLUT/P=" + TStr );
        TStr = Parse_Str( LDField, FName );
        if ( TStr != "" ) {
          TStr = Parse_Str( LDField, tlibLUT) + ";" + TStr;
          Return_Str = LDField;
          Rm( "ChngParm /G=!tlibLUT/P=" + TStr );
        }
      }
      else {
        tlibLUT = FName;
        if ( XPos( Field1, "ADLD", 1 ) ) {
          break;
        }
      }
      Flags =  _dbf_NoDelWin | _dbf_NoSwitchWin | _sf_Position;
      FName = SFName;
      DbName = "";
      Result = True;
    }
    Switch_Win_Id( OrgWin );
    Refresh = TRefresh;
  }
  if ( Result ) {
    vcsRStr = Parse_Str( "\x7F" + Field2 + "=", tlibLUT );
    if ( XPos( Field1, "ADLD", 1 ) ) {
      tlibLUT = "";
    }
  }
  return ( vcsRStr );

}  // TlibLookup

str TlibCfgFile(
        str FName = Parse_Str( "/F=", MParm_Str ),
        str Param = Parse_Str( "/P=", MParm_Str )
    ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               20-Dec-94  00:50

  Name    : TlibCfgFile

  Function: Parse and return the value for Param from the TLIB.CFG file.
            (Note: this function currently uses the <LOOKUP> function until the
            code is actually written and tested to parse the TLIB.CFG file)

  Syntax  : Str_Val = TlibCfgFile( FName, Param );

  Entry   : str FName   - The filename to extract the directory name from
            str Param   - The parameter to parse for the return string

  Exit    : str ( gstr !vcsRStr )
              ""          - Empty string if no match
              [Param]     - Contents of Param from config file when match found

  Globals : str !vcsRStr  - The return string
            str !tlibCfg

  Macros  : str TlibLookUp
            str TlibGetUser

                 Copyright (C) 1994 by Small Systems Support.
********************************************************************( ldh )***/

  vcsRStr = "";
  switch ( Param ) {
    case "ARCDIR" :
      vcsRStr = TlibLookup( FName, "FD", "AD" );
      break;

    case "ARCEXT" :
      vcsRStr = _LIB_EXT;
      break;

    case "USER" :
      vcsRStr = TlibGetUser( );
      break;

    case "WORKDIR" :
      vcsRStr = TlibLookup( FName, "FD", "WD" );
      break;

    case "LOKDIR" :
      vcsRStr = TlibLookup( FName, "FD", "LD" );
      break;

    case "LOKEXT" :
      vcsRStr = _LOK_EXT;
      break;
  }
  return ( vcsRStr );

}  // TlibCfgFile

macro TlibChkAdmin Trans {
/******************************************************************************
                               Multi-Edit Macro
                               12-Aug-94  23:31

  Name    : TlibChkAdmin

  Function: Called by the AdminPrj dialog to capitialize, check and update all
            directories to end with a \ when saving the data in the dialog.

  Syntax  : Called only by the DB macro when in the AdminPrj dialog.

  Entry   : Values passed by the DB macro.

  Exit    : updated data.

  Globals : none.

  Macros  : none.

                 Copyright (C) 1994 by Small Systems Support.
********************************************************************( ldh )***/

  if ( Parse_Int( "/P=", MParm_Str ) != 0 ) {

    str GStr = Parse_Str( "/GLO=", MParm_Str );
    str TStr = Caps( Global_Str( GStr ) );

    int Len = Svl( TStr );
    int Jx = 1;

    while ( Jx < Len ) {
      if ( ( Jx = XPos( "\x7F", TStr, ++Jx ) ) == 0 ) {
        Jx = Len + 1;
      }
      if ( Pos( Copy( TStr, Jx - 2, 1 ), "=" ) == 0 ) {
        if ( Pos( Copy( TStr, Jx - 1, 1 ), ";>\\" ) == 0 ) {
          TStr = Str_Ins( "\\", TStr, Jx );
          Len = Svl( TStr );
        }
      }
    }
    Jx = 1;
    while ( Jx = XPos( ";", TStr, Jx ) ) {
      if ( Copy( TStr, Jx - 1, 1 ) != "\\" ) {
        TStr = Str_Ins( "\\", TStr, Jx );
      }
      ++Jx;
    }
    Set_Global_Str( GStr, TStr );
  }
}  // TlibChkAdmin

void TlibParseErr( ) Trans {
/******************************************************************************
                               Multi-Edit Macro
                               15-Sep-94  17:56

  Name    : TlibParseErr

  Function: Used to parse the captured file from a Windows executable.
            Note: Currently no Windows programs for TLIB to support.

  Syntax  : TlibParseErr( );

  Entry   : None.

  Exit    : gint ExecReturnCode - The error code for the executed windows program

  Globals : int ExecReturnCode

  Macros  : None.

                  Copyright (C) 1994 by Small Systems Support
********************************************************************( ldh )***/

  ExecReturnCode = 100;                 // Return error not supported yet

}  // TlibParseErr

str TlibGetUser( ) {
/******************************************************************************
                               Multi-Edit Macro
                               03-Oct-94  15:04

  Name    :
  Function:
  Syntax  :
  Entry   :
  Exit    :
  Globals :
  Macros  :

                  Copyright (C) 1994 by Small Systems Support
********************************************************************( ldh )***/


  str Result = Get_Environment( "TLIBID" );

  if ( Result == "" ) {
    if ( ( Result = Get_Environment( "USERNAME" ) ) == "" ) {
      Result = _VCS_USERID;
    }
  }
  return ( Result );

}  // TlibGetUser
