// TBWIN.SH :: access to toolbox routines in MEWTOOLS.DLL

// Toolbox styles
#define   TBS_NOCAPTION       0x0001      // No caption on toolbox
#define   TBS_FLOATING        0x0002      // Popup toolbox restricted to appwin
#define   TBS_NORESIZE        0x0004      // Toolbox that can not be resized
#define   TBS_KEEPPARENTWIDTH 0x0008      // Keeps parent width
#define   TBS_NOBORDER        0x1000      // is there a border?
#define   TBS_ROVING          0x2000      // popup toolbox that can rove anywhere


#define   TBS_TOPHORIZONTAL     ( TBS_KEEPPARENTWIDTH | TBS_NORESIZE  | TBS_NOCAPTION | 0x0010 )
#define   TBS_BOTTOMHORIZONTAL  ( TBS_KEEPPARENTWIDTH | TBS_NORESIZE  | TBS_NOCAPTION | 0x0020 )
#define   TBS_RIGHTVERTICAL     ( TBS_KEEPPARENTWIDTH | TBS_NORESIZE  | TBS_NOCAPTION | 0x0040 )
#define   TBS_LEFTVERTICAL      ( TBS_KEEPPARENTWIDTH | TBS_NORESIZE  | TBS_NOCAPTION | 0x0080 )


// Tool styles
#define	  TS_TWOSTATE					0x0000			// Two state button
#define		TS_ONESTATE					0x0001			// One state button
#define   TS_DEADSTATE        0x0002      // Dead state button (no msg proc'g)

// Toolbox flags for ToolboxDisableItem/ToolboxEnableItem/ToolboxGetItemState
#define		TF_BYCOMMAND				0x0000
#define		TF_BYPOSITION				0x0400

#define		TF_ENABLED          0x0001
#define		TF_SELECTED					0x0002
#define		TF_DISABLED        	0x0003

//          T o o l b o x   S y s t e m   M e n u
// ----------------------------------------------------------------------
// most items on the toolbox menu will call
// some cmacw macro for handling
// this structure will be passed with the call to ToolboxCreate

#DEFINE PtbSysMenuInfo POINTER
struct TtbSysMenuInfo
{
  // checkmark shows current orientation
  int16 wTBmgrLeft;
  int16 wTBmgrRight;
  int16 wTBmgrTop;
  int16 wTBmgrBottom;
  int16 wTBmgrFloating;
  int16 wTBmgrRoving;

  // checkmark show current icon size
  int16 wTBmgrBigIcon;
  int16 wTBmgrSmallIcon;

  int16 wTBmgrShowTbox;         // Show...   hide/show from a list
  int16 wTBmgrHide;             // Hide current toolbox

  int16 wTBmgrEdit;             // edit toolbox attached to current menu
  int16 wTbmgrWcmd;             // just bring up the toolbox manager

  int16 wTbmgrCheckmarks;

}

//***************************************************************
// Tool box functions
//***************************************************************
IMPORT  BOOL  ToolboxSetPopupDelay(WORD wDelay)
                  MEWTOOLS 117;
IMPORT  BOOL  ToolboxGetTitle(WORD hWnd, *ASCIIZ title)
                  MEWTOOLS 116;
IMPORT  BOOL  ToolboxSetTitle(WORD hWnd, ASCIIZ title)
                  MEWTOOLS 115;
IMPORT  BOOL  ToolboxShow(WORD hWnd)
                  MEWTOOLS 114;
IMPORT	BOOL	ToolboxHide(WORD hWnd)
                  MEWTOOLS 113;
IMPORT	BOOL	ToolboxIsVisible(WORD hWnd)
                  MEWTOOLS 112;
IMPORT  BOOL  ToolboxIsFloating(WORD hWnd)
                  MEWTOOLS 111;
IMPORT	WORD	ToolboxCreate(WORD hWnd,ASCIIZ lpszTitle,WORD wWndStyle,WORD wXSize,
                WORD wYSize,WORD hMDIClient,
                PTBSYSMENUINFO ts)
                  MEWTOOLS 110;
IMPORT	WORD	ToolboxSetFont(WORD hWnd,WORD wWeight,WORD wMaxHeight,ASCIIZ lpszFaceName)
                  MEWTOOLS 109;
IMPORT	WORD	ToolboxAddBitmapItem(WORD hWnd,WORD hBMSrc,WORD wXPos,WORD wId,WORD wStyle,
									ASCIIZ lpszQHelpText,ASCIIZ lpszEHelpLink)
                  MEWTOOLS 108;
IMPORT	WORD	ToolboxAddTextItem(WORD hWnd,ASCIIZ lpszText,WORD wId,WORD wStyle,ASCIIZ lpszQHelpText,
									ASCIIZ lpszEHelpLink)
                  MEWTOOLS 107;
IMPORT	WORD	ToolboxSetPos(WORD hWnd,WORD wXCoord,WORD wYCoord)
                  MEWTOOLS 106;
IMPORT 	WORD	ToolboxDisableItem(WORD hWnd,WORD wItemId,WORD wFlag,WORD wRedraw)
                  MEWTOOLS 105;
IMPORT  WORD	ToolboxEnableItem(WORD hWnd,WORD wItemId,WORD wFlag,WORD wRedraw)
                  MEWTOOLS 104;
IMPORT	WORD	ToolboxGetItemState(WORD hWnd,WORD wItemId,WORD wFlag,WORD wRedraw)
                  MEWTOOLS 103;
IMPORT	WORD	ToolboxSetItemState(WORD hWnd,WORD wItemId,WORD wFlag,WORD wState,WORD wRedraw)
                  MEWTOOLS 102;
IMPORT  WORD  ToolboxGetItemId(WORD hWnd, WORD wItemNum)
                  MEWTOOLS 118;
IMPORT	WORD 	ToolboxGetItemCount(WORD hWnd)
                  MEWTOOLS 101;
IMPORT	WORD	ToolboxGetMenu(WORD hWnd)
                  MEWTOOLS 100;

//***************************************************************
// Quick Help popup functions
//***************************************************************
IMPORT  WORD  QHelpPopup(WORD ScreenX,WORD ScreenYHi,WORD ScreenYLo,WORD iTBorientation,WORD iTBitemWidth,ASCIIZ lpszQHelpText,
                ASCIIZ lpszEHelpLink)
                MEWTOOLS 150;