// $Header: /MEWIN/SRC/SPELL.S 17    2/02/95 4:30p Todd $

#IFDEF windows
//  #include winsmall.sh
  #include windows.sh
  #include mew_dlgs.sh
  #include mewlist2.sh
  #include dialog.sh
  #include metools.sh

  #DEFINE SPLCHK_HELPLINK "SPELL CHECKER"
  #DEFINE SPLCHKSETUP_HELPLINK "SPELL CHECK SETUP"

  prototype spell
  {
    int   SpellEditDlg( int m; str &s );
    void  SpellSetup();
    void  SpellSetDef();
    int   SpellCheckSource(int m, str &tstr, int go_on );
    int   SpellCheckComnt(int m, str &tstr, int go_on );
  }

#ENDIF
macro_file SPELL;
/*******************************************************************************
														MULTI_EDIT MACRO FILE

Name: SPELL

Description:	This is the spell checker macros.

SPLSETF					- Retrieves spell checker setup data from file
SPELLCHECKSOURCE- Spell Checks only words between single, or double quotes.
SPLSETUP				- The spell checker setup interface

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/


global
{
  int suggest_mode          "!suggest_mode";
  int suggest_tick          "!suggest_tick";
  int suggest_count         "!suggest_count";
  str spell_str             "!spell_str";
  str suggest_phonic        "!suggest_phonic";
  str spell_phonic_chars    "!spell_phonic_chars";
  int spell_caps_mode       "!spell_caps_mode";
  int SpellIgnoreStrChng    "!SpellIgnoreStrChng";
  int spell_aux1_window     "!spell_aux1_window";
  int spell_aux2_window     "!spell_aux2_window";
  int spell_ignore_window   "!spell_ignore_window";
  int spell_list_window     "!spell_list_window";
  int spell_window          "!spell_window";
  int spell_dialog_mode     "!spell_dialog_mode";

  str spell_common_dic      "!spell_common_dic";
  str spell_main_dic        "!spell_main_dic";
  str spell_aux1_dic        "!spell_aux1_dic";
  str spell_aux2_dic        "!spell_aux2_dic";
  str spell_ignore_w        "!spell_ignore_w";
  str spell_ignore_c        "!spell_ignore_c";
  str spell_parms           "!spell_parms";
  str spell_chars           "!spell_chars";
  int spell_word_count      "!spell_word_count";
  int spell_check_mode      "!spell_check_mode";
  int spell_main_hdlg       "!spell_main_hdlg";
  int spell_line1           "!spell_line1";
  int spell_line2           "!spell_line2";
  int spell_col1            "!spell_col1";
  int spell_col2            "!spell_col2";
  str gszLanguageRecord     "!GSZ_LANGREC!";
  str gzOpenComment1        "!gzOpenComment1";
  str gzCloseComment1       "!gzCloseComment1";
  str gzEOLComment1         "!gzEOLComment1";
  str gzOpenComment2        "!gzOpenComment2";
  str gzCloseComment2       "!gzCloseComment2";
  str gzEOLComment2         "!gzEOLComment2";
}


#DEFINE _SPELL_MISSPELLED   1
#DEFINE _SPELL_DOUBLEWORD   2

#DEFINE _SPELL_CHECKDOC      0x00
#DEFINE _SPELL_CHECKWORD     0x01
#DEFINE _SPELL_CHECKBLOCK    0x02
#DEFINE _SPELL_CHECKPAGE     0x04
#DEFINE _SPELL_CHECKQUOTES   0x08
#DEFINE _SPELL_CHECKCOMMENTS 0x10
#DEFINE _SPELL_QUOTEORCOMNT 0x19
#DEFINE _SPELL_CHECKFROMTOP  0x20
#DEFINE _SPELLF_CONTINUE    0x0001

int SpellNextMiss( int op_type = parse_int("/T=", mparm_str), str &orig_word,
    int flags ) {
/*
beep;
redraw;
make_message("ENTERING SPELLNEXTMISS");
read_key;
*/
  int result = 0;
  str  tstr[80], prev_word[80] = lower(spell_str) ,word_chars[128] ;
	str  ignore_word[40], ignore_char[40] ;
  int  jy, jz, jx, tc,
      work_window, cur_dic, ignore_window, t_word_wrap ,T_Insert_Mode;
  int  min_word_size, word_count = spell_word_count,
      word_result, screen_stat, tr ;
  int common_result,
      restrict_to_block = op_type & _SPELL_CHECKBLOCK;
	int tpb = persistent_blocks;
  int get_result = 0, next_result = 0, check_result;
	char  tchar, pchar ;
  int t_line1 = block_line1,
      t_line2 = block_line2,
      t_col1 = block_col1,
      t_col2 = block_col2;

  if (op_type & _SPELL_QUOTEORCOMNT) {
    restrict_to_block = _SPELL_QUOTEORCOMNT;
    t_line1 = spell_line1;
    t_line2 = spell_line2;
    t_col1 = spell_col1;
    t_col2 = spell_col2;
  }

  working;
	persistent_blocks = TRUE;
	t_word_wrap = wrap_stat;
	T_Insert_Mode = Insert_Mode;
	Insert_Mode = true;
	work_window = window_id;
  ignore_window = spell_ignore_window;
 /*
  if (  op_type and _SPELL_CHECKWORD  ) {
		mark_pos;
	}
  */
  tstr = spell_parms;
	min_word_size = parse_int('/WS=',tstr) - 1;
  screen_stat = false; // parse_int('/SCRN=',tstr);
	wrap_stat = (parse_int('/WW=',tstr) & wrap_stat);

  word_chars = spell_chars;
  ignore_word = spell_ignore_w;
  ignore_char = spell_ignore_c;

  //make_message( prev_word );
  refresh = false;
		/* go to start of first word */

  if (!(flags & _SPELLF_CONTINUE ) )
  {

    while (  (xpos(cur_char,'|255 |9',1) != 0) & (c_col > 1)  ) {
      left;
    }

    while (  (xpos(cur_char, '|255() ''"|9[]{}+\-||=*&^%$#@!~`><,.:;?/', 1) == 0)  ) {
      if (  (c_col == 1)  ) {
        goto cdone;
      }
      left;
    }
    right;
  }
  else
  {
    forward_till_not(' |9|255');
  }

cdone:

check_to_eof:
  call spell_get_word;
  if (get_result)
  {
    call check_spelling;

    if (op_type & _SPELL_CHECKWORD) {
      goto EXIT;
    }

    if (!check_result)
    {
       goto ceof_exit;
    }
    call check_double_word;
    if (!check_result)
    {
      goto ceof_exit;
    }
  }
  call spell_next_word;
  if (next_result)
  {
    goto check_to_eof;
  }

ceof_exit:
  goto exit;

spell_message:
  make_message(str(word_count) + ' words checked...  Press <ESC> to abort.');
	ret;

replace_word:
	int  rx ;

	rx = 0;
caps_loop:
  if (caps(orig_word) == orig_word)
  {
    return_str = caps(return_str);
	} else {
    if (caps(str_char(orig_word,1)) == str_char(orig_word,1))
    {
			return_str = caps(copy(return_str,1,1)) + str_del(return_str,1,1);
		}
	}

replace_word2:
	push_undo;
	del_chars( svl(tstr) );
	Insert_Mode = True;
	text(return_str);
  if (  wrap_stat  ) {
		word_wrap_line( FALSE, TRUE );
	}
	pop_undo;
	tstr = return_str;
	ret;


spell_next_word:
	prev_word = tstr;
  next_result = 0;
	forward_till_not(' |9|255');
eolagainx:
  if (  at_eol  ) {
eolagainy:
    call spell_message;
		refresh = screen_stat;
		down;
		first_word;
    if (  at_eof  ) {
      ret;
		}
    if (restrict_to_block)
    {
       if (c_line > t_line2)
       {
        ret;
       }

       if ( restrict_to_block & _SPELL_QUOTEORCOMNT ) {
         goto BLOCK_CASE_3;
       }

       switch ( block_stat )
       {
        case  2 :

            if (t_col1 > c_col)
              goto_col(t_col1);

        case 3 :
BLOCK_CASE_3:
            if (c_line == t_line2)
            {
              if (c_col > t_col2)
              {
                ret;
              }
            }
            break;
       }
    }
    if (  (at_eol)  ) {
      prev_word = '';
      goto eolagainy;
		}
	}
  else
  if (restrict_to_block)
  {

    if (restrict_to_block & _SPELL_QUOTEORCOMNT) {
      GOTO BLOCK_CASE_3X;
    }

    switch ( block_stat )
    {
      case 2 :
        if (c_col > t_col2)
        {
          goto eolagainy;
        }
        break;

      case 3 :
BLOCK_CASE_3X:
        if (c_line == t_line2)
        {
          if (c_col > t_col2)
          {
            ret;
          }
        }
        break;
    }
  }

  next_result = TRUE;
  ret;


spell_get_word:
  get_result = 0;
	tc = c_col;
	tchar = lower(cur_char);
	jx = ascii(tchar);
  if (  (jx > 96) & (jx < 169)  ) {
		++word_count;
		refresh = screen_stat;
    forward_till( word_chars );
		orig_word = get_word_in( word_chars );
    if (!svl(orig_word))
    {
      refresh = false;
      ret;
    }
    //right;
			/* Ignore any word with an underscore in it. */
		jz = xpos('_', orig_word, 2);
    if (  jz != 0  ) {
			tstr = orig_word;
		}
    else
    {
      get_result = TRUE;
    }
			/* deal with apostrophes */
		jz = xpos('''', orig_word, 2);
    if (  jz != 0  ) {
      if (  (svl(orig_word) == (jz + 1))  ) {
        if (  lower(str_char(orig_word, jz + 1)) == 's'  ) {
					orig_word = str_del( orig_word, jz, 2 );
				}
			} else {
        if (  svl( orig_word ) == jz  ) {
					orig_word = str_del( orig_word, jz, 1 );
				}
			}
		}
		tstr = lower(orig_word);
		word_result = true;
		jx = svl(tstr);
  }
  else
  {
		tstr = tchar;
		right;
    if (  xpos(tchar, ignore_word, 1)  ) {
			tstr = lower(get_word_in(word_chars ));
			tstr = '';
		} else {
      if (  xpos(tchar, ignore_char, 1)  ) {
				right;
			}
		}
  }
  ret;

check_spelling:
    check_result = TRUE;
    if (  jx > min_word_size  ) {
				/* If the wordlength is less than 9 then check the common words
					dictionary */
      if (  jx < 9  ) {
				common_result = spell_lookup_word( tstr,4 );
			} else {
				common_result = 0;
			}
      if (  common_result == 0  ) {
        if (  spell_lookup_word( tstr, 1 ) == 0  ) {
          if (  spell_lookup_word( tstr, 2 ) == 0  ) {
            if (  spell_lookup_word( tstr, 3 ) == 0  ) {
              if (  switch_win_id( ignore_window )  ) {
								tof;
                if (  find_text('%' + tstr + '@||',0, _OldExp)  ) {
									goto_col( svl(tstr) + 2);
									return_str = get_word(' ');
									switch_win_id( work_window );
                  if (  return_str != ''  ) {
										goto_col(tc);
										call replace_word;
                    ret;
									}
                  ret;
								}
								switch_win_id( work_window );
							}
							refresh = true;
							goto_col(c_col);
							word_result = false;
							goto_col(tc);
              Set_Highlight( c_line, c_col, c_line, c_col + svl(tstr) );
              display_line;
							refresh = false;
              result = _SPELL_MISSPELLED;
              check_result = FALSE;
        do_loop:
				do_loop4:
						}
					}
				}
			}
		}
    ret;

check_double_word:
    /* process double word */
  check_result = TRUE;
  if (  prev_word == tstr  ) {
    if ( svl( tstr ) != 0 ) {
      refresh = true;
      goto_col(c_col);
      goto_col(tc);

      Set_Highlight( c_line, c_col, c_line, c_col + svl(tstr) );
      display_line;
      result = _SPELL_DOUBLEWORD;
      check_result = FALSE;
    }
  }
  ret;



abort_check:
	make_message('Spell check aborted, ' + str(word_count) + '  words checked.');
  goto exit2;


check_complete:
    //make_message('Spell check complete, ' + str(word_count) + ' words checked.');

exit:
  make_message(str(word_count) + '  word(s) checked.');
exit2:
/*  if (  op_type & _SPELL_CHECKWORD  ) {
		goto_mark;
	}
 */
	refresh = false;

  spell_word_count = word_count;
	switch_win_id( work_window );
	wrap_stat = t_word_wrap;
	return_int = 100;
	Insert_Mode = T_Insert_Mode;
	persistent_blocks = tpb;
/*
beep;
redraw;
make_message("LEAVING SPELL_NEXT_MISS");
read_key;
*/
  return(result);
}


int SpellOpenDics()
{
/*
beep;
redraw;
make_message("ENTERING SPELLOPENDICS");
read_key;
*/
  int result = 1;


  if (  SPELL_MAIN_DIC == ''  ) {
    SpellSetDef();
	}

      // Open common words dictionary
  str tstr = SPELL_COMMON_DIC;
  if (  get_path(tstr) == ''  ) {
    tstr = me_path + tstr;
	}

  if (  spell_open_dic(tstr, 4, 1, 0 ) == false  ) {
	}

      // Open main dictionary

  tstr = SPELL_MAIN_DIC;
  if (  get_path(tstr) == ''  ) {
    tstr = me_path + tstr;
	}

  if (  spell_open_dic(tstr, 1, 1, 2048 ) == false  ) {
		make_message('Cannot open main dictionary "' + global_str('SPELL_MAIN_DIC') + '".');
    result = 0;
		goto exit;
	}

      // Open aux 1 dictionary

  tstr = SPELL_AUX1_DIC;
  if (  get_path(tstr) == ''  ) {
    tstr = me_path + tstr;
	}
  if (  spell_open_dic( tstr, 2, 0, 1000 ) == false  ) {
	}

      // Open aux 2 dictionary

  tstr = SPELL_AUX2_DIC;
  if (  get_path(tstr) == ''  ) {
    tstr = me_path + tstr;
	}
  if (  spell_open_dic( tstr, 3, 0, 1000 ) == false  ) {
	}
exit:
/*
beep;
redraw;
make_message("LEAVING SPELLOPENDICS");
read_key;
*/
  return(result);
}



void SpellCloseDics()
{
  if (  switch_win_id( spell_aux1_window )) {
		delete_window;
    spell_aux1_window = 0;
	}
  if (  switch_win_id(spell_aux2_window)   ) {
		delete_window;
    spell_aux2_window = 0;
	}
  if (  switch_win_id( spell_ignore_window )  ) {
    delete_window;
    spell_ignore_window = 0;
	}

  spell_close_dic( 1 );
  spell_close_dic( 2 );
  spell_close_dic( 3 );
  spell_close_dic( 4 );
}



#DEFINE suggest_list_id 1002
#DEFINE orig_str_id     1000
#DEFINE change_str_id   1001

#DEFINE check_btn_id      100
#DEFINE ignore_btn_id     101
#DEFINE ignore_exit_id    201  // non-existent control for SPELLCHECK_SOURCE()
#DEFINE ignoreall_btn_id  102
#DEFINE change_btn_id     103
#DEFINE changeall_btn_id  104
#DEFINE addaux1_btn_id    105
#DEFINE addaux2_btn_id    106
#DEFINE setup_btn_id      107
#DEFINE lookup_btn_id     108

#DEFINE cancel_btn_id     2
#DEFINE help_btn_id       110

void SpellCheck( int m = parse_int("/M=", mparm_str))
{
/*
beep;
redraw;
make_message("ENTERING SPELLCHECK " + hex_str(m));
read_key;
*/
  str orig_word;
  int spell_result;

  spell_word_count = 0;
  spell_check_mode = m;
  if (SpellOpenDics())
  {
    int tp = persistent_blocks;
    int tr = refresh;
    persistent_blocks = TRUE;

    refresh = false;

    mark_pos;
    if ( m & _SPELL_CHECKBLOCK )
    {
      block_end;
    }
    if ( m & _SPELL_CHECKFROMTOP )
    {
      if ( m & _SPELL_CHECKBLOCK )
      {
        goto_line( block_line1);
        goto_col( block_col1);
      }
      else
      {
        tof;
      }
    }
    if (m & _SPELL_CHECKQUOTES) {
      Spell_Dialog_Mode = 0;
      SpellCheckSource(m, orig_word, 0 );
    } else if (m & _SPELL_CHECKCOMMENTS) {
      Spell_Dialog_Mode = 0;
      SpellCheckComnt(m, orig_word, 0);
    } else {
      Spell_Dialog_Mode = SpellNextMiss(m, orig_word, 0);
    }
    if (Spell_Dialog_Mode)
    {
      SpellEditDlg( m, orig_word );
    }
    SpellCloseDics();
    switch_win_id( spell_window );
    spell_check_mode = 0;
    if ( (m  & _SPELL_CHECKWORD) || (parse_int("/RC=", spell_parms)) )
    {
      goto_mark;
    }
    else
      pop_mark;
    goto_line(c_line);
    persistent_blocks = tp;
    refresh = tr;
  }
/*
beep;
redraw;
make_message("LEAVING SPELLCHECK");
read_key;
*/
}

void Spell()
{
  int dlg;
  int result;
  int m = 0;

  DlgCreate(dlg);

  DlgAddCtrl( dlg, DLG_BitmapStatic, "BT_ED_115", 4,1,0,0,2100,0,"" );

  DlgAddCtrl( dlg, DLG_GroupBox, "From", 1,DLG_Units | DLG_Units_Line_Half,12,3,2000,0,"" );
  DlgAddCtrl( dlg, DLG_RadioButton, "C&ursor", DLG_PosOffset + 1,DLG_PosOffset + 1,0,0,1000,0,"" );
  DlgSetInt(dlg, 1000, !block_stat);
  DlgAddCtrl( dlg, DLG_RadioButton, "&Top", DLG_PosOffset,DLG_PosOffset + 1,0,0,1001,0,"" );
  DlgSetInt(dlg, 1001, (block_stat != 0));

  DlgAddCtrl( dlg, DLG_GroupBox, "Options", DLG_PosOffset + 14,DLG_Units | 6,25,4,2000,0,"" );
  DlgAddCtrl( dlg, DLG_CheckBox, "&Selected text only", DLG_PosOffset + 1,DLG_PosOffset + 1,0,0,1002,0,"" );
  DlgSetInt(dlg, 1002, (block_stat != 0));
  DlgAddCtrl( dlg, DLG_CheckBox, "Text in &Quotes", DLG_PosOffset,DLG_PosOffset + 1,0,0,1003,0,"" );
  DlgAddCtrl( dlg, DLG_CheckBox, "Text in &Comments", DLG_PosOffset,DLG_PosOffset + 1,0,0,1004,0,"" );


  DlgAddCtrl( dlg, DLG_PushButton, "&Lookup word under cursor", 1,DLG_PosOffset + 2,0,0,lookup_btn_id,0,"/R=10" );
  DlgAddCtrl( dlg, DLG_PushButton, "S&etup...", DLG_PosOffset + 30,DLG_PosOffset,10,0,setup_btn_id,0,"/M=SpellSetup" );
  DlgAddCtrl( dlg, DLG_PushButton, "&Help", 44,DLG_PosOffset ,DLG_StanBtnWidth,0,help_btn_id,0,"/R=2" );

  DlgAddCtrl( dlg, DLG_PushButton, "OK", DLG_PosOffset, DLG_Units  | 6,DLG_StanBtnWidth,0,check_btn_id,DLGF_DefButton,"/R=1" );

  DlgAddCtrl( dlg, DLG_PushButton, "Cancel", Dlg_PosOffset,DLG_PosOffset | DLG_Units |
      DLG_Units_Line_Half,DLG_StanBtnWidth,0,cancel_btn_id,0,"/R=0" );


  result = DlgExecute( dlg, 1002, "Spelling", SPLCHK_HELPLINK,
            "/HOOK=SpellMsgProc", 0 );
  if (result)
  {
    int tp = persistent_blocks;

    m = _SPELL_CHECKDOC;
    if (result == 10)
    {
      m = _SPELL_CHECKWORD;
    }
    else
    {
      if (DlgGetInt( dlg, 1002))
      {
        m |= _SPELL_CHECKBLOCK;
      }
      if (dlgGetInt( dlg,1001))
      {
        m|= _SPELL_CHECKFROMTOP;
      }
      if (dlgGetInt( dlg,1003))
      {
        m|= _SPELL_CHECKQUOTES;
      }
      if (dlgGetInt( dlg,1004))
      {
        m|= _SPELL_CHECKCOMMENTS;
      }
    }

    UpdateWindow( frame_handle );
/*
beep;
make_message("m=[" + hex_str(m) + "]");
read_key;
*/
    SpellCheck( m );
  }
  DlgKill(dlg);
}
int SpellMsgProc( int &retval, int window, message, wparam, lparam, str parms ) no_break {

  switch( message )
  {
    case WM_COMMAND :
    {
      switch( wparam )
      {
// The following stuff guarantees that you can't select both in comments and in quotes
        case 1003 :
          if ((lparam >> 16) == BN_CLICKED) {
            if (SendDlgItemMessage(window, 1003, BM_GETCHECK, 0, 0)) {
              SendDlgItemMessage(window, 1004, BM_SETCHECK, 0, 0);
            }
          }
          break;
        case 1004 :
          if ((lparam >> 16) == BN_CLICKED) {
            if (SendDlgItemMessage(window, 1004, BM_GETCHECK, 0, 0)) {
              SendDlgItemMessage(window, 1003, BM_SETCHECK, 0, 0);
            }
          }
          break;
      }
    }
  }
  return(DlgMessageProc(retval, window,message,wparam,lparam, parms ));
}
 #IFDEF windows



int SpellGetCapsMode( str orig_word )
{
/*
beep;
redraw;
make_message("ENTERING SPELLGETCAPSMODE");
read_key;
*/
	int  rx ;
  int result = 0;

	rx = 0;
  if (  caps(orig_word) == orig_word ) {
    result = 1;
	} else {
    if (  caps(str_char(orig_word,1)) == str_char(orig_word,1)) {
      result = 2;
		}
	}
/*
beep;
redraw;
make_message("LEAVING SPELLGETCAPSMODE");
read_key;
*/
  return(result);
}

int SpellEditDlg( int m, str &s )
{
/*
beep;
redraw;
make_message("ENTERING SPELLEDITDLG. M=" + hex_str(m));
read_key;
*/
  int dlg;
  int  x,y, result = 0;

  int tw = window_id;
  int tr = refresh;

  refresh = false;

  create_window;
  window_attr =  0x81;
  spell_list_window = window_id;

  int list_win_num = cur_window;

  switch_win_id(tw);

  Spell_Caps_Mode = SpellGetCapsMode( s );

  Spell_Window = window_id;

  Suggest_mode = 0;
  Suggest_Tick = 0;
  Spell_Str = lower(s);
  Suggest_Count = 0;
  Suggest_Phonic = "";
  SpellIgnoreStrChng = 0;

  Spell_Phonic_Chars = "/f=ph/s=c";


  DlgCreate(dlg);

  DlgAddCtrl( dlg, DLG_BitmapStatic, "BT_ED_115", DLG_Units | 7,DLG_Units  | 6,0,0,2100,0,"" );

  DlgAddCtrl( dlg, DLG_Static, "Word not in dictionar&y:", 15,1,0,0,2000,0,"" );
  DlgAddCtrl( dlg, DLG_Text, s, DLG_PosOffset ,DLG_PosOffset + 1,30,0,orig_str_id,0,"" );
  DlgAddCtrl( dlg, DLG_Static, "Change &To:", 1,DLG_PosOffset | DLG_Units | DLG_Units_Line_Half,0,0,2001,0,"" );
  DlgAddCtrl( dlg, DLG_Text, s, DLG_PosOffset + 14,DLG_PosOffset,30,0,change_str_id,0,"" );
  DlgAddCtrl( dlg, DLG_Static, "Suggestio&ns:", 1,DLG_PosOffset + 1,0,0,2002,0,"" );
  DlgAddCtrl( dlg, DLG_ListBox,
      "W=/W=29",
   //   "W=/W=20V=/W=10",
      //"",
      DLG_PosOffset + 14,DLG_PosOffset,30,3,suggest_list_id,DLGF_LBIncSearch,"/WIN=" + str(list_win_num) );

  DlgAddCtrl( dlg, DLG_PushButton, "&Ignore", DLG_PosOffset + 33, DLG_Units | 4,14,0,ignore_btn_id,DLGF_DefButton,"" );
  DlgGetCR( dlg, ignore_btn_id,x, y );
  DlgAddCtrl( dlg, DLG_PushButton, "I&gnore All", DLG_PosOffset + 15,DLG_PosOffset,14,0,ignoreall_btn_id,0,"" );
  DlgAddCtrl( dlg, DLG_PushButton, "&Change", x,DLG_PosOffset | DLG_Units  | 17,14,0,change_btn_id,0,"" );
  DlgAddCtrl( dlg, DLG_PushButton, "Change A&ll", DLG_PosOffset + 15,DLG_PosOffset,14,0,changeall_btn_id,0,"" );
  DlgAddCtrl( dlg, DLG_PushButton, "&Add to Aux1", x,DLG_PosOffset | DLG_Units  | 17,14,0,addaux1_btn_id,0,"" );
  DlgAddCtrl( dlg, DLG_PushButton, "Add to Aux&2", DLG_PosOffset + 15,DLG_PosOffset,14,0,addaux2_btn_id,0,"" );
  DlgAddCtrl( dlg, DLG_PushButton, "Cancel", x,DLG_PosOffset | DLG_Units |
      (DLG_Units_Per_Line + DLG_Units_Line_Half),14,0,cancel_btn_id,0,"/R=0" );
  DlgAddCtrl( dlg, DLG_PushButton, "&Help", DLG_PosOffset + 15,DLG_PosOffset,14,0,help_btn_id,0,"/R=2" );

  result = DlgExecute( dlg, change_str_id,"Spelling",
            SPLCHKSETUP_HELPLINK, "/HOOK=SpellMessageProc //SM=" + str(m), 0 );
  switch ( result )
  {
    case 12 :
    case 13 :
        s = DlgGetStr( dlg, change_str_id );
  }
  DlgKill(dlg);
  switch_window(list_win_num);
  delete_window;
  switch_win_id(tw);
  refresh = tr;
  Suggest_mode = 0;
  Suggest_Tick = 0;
  Suggest_Count = 0;
  Spell_Str = "";
  Suggest_Phonic = "";
  Spell_Caps_Mode = 0;
  SpellIgnoreStrChng = 0;
  spell_word_count = 0;
/*
beep;
redraw;
make_message("LEAVING SPELLEDITDLG");
read_key;
*/
  return( result );
}


int SpellNextSuggest( str tstr[128] )
{
/*
beep;
redraw;
make_message("ENTERING SPELLNEXTSUGGEST");
read_key;
*/
  char lchar;
  int result = 0,m = suggest_mode, dic,jx;
  int tw = cur_window;
  int tr = refresh;
  str tstr2[128] = "";
  refresh = false;
  switch_win_id( spell_list_window  );
  switch ( m )
  {
    case 0 :
            lchar = copy(tstr,1,1);
            if (  !spell_lookup_word( lchar, 1 )  ) {
              m = -1;
              break;
            }

    case 1 :
            m=1;
            dic = 1;
            call add_spell;
            if (m != -1)
              break;

            if ( !spell_lookup_word( '', 2 )  ) {
              m = -1;
              break;
            }

    case 2 :
            m=2;
            dic=2;
            call add_spell;
            if (m != -1)
              break;

            suggest_phonic = parse_str("/" + copy(tstr,1,1) + '=',spell_phonic_chars );
            if ( suggest_phonic == "" )
            {
              m = -1;
              break;
            }

            if ( !spell_lookup_word( suggest_phonic, 1 )  ) {
              m = -1;
              break;
            }

    case 3 :
            m=3;
            tstr = suggest_phonic  + copy(tstr,length(suggest_phonic) + 1, 128 );
            dic=1;
            call add_spell;
            if (m != -1)
              break;


            if ( !spell_lookup_word( '', 2 )  ) {
              m = -1;
              break;
            }
    case 4 :
            m=4;
            tstr = suggest_phonic  + copy(tstr,length(suggest_phonic) + 1, 128 );
            dic=2;
            call add_spell;

  }
  switch_window( tw );
  refresh = tr;
  Suggest_Mode = m;
/*
beep;
redraw;
make_message("LEAVING SPELLNEXTSUGGEST");
read_key;
*/
  return(result);

add_spell:
  tstr2 = spell_next_match( tstr, dic );
  if (  svl(tstr2) != 0  ) {
    if ( suggest_phonic != "" )
    {
      if (copy(tstr2,1,length(suggest_phonic)) != suggest_phonic)
        ret;
      --return_int;
    }
    switch ( spell_caps_mode )
    {
      case 1 :
          tstr2=caps(tstr2);
          break;

      case 2 :
          tstr2=caps(str_char(tstr2,1)) + copy(tstr2,2,128);
    }
    tstr2= char(250  - return_int) + "W=" + tstr2;// + "V=" + str(return_int);
    mark_pos;
    tof;
    do
    {
      if (at_eof)
      {
        goto do_put;
      }
      if (tstr2 == get_line)
        break;
      if (tstr2 < get_line)
      {
        goto_col(1);
        cr;
        up;
      do_put:
        result = 1;
        put_line(tstr2);
        ++suggest_count;
        break;
      }
      down;
    }
    while (TRUE);
    goto_mark;

  }
  else
  {
    m = -1;
  }
  ret;

}

#DEFINE SPSET_TOORIG    0
#DEFINE SPSET_TOCHANG   1
#DEFINE SPSET_EDITCHANG 2
#DEFINE SPSET_REPLACE   3
#DEFINE SPSET_NEXT      4
#DEFINE SPSET_ADDIGNORE 5
#DEFINE SPSET_ADDAUX1   6
#DEFINE SPSET_ADDAUX2   7
#DEFINE SPSET_SETUPDLG  8
#DEFINE SPSET_REPLACEALL 9
#DEFINE SPSET_SUGGEST   10


int SpellSetStr( int window, int m )
{
/*
beep;
redraw;
make_message("ENTERING SPELLSETSTR");
read_key;
*/
  str tstr[129],tstr2[129];
  int jx;
  int tr = refresh;
  int tw = cur_window;
  int result = 0;
  int ti = insert_mode;

  switch(m)
  {
    case SPSET_SUGGEST :
      refresh = false;
      switch_win_id( spell_list_window );
      SetDlgItemText( window, change_str_id, parse_str("W=", get_line) );
      switch_window(tw);
      refresh = tr;
      break;

    case SPSET_TOORIG :
      SpellIgnoreStrChng = 1;
      SendDlgItemMessage( window, orig_str_id, EM_SETSEL, 0, Make_Long( 0, -1 ) );
      GetDlgItemText( window, orig_str_id, tstr, 128 );
      SetDlgItemText( window, change_str_id, tstr );
      SetDefaultButton( window, 100);
      SetFocus( GetDlgItem( window,change_str_id ) );
      SendDlgItemMessage( window, change_str_id, EM_SETSEL, 0, Make_Long( 0, -1 ) );
      break;

    case SPSET_TOCHANG :
      refresh = false;
      switch_win_id( spell_list_window );
      tof;
      if (!at_eof)
      {

        GetDlgItemText( window, orig_str_id,   tstr, 128 );
        GetDlgItemText( window, change_str_id, tstr2, 128 );

        if (tstr2 == tstr )
        {
          SpellIgnoreStrChng = 1;
          refresh = false;
          switch_win_id( spell_list_window );
          SetDlgItemText( window, change_str_id, parse_str("W=", get_line) );
          switch_window(tw);
          refresh = tr;
        }
      }
      switch_window( tw );
      refresh = tr;
      SetFocus( GetDlgItem( window,change_str_id ) );
      SendDlgItemMessage( window, change_str_id, EM_SETSEL, 0, Make_Long( 0, -1 ) );
      break;

    case SPSET_EDITCHANG :
      if ( SpellIgnoreStrChng )
      {
        SpellIgnoreStrChng = 0;
      }
      else
      {
        if (spell_dialog_mode == 2)
        {

          GetDlgItemText( window, change_str_id, tstr2, 128 );
          if ((tstr2 == spell_str) || (tstr2 == ""))
          {
            SetDlgItemText( window, change_btn_id, "&Delete" );
          }
          else
          {
            SetDlgItemText( window, change_btn_id, "&Change" );
          }
          jx = getdefaultbutton(window);
          if ( jx != change_btn_id)
          {
            SetDefaultButton(window, change_btn_id );
          }
        }
        else
        {
          jx = getdefaultbutton(window);
          if (( jx != change_btn_id) && (jx != changeall_btn_id))
          {
            SetDefaultButton(window, change_btn_id );
          }
        }
      }
      break;

    case SPSET_ADDIGNORE :
      tstr2 = spell_str + "|";
      call add_ignore;
      break;

    case SPSET_ADDAUX1 :
      insert_mode = true;
      refresh = false;

      spell_close_dic( 2 );

      tstr2 = spell_str;
      if (!switch_win_id( spell_aux1_window))
      {
        create_window;
        window_attr = 0x81;
        tstr = spell_aux1_dic;
        if (  tstr != ''  ) {
          if (  get_path(tstr) == ''  ) {
            tstr = me_path + tstr;
          }
          load_file( tstr );
          if (  error_level != 0  ) {
            error_level = 0;
            file_name = tstr;
          }
        }
        spell_aux1_window = window_id;
      }
      call add_word_to_file;
      save_file;
      spell_open_dic( file_name, 2, 0, 1000);
      switch_window( tw );
      refresh = TR;
      insert_mode = TI;
      break;

    case SPSET_ADDAUX2 :
      insert_mode = true;
      refresh = false;

      spell_close_dic( 3 );

      tstr2 = spell_str;
      if (!switch_win_id( spell_aux2_window))
      {
        create_window;
        window_attr = 0x81;
        tstr = spell_aux2_dic;
        if (  tstr != ''  ) {
          if (  get_path(tstr) == ''  ) {
            tstr = me_path + tstr;
          }
          load_file( tstr );
          if (  error_level != 0  ) {
            error_level = 0;
            file_name = tstr;
          }
        }
        spell_aux2_window = window_id;
      }
      call add_word_to_file;
      save_file;
      spell_open_dic( file_name, 3, 0, 1000);
      switch_window( tw );
      refresh = TR;
      insert_mode = TI;
      break;


    case SPSET_REPLACEALL :
    case SPSET_REPLACE : {

      str repl_str = spell_str;

      insert_mode = true;
      refresh = false;
      switch_win_id( spell_window );
      push_undo;
      if (spell_dialog_mode == 2)
      {
        if (  c_col > 1  ) {
          left;
          if (  cur_char == ' '  ) {
            del_char;
          } else {
            right;
          }
        }
        del_chars(length(spell_str));
      }
      else
      {
        del_chars(length(spell_str));
        GetDlgItemText( window, change_str_id, tstr2, 128 );
        text(  tstr2 );
        spell_str = tstr2;
      }
      pop_undo;
      if ( m == SPSET_REPLACEALL )
      {
        tstr2 = lower(repl_str) + "|" + lower(tstr2);
        call add_ignore;
      }

      refresh = true;
      display_line;
      refresh = tr;
      insert_mode = ti;
      break;
    }
    case SPSET_SETUPDLG :
      call setup_dialog;
      break;

    case SPSET_NEXT :
      switch_win_id( spell_window );
      result = SpellNextMiss( spell_check_mode, tstr, _SPELLF_CONTINUE );
      if (result)
      {
        Spell_Dialog_Mode = result;
        call Setup_Dialog;
        refresh = false;
        Spell_Caps_Mode = SpellGetCapsMode( tstr );
        Spell_Str = lower(tstr);
        Suggest_Count = 0;
        Suggest_Phonic = "";
        SpellIgnoreStrChng = 0;
        SetDlgItemText( window, orig_str_id, tstr );
        if (result != 2)
        {
          SetDlgItemText( window, change_str_id, tstr );
        }
        else
        {
          SetDlgItemText( window, change_str_id, "" );
        }
        SetDefaultButton( window, ignore_btn_id );
        switch_win_id( spell_list_window );
        erase_window;
        SendDlgItemMessage( window, suggest_list_id, LB_RESETCONTENT,0, 0);
        window_attr = 0x81;
        switch_window( tw );
        refresh = tr;
        SetFocus( GetDlgItem( window,change_str_id ) );
        SendDlgItemMessage( window, change_str_id, EM_SETSEL, 0, Make_Long( 0, -1 ) );
      }
      break;
  }
/*
beep;
redraw;
make_message("LEAVING SPELLSETSTR");
read_key;
*/
  return(result);

/* eliminates duplicates */
add_word_to_file:
	tof;
  find_text('^' + copy(tstr2,1,1), 0, _RegExp );
  while (  not(at_eof) & (get_line < tstr2)  ) {
		down;
	}
	goto_col(1);
  if (  get_line != tstr2  ) {
    if (  not(at_eof)  ) {
			cr;
			up;
		}
		put_line(tstr2);
  }
  tof;
	ret;


setup_dialog:
  if (Spell_Dialog_Mode == _SPELL_DOUBLEWORD)
  {
    SetDlgItemText( window, 2000, "Re&peated word:" );
    SetDlgItemText( window, change_btn_id, "&Delete" );
    EnableWindow( GetDlgItem(window, ignoreall_btn_id), false );
    EnableWindow( GetDlgItem(window, changeall_btn_id), false );
    EnableWindow( GetDlgItem(window, addaux1_btn_id), false );
    EnableWindow( GetDlgItem(window, addaux2_btn_id), false );
    Suggest_mode = -1;
  }
  else
  {
    SetDlgItemText( window, 2000,"Word not in dictionar&y:");
    SetDlgItemText( window, change_btn_id, "&Change" );
    EnableWindow( GetDlgItem(window, ignoreall_btn_id), true );
    EnableWindow( GetDlgItem(window, changeall_btn_id), true );
    EnableWindow( GetDlgItem(window, addaux1_btn_id), true );
    EnableWindow( GetDlgItem(window, addaux2_btn_id), true );
    Suggest_mode = 0;
  }
  ret;

add_ignore:
  {
    insert_mode = true;
    refresh = false;
    if (!switch_win_id( spell_ignore_window))
    {
      create_window;
      window_attr = 0x81;
      spell_ignore_window = window_id;
    }
    call add_word_to_file;
    switch_window( tw );
    refresh = TR;
    insert_mode = TI;
    ret;
  }
}

int SpellMessageProc( int &retval, int window, message, wparam, lparam, str parms ) no_break
{

//beep;
//redraw;
//make_message("ENTERING SPELLMESSAGEPROC");
//read_key;

  switch( message )
  {
    case WM_TIMER :
    {
      if (suggest_mode != -1)
      {
        if (SpellNextSuggest(spell_str) != 0)
        {
          SendDlgItemMessage(window, suggest_list_id, LB_ADDSTRING,0,0 );
          SendDlgItemMessage(window, suggest_list_id, WM_ML2_REDRAW,0,0 );
          //RedrawWindow( GetDlgItem(window,suggest_list_id), 0,0, rdw_Invalidate );
        /*  if (suggest_count == 1)
          {
            SendDlgItemMessage(window, suggest_list_id, LB_SETCURSEL,0,0 );
          }*/
        }

        if (suggest_mode == -1)
        {
          SpellSetStr(window, SPSET_TOCHANG);
        }
      }
      return(1);
    }

    case WM_DESTROY :
    {
      KillTimer( window, 1 );
      break;
    }


    case WM_COMMAND :
    {
      wm_command_again:
      switch( wparam )
      {
        case 998 :
            wparam = GetDefaultButton( window );
            if(wparam)
            {
              PostMessage( window, WM_COMMAND, wparam, lparam );
            }
            return(1);
            break;

        case DLG_WCMD_INIT :
            Spell_Main_Hdlg = window;
            SpellSetStr(window, SPSET_SETUPDLG );
            SetTimer( window, 1,50, 0 );
            break;

        case orig_str_id :
            if ((lparam >> 16) == en_SetFocus)
            {
              SpellSetStr( window,SPSET_TOORIG );
            }
            break;

        case change_str_id :
            if ((lparam >> 16) == en_Change)
            {
              SpellSetStr(window,SPSET_EDITCHANG);
            }
            break;

        case suggest_list_id :
            switch ( lparam >> 16 )
            {
              case LBN_SELCHANGE :
                      SpellSetStr(window, SPSET_SUGGEST);
                      break;
            }
            break;

        case change_btn_id :
            SpellSetStr(window, SPSET_REPLACE);
            call spell_next;
            return(1);

        case changeall_btn_id :
            SpellSetStr(window, SPSET_REPLACEALL);
            call spell_next;
            return(1);

        case addaux1_btn_id :
            SpellSetStr(window, SPSET_ADDAUX1 );
            call spell_next2;
            return(1);

        case addaux2_btn_id :
            SpellSetStr(window, SPSET_ADDAUX2 );
            call spell_next2;
            return(1);

        case ignoreall_btn_id :
            SpellSetStr(window, SPSET_ADDIGNORE );
            call spell_next2;
            return(1);


        case ignore_btn_id :
            call spell_next2;
            return(1);
        break;

        case ignore_exit_id :
//            DestroyWindow(spell_main_hdlg);
SET_GLOBAL_INT("!SPELL_SOURCE_FLAG",1);
            postmessage(window, WM_COMMAND, 2, 0);
            return(ignore_exit_id);
            break;
      }
    }
  }
  return(DlgMessageProc(retval, window,message,wparam,lparam, parms ));

spell_next2:
/*
if (parse_int("/SM=",parms) & _SPELL_CHECKWORD) {
beep;
RET;
}
*/
  Switch_Win_Id( spell_window );
  goto_col( c_col + length( spell_str ) + 1);
spell_next:
/*
beep;
make_message("PARMS=[" + parms + "]" + str(parse_int("/SM=",parms) & _SPELL_CHECKQUOTES));
read_key;
*/
/*
if (parse_int("/SM=",parms) & _SPELL_CHECKWORD) {
beep;
RET;
}
*/
  if (parse_int("/SM=",parms) & _SPELL_QUOTEORCOMNT) {
    postmessage(window, WM_COMMAND, ignore_exit_id, 0);
  } else {
    if (!SpellSetStr(window, SPSET_NEXT)) {
//beep;
      postmessage(window, WM_COMMAND, 2, 0);
    }
  }
  ret;
}

macro spelltest
{
  str tstr = "Sensur";

  spell_open_dic(me_path + "me.dic", 1, 1, 2048 );
  spell_open_dic(me_path + "auxdic.txt", 2, 0, 2048 );
  make_message(str(SpellEditDlg( 0,tstr )));

  spell_close_dic(1);
  spell_close_dic(2);
}
 #ENDIF

/*******************************************************************************
																MULTI_EDIT MACRO

Name:  SpellSetDef

Description: Retrieves spell check setup parameters from disk.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
void SpellSetDef() {
		int  t2 = Window_Id;

		refresh = false;
    spell_chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_''';
    RM('SETCONFIG /DB=MECONFIG/T=SPELLSET.ME');
    if ( LocateDbPage( "MECONFIG.DB", "SPELLSET.ME", false)  )
    {
      down;
      spell_common_dic = get_line; down;
      spell_main_dic   = get_line; down;
      spell_aux1_dic   = get_line; down;
      spell_aux2_dic   = get_line; down;
      spell_ignore_w   = get_line; down;
      spell_ignore_c   = get_line; down;
      spell_parms      = get_line; down;
      Goto_Col(1);
      if ((at_eof == False) & (Cur_Char != '|12')) {
        spell_chars = get_line;
      }
    } else {
      spell_common_dic =  'COMMON.DIC';
      spell_main_dic   =  'ME.DIC';
      spell_aux1_dic   =  'AUXDIC.TXT';
      spell_aux2_dic   =  'AUXDIC2.TXT';
      spell_ignore_w   =  '.@<';
      spell_ignore_c   =  '^';
      spell_parms      =  '/WS=1/SCRN=0/WW=0';
    }
		switch_win_id(t2);
		update_status_line;
}

int spell_in_comment() {
  int ret_value  = 0,
      maybe = 0,
      t_refresh = refresh;
  str szFilExt,
      szExtRef,
      szLanguageType;

  refresh = false;
  szFilExt = get_extension(file_name);
  rm('FIND_EXT /EXT=.'+szFilExt);
  szExtRef = return_str;
  szLanguageType = parse_str('LS=',global_str(szExtRef));

  rm('GET_DB_RECORD '
        +'/F=MECONFIG'
        +'/NDF=1'
        +'/DPT=LANGUAGE.DB'
        +'/GLO=!GSZ_LANGREC!'
        +'/DBF=LANG'
        +'/FV='+szLanguageType
  );

  if ( return_int == 1 )
  {
    gzOpenComment1  = parse_str('OC1=',gszLanguageRecord);
    gzCloseComment1 = parse_str('CC1=',gszLanguageRecord);
    gzEOLComment1   = parse_str('EOL=',gszLanguageRecord);
    gzOpenComment2  = parse_str('OC2=',gszLanguageRecord);
    gzCloseComment2 = parse_str('CC2=',gszLanguageRecord);
    gzEOLComment2   = parse_str('EOL2=',gszLanguageRecord);
// see if we are in an enclosed comment
    mark_pos;

    if (line_stat & 0x10) {
      maybe = 1;
    } else {
      up;
      if (line_stat & 0x10) {
        maybe = 2;
      }
      down;
    }
    if (maybe == 1) {
      do {
        up;
      } while (line_stat & 0x10);
      down;
      eol;
      if (search_bwd(make_literal(gzOpenComment1),1)) {
        ret_value = 1;
      } else if (search_bwd(make_literal(gzOpenComment2),1)) {
        ret_value = 1;
      }
    } else if (maybe == 2) {
      if (((xpos(gzCloseComment1,get_line,1) >= c_col)) ||
          (xpos(gzCloseComment2,get_line,1) >= c_col)) {
        ret_value = 1;
      }
    }

    goto_mark;
// check to see if we are in a 1 line comment
    if (((xpos(gzEOLComment1,get_line,1) > 0) &&
        (xpos(gzEOLComment1,get_line,1) < c_col)) ||
       ((xpos(gzEOLComment2,get_line,1) > 0) &&
        (xpos(gzEOLComment2,get_line,1) < c_col))) {
      ret_value |= 2;
    }
  }

  refresh = t_refresh;
//make_message(hex_str(ret_value));
  Return(ret_value);
}

int SpellNextComment() {
  int ret_value = 0,
      already_in_one = ((spell_in_comment() & 2) != 0);

  if (spell_in_comment() & 2) {
    down;
    goto_col(1);
    RETURN(1);
  }
  mark_pos;
  while ((!at_eof) && (!spell_in_comment())) {
    down;
    eol;
  }
  if (at_eof) {
    goto_mark;
  } else {
    ret_value = 1;
    if (Already_in_one) {
      goto_mark;
    } else {
      pop_mark;
      while ((spell_in_comment) && (c_col > 1)) {
        left;
      }
      if (!spell_in_comment) {
        right;
      }
    }
  }

  return(ret_value + already_in_one);
}

int spellendcomment() {
  int comment_type = spell_in_comment(),
      ret_value = 1;

  mark_pos;
  if (comment_type == 2) {
    pop_mark;
    eol;
  } else if (comment_type == 1) {
// find the end of the closed comment
    pop_mark;
    if (!Search_Fwd(make_literal(gzCloseComment1),0)) {
      if (!Search_Fwd(make_literal(gzCloseComment2),0)) {
        eof;
      }
    }
  } else {
    goto_mark;
    ret_value = 0;
  }
  RETURN(ret_value);
}

int spell_in_block(int t_line1, t_line2, t_col1, t_col2, t_stat) {
// returns true if cursor is in a block defined by above arguments
// this way it can be used for more than just marked blocks
  int ret_value = 0;

  if ((c_line >= t_line1) && (c_line <= t_line2)) {
    switch (t_stat) {
    case 1 :
      ret_value = 1;
      break;
    case  2 :
      if ((c_col >= t_col1) || (c_col <= t_col2)) {
        ret_value = 1;
      }
      break;
    case 3 :
      if (((c_line > t_line1) && (c_line < t_line2))
        || ((c_line == t_line1) && (c_col > t_col1))
        || ((c_line == t_line2) && (c_col < t_col2))) {
        ret_value = 1;
      }
      break;
    }
  }


  RETURN(Ret_Value);
}

int SpellCheckComnt(int m, str &tstr, int go_on ) {

/*******************************************************************************
																MULTI_EDIT MACRO

Name: SpellCheckCmnt

Description: Goes through a source file, from the current cursor position
  and spell checks all text that is in comments.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
/*
beep;
redraw;
make_message("ENTERING SPELLCHECKSOURCE");
read_key;
*/
   int    result = 0
          ,tpb = persistent_blocks
          , use_block = m & _SPELL_CHECKBLOCK
          ,spell_flag = 0
          ;


  persistent_blocks = TRUE;
  if (go_on)
  {
    goto do_go_on;
  }
  while (spellnextcomment()) {
		RIGHT;
    if (use_block) {
      if (!Spell_in_block(block_line1,
                          block_line2,
                          block_col1,
                          block_col2,
                          block_stat)) {
        break;
      }
    }
 //   Str_Block_Begin;
    spell_line1 = c_line;
    spell_col1 = c_col;

    if (!(spellendcomment())) {
/*
beep;
redraw;
make_message("NOT FOUND!!");
read_key;
*/
      continue;
		}
//    block_End;
    spell_line2 = c_line;
    spell_col2 = c_col;
//    Goto_Line( block_line1 );
//    goto_col( block_col1 );
    Goto_Line( spell_line1 );
    goto_col( spell_col1 );
		refresh = TRUE;
		redraw;
/*
beep;
redraw;
make_message("parked at [" + copy(get_line, c_col, 50) + "]");
read_key;
*/
do_go_on:
SET_GLOBAL_INT("!SPELL_SOURCE_FLAG",0);
//    result = SpellNextMiss( _SPELL_CHECKBLOCK, tstr, _SPELLF_CONTINUE  );
    result = SpellNextMiss( _SPELL_CHECKCOMMENTS, tstr, spell_flag  );
    spell_flag = _SPELLF_CONTINUE;
    if (result) {
      if (SpellEditDlg( m, tstr ) == 0) {
/*
beep;
redraw;
make_message("Flag=" + str(GLOBAL_INT("!SPELL_SOURCE_FLAG")));
read_key;
*/
if (GLOBAL_INT("!SPELL_SOURCE_FLAG")) {
    if (c_line == spell_line2) {
      if (c_col < spell_col2) {
        goto DO_GO_ON;
      }
    } else {
      goto DO_GO_ON;
    }
} else {
        break;
}
SET_GLOBAL_INT("!SPELL_SOURCE_FLAG",0);
      }
    }
//    goto_line(block_line2);
//    goto_col(block_col2 + 2);
    goto_line(spell_line2);
    goto_col(spell_col2 + 2);
/*
beep;
redraw;
make_message("result=" + str(result));
read_key;
*/
	}
  persistent_blocks = tpb;
/*
beep;
redraw;
make_message("LEAVING SPELLCHECK_SOURCE");
read_key;
*/
SET_GLOBAL_INT("!SPELL_SOURCE_FLAG",0);
  return(result);
}


int SpellCheckSource(int m, str &tstr, int go_on ) {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: SpellCheckSource

Description: Goes through a source file, from the current cursor position
	and spell checks all text that is in between single, or double quotes.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
/*
beep;
redraw;
make_message("ENTERING SPELLCHECKSOURCE");
read_key;
*/
   int    result = 0
          ,tpb = persistent_blocks
          , use_block = m & _SPELL_CHECKBLOCK
          , spell_flag = 0
          ;
  str end_str;

  persistent_blocks = TRUE;
  if (go_on)
  {
    goto do_go_on;
  }

  while (  find_text('[''"]',0, _RegExp)  ) {
/*
beep;
refresh = true;
redraw;
make_message("FOUND");
read_key;
*/
		RIGHT;
    if (use_block) {
      if (!Spell_in_block(block_line1,
                          block_line2,
                          block_col1,
                          block_col2,
                          block_stat)) {
        break;
      }
    }
 //   Str_Block_Begin;
    spell_line1 = c_line;
    spell_col1 = c_col;
/*
beep;
refresh = true;
redraw;
make_message("BEFORE SECOND SEARCH");
read_key;
*/

    end_str = found_str;

    if (!(find_text(found_str,1,0))) {
/*
beep;
redraw;
make_message("NOT FOUND!!");
read_key;
*/
      continue;
		}
//    block_End;
    spell_line2 = c_line;
    spell_col2 = c_col;
//    Goto_Line( block_line1 );
//    goto_col( block_col1 );
    Goto_Line( spell_line1 );
    goto_col( spell_col1 );
		refresh = TRUE;
		redraw;
/*
beep;
redraw;
make_message("parked at [" + copy(get_line, c_col, 50) + "]");
read_key;
*/
do_go_on:
SET_GLOBAL_INT("!SPELL_SOURCE_FLAG",0);
    result = SpellNextMiss( _SPELL_CHECKQUOTES, tstr,  spell_flag );
    spell_flag = _SPELLF_CONTINUE;
    if ( result )
    {
      if (SpellEditDlg( m, tstr ) == 0) {
if (GLOBAL_INT("!SPELL_SOURCE_FLAG")) {
    if (c_line == spell_line2) {
      if (c_col < spell_col2) {
        goto DO_GO_ON;
      }
    } else {
      goto DO_GO_ON;
    }
} else {
        break;
}
SET_GLOBAL_INT("!SPELL_SOURCE_FLAG",0);
      }
    }
//    goto_line(block_line2);
//    goto_col(block_col2 + 2);
/*
beep;
redraw;
make_message("Before moving cursor");
read_key;
*/
    goto_line(spell_line2);
    goto_col(spell_col2 + 2);
/*
beep;
redraw;
make_message("After moving cursor");
read_key;
*/
/*
beep;
redraw;
make_message("result=" + str(result));
read_key;
*/
	}
  persistent_blocks = tpb;
/*
beep;
redraw;
make_message("LEAVING SPELLCHECK_SOURCE");
read_key;
*/
SET_GLOBAL_INT("!SPELL_SOURCE_FLAG",0);
  return(result);
}


void SpellSetup() {
/*******************************************************************************
																MULTI_EDIT MACRO

Name:  SpellSetup

Description: A setup interface for the spell checker.

Parameters:

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
    int     dlg,
            T_Insert_Mode = Insert_Mode,
						Count,
						tw = Window_Id;

		refresh = false;

    if (  spell_main_dic == ''  ) {
      SpellSetDef();
		}

    DlgCreate(dlg);

    DlgAddCtrl( dlg, DLG_BitmapStatic, "BT_ED_115", 4,2, 0, 0, 2101, 0, "" );
    DlgAddCtrl( dlg, DLG_GroupBox, "Options", 14,1, 44, 3, 2100, 0, "" );

    DlgAddCtrl( dlg, DLG_CheckBox, "Re&turn cursor to original position", DLG_PosOffset + 1,DLG_PosOffset + 1, 0, 0, 1007, 0, "" );
    DlgSetInt( dlg, 1007,parse_int('/RC=', spell_parms));

    DlgAddCtrl( dlg, DLG_CheckBox, "&Reformat paragraph if Word Wrap is on", DLG_PosOffset,Dlg_PosOffset + 1, 0, 0, 1008, 0, "" );
    DlgSetInt( dlg, 1008,parse_int('/WW=', spell_parms));

    DlgAddCtrl( dlg, DLG_Static, "&Common words dictionary:", 1,5, 0, 0, 2000, 0, "" );
    DlgAddCtrl( dlg, DLG_Text, spell_common_dic, DLG_PosOffset + 30,DLG_PosOffset, 30, 0, 1000, 0, "/ML=80" );
    DlgAddCtrl( dlg, DLG_Static, "&Main dictionary:", 1,DLG_PosOffset + 1, 0, 0, 2001, 0, "" );
    DlgAddCtrl( dlg, DLG_Text, spell_main_dic, DLG_PosOffset + 30,DLG_PosOffset, 30, 0, 1001, 0, "/ML=80" );
    DlgAddCtrl( dlg, DLG_Static, "&Auxiliary dictionary 1:", 1,DLG_PosOffset + 1, 0, 0, 2002, 0, "" );
    DlgAddCtrl( dlg, DLG_Text, spell_aux1_dic, DLG_PosOffset + 30,DLG_PosOffset, 30, 0, 1002, 0, "/ML=80" );
    DlgAddCtrl( dlg, DLG_Static, "Auxiliary dictionary &2:", 1,DLG_PosOffset + 1, 0, 0, 2003, 0, "" );
    DlgAddCtrl( dlg, DLG_Text, spell_aux2_dic, DLG_PosOffset + 30,DLG_PosOffset, 30, 0, 1003, 0, "/ML=80" );
    DlgAddCtrl( dlg, DLG_Static, "&Ignore word after these chars:", 1,DLG_PosOffset + 1, 0, 0, 2004, 0, "" );
    DlgAddCtrl( dlg, DLG_Text, spell_ignore_w, DLG_PosOffset + 30,DLG_PosOffset, 30, 0, 1004, 0, "/ML=80" );
    DlgAddCtrl( dlg, DLG_Static, "I&gnore char after these chars:", 1,DLG_PosOffset + 1, 0, 0, 2005, 0, "" );
    DlgAddCtrl( dlg, DLG_Text, spell_ignore_c, DLG_PosOffset + 30,DLG_PosOffset, 30, 0, 1005, 0, "/ML=80" );
    DlgAddCtrl( dlg, DLG_Static, "&Minimum word size:", 1,DLG_PosOffset + 1, 0, 0, 2006, 0, "" );
    DlgAddCtrl( dlg, DLG_Integer, "", DLG_PosOffset + 30,DLG_PosOffset, 5, 0, 1006, 0, "" );
    DlgSetInt( dlg, 1006,parse_int('/WS=', spell_parms));

    DlgAddCtrl( dlg, DLG_Static, "&Valid word characters:", 1,DLG_PosOffset + 1, 0, 0, 2009, 0, "" );
    DlgAddCtrl( dlg, DLG_Text, spell_chars, DLG_PosOffset + 30,DLG_PosOffset, 30, 0, 1009, 0, "" );

    DlgAddCtrl( dlg, DLG_PushButton, "OK", 1,DLG_PosOffset + 2, DLG_StanBtnWidth, 0, 100, DLGF_DefButton, "/R=1" );
    DlgAddCtrl( dlg, DLG_PushButton, "Cancel", DLG_PosOffset + DLG_StanBtnWidth + 1,DLG_PosOffset, DLG_StanBtnWidth, 0, 101, 0, "/R=0" );
    DlgAddCtrl( dlg, DLG_PushButton, "&Help", DLG_PosOffset + 39,DLG_PosOffset, Dlg_StanBtnWidth, 0, 102, 0, "/R=2" );


    if (DlgExecute( dlg, 1000,"Spellcheck Setup",
					"SPELL CHECKER SETUP","", 0 ))
    {
      spell_common_dic = DlgGetStr( dlg, 1000 );
      spell_main_dic   = DlgGetStr( dlg, 1001 );
      spell_aux1_dic   = DlgGetStr( dlg, 1002 );
      spell_aux2_dic   = DlgGetStr( dlg, 1003 );
      spell_ignore_w   = DlgGetStr( dlg, 1004 );
      spell_ignore_c   = DlgGetStr( dlg, 1005 );
      spell_parms      =  '/WS=' + str(DlgGetInt( dlg, 1006))
                            + '/RC=' + str(DlgGetInt(dlg,1007))
                            + '/WW=' + str(DlgGetInt(dlg,1008));
      spell_chars      = DlgGetStr( dlg, 1009 );
 /* now save the configuration */
      if (LocateDbPage("MECONFIG.DB", "SPELLSET.ME", TRUE ))
      {
/* If there is existing configuration options, delete them */
				Down;
				Goto_Col(1);
        while (  ((At_Eof == False) & (Cur_Char != '|12'))  ) {
					Del_Line;
				}
				Up;
        Insert_Mode = True;
        Eol;
        Cr;
        put_line( spell_common_dic );
        eol; cr;
        put_line( spell_main_dic );
        eol; cr;
        put_line( spell_aux1_dic );
        eol; cr;
        put_line( spell_aux2_dic );
        eol; cr;
        put_line( spell_ignore_w );
        eol; cr;
        put_line( spell_ignore_c );
        eol; cr;
        put_line( spell_parms );
        eol; cr;
        put_line( spell_chars );
      }
    }

    DlgKill(dlg);
		switch_win_id(tw);
		update_status_line;
		Insert_Mode = T_Insert_Mode;
		return_int = 0;
    return();
}