// $Header: /MEWIN/SRC/MOUSE.S 11    2/06/95 4:04p Johnp $
Macro_File Mouse;
#include winsmall.sh
#include shellapi.sh
#include mew.sh
#include menus.sh

#DEFINE _MouseLButton   0x00000001
#DEFINE _MouseRButton   0x00000002
#DEFINE _MouseInBlock   0x00000004
#DEFINE _mk_LButton     0x00010000
#DEFINE _mk_RButton     0x0002
#DEFINE _mk_Shift       0x0004
#DEFINE _mk_Control     0x0008
#DEFINE _mk_MButton     0x0010

#DEFINE WINDOWNAME      0x20
#DEFINE WINDOWSTATUS    0x40


void MouseDblClick( int flags )
{
  str tstr;
  int jx,cx,cy;
  int obs = block_stat;
  int tr = refresh;
  int tc = c_col;
  int to = left_offset;

  refresh = false;
  if( flags & _MouseLButton )
  {
    block_off;
    tstr = word_delimits;
    while( jx = xpos( ' ', tstr, 1 ) )
        tstr = str_del( tstr, jx, 1 );
    while( jx = xpos( '|255', tstr, 1 ) )
        tstr = str_del( tstr, jx, 1 );
    while( jx = xpos( '|9', tstr, 1 ) )
        tstr = str_del( tstr, jx, 1 );
    if( xpos( cur_char, tstr, 1) )
    {
      while( xpos( cur_char, tstr, 1) && (c_col > 1) )
          left;
      if( !xpos( cur_char, tstr, 1))
          right;
      cx = c_col;
      forward_till_not( tstr );
    }
    else
    {
      right;
      word_left;
      cx = c_col;
      forward_till(word_delimits);
    }
    cy = c_col - 1;
    goto_col(tc);
    left_offset = to;
    if( (obs == 3) && (cx == block_col1) && (cy == block_col2) &&
          (c_line == block_line1) && (c_line == block_line2)) {
      block_begin;
      block_end;
    }
    else if( (obs == 1) && (block_line1 == c_line) && (block_line2 == c_line) ) {
      block_off;
    }
    else {
      block_stat = 3;
      block_line1 = block_line2 = c_line;
      block_col1 = cx;
      block_col2 = cy;
    }
    refresh = TRUE;
    display_line;
  }
  refresh = tr;
}


void ContextMenu( int x = parse_int("/X=",mparm_str),
                  int y = parse_int("/Y=", mparm_str) )
{
    str passedstr = global_str('ACTIVE_CONTEXT');
    if ( passedstr == '' )
      passedstr = 'CONTEXT';

    struct tpoint tp;

    if((!x) && (!y))
    {
      GetCaretPos( &tp );
      tp.x += 3;
    }
    else
    {
      tp.x = x;
      tp.y = y;
    }

    ClientToscreen( window_handle, &tp );
    int Menu = CreateMenuFromDB( wcmdmapname, passedstr, MENU_Popup );

    if(Menu)
    {
      TrackPopupMenu( menu, TPM_LEFTALIGN | TPM_RIGHTBUTTON, tp.x, tp.y,0,frame_handle,0 );
      destroymenu( menu );
    }
}

void MouseRClick( int flags, int x, int y, int ol, int oc )
{

    ContextMenu( x, y );
}



void ProcDragDrop( int hn )
{

  str fn;
  int file_count = DragQueryFile( hn, 0xffff, fn, 0 );
  int jx;
  int tr = refresh;
  refresh = false;

  for(jx = 0; jx < file_count; jx++)
  {
    DragQueryFile( hn, jx, fn, 253 );
    return_str = fn;
    rm("ldFiles /LC=0/CW=2");
  }

  DragFinish( hn );
  refresh = tr;
}


Macro ToggleCaps
{
  struct TkeyboardState kState;

  int x;

  GetKeyboardState (&kState);
  x = kState.k[VK_CAPITAL];
  if ( x & 0x01 )
    kState.k[VK_CAPITAL] = x & 0xFE;
  else
    kState.k[VK_CAPITAL] = x | 0x01;

  SetKeyboardState (&kState);
  Update_Status_Line;
}

Macro ToggleNum
{
  struct TkeyboardState kState;

  int x;

  GetKeyboardState (&kState);
  x = kState.k[VK_NUMLOCK];
  if ( x & 0x01 )
    kState.k[VK_NUMLOCK] = x & 0xFE;
  else
    kState.k[VK_NUMLOCK] = x | 0x01;

  SetKeyboardState (&kState);
  Update_Status_Line;
}


void StatOp (int option = Parse_Int ("/T=", mparm_str))
{
  Switch (option)
  {
    case 10:  // Case from StatWIN
      RM ("GOTOLINE");
      break;
    case 11:
      RM ("INSTGL");
      break;
    case 12:
      RM ("ToggleCaps");
      break;
    case 13:
      RM ("ToggleNum");
      break;
    case 14 :
      key1 = 0;
      key2 = 0;
      Key_Record;
      break;

    case $21:   // Left Button Letter
      RM ("WINDOW^SWITWIN");
      break;
    case $22:   // rightButton Letter
      break;
    case $25:   // Left Button -Shift
      RM ("WINDOW^LASTWIN");
      break;
    case $26:   // Right Button Shift
      RM ("WINDOW^NEXTWIN");
      break;
    case $29:   // Left Button Control
      break;
    case $2A:   // Right Button Control
      break;

    case $41:   // Left Button Status
      RM ("FILESTAT");
      break;
    case $42:   // rightButton Status
      break;
    case $45:   // Left Button -Shift
      break;
    case $46:   // Right Button Shift
      break;
    case $49:   // Left Button Control
      break;
    case $4A:   // Right Button Control
      break;
  }
}