macro_file MEWHELP;

#include mewhelp.sh
#include windows.sh
#include metools.sh
#include dialog.sh

#define mewmain_help        "MEW.HLP"
#define CONTENTS_HELPLINK   "CONTENTS"

void MEW_MAIN_HELP() {
	MEWHELP("");
}

str Locate_Help_Main( )
{
  str th = SearchPath( mewmain_help, TranslateCmdLine( "<ME_PATH>HELP;<ME_PATH>", "") );
  if(th == "")
  {
    th = SearchPath( mewmain_help, Get_Environment("PATH") );
    if(th == "" )
    {
      th = SearchPath( mewmain_help, TranslateCmdLine( global_str('!HELP_PATH!'), ""));
    }
  }

  return(th);
}


str Locate_Help_File( str fn )
{
  if( get_path(fn) != "" )
    return( fn );

  if(get_extension(fn) == "")
    fn = fn + ".HLP";

  str th = SearchPath( fn, Get_Environment("PATH") );
  if(th == "")
  {
    th = SearchPath( fn, TranslateCmdLine( global_str('!HELP_PATH!'), ""));
    if(th == "" )
    {
      th = SearchPath( fn, TranslateCmdLine( "<ME_PATH>HELP;<ME_PATH>", "") );
    }
  }
  if(th == "")
    th = fn;
  return(th);
}



void MEWHELP(str help_Str = Parse_Str ('/H=', mparm_str)) TRANS2 {
/*

	The main help macro for Multi-Edit for Windows
		Parameters:
			help_str		should be in the format "file^param"
									File can be any Windows help file.  It may or may
									not contain a path.  If a path is not provided,
									the path or paths contained in the global string
									"!HELP_PATH!" will be searched.  File also
 									assumes an extension of .HLP if one is not
 									specified.
									Param can be a character string corresponding to
									a keyword search string contained in the help
 									file, or it is expected to be a numeric value
 									corresponding to a context string contained in
 									the help file.
*/
  int t_int, context_int = 0,
			do_search = parse_int("/SEARCH=",mparm_str);
	str help_file = help_str,
			help_param = "",
      help_path = "",
      tstr;


	if (help_file == "") {
    help_file = Locate_Help_Main();
		help_param = CONTENTS_HELPLINK; // default to main help screen
	} else if (t_int = xpos("^",help_file,1)) {
    help_file = caps(copy(help_file,1,t_int - 1));
    if ((help_file == "") || (help_file == mewmain_help)) {
      help_file = Locate_Help_Main();
		}
		help_param = copy(help_str,t_int + 1,255);
	} else {
		help_param = help_file;
    help_file = Locate_Help_Main();
	}

	if (!Xpos(".", help_file,1)) {
		help_file = help_file + ".HLP";
	}

  if( get_path( help_file ) == "" )
  {
    help_file = Locate_Help_File( help_file );
  }

	if (do_search) {
  	t_int = WinHelpStr(frame_handle, help_file,
												HELP_PARTIALKEY, "");
	} else if (!val(context_int,help_param)) {
  	t_int = WinHelp(frame_handle, help_file,
                    HELP_CONTEXT, context_int);
	} else {
  	t_int = WinHelpStr(frame_handle, help_file,
												HELP_PARTIALKEY, help_param);
	}

  RETURN();
}

void MEWHELP_CONTEXT ()
{
  MewHelp (Global_str ('!MEWHELP_CONTEXT'));
}
void MEWHELP_SEARCH() {
	RM("mewhelp /SEARCH=1");
}

void EXT_HELP() TRANS2 {
/*
 Invokes extension specific help.  Gets the word at the cursor or
 the text in the currently marked block (if the cursor is in the
 block) and searches in the help file configured under extension
 setup.
*/
  str help_str,
			help_file,
      help_search_str;

	int ext_str_pos, t_int;

  help_search_str = Get_Context("");

	RM('Find_Ext /EXT=.' + get_extension(file_name));
  help_str = Parse_Str('HLP=', Global_Str(Return_Str));


  if( xpos( ";", help_str, 1 ) )
  {
    int twid = window_id;
    int tr = refresh;
    int ti = insert_mode;

    refresh = false;
    insert_mode = TRUE;

    create_window;
    put_line( help_str );
    while( find_text(";", 0, 0 ) )
    {
      del_char;
      cr;
    }
    tof;

    int dlg;

    int r;

    DlgCreate( dlg );

    DlgAddCtrl( dlg, DLG_BitmapStatic, "BT_HL_101", 3, 2, 0,0,2010,0, "" );
    DlgAddCtrl( dlg, Dlg_ListBox, "", Dlg_PosOffset + Dlg_StanBtnWidth, 1, 30, 5, 2100, DLGF_LBIncsearch, "/INCO=2/WIN=" + str(cur_window));
    DlgAddCtrl( dlg, DLG_PushButton, "OK", 1, 7, Dlg_StanBtnWidth, 0, 102, DLGF_Defbutton, "/R=1");
    DlgAddCtrl( dlg, DLG_PushButton, "Cancel", Dlg_PosOffset + Dlg_StanBtnWidth + 2, DLG_PosOffset, Dlg_StanBtnWidth, 0, 102, DLGF_Defbutton, "/R=0");
    DlgAddCtrl( dlg, DLG_PushButton, "&Help", Dlg_Posoffset + Dlg_StanBtnWidth + 10, DLG_PosOffset, Dlg_StanBtnWidth, 0, 103, 0, "/R=2");

    r = DlgExecute( dlg, 2100, "Select Help File", "", "" ,0);
    DlgKill(dlg);

    help_str = get_line;

    delete_window;
    switch_win_id( twid );
    refresh = tr;
    insert_mode = ti;

    if(!r)
    {
      return();
    }
  }


  if (t_int = xpos("^",help_str,1)) {
    help_file = copy(help_str,1,t_int - 1);
    help_search_str = copy(help_str,t_int + 1,255);
  } else {
    help_file = help_str;
    //help_search_str = "";
  }

	mewhelp(help_file + "^" + help_search_str);

  return();
}


str Get_Context(str tstr[100]) trans2 {
/*******************************************************************************
															 MULTI-EDIT MACRO

	Macro   : Get_Context
	Function: Return the word under the cursor defined by the passed Regular
						Expresson or the word marked by a column or stream block.  The
						marked word will only be used if the cursor is on the same line
						as the marked word.

							 (C) Copyright 1994 by American Cybernetics, Inc.
***********************************************************************(ldh)***/

	str tstr2[100];
  int org_refresh, org_reg, col, tc;
	int tpb = persistent_blocks;
	persistent_blocks = TRUE;

	/* Set up our context */
	org_refresh = REFRESH;
	REFRESH = FALSE;                       /* No flashing of windows */
	org_reg = Reg_Exp_Stat;
	Reg_Exp_Stat = TRUE;                   /* Regular expression search */

	Mark_Pos;                               /* Save current column position */

//	tstr = Return_Str;                     /* Get Word Definition */
	if(  tstr == ''  ) {
		tstr = '[A-Za-z0-9._]';
	}
	tstr2 = Str_Ins('~', tstr, 2);

	if(  Marking  ) {
		Block_End;
	}
	if(  (Block_Stat > 1) & (Block_Line1 == C_Line) & (Block_Line2 == C_Line)  ) {
		Goto_Col(Block_Col1);
		col = Block_Col2 + 1;
	} else {
		Search_Bwd(tstr, 1);
		if(  Search_Bwd(tstr2, 1) == 0  ) {
			Goto_Col(1);
		}
		Search_Fwd(tstr, 1);
		Mark_Pos;
		if(  Search_Fwd(tstr2, 1) == 0  ) {
			EOL;
		}
		col = C_Col;
		Goto_Mark;
	}

  tc = c_col;

	/* Grab the characters that make up this word */
	Return_Str = '';
	while(  (C_Col < col)  ) {
		Return_Str = Return_Str + Cur_Char;
		right;
	}

	/* Restore original cursor position */
	Goto_Mark;

	REFRESH = org_refresh;
	Reg_Exp_Stat = org_reg;
	persistent_blocks = tpb;
  Set_Highlight(c_line,tc,c_line, col );
	Return(Return_Str);
}  /* Get_Context */

macro REGEXPHELP
{
  if ( GLOBAL_INT('reg_exp_style') )
  {
    rm('mewhelp /H=UNIX STYLE REGULAR EXPRESSIONS');
  }
  else
  {
    rm('mewhelp /H=CLASSIC REGULAR EXPRESSIONS');
  }
  return_int = 0;
}