macro_file MEUTIL3;
#ifdef WINDOWS
  #include winsmall.sh
	#include mewhelp.sh
	#include dialog.sh

  #define SORTTEXT_HELPLINK   'Sort Text'
  #define LOADMACRO_HELPLINK  'Load a Macro File'
  #define LISTMACS_HELPLINK   'List all Macros'
  #define LISTGLOB_HELPLINK   'List all Globals'
  #define LAYOUT_HELPLINK     "LAYOUT"
#endif
/*******************************************************************************
													MULTI-EDIT MACRO FILE MEUTIL3

ABOUTME					- Displays an "ABOUT" dilog box.
WINDMENU				- Brings up the window menu.
USER						- Brings up the user menu.
SORTMENU				- The text sorting dialog box.
LOADMACRO				- Prompts for a macro file to load.
LISTMACS				- Creates a list of macros.
LISTGLOB				- Creates a list of global variables.
LAYOUT					- The layout dialog box.
OPEN_CLOSE_FILE	- Opens or closes a file or device.
NOTINC          - Presents an "Option not included" message.

 Note: All printer stuff is in Print.s

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
#ifndef Windows
macro AboutMe TRANS {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: ABOUTME

Description: Displays an 'ABOUT' dialog box

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	int  menu = menu_create ;
	menu_set_item( menu, 1, 'ķ                      ķ             ','',
			'/L=1/C=4/ATTR=' + str( m_s_color ),10,0, 0);
	menu_set_item( menu, 2, ' ɸɸ     A Text Editor     ͼ             ','',
			'/L=2/C=4/ATTR=' + str( m_s_color ),10,0, 0);
	menu_set_item( menu, 3, '  ڷ ķڷ  ķڷ    ķ ķڷķ','',
			'/L=3/C=4/ATTR=' + str( m_s_color ),10,0, 0);
	menu_set_item( menu, 4, '      ͸ͼķͼ  ɸ͸ͼ','',
			'/L=4/C=4/ATTR=' + str( m_s_color ),10,0, 0);
	menu_set_item( menu, 5, '   ķ   ͼķ ٺ    ','',
			'/L=5/C=4/ATTR=' + str( m_s_color ),10,0, 0);
	menu_set_item( menu, 6, 'ͼԼͼͼͼ Լ  Լ    ͼͼԼ    ','',
			'/L=6/C=4/ATTR=' + str( m_s_color ),10,0, 0);
	menu_set_item( menu, 7, 'Version ' + version,'',	'/L=7/C=20',10,0, 0);
  menu_set_item( menu, 8, 'Copyright(c) 1988, 1993 by American Cybernetics, Inc.','',
			'/L=9/C=2',10,0, 0);

	menu_set_item( menu, 9, 'Multi-Edit is protected under United States copyright ','',
			'/L=11/C=2',10,0, 0);
	menu_set_item( menu, 10, 'law.  Copies may be  made for  the purpose  of backup','',
			'/L=12/C=2',10,0, 0);
	menu_set_item( menu, 11, 'ONLY.  Unless licensed under the terms of a  separate','',
			'/L=13/C=2',10,0, 0);
	menu_set_item( menu, 12, 'agreement which is signed  by an authorized agent  of','',
			'/L=14/C=2',10,0, 0);
	menu_set_item( menu, 13, 'American Cybernetics, Inc., this software is licensed','',
			'/L=15/C=2',10,0, 0);
	menu_set_item( menu, 14, 'for use by only one person at a time and on only  one','',
			'/L=16/C=2',10,0, 0);
	menu_set_item( menu, 15, 'computer at a time.','',
			'/L=17/C=2',10,0, 0);
	return_int = menu;
	RM('UserIn^Data_In /HN=1/H=*/A=1/#=15/T=');
	menu_delete( menu );
}
#endif

macro windmenu trans2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: WINDMENU

Description: Brings up the window menu.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	rm('MENU /MN=WINDOW' + mparm_str);
}

macro user trans2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: USER

Description: Brings up the user menu.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	rm('MENU /MN=MECONFIG.DB^USER');
}

macro SORTMENU TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: SORTMENU

Description:  The text sorting dialog box.

Global Variables:
							Global_Str('SORTPARMS') stores the following:
								/C= The starting column of sort key
								/L= Number of character in sort key
								/B The sort marked block flag
								/CASE Ignore case flag
								/D Descending order flag


							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	str  gstr[80], ustr[4] ;
	int  sort_col, sort_length, sort_mode, sort_case, sort_order ;
	int  jx, menu, dlg;

	gstr = Global_Str('SORTPARMS');
	sort_col = Parse_Int('/C=', gstr);
	sort_length = Parse_Int('/L=', gstr);
	sort_mode = (xpos('/B', gstr, 1) != 0);
	sort_case = (xpos('/CASE',gstr,1) != 0);
	sort_order = (xpos('/D', gstr, 1) == 0);

#ifdef windows

	DlgCreate(dlg);

  DlgAddCtrl( dlg, DLG_BitmapStatic, "BT_ED_104", 1, 1, 0,0,2010,0, "" );
  DlgAddCtrl( dlg, Dlg_Static, "&Starting Column of Sort Key", 9, 1, 0, 0, 110, 0, "");
	DlgAddCtrl( dlg, Dlg_Integer, "", Dlg_PosOffset + 40, 1, 8, 0, 1201, 0, "");
	DlgSetInt( dlg, 1201, sort_col);
  DlgAddCtrl( dlg, Dlg_Static, "&Number of Characters in Sort Key (0 = All)", 9, Dlg_PosOffset + 1, 0, 0, 111, 0, "");
	DlgAddCtrl( dlg, Dlg_Integer, "", Dlg_PosOffset + 40, Dlg_PosOffset, 8, 0, 1202, 0, "");
	DlgSetInt( dlg, 1202, sort_length);

  DlgAddCtrl( dlg, DLG_GroupBox, 'Options',1, Dlg_PosOffset + 2, 30, 3, 2001, 0, "");
  DlgAddCtrl( dlg, DLG_CheckBox, "Sort Marked &Block Only", 2, Dlg_PosOffset + 1, 0, 0, 1301, 0, "");
	DlgSetInt( dlg, 1301, sort_mode);
  DlgAddCtrl( dlg, DLG_CheckBox, "&Ignore Case", Dlg_PosOffset, Dlg_PosOffset + 1, 0, 0, 1302, 0, "");
	DlgSetInt( dlg, 1302, sort_case);

  DlgAddCtrl( dlg, DLG_GroupBox, 'Sort Order',Dlg_PosOffset + 33, Dlg_NegOffset - 2, 24, 3, 2002, 0, "" );
  DlgAddCtrl( dlg, DLG_RadioButton, "&Ascending", Dlg_PosOffset + 1, Dlg_PosOffset + 1, 0, 0, 1303, 0, "");
	DlgSetInt( dlg, 1303, sort_order);
  DlgAddCtrl( dlg, DLG_RadioButton, "&Descending", Dlg_PosOffset, Dlg_PosOffset + 1, 0, 0, 1304, 0, "");
	DlgSetInt( dlg, 1304, sort_order == 0);

  DlgAddCtrl( dlg, DLG_PushButton, "OK", 1, Dlg_PosOffset + 2, Dlg_StanBtnWidth, 0, 101, 0, "/R=1");
  DlgAddCtrl( dlg, DLG_PushButton, "Cancel", Dlg_PosOffset + 12, Dlg_PosOffset, Dlg_StanBtnWidth, 0, 102, 0, "/R=0");
  DlgAddCtrl( dlg, DLG_PushButton, "&Help", Dlg_PosOffset + 36, Dlg_PosOffset, Dlg_StanBtnWidth, 0, 103, 0, "/R=2");

	return_int = DlgExecute( dlg, 101, "Text Sort", SORTTEXT_HELPLINK, "" ,0);
	if ( return_int == 1 ) {
		sort_order  = DlgGetInt( dlg, 1303);
		sort_case   = DlgGetInt( dlg, 1302);
		sort_mode   = DlgGetInt( dlg, 1301);
		sort_length = DlgGetInt( dlg, 1202);
		sort_col    = DlgGetInt( dlg, 1201);
	}

	DlgKill(dlg);
#else
	menu = menu_create;
  menu_set_item( menu, 1, 'Starting column of sort key:                ','',
			'/QK=1/C=1/W=4/L=1',1,sort_col, 0);
  menu_set_item( menu, 2, 'Number of characters in sort key (0 = all): ','',
      '/QK=1/C=1/W=4/L=2',1,sort_length, 0);
  menu_set_item( menu, 3, 'Options:','', '/C=1/L=4/W=29/HT=3',10,0, 0);
  menu_set_item( menu, 4, 'Sort Marked Block Only ','', '/QK=13/C=2/L=5',13,sort_mode, 0);
  menu_set_item( menu, 5, 'Ignore Case            ','', '/QK=1/C=2/L=6',13,sort_case, 0);
  menu_set_item( menu, 6, 'Sort order:','', '/C=1/L=7/W=29/HT=3',10,0, 0);
  menu_set_item( menu, 7, 'Ascending  ','', '/QK=1/C=2/L=8',12,sort_order, 0);
  menu_set_item( menu, 8, 'Descending ','', '/QK=1/C=2/L=9',12,(sort_order == 0), 0);
	return_int = menu;
//#ifdef WINDOWS
  RM('UserIn^Data_In /HN=1/S=1/#=8/T=Text Sort/H=' + SORTTEXT_HELPLINK);
//#else
  RM('UserIn^Data_In /HN=1/H='+SORTTEXT_HELPLINK+'/S=1/#=8/T=Text Sort');
//#endif
	sort_order = menu_item_int( menu, 7, 2 );
	sort_case = menu_item_int( menu, 5, 2 );
	sort_mode = menu_item_int( menu, 4, 2 );
	sort_length = menu_item_int( menu, 2, 2 );
	sort_col = menu_item_int( menu, 1, 2 );
#endif
	gstr = '/C=' + str(sort_col) + '/L=' + str(sort_length);
	if(  (sort_case)  ) {
		gstr = gstr + '/CASE';
	}
	if(  sort_mode  ) {
		gstr = gstr + '/B';
	}
	if(  sort_order == 0  ) {
		gstr = gstr + '/D';
	}
	set_global_str('SORTPARMS', gstr);
	if(  return_int  ) {
		jx = parse_int('/BC=', mparm_str);
#ifndef Windows
    while(  box_count > jx  ) {
      kill_box;
    }
#endif
		RM('TEXT^TEXTSORT ' + gstr);
		return_int = 1;
	}
#ifndef windows
	menu_delete( menu );
#endif
}

macro LOADMACRO TRANS {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: LOADMACRO

Description:  Prompts for a macro to load.

Parameters:
							/BC= Number of boxes to kill upon exit

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
		int jx;

		set_global_str('!MAC_ISTR_1', '');
#ifdef WINDOWS
    set_global_str('!MAC_IPARM_1', '/HISTORY=MACRO_HISTORY/C=7/L=1/W=40/T=Name:/ML=80');
    set_global_str('!MAC_ISTR_2', 'BT_GN_118' );
    set_global_str('!MAC_IPARM_2', '/L=1/C=1/HT=2/TP=30/MD=1');
    rm('USERIN^Data_In /A=2/T=Load Macro File/#=2/PRE=!MAC_/H=' +
				LOADMACRO_HELPLINK);
#else
    set_global_str('!MAC_IPARM_1', '/HISTORY=MACRO_HISTORY/C=1/L=1/W=40/T=Name:/ML=80');
    rm('USERIN^Data_In /A=2/T=Load Macro File/#=1/PRE=!MAC_/H=');
#endif
		return_str = global_str('!MAC_ISTR_1');
		Set_Global_Str('!MAC_ISTR_1', '');
		if(  (Return_Int)  ) {
			Load_Macro_File(Return_Str);
			if(  error_level != 0  ) {
				RM('MEERROR');
				return_int = 0;
			} else {
#ifndef Windows
        jx = parse_int('/BC=', mparm_str);
        while(  box_count > jx  ) {
          kill_box;
        }
#endif
				make_message('Macro file "' + return_str + '" loaded.');
				return_int = 100;
			}
		}
}

#ifdef windows
/****************************************************************
 *
 *  This macro is used solely to support the sorting capability
 *  in the "List All Macros" dialog.
 *
 ***************************************************************/
void MacListSort (int dlg = parse_int('/DLGHANDLE=', mparm_str))
{
	int Sortdlg, bl, el;
	mark_pos;
	tof;
	bl = c_line;
	eof;
	el = c_line;
	goto_mark;

	DlgCreate(Sortdlg);
  DlgAddCtrl( Sortdlg, Dlg_GroupBox, "Sort", 1, 1, 15, 4, 1100, 0, '');
	DlgAddCtrl( Sortdlg, Dlg_RadioButton, "&Ascend", Dlg_PosOffset + 1, Dlg_PosOffset + (Dlg_Units | 10), 0, 0, 1200, 0, '');
  DlgSetInt ( Sortdlg, 1200, global_int('MacListSort') == 1);
	DlgAddCtrl( Sortdlg, Dlg_RadioButton, "&Descend", Dlg_PosOffset, Dlg_PosOffset + (Dlg_Units | 11), 0, 0, 1201, 0, '');
  DlgSetInt ( Sortdlg, 1201, global_int('MacListSort') == 2);
	DlgAddCtrl( Sortdlg, Dlg_RadioButton, "&No Sort", Dlg_PosOffset, Dlg_PosOffset + (Dlg_Units | 11), 0, 0, 1202, 0, '');
  DlgSetInt ( Sortdlg, 1202, global_int('MacListSort') == 0);
  DlgAddCtrl( Sortdlg, Dlg_PushButton, "OK", Dlg_PosOffset + 18, 1, Dlg_StanBtnWidth, 0, 100, DLGF_DefButton, "/R=1");
  DlgAddCtrl( Sortdlg, Dlg_PushButton, "Cancel", Dlg_PosOffset, Dlg_PosOffset + (Dlg_Units | 18), Dlg_StanBtnWidth, 0, 101, 0, "/R=0");
  DlgAddCtrl( SortDlg, Dlg_PushButton, "&Help", Dlg_PosOffset, Dlg_PosOffset + (Dlg_Units | 18), Dlg_StanBtnWidth, 0, 102, 0, "/R=2");
  return_int = DlgExecute( Sortdlg, 1100, "Sort Macros", LISTMACS_HELPLINK, "", 0);

	if ( return_int == 1 ) {
		if ( DlgGetInt(Sortdlg, 1200) )
      set_global_int("MacListSort", 1);
		else if ( DlgGetInt(Sortdlg, 1201) )
      set_global_int("MacListSort", 2);
		else
      set_global_int("MacListSort", 0);

    qsort_lines( bl, el, global_int('MacListSort') == 1, 0, 0, 0 );
	  struct TRect r;
	  GetClientRect (GetDlgItem (dlg, 2100 ), &r);
		RedrawWindow (GetDlgItem (dlg, 2100 ), 0, 0, RDW_INVALIDATE | RDW_UPDATENOW | RDW_ALLCHILDREN);
	}
	SetFocus( GetDlgItem (dlg, 2100));
	DlgKill(SortDlg);
}
#endif

macro LISTMACS TRANS {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: LISTMACS

Description:  Builds a list of macros currently in memory.


							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	str TStr[20];
	int Active_window,T_Refresh, Dlg;

	working;
	Active_Window = Window_Id;
	T_REfresh = Refresh;
	Refresh = False;
	Create_Window;
	if(  (Error_Level)  ) {
		RM('MEERROR');
		Goto EXIT;
	}
	TStr = First_Macro;
Loop:
	if(  TStr != ''  ) {
		Put_Line(TStr);
		Down;
		TStr = Next_Macro;
		Goto Loop;
	}
	tof;
#ifdef windows
  eof;
  int el = c_line;
  tof;
  int bl = c_line;
  if ( global_int('MacListSort') )
    qsort_lines( bl, el, global_int('MacListSort') == 1, 0, 0, 0 );

  DlgCreate(dlg);

  DlgAddCtrl( dlg, DLG_BitmapStatic, "BT_GN_119", 3, 2, 0,0,2010,0, "" );
  DlgAddCtrl( dlg, Dlg_ListBox, "", Dlg_PosOffset + Dlg_StanBtnWidth, 1, 30, 0, 2100, DLGF_LBIncsearch, "/INCO=2/WIN=" + str(cur_window));
  DlgAddCtrl( dlg, Dlg_PushButton, "&Sort...", Dlg_NegOffset - Dlg_StanBtnWidth - 2, 4, Dlg_StanBtnWidth, 0, 101, 0, "/M=MACLISTSORT");
  DlgAddCtrl( dlg, DLG_PushButton, "Close", Dlg_PosOffset + Dlg_StanBtnWidth + 2, 16, Dlg_StanBtnWidth, 0, 102, DLGF_Defbutton, "/R=0");
  DlgAddCtrl( dlg, DLG_PushButton, "&Help", Dlg_Posoffset + Dlg_StanBtnWidth + 10, 16, Dlg_StanBtnWidth, 0, 103, 0, "/R=2");

  DlgExecute( dlg, 2100, "Loaded Macros", LISTMACS_HELPLINK, "" ,0);

  DlgKill( dlg );
#else
  Set_Global_Str('MEIPARM_1', '/TP=15/C=3/L=1/WIN=' + str(cur_window) );
  RM('USERIN^DATA_IN /A=2/T=Loaded Macros/A=1/H=/#=1/PRE=ME/ABT=Done/NOCANCEL=1');
#endif
	Delete_WIndow;
	Switch_Win_Id(Active_WIndow);

EXIT:

	Refresh = T_Refresh;
	Return_Int = 0;

}

/*******************************************************************
 *
 *	This macro is used solely in conjunction with the "List All Global"
 *	macro.
 ******************************************************************/
void BUILD_GLOB_LIST ()
{
	int oim = insert_mode, bl, el, attr;
	str  astr[20], tstr;
	insert_mode = true;
	erase_window;
	tof;
	aStr =  First_Global( attr );
Loop:
	if(  aStr != ''  ) {
#ifdef windows
		if(  attr == 0  )
			tstr = "GV=" + astr + "TP=STRING";
		else
			tstr = "GV=" + astr + "TP=INTEGER";
#else
		tstr = astr + copy('                     ', 1, 21 - svl(astr) );
		if(  attr == 0  ) {
			tstr = tstr + 'STRING' ;
		} else {
			tstr = tstr + 'INTEGER' ;
		}
#endif
		put_line( tstr );
		down;
		aStr = Next_Global( attr );
		Goto Loop;
	}
	el = c_line - 1;
	tof;
	bl = c_line;
	if ( global_int('GLOBLISTSORT') != 0 ) {
		if ( global_int('GLOBLISTSKIP') != 0 ) {
			while ( !at_eof ) {
				goto_col(5);
				if ( !xpos(cur_char, '!@#&~', 1 )	)
					text('*');
				down;
			}
			qsort_lines( bl, el, global_int('GlobListSort') == 1,
									global_int("GlobListSkip") + 4, 0, 0 );
			tof;
			while ( !at_eof ) {
				goto_col(5);
				if ( cur_char == '*' )
					del_char;
				down;
			}
		} else
			qsort_lines( bl, el, global_int('GlobListSort') == 1,	0, 0, 0 );
	}
	tof;
	insert_mode = oim;
}
#ifdef windows

/****************************************************************
 *
 *  This macro is used solely to support the sorting capability
 *	in the "List All Globals" dialog.
 *
 ***************************************************************/
void GlobListSort (int dlg = parse_int('/DLGHANDLE=', mparm_str))
{
	int Sortdlg;

	DlgCreate(Sortdlg);
  DlgAddCtrl( Sortdlg, Dlg_GroupBox, "Sort...", 1, 1, 15, 4, 1100, 0, '');
	DlgAddCtrl( Sortdlg, Dlg_RadioButton, "&Ascend", Dlg_PosOffset + 1, Dlg_PosOffset + (Dlg_Units | 10), 0, 0, 1200, 0, '');
	DlgSetInt ( Sortdlg, 1200, global_int('GlobListSort') == 1);
	DlgAddCtrl( Sortdlg, Dlg_RadioButton, "&Descend", Dlg_PosOffset, Dlg_PosOffset + (Dlg_Units | 11), 0, 0, 1201, 0, '');
	DlgSetInt ( Sortdlg, 1201, global_int('GlobListSort') == 2);
	DlgAddCtrl( Sortdlg, Dlg_RadioButton, "&No Sort", Dlg_PosOffset, Dlg_PosOffset + (Dlg_Units | 11), 0, 0, 1202, 0, '');
	DlgSetInt ( Sortdlg, 1202, global_int('GlobListSort') == 0);
	DlgAddCtrl( Sortdlg, Dlg_CheckBox, "&Skip Identifier", Dlg_PosOffset + 18, 2, 0, 0, 1300, 0, '');
	DlgSetInt ( Sortdlg, 1300, global_int('GlobListSkip') == 2);
	DlgAddCtrl( Sortdlg, Dlg_PushButton, "OK", 1, Dlg_PosOffset + 4, Dlg_StanBtnWidth, 0, 100, 0, "/R=1");
	DlgAddCtrl( Sortdlg, Dlg_PushButton, "Cancel", Dlg_PosOffset + Dlg_StanBtnWidth + 2, Dlg_PosOffset, Dlg_StanBtnWidth, 0, 101, 0, "/R=0");
	DlgAddCtrl( SortDlg, Dlg_PushButton, "&Help", Dlg_PosOffset + (2 * Dlg_StanBtnWidth), Dlg_PosOffset, Dlg_StanBtnWidth, 0, 102, 0, "/R=2");
	return_int = DlgExecute( Sortdlg, 1100, "Sort Globals", LISTGLOB_HELPLINK, "", 0);

	if ( return_int == 1 ) {
		if ( DlgGetInt(Sortdlg, 1200) )
			set_global_int("GlobListSort", 1);
		else if ( DlgGetInt(Sortdlg, 1201) )
			set_global_int("GlobListSort", 2);
		else
			set_global_int("GlobListSort", 0);

		if ( DlgGetInt(Sortdlg, 1300) ) {
			set_global_int("GlobListSkip", 2);
		} else
			set_global_int("GlobListSkip", 0);

		build_glob_list();

		eof;
	  int jx = SendDlgItemMessage( dlg, 2100, LB_GETCOUNT, 0, 0 );
	  while(  jx < c_line )
	  {
	    SenddlgItemMessage( dlg, 2100, LB_ADDSTRING, 0, 0 );
	    ++jx;
	  }
	  while(  jx > c_line )
	  {
	    SendDlgItemMessage( dlg, 2100, LB_DELETESTRING, jx - 1, 0 );
	    --jx;
	  }
		SendDlgItemMessage(dlg, 2100, LB_SETCURSEL, 0, 0);
	}
	DlgKill(SortDlg);
}

/*******************************************************************
 *
 *	This macro is used solely to support the "List All Globals"
 *	option.  It brings up the "View" dialog.
 *
 ******************************************************************/
void view_global (int dlg = parse_int('/DLGHANDLE=', mparm_str))
{
	int viewdlg, attr;
	str gv, tp;
	DlgCreate(viewdlg);
	gv = parse_str("GV=", get_line);
	tp = parse_str("TP=", get_line);
	if ( tp == "STRING" ) {
		tp = "String";
		DlgAddCtrl( viewdlg, DLG_Static, "String &Value:", 1, 1, 0,0, 105,0, "" );
  	DlgAddCtrl( viewdlg, DLG_Text, global_str(gv), 15, 1,28, 0, 1101,0,"/ML=256" );
	} else {
		tp = "Integer";
		DlgAddCtrl( viewdlg, DLG_Static, "Integer &Value:", 1, 1, 0,0, 105,0, "" );
  	DlgAddCtrl( viewdlg, DLG_Text, str(global_int(gv)),15, 1,20, 0, 1101,0,"" );
	}
  DlgAddCtrl( viewdlg, DLG_PushButton, "OK", 1, 3, Dlg_StanBtnWidth, 0, 101, 0, "/R=1");
  DlgAddCtrl( viewdlg, DLG_PushButton, "Cancel", Dlg_Posoffset + 12, 3, Dlg_StanBtnWidth, 0, 102, 0, "/R=0");
  DlgAddCtrl( viewdlg, DLG_PushButton, "&Help", Dlg_Posoffset + 22, 3, Dlg_StanBtnWidth, 0, 103, 0, "/R=2");

	return_int = DlgExecute( viewdlg, 1101, gv, LISTGLOB_HELPLINK, "" ,0);

	if ( return_int == 1 ) {
		if ( tp == "String" ) {
			set_global_str(gv, DlgGetStr( viewdlg, 1101));
			if ( global_str(gv) == '' ) {
				del_line;
			}
		} else {
			int tval, checkvar;
			if (val(tval, DlgGetStr( viewdlg, 1101)) == 0) {
				set_global_int(gv, tval);
				if ( global_int(gv) == 0 ) {
					del_line;
				}
			} else
				rm('messagebox /M=The value did not change due to an invalid entry!');
		}
	}
	DlgKill(viewdlg);
	struct TRect r;
	GetClientRect (GetDlgItem (dlg, 2100 ), &r);
	RedrawWindow (GetDlgItem (dlg, 2100 ), 0, 0, RDW_INVALIDATE | RDW_UPDATENOW | RDW_ALLCHILDREN);
	SetFocus( GetDlgItem(dlg, 2100));
}
#endif

macro LISTGLOB TRANS {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: LISTGLOB

Description:  Builds a list of globals currently in memory.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	str  astr[20], TStr[40] ;
	int  attr, twindow, tr, tbc ;

#ifndef Windows
  tbc = box_count;
#endif
	tr = refresh;
	refresh = false;
	working;
	twindow = window_id;
	switch_window( window_count );
	create_window;
	build_glob_list();
	call clear_boxs;
#ifdef windows
	int dlg, sortdlg;
	str gv, tp;
	DlgCreate(dlg);

  DlgAddCtrl( dlg, DLG_BitmapStatic, "BT_GN_113", 3, 2, 0,0,2010,0, "" );
	DlgAddCtrl( dlg, Dlg_ListBox, "GV=/W=27TP=/W=12", Dlg_PosOffset + Dlg_StanBtnWidth, 1, 45, 14, 2100, DLGF_LBIncsearch, "/WIN=" + str(cur_window));
  DlgAddCtrl( dlg, DLG_PushButton, "&Sort...", 1, Dlg_PosOffset + 3, Dlg_StanBtnWidth, 0, 102, 0, "/M=GlobListSort");
  DlgAddCtrl( dlg, DLG_PushButton, "&View", 1, Dlg_PosOffset + DLG_Units | ((Dlg_Units_Per_Line * 11) + (Dlg_Units_Qline | 4)), Dlg_StanBtnWidth, 0, 101, DLGF_DEFBUTTON, "/M=VIEW_GLOBAL");
  DlgAddCtrl( dlg, DLG_PushButton, "Close", Dlg_Posoffset + Dlg_StanBtnWidth + 2, Dlg_PosOffset, Dlg_StanBtnWidth, 0, 103, 0, "/R=0");
  DlgAddCtrl( dlg, DLG_PushButton, "&Help", Dlg_Posoffset + (3 * Dlg_StanBtnWidth) + 2, Dlg_PosOffset, Dlg_StanBtnWidth, 0, 104, 0, "/R=2");

  return_int = DlgExecute( dlg, 2100, "Global Variables", LISTGLOB_HELPLINK, "" ,0);

	DlgKill( dlg );

#else
	Set_Global_Str('GEIPARM_1', '/DC=1/TP=15/T=Select global to view//change:/W=31/L=1/C=1/WIN=' + str(cur_window));
  RM('USERIN^DATA_IN /A=2/T=Global Variables/H=MC/#=1/PRE=GE/ABT=View/CBT=Done');
	if(  (Return_Int == 1)  ) {
		tstr = shorten_str( copy(Get_Line,1,20));
		if(  copy( Get_Line, 22, 1) == 'S'  ) {
			set_global_str('!GLOB_ISTR_1', tstr);
      set_global_str('!GLOB_IPARM_1', '/PROTECT=1/C=1/L=1/W=20/T=Name: ');
			set_global_str('!GLOB_ISTR_2', global_str(tstr));
      set_global_str('!GLOB_IPARM_2', '/C=1/L=2/W=60/T=Value:/ML=2048');
      rm('USERIN^Data_In /A=2/T=Examining Global String/S=2/#=2/PRE=!GLOB_');
			if(  (Return_Int)  ) {
				set_global_str( tstr, global_str('!GLOB_ISTR_2' ));
			}
			Set_Global_Str('!GLOB_ISTR_1', '');
			Set_Global_Str('!GLOB_ISTR_2', '');
		} else {
			set_global_str('!GLOB_ISTR_1', tstr);
      set_global_str('!GLOB_IPARM_1', '/PROTECT=1/C=1/L=1/W=20/T=Name: ');
			set_global_int('!GLOB_IINT_2', global_int(tstr));
      set_global_str('!GLOB_IPARM_2', '/TP=1/C=1/L=2/W=9/T=Value:');
      rm('USERIN^Data_In /A=2/T=Examining Global Integer/S=2/#=2/PRE=!GLOB_');
			if(  (Return_Int)  ) {
				set_global_int( tstr, global_int('!GLOB_IINT_2' ));
			}
			Set_Global_Str('!GLOB_ISTR_1', '');
			Set_Global_Int('!GLOB_IINT_2', 0);
		}
		Goto again;
	}
#endif
	goto exit;

clear_boxs:
#ifndef Windows
  while(  box_count > tbc  ) {
    kill_box;
  }
#endif
	ret;

exit:
	call clear_boxs;
	refresh = false;
	delete_window;
	switch_win_id( twindow );
	Return_Int = 0;
	refresh = tr;
}

macro LAYOUT trans2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: LAYOUT

Description:  The layout dialog box

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	int menu,
			jx  = xpos( '|16', format_line, 1 )
			;

	if(jx > 0)
		--jx;
#ifdef windows
	int dlg;
again:

	DlgCreate(dlg);

  DlgAddCtrl( dlg, DLG_BitmapStatic, "BT_ED_110", 1, 1, 0,0,2010,0, "" );

  DlgAddCtrl( dlg, DLG_GroupBox, 'Edit Mode',Dlg_PosOffset + 7, 1, 15, 4, 2001, 0, "" );
  DlgAddCtrl( dlg, DLG_RadioButton, "Te&xt", Dlg_PosOffset + 1, Dlg_PosOffset + 1, 0, 0, 1301, 0, "");
	DlgSetInt( dlg, 1301, Doc_Mode == 0);
  DlgAddCtrl( dlg, DLG_RadioButton, "&Document", Dlg_PosOffset, Dlg_PosOffset + 1, 0, 0, 1302, 0, "");
	DlgSetInt( dlg, 1302, Doc_Mode != 0);

  DlgAddCtrl( dlg, DLG_GroupBox, 'Indent Style',Dlg_PosOffset + 16, 1, 15, 4, 2002, 0, "" );
  DlgAddCtrl( dlg, DLG_RadioButton, "&Off", Dlg_PosOffset + 1, Dlg_PosOffset + 1, 0, 0, 1303, 0, "");
	DlgSetInt( dlg, 1303, Indent_Style == 0);
  DlgAddCtrl( dlg, DLG_RadioButton, "&Auto", Dlg_PosOffset, Dlg_PosOffset + 1, 0, 0, 1304, 0, "");
	DlgSetInt( dlg, 1304, Indent_Style == 1);
  DlgAddCtrl( dlg, DLG_RadioButton, "&Smart", Dlg_PosOffset, Dlg_PosOffset + 1, 0, 0, 1305, 0, "");
	DlgSetInt( dlg, 1305, Indent_Style == 2);

  DlgAddCtrl(dlg, Dlg_PushButton, "&Format Line...", Dlg_PosOffset + 17, Dlg_NegOffset - 2, 16, 0, 104, 0, "/M=MEW^NOT_YET_SUPP");
  DlgAddCtrl(dlg, Dlg_PushButton, "Auto S&etup", Dlg_PosOffset , Dlg_PosOffset + 2, 16, 0, 105, 0, "/R=4");

  DlgAddCtrl( dlg, Dlg_GroupBox, 'Options', 1, Dlg_PosOffset + 2, 61, 4, 2003, 0, "");
  DlgAddCtrl( dlg, DLG_CheckBox, "&Word Wrap", Dlg_PosOffset + 1, Dlg_PosOffset + 1, 0, 0, 1001, 0, "");
	DlgSetInt( dlg, 1001, wrap_stat);
  DlgAddCtrl( dlg, DLG_CheckBox, "Sa&ve Format Line with File", Dlg_PosOffset, Dlg_PosOffset + 1, 0, 0, 1002, 0, "");
	DlgSetInt( dlg, 1002, format_stat);
  DlgAddCtrl( dlg, DLG_CheckBox, "D&isplay Tabs", Dlg_PosOffset, Dlg_PosOffset + 1, 0, 0, 1003, 0, "");
	DlgSetInt( dlg, 1003, display_tabs);

  DlgAddCtrl( dlg, DLG_Static, "&Tab Spacing:", Dlg_PosOffset + 33, Dlg_NegOffset - 2, 16, 0, 120, 0, "" );
	DlgAddCtrl( dlg, Dlg_Integer, "", Dlg_PosOffset + 13, Dlg_PosOffset, 10, 0, 1201, 0, "" );
	DlgSetInt( dlg, 1201, jx);
  DlgAddCtrl( dlg, DLG_Static, "&Right Margin:", Dlg_NegOffset - 13, Dlg_PosOffset + 1, 16, 0, 121, 0, "" );
	DlgAddCtrl( dlg, Dlg_Integer, "", Dlg_PosOffset + 13, Dlg_PosOffset, 10, 0, 1202, 0, "" );
	DlgSetInt( dlg, 1202, right_margin);

  DlgAddCtrl( dlg, Dlg_GroupBox, "Tab Settings Mode", 1, Dlg_PosOffset + 3, 61, 3, 2004, 0, "");
  DlgAddCtrl( dlg, DLG_RadioButton, "Using Tab and &Margin Settings - Ignoring Format Line", Dlg_PosOffset + 1, Dlg_PosOffset + 1, 0, 0, 1306, 0, "");
	DlgSetInt( dlg, 1306, use_format_line == 0);
  DlgAddCtrl( dlg, DLG_RadioButton, "Using Format &Line - Ignoring Tab and Margin Settings", Dlg_PosOffset, Dlg_PosOffset + 1, 0, 0, 1307, 0, "");
	DlgSetInt( dlg, 1307, use_format_line == 1);

  DlgAddCtrl( dlg, DLG_PushButton, "OK", 1, Dlg_PosOffset + 2, Dlg_StanBtnWidth, 0, 101, 0, "/R=1");
  DlgAddCtrl( dlg, DLG_PushButton, "Cancel", Dlg_PosOffset + 12, Dlg_PosOffset, Dlg_StanBtnWidth, 0, 102, 0, "/R=0");
  DlgAddCtrl( dlg, DLG_PushButton, "&Help", Dlg_PosOffset + 39, Dlg_PosOffset, Dlg_StanBtnWidth, 0, 103, 0, "/R=2");

  return_int = DlgExecute( dlg, 101, "Layout", LAYOUT_HELPLINK, "" ,0);
	if ( (return_int == 1) || (return_int == 4) ) {
		doc_mode = DlgGetInt( dlg, 1302 );
		if ( DlgGetInt( dlg, 1303 ))
			indent_style = 0;
		else if (DlgGetInt (dlg, 1304 ))
			indent_style = 1;
		else
			indent_style = 2;
		wrap_stat = DlgGetInt(dlg, 1001);
		format_stat = DlgGetInt(dlg, 1002);
		display_tabs = dlgGetInt(dlg, 1003);
		use_format_line = dlgGetInt(dlg, 1307);
		right_margin = DlgGetInt(dlg, 1202);
		if( !use_format_line )
			rm('SETTABS /RM=' + str(right_margin) + '/TS=' + str(DlgGetInt(dlg, 1201)));
		if(return_int == 4)
			rm('EXTSETUP');
	}

	DlgKill(dlg);
	redraw;

	if ( return_int == 3) {
		beep;
		rm('messagebox /M=This option not yet supported');
		goto again;
	}
#else
	menu = menu_create;
	return_int = menu;
//  rm('RESOURCE^_DG_LAYOUT');

  menu_set_item( return_int, 1, "Edit Mode:", "", "/C=1/L=1/HT=4/W=15/QK=1/L=/C=/W=", 10, 0, 0);
  menu_set_item( return_int, 2, "Text     ", "", "/C=2/L=2/L=/C=/W=", 12, 0, 0);
  menu_set_item( return_int, 3, "Document ", "", "/C=2/L=3/L=/C=/W=", 12, 0, 0);
  menu_set_item( return_int, 4, "Indent style:", "", "/C=18/L=1/HT=4/W=12/QK=1/L=/C=/W=", 10, 0, 0);
  menu_set_item( return_int, 5, "Off    ", "", "/C=19/L=2/L=/C=/W=", 12, 0, 0);
  menu_set_item( return_int, 6, "Auto   ", "", "/C=19/L=3/L=/C=/W=", 12, 0, 0);
  menu_set_item( return_int, 7, "Smart  ", "", "/C=19/L=4/L=/C=/W=", 12, 0, 0);
  menu_set_item( return_int, 8, "Tab spacing :", "", "/C=35/L=2/W=5/MIN=1/MAX=255/QK=1/L=/C=/W=", 1, 0, 0);
  menu_set_item( return_int, 9, "Right margin:", "", "/C=35/L=3/W=6/MIN=1/MAX=2048/QK=1/L=/C=/W=", 1, 0, 0);
  menu_set_item( return_int, 10, "Word wrap                  ", "", "/C=1/L=6/QK=1/L=/C=/W=", 13, 0, 0);
  menu_set_item( return_int, 11, "Save format line with file ", "", "/C=1/L=7/QK=1/L=/C=/W=", 13, 0, 0);
  menu_set_item( return_int, 12, "Display tabs               ", "", "/C=1/L=8/QK=1/L=/C=/W=", 13, 0, 0);
  menu_set_item( return_int, 13, "Tab settings mode:", "", "/C=1/L=10/QK=3/HT=3/W=55/L=/C=/W=", 10, 0, 0);
  menu_set_item( return_int, 14, "Using tab and margin settings - ignoring format line", "", "/C=2/L=11/L=/C=/W=", 12, 0, 0);
  menu_set_item( return_int, 15, "Using format line - ignoring tab and margin settings", "", "/C=2/L=12/L=/C=/W=", 12, 0, 0);
// ********************** this one is disabled until we get it working.
  menu_set_item( return_int, 16, "Edit format line", "", "/OFF=1/C=35/L=6/QK=6/R=10/L=/C=/W=", 11, 0, 0);
  menu_set_item( return_int, 17, "Auto setup", "", "/C=35/L=8/QK=1/R=11/L=/C=/W=", 11, 0, 0);

//#ifdef WINDOWS
//  return_str = "/#=17/T=Layout/H=" + Str(hLAYOUT);
//#else
  return_str = "/#=17/T=Layout/H=LAYOUT";
//#endif

	jx = xpos( '|16', format_line, 1 );
	if(jx > 0)
			--jx;
	menu_set_int( menu, 2, 2, doc_mode == 0 );
	menu_set_int( menu, 3, 2, doc_mode != 0 );
	menu_set_int( menu, 5, 2, indent_style == 0 );
	menu_set_int( menu, 6, 2, indent_style == 1 );
	menu_set_int( menu, 7, 2, indent_style == 2 );
	menu_set_int( menu, 8, 2, jx );
	menu_set_int( menu, 9, 2, right_margin );
	menu_set_int( menu, 10, 2, wrap_stat );
	menu_set_int( menu, 11, 2, format_stat );
	menu_set_int( menu, 12, 2, display_tabs );
	menu_set_int( menu, 14, 2, use_format_line == 0 );
	menu_set_int( menu, 15, 2, use_format_line == 1 );
	return_int = menu;

	rm('USERIN^Data_In /HN=1' + return_str);

	if (return_int) {
		doc_mode = menu_item_int( menu, 3, 2 );
		if( menu_item_int( menu, 5, 2 ))
				indent_style = 0;
		else if (menu_item_int( menu, 6, 2 ) )
				indent_style = 1;
		else
				indent_style = 2;
		right_margin = menu_item_int( menu, 9, 2 );
		wrap_stat = menu_item_int( menu, 10, 2 );
		format_stat = menu_item_int( menu, 11, 2 );
		display_tabs = menu_item_int( menu, 12, 2 );
		use_format_line = !menu_item_int( menu, 14, 2 );
		if( !use_format_line )
				rm('SETTABS /RM=' + str(right_margin) + '/TS=' + str( menu_item_int( menu, 8, 2 ) ));
		if(return_int == 11)
				rm('EXTSETUP');
		else if (return_int == 10) {
			refresh = TRUE;
			rm('MEUTIL1^EDFORMAT');
		}
	}
	menu_delete( menu );
#endif
}

macro OPEN_CLOSE_FILE TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: OPEN_CLOSE_FILE

Description:  Opens or closes a file or device.

Parameters:
							/M= Mode	If 1, create new file, if 2 open existing file, if 0,
									close the file.
							/FN= File name.  Required if M > 0.
							/H=n  Handle of file to close (/M=0);

Returns:
							RETURN_INT = the file handle
							Error_Level > 0 if an error occurred.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	int Open_Mode,Error,Handle;
	str F_Name[80];

	Return_Int = 0;
	Open_Mode = Parse_Int('/M=',MParm_Str);
	F_Name = Parse_Str('/FN=',MParm_Str);
	Handle = 0;
	if(  (Open_Mode == 1)  ) {
/* Create the file */
		Error = S_Create_File(F_Name,Handle);
	} else if(  (Open_Mode == 2)  ) {
		Error = S_Open_File(F_Name,1,Handle);
	} else {
		Error = S_Close_File(Parse_Int('/H=',MParm_Str));
	}

	if(  (Error)  ) {
		Error_Level = 3000 + Error;
	} else {
		Return_Int = Handle;
		Error_Level = 0;
	}

}

macro NOTINC TRANS {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: NOTINC

Description:  Puts up the message that a module is not included.

Parameters:
							/X= The upper left column coordinate
							/Y= The upper left row coordinate
							/T= The name of the option
							/H= The help index string, if help is to be enabled

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int x,y;
	str t_return_str = return_str;
	int  menu = menu_create ;
  menu_set_item( menu, 1, 'This module is not installed, and is included','',
      '/L=1/C=1',10,0, 0);
  menu_set_item( menu, 2, 'only with the Professional package.  If you','',
      '/L=2/C=1',10,0, 0);
  menu_set_item( menu, 3, 'are running Multi-Edit Professional then you','',
      '/L=3/C=1',10,0, 0);
  menu_set_item( menu, 4, 'need to install the module from the Installation','',
      '/L=4/C=1',10,0, 0);
  menu_set_item( menu, 5, 'and Setup -> Module installation dialog box.','',
      '/L=5/C=1',10,0, 0);
  menu_set_item( menu, 6, 'Press F1 for more info on this optional module.','',
      '/L=6/C=1',10,0, 0);
	return_int = menu;
  RM('UserIn^Data_In /HN=1/A=1/#=6' + mparm_str );
	menu_delete( menu );

	return_str = t_return_str;
	return_int = 100;
}