prototype METOOLS
{
  str TranslateCmdLine( str cmdline, fname );
  /*******************************************************************************
  Description:  Translates cmdline so that any occurances of
                <FILE>, <NAME>, <EXT>, <PATH>, <ME_PATH>, <USER_PATH>, <MAC_PATH>
                 are expanded out.

                Also, <%str> is now expanded out to whatever the environment
                variable "str" is.
                AND, <~str> is now expanded out to the value of
                Global_Str( str ).

                fname is the file name to be used.
  *******************************************************************************/

  str GetUserMacroPath();
  /******************* Multi-Edit STRING Macro Function ***********************

   DESCRIPTION:  Returns the path to place user generated .MAC files in.
  *****************************07-23-93 11:15am*******************************/

  str GetUserPath( );
  // Simply returns User_Path

  str CreateUserPath( str path, int copy_default );

  str TempFileName( str path );

  int LocateDbPage( str fname, str page_title, int create_if_not_found  );
  /*******************************************************************************
  Description: Loads up the specified DB file (if it is not already
              loaded), and then searches for the specified page title.

  Returns:    1 IF the title was found,
              0 If NOT found.

  Parameters:   fname                   The db file name.
                page_title              The page Title.
                create_if_not_found     1 = Create page if not found.

  *******************************************************************************/

  int GetDbRecord(
  /****************************************************************************
  Description:  Finds and returns the specified record in a .DB file.
  Returns:
                1 if found
                0 if not found, but first record is stored in /GLO=
               -1 if not found and there are no records.
               -2 if the DPT is not found in the DB file.
               -3 if the DB file is not found.

  This only works for string and integer fields
  ****************************************************************************/
          str fname,           // db filename
          str dpt,             // data page title
          str dbf,             // field name
          str fv,              // field value
          int rec_num,         // record # to return (overrides fv
                               //   and dbf).  Example:  If /#=3 then the
                               //   3rd record will be returned.
          int flags,           // 1 = case sensitive search
          str global_name,     // name of global variable to store record
          int remove_file,     // if TRUE, then remove DB file from memory
                               //    after operation
          str misc             // Misc parameters
                               //   /AGLO=n  name  of global integer
                               //            to store total #  of
                               //            records
                               //   /LD=str  Delimit to use, default is
                               //            ASCII 127
                 );

  int CheckDupFields (str dbpage, str dbline, str fielddata, ...);
  //******************************************************************************
  // Check for duplicate fields in records of a dbpage.  The current window is
  // the current db file.
  //
  //  dbpage    = strname of page for db list
  //  dbline    = Skip this record
  //  fielddata = str of field data to compare
  //  ...       = optional field names to compare in each record, must be strings i.e. NAME=
  //
  //******************************************************************************
  str SearchPath( str fname, fpath );
  /*******************************************************************************
  Description: Searches for a filename in a given path
              TranslateCmdLine is called to parse out any metacommands BEFORE
              the search takes place.

  Returns:    complete path and filename, or a NUL string if
              the search was not successful.

  *******************************************************************************/

}


#DEFINE  EVENT_CURSOR_LINE      0x0001
#DEFINE  EVENT_CURSOR_COL       0x0002
#DEFINE  EVENT_WCMD             0x0004
#DEFINE  EVENT_KEY_ENHANCED     0x0008
#DEFINE  EVENT_DELETE_WIN       0x0010
#DEFINE  EVENT_ACTIVATE_WIN     0x0020
#DEFINE  EVENT_DEACTIVATE_WIN   0x0040
#DEFINE  EVENT_MOUSE_VSCROLL    0x0080
#DEFINE  EVENT_MODE_ENHANCED    0x8000