
#IFDEF windows
  #INCLUDE mew.sh
  #INCLUDE windows.sh
  #INCLUDE mewlib.sh
  #INCLUDE dialog.sh
  #include colors.sh
	#include mewhelp.sh

  macro_file MEWSYS;

  #DEFINE MasterHeader          "MEWHDRS.DB"
  #define GOTOLINE_HELPLINK     "GOTO LINE NUMBER"
  #define ALREADYLOAD_HELPLINK  "CONTENTS"
  #define FILELOCK_HELPLINK     "FILE LOCKING"

#ELSE
  macro_file MESYS;

  #DEFINE   MasterHeader ""

#ENDIF

#INCLUDE WINDOW.SH
#INCLUDE METOOLS.SH


/*******************************************************************************
														MULTI_EDIT MACRO FILE

MESYS is loaded automatically by Multi-Edit upon startup.  Multi-Edit will
abort if it cannot find the MESYS macro file.

MESYS contains the following macros:

UNDO            Executes an UNDO or REDO
SETSCRN         Sets up the screen based on the selected style.
INSTGL          Toggles insert/overwrite mode.
BSWORD          Deletes the word before the cursor.
DELWORD         Deletes the word under the cursor.
DELEOL          Delete to end of line.
DEL_TO_HOME     Deletes to the home position of the line
DEL             Processes the <DEL> key in a CUA compliant manner.
HOME            Implements the multi-stroke start of line/window/file function.
END             Implements the multi-stroke end of line/window/file function.
SHIFT_CURSOR    Handles SAA/CUA complient shifted cursor key use
CR              Implements carriage return with indenting styles.
TAB             Processes <TAB> and <ShiftTAB> in a CUA compiant manner
DATETIME        Stamps the date and time into a file.
GOTOLINE        Prompts for a line number to go to.
TOPBLOCK        Cursor to top of block.
ENDBLOCK        Cursor to end of block.
TOPWIN          Cursor to top of window.
BOTWIN          Cursor to bottom of window.
SCROLLUP        Scroll the window up one line.
SCROLLDN        Scroll the window down one line.
PAGEBRK         Insert a line with a page break.
SPACE           Inserts a space character at the current cursor position.
MEXTCHGLINE     Goes to next/previous changed line.
FIND_EXT        Retrieves the extension specific setup from EXT.DB.
SETTABS         Creates a temporary format line from the tab spacing parameter.
EXTSETUP        Setup a file/window format based on its extension.
PATHSEARCH      Searches for a filename in a given path
SETFILENAME     Adds in the default directory for an extension.
CREATEWINDOW    Creates a new window at the end of the window list.
LDFILES         Load files into windows.  Allows wildcards.
AUTOSAVE        Implements the automatic save feature.
AUTOSAVETIMER   Manages autosave timer events.
SETAUTOSAVE     Initializes timer events for AUTOSAVE
SETWINDOWNAMES  Creates sequential window letters for all editable windows.
KEYMAC_LOAD     Loads, saves, erases keystroke macros from KEYMAC.DB
PARMS1          Process command line switches.
PARMLOAD        Load files from the command line.

							 (C) Copyright 1991 by American Cybernetics, Inc.
********************************************************************************/


#IFNDEF windows
  #INCLUDE dosonly.s
#ENDIF


macro UNDO TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: UNDO

Description:  Performs an UNDO or REDO

Parameters:   /R        causes a REDO instead of an UNDO

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	if(  xpos('/R', caps(mparm_str),1)  ) {
		redo;
	} else {
		undo;
	}
}

macro INSTGL TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: INSTGL

Description:  toggles between insert and overwrite modes.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	Insert_Mode = NOT( Insert_Mode );
}

macro BSWORD TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: BSWORD

Description:  This macro deletes the word before the cursor(And you thought it
							had something to do with cow pies).

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	Push_Undo;
	if( read_only )
	{
		return();
	}

	if(  C_Col == 1  ) {
		BACK_SPACE;
		GOTO EXIT;
	}

	if(  at_eol  ) {
		eol;
		if(c_col == 1)
		{
			goto exit;
		}
	}
	LEFT;
	if(xpos(cur_char,'|255|9 ',1))
	{
		call Kill_White_Space;
	}
	else if(  XPOS( cur_char, word_delimits, 1)  ) {
		Call Kill_Delimits;
	//  Call Kill_White_Space;
	//  Call Kill_Word;
	//  Call Kill_White_Space;
	} else {
		Call Kill_Word;
	//  Call Kill_White_Space;
	}
	RIGHT;
	goto EXIT;


kill_white_space:
	if(  (xpos(cur_char,' |9|255',1)) & NOT(at_eol)  ) {
		del_char;
		if(  (C_Col > 1)  ) {
			left;
			Goto KILL_WHITE_SPACE;
		} else {
			Goto EXIT;
		}
	}
	RET;



KILL_WORD:
	if(  xpos(cur_char,word_delimits,1) == 0  ) {
		del_char;
		if(  (C_Col > 1)  ) {
			left;
			Goto KILL_WORD;
		} else {
			Goto EXIT;
		}
		right;
		goto exit;
	}
	RET;

KILL_DELIMITS:
	if((xpos(cur_char,word_delimits,1) != 0) && (xpos(cur_char,'|255|9 ',1) == 0)  ) {
		if(  NOT( at_eol )  ) {
			del_char;
		}
		if(  (C_Col > 1)  ) {
			left;
			Goto KILL_DELIMITS;
		} else {
			Goto EXIT;
		}
	}
	RET;

EXIT:
	Pop_Undo;
}

macro DELWORD TRANS2  {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: DELWORD

Description:  This macro deletes the word after the cursor

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	int jx,tr;

	if( read_only )
	{
		return();
	}

	tr = refresh;
	jx = 0;

	Push_Undo;

	if(  (AT_EOL)  ) {
		Del_Char;
		Goto Exit;
	}

	refresh = false;
	if( read_only )
			goto exit;
Delete1:
	/* IF on white space, then delete only to non-white space  */
	if(  xpos(cur_char,' |255|9', 1) != 0  ) {
	delete_white_space:
		while(  NOT(At_Eol) & (xpos(cur_char,' |255|9', 1) != 0)  ) {
			++jx;
			Del_Char;
		}
		if(  jx == 1  ) {
			call delete_word_delimits;
		}
		goto exit;
	}

	++jx;
	if(  (XPOS(Cur_Char,Word_Delimits,1) != 0)  ) {
		call delete_word_delimits;
		GOTO delete_white_space;
	}
	while(  (NOT(AT_EOL)) & (XPOS(Cur_Char,Word_Delimits,1) == 0)  ) {
		++jx;
		Del_Char;
	}
	goto delete_white_space;


delete_word_delimits:
	while(!AT_EOL && XPOS(Cur_Char,Word_Delimits,1)
		&& !xpos(cur_char,'|255|9 ',1) )
	{
		++jx;
		del_char;
	}
	ret;

EXIT:
	refresh = tr;
	Pop_Undo;

}

macro DELEOL TRANS2  {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: DELEOL

Description:  Deletes to the end of a line

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int jx;
	Jx = Length(Get_Line);
	Del_Chars(jx - c_col + 1);
}

macro DEL_TO_HOME TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: DEL_TO_HOME

Description:  Deletes to the home position of the line

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int jx = c_col;
	push_undo;
  first_word;
  if ( c_col >= jx )
    goto_col(1);
	del_chars( jx - c_col );
	pop_undo;
}

macro DEL TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

 NAME:         DEL

 DESCRIPTION:  Deletes character that the cursor is on OR
							 IF persistent blocks are OFF, AND a block is marked, then
							 that block is deleted.

 PARAMETERS:

 RETURNS:

*****************************09-29-91 02:17pm*******************************/
	if( !persistent_blocks && block_stat ) {
		delete_block;
	}
	else {
		del_char;
	}
}

#IFDEF windows

global
{
	str _KEY_TIMER "!_KEY_TIMER";
}

macro HOME TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: HOME

Description:  Implements the home function as follows:

			If the home key is pressed once, then the cursor will go to:
					A.  The current indent level if the cursor is beyond the current
							indent level.
					B.  Column 1 if the cursor is less than or equal to the current
							indent level.

			The following stuff requires that the /T=nn parameter be passed to HOME
			where nn is the number of milliseconds to wait for the next keypress.

			If the home key is pressed twice in rapid succession and the cursor is NOT
					at the top of the window, then the cursor will go to the top of the
					window.  If the cursor is at the top of the window, then the cursor
					will be moved to the top of the file.

			If the home key is pressed three times in rapid succession, then the cursor
					will be moved to the top of the file.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

  int tm = 36, tc ;
	str key_timer[40] = _KEY_TIMER;

	int last_time, last_op, new_op = 0, last_function;

	var_parse_int("/LT=", key_timer, last_time );
	var_parse_int("/LO=", key_timer, last_op );
	var_parse_int("/LF=", key_timer, last_function );

  if ((key1 != prev_key1) || (key2 != prev_key2) || (last_function != 1) || (last_keypress_time > (last_time + tm)) || ( last_op >= 2) )
	{
		new_op = 0;
	} else {
		if(c_col == 1)
      new_op = last_op + 1;
	}


	PUSH_UNDO;

	switch ( new_op )
	{
		case 1 :
							refresh = FALSE;
							while(  c_row > 1  ) {
								up;
							}
							refresh = TRUE;
							goto_col(1);
							redraw;
							break;

		case 2 :
							tof;
							break;

		case  0 :
		default:
							tc = c_col;
							if ( c_col > 1 )
							{
								first_word;
								if( (c_col < tc)  && (c_col > 1) )
								{
									--new_op;
									break;
								}
							}
							goto_col(1);
							break;
	}

exit:
  _KEY_TIMER = "/LT=" + str(last_keypress_time) + "/LO=" + str(new_op) + "/LF=" + str(1);
	POP_UNDO;
}

#ELSE
macro HOME TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: HOME

Description:  Implements the home function as follows:

			If the home key is pressed once, then the cursor will go to:
					A.  The current indent level if the cursor is beyond the current
							indent level.
					B.  Column 1 if the cursor is less than or equal to the current
							indent level.

			The following stuff requires that the /T=nn parameter be passed to HOME
			where nn is the number of milliseconds to wait for the next keypress.

			If the home key is pressed twice in rapid succession and the cursor is NOT
					at the top of the window, then the cursor will go to the top of the
					window.  If the cursor is at the top of the window, then the cursor
					will be moved to the top of the file.

			If the home key is pressed three times in rapid succession, then the cursor
					will be moved to the top of the file.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int  k1, k2, tm = 18, tc, t ;

	k1 = key1;  k2 = key2;

	PUSH_UNDO;
loop:
	tc = c_col;
	if(  tc > 1  ) {
		first_word;
	}
	if(  (c_col > 1) && (c_col < tc)  ) {
		goto exit;
	}
	if(  (at_eol)  ) {
		if(  tc > indent_level  ) {
			goto_col(indent_level);
		}
	} else {
		if(  c_col >= tc  ) {
			goto_col(1);
		}
	}
	goto_col( c_col );
	tm = Parse_Int( '/T=', MParm_Str );
	if(  ( tm > 0 )  ) {
		tm = tm / 55;
		call delay_check;
		if(  return_int  ) {
home_on:
			if(  (key1 == k1) && (key2 == k2)  ) {
				if(  c_row == 1  ) {
					goto try_tof;
				}
				refresh = FALSE;
				while(  c_row > 1  ) {
					up;
				}
				refresh = TRUE;
				goto_col(1);
				call delay_check;
				if(  return_int  ) {
		 home_on2:
					if((key1 == k1) && (key2 == k2)) {
	try_tof:
						tof;
						goto exit;
					}
				}
			}
			goto push_exit;
		}
	}

	goto exit;

delay_check:
	return_int = 0;
	t = system_timer;
	while(( system_timer - t) < tm) {
		if(check_key) {
			return_int = 1;
			break;
		}
	}
	ret;


push_exit:
	push_key( key1, key2 );

exit:
	POP_UNDO;
}
#ENDIF

#IFDEF Windows
macro END TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: END

Description:  Implements the end of line function as follows:
			If the end key is pressed once then, the cursor will go to the end of line.

			The following stuff requires that the /T=nn parameter be passed to END
			where nn is the number of milliseconds to wait for the next keypress.

			If the end key is pressed twice in rapid succession and the cursor is NOT
					at the bottom of the window, then the cursor will go to the bottom
					of the window.  If the cursor is at the bottom of the window, then
					the cursor will be moved to the end of the file.

			If the end key is pressed three times in rapid succession, then the cursor
					will be moved to the end of the file.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

  int tm = 36, tc ;
	str key_timer[40] = _KEY_TIMER;

	int last_time, last_op, new_op = 0, last_function;

	var_parse_int("/LT=", key_timer, last_time );
	var_parse_int("/LO=", key_timer, last_op );
	var_parse_int("/LF=", key_timer, last_function );
  if ((key1 != prev_key1) || (key2 != prev_key2) ||
      (last_function != 2) || (last_keypress_time > (last_time + tm)) ||
      ( last_op >= 2) )
	{
		new_op = 0;
	} else {
		if(at_eol)
       new_op = last_op + 1;
	}


	PUSH_UNDO;

	switch ( new_op )
	{
		case 1 :
						int wl = win_cheight();
						if( wl > 1)
						{
							refresh = false;
							while(  c_row < wl  ) {
								down;
							}
							eol;
							refresh = true;
							redraw;
						}
						break;

		case 2 :
							eof;
							break;

		case  0 :
		default:
							eol;
							break;
	}

exit:
  _KEY_TIMER = "/LT=" + str(last_keypress_time) + "/LO=" + str(new_op) + "/LF=" + str(2);
	POP_UNDO;
}


#ELSE
macro END TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: END

Description:  Implements the end of line function as follows:
			If the end key is pressed once then, the cursor will go to the end of line.

			The following stuff requires that the /T=nn parameter be passed to END
			where nn is the number of milliseconds to wait for the next keypress.

			If the end key is pressed twice in rapid succession and the cursor is NOT
					at the bottom of the window, then the cursor will go to the bottom
					of the window.  If the cursor is at the bottom of the window, then
					the cursor will be moved to the end of the file.

			If the end key is pressed three times in rapid succession, then the cursor
					will be moved to the end of the file.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	int  k1, k2, wl, tm, t ;

	k1 = key1;  k2 = key2;
	PUSH_UNDO;
loop:
	eol;

	tm = Parse_Int( '/T=', MParm_Str );
	if(  ( tm > 0 )  ) {
		tm = tm / 55;
		call delay_check;
		if(  return_int  ) {
	 end_on:
			if(  (key1 == k1) & (key2 == k2)  ) {
        wl = Win_CHeight () - 1;
				if(  c_row == wl  ) {
					goto try_eof;
				}
				refresh = false;
				while(  c_row < wl  ) {
					down;
				}
				eol;
				if(  at_eof  ) {
					eof;
				}
				refresh = true;
				redraw;
				call delay_check;
				if(  return_int  ) {
			end_on2:
					if(  (key1 == k1) & (key2 == k2)  ) {
	try_eof:
						eof;
						goto exit;
					}
				}
			}
			goto push_exit;
		}
	}

	goto exit;

delay_check:
	return_int = 0;
	t = system_timer;
	while(( system_timer - t) < tm) {
		if(check_key) {
			return_int = 1;
			break;
		}
	}
	ret;


push_exit:
	push_key( key1, key2 );

exit:
	POP_UNDO;
}
#ENDIF

#IFDEF Windows

/******************** Multi-Edit VOID Macro Function ************************

 NAME:         ShiftCursor( )

 DESCRIPTION:  Handles Shifted Cursor movement for  ME4WIN only.


*****************************04-21-94 12:15pm*******************************/
void ShiftCursor( ) trans2
{
	int k1 = key1,
      k2 = key2,
      need_redraw = FALSE,
			t_block_stat = block_stat;

	k2 = k2 & 0xfd;
	if ( marking )
	{
		 pass_key(k1,k2);
	}
	else
	{
		if( block_stat == 0)
		{
			str_block_begin;
		}
		else
		{

      if(persistent_blocks)
      {
			  if (((GetShiftUpTime == 0) ||
						 (GetShiftUpTime > global_int('~ShiftMark'))) ||
						 (global_int('~ShiftMark') == 0)) {
					str_block_begin;
				} else {
					goto continue;
				}
        //block_extend;
      }
      else
      {
        if(block_stat == 3)
        {

          if((c_line == block_line2) && (c_line == block_line1)
            && (c_col < (block_col2 + stream_block_mode))
            && (c_col > block_col1))
          {
            switch ( k1 )
            {
              case VK_DOWN :
              case VK_NEXT :
                block_colx = block_col1;
                block_linex = block_line1;
                break;

              case VK_RIGHT :
              case VK_END :
                block_colx = block_col1;
                block_linex = block_line1;
                marking = true;
                goto_col( block_col2 + 1  - stream_block_mode);
                break;

              case VK_UP :
              case VK_PRIOR :
                block_linex = block_line1;
                block_colx = block_col2 + 1 - stream_block_mode;
                break;

              case VK_LEFT :
              case VK_HOME :
                block_linex = block_line1;
                block_colx = block_col2 + 1 - stream_block_mode;
                marking = true;
                goto_col( block_col1);
                break;
            }
          }
        }
      }
CONTINUE:
      marking = true;
		}
		int winnum = 0;
		int wc = Wcmd_Key( 0, make_word(k1,k2) );
		if( wc ==  0 )
		{
			winnum = cur_window;
			wc = Wcmd_Key( cur_window, make_word(k1, k2) );
		}
		if( wc == 0 )
		{
			pass_key(k1,k2);
		}
		else
		{
      Wcmd_Execute( winnum, wc, wcmd_last_lparam );
		}
  /*  if(persistent_blocks)
    {
      Block_Extend;
    } */
		block_end;
	}
	set_global_int('~ShiftMark', GetMessageTime);
}
#ELSE
void shift_cursor TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: SHIFT_CURSOR

Description:  Handles SAA/CUA complient shifted cursor key use (mark a stream
							block)

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	str codes1[20] = '12346789|0',
			codes2[20] = '|71|72|73|75|77|79|80|81|116|115|145|141|132|118|119|117',
			m_str[8];
	int block_mode = parse_int("/M=", mparm_str),
			shift_stat = peek( 0, 0x417) & 0x0f;

	if ( block_mode == 0 )
	{
		block_mode = global_int("@SHFT_CURS_BLCK_MODE");
	}
	if ((block_mode < 1) || (Block_mode > 3))
		block_mode = 3;

	switch (block_mode) {
		case 1 :
			m_str = "MarkBlck";
			key2 = 0;
			break;
		case 2 :
			m_str = "MColBlck";
			key2 = 0;
			break;
		default :
			m_str = "MStrBlck";
	}

	if( !marking )
		rm("MEUTIL2^" + m_str);
  refresh = TRUE;
	pass_key( 0, key2 );
	do {
		if( check_key ) {
			if( key1 == 253 )
					key1 = 0;
			if( xpos( char(key1), codes1, 1 ) && xpos( char(key2), codes2, 1 )) {
				pass_key( 0, key2 );
			} else {
				push_key(key1, key2 );
				break;
			}
		}
    refresh = TRUE;
    goto_col(c_col);
	} while( peek( 0, 0x417) & shift_stat );
	rm("MEUTIL2^" + m_str);
}

#ENDIF

macro CR TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: CR

Description:  Performs a carriage return according to INDENT_STYLE:
							0 = None.  Just do a plain carriage return
							1 = Auto.  Indents to first word of previous line.
							2 = Smart.  Uses language specific smart indenting.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	str tstr;
	int jx, temp_ins;

	Push_Undo;

		/* If auto-indent then */
	if(  Indent_Style == 1  ) {
		JX = C_COL;
		FIRST_WORD;
		if(  At_EOL == False  ) {
			SET_INDENT_LEVEL;
		}
		GOTO_COL(JX);
		Goto ExitX;
	}
	if(  Indent_Style == 2  ) {
		TStr = Parse_Str('LS=',Global_Str('.'+Get_Extension(file_name)));
		if(  TStr != ''  ) {
			ERROR_LEVEL = 0;
			RM( TSTR + '^' + Copy(TStr,1,3) + '_IND' );
			if(  Error_Level != 0  ) {
				if(  (Error_Level == 5001)  ) {
					Error_Level = 0;
					Make_Message('Smart indent macro NOT found.');
				} else {
					RM('MEERROR');
				}
				Goto ExitX;
			}
			Goto Exit;
		}
		GOTO EXITX;
	}
EXITX:

			/* If in then insert a hard carriage return if one
			 is defined */
	if(   (HARD_CR != '') & (HARD_CR != '|0')  ) {
		Temp_Ins = Insert_Mode;
		Insert_Mode = True;
		Text(Hard_CR);
		CR;
		if(  wrap_stat  ) {
			word_wrap_line( FALSE, TRUE );
		}
		Insert_Mode = Temp_Ins;
	} else {
		jx = c_col;
		CR;
		if(  (insert_mode == false) & (jx >= indent_level)  ) {
			goto_col(indent_level);
		}
	}
EXIT:
	Pop_Undo;
}

macro TAB TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

 NAME:         TAB

 DESCRIPTION:  Handles <TAB>/<SHFTTAB>.  If persistent_blocks is NOT on,
							 then if a block is marked the block will be indented or
							 undented

 PARAMETERS:   /M=0     Tab right
									1     Tab left

 RETURNS:      Nothing.

*****************************09-30-91 01:47pm*******************************/

	int m = parse_int('/M=', mparm_str );

	if( !persistent_blocks && (block_stat != 0)) {
		if( m )
			rm('Meutil2^UndBlk');
		else
			rm('Meutil2^IndBlk');
	}
	else
		if( m )
			tab_left;
		else
			tab_right;

}

macro DATETIME TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: DATETIME

Description:  Writes the current date and time onto the current line.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
   str time_str[10] = STR_DEL(TIME,6,3);

#IFDEF WINDOWS
  str sTime[2];
  GetProfileString("intl","sTime", ":",sTime,2);
  if (xpos(sTime,time_str,1) == 2) {
    time_str = STR_DEL(TIME,5,3);
  }
#ENDIF

   TEXT( DATE + ' ' + time_str);
}

/****************************Multi-Edit Macro********************************

 NAME:         CenterLn

 DESCRIPTION:  Centers the current line verticall in the window.

*****************************08-17-93 05:25pm*******************************/
macro CenterLn
{
	int t_c_row = 0;
	int t_refresh = refresh;
	int tl = c_line;
	refresh = false;

	while( (t_c_row != c_row) && (C_Row > ((Win_Y2 - Win_Y1) / 2))  ) {
		t_c_row = c_row;
		Up;
	}
	while( (t_c_row != c_row) && (C_Row < ((Win_Y2 - Win_Y1) / 2))  ) {
		t_c_row = c_row;
		Down;
	}
	goto_line( tl );
	refresh = t_refresh;
  redraw;
}

macro GOTOLINE TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: GOTOLINE

Description:  Prompts for a line number, then moves the cursor to that line.

Parameters:
							/X=   The column to place the prompt box.
							/Y=   The line to place the prompt box.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

		int jx,jj;
		Return_Str = '';
		Return_Int = Global_Int('@GOTOLINE#');
		if(  return_int < 1  ) {
			return_int = 1;
		}
#ifdef WINDOWS
		RM('userin^QUERYBOX /N=1/MIN=1/L=' + parse_str('/Y=', mparm_str) +
          '/C=' + parse_str('/X=', mparm_str) + '/W=12/P=Line number: /T=Go To Line/H=' +
					GOTOLINE_HELPLINK);
#else
		RM('userin^QUERYBOX /N=1/MIN=1/L=' + parse_str('/Y=', mparm_str) +
          '/C=' + parse_str('/X=', mparm_str) + '/W=12/P=Line number: /T=Go To Line/H=GOTOLINE');
#endif
		if(  Return_Str == 'TRUE'  ) {
			refresh = TRUE;
			GOTO_LINE(return_int);
			Set_Global_Int('@GOTOLINE#', return_int);
			redraw;
			return_int = 100;
		} else {
			return_int = 0;
		}
}

/*---------------12-30-92 12:39pm-------------------
 Moves the cursor to line l.  Unlike Goto_Line, this
 function moves the cursor as if the up or down
 arrow keys were used.
--------------------------------------------------*/
void cursor_to_line( int l )
{
	int tr = refresh;
	refresh = false;
	if( c_line > l )
	{
		if(( c_line - l) <= (win_y2 - win_y1))
		{
			while ( c_line > l )
			{
				up;
			}
		}
		else
		{
			rm("TOPWIN");
			goto_line(l);
		}
	}
	else if(c_line < l)
	{
		if(( l - c_line) <= (win_y2 - win_y1))
		{
			while ( c_line < l )
			{
				down;
			}
		}
		else
		{
			rm("BOTWIN");
			goto_line(l);
		}
	}
	refresh = tr;
}

macro TOPBLOCK TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: TOPBLOCK

Description:  Take cursor to top of currently defined block

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	int tpersist = persistent_blocks;
	persistent_blocks = true;

	if(  Block_Stat != 0  ) {
		cursor_to_line(block_line1);
		if(  Block_Stat != 1  ) {
			Goto_Col( Block_Col1 );
		}
		Redraw;
	}
	persistent_blocks = tpersist;
}

macro ENDBLOCK TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: ENDBLOCK

Description:  Take cursor to bottom of currently defined block

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	int tpersist = persistent_blocks;
	persistent_blocks = true;
	if(  Block_Stat != 0  ) {
		cursor_to_line(block_line2);
		if(  Block_Stat != 1  ) {
			Goto_Col( Block_Col2 );
		}
		Redraw;
	}
	persistent_blocks = tpersist;
}

macro TOPWIN TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: TOPWIN

Description:  Take cursor to top of the window

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
  int trefresh = Refresh;
  Refresh = False;

	while(  (C_Row > 1)  ) {
		Up;
	}
  Refresh = tRefresh;
}

macro BOTWIN TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: BOTWIN

Description:  Take cursor to bottowm of the window

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

  int trefresh = Refresh;
  Refresh = False;
#ifdef windows
  while ( C_Row < Win_CHeight () )
#else
  while(  (C_Row < ((Win_Y2 - Win_Y1) - 1))  )
#endif
  {
		Down;
	}
  Refresh = tRefresh;
}

macro SCROLLUP TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: SCROLLUP

Description:  Scroll screen up one line

Parameters:   /MC=1 move cursor with scrolled line if possible

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int  jx ;
	jx = refresh;
	refresh = false;
	Goto_Line(C_Line + 1);
	if (Parse_Int('/MC=',MParm_Str)) {
		if (C_Row > 1) {
			Up;
		}
	}
	Redraw;
	refresh = jx;
}

macro SCROLLDN TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: SCROLLDN

Description:  Scroll screen down one line

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int  jx ;
	jx = refresh;
	refresh = false;
	Goto_Line( C_Line - 1 );
	if (Parse_Int('/MC=',MParm_Str)) {
		if (C_Row < (Win_Y2 - Win_Y1 - 1)) {
			Down;
		}
	}
	Redraw;
	refresh = jx;
}

macro PAGEBRK TRANS {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: PAGEBRK

Description:  Insert a page break

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	push_undo;
	UP;
	EOL;
	CR;
	GOTO_COL(1);
	TEXT( PAGE_STR );
	UP;
	DOWN;
	pop_undo;
}

macro SPACE {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: SPACE

Description:  This macro simply puts a space character at the current cursor
							position.  It is intended to be used with <CtrlSpace>,
							<CtrlShiftSpace> and <AltShiftSpace> in the keymap.


							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	Text(" ");
}

void NextChgLine (int back = parse_int("/BACK=", mparm_str))
/*******************************************************************************
																MULTI-EDIT MACRO

Name: NextChgLine

Description:  Positions the cursor on the next or previous changed
              line.  If no more lines are changed, no action takes
              place.

Parameters:   /BACK=1  Looks backwards from current line.

               (C) Copyright 1994 by American Cybernetics, Inc.
*******************************************************************************/
{
  int or = refresh;
  refresh = false;
  mark_pos;
  if ( !back ) {
    down;
    while ( (!line_changed) && (!at_eof) ) {
      down;
    }
  } else {
    up;
    while ( (!line_changed) && (c_line != 1) ) {
      up;
    }
  }
  if ( (at_eof) || ((c_line == 1) && !line_changed) ) {
    goto_mark;
    beep;
    make_message("No more changed lines");
  } else
#IFDEF WINDOWS
    Set_Highlight( c_line, 0, c_line, 2047 );
#ENDIF
    pop_mark;

  refresh = or;
}


macro FIND_EXT {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: FIND_EXT

Description: Makes sure extension specific setup globals are loaded for
	the passed extension.

Parameters:   /EXT=str    Str is the extension to use (including the
													leading ".").

Returns:
			RETURN_STR contains the name of the global to use to access
			the extension specific setup.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	str Ext[8];

	Ext = Caps(Parse_Str('/EXT=',MParm_Str));

	if(  (Global_Str(Ext) == '')  ) {
    reg_exp_stat = TRUE;
		RM('GET_DB_RECORD /DBF=EXT/F=MECONFIG/NDF=1/DPT=EXT.DB/GLO=' + Ext +
			"/FV=" + make_literal(Copy(Ext,2,3)) + " |,|;|");
		if (return_int < 1) {
// The regular expressions in /FV= allow multiple file extensions per record
// example C;INC;H
			RM('GET_DB_RECORD /DBF=EXT/F=MECONFIG/NDF=1/DPT=EXT.DB/GLO=' + Ext +
				"/FV=[~]*[ ,;]" + make_literal(Copy(Ext,2,3)) + " |,|;|");
		}
//    RM('GET_DB_RECORD /DBF=EXT/F=MECONFIG/NDF=1/DPT=EXT.DB/GLO=' + Ext + '/FV=' + Copy(Ext,2,3));
		if(  (Return_Int < 1)  ) {
				RM('GET_DB_RECORD /DBF=EXT/F=MECONFIG/NDF=1/DPT=EXT.DB/GLO=' + Ext + '/FV=DEFAULT');
			Return_Int = -1;
		} else {
			Return_Int = 0;
		}
		if(  xpos( ext + '', Global_Str('EXTENSIONS'), 1 ) == 0  ) {
			Set_Global_Str('EXTENSIONS',Global_Str('EXTENSIONS') + Ext + '');
		}
	} else {
		Return_Int = 0;
	}
EXIT:
	return_str = ext;
}

macro SETTABS {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: SETTABS

Description: Sets up even interval tab spacing.

Parameters: /TS=nn    Tab spacing.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int  Tab_Size, jx, margin ;
	str  tformat[2048];
	Tab_Size = Parse_Int('/TS=', mparm_str );
	Margin = Parse_Int('/RM=', mparm_str );
	if(  (Margin < 1) | (Margin > 2048)  ) {
		Margin = 128;
	}
	TFormat = ' ';
	while(  SVL(TFormat) < Margin  ) {
		Jx = 1;
		while(  jx < Tab_Size  ) {
			TFormat = TFormat + ' ';
			++jx;
		}
		TFormat = TFormat + '|16';
	}
	Format_Line = TFormat;
	Format_Stat = False;
}


macro EXTSETUP {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: EXTSETUP

Description:  Is called to setup a window/file based on the files extension.
						If the extension is not found in the global extension list, then
						the default extension setup is used.

Parameters:
							/PRE=  If 1, then post-load macro will not be run, such as would
							be the case if this was run after the file had already been loaded.

							/FTO=x File type override
										1 = DOS
										2 = UNIX
										3 = Binary
									255 = Do NOT override the line_terminator value or the
												fixed line length value



Returns:  Return_Str = default directory for file.
							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	int  t_cb_t_color = cb_t_color,
					post = parse_int('/POST=', mparm_str)
					 ;
	str TStr1[2048],TStr2,Tstr3;
	int JX,jy,T_File_Changed = File_Changed;

	if(  xpos('/EXT=', mparm_str, 1) != 0  ) {
		tstr3 = parse_str('/EXT=', mparm_str );
	} else {
		tstr3 = get_extension( file_name );
	}
	RM( 'FIND_EXT /EXT=.' + tstr3 );
	Tstr3 = Return_Str;
	TStr1 = Global_Str(tstr3);

	Wrap_Stat = Parse_Int('WW=', TStr1 );
	indent_style = Parse_Int('IND=', TStr1 );
	if(  (Indent_Style > 0)  ) {
		Indent_Style = Indent_Style - 1;
	}
	Doc_Mode = Parse_Int('DOC=', TStr1 );

	if(  post == 0  ) {
		jx = parse_int('/FTO=',mparm_str);

		if(jx != 255 )
		{
      filetype_override = 0;
			fixed_line_length = 0;
			if(jx == 0)
				jx = parse_int('FT=', tstr1 );

			if(  jx == 2  ) {
				line_terminator = '|10|0';
			} else if(  jx == 3  ) {
				line_terminator = '|0';
				fixed_line_length = parse_int('BRL=', tstr1);
				if(fixed_line_length == 0)
				{
					fixed_line_length = 16;
				}
			} else {
				line_terminator = '|13|10';
        if( jx == 0 )
        {
          filetype_override = 255;
        }
			}
		}
	}
	if(  Format_Stat == 0  ) {
		if(  (Parse_Int('UF=',TStr1) == 0)  ) {
			JX = Parse_Int('TS=',TStr1);
			if(  (JX != 0)  ) {
				Use_Format_Line = false;
				right_margin = Parse_Int('RM=',TStr1);
				if(  (right_margin == 0)  ) {
					Right_Margin = 80;
				}
				if( ( post == 0 ) || (format_line == "") ) {
					RM('SETTABS /TS=' + str( jx ) + '/RM=' + str(right_margin) );
	/* Here, we are deleting any defined format line from the global to conserve ram */
					Jx = XPos('FORMAT=',Tstr1,1);
					if(  (Jx)  ) {
						Jy = Length(Parse_Str('FORMAT=',Tstr1));
						Set_Global_Str(TStr3,Str_Del(TStr1,Jx,Jy + 8));
					}
				}
			} else {
				Goto USE_FORMAT;
			}
		} else {
USE_FORMAT:
			TStr2 = Parse_Str('FORMAT=',TStr1);
			if(  Tstr2 != ''  ) {
				Format_Line = TStr2;
				Format_Stat = false;
				Use_Format_Line = true;
			}
			if(  (XPos('R',Caps(Format_Line),1) == 0)  ) {
/* If there is no right_margin defined in the format line, see if there is one
defined explicity */
				Right_Margin = Parse_Int('RM=',TStr1);
			}
		}
	}
	tstr3 = parse_str('CC=', tstr1 );
#IFNDEF Windows
	if(  xpos('/CTC=', tstr3, 1) != 0  ) {
		t_color = parse_int( '/CTC=', tstr3);
		c_color = parse_int( '/CCC=', tstr3);
		b_color = parse_int( '/CBC=', tstr3);
		h_color = parse_int( '/CHC=', tstr3);
		s_color = parse_int( '/CSC=', tstr3);
		l_color = parse_int( '/CLC=', tstr3);
		lb_color = parse_int( '/CLBC=', tstr3);
		eof_color = parse_int( '/CEC=', tstr3);
		window_color_stat = TRUE;
	}
	else {
		t_color = w_t_color;
		c_color = w_c_color;
		b_color = w_b_color;
		h_color = w_h_color;
		s_color = w_s_color;
		l_color = w_l_color;
		lb_color = w_lb_color;
		eof_color = w_eof_color;
		window_color_stat = FALSE;
	}
#ELSE
  if ((tstr3 != '') && ( tstr3 != Global_str('@Default_Color') ))
  {
    SetTemplateAttrs (cur_window, tstr3);
    window_color_stat = TRUE;
  }
	else {
		window_color_stat = FALSE;
	}
#ENDIF
	if( parse_int('ATX=', tstr1 ) )
    #IFDEF windows
    key_to_window( 32, 'LANGUAGE^TEMPLATE /S=1' );
    #ELSE
		key_to_window( <SPACE>, 'LANGUAGE^TEMPLATE /S=1' );
    #ENDIF
	else
    #IFDEF windows
    key_to_window( 32, '' );
    #ELSE
		key_to_window( <SPACE>, '' );
    #ENDIF

	if ( Parse_Int('/PRE=',MParm_Str)==0 )
	{
		TStr3 = Parse_Str('LS=',tstr1);
		RM(Copy(tstr3,1,8)+'^'+Copy(tstr3,1,3)+'SETX');
		if (!parse_int("/NOSYNTAX=",Mparm_Str)) {
			RM("SET_SYNTAX_PARMS");
		}
		error_level = 0;
		TStr3 = Parse_Str('MAC=',TStr1);
		if ( ''!=TStr3 )
		{
			int fsa=File_Search_ATTR;
			str fsr[80]=File_Search_REC;
			File_Changed = T_File_Changed;
			RM(TStr3);
			T_File_Changed = File_Changed;
			File_Search_ATTR=fsa;
			File_Search_REC=fsr;
		}
	}
	if(post && (copy(line_terminator,1,1) == '|0')  && !(window_attr & 0x20))
	{
		if(global_int("BINARY_MODE"))
			rm("hex^HexWindow");
	}
	File_Changed = T_File_Changed;
}

macro SET_SYNTAX_PARMS {
/*
*/
	str language[40] = parse_str("/LANG=",mparm_str),
			t_str, sc1, ac1[128] = "",
			rw1,rw2,rw3,rw4;
	int t_int,
			ta,
			reinit = parse_int("/REINIT=",mparm_str),
			reset =  parse_int("/RESET=", mparm_str),
			parse_mode = 0,
			case_sensitive;
	char tc;

	if (!svl(language))
		language = parse_str("LS=",Global_Str("." + Get_Extension(file_name)));
	else
		reinit = true;

	if (svl(language)) {
    str g_str [2048],
        g_name [20] = "@" + copy(language,1,3) + "_SYNTAX_PARMS";

		if ((global_str(g_name) == "") || RESET) {
      RM("GET_DB_RECORD /F=MECONFIG/NDF=1/DPT=LANGUAGE.DB/DBF=LANG/FV="
        + language
				+ "/GLO=" + g_name);
		}
		g_str = global_str(g_name);
		var_remove_str("LANG=",g_str);
		if(svl(g_str) != 0)
		{
			if(g_str != "RECORD_SET")
			{
	// if we are not case sensitive, capitalize all keywords
				case_sensitive = parse_int("CS=",g_str);
				rw1 = remove_space(parse_str("RW1=",g_str));
				if (!case_sensitive)
					rw1 = caps(rw1);
				rw2 = remove_space(parse_str("RW2=",g_str));
				if (!case_sensitive)
					rw2 = caps(rw2);
				rw3 = remove_space(parse_str("RW3=",g_str));
				if (!case_sensitive)
					rw3 = caps(rw3);
				rw4 = remove_space(parse_str("RW4=",g_str));
				if (!case_sensitive)
					rw4 = caps(rw4);
	// parse out first character of each of the keywords fields
				t_str = rw1;
				t_int = 2;
				call PARSE_SCAN_CHARS;
				t_int = svl(t_str) + 1;
				t_str = t_str + rw2;
				call PARSE_SCAN_CHARS2;
				t_int = svl(t_str) + 1;
				t_str = t_str + rw3;
				call PARSE_SCAN_CHARS2;
				t_int = svl(t_str) + 1;
				t_str = t_str + rw4;
				call PARSE_SCAN_CHARS2;
				sc1 = t_str;

				t_int = 2;
				t_str = /* t_str + */
				copy(parse_str("OC1=",g_str),1,1) +
				copy(parse_str("CC1=",g_str),
								length(parse_str("CC1=",g_str)),1) +
				Copy(parse_str("OC2=",g_str),1,1) +
				copy(parse_str("CC2=",g_str),
								length(parse_str("CC2=",g_str)),1) +
				parse_str("SYM=",g_str) +
				parse_str("STR=",g_str) +
				parse_str("EOL=",g_str) +
				parse_str("EOL2=",g_str)
				;
				parse_mode = 1;
				call PARSE_SCAN_CHARS2;
#ifndef WINDOWS
        str attr_str = Global_Str ("&SYNTAX_COLORS");

				set_keywords(copy(language,1,3) + "_KEYS",   // name
					case_sensitive,// TRUE = case sensitive
					sc1,
					t_str, // + parse_str("SYM=",g_str),  // scan chars
					//  reserved words 1
					" " + RW1 + " ",
					// reserved words 2
					" " + RW2 + " ",
					// reserved words 3
					" " + RW3 + " ",
					// reserved words 4
					" " + RW4 + " ",
					ac1,
          parse_int("/RWC=",attr_str),    // reserved words attr
          parse_str("SYM=",g_str),       //Symbols
          parse_int("/SYC=",attr_str),    // symbol attribute
          parse_str("STR=",g_str),       //string chars,
          parse_int("/SCC=",attr_str),    //string attr
          parse_str("LIT=",g_str),       // literal char
          parse_str("EOL=",g_str),       // eol comment
          parse_int("/ECC=",attr_str),    // eol comment attr
          parse_int("EOC=",g_str ),      // eol column
          parse_str("EOL2=",g_str),      // eol comment
          parse_int("/ECC=",attr_str),    // eol comment attr
          parse_int("EOC2=",g_str ),     // eol column
          parse_str("OC1=",g_str),       //open comment 1
          parse_str("CC1=",g_str),       //close comment 1
          parse_int("/C1C=",attr_str),    // open/close comment 2 attr
          parse_str("OC2=",g_str),       //open comment 2
          parse_str("CC2=",g_str),       // close comment 2
          parse_int("/C2C=",attr_str),    // open/close comment 2 attr
          parse_str("NC=",g_str),        // numeric chars
          parse_int("/NCC=",attr_str)     // numeric chars attr
					);
#else
        str attr_str [80];
        str aname [25] = "~" + copy (language, 1, 3) + "_SYNTAX_COLORS";
        if (Global_Str (aname) == "")
        {
          attr_str = Global_Str ("~SYNTAX_COLORS");
        } else {
          attr_str = Global_Str (aname);
        }

        set_keywords(copy(language,1,3) + "_KEYS",  // name
          case_sensitive,                           // TRUE = case sensitive
					sc1,
          t_str,                  // scan chars
					//  reserved words 1
					" " + RW1 + " ",
					// reserved words 2
					" " + RW2 + " ",
					// reserved words 3
					" " + RW3 + " ",
					// reserved words 4
					" " + RW4 + " ",
					ac1,
          parse_int("/RWC=",attr_str),    // reserved words attr
          parse_str("SYM=",g_str),       // Symbols
          parse_int("/SYC=",attr_str),    // symbol attribute
          parse_str("STR=",g_str),       // string chars,
          parse_int("/SCC=",attr_str),    // string attr
          parse_str("LIT=",g_str),       // literal char
          parse_str("EOL=",g_str),       // eol comment
          parse_int("/E1C=",attr_str),    // eol comment attr 1
          parse_int("EOC=",g_str ),      // eol column
          parse_str("EOL2=",g_str),      // eol comment
          parse_int("/E2C=",attr_str),    // eol comment attr 2
          parse_int("EOC2=",g_str ),     // eol column
          parse_str("OC1=",g_str),       // open comment 1
          parse_str("CC1=",g_str),       // close comment 1
          parse_int("/C1C=",attr_str),    // open/close comment 2 attr
          parse_str("OC2=",g_str),       // open comment 2
          parse_str("CC2=",g_str),       // close comment 2
          parse_int("/C2C=",attr_str),    // open/close comment 2 attr
          parse_str("NC=",g_str),        // numeric chars
          parse_int("/NCC=",attr_str)     // numeric chars attr
					);

#endif
				set_global_str(g_name,"RECORD_SET");
			}
			if (!reinit)  {
				keywords_str = copy(language,1,3) + "_KEYS";
			}
		}
	}
	goto EXIT;

PARSE_SCAN_CHARS:
	while (((tc = str_char(t_str,t_int)) != " ") && (t_int <= svl(t_str))) {
		t_str = str_del(t_str,t_int,1);
			// TMJ - 10-30-92 10:51am - Locate NON-ALPHA-NUMERIC chars
		if( !xpos( caps(tc),  "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_",1)) {
			if ( !xpos( tc, ac1,1) )
			{
				ac1 += tc;
			}
		}
	}
	if (t_int < svl(t_str)) {
		t_str = str_del(t_str,t_int,1); // remove the space
PARSE_SCAN_CHARS2:
		if (xpos(str_char(t_str,t_int),copy(t_str,1,t_int - 1),1)) {
//if this char is already in the string, delete it
			t_str = str_del(t_str,t_int,1);
		} else if ((t_int < svl(t_str)) || (parse_mode))
			++t_int;
		if (parse_mode) {
			if (t_int > svl(t_str))
				RET;
			goto PARSE_SCAN_CHARS2;
		}
		goto PARSE_SCAN_CHARS;

	}
	RET;

EXIT:
}

macro SETFILENAME TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: SETFILENAME

Description:  Completes a filename (no wildcards).  Adds in the default
	directory for that extension if none is specified.

Parameters:   Return_Str = Filename

Returns:      Return_Str = new Filename
							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	str  tstr[128], gstr[20] ;
	int  jx ;

	tstr = return_str;
	if(  get_path(tstr) == ''  ) {
		RM( 'FIND_EXT /EXT=.' + get_extension( tstr ) );
		gstr = return_str;
    return_str = SearchPath(tstr,TranslateCmdLine(parse_str('DIR=',Global_Str(gstr)), tstr));
    if(  return_str == ""  ) {
      return_str = TranslateCmdLine(parse_str('DIR=',Global_Str(gstr)), tstr);
			jx = xpos(';', return_str, 1);
			if(  jx == 0  ) {
				jx = length(return_str) + 1;
			}
			return_str = copy(return_str,1, jx - 1);
			if(  (Length(return_str) > 0) & (copy(return_str,Length(Return_Str),1) != '\')  ) {
				return_str = return_str + '\';
			}
			return_str = return_str + tstr;
		}
	}
Expand_Exit:
	return_str = fexpand( return_str );
}

void CreateWindow (int nodef = parse_int ("/ND=", mparm_str))
{
/*******************************************************************************
																MULTI_EDIT MACRO

Name: CreateWindow

Description: Creates a new window at the end of the window list.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int  jx, tr, x1, x2, y1, y2, ox1,oy1 ;
	str  tstr[40] ;
	tr = refresh;
	refresh = FALSE;

	jx = cur_window;
  Switch_Window(Window_Count);
	Error_Level = 0;
  Create_window;
	if(  error_level == 0  ) {
#ifndef Windows
		x1 = min_window_col;
		x2 = max_window_col;
		y1 = min_window_row;
		screen_num = global_int('@SCREEN_COUNT') + 1;
		if(  screen_num <= 1  ) {
			screen_num = 2;
		}
		jx = (global_int( '~WIN_BOTTOM_BORDER') == 0) * (global_int('ICON_ROWS') != 0);
		y2 = max_window_row - Global_Int( 'ICON_ROWS') - jx;
		set_global_int('@SCREEN_COUNT', screen_num );
		tstr = global_str('@INIT_WINDOW_PARMS');
    if(  tstr != ''  ) {
			x1 = parse_int('/X1=', tstr);
			x2 = parse_int('/X2=', tstr);
			y1 = parse_int('/Y1=', tstr);
			y2 = parse_int('/Y2=', tstr);
			if(  x1 < min_window_col  ) {
				x1 = min_window_col;
			}
			if(  (x2 == 0) | (x2 > max_window_col)  ) {
				x2 = max_window_col;
			}
			if(  y1 < min_window_row  ) {
				y1 = min_window_row;
			}
			if(  (y2 == 0) | (y2 > (max_window_row - Global_Int( 'ICON_ROWS') - jx)  )) {
				y2 = max_window_row - Global_Int( 'ICON_ROWS') - jx;
			}
		}
		size_window( x1, y1, x2, y2 );
#else
    if ( (Global_Int ("@MAXIMIZE_WINDOWS") != 0) && (nodef == 0) )
    {
      make_window_visible (3);  // show maximized  SW_SHOWMAXIMIZED
    } else {
      make_window_visible (1);
    }

#endif
	} else {
		switch_window(jx);
	}

	refresh = TR;
}

macro ldFiles trans2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: LDFILES

Description:  Loads files into windows.  Handles wild card characters.
						Normally, LDFILES checks to see if the file is already loaded.

Parameters: RETURN_STR = the filename;
						/LC=load_count
						/MC=max_count
						/NW=1     no wildcards allowed.
						/NC=1     no check for the file already loaded.
						/PRE=   Will pass this parameter to EXTSETUP
						/CW=1   create new window immediately, regardless of /LC=
								2   create new window ONLY if the current window is NOT empty.
						/NHA=1  No History Add - don't add filenames loaded to history list.
						/DE=1   Use default extension if applicable
						/FTO=x  Filetype override
										1 = DOS
										2 = UNIX
										3 = Binary
										255 = Leave line_terminator values alone
						/TAG=x  Load using tag list in specified window id   // ldh //tmj

						If LDFILES is entered with LOAD_COUNT
						set to zero, then the first file will be loaded into the current
						window.  Subsequent files will be loaded into new windows.

Returns:    Return_Int = LOAD_COUNT.

						Also, Global integer LOAD_COUNT will be set to /LC=nn + the
						number of files loaded.

Note: Changes marked with "// ldh" were made 13-Sep-93 to allow loading files
			from a tag list.  Need to support tagging file in file_prompt. // ldh

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int  Load_Count, lc2 , good_load, Jx, Jy;
  int  redraw_state =  0;
	str  Tstr[128], TStr2[128], t_search_rec[64] ,MSTr[128];
	int  t_win, tr, max_count, wild_cards, load_check,T_File_Search_Attr ;
	int  xload = FALSE, fto = parse_int("/FTO=",mparm_str),
			 tag = parse_int("/TAG=", mparm_str);                 // Tmj
  call redraw_off;
	good_load = False;
	t_search_rec = file_search_rec;
	T_File_Search_Attr = File_Search_Attr;
	File_Search_Attr = $27;

	TStr = return_str;

	load_check = (parse_int('/NC=', mparm_str) == 0);
	wild_cards = (parse_int('/NW=', mparm_str) == 0);
	Load_Count = parse_int('/LC=',mparm_str);
	max_count = parse_int('/MC=',mparm_str);
	if(  max_count == 0  ) {
		max_count = 1000;
	}
	lc2 = parse_int('/CW=', mparm_str );
	if ( lc2 == 2 )
	{
		lc2 = 1;
		if(  (caps(file_name) == '?NO-FILE?') & (file_changed == FALSE)  ) {
      if((lines_in_mem == 0) && (eof_in_mem))
      {
       lc2 = 0;
			}
		}
	}
// <<< Added 13-Sep-93 ldh ****************************************************
	if (tag) {                                               // Tmj

		int ow = window_id,
				new_win = ow,
				srf = refresh;

		refresh = FALSE;
		if(switch_win_id(tag))                                // Tmj
		{
			tof;
			tstr = shorten_str(get_line);
			if (tstr != "") {                                // Tmj
				// lc2 = 1;                                    // Tmj
				if ((parse_int("/NHA=", mparm_str) == 0)) {
          // Mods below by AJH 12/30/94 3:46PM to add multiple loaded files
          // to history list.  To enable, set global integer below to 1
          if ( global_int("!MULTI_FILE_HISTORY") )
          {
            return_str = tstr;
            do
            {
              rm("userIn^history_list /M=1/HISTORY=FILE_HISTORY");
              down;
              return_str = shorten_str(get_line);
            } while ( !at_eof );
            tof;
          }
          else
          {
             rm("userIn^history_list /M=1/HISTORY=FILE_HISTORY");
          }
          // End of mods by AJH 12/30/94 3:47PM
        }

				int sfto = fto;
				while (TRUE) {
					if (jx = xpos("/FTO=", tstr, 1)) {
						fto = parse_int("/FTO=", tstr);
						tstr = shorten_str(copy(tstr, 1, jx - 1));
					}
					else {
						fto = sfto;
					}
					if (wild_cards && (pos("*", tstr) || pos("?", tstr))) {
						tstr2 = get_path(tstr);
						if (!first_file(tstr)) {
							do {
								tstr = tstr2 + last_file_name;
								switch_win_id(ow);
								call do_load_file;
								new_win = window_id;
								if (check_key && ((key1 == 27) && (key2 == 1)) ||
										(load_count >= max_count)) {
									break;
								}
								switch_win_id(tag);
							} while (!next_file);
						}
					}
					else if (file_exists(tstr)) {   // Check for file
						switch_win_id(ow);
						call do_load_file;
						new_win = window_id;
					}
					if (check_key && ((key1 == 27) && (key2 == 1)) ||
							(load_count >= max_count)) {
						break;
					}
					switch_win_id(tag);
					down;
					if ((tstr = shorten_str(get_line)) == "") {
						break;
					}
				}
				delete_window;
				switch_win_id(new_win);
			}                                                // Tmj
			refresh = srf;
		}
	}
// ****************************************************************** Added >>>
	else if (wild_cards && (pos("*", tstr) || pos('?', tstr))) {        // ldh
		if(  parse_int('/NHA=', mparm_str) == 0  ) {
			RM('USERIN^HISTORY_LIST /M=1/HISTORY=FILE_HISTORY');
		}
		TStr2 = Get_Path(TStr);
		if(  FIRST_FILE(TSTR) == 0  ) {
			TStr = TStr2 + LAST_FILE_NAME;
			Call Do_Load_File;
			while(  (NEXT_FILE == 0) & (Load_Count < max_count)  ) {
				TStr = TStr2 + LAST_FILE_NAME;
				Call Do_Load_File;
				if (check_key && ((key1 == 27) && (key2 == 1))) {             // ldh
					break;                                                      // ldh
				}                                                             // ldh
			}
		}
	} else {
/* Support for default file extensions T.R. */
		if(  (Parse_Int('/DE=',MParm_Str))  ) {
			if ( !XPos(".",Truncate_Path(Tstr),1) && (File_Exists(Tstr) != 1) ) {
				Tstr2 = Global_Str('@DEFAULT_EXT_LIST');
				if(  (Svl(Tstr2))  ) {
/* Parse out each extension one at a time until a file is found with that
extension, or we come to the end of the list. */
					Jy = 0;
MORE_EXTS:
					if(  (jy > Svl(Tstr2))  ) {
/* If we come to the end of the list, use no extension, unless the global integer
points to a desired default, and consider it a new file. */
						Mstr = '';
						Tr = Global_Int('@DEFAULT_EXT_POS');
						while(  (Tr)  ) {
							Call PARSE_EXT;
							--Tr;
						}
						Goto GOT_EXT;
					}
					Call PARSE_EXT;

					Return_Str = Tstr + Mstr;
					RM('SETFILENAME');
					if(  (File_Exists(Return_Str) == 1)  ) {
						Goto GOT_EXT;
					}

					Goto MORE_EXTS;
GOT_EXT:
					TStr = Tstr + Copy(Mstr,1,4);
				}
			}
		}

NO_EXT:
		return_str = tstr;

		RM('SetFileName');
		tstr = return_str;
		if(  parse_int('/NHA=', mparm_str) == 0  ) {
			RM('USERIN^HISTORY_LIST /M=1/HISTORY=FILE_HISTORY');
		}
		Call DO_LOAD_FILE;
	}

	Set_Global_Int('LOAD_COUNT',Load_Count);
	return_int = load_count;

	GOTO Exit;

DO_LOAD_FILE:
	tstr = caps(FExpand(TStr));
	t_win = cur_window;
	tr = refresh;
	refresh = false;
	if(  load_check  ) {
		if(  switch_file( tstr )  ) {
#ifdef WINDOWS
			RM( 'USERIN^VERIFY /H='+ALREADYLOAD_HELPLINK +'/S=1/T=' + tstr + ' already loaded, load again?');
#else
			RM( 'USERIN^VERIFY /S=1/H=FL/T=' + tstr + ' already loaded, load again?');
#endif
			if(  return_int <= 0  ) {
				++Load_Count;
        RM("WINDOW^SELECT_WINDOW");
				window_attr = 0;
				refresh = tr;
				good_load = False;
				ret;
			}
			switch_window( t_win );
		}
	}

	if(  (Load_Count + lc2) > 0  ) {
		Error_Level = 0;
		if(  Window_Count >= 128  ) {
			Goto NO_WINDOWS;
		}
		if(  load_count > 0  ) {
			refresh = FALSE;
		} else {
			refresh = TRUE;
		}
		RM('CreateWindow');
		Redraw;
		if(  Error_Level != 0  ) {
no_windows:
			Load_Count = 20000;
			Error_Level = 0;
			Make_Message('OUT OF WINDOWS!!!');
			good_load = False;
			RET;
		}
	}

	if(  load_count == 0  ) {
		refresh = tr;
	}
	Make_Message('Loading "' + TStr + '"...');
	RM('EXTSETUP /PRE=1/EXT=' + get_extension( tstr ) + "/FTO=" + str(fto));  /*   03-15-91 01:06pm  */
	if(  (Load_Count > 0) | (parse_int('/XL=', mparm_str)) ) {
		XLoad_File(Tstr);
		xload = TRUE;
	} else {
		Load_File(TStr);
		xload = FALSE;
	}

	if(  Error_Level == 3002  ) {
		mstr = '';
		Error_Level = 0;
		RETURN_INT = 0;
		if(  global_str('@FNF_LOAD_MACRO@') != ''  ) {
			RM( global_str('@FNF_LOAD_MACRO@') + ' /F=' + tstr );
		}
		if(  return_int == 0  ) {
			if(  (error_level == 0) && (CAPS(file_name) == '?NO-FILE?') ) {
				MStr = TStr + ' NOT Found,  NEW file assumed.';
				File_Name = FExpand(TStr);
			} else {
				Error_level = 3002;
				Mstr = 'Error:'+Str(Error_Level)+' occured loading "' + TStr + '"';
			}
		}
	} else if(  error_level != 0  ) {
		erase_window;
		RM('MEERROR^ERRMSG');
		Mstr = '"' + TStr + '":  Error ' + str(error_level) + ' ' + return_str;
	} else { /* IF (Load_Count > 0) or (EOF_IN_MEM > 0) or (xload) THEN  */
		if(  Read_Only  ) {
			TStr = ' (Read-Only).';
		} else {
			TStr = '.';
		}
		Mstr = '"' + File_Name + '" loaded' + tstr;
	}
	if(  mstr != ''  ) {
		Make_Message(MStr);
	}
	File_Changed = False;
	if(  error_level == 0  ) {
		RM( 'EXTSETUP /POST=1/PRE=' + parse_str('/PRE=',mparm_str) + '/FTO=' + str(fto));
	}
  if(( window_attr & 0x0001 ) || (window_handle == 0) )
  {
    RM("Select_Window /MAX=" + str(Global_Int ("@MAXIMIZE_WINDOWS")));
    window_attr = window_attr & 0x7E;
  }
	++Load_Count;
	good_load = True;
	RET;



REDRAW_OFF:
  #IFDEF windows
    // Here we are going to turn off the windows redraw flag
   if( !redraw_state )
   {
    if ( (SendMessage (client_handle, WM_MDIGETACTIVE, 0, 0) >> 16) == 0)
    {
      redraw_state = TRUE;
      SendMessage( client_handle, WM_SETREDRAW, 0, 0 );
    }
   }
  #ENDIF
  ret;

REDRAW_ON:
  #IFDEF windows
    // Here we are going to turn on the windows redraw flag
   if( redraw_state )
   {
    redraw_state = FALSE;
    SendMessage( client_handle, WM_SETREDRAW, 1, 0 );
    RedrawWindow( client_handle, 0, 0, RDW_ALLCHILDREN | RDW_INVALIDATE );
   }
  #ENDIF
  ret;

PARSE_EXT:
	jx = XPos( ';', Tstr2, jy + 1 );
	if(  jx == 0  ) {
		jx = Svl(Tstr2) + 1;
	}
	Mstr = Copy( Tstr2, jy + 1, jx - jy - 1 );
	if(  (Str_Char(Mstr,1) != '.')  ) {
		Mstr = '.' + Mstr;
	}
	jy = jx;
	RET;

EXIT:
test2:
	file_search_rec = t_search_rec;
	File_Search_Attr = T_File_Search_Attr;
	RM('SetWindowNames');
  call REDRAW_ON;

}  // ldFiles

Macro QUICKLOAD (int historyFile = parse_int ("/F=", mparm_str))
{
  int historycount = Parse_Int ("/#=", Global_Str ("FILE_HISTORY"));
  int index = (historycount - historyfile) + 1;
  str fn;

  if((historycount > 0) && (index > 0) && (index <= historycount))
  {
    fn = Global_Str ("FILE_HISTORY" + Str (index));
    if( switch_file( fn ) )
    {
      rm("Select_Window");
      return();
    }

    return_str = fn;
    rm("ldFiles /LC=0/CW=2");
  }
}

macro AUTOSAVE TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: AUTOSAVE

Description:  Checks all windows and saves all modified files.  Can be invoked
							by the autosave timer system, or as part of the exit macro.

Parameters:
							/EX=1  tells autosave to clean up autosave files and save all
										 changed files if the global autosave_ext was defined.

							/EX=2  tells autosave to clean up autosave files and exit
										 if the global autosave_ext was defined.

	if the global autosave_ext is not defined the parameter /EX has no effect

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int Save_Count,JX,OLD_WIN, t_error, b1, old_refresh;
/* Start of .ASV modification block 1
	Def_Str(f_name, flg_name, ASV_name, save_ext);
	def_int (t_Ex, tmp_backup);

	t_Ex := Parse_Int('/EX=', mparm_str);
End of .ASV modification block 1  */

	old_refresh = refresh;
	Refresh = False;
	OLD_WIN = CUR_WINDOW;
	Save_Count = 0;
	t_error = 0;
	b1 = 0;
	JX = 1;
	while(  jx <= Window_Count  ) {
		Switch_Window(jx);
		++jx;

/* Start of .ASV modification block 2
		save_ext := '.' + global_str( 'autosave_ext' );
		flg_name   := Truncate_Extension(Truncate_Path(File_Name)) + save_ext;
		IF (t_Ex) THEN
			IF (Global_Int(flg_name)) THEN
				if (backups = 2) Then
					ASV_Name := Backup_Path +
											Truncate_Extension(Truncate_Path(File_Name)) +
											save_ext;
				else
					ASV_Name := Truncate_Extension(File_name) +
											save_ext;
				end;
				Put_Box( 20, 5, 60, 8, 0, m_s_color, 'REMOVING AUTOSAVE FILES...', TRUE );
				Draw_Char( 32, 22, 6, m_t_color, 35 );
				Write( truncate_path( ASV_name ), 26, 6, 0, m_t_color );
				Set_File_Attr(ASV_name,0);
				del_file(ASV_name);           /* delete autosave file if exiting */
				File_changed := TRUE;
			END;
			save_ext := '.';
		END;
		IF ((t_Ex = 2) and (global_str( 'autosave_ext' ) <> '')) THEN
			goto ASV_quit;
		END;
End of .ASV modification block 2  */

    if(  (File_Changed != 0) && (((window_attr & $80) == 0) /* ||
      (caps(file_name) != "?NO-FILE?") */)  ) {
        #IFNDEF windows
			if(  NOT(b1)  ) {
				b1 = TRUE;
				Put_Box( 20, 5, 60, 8, 0, m_s_color, 'SAVING FILES...', TRUE );
			}
			Draw_Char( 32, 22, 6, m_t_color, 35 );
			Write( truncate_path( file_name ), 26, 6, 0, m_t_color );
        #ENDIF
			if(  CAPS(File_Name) == '?NO-FILE?'  ) {
				Refresh = True;
				Redraw;
				RM( 'MEUTIL1^SAVEFILE' );
				if(  (Return_Int == 0)  ) {
					T_Error = 1;
				}
				Refresh = False;
			} else {
				rm("MEUTIL1^SAVEFILE /NP=1/NM=1/NCO=1");
/* Start of .ASV modification block 3
				IF (save_ext <> '.') THEN
					f_name := File_Name;
					if (backups = 2) Then
						File_Name := Backup_Path +
												Truncate_Extension(Truncate_Path(File_Name)) +
												save_ext;
					else
						File_Name := Truncate_Extension(File_name) +
												save_ext;
					end;
					Set_Global_Int(flg_name,1);
					if (CAPS(TRUNCATE_PATH(File_Name)) <> '!BUF.0') and
						(CAPS(TRUNCATe_PATH(File_Name)) <> 'MEFIND.TMP') then
						tmp_backup := backups;
						Backups := 0;
						SAVE_FILE;
						Backups := tmp_backup;
					end;
					File_Name := f_name;
					File_Changed := 0;
				ELSE
					SAVE_FILE;
				END;
End of .ASV modification block 3 */
			}
			if(  Error_Level != 0  ) {
				RM( 'MEERROR' );
				t_error = true;
			}
			++Save_Count;
		}
/*
ASV_quit:
 */
	}
  #IFNDEF windows
	if(  b1  ) {
		kill_box;
	}
  #ENDIF
	Switch_Window(OLD_WIN);
	Refresh = old_refresh;
	return_int = t_error;
}

macro AUTOSAVETIMER TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: AUTOSAVETIMER

Description:  Manages autosave timer events.  The timer can be based on the
amount of time that has passed since the last time the user pressed a key (or moved
the mouse), or on an absolute interval.  This macro is only intended to be run
by assigning it as a timer event macro.  EXAMPLE:
Timer_Handle := SET_TIMER_EVENT('AUTOSAVETIMER /NOW=0/T=10/S=0', 18, EDIT);

Parameters:
						/NOW= If <> 0, will immediately autosave.  This is for the absolute
						interval method.  IF 0, then the keyboard inactivity method is used.
						/S= If <> 0, then the complete status of the editor is saved as
						well as the files.


							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	if(  (Global_Int('Menu_Level'))  ) {
/* We don't want to autosave in the middle of a menu or prompt */
		Goto EXIT;
	}
	if(  parse_int('/NOW=', mparm_str)  ) {
		goto GO_AUTOSAVE;
	}
	if(  global_int('!LAST_AUTOSAVE_TIME') < last_keypress_time  ) {
		if(  (last_event_time - last_keypress_time) >= parse_int('/T=', mparm_str)  ) {
GO_AUTOSAVE:
			set_global_int( '!LAST_AUTOSAVE_TIME', last_event_time );
			SET_GLOBAL_INT('@TEMP_RETURN_INT', return_int );
			SET_GLOBAL_STR('@TEMP_RETURN_STR', return_str );
			RM('AUTOSAVE');
			if(  (Parse_Int('/S=',MParm_Str))  ) {
        RM(']EXIT^STATUS');
			}
			return_int = Global_Int('@TEMP_RETURN_INT');
			return_str = Global_Str('@TEMP_RETURN_STR');
			set_global_int('@TEMP_RETURN_INT',0);
			set_global_str('@TEMP_RETURN_STR','');
			update_status_line;
		}
	}
EXIT:
}

macro SETAUTOSAVE TRANS {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: SETAUTOSAVE

Description:  Creates 1 or 2 autosave events from parameters passed by the
installation and setup screen.

Parameters:
						/H1= Existing timer event handle.  This macro will release this
								 handle before assigning a new one to replace it.  The new
								 handles are saved into GLOBAL_STR( '!AUTOSAVEPARMS') using
								 identical parameter syntax.  You must pass these handles to
								 this macro, or they will remain in force.
						/H2= Same as above.

						/T1= Timeout factor for event 1 in seconds.
						/T2= Timeout factor for event 2.

						/M1= Timeout method for event 1.
								0=Keyboard inactivity method.
								1=Absolute interval method.
						/M2= Timeout method for event 2.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int  h1,h2,T1,T2,M1,M2,S1,S2;
	str  astr[80] ;

	astr = Global_str('!AUTOSAVEPARMS');
	h1 = parse_int('/H1=', astr );
	h2 = parse_int('/H2=', astr );
	m1 = 0;
	m2 = 0;
	S1 = parse_int('/S1=', mparm_str );
	S2 = parse_int('/S2=', mparm_str );
	if(  h1 != 0  ) {
		kill_timer_event( h1 );
		h1 = 0;
	}
	if(  h2 != 0  ) {
		kill_timer_event( h2 );
		h2 = 0;
	}
	T1 = parse_int('/T1=', mparm_str ) * 18;
	T2 = parse_int('/T2=', mparm_str ) * 18;
	if(  T1 > 0  ) {
		M1 = parse_int('/M1=', mparm_str );
		if(  M1 == 0  ) {
			h1 = set_timer_event('AUTOSAVETIMER /T=' + str( T1 ) + '/S=' + Str(S1), 28, EDIT);
		} else if(  M1 == 1  ) {
			h1 = set_timer_event('AUTOSAVETIMER /NOW=1/S=' + Str(S1), T1, edit);
		}
	}
	if(  T2 > 0  ) {
		M2 = parse_int('/M2=', mparm_str );
		if(  M2 == 0  ) {
			h2 = set_timer_event('AUTOSAVETIMER /T=' + str( T2 ) + '/S=' + Str(S2), 28, EDIT);
		} else if(  M2 == 1  ) {
			h2 = set_timer_event('AUTOSAVETIMER /NOW=1/S=' + Str(S2), T2, edit);
		}
	}

	Set_Global_STR( '!AUTOSAVEPARMS', '/H1=' + str(H1) + '/H2=' + str(H2) +
									'/M1=' + str(M1) + '/M2=' + str(M2) +
									'/T1=' + str(T1 / 18) + '/T2=' + str(T2 / 18) +
									'/S1=' + str(S1) + '/S2=' + str(S2)
									);

}

macro SetWindowNames {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: SetWindowNames

Description:  Goes through the entire set of windows currently loaded
		and assigns alphabetic WINDOW_NAMEs to them, skipping any with the
		INVISIBLE (Bit 7) attribute.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int  tw, jx, jy,jz, t_refresh,
		error_win_id = Global_Int('~MEERR_ID') ;

	t_refresh = refresh;
	refresh = FALSE;
	tw = cur_window;

	jx = 0;
	jy = 0;
	jz = 0;
	while(  jx < window_count  ) {
		++jx;
		switch_window(jx);
		if(  (window_attr & $80) == 0  ) {
			if( window_id == error_win_id )
			{
				window_name = 'OUTPUT';
			}
			else
			{
        ++jy;
        if(  jy > 26  ) {
          jy = 1;
         ++jz;
        }
        if(  jz > 0  ) {
          window_name = CHAR( jz + 48) + CHAR( jy + 64 );
        } else {
          window_name = CHAR( jy + 64 );
        }
			}
		}
	}

	switch_window( tw );
	refresh = t_refresh;

}

macro KEYMAC_LOAD {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: KEYMAC_LOAD

Description:  Loads, saves, erases keystroke macros from KEYMAC.DB

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	int Active_Window,
					Keymac_Window,
					Keymac_Count,
					T_Reg_Exp_Stat = Reg_Exp_Stat,
					T_Insert_Mode = Insert_Mode,
					T_Mode,
					T_Refresh,
					Load_Mode,
					K_int,
					Keep_Window;
  str k_str;

	T_Refresh = Refresh;
	Refresh = False;
	Load_Mode = Parse_Int('/LM=',MParm_Str);
	Keep_Window = Parse_Int('/KW=',MParm_Str);
	Keymac_Count = 0;
	Reg_Exp_Stat = True;
	Active_Window = Window_Id;
	RM('Setconfig /DB=MECONFIG/T=KEYMAC.DB');

  if (Return_Int == 0) {
/*
		Goto NOT_FOUND;
  } else if (Search_Fwd('%@*@*@*@*START@*@*@*@*$',0) == False) {
NOT_FOUND:
*/
    if (Parse_Int('/NE=',MParm_Str)) {
			Error_Level = 0;
			Goto EXIT;
		}
    if (Load_Mode == 1) {
//      error_level = 3003;
      RM('MESSAGEBOX /B=1/M=Can''t find ' + Return_Str + ' to save this keystroke macro in.');
		} else if(  (Load_mode == 2)  ) {
      RM('MESSAGEBOX /B=1/M=Can''t find ' + Return_Str + ' to erase keystroke macros.');
		} else {
      RM('MESSAGEBOX /B=1/M=Can''t find ' + Return_Str + ' to load keystroke macros.');
		}
		Goto EXIT;
	}

  eol;

  if (Load_Mode == 1) {
		reg_Exp_Stat = TRUE;
		RM('KEYMAC^DOUBLE_127');
    if (Search_Fwd('%|12',0)) {
			Up;
		} else {
			Eof;
			if(  (C_Col == 1)  ) {
				Up;
			}
		}
		Eol;
		Insert_Mode = True;
		Cr;
/*
NAME=Ascii tableCMD=ASCIITYPE=1KEY=/KL=Alt+A/K1=65/K2=9ICON=BT_GN_123ICON2=BT_GN_123_SHNDX=ASCIIWCMD=818
*/
    Put_Line('D=' + Parse_Str('/D=',MParm_Str) + 'KEY=' +
      parse_str("KEY=",mparm_str) + 'M=' + Parse_Str('/M=',MParm_Str) +
			'S=' + Convert_String(Global_Str('@KEYBUF')));
/*
beep;
make_message("[" + get_line + "]");
read_key;
*/
/*
		Put_Line('D=' + Parse_Str('/D=',MParm_Str) + 'K=' +
			Parse_Str('/K=',MParm_Str) + 'M=' + Parse_Str('/M=',MParm_Str) +
			'S=' + Convert_String(Global_Str('@KEYBUF')));
*/
		Set_Global_Str('@KEYBUF','');
	} else {
/* Find each keystroke macro record and set up the global and key assignment */
		Down;
		Goto_Col(1);
    while ((Not(At_Eof)) & (Cur_Char != '|12')) {
      if (Get_Line != '') {
				T_Mode = Parse_Int('M=',Get_Line);
        if ((T_Mode != 0) & (T_Mode != 1) & (T_Mode != 3) &
            (T_Mode != 255)) {
/* Make sure the ME mode is a legal value */
					T_Mode = 0;
				}

        K_str = Parse_str('KEY=',Get_Line);
        if (svl(k_str)) {
          k_int = (parse_int("/K2=",k_str) << 8) | (parse_int("/K1=",k_str));
          if (k_int) {
/* Only load those macros who have a key assigned to them */
            ++keymac_count;
            if (Load_Mode == 2) {
/* This will unload the macros from memory */
              set_global_str('@KM!#' + str(keymac_count),'');
              Unassign_key(k_int,t_mode);
            } else {
              set_global_str('@KM!#' + str(keymac_count),Reconvert_String(Parse_str('S=',Get_Line)));
/*
beep;
make_message(hex_str(k_int) + " " + make_key_name( make_word( parse_int("/K1=",k_str), parse_int("/K2=",k_str))));
read_key;
*/
/*
  if (switch_win_id(global_int("XXX"))) {
  beep;
  eol;
  cr;
  put_line(global_str('@KM!#' + str(keymac_count)));
  switch_win_id(active_window);
  }
*/
              global_to_key(K_Int, '@KM!#' + str(keymac_count),T_Mode);
            }
          }
        }
			}
			Down;
		}
    if (Load_Mode == 2) {
			set_global_int('@KEYMACRO_COUNT@',0);
/* This will reload the keymap in case a keystroke macro had previously
overwritten a keymap assignment */
			ERROR_LEVEL = 0;
			RM(User_Id+'INIT^'+User_Id+'KEYMAP');
      if (ERROR_LEVEL != 0) {
				RM('INIT^KEYMAP');
			}
		} else {
			set_global_int('@KEYMACRO_COUNT@', keymac_count );
		}
	}

EXIT:
/*
Refresh := True;
Window_Attr := 0;
Eof;
Redraw;
Read_Key;
 */
/*
	IF (Window_Created) THEN
		IF (Keep_Window) THEN
			Window_Attr := $81;
		ELSE
			Delete_Window;
		END;
	END;
 */
	Switch_Win_id(Active_Window);
	Reg_Exp_Stat = T_Reg_Exp_Stat;
	Insert_Mode = T_Insert_Mode;
	Refresh = T_Refresh;
}

macro PARMS1 DUMP {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: PARMS1

Description:  Called by Multi-Edit internally to process most command line
		parameters.  Gets called before PARMLOAD, after INIT and before STARTUP.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int Parm_Number;
	int jx, default_back, kspeed ;
	str TStr;
	char Tchar;


	set_global_int("@NO_MOUSE_SET", TRUE );

  temp_path = TranslateCmdLine(Global_Str('!TEMP_PATH'), '');
  if (length(temp_path) == 0) {
    GetTempFileName(GetTempDrive(jx), "", 0, tstr);
    temp_path = get_path(tstr);
  }

  if (((Length(Temp_Path) > 0) &
      (Copy(Temp_Path,Length(Temp_Path),1) != '\'))) {
    Temp_Path = Temp_Path + '\';
  }

  backup_path = TranslateCmdLine( Global_Str('!BACKUP_PATH'), '' );
  if(  ((Length(Backup_Path) > 0) &
      (Copy(Backup_Path,Length(Backup_Path),1) != '\'))  ) {
    Backup_Path = Backup_Path + '\';
  }

#IFNDEF windows
    kspeed = (Global_Int('NO_KEYSPEED') == 0);


		 /* Do we need to set default colors? */
	if(  global_int('DEFAULT_COLORS')  ) {
		intr($11);
		if(  (r_ax & $0030) == $0030  ) {
			call set_mono;
		} else {
			call set_color;
		}
	}

	Parm_Number = 1;
	while(  Parm_Number <= PARAM_COUNT  ) {
		TStr = Caps(PARAM_STR(Parm_Number));
		if(  XPOS(Copy(TStr,1,1),'/-',1) != 0  ) {
			TStr = Copy(TStr,2,80);
			TChar = Copy(Tstr,1,1);
			if(  (Length(TSTR) > 1) & (XPos(Copy(Tstr,2,1),'0123456789',1) != 0)  ) {
				if(  VAL(jx, Copy(Tstr,2,8)) == 0  ) {
				}
			} else {
				if(  (Length(tstr) == 2) & (XPOS(Copy(Tstr,2,1), 'YN', 1) != 0)  ) {
					if(  (Copy(Tstr,2,1) == 'Y')  ) {
						jx = true;
					} else {
						jx = false;
					}

					if(  TChar == 'K'  ) {
						Set_Global_Int('NO_KEYSPEED', jx == 0 );
						kspeed = jx;
					}
					if(  TChar == 'N'  ) {
						Name_Line = jx;
					}
					if(  TChar == 'L'  ) {
						Logo_Screen = jx;
					}
				} else {
					if(  (Length(TStr) == 1)  ) {
/* This is a list of command line options that occurs if a /? is used on the
command line. */
						if(  (Tchar == '?')  ) {
							Rest_Dos_Screen;
							Write_Sod('The following command line options are available:|13|10');
							Write_Sod('  /Ln = Go to line n in first file loaded.|13|10');
							Write_Sod('  /MN = Mouse disable, /MY = Mouse enable|13|10');
              Write_Sod('  /MF = Force fully compatible mouse mode|13|10');
							Write_Sod('  /KN = Don''t change keyspeed, /KY = Change keyspeed|13|10');
							Write_Sod('  /NR = No Restore;  Does not change the setup|13|10');
							Write_Sod('  /B  = Use black and white colors, /C = Use default colors|13|10');
							Write_Sod('  /Xn = Sets screen width to n.|13|10');
							Write_Sod('  /Yn = Sets screen height to n.|13|10');
							Write_Sod('  /O  = OS/2 switch on.|13|10');
							Write_Sod('  /EN = Don''t try to use enhanced keyboard|13|10');
							Write_Sod('  /D  = Use direct video.  Bypass Desq-View/Windows|13|10');
							Write_Sod('  /V  = Don''t wait for retrace on CGA video I/O.|13|10');
              Write_Sod('  /Rmacro_name = Run the macro: macro_name.|13|10');
							Write_Sod('  /EMSOFF = Do NOT use expanded/extended memory.|13|10');
							Write_Sod('  /BIGVM = Use large virtual memory mode.|13|10');
              Write_Sod('  /@filename = Load file list.|13|10');
// new options (and old) - loading of files [with filetype override]
							Write_Sod('  filename [filename [...]] = Load the specified file.|13|10');
							Write_Sod('      Multiple files may be loaded, and optionally, use|13|10');
							Write_Sod('      the following File Type Override specifiers:|13|10');
							Write_Sod('  /!filename = Load file in UNIX format.|13|10');
							Write_Sod('  /&filename = Load file in Binary format.|13|10');
							Write_Sod('  /*filename = Load file in MSDOS text format.|13|10');
              Write_Sod('  /CDpath = change to directory.|13|10');
							quit(0);
						}
						if(  TChar == 'B'  ) {
							/* /B force monochrome defaults */
							Set_Global_Int('COM_DEFAULT_COLORS',1);
							call set_mono;
						}
						if(  TChar == 'C'  ) {
							Set_Global_Int('COM_DEFAULT_COLORS',1);
							call set_color;
						}
					}
				}
			}
		Next_While:
		}
		Parm_Number = Parm_Number + 1;
	}

	if(  kspeed  ) {
		R_BX = (Global_Int('KEYDELAY') << 8) | GLOBAL_INT('KEYSPEED');
		R_AX = $0305;
		INTR( $16 );
		Set_Global_Int('NO_KEYSPEED', 0 );
	}
	goto exit;

color_defaults:
	stat1_color = lightgray | default_back;
	stat2_color = white | default_back;
	message_color = lightgray | default_back;
	fnum_color = lightgray | default_back;
	fkey_color = 112;
	w_t_color = LightGray | default_back;
	w_s_color = yellow | default_back;
	w_b_color = lightgray | default_back;
	w_h_color = 112;
	w_eof_color = white | default_back;
	w_l_color = yellow | default_back;
	w_lb_color = 113;
	w_c_color = white | default_back;
	m_t_color = LightGray | default_back;
	m_s_color = white | default_back;
	m_b_color = white | default_back;
	m_k_color = cyan | default_back;
	m_h_color = 112;
	d_t_color = m_t_color;
	d_s_color = m_s_color;
	d_b_color = m_b_color;
	d_h_color = m_h_color;
	h_t_color = lightgray | default_back;
	h_s_color = white | default_back;
	h_r_color = yellow | default_back;
	h_b_color = lightgray | default_back;
	h_h_color = 112;
	h_f_color = 112;
	h_t1_color = 33;
	h_t2_color = 41;
	h_t3_color = 240;
	working_color = 240;
	background_color = default_back | white;
	Error_color = white | default_back;
	Shadow_Color = LightGray | default_back;
	Shadow_Char = Char(177);
	button_color = 7;
	button_key_color = 15;
	button_shadow_color = default_back | lightgray;
	Set_Global_Str('&SYNTAX_COLORS','/RWC=271/SYC=271/ECC=880/SCC=265/C1C=880/C2C=880/NCC=0');
	ret;

set_color:
	Error_Color = 79;
	Shadow_Color = 8;
	Shadow_Char = '|0';
	W_T_Color = 23;
	W_H_Color = 96;
	W_B_Color = 27;
	W_C_Color = 31;
	w_l_color = 30;
	w_lb_color = 110;
	W_EOF_Color = 20;
	W_S_Color = 30;
	M_T_Color = 112;
	M_S_Color = 113;
	M_B_Color = 112;
	M_H_Color = 95;
	m_k_color = 120;
	CB_H_Color = 63;
	CB_T_Color = 48;
	CB_S_Color = 49;
	Button_Color = 27;
	Button_Key_Color = 30;
	Button_Shadow_Color = 120;
	D_T_Color = 112;
	D_S_Color = 113;
	D_B_Color = 112;
	D_H_Color = 80;
	H_T_Color = 23;
	H_T1_Color = 27;
	H_T2_Color = 28;
	H_T3_Color = 127;
	H_S_Color = 31;
	H_B_Color = 23;
	H_H_Color = 112;
	H_R_Color = 30;
	H_F_Color = 112;
	FKey_Color = 112;
	FNum_Color = 49;
	Stat1_Color = 112;
	Stat2_Color = 113;
	Message_Color = 112;
	Working_Color = 192;
	Background_Color = 23;
	Set_Global_Str('&SYNTAX_COLORS','/RWC=283/SYC=267/ECC=316/SCC=298/C1C=268/C2C=268/NCC=266');
	ret;

set_mono:
	CB_H_Color = 112;
	CB_T_Color = 7;
	CB_S_Color = 15;
	default_back = 0;
	Call Color_Defaults;
	Set_Global_Str('&SYNTAX_COLORS','/RWC=271/SYC=271/ECC=880/SCC=265/C1C=880/C2C=880');
	ret;

#ENDIF

exit:
}


/****************** Multi-Edit INTEGER Macro Function ***********************

 NAME:         ld_override_file

 DESCRIPTION:  loads a filename from command-line using
	 using a filetype override specifier

	command line syntax:   me /<specifier>filename ...

	multiple type-overridden filenames are valid.

				! - unix format override
				& - binary format override
				* - msdos text format override

 PARAMETERS:  str tstr	filename with type specifier
	      int lc	current value of Load_Count in PARMLOAD
	      		macro or 0 to just load the file.

 RETURNS:     return_int as returned by LDFILES macro (new Load_Count)

*****************************12-02-93 01:35am*******************************/

int ld_override_file(str fstr, int lc)
{
  str tstr = fstr; // str_char requires local string variable!!!

  int this_fto = 0;
  int use_def_ext = 0;


  switch ( str_char( tstr, 1) )
  {
    case '!':	// load as unix file
      this_fto = 2;
      tstr = str_del(tstr, 1, 1);
      break;
    case '&': // load as binary file
      this_fto = 3;
      tstr = str_del(tstr, 1, 1);
      break;
    case '*': // load as msdos text file
      this_fto = 1;
      tstr = str_del(tstr, 1, 1);
      break;
    default:
      use_def_ext = 1;
      break;
  }
  return_str = tstr;
  RM('LDFILES /DE='+str(use_def_ext)+
  	'/FTO='+str(this_fto)+
  	'/LC=' + str(lc));
  return(return_int);		// return new Load_Count
}

void ConfigLocked() trans
{
  #IFDEF windows
  int dlg;
  DlgCreate( dlg );
  DlgAddCtrl( dlg, DLG_ICON,"IC_STOP", 1,1, 0,0, 1100, 0, "" );
  DlgAddCtrl( dlg, DLG_Static,"Your configuration files are locked!", 8,2, 0,0, 1000, 0, "" );
  DlgAddCtrl( dlg, DLG_Static,"Before unlocking them, insure that there are NOT multiple",
                      2,DLG_PosOffset + 2, 0,0, 1001, 0, "" );
  DlgAddCtrl( dlg, DLG_Static,"copies of Multi-Edit running with your user id.",
                      DLG_PosOffset,DLG_PosOffset + 1, 0,0, 1002, 0, "" );

  DlgAddCtrl( dlg, DLG_ICON,"IC_QUESTION", 1,DLG_POSOFFSET + 2, 0,0, 1101, 0, "" );
  DlgAddCtrl( dlg, DLG_Static,"Do you want to unlock your configuration files?",
                      8,DLG_PosOffset + 1, 0,0, 1003, 0, "" );
  DlgAddCtrl( dlg, DLG_PushButton,"&Yes", 8,DLG_POSOFFSET + 2, 8,0, 100, DLGF_DefButton, "/R=1" );
  DlgAddCtrl( dlg, DLG_PushButton,"&No", DLG_PosOffset + 10,DLG_POSOFFSET, 8,0, 101, 0, "/R=3" );
  DlgAddCtrl( dlg, DLG_PushButton,"Cancel", DLG_PosOffset + 10,DLG_POSOFFSET, 8,0, 102, 0, "/R=0" );
  DlgAddCtrl( dlg, DLG_PushButton,"&Help", DLG_PosOffset + 12,DLG_POSOFFSET, 8,0, 103, 0, "/R=2" );

  return_int = DlgExecute( dlg, 100, "Warning!", FILELOCK_HELPLINK, "", DLG_ScreenCenter );
  DlgKill( dlg );
  #ELSE
  RM('MEERROR^MessageBox /NW=1/T=Warning/M=Your configuration files are locked.  Before unlocking them, insure that there are NOT multiple copies of Multi-Edit running with your user id.');
  RM('USERIN^XMENU /B=1/X=25/Y=8/T=1/L=Action:/M=Unlock configuration files()Ignore and leave files locked()');
  kill_box;
  #ENDIF
  if(  return_int == 1  ) {
    int tr = refresh;
    str tstr;

    refresh = false;
    make_message('Unlocking configuration files...');
    working;
    delete_window;
    if(  user_id == ''  ) {
      if(  (Global_Str('@DB_EXTENSION') == '')  ) {
        tstr = me_path + '*.DB';
        call unlock_files;
      } else {
        tstr = me_path + '*.' + Global_Str('@DB_EXTENSION');
        call unlock_files;
      }
      tstr = me_path + '*.ME';
      call unlock_files;
    } else {
//          tstr = me_path + user_id + '.USR\*.*';
      return_str = '<USER_PATH>*.*';
      rm('XlateCmdLine');
      tstr = return_str;
      call unlock_files;
    }
    tstr = user_id + 'MEERR.TMP';
    call unlock_files;
//        tstr = me_path + user_id + '*.TMP';

    return_str = '<USER_PATH>*.TMP';
    rm('XlateCmdLine');
    tstr = return_str;
    call unlock_files;
    goto config_unlocked;

    unlock_files:
      int jx = FIRST_FILE(TSTR);
      while(  jx == 0  ) {
        if(last_file_attr & 1)
        {
          if( switch_file( caps(fexpand( get_path( tstr ) + last_file_name ))))
          {
            if(file_changed)
              save_file;
            delete_window;
          }
          Set_File_Attr( get_path( tstr ) + last_file_name,
                          last_file_attr & $FE );
        }
        jx = next_file;
      }
      ret;

config_unlocked:
    make_message('Configuration files unlocked.');
    refresh = tr;
  }
  return();
}


void ProcessCmdLine( int m = parse_int("/M=", mparm_str) )
{
}


macro PARMLOAD  {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: PARMLOAD

Description:  This macro is called by Multi-Edit directly after STARTUP.  It
							takes care of loading in files and executing macros from the
							command line.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
  int parmload_mode = parse_int("/M=", mparm_str);

#ifdef DEMO
  if( !parmload_mode)
  {
  // special stuff for the demo to support Evolve
    if (global_int('!EVgDialectId')) {
  /*
      make_message("!EVgDialectId=" + str(global_int('!EVgDialectId')));
      read_key;
  */
      RM("EVINIT");
    }
  }
#endif // DEMO
	int Load_Count,Parm_Number;
  int cur_id = window_id;
	int jx, tw, tr, mouse_initialized = FALSE ;
	int restore_enable = 1, no_restore = 0, Goto_L_Num = 0;
  str TStr, TStr2, Goto_F_Name[80], session_name[128] = "";
  str wdir[512] = "";


	set_global_int('MENU_LEVEL', global_int('MENU_LEVEL') + 1 );

  if( !parmload_mode )
  {
#IFNDEF Windows
    make_message('Welcome to Multi-Edit V' + Version + '.  Press ' + global_str('!HM_KEY1') + ' for help.');
#ELSE
    make_message('Welcome to Multi-Edit V' + Version + '.  Press <F1> for help.');
#ENDIF
    refresh = false;
    working;
    RM('.STARTUP^STARTUP');
  }
	refresh = false;
	working;

  if( !parmload_mode )
  {
  /* Check and see if MECONFIG is read_only.  If so then prompt the
  user, to see if he/she wants them unlocked */
    tw = window_id;
    if(  user_id == ''  ) {
      tstr = me_path + 'MECONFIG';
    } else {
      // 7.00.0: tstr = me_path + user_id + '.USR\MECONFIG';
      // 7.00.a: consult the USER_PATH for user directory
      return_str = '<USER_PATH>MECONFIG';
      rm('XlateCmdLine');
      tstr = return_str;
    }

  /* This provides support for a default DB file extension to be configured.  It
  is overridden if the calling macro specifies an extension */
    if(  (Global_Str('@DB_EXTENSION') == '')  ) {
      Tstr = Tstr + '.DB';
    } else {
      Tstr = Tstr + '.' + Global_Str('@DB_EXTENSION');
    }
    if(  switch_file( tstr )  ) {
      if(  read_only  ) {
        call init_mouse;
        ConfigLocked();
      }
    }
  }
	switch_win_id( tw );

	error_level = 0;

	Error_Level = 0;

  load_count = parmload_mode;

	Parm_Number = 1;
	refresh = false;
	while(  Parm_Number <= PARAM_COUNT  ) {
    TStr = PARAM_STR(Parm_Number);
		TStr = Caps(Remove_Space(TStr));
		if(  Xpos(Copy(Tstr,1,1),'/-',1)  ) {
			Tstr = Copy(Tstr,2,80);

      if ( TStr == "CD" ) {                                           // ldh
        ++Parm_Number;                                                // ldh
        if ( Param_Str( Parm_Number ) != ""  ) {                      // ldh
          TStr = Caps( Remove_Space( Param_Str( Parm_Number ) ) );    // ldh
          if ( Svl( TStr ) > 3 ) {                                    // ldh
            if ( Copy( TStr, Svl( TStr ), 1 ) == "\\" ) {             // ldh
              TStr = Copy( TStr, 1, Svl( TStr ) - 1 );                // ldh
            }                                                         // ldh
          }                                                           // ldh
          Change_Dir( TStr );                                         // ldh
        }                                                             // ldh
      }                                                               // ldh
      else if ( Copy (TStr, 1, 3) == "WK=" )
      {
        wdir = Copy (TStr, 4, 128);
      }
      else if ( TStr == "SM" )
			{
				restore_enable = False;
				no_restore = True;
				RM("SESSMGR /NOSWITCH=1");
			}
      else if ( copy(tstr,1,2) == "SR" )
      {
        int tid = window_id;
        int tr = refresh;
        refresh = false;
        if(LocateDbPage("MECONFIG", "SESSMGR.CFG", false))
        {
          down;
          session_name = get_line;
          restore_enable = TRUE;
        }
        switch_win_id(tid);
        refresh = tr;
      }
      else if ((Copy( TStr, 1, 2) == "SN" ) &&
          (Global_Int('@RESTORE') == 3)) // only if encoded status files are active
			{
						// switch to named session
				restore_enable = True;
				session_name = copy(tstr,3,128);
			}
      else if ( Copy( TStr, 1, 1) == "@" )                            // ldh
			{
						// Load files from a file list
				refresh = false;
				restore_enable = False;
				Set_Global_Int('LOAD_COUNT',Load_Count);
				int tid = window_id;
				create_window;
				window_attr = 0x81;
				tstr = copy(tstr,2,128);
				load_file( tstr );
				int tag_win = window_id;
				make_message("");
				if(error_level)
				{
					call init_mouse;
          rm("messagebox /B=2/T=Error/M=List file " + tstr + " not found.");
				}
				else
				{
					switch_win_id( tid );
					RM('LDFILES /TAG=' + str(tag_win) + '/DE=1/CW=2/LC=' + str(load_count));
					Load_Count = return_int;
					if(  (Load_Count == 1)  ) {
	/* Save the first file loaded so that if the user specifies a line number to
	go to, we can do it. */
						Goto_F_Name = File_Name;
					}
					tid = window_id;
				}
				refresh = false;
        if( switch_win_id( tag_win ))
          delete_window;
				switch_win_id(tid);
			}
			else if(  TStr == 'NR'  ) {
        if( !parmload_mode )
        {
          restore_enable = False;
          no_restore = TRUE;
        }
			} else if(  (TStr == 'NS') ) {		// no restore(windows), no save status
        if( !parmload_mode )
        {
          restore_enable = False;
          no_restore = TRUE;
          set_global_int('@RESTORE',0);
        }
			} else if(  (TStr == 'R')  ) {
				call init_mouse;
				++Parm_Number;
				restore_enable = False;
				Refresh = True;
				if(  PARAM_Str(Parm_Number) != ''  ) {
					RM(PARAM_Str(Parm_Number));
				}
      } else if (copy(tstr,1,1) == "R") {
        call init_mouse;
				restore_enable = False;
        refresh = true;
        tstr = copy(tstr,2,40);
        if (tstr != "") {
          RM(tstr);
        }
			} else if(  (Str_Char(TStr,1) == 'L')  ) {
/* This is the go to line number parameter */
				if(  (Val(Goto_L_Num,Copy(TStr,2,10)) == 0)  ) {
					if(  ((Goto_L_Num < 0) | (Goto_L_Num > 2000000000))  ) {
						Goto_L_Num = 0;
					}
				}
			}
		// ----------------------------------------------------------------------
		// mods to handle loading unix,msdos  and binary file type overrides

		// to load a file in unix mode (to override or it is really is):
		// 	C:\> me /!unix.fil

		// to load a file in binary mode
		// 	C:\> me /&binary.fil

		// to load a file in msdos text mode
		// 	C:\> me /*msdostxt.fil

		// or load multiple files
		// 	C:\> me normal.fil /!unix.fil /&binary.fil /*msdostxt.fil

		// 			Yuuuck!

		  else if ( Xpos(Copy(Tstr,1,1),'!&*',1) )
		  {
		    refresh = false;
		    restore_enable = False;
		    Set_Global_Int('LOAD_COUNT',Load_Count);

		    // Load file as unix, msdos, or binary format file
		    Load_Count = ld_override_file(tstr, Load_Count);
		    if(  (Load_Count == 1)  ) {
		      // Save the first file loaded so that if the user
		      // specifies a line number to go to, we can do it.
		      Goto_F_Name = File_Name;
		    }
		    refresh = false;
		  }
		}
		else {
			if(  (Load_Count < 20000) & (Pos(copy(TStr,1,1),'/-') == 0) & (copy(TStr,1,1) != ';')  ) {
				if(  load_count == 0  ) {
					refresh = true;
				}
				restore_enable = False;
				Set_Global_Int('LOAD_COUNT',Load_Count);
        // Check if has a path or not
        if ( xpos ("\\", tstr, 1) )
          return_str = tstr;
        else
          return_str = wdir + tstr;
        RM('LDFILES /DE=1/LC=' + str(load_count));
				Load_Count = return_int;
				if(  (Load_Count == 1)  ) {
/* Save the first file loaded so that if the user specifies a line number to
go to, we can do it. */
					Goto_F_Name = File_Name;
				}
			}
		}
		++Parm_Number;
	}

  if( !parmload_mode )
  {

  /* Load keystroke macros if present */
    RM('KEYMAC_LOAD /NE=1');
    Error_Level = 0;
  }

	if(  (Goto_L_Num)  ) {
/* Go directly to specified line number */
		if(  (Switch_File(Goto_F_Name))  ) {
			Goto_Line(Goto_L_Num);
		}
	}


  if( !parmload_mode )
  {
    if(Global_Int('@RESTORE')) {
      if (Restore_Enable) {
        RM( 'EXIT^RESTORE /SN=' + session_name);
        Error_Level = 0;
      }
      else if( !no_restore )
      {
        RM( 'EXIT^RESTORE /M=1' );
        Error_Level = 0;
      }
    }

    #IFDEF windows


    if ( MEW_ShowCmd != 0 )
    {
      ShowWindow( frame_handle,MEW_ShowCmd );
      MEW_ShowCmd = -1;
    }
    else
    {
      ShowWindow( frame_handle, SW_Show );
      MEW_ShowCmd = -1;
    }

    RedrawWindow (frame_handle, 0, 0, RDW_INVALIDATE | RDW_UPDATENOW | RDW_ALLCHILDREN);

    #ENDIF

    rm("VCSCHK^VcsStartup");    // Initialize the vcs support

  /* This is for the "post restore" startup macro which can be used to do stuff
  that you don't want restore to undo like setting globals */
    if(  (Length(Global_Str('@STARTUP_MAC_2')))  ) {
      RM(Global_Str('@STARTUP_MAC_2'));
      Error_Level = 0;
    }
  }
	goto exit;

init_mouse:

  if( !parmload_mode )
  {
    #IFNDEF windows
    if( !mouse_initialized )
        rm("INIT_MOUSE");
    set_global_int("@NO_MOUSE_SET", 0 );
    #ENDIF

    mouse_initialized = TRUE;
  }
	ret;

EXIT:
  #IFNDEF windows
	set_virtual_display;
  #ENDIF

  refresh = true;


  if( !parmload_mode )
  {
    if(  load_count > 0  ) {
      switch_window(1);
      rm("FINDWIN");
    }
  }
exit2:

  if( !parmload_mode )
  {
    if(  window_name == ''  ) {
      RM('SetWindowNames');
    }
    tstr = global_str('!AUTOSAVEPARMS');
    if(  (parse_int('/T1=', tstr ) != 0) | (parse_int('/T2=', tstr ) != 0)  ) {
      RM('SetAutoSave ' + tstr);
    }
  }
	set_global_int('MENU_LEVEL', 0);
  #IFNDEF windows
	update_virtual_display;
	reset_virtual_display;
	call init_mouse;
  #ENDIF
}