macro_file MECOMPAT;
/*************************************************************************
 MECOMPAT.S

 This file is provided for compatibility with older Multi-Edit macros.
 These macros simply translate parameters, and call their newer equivelants
 in METOOLS.

**************************************************************************/

#INCLUDE METOOLS.SH

macro XLATECMDLINE TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: XlateCmdLine

Description:  Translates RETURN_STR so that any occurences of
							<FILE>, <NAME>, <EXT>, <PATH>, <ME_PATH>, <USER_PATH>, <MAC_PATH>
							 are expanded out.

							Also, <%str> is now expanded out to whatever the environment
							variable "str" is.
							AND, <~str> is now expanded out to the value of
							Global_Str( str ).

Parameters:
							/F=str    The filename to use.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

  return_str = TranslateCmdLine( return_str, parse_str('/F=', mparm_str ));
}

/*******************************************************************************
																MULTI_EDIT MACRO

Name: MakeUserPath

Description: Takes the filename in RETURN_STR and converts it to a
	complete path and filename for the current USER_ID.  Automatically creates
	a .USR subdirectory if one doesn't exist for the current USER_ID.

Parameters: /DF=n   1 = Copy default file if specified file doesn't exist.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
macro MAKEUSERPATH {
  return_str = CreateUserPath( return_str, parse_int("/DF=", mparm_str));
}

macro TMP_FILE_NAME trans2 {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: TMP_FILE_NAME

Description:  Returns in RETURN_STR a file name with path suitable for placing
							any .TMP files like MEERR.TMP in the proper directory according
							to current configuration options.

Parameters:
							/FN=str    The filename to use (no path).

							 (C) Copyright 1993 by American Cybernetics, Inc.
*******************************************************************************/

  return_str = TempFileName( parse_str('/FN=', mparm_str));

}




macro SETCONFIG  {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: SetConfig

Description: Loads up the specified DB file (if it is not already
						loaded), and then searches for the specified page title.

Returns:    RETURN_INT = 1 IF the title was found,
												 0 If NOT found.

Parameters:   /DB=str   The db file name.
							/T=str    The page Title.
							/C=int    1 = Create page if not found.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
  return_int = LocateDbPage( parse_str('/DB=',mparm_str),
                             parse_str('/T=', mparm_str),
                             parse_int('/C=', mparm_str )
                           );
}



macro GET_DB_RECORD {
/*******************************************************************************
																MULTI_EDIT MACRO

Name: GET_DB_RECORD

Description:  Finds and returns the specified record in a .DB file.

Parameters:
						/F=     Filename
						/NDF=1  Do not delete the window after you are done
						/DPT=   Data page title
						/GLO=   Name of global string to store record
						/DBF=   Field name
						/FV=    Value of field
						/CS=1   Make search for field case sensitive
						/#=     Number of Record to return.  Overrides /DBF= and /FV=.
											Example:  If /#=3 then the 3rd record will be returned.
						/AGLO=  Name of global integer to store total amount of records
										found.  This was added primarily for the macro COMPILE so
										that it can find out it there is only 1 compiler interface
										and bypass the compiler menu.

Returns:
						Return_int = 1 if found
						Return_int = 0 if not found, but first record is stored in /GLO=
						Return_int = -1 if not found and there are no records.
						Return_Int = -2 if the DPT is not found in the DB file.
						Return_Int = -3 if the DB file is not found.

This only works for string and integer fields

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
  return_int = GetDbRecord( parse_str('/F=', mparm_str),
                            parse_str('/DPT=', mparm_str),
                            parse_str('/DBF=', mparm_str),
                            parse_str('/FV=', mparm_str),
                            parse_int('/#=', mparm_str),
                            parse_int('/CS=', mparm_str),
                            parse_str('/GLO=', mparm_str ),
                            !parse_int('/NDF=', mparm_str),
                            mparm_str
                             );
}

/*******************************************************************************
																MULTI_EDIT MACRO

Name: PathSearch

Description: Searches for a filename in a given path
						XLateCmdLine is called to parse out any metacommands BEFORE
						the search takes place.

Parameters:  /F=str     The filename

						RETURN_STR contains the path. For example:  "\;C:\ME;C:\MASM"

Returns:  RETURN_STR = complete path and filename

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
macro PATHSEARCH TRANS2 {
 return_str = searchpath( parse_str('/F=', mparm_str),
                           return_str);
 return_int = (return_str != '');
}
