macro lsc_vcs
{
  str   vcs_file;
  str   year;
  str   file_type;
  str   dest_dir;
  str   ext_type;
  str   filename;
  str   extension;
  str   network_drive;

  vcs_file = file_name;
  year = get_environment('year');
  network_drive = 'Q:\9' + year + 'SOURCE\';
  filename  = truncate_path(vcs_file);
  extension = get_extension(vcs_file);
  file_type = caps(str_char(filename,1));
  ext_type  = caps(str_char(extension,1));
  switch(extension)
    {
      case 'BAS':
      case 'BLD':
      case 'RTL':
        {
          switch (file_type)
            {
              case  'P':
                dest_dir = copy(filename,2,2);
                network_drive = network_drive + 'PAR\' + dest_dir;
                break;
              case  'S':
                dest_dir = copy(filename,2,2);
                network_drive = network_drive + 'SCO\' + dest_dir;
                break;
              case  'C':
                dest_dir = copy(filename,2,2);
                network_drive = network_drive + 'COR\' + dest_dir;
                break;
              case  'I':
                dest_dir = copy(filename,2,2);
                network_drive = network_drive + 'IND\' + dest_dir;
                break;
              case  'F':
                dest_dir = copy(filename,2,2);
                network_drive = network_drive + 'FID\' + dest_dir;
                break;
              case  'G':
                network_drive = network_drive + 'G' + year;
                break;
              case  'L':
                network_drive = network_drive + 'L' + year;
                break;
              case  'Q':
                network_drive = network_drive + 'Q' + year;
                break;
              default:
                network_drive = '';
                break;
            }
          break;
        }
      default:
        {
          switch (ext_type)
            {
              case  'P':
                network_drive = network_drive + 'PAR';
                break;
              case  'S':
                network_drive = network_drive + 'SCO';
                break;
              case  'C':
                network_drive  = network_drive + 'COR';
                break;
              case  'I':
                network_drive  = network_drive + 'IND';
                break;
              case  'F':
                network_drive  = network_drive + 'FID';
                break;
              case  'G':
                network_drive  = network_drive + 'G' + year;
                break;
              case  'L':
                network_drive  = network_drive + 'L' + year;
                break;
              case  'Q':
                network_drive  = network_drive + 'Q' + year;
                break;
              default:
                network_drive = '';
                break;
            }
        }
    }
  return_str = network_drive + '\';
}