//+++keyword+++ "@(#)%v %n, %f, %w"
// "@(#)1 DBTOOLS.SH, 14-Dec-94,15:32:48, LDH"

// Db constants
#define _db_Delimit       "\x7F"
#define _db_PageGlob      "~Section_"
#define _db_RecGlob       "~DbRec_"
#define _db_CmdGlob       "~DbCmd_"

// Db search flags
#define _sf_RegExp        0x0001
#define _sf_Contains      0x0002
#define _sf_CaseSensitive 0x0004
#define _sf_Backwards     0x0008
#define _sf_Position      0x0010
#define _sf_FirstField    0x0020
#define _sf_ErrorNoRec    0x0040

// Other db flags
#define _dbf_NoDups       0x0100
#define _dbf_ReplaceRec   0x0200
#define _dbf_InsertBefore 0x0400
#define _dbf_SaveFile     0x0800
#define _dbf_NoSwitchWin  0x1000
#define _dbf_NoDelWin     0x2000
#define _dbf_CreatePage   0x4000

// Return/Error constants
#define _ErrorDupKey     -1
#define _NoError          0
#define _ErrorNoFile      1
#define _ErrorNoDbPage    2
#define _ErrorNoDbRecord  3
#define _ErrorDupRecord   4

// CmdSet db Cmd constants
#define _db_cmd_UserWCmd  10000
#define _db_cmd_CMPage    "WCMDMAP.DB"
#define _db_cmd_Section   "@\xFE"

// CmdSet db Cmd record field names
#define _db_cmd_Name      "NAME"
#define _db_cmd_Cmd       "CMD"
#define _db_cmd_Type      "TYPE"
#define _db_cmd_Key       "KEY"
#define _db_cmd_Key2      "KEY2"
#define _db_cmd_Icon      "ICON"
#define _db_cmd_Icon2     "ICON2"
#define _db_cmd_TBText    "TBT"
#define _db_cmd_HlpCtx    "HNDX"
#define _db_cmd_OffId     "OFFID"
#define _db_cmd_Checked   "CHECKED"
#define _db_cmd_WCmdId    "WCMDID"
#define _db_cmd_WCmd      "WCMD"
#define _db_cmd_XMin      "XMIN"

// CmdSet Cmd Type constants
#define _db_ct_Macro      1
#define _db_ct_Program    2
#define _db_ct_HelpFile   3
#define _db_ct_TextFile   4
#define _db_ct_Command    5

// CmdSet Cmd Flags constants
#define _db_cf_XMin       1

// CmdSet command structure
struct TCmdMap {
  str Name[120];
  str Cmd[120];
  int Type;
  str KeyStr[50];
  str Key2Str[50];
  str Icon[40];
  str Icon2[40];
  str TBText[65];
  str HlpCtx[40];
  str OffId[128];
  str Checked[128];
  str WCmdId[128];
  int WCmd;
  int Flags;
}

// CmdSet db Menu constants
#define _db_mnu_SepWCmd   6969
#define _db_mnu_MainPage  "MAIN.MNU"
#define _db_mnu_PageExt   ".MNU"

#define _db_mnu_Menu      "MENU"
#define _db_mnu_WCmd      "WCMD"

#define _db_mnu_Text      "/TX="
#define _db_mnu_Level     "/IN="
#define _db_mnu_Sep       "/SP="

// CmdSet Menu structure
struct TMenus {
  str Menu1[128];
  str Menu2[128];
  str Menu3[128];
  str Menu4[128];
}

// CmdSet db ToolBox constants
#define _db_tbx_TBPage    "BOXLIST.DB"
#define _db_tbx_PageExt   ".TBX"

// CmdSet db ToolBox record constants
#define _db_tbx_BoxId     "BOXID"
#define _db_tbx_BoxShow   "BOXSHOWN"
#define _db_tbx_BoxStyle  "BOXSTYLE"
#define _db_tbx_UseIcon   "USEICON"

// CmdSet ToolBox Show constants
#define _db_tbs_Hidden    1
#define _db_tbs_Visable   2

// CmdSet ToolBox Position (style) constants
#define _db_tbp_Top       1
#define _db_tbp_Bottom    2
#define _db_tbp_Left      3
#define _db_tbp_Right     4
#define _db_tbp_Floating  5
#define _db_tbp_Roaving   6

// CmdSet ToolBox Icon constants
#define _db_tbi_BigIcon   1
#define _db_tbi_SmallIcon 3

// CmdSet ToolBox Button record constants
#define _db_tbb_WCmd      "WCMD"

prototype CSAPI {

  void DbToolsExit( int Result, int DbFlags, int OrgWin );

  int DbGetPage( str FName, str DbPage, int &FirstRec, int &NumRec );

  int DbGetRecord( str FName, str DbPage, str DbField, str &DbData,
          int &RecNum, int &Flags, str Misc );

  int DbDelRecord( str FName, str DbPage, str DbField, str &DbData,
          int &RecNum, int &Flags, str Misc );

  int DbPutRecord( str FName, str DbPage, str DbField, str &DbData,
          int &RecNum, int &Flags, str Misc, str NewData );

  int DbCheckDupFields( str DbPage, str DbLine, str FieldData, ... );

  int DbCheckDupKeys( str DbRecord );

  int DbCheckWCmd( str &DbRecord );

  str DbGetKeyStr( int K1, int K2 );

  str DbCmdMap2Rec( struct TCmdMap );

  void DbRec2CmdMap( struct TCmdMap, str DbRecord );

  int DbGetCmdSection( str FName, str &Section, int &Flags );

  int DbDelCmdSection( str FName, str &Section, int &Flags );

  int DbPutCmdSection( str FName, str &Section, int &Flags, str NewSection );

  int DbGetCmd( str FName, str &Section, str &CmdRecord, int &Flags );

  int DbDelCmd( str FName, str &Section, str &CmdRecord, int &Flags );

  int DbPutCmd( str FName, str &Section, str &CmdRecord, int &Flags,
          str NewCmdRecord );

  str DbExpandChar( str TStr, str XChar );

  str DbMenu2Rec( str MenuText, int Level, int WCmd );

  void DbRec2Menu( str &MenuText, int &Level, int &WCmd, str MenuRec );

  int DbGetMenu( str FName, str MenuPage, struct TMenus, int &Level, int &WCmd,
          int &Flags );

  int DbDelMenu( str FName, str MenuPage, struct TMenus, int &Level, int &WCmd,
          int &Flags );

  int DbPutMenu( str FName, str MenuPage, struct TMenus, int &Level, int &WCmd,
          int &Flags, str &NewMenuRec );

  str DbTBox2Rec( str TBoxName, int BoxShow, int BoxStyle, int UseIcon );

  void DbRec2TBox( str &TBoxName, int &BoxShow, int &BoxStyle, int &UseIcon,
          str TBoxRec );

  int DbGetToolBox( str FName, str &TBoxName, int &Flags );

  int DbDelToolBox( str FName, str &TBoxName, int &Flags );

  int DbPutToolBox( str FName, str &TBoxName, int &Flags, str NewTBRec );

  int DbGetTBButton( str FName, str &TBoxName, int &WCmd, int &BtnNo,
          int &Flags );

  int DbDelTBButton( str FName, str &TBoxName, int &WCmd, int &BtnNo,
          int &Flags );

  int DbPutTBButton( str FName, str &TBoxName, int &WCmd, int &BtnNo,
          int &Flags, int NewWCmd );
}
