macro_file COBOL;
/****************************************************************************
*                         MULI-EDIT MACRO                                   *
*                                                                           *
*                                                                           *
* Name -                  03/17/89 03:55pm - updated        								*
*     COB_IND             05-19-92 12:25pm - Converted to .S source format	*
* 																					 (CMAC format)									*
*                                                                           *
*                                                                           *
* Desciption -                                                              *
*     Smart Indent macro for COBOL programming language.                    *
*                                                                           *
*                                          Written by -                     *
*                                                Marshall C. Youngblood     *
*                                                                           *
*****************************************************************************/
macro COB_IND
{
	str Hold_String,KEY_WORDS;
	int Temp_Col,Tmp_Val,Result;

	KEY_WORDS = ' GO AT INVALID FD IF COMPUTE ELSE';
	Refresh = False;
	Mark_Pos;
	Temp_Col = C_Col;
	if ( (Cur_Char=='|255')||(Cur_Char == '|13')&&(Search_Bwd('[~|9 ]', 1)) )
	{
		if ( Cur_Char == '.' )
		{
			if ( search_bwd(' PIC ', 1) )
			{
				First_Word;
				Set_Indent_Level;
				Goto_Mark;
				Cr;
			}
			else
			{
				First_Word;
				if ( C_Col > Temp_Col )
				{
					Goto_Mark;
					Set_Indent_Level;
					Cr;
				}
				else
				{
						Goto_Col(12);
						Set_Indent_Level;
						Goto_Mark;
						Cr;
				}
			}
		}
		else
		{
			if ( (Cur_Char=='*')||(Cur_Char=='/') )
			{
				Goto_Col(8);
				Set_Indent_Level;
				Goto_Mark;
				Cr;
			}
			else
			{
				First_Word;
				if ( C_Col > Temp_Col )
				{
					Goto_Mark;
					Set_Indent_Level;
					Cr;
				}
				else
				{
					Set_Indent_Level;
					Hold_String = Get_Word(' ');
					Goto_Mark;
					Cr;
					if ( (XPos(Hold_String,KEY_WORDS,1)!=0) )
					{
						if ( (Hold_String=='GO')||(Hold_String=='EXIT') )
							Tab_Left;
						else
							Tab_Right;
					}
				}
			}
		}
	}
	else
	{
		First_Word;
		if ( c_col == 1 )
			Goto_Col(8);
		Set_Indent_Level;
		Goto_Mark;
		Cr;
	}
	Refresh = True;
	Redraw;
}

macro COBTEMP
{
/****************************************************************************
*                         MULI-EDIT MACRO                                   *
*                                                                           *
*                                                                           *
* Name -                                  Last update - 03/17/89 03:55pm    *
*     COBTEMP                                                               *
*                                                                           *
* Desciption -                                                              *
*     Template macros for the COBOL programming language.                   *
*                                                                           *
*                                          Written by -                     *
*                                                Marshall C. Youngblood     *
*                                                                           *
*****************************************************************************/
	int Temp_Col,Temp_Insert,Result;
	str Key_Chars,Read_File_Name;
	char Temp_Char;

	Key_Chars = 'AMPDFRSW';
	Temp_Insert = Insert_Mode;
	if ( !At_Eol )
		GOTO END_OF_MAC;
	Insert_Mode = True;
	Temp_Col = C_COL;
	if ( C_Col > 1 )
	{
		Left;
		if ( 0 == XPos(Cur_Char,Key_Chars,1) )
		{
			Goto_Col(Temp_Col);
			Goto END_OF_MAC;
		}
	}
	else
		Goto END_OF_MAC;
	Temp_Col = C_COL;

	if ( Cur_Char=='R' )
	{
		Run_Macro('Read_Template /C=' + Str(Temp_Col));
		Goto END_OF_MAC;
	}

	if ( Cur_Char == 'S' )
	{
		Call Select_Template;
		Goto END_OF_MAC;
	}

	if ( Cur_Char == 'A' )
	{
		Run_Macro ('Accept_Template /C=' + Str(Temp_Col));
		Goto END_OF_MAC;
	}

	if ( Cur_Char == 'D' )
	{
		Run_Macro ('Display_Template /C=' + Str(Temp_Col));
		Goto END_OF_MAC;
	}

	if ( Cur_Char == 'F' )
	{
		Call Filler_Template;
		Goto END_OF_MAC;
	}

	if ( Cur_Char == 'P' )
	{
		Run_Macro('Perform_Template /C=' + Str(Temp_Col));
		Goto END_OF_MAC;
	}

	if ( Cur_Char == 'M' )
	{
		Call Move_Template;
		Goto END_OF_MAC;
	}

Goto END_OF_MAC;

Select_Template:

		Run_Macro('USERIN^XMenu /X=8/Y=5/S=1/L=Select Template Options' +
							'/M=Indexed(TE)Relative(TE)Sequential(TE)/T=1/B=1');
		Result = Return_Int;
#ifndef windows
		Kill_Box;
#endif
		Insert_Mode = False;
		Indent;
		Indent;
		Indent;
		Goto_Col(Temp_Col);
		Text('SELECT ');
		Insert_Mode = True;
		switch ( Result )
		{
			case 1 :
				Call Indexed_Template;
				break;

			case 2 :
				Call Relative_Template;
				break;

			case 3 :
				Call Sequential_Template;
				break;
		}
		Ret;

Indexed_Template:
		Cr;
		Goto_Col(Temp_Col);
		Text('        ORGANIZATION IS INDEXED');
		Cr;
		Goto_Col(Temp_Col);
		Text('        ACCESS IS DYNAMIC');
		Cr;
		Goto_Col(Temp_Col);
		Text('        RECORD KEY IS .');
		Up;
		Up;
		Up;
		Goto_Col(Temp_Col + 7);
		Ret;

Sequential_Template:
		Cr;
		Goto_Col(Temp_Col);
		Text('        ORGANIZATION IS LINE SEQUENTIAL');
		Cr;
		Goto_Col(Temp_Col);
		Text('        ACCESS IS SEQUENTIAL.');
		Up;
		Up;
		Goto_Col(Temp_Col + 7);
		Ret;

Relative_Template:
		Cr;
		Goto_Col(Temp_Col);
		Text('        ORGANIZATION IS RELATIVE');
		Cr;
		Goto_Col(Temp_Col);
		Text('        ACCESS IS DYNAMIC');
		Cr;
		Goto_Col(Temp_Col);
		Text('        RELATIVE KEY IS .');
		Up;
		Up;
		Up;
		Goto_Col(Temp_Col + 7);
		Ret;

Move_Template:
		Insert_Mode = False;
		Indent;
		Indent;
		Indent;
		Goto_Col(Temp_Col);
		Text('MOVE  TO');
		Insert_Mode = True;
		Goto_Col(Temp_Col + 5);
		Ret;

Filler_Template:
		Insert_Mode = False;
		Goto_Col(Temp_Col);
		Text('FILLER                      PIC X() VALUE');
		Insert_Mode = True;
		Goto_Col(Temp_Col + 34);
		Ret;

END_OF_MAC:
	Insert_Mode = Temp_Insert;
}

macro Read_Template
{
	str Read_File_Name,Into_File_Name,Col_Passed;
	int Temp_Col,No_Lock,Result,Read_Mode,File_Type;

	Col_Passed = Parse_Str('/C=',MParm_Str);
	Result = Val(Temp_Col,Col_Passed);

	Insert_Mode = False;
	Indent;
	Indent;
	Indent;
	Goto_Col(Temp_Col);
	Text('READ ');

	Read_File_Name = Global_Str('Last_Read_File');
	No_Lock = 1;
	Read_Mode = 0;
	File_Type = 0;

	Set_Global_Str('IHELP1',
		'/C=03/L=7/H= to select,   <ESC> to exit,   <F3> to edit.');
	Set_Global_Str('IHELP2',
		'/C=03/L=7/H=<ENTER> to accept input, <ESC> to abort input.');
	Set_Global_Str('ISTR_1',Read_File_Name);
	Set_Global_Str('IPARM_1','/T=File Name: /C=1/W=32/ML=32/H=TE/L=1');
	Set_Global_Str('ISTR_2',Into_File_Name);
	Set_Global_Str('IPARM_2','/T=Into : /C=1/W=32/ML=32/H=TE/L=2');
	Set_Global_Int('IINT_3',No_Lock);
	Set_Global_Str('ISTR_3','/T=YES/F=NO');
	Set_Global_Str('IPARM_3','/T=With No Lock?:/C=1/W=10/ML=30/H=TE/L=3/TP=5');
	Set_Global_Str('IPARM_4','/T=>>>>/C=1/H=TE/L=4/TP=6');
	Set_Global_Str('ISTR_4','[ACCEPT TEMPLATE]');

	Set_Global_Str('ISTR_5','Random(TE)Sequential(TE)');
	Set_Global_Int('IINT_5',Read_Mode);
	Set_Global_Str('IPARM_5','/T=Read_Mode:/C=1/W=12/H=TE/L=5/TP=3');
	Set_Global_Str('ISTR_6','Indexed(TE)Sequential(TE)Relative(TE)');
	Set_Global_Int('IINT_6',File_Type);
	Set_Global_Str('IPARM_6','/T=File Type:/C=1/W=12/H=TE/L=6/TP=3');

	Run_Macro('UserIn^Data_In /S=1/A=3/#=6/X=1/T=Read Template/Y=4');

	Read_Mode = Global_Int('IINT_5');
	File_Type = Global_Int('IINT_6');
	No_Lock = Global_Int('IINT_3');
	Read_File_Name = Global_Str('ISTR_1');
	Into_File_Name = Global_Str('ISTR_2');


	if ( Return_Int == 0 )
	{
		Undo;
		Undo;
		Goto End_of_Mac;
	}
	Read_File_Name = Return_Str;
	Text(Read_File_Name);
	if ( Into_File_Name != '' )
	{
		Cr;
		Goto_Col(Temp_Col);
		Text('  INTO ' + Into_File_Name);
	}
	if ( Read_Mode == 2 )
		Goto Read_Seq_Template;
	else
		Goto Read_Ran_Template;
	Goto End_of_Mac;

Read_Seq_Template:
		Result = Global_Int('File_Type');
		Insert_Mode = True;
		Cr;
		if ( File_Type == 0 )
		{
			Goto_Col(Temp_Col);
			Text('    NEXT RECORD');
			Cr;
		}
		Goto_Col(Temp_Col);
		Text('    WITH NO LOCK');
		Cr;
		Goto_Col(Temp_Col);
		Text('    AT END ');
		Cr;
		Goto_Col(Temp_Col + 8);
		Goto End_of_Mac;

Read_Ran_Template:
		Insert_Mode = False;
		Indent;
		Indent;
		Indent;
		Goto_Col(Temp_Col);
		Text('READ ' + Read_File_Name);
		Insert_Mode = True;
		Cr;
		Goto_Col(Temp_Col);
		Text('    WITH NO LOCK');
		Cr;
		Goto_Col(Temp_Col);
		Text('    INVALID KEY');
		Cr;
		Goto_Col(Temp_Col + 8);

END_OF_MAC:
}

macro Accept_Template
{
	str Col_Passed, Accept_Field, Line_Field, Col_Field, Size_Field;
	str Option_Line,Exception_Field,Exception_Proc;
	int Temp_Col,Result,Up_Cnt,Exception_Flag;

	Col_Passed = Parse_Str('/C=',MParm_Str);
	Result = Val(Temp_Col,Col_Passed);

	Insert_Mode = False;
	Indent;
	Indent;
	Indent;
	Goto_Col(Temp_Col);
	Text('ACCEPT ');

	Option_Line = 'PROMPT TAB NO BEEP UPDATE';
	Exception_Flag = 1;

	Set_Global_Str('IHELP1',
		'/C=08/L=8/H= to select,   <ESC> to exit,   <F3> to edit.');
	Set_Global_Str('IHELP2',
		'/C=08/L=8/H=<ENTER> to accept input, <ESC> to abort input.');
	Set_Global_Str('ISTR_1',Accept_Field);
	Set_Global_Str('IPARM_1','/T=Accept Field:/C=1/W=32/ML=32/H=TE/L=1');
	Set_Global_Str('ISTR_2',Line_Field);
	Set_Global_Str('IPARM_2','/T=Line:    /C=1/W=10/ML=30/H=TE/L=2');
	Set_Global_Str('ISTR_3',Col_Field);
	Set_Global_Str('IPARM_3','/T=Position:/C=1/W=10/ML=30/H=TE/L=3');
	Set_Global_Str('ISTR_4',Size_Field);
	Set_Global_Str('IPARM_4','/T=Size    :/C=1/W=10/ML=30/H=TE/L=4');
	Set_Global_Str('IPARM_5','/T=>>>>/C=1/H=TE/L=5/TP=6');
	Set_Global_Str('ISTR_5','[ACCEPT TEMPLATE]');
	Set_Global_Str('ISTR_6',Option_Line);
	Set_Global_Str('IPARM_6','/T=Options :/C=1/W=35/ML=30/H=TE/L=6');
	Set_Global_Int('IINT_7',Exception_Flag);
	Set_Global_Str('ISTR_7','/T=YES/F=NO');
	Set_Global_Str('IPARM_7','/T=Exception?:/C=1/W=3/ML=3/H=TE/L=7/TP=5');
	Run_Macro('UserIn^Data_In /S=1/A=3/#=7/X=1/T=Accept Template/Y=4');

	if ( Return_Int == 0 )
		Goto End_of_Macro;

	Accept_Field = Global_Str('ISTR_1');
	Line_Field = Global_Str('ISTR_2');
	Col_Field = Global_Str('ISTR_3');
	Size_Field = Global_Str('ISTR_4');
	Option_Line = Global_Str('ISTR_6');
	Exception_Flag = Global_Int('IINT_7');

	Text(Accept_Field);
	Insert_Mode = True;
	Cr;
	Goto_Col(Temp_Col);

	if ( Line_Field != '' )
		Text('    LINE ' + Line_Field);

	if ( Col_Field != '' )
		Text(' POSITION ' + Col_Field);
	if ( Col_Field != '' )
		Text(' SIZE ' + Size_Field);

	Cr;

	if ( Option_Line != '' )
	{
		Goto_Col(Temp_Col);
		Text('    ' + Option_Line);
		Cr;
	}

	if ( Exception_Flag )
	{
		Exception_Field = 'F-X';
		Exception_Proc = 'PERFORM F1-PROC THRU F1-X.';
		Set_Global_Str('IHELP1',
			'/C=3/L=4/H= to select,   <ESC> to exit,   <F3> to edit.');
		Set_Global_Str('IHELP2',
			'/C=3/L=4/H=<ENTER> to accept input, <ESC> to abort input.');
		Set_Global_Str('IPARM_1','/T=>>>>/C=1/H=TE/L=1/TP=6');
		Set_Global_Str('ISTR_1','[ACCEPT TEMPLATE]');
		Set_Global_Str('ISTR_2',Exception_Field);
		Set_Global_Str('IPARM_2','/T=Exception Field:/C=1/W=10/ML=30/H=TE/L=2');
		Set_Global_Str('ISTR_3',Exception_Proc);
		Set_Global_Str('IPARM_3','/T=Exception Procedure:/C=1/W=26/ML=40/H=TE/L=3');
		Run_Macro('UserIn^Data_In /S=1/A=3/#=3/X=1/T=Exception Options/Y=4');

		if ( Return_Int != 0 )
		{
			Exception_Field = Global_Str('ISTR_2');
			Exception_Proc = Global_Str('ISTR_3');
			Goto_Col(Temp_Col);
			Text('    ON EXCEPTION ' + Exception_Field);
			Cr;
			Goto_Col(Temp_Col);
			Text('        ' + Exception_Proc);
		}
	}

	Cr;
	Goto_Col(Temp_Col + 7);

End_of_Macro:
}

macro Display_Template
{
	str Col_Passed, Display_Field, Line_Field, Col_Field, Size_Field;
	int Temp_Col,Result;

	Col_Passed = Parse_Str('/C=',MParm_Str);
	Result = Val(Temp_Col,Col_Passed);

	Insert_Mode = False;
	Indent;
	Indent;
	Indent;
	Goto_Col(Temp_Col);
	Text('DISPLAY ');

	Set_Global_Str('IHELP1',
		'/C=3/L=6/H= to select,   <ESC> to exit,   <F3> to edit.');
	Set_Global_Str('IHELP2',
		'/C=3/L=6/H=<ENTER> to accept input, <ESC> to abort input.');
	Set_Global_Str('ISTR_1',Display_Field);
	Set_Global_Str('IPARM_1','/T=Display field:/C=1/W=32/ML=60/H=TE/L=1');
	Set_Global_Str('ISTR_2',Line_Field);
	Set_Global_Str('IPARM_2','/T=Line:    /C=1/W=10/ML=30/H=TE/L=2');
	Set_Global_Str('ISTR_3',Col_Field);
	Set_Global_Str('IPARM_3','/T=Position:/C=1/W=10/ML=30/H=TE/L=3');
	Set_Global_Str('ISTR_4',Size_Field);
	Set_Global_Str('IPARM_4','/T=Size:    /C=1/W=10/ML=30/H=TE/L=4');
	Set_Global_Str('IPARM_5','/T=>>>>/C=1/H=TE/L=5/TP=6');
	Set_Global_Str('ISTR_5','[ACCEPT TEMPLATE]');
	Run_Macro('UserIn^Data_In /S=1/A=3/#=5/X=1/T=Display Template/Y=4');

	Display_Field = Global_Str('ISTR_1');
	Line_Field = Global_Str('ISTR_2');
	Col_Field = Global_Str('ISTR_3');
	Size_Field = Global_Str('ISTR_4');

	if ( Return_Int == 0 )
	{
		Undo;
		Undo;
		Goto End_of_Mac;
	}

	Text(Display_Field);
	Insert_Mode = True;
	Cr;
	Goto_Col(Temp_Col);
	Text('    LINE ' + Line_Field);
	if ( Col_field != '' )
		Text(' POSITION ' + Col_Field);
	if ( Size_Field != '' )
		Text(' SIZE ' + Size_Field + '.');
	Up;
	Goto_Col(Temp_Col + 8);

End_of_Mac:
}

macro Perform_Template Trans
{
	int Temp_Col,Perform_Option,Result;
	str Perform_Procedure,Thru_Procedure,Temp_Line,Varying_Index,
			From_Index,By_Index,Until_Clause,Col_Passed;

	Col_Passed = Parse_Str('/C=',MParm_Str);
	Result = Val(Temp_Col,Col_Passed);

	Insert_Mode = False;
	Indent;
	Indent;
	Indent;
	Goto_Col(Temp_Col);
	Text('PERFORM ');

	Perform_Procedure = '';
	Thru_Procedure = '';

	Perform_Option = 1;

	Set_Global_Str('IHELP1',
		'/C=3/L=5/H= to select,   <ESC> to exit,   <F3> to edit.');
	Set_Global_Str('IHELP2',
		'/C=3/L=5/H=<ENTER> to accept input, <ESC> to abort input.');
	Set_Global_Str('ISTR_1',Perform_Procedure);
	Set_Global_Str('IPARM_1','/T=Perform:/C=1/W=32/ML=32/H=TE/L=1');
	Set_Global_Str('ISTR_2',Thru_Procedure);
	Set_Global_Str('IPARM_2','/T=Thru:   /C=1/W=32/ML=32/H=TE/L=2');
	Set_Global_Str('ISTR_3','Varying(TE)Until(TE)Times(TE)Omit(TE)');
	Set_Global_Int('IINT_3',Perform_Option);
	Set_Global_Str('IPARM_3','/T=Perform Option:/C=1/W=12/H=TE/L=3/TP=3');
	Set_Global_Str('IPARM_4','/T=>>>>/C=1/H=TE/L=4/TP=6');
	Set_Global_Str('ISTR_4','[ACCEPT PERFORM TEMPLATE]');
	Run_Macro('UserIn^Data_In /S=1/A=3/#=4/X=1/T=Perform Template/Y=4');


	if ( Return_Int == 0 )
	{
		Undo;
		Undo;
		Goto End_of_Mac;
	}

	Perform_Procedure = Global_Str('ISTR_1');
	Thru_Procedure = Global_Str('ISTR_2');
	Perform_Option = Global_Int('IINT_3');

	Result = Global_Int('IINT_3');
	Text(Perform_Procedure);
	Insert_Mode = True;
	if ( Thru_Procedure != '' )
	{
		Cr;
		Goto_Col(Temp_Col);
		Text ('   THRU ' + Thru_Procedure);
	}
	switch ( Result )
	{
		case 1 :
			Goto Varying_Template;
			break;

		case 2 :
			Goto Until_Template;
			break;

		case 3 :
			Goto Times_Template;
			break;
	}
	Goto End_Of_Mac;

Times_Template:
		Run_Macro('UserIn^QueryBox /C=1/L=3/W=15/ML=32/T=Times Option/H=TE' +
							'/P=How many Times?');
		if ( Return_Int == 0 )
			Goto End_of_Mac;
		Cr;
		Goto_Col(Temp_Col);
		Temp_Line = Return_Str + ' TIMES' ;
		Text(Temp_Line);
		Goto End_Of_Mac;

Varying_Template:

	From_Index = '1';
	By_Index = '1';
	Set_Global_Str('IHELP1',
		'/C=3/L=5/H= to select,   <ESC> to exit,   <F3> to edit.');
	Set_Global_Str('IHELP2',
		'/C=3/L=5/H=<ENTER> to accept input, <ESC> to abort input.');
	Set_Global_Str('ISTR_1',Varying_Index);
	Set_Global_Str('IPARM_1','/T=Varying :/C=1/W=32/ML=32/H=TE/L=1');
	Set_Global_Str('ISTR_2',From_Index);
	Set_Global_Str('IPARM_2','/T=From     /C=1/W=32/ML=32/H=TE/L=2');
	Set_Global_Str('ISTR_3',By_Index);
	Set_Global_Str('IPARM_3','/T=By       /C=1/W=32/ML=32/H=TE/L=3');
	Set_Global_Str('ISTR_4',Until_Clause);
	Set_Global_Str('IPARM_4','/T=Until    /C=1/W=32/ML=60/H=TE/L=4');
	Set_Global_Str('ISTR_5','[ACCEPT VARYING TEMPLATE]');
	Set_Global_Str('IPARM_5','/T=>>>>/C=1/H=TE/L=5/TP=6');
	Run_Macro('UserIn^Data_In /S=1/A=3/#=5/X=1/T=Varying Template/Y=4');

	Varying_Index = Global_Str('ISTR_1');
	From_Index = Global_Str('ISTR_2');
	By_Index = Global_Str('ISTR_3');
	Until_Clause = Global_Str('ISTR_4');
	if ( Return_Int == 0 )
		Goto End_Of_Mac;
	Cr;
	Goto_Col(Temp_Col);
	Text('VARYING ' + Varying_Index + ' FROM ' + From_Index + ' BY ' + By_Index);
	Cr;
	Goto_Col(Temp_Col);
	Text('  UNTIL ' + Until_Clause);
	Goto End_Of_Mac;

Until_Template:
		Run_Macro('UserIn^QueryBox /C=1/L=3/W=20/ML=55/T=Until Option/H=TE' +
							'/P=Until :');
		if ( Return_Int == 0 )
			Goto End_of_Mac;
		Cr;
		Goto_Col(Temp_Col);
		Temp_Line = '  UNTIL ' + Return_Str;
		Text(Temp_Line);
End_of_Mac:
}

/****************************************************************************
*                                                                           *
*  This Macro loads a copybook. If the line has the string 'COPY "' then    *
*  it will load that copy book in a linked window. If it doesn''t find      *
*  the string then it will prompt for a filename.                           *
*                                                                           *
*****************************************************************************/
macro LOAD_COPYBOOK
{
	str Copybook, Temp_Line, Copy_Path, Copy_Ext;
	int c_pos,Func,Main_Window,Copy_Window,X1,Y1,X2,Y2;
	Refresh = False;
	Main_Window = Window_Id;
	if ( First_Run )
		Call Save_Cur_Dim;
	Func = Parse_Int('/F=',MParm_Str);

Get_Path:
	Copy_Path = '';
	Copy_Path = Global_Str('COPYBOOK_PATH');
	Return_Str = Copy_Path;
	if ( (Func == 1) || (Copy_Path == '') )
	{
		if ( Copy_Path == '' )
			Call Get_RMPATH;
		Return_Str = Parse_Str(';',Temp_Line);
		while ( Copy_Path != '' )
		{
			Run_Macro('USERIN^QueryBox /C=1/L=4/W=40/ML/80/T=CopyBook Path' +
								'/H=*/P=Enter the Copy Book Path:');
			if ( Return_Int == 0 )
			{
				Return_Str = Parse_Str(';',Temp_Line);
				if(  Return_Str == ''  )
					Copy_Path = '-';
			}
			else
				Copy_Path = Return_Str;
		}
		Set_Global_Str('COPYBOOK_PATH',Temp_Line);
		if ( Return_Int == 0 )
			Func = 1;
	}
	if ( Func == 1 )
		Goto End_of_Macro;
	Copy_Path = Global_Str('COPYBOOK_PATH');
	Temp_Line = Get_Line;
	Temp_Line = Remove_Space(Temp_Line);
	c_pos = Xpos('COPY "', Temp_Line,1);
	if ( c_pos != 0 )
	{
		Temp_Line = Str_Del(Temp_Line,c_pos,6);
		Temp_Line = Remove_Space(Temp_Line);
		c_pos = Xpos('".', Temp_Line,1);
		Temp_Line = Str_Del(Temp_Line,c_pos,2);
	}
	else
	{
		Return_Str = '';
		Run_Macro('USERIN^QueryBox /C=1/L=4/W=40/ML/80/T=Copybook Name' +
						'/H=*/P=Enter the Copy_Book:');
		Temp_Line = Return_Str;
	}
	if(  (Length(copy_path) > 0) & (copy(copy_path,Length(copy_path),1) != '\')  )
		copy_path = copy_path + '\';

	if ( Return_Int == 0 )
		Goto End_of_Macro;
	if ( copy(caps(temp_line),1,length(copy_path)) == caps(copy_path) )
		temp_line = remove_space(temp_line);
	else
		Temp_Line = Copy_Path + Remove_Space(Temp_Line);
	Copy_Ext = Get_Extension(Temp_Line);
	if ( Copy_Ext == '' )
		Temp_Line = Temp_Line + '.CBL';
	while (  !File_Exists(Temp_Line) && (Return_Int != 0) )
	{
		Return_Str = Temp_Line;
		Run_Macro('USERIN^QueryBox /C=1/L=4/W=40/ML/80/T=' + Copy_Path
					+ Temp_Line + ' not found./H=*/P=Enter the Copy_Book:');
		Temp_Line = Return_Str;
	}
	if ( Return_Int == 0 )
		Goto End_of_Macro;
//	Size_Window(0,3,81,30);
//	Create_Window;
	return_str = temp_line;
	rm('ldfiles /CW=2');
//	Load_File(Temp_Line);
//	Size_Window(0,30,81,42);
	Goto End_of_Macro;

Get_RMPATH:
	Temp_Line = Get_Environment('RMPATH');
	Temp_Line = Str_Ins(';',Temp_Line,1);
	Temp_Line = Parse_Str(';',Temp_Line);
	Return_Str = Temp_Line;
	Ret;

Save_Cur_Dim:
	X1 = Win_X1;
	X2 = Win_X2;
	Y1 = Win_Y1;
	Y2 = Win_Y2;
	Ret;

Restore_Cur_Dim:
	Size_Window(X1,Y1,X2,Y2);
	Ret;

End_of_Macro:
	Refresh = True;
	Redraw;
}

macro Load_Listing
{
	int  Main_Window;
	str  List_File_Name;

	List_File_Name = Truncate_Extension(File_Name) + '.LST';
	Main_Window = Cur_Window;
	Refresh = False;
	Switch_Window(Cur_Window + 1);

	while ( (Cur_Window!=Main_Window)&&(File_Name!=List_File_Name) )
			Switch_Window(Cur_Window + 1);

	if ( Cur_Window != Main_Window )
		Delete_Window;
	Create_Window;
	if ( File_Exists(List_File_Name) )
	{
		Load_File(List_File_Name);
		if ( Error_Level != 0 )
			Make_Message('Unable to find ' + List_File_Name);
	}
	Refresh = True;
	Redraw;
}

macro RENUMBER_COBOL
{
// Renumbers Cobol source code.  If a block is defined, will do the block
// otherwise will do the whole file.

	int T_Insert_Mode = Insert_Mode,
					Start_Number,
					Increment = 10,
					T_Block_Stat = Block_Stat;

	Push_Undo;	// Make the whole macro 1 undo step

// Turn screen refresh off so it will happen much faster
	Refresh = False;
	Insert_Mode = False;

// Mark current cursor position
	Mark_Pos;

	if ( Block_Stat == 0 )
	{
		Tof;
		Block_Begin;
		Eof;
		Block_End;
	}
	Goto_Line(Block_Line1);
// Attempt to get the existing line number
	if ( ((Val(Start_Number,Copy(Get_Line,1,6))>0)||(Start_Number<1)) )
		Start_Number = 10;

// Present a dialog box for the user to enter parameters
	set_global_str('EXIPARM_1', '/TP=1/T=Starting line number:/QK=1/L=1/C=1/W=6/MIN=1/MAX=999999');
	set_global_int('EXIINT_1',Start_Number);
	set_global_str('EXIPARM_2', '/TP=1/T=Increment value:     /QK=1/L=2/C=1/W=3/MIN=1/MAX=999');
	set_global_int('EXIINT_2',Increment);
  RM('USERIN^DATA_IN /PRE=EX/#=2/T=Renumber Cobol Source');
	if ( Return_Int < 1 )
		Goto ABORT;
	Start_Number = Global_Int('EXIINT_1');
	Increment = Global_Int('EXIINT_2');

	while ( C_Line <= Block_Line2 )
	{
		Goto_Col(1);
		Text(Copy('000000',1,6 - Length(Str(Start_Number))) + Str(Start_Number));
		Start_Number = Start_Number + increment;
		DOWN;
	}


ABORT:
// Deallocate global variables
	set_global_int('EXIINT_1',0);
	set_global_int('EXIINT_2',0);

// Return to previous cursor position
	Goto_Mark;

// Restore previous insert mode
	Insert_Mode = T_Insert_Mode;

// If we previously did not have a block marked, un-mark it
	if ( T_Block_Stat == 0 )
		Block_Off;
	Refresh = True;
	Redraw;
	Pop_Undo;
}
