/*
***************************THINGS TO REMEMBER TO DO:***************************
a beta site wants non decimal mode to trunc rather than round
*/
macro_file CALC;
/* ******************************************************************************
													 MULTI-EDIT MACRO FILE CALC
CALC - The calculator
PASTECALC - Pastes the current calculator value in at the current cursor position

							 (C) Copyright 1991 by American Cybernetics, Inc.
****************************************************************************** */

#include dialog.sh
#include windows.sh
#include mew_dlgs.sh
#include mewlist2.sh
#include mewhelp.sh

//#define Calc_Modeless 0
#define Calc_Modeless (DLG_Modeless | DLG_NoParDisable) // parens necessary for proper evaluation

#define Calc_Display_Ctrl 1000
#define Calc_Paste_Ctrl 1001
#define Calc_Help_Ctrl 1002
#define Calc_ClrTape_Ctrl 1003
#define Calc_And_Ctrl 1004
#define Calc_Or_Ctrl 1005
#define Calc_Xor_Ctrl 1006
#define Calc_Mod_Ctrl 1007
#define Calc_Not_Ctrl 1008
#define Calc_A_Ctrl 1097
#define Calc_B_Ctrl 1098
#define Calc_C_Ctrl 1099
#define Calc_D_Ctrl 1100
#define Calc_E_Ctrl 1101
#define Calc_F_Ctrl 1102
#define Calc_0_Ctrl 1048
#define Calc_1_Ctrl 1049
#define Calc_2_Ctrl 1050
#define Calc_3_Ctrl 1051
#define Calc_4_Ctrl 1052
#define Calc_5_Ctrl 1053
#define Calc_6_Ctrl 1054
#define Calc_7_Ctrl 1055
#define Calc_8_Ctrl 1056
#define Calc_9_Ctrl 1057
#define Calc_Shl_Ctrl 1058
#define Calc_Shr_Ctrl 1059
#define Calc_add_Ctrl 1043
#define Calc_subtract_Ctrl 1045
#define Calc_Multiply_Ctrl 1042
#define Calc_Divide_Ctrl 1047
#define Calc_Equals_Ctrl 1028
#define Calc_CE_Ctrl 1029
#define Calc_PlusMinus_Ctrl 1030
#define Calc_Point_Ctrl 1046
#define Calc_Clear_Ctrl 1032
#define Calc_Close_Ctrl 1033
//#define Calc_Base_Ctrl 1034
//#define Calc_Base_t_Ctrl 1040
#define Calc_Function_Ctrl 1035
#define Calc_Bin_Ctrl 1202
#define Calc_Oct_Ctrl 1208
#define Calc_Dec_Ctrl 1210
#define Calc_Hex_Ctrl 1216

#define Calc_Disp_Frame_Ctrl 1036
#define Calc_Mem_In_Ctrl 1037
#define Calc_Mem_Plus_Ctrl 1038
#define Calc_Mem_Rec_Ctrl 1039
#define Calc_Mem_Clear_Ctrl 1040
#define Calc_Config_Ctrl 1041
// !!!!!!!!!!!!!!  watch the values above 1041 !!!!!!!!!!!!!!!!
#define Calc_Tape_Ctrl 1200
#define calc_tape_ctrl2 1201
// *************** any more you add below, be sure to include in calc_disable_btn() and calc_enable_btn()

// flags for calc_enable_btns()
#define calc_main_btns 1
#define calc_mem_btns 10

#define Calc_Title "Calculator"
#define Calc_Base_Title "&Base: "
#define tape_length 20
#define Calc_display_x 1
#define Calc_Display_Y_Units 24
#define Calc_display_y Dlg_Units | Calc_Display_Y_Units
//#define Calc_display_width 54
#define Calc_display_width 56
#define Calc_display_Height 5
#define Calc_display_Height2 (dlg_units | 61)
//#define Calc_display_Height 1
#define Calc_keys_Height 6
#define Calc_help_link "CALCULATOR"
#define Calc_BtnWidth 4
#define Calc_Mem_BtnWidth (dlg_units | 24)
#define decimal 10
#define oct 8
#define hex 16
#define bin 2
//#define word_length 32
//#define Word_Length_Mask $FFFFFFFF
//#define word_length 16
//#define Word_Length_Mask $FFFF
//#define Max_Pos 2147483647.0
//#define Min_Neg -2147483647.0


global {
  int Calc_Active_Window    "!CALC_ACTIVE_WINDOW";
  int Calc_hdlg             "!CALC_HDLG";
  int Calc_display_hdlg     "!CALC_DISPLAY_HDLG";
  int Calc_function_hdlg    "!CALC_Function_HDLG";
  int Calc_equals_hdlg      "!CALC_Equals_HDLG";
  int Calc_disp_frame_hdlg  "!CALC_disp_frame_HDLG";
  int Calc_tape_hdlg        "!CALC_TAPE_HDLG";
//  int Calc_tape_hdlg2       "!CALC_TAPE_HDLG2";
  int Calc_tape_window      "!CALC_TAPE_WINDOW";
  int Calc_result_flag      "!CALC_RESULT_FLAG";
  int Calc_dlg              "!CALC_DLG";
  int Calc_font             "!CALC_FONT";
  str Disp_Str              "!CALC_DISP_STR";
  str Func_Str1             "!CALC_FUNC_STR1";
  str Func_Str2             "!CALC_FUNC_STR2";
  str calc_struct_str       "!CALC_STRUCT_STR";
  int last_key_type         "!CALC_LAST_KEY_TYPE";
  int decimal_point         "!CALC_DECIMAL_POINT";
  int decimal_places        "!CALC_DECIMAL_PLACES";
  int which_one             "!CALC_WHICH_ONE";
  int base                  "!CALC_BASE";
  int shift_places          "!CALC_SHIFT_PLACES";
  str input_char            "!CALC_INPUT_CHAR";
  int error_flag            "!CALC_ERROR_FLAG";
  int function_pending      "!CALC_FUNC_PENDING";

  int word_length_mask      "!CALC_WORD_LEN_MASK";
// these are configuration variables, don't deallocate when exiting
  int calc_tape_off         "!CALC_TAPE_OFF";
  int word_length           "!CALC_WORD_LENGTH";
  int calc_unsigned         "!CALC_UNSIGNED";
  int Max_unsigned          "!CALC_MAX_UNSIGNED";
  int Max_Pos               "!CALC_MAX_POS";
  int Min_Neg               "!CALC_MIN_NEG";
}

struct calc_struct {
  real
      t_real,
      memory,
      accumulator,
      entry;
}


void calc() {

  if (calc_hdlg != 0) {
// don't allow multiple occurances, switch to currently active calculator
    SetActiveWindow(calc_hdlg);
		Return();
	}

  int lh, fh,fw,dlgfont,
      calc_notape_height = 0,
      calc_notape_height2 = 0;

  real t_real;
	struct TLogFont cur_font;
  struct calc_struct cs;
  str t_str[2048];

  switch (word_length) {
    case 8 :
      word_length_mask = 0xFF;
      Max_Unsigned = 255;
      Max_Pos = 127;
      Min_Neg = -128;
      break;
    case 16 :
      word_length_mask = 0xFFFF;
      Max_Unsigned = 65535;
      Max_Pos = 32767;
      Min_Neg = -32768;
      break;
    default :
      word_length_mask = 0xFFFFFFFF;
      word_length = 32;
//      Max_unsigned = 4294967295;  the compiler won't accept this
      calc_unsigned = false;
      Max_unsigned = 0;
      Max_Pos = 2147483647;
      Min_Neg = -2147483647;
      break;
  }

calc_unsigned = true;

  if (calc_tape_off) {
    calc_notape_height = 4;
    calc_notape_height2 = 46;
  }
  calc_active_window = window_id;
  shift_places = 1;

	Which_One = Parse_Int('/WO=',Global_Str('Calc_Params'));
	if(  ((Which_One > 1) || (Which_One < 0))  ) {
		Which_One = 0;
	}
	Last_Key_Type = Parse_Int('/LK=',Global_Str('Calc_Params'));
	if(  ((Last_Key_Type > 3) || (Last_Key_Type < 0))  ) {
		Last_Key_Type = 0;
	}
	Decimal_Places = Parse_Int('/DPL=',Global_Str('Calc_Params'));
	if(  ((Decimal_Places > 10) || (Decimal_Places < 0))  ) {
		Decimal_Places = 0;
	}
	Decimal_Point = Parse_Int('/DPO=',Global_Str('Calc_Params'));
	if(  ((Decimal_Point > 1) || (Decimal_Point < 0))  ) {
		Decimal_Point = 0;
	}
	Func_Str1 = Parse_Str('/FS1=',Global_Str('Calc_Params'));
	Func_Str2 = Parse_Str('/FS2=',Global_Str('Calc_Params'));
	Function_Pending = Parse_Int('/FP=',Global_Str('Calc_Params'));
	if(  ((Function_Pending > 1) || (Function_Pending < 0))  ) {
		Function_Pending = 0;
	}
//  if(  (RVal(Memory,Parse_Str('/MEM=',Global_Str('Calc_Params'))))  ) {
  if (RVal(t_real,Parse_Str('/MEM=',Global_Str('Calc_Params')))) {
    cs.Memory = 0.0;
  } else {
    cs.Memory = t_real;
  }
  if (RVal(t_real,Parse_Str('/ACC=',Global_Str('Calc_Params')))) {
    cs.Accumulator = 0.0;
  } else {
    cs.accumulator = t_real;
  }
  if (RVal(t_real,Parse_Str('/ENT=',Global_Str('Calc_Params')))) {
    cs.Entry = 0.0;
  } else {
    cs.entry = t_real;
  }
	Base = Parse_Int('/BASE=',Global_Str('Calc_Params'));
  if (XPos(' ' + Str(Base) + ' ',' 2 8 10 16 ',1) == 0) {
		Base = 10;
	}

	if(  (Which_One == 1)  ) {
    cs.T_Real = cs.Accumulator;
	} else {
    cs.T_Real = cs.Entry;
	}
/*
beep;
make_message(rstr(cs.accumulator,10,10) + " " + rstr(cs.entry,10,10));
read_key;
*/

  Struct_To_Str(t_str, cs);
  calc_struct_Str = t_str;


  Set_Global_Str('Calc_Base_Display2','Bin');
  Set_Global_Str('Calc_Base_Display8','Oct');
  Set_Global_Str('Calc_Base_Display10','Dec');
  Set_Global_Str('Calc_Base_Display16','Hex');

  Get_MEW_Dlg_Metrics (0, lh, fh,fw,dlgfont);

  cur_font.lfFaceName  = "Courier New";
  cur_font.lfCharSet = ANSI_Charset;
  cur_font.lfHeight = -fh;
  cur_font.lfWidth = 0;
 	cur_font.lfEscapement = 0;
  cur_font.lfWeight = fw_normal;
 	cur_font.lfItalic = 0;
 	cur_font.lfUnderline = 0;
 	cur_font.lfStrikeOut = 0;
  cur_font.lfOutPrecision = OUT_DEFAULT_PRECIS;
 	cur_font.lfCLipPrecision = Clip_Default_Precis;
  cur_font.lfQuality = Draft_Quality;
  cur_font.lfPitchAndFamily = Default_Pitch;

  Calc_font  = CreateFontIndirect(&cur_Font);


  DlgCreate(lh);
  calc_dlg = lh;

  DlgAddCtrl(calc_dlg, DLG_BlackFrame, "",
            calc_display_x,
            calc_display_y ,
            calc_display_width + 4,
            calc_display_height2 - calc_notape_height2,
            calc_disp_frame_ctrl,0,"");


  DlgAddCtrl(calc_dlg, DLG_BlackFrame, "",
              Dlg_PosOffset,
              Dlg_PosOffset | calc_display_height - calc_notape_height + 1,
              calc_display_width + 4,
              Dlg_Units | 76,
              0,0,"");


  DlgAddCtrl( calc_dlg, DLG_PushButton, "A&nd",
              Dlg_PosOffset | 2,
              Dlg_PosOffset | dlg_units | 4,
              DLG_StanBtnWidth, 0,
              Calc_And_ctrl, 0,
              "/M=CalcMathOp /FS=And/CTRL=" + str(Calc_And_Ctrl));


  DlgAddCtrl( calc_dlg, DLG_PushButton, "A",
              Dlg_PosOffset + Dlg_StanBtnWidth + 5,
              Dlg_PosOffset,
              Calc_BtnWidth, 0,
              Calc_A_ctrl,
              Dlgf_Disable,
              "/M=CalcNumChar /CTRL=" + str(Calc_A_Ctrl));

  DlgAddCtrl( calc_dlg, DLG_PushButton, "B",
              Dlg_PosOffset + Calc_BtnWidth + 1,
              Dlg_PosOffset,
              Calc_BtnWidth, 0,
              Calc_B_ctrl, 0,
              "/M=CalcNumChar /CTRL=" + str(Calc_B_Ctrl));

  DlgAddCtrl( calc_dlg, DLG_PushButton, "7",
              Dlg_PosOffset + Calc_BtnWidth + 3,
              Dlg_PosOffset,
              Calc_BtnWidth, 0,
              Calc_7_ctrl, 0,
              "/M=CalcNumChar /CTRL=" + str(Calc_7_Ctrl));

  DlgAddCtrl( calc_dlg, DLG_PushButton, "8",
              Dlg_PosOffset + Calc_BtnWidth + 1,
              Dlg_PosOffset,
              Calc_BtnWidth, 0,
              Calc_8_ctrl, 0,
              "/M=CalcNumChar /CTRL=" + str(Calc_8_Ctrl));

  DlgAddCtrl( calc_dlg, DLG_PushButton, "9",
              Dlg_PosOffset + Calc_BtnWidth + 1,
              Dlg_PosOffset,
              Calc_BtnWidth, 0,
              Calc_9_ctrl, 0,
              "/M=CalcNumChar /CTRL=" + str(Calc_9_Ctrl));

  DlgAddCtrl( calc_dlg, DLG_PushButton, "C&lear",
              Dlg_PosOffset + Calc_BtnWidth + 5,
              Dlg_PosOffset,
              Dlg_StanBtnWidth, 0,
              Calc_Clear_ctrl, 0,
              "/M=Calc_Clear");
/*
  DlgAddCtrl( calc_dlg, DLG_PushButton, "&Or",
              3,
              Dlg_PosOffset | Dlg_units | 18,
              DLG_StanBtnWidth, 0,
              Calc_Or_ctrl, 0,
              "/M=CalcMathOp /FS=Or /CTRL=" + str(Calc_Or_Ctrl));
*/
  DlgAddCtrl( calc_dlg, DLG_PushButton, "&Or",
              2,
              Dlg_PosOffset | Dlg_units | 18,
              Calc_Mem_BtnWidth, 0,
              Calc_Or_ctrl, 0,
              "/M=CalcMathOp /FS=Or /CTRL=" + str(Calc_Or_Ctrl));

  DlgAddCtrl( calc_dlg, DLG_PushButton, "&Xor",
              Dlg_PosOffset + calc_mem_btnWidth + 4,
              Dlg_PosOffset,
              Calc_Mem_BtnWidth, 0,
              Calc_Xor_ctrl, 0,
              "/M=CalcMathOp /FS=Xor/CTRL=" + str(Calc_Xor_Ctrl));

  DlgAddCtrl( calc_dlg, DLG_PushButton, "C",
              Dlg_PosOffset + Calc_BtnWidth + 5,
              Dlg_PosOffset,
              Calc_BtnWidth, 0,
              Calc_c_ctrl, 0,
              "/M=CalcNumChar /CTRL=" + str(Calc_C_Ctrl));

  DlgAddCtrl( calc_dlg, DLG_PushButton, "D",
              Dlg_PosOffset + Calc_BtnWidth + 1,
              Dlg_PosOffset,
              Calc_BtnWidth, 0,
              Calc_d_ctrl, 0,
              "/M=CalcNumChar /CTRL=" + str(Calc_D_Ctrl));

  DlgAddCtrl( calc_dlg, DLG_PushButton, "4",
              Dlg_PosOffset + Calc_BtnWidth + 3,
              Dlg_PosOffset,
              Calc_BtnWidth, 0,
              Calc_4_ctrl, 0,
              "/M=CalcNumChar /CTRL=" + str(Calc_4_Ctrl));

  DlgAddCtrl( calc_dlg, DLG_PushButton, "5",
              Dlg_PosOffset + Calc_BtnWidth + 1,
              Dlg_PosOffset,
              Calc_BtnWidth, 0,
              Calc_5_ctrl, 0,
              "/M=CalcNumChar /CTRL=" + str(Calc_5_Ctrl));

  DlgAddCtrl( calc_dlg, DLG_PushButton, "6",
              Dlg_PosOffset + Calc_BtnWidth + 1,
              Dlg_PosOffset,
              Calc_BtnWidth, 0,
              Calc_6_ctrl, 0,
              "/M=CalcNumChar /CTRL=" + str(Calc_6_Ctrl));

  DlgAddCtrl( calc_dlg, DLG_PushButton, "*",
              Dlg_PosOffset + Calc_BtnWidth + 5,
              Dlg_PosOffset,
              Calc_BtnWidth, 0,
              Calc_Multiply_ctrl, 0,
              "/M=CalcMathOp /FS= * /CTRL=" + str(Calc_Multiply_Ctrl));

  DlgAddCtrl( calc_dlg, DLG_PushButton, "/",
              Dlg_PosOffset + Calc_BtnWidth + 2,
              Dlg_PosOffset,
              Calc_BtnWidth, 0,
              Calc_Divide_ctrl, 0,
              "/M=CalcMathOp /FS= // /CTRL=" + str(Calc_Divide_Ctrl));

  DlgAddCtrl( calc_dlg, DLG_PushButton, "&<Shl",
              2,
              Dlg_PosOffset | Dlg_units | 18,
              Calc_Mem_BtnWidth, 0,
              Calc_Shl_ctrl, 0,
              "/M=CalcMathOp /FS=Shl/CTRL=" + str(Calc_Shl_Ctrl));

  DlgAddCtrl( calc_dlg, DLG_PushButton, "&>Shr",
              Dlg_PosOffset + calc_mem_btnWidth + 4,
              Dlg_PosOffset,
              Calc_Mem_BtnWidth, 0,
              Calc_Shr_ctrl, 0,
              "/M=CalcMathOp /FS=Shr/CTRL=" + str(Calc_Shr_Ctrl));
/*
  DlgAddCtrl( calc_dlg, DLG_PushButton, "&Xor",
              3,
              Dlg_PosOffset | Dlg_units | 18,
              DLG_StanBtnWidth, 0,
              Calc_Xor_ctrl, 0,
              "/M=CalcMathOp /FS=Xor/CTRL=" + str(Calc_Xor_Ctrl));
*/
  DlgAddCtrl( calc_dlg, DLG_PushButton, "E",
              Dlg_PosOffset + Calc_BtnWidth + 5,
              Dlg_PosOffset,
              Calc_BtnWidth, 0,
              Calc_E_Ctrl, 0,
              "/M=CalcNumChar /CTRL=" + str(Calc_E_Ctrl));

  DlgAddCtrl( calc_dlg, DLG_PushButton, "F",
              Dlg_PosOffset + Calc_BtnWidth + 1,
              Dlg_PosOffset,
              Calc_BtnWidth, 0,
              Calc_F_ctrl, 0,
              "/M=CalcNumChar /CTRL=" + str(Calc_F_Ctrl));

  DlgAddCtrl( calc_dlg, DLG_PushButton, "1",
              Dlg_PosOffset + Calc_BtnWidth + 3,
              Dlg_PosOffset,
              Calc_BtnWidth, 0,
              Calc_1_ctrl, 0,
              "/M=CalcNumChar /CTRL=" + str(Calc_1_Ctrl));

  DlgAddCtrl( calc_dlg, DLG_PushButton, "2",
              Dlg_PosOffset + Calc_BtnWidth + 1,
              Dlg_PosOffset,
              Calc_BtnWidth, 0,
              Calc_2_ctrl, 0,
              "/M=CalcNumChar /CTRL=" + str(Calc_2_Ctrl));

  DlgAddCtrl( calc_dlg, DLG_PushButton, "3",
              Dlg_PosOffset + Calc_BtnWidth + 1,
              Dlg_PosOffset,
              Calc_BtnWidth, 0,
              Calc_3_ctrl, 0,
              "/M=CalcNumChar /CTRL=" + str(Calc_3_Ctrl));

  DlgAddCtrl( calc_dlg, DLG_PushButton, "+",
              Dlg_PosOffset + Calc_BtnWidth + 5,
              Dlg_PosOffset,
              Calc_BtnWidth, 0,
              Calc_Add_ctrl, 0,
              "/M=CalcMathOp /FS= + /CTRL=" + str(Calc_Add_Ctrl));

  DlgAddCtrl( calc_dlg, DLG_PushButton, "-",
              Dlg_PosOffset + Calc_BtnWidth + 2,
              Dlg_PosOffset,
              Calc_BtnWidth, 0,
              Calc_Subtract_ctrl, 0,
              "/M=CalcMathOp /FS= - /CTRL=" + str(Calc_Subtract_Ctrl));

  DlgAddCtrl( calc_dlg, DLG_PushButton, "Mo&d",
              2,
              Dlg_PosOffset | Dlg_units | 18,
              Calc_Mem_BtnWidth, 0,
              Calc_Mod_ctrl, 0,
              "/M=CalcMathOp /FS=Mod/CTRL=" + str(calc_mod_ctrl));

  DlgAddCtrl( calc_dlg, DLG_PushButton, "&!Not",
              Dlg_PosOffset + calc_mem_btnWidth + 4,
              Dlg_PosOffset,
              Calc_Mem_BtnWidth, 0,
              Calc_Not_ctrl, 0,
              "/M=Calc_Complement /M=1");

/*
  DlgAddCtrl( calc_dlg, DLG_PushButton, "Clr&Tape",
              3,
              Dlg_PosOffset | Dlg_units | 18,
              DLG_StanBtnWidth,0,
              Calc_ClrTape_ctrl,0,
              "/M=Calc_Clear_Tape");
*/
  DlgAddCtrl( calc_dlg, DLG_PushButton, "C&E",
              Dlg_PosOffset + Calc_BtnWidth + 5,
              Dlg_PosOffset,
              Calc_BtnWidth * 2 + 1, 0,
              Calc_CE_ctrl, 0,
              "/M=Calc_Clear_Entry");

  DlgAddCtrl( calc_dlg, DLG_PushButton, "0",
              Dlg_PosOffset + (Calc_BtnWidth * 2) + 4,
              Dlg_PosOffset,
              Calc_BtnWidth, 0,
              Calc_0_ctrl, 0,
              "/M=CalcNumChar /CTRL=" + str(Calc_0_ctrl));

  DlgAddCtrl( calc_dlg, DLG_PushButton, ".",
              Dlg_PosOffset + Calc_BtnWidth + 1,
              Dlg_PosOffset,
              Calc_BtnWidth, 0,
              Calc_point_ctrl, 0,
              "/M=CalcDecimalPoint /CTRL=" + str(Calc_Point_ctrl));

  DlgAddCtrl( calc_dlg, DLG_PushButton, "+-",
              Dlg_PosOffset + Calc_BtnWidth + 1,
              Dlg_PosOffset,
              Calc_BtnWidth, 0,
              Calc_PlusMinus_ctrl, 0,
              "/M=Calc_Complement");

  DlgAddCtrl( calc_dlg, DLG_PushButton, "=",
              Dlg_PosOffset + Calc_BtnWidth + 5,
              Dlg_PosOffset,
              Dlg_StanBtnWidth, 0,
              Calc_Equals_ctrl, 0,
              "/M=Calc_Result");

  DlgAddCtrl(calc_dlg, DLG_GreyFrame, "",
            calc_display_x + Dlg_StanBtnWidth + 5,
            calc_display_y +
            ((Calc_display_height - calc_notape_height) * dlg_units_per_line) + 15,
            ((calc_btnWidth + 2) * 4) + 6,
            Dlg_Units | 70,
            0,0,"");


  DlgAddCtrl( calc_dlg, DLG_PushButton, "ClrTa&pe", 1,
              calc_display_y +
              ((Calc_display_height - calc_notape_height) * dlg_units_per_line) + 96,
              DLG_StanBtnWidth,0,
              Calc_ClrTape_ctrl,0,
              "/M=Calc_Clear_Tape");

  DlgAddCtrl( calc_dlg, DLG_PushButton, "Pa&ste",
              Dlg_PosOffset + Dlg_StanBtnWidth + 2,
              Dlg_PosOffset,
              DLG_StanBtnWidth,0,
              Calc_Paste_ctrl,0,"");

/*
  DlgAddCtrl( calc_dlg, DLG_PushButton, "&Paste",
              1,
              calc_display_y +
              (Calc_display_height * dlg_units_per_line) + 96,
              DLG_StanBtnWidth,0,
              Calc_Paste_ctrl,0,"");
*/
  DlgAddCtrl( calc_dlg, DLG_PushButton, "Close",
              Dlg_PosOffset + Dlg_StanBtnWidth + 2,
              Dlg_PosOffset,
              DLG_StanBtnWidth,0,
              Calc_Close_ctrl,0,"/R=0");

  DlgAddCtrl( calc_dlg, DLG_PushButton, "&Setup",
              Dlg_PosOffset + Dlg_StanBtnWidth + 3,
              Dlg_PosOffset,
              DLG_StanBtnWidth,0,
              Calc_Config_ctrl,0,"/M=CALC_SETUP");

  DlgAddCtrl( calc_dlg, DLG_PushButton, "Help",
              (calc_display_width + 4 - DLG_StanBtnWidth) ,
              Dlg_PosOffset,DLG_StanBtnWidth, 0,
              Calc_Help_ctrl,0,"/R=2");
/*
  DlgAddCtrl( calc_dlg, DLG_PushButton,
              Global_Str('Calc_Base_Display' + str(base)),
              calc_display_x + calc_display_width - 7,
              Calc_Display_Y - 20,
              dlg_units | 24, Dlg_units | 10,
              Calc_Base_ctrl,0,
              "/M=Calc_Change_Base");
*/
/*
  DlgAddCtrl( calc_dlg, DLG_PushButton,
              calc_base_title + Global_Str('Calc_Base_Display' + str(base)),
              calc_display_x + calc_display_width - Dlg_StanBtnWidth,
              Calc_Display_Y - 20,
              DLg_StanBtnWidth + 3,
              0,
              Calc_Base_ctrl,0,
              "/M=Calc_Change_Base");
*/
/*
  DlgAddCtrl(calc_dlg, DLG_Static, "&Base:",
            Dlg_NegOffset | 6,
            DLg_PosOffset | Dlg_units | 2,
            5,
            0,
            Calc_Base_t_ctrl,
            0,"");
*/

  DlgAddCtrl( calc_dlg, DLG_RadioButton,
              "&Bin",
              calc_display_x + calc_display_width - 13,
              1,
              0,
              0,
              Calc_Bin_ctrl,
              0,
              "");

  DlgAddCtrl( calc_dlg, DLG_RadioButton,
              "Oc&t",
              Dlg_PosOffset | 8,
              Dlg_PosOffset,
              0,
              0,
              Calc_Oct_ctrl,0,
              "");

  DlgAddCtrl( calc_dlg, DLG_RadioButton,
              "De&c",
              Dlg_NegOffset | 8,
              Dlg_PosOffset | Dlg_Units | 8,
              0,
              0,
              Calc_Dec_ctrl,0,
              "");

  DlgAddCtrl( calc_dlg, DLG_RadioButton,
              "&Hex",
              Dlg_PosOffset | 8,
              Dlg_PosOffset,
              0,
              0,
              Calc_Hex_ctrl,0,
              "");
  DlgSetInt(calc_dlg, 1200 + base, 1);




  DlgAddCtrl(calc_dlg, DLG_BlackFrame, "",
              dlg_units | 3,
              Calc_display_y + ((calc_display_height - calc_notape_height - 1) * dlg_units_per_line) + 6,
              59,
              Dlg_units | 4,
              0,0,"");

  DlgAddCtrl(calc_dlg, DLG_Static, "0000000000000000000000000000000000000000000000",
            Dlg_units | 3,
            Calc_display_y + ((calc_display_height - calc_notape_height - 1) * dlg_units_per_line) + 3,
            0, //52,
            0,
            Calc_Display_ctrl,
            DLGF_ss_Right,"");

  DlgAddCtrl(calc_dlg, DLG_Static, " And ",
            calc_display_x + calc_display_width - 2,
             Dlg_PosOffset,
             0, 0,Calc_Function_ctrl,
            DLGF_ss_Center,"");

  DlgAddCtrl(calc_dlg, DLG_BitmapStatic, "BT_ED_106",
            1,
            1,
            0, 0, 0, 0, "");

// memory buttons
  DlgAddCtrl( calc_dlg, DLG_PushButton,
              "M&in",
              9,
              Dlg_Units | 3,
              Calc_mem_btnWidth, 0,
              Calc_Mem_In_ctrl,0,
              "/M=CALC_MEMORY /ID=" + str(calc_mem_in_ctrl));

  DlgAddCtrl( calc_dlg, DLG_PushButton,
              "&M+",
              Dlg_PosOffset | Calc_Mem_BtnWidth + 6,
              Dlg_PosOffset,
              Calc_Mem_BtnWidth,
              0,
              Calc_Mem_Plus_ctrl,0,
              "/M=CALC_MEMORY /ID=" + str(calc_mem_Plus_ctrl));

  DlgAddCtrl( calc_dlg, DLG_PushButton,
              "M&rec",
              Dlg_PosOffset | Calc_Mem_BtnWidth + 6,
              Dlg_PosOffset,
              Calc_Mem_BtnWidth, 0,
              Calc_Mem_Rec_ctrl,0,
              "/M=CALC_MEMORY /ID=" + str(calc_mem_rec_ctrl));

  DlgAddCtrl( calc_dlg, DLG_PushButton,
              "Mc&lr",
              Dlg_PosOffset | Calc_Mem_BtnWidth + 6,
              Dlg_PosOffset,
              Calc_Mem_BtnWidth, 0,
              Calc_Mem_Clear_ctrl,0,
              "/M=CALC_MEMORY /ID=" + str(calc_mem_clear_ctrl));

  if (calc_tape_off) {
    calc_tape_window = 0;
  } else {
// this is the list box for the tape
    fh = window_id;

    fw = refresh;
    refresh = false;
    switch_window(window_count);
    create_window;
    calc_tape_window = window_id;
    for (lh = tape_length; lh > 0; --lh) {
      t_str = Global_Str("Calc_Tape" + Str(lh));
/*
beep;
make_message(str(lh) + " " + t_str);
read_key;
*/
      if (svl(t_str)) {
        if (xpos("@=",t_str,1)){
          put_line('@= ');
        } else {
          str t_str2 = parse_str("OP=", t_str);
          Put_Line("TAPE=/TX=" + parse_str("/TX=",t_str)
            + "/FT=" + str(calc_font)
            + "/FC=" + str(GetSysColor(Color_WindowText))
            + "/BC=" + str(GetSysColor(Color_Window))
            + "OP=/TX=" + parse_Str("/TX=",t_str2)
            + "/FT=" + str(calc_font)
            + "/FC=" + str(GetSysColor(Color_WindowText))
            + "/BC=" + str(GetSysColor(Color_Window))
            + "B=" + parse_Str("B=",t_str)
            );
        }
        Set_Global_Str("Calc_Tape" + Str(lh),"");
        down;
      }
    }
    up;
    while ((c_line > 1) && (xpos("@=",get_line,1))) {
      up;
    }


    DlgAddCtrl( calc_dlg, DLG_ListBox,
                "TAPE=/W=53/T=5OP=/W=2/T=5",
                Dlg_Units | (Calc_display_X * DLG_units_per_col) - 1,
                Calc_display_y,
                Dlg_Units | ((Calc_display_width) * DLG_Units_Per_Col) + 10,
                Calc_display_height - 1,
                Calc_tape_ctrl,
                DLGF_LB_ScrollBar,
                "/INCO=1/WIN=" + str(cur_window));

    switch_win_id(fh);
    refresh = fw;
  }

  DlgExecute( Calc_dlg, Calc_equals_Ctrl, Calc_title, calc_help_link,"/HOOK=CalcMsgProc",Calc_Modeless);

  switch_win_id(fh);

  if (!Calc_Modeless) {
    DlgKill(calc_dlg);
    Calc_dlg = 0;
  }

}
/*

macro PASTE_CALC {
// *******************************MULTI-EDIT MACRO******************************
//
//Name:  PASTE_CALC
//
//Description:  Will place the value last displayed on the calculator at the
//              current cursor position.
//
//               (C) Copyright 1991 by American Cybernetics, Inc.
//******************************************************************************

// Determine if the value last displayed is an entry or a result, then use the
//appropriate value
	if(  (Parse_Int('/WO=',Global_Str('Calc_Params')) == 1)  ) {
		Return_Str = Parse_Str('/ACC=',Global_Str('Calc_Params'));
	} else {
		Return_Str = Parse_Str('/ENT=',Global_Str('Calc_Params'));
	}
	RM('CALC /STR=1/RS=' + Return_Str + '/BASE=' +
		Parse_Str('/BASE=',Global_Str('Calc_Params')) + '/DPL=' +
		Parse_Str('/DPL=',Global_Str('Calc_Params')) + '/DPO=' +
		Parse_Str('/DPO=',Global_Str('Calc_Params')));

	Text(Return_Str);
}
*/

/*
void Calc_Word_Adjust() {
  if (word_length == 16) {
    if (base != Decimal) {
      int t_int;
      struct calc_struct cs;
      str t_str[2048] = calc_struct_str;

      Str_To_Struct(cs, t_str);

      if (cs.t_real > 0x7FFF) {

      }
      cs.memory
      cs.accumulator
      cs.entry


      Struct_To_Str(t_str, cs);
      calc_struct_str = t_str;

    }
  }
}
*/

void CalcMakeDisplay() {
  int t_int;
  struct calc_struct cs;
  str t_str[2048] = calc_struct_str;
  real x_real;

  Str_To_Struct(cs, t_str);
/* This routine will change T_Real into a string representation according to the
base */
  if (Base == Decimal) {
//make_message("LINE 1893");
    x_real = cs.t_real;
    if (word_length != 32) {
      if (calc_unsigned) {
        if (x_real > real_i(max_unsigned)) {
          x_real = x_real - real_I(max_unsigned);
        }
      } else if ((x_real > real_I(max_pos))) {
        X_real = real_I(max_unsigned) - x_real - 1.0;
      }
    }
//    Disp_Str = RStr(cs.T_Real,0,Decimal_Places);
    Disp_Str = RStr(x_Real,0,Decimal_Places);
/*
beep;
make_message("calcmakedisplay[" + str(decimal_places) + "]");
*/
    if ((Decimal_Point == True) & (Decimal_Places == 0)) {
			Disp_Str = Disp_Str + '.';
		}
	} else {

    Return_Int = Int_R(cs.T_Real);
/*
    if (Word_Length == 16) {
      if (Return_Int > 0x7FFF) {
        Return_int = 0 - Return_int;
      }
    }
*/
    Return_Int &= Word_Length_Mask;
		Disp_Str = '';
		if(  (Base == Bin)  ) {
			Shift_Places = 1;
		}
		if(  (Base == Oct)  ) {
			Shift_Places = 3;
		}
		if(  (Base == Hex)  ) {

			Shift_Places = 4;
		}

		while(  (Return_Int != 0)  ) {
			Disp_Str = Copy('0123456789ABCDEF',((Return_Int & (Base - 1)) + 1),1) + Disp_Str;
			Return_Int = Return_Int >> Shift_Places;
		}
    Return_Int = length(Disp_Str);
		if(  (Return_Int < (Word_Length / Shift_Places))  ) {
			Disp_Str = Copy('00000000000000000000000000000000',1,(Word_Length / Shift_Places) - Return_Int) + Disp_Str;
		}
	}
	if(  (Base == Bin)  ) {
/* Put in spaces every 4 bits for clarity */
		T_Int = (Word_Length / 4) - 1;
		while(  (T_Int)  ) {
			Disp_Str = Str_Ins(' ',Disp_Str,(T_Int * 4) + 1);
			--T_Int;
		}
	}
PAD_DISPLAY:
  Disp_Str = Copy('                                       ',1,39 - (length(Disp_Str))) + Disp_Str;

//  Struct_To_Str(t_str, cs);
//  calc_struct_str = t_str;
  RETURN();
}

void CalcSTRIP_SPACES() {
STRIP_SPACES:
	Return_Int = XPos(' ',Return_Str,1);
	if(  (Return_Int)  ) {
		Return_Str = Str_Del(Return_Str,Return_Int,1);
		Goto STRIP_SPACES;
	}
}

void Calc_Enable_Btns(int enable_mode, enable_flag) trans2 {
  switch (enable_mode) {

    case calc_mem_btns :
//      EnableWindow(GetDlgItem(calc_hdlg, Calc_Mem_In_Ctrl   ), enable_flag)
      EnableWindow(GetDlgItem(calc_hdlg, Calc_Mem_Plus_Ctrl ), enable_flag)
      EnableWindow(GetDlgItem(calc_hdlg, Calc_Mem_Rec_Ctrl  ), enable_flag)
      EnableWindow(GetDlgItem(calc_hdlg, Calc_Mem_clear_Ctrl ), enable_flag)
      break;

    case calc_main_btns :
      if (enable_flag) {
        EnableWindow(GetDlgItem(calc_hdlg, Calc_Point_Ctrl    ), false)
        EnableWindow(GetDlgItem(calc_hdlg, Calc_F_Ctrl        ), false)
        EnableWindow(GetDlgItem(calc_hdlg, Calc_E_Ctrl        ), false)
        EnableWindow(GetDlgItem(calc_hdlg, Calc_D_Ctrl        ), false)
        EnableWindow(GetDlgItem(calc_hdlg, Calc_C_Ctrl        ), false)
        EnableWindow(GetDlgItem(calc_hdlg, Calc_B_Ctrl        ), false)
        EnableWindow(GetDlgItem(calc_hdlg, Calc_A_Ctrl        ), false)
        EnableWindow(GetDlgItem(calc_hdlg, Calc_9_Ctrl        ), false)
        EnableWindow(GetDlgItem(calc_hdlg, Calc_8_Ctrl        ), false)
        EnableWindow(GetDlgItem(calc_hdlg, Calc_7_Ctrl        ), false)
        EnableWindow(GetDlgItem(calc_hdlg, Calc_6_Ctrl        ), false)
        EnableWindow(GetDlgItem(calc_hdlg, Calc_5_Ctrl        ), false)
        EnableWindow(GetDlgItem(calc_hdlg, Calc_4_Ctrl        ), false)
        EnableWindow(GetDlgItem(calc_hdlg, Calc_3_Ctrl        ), false)
        EnableWindow(GetDlgItem(calc_hdlg, Calc_2_Ctrl        ), false)
        switch (base) {
          case hex :
            EnableWindow(GetDlgItem(calc_hdlg, Calc_F_Ctrl        ), enable_flag)
            EnableWindow(GetDlgItem(calc_hdlg, Calc_E_Ctrl        ), enable_flag)
            EnableWindow(GetDlgItem(calc_hdlg, Calc_D_Ctrl        ), enable_flag)
            EnableWindow(GetDlgItem(calc_hdlg, Calc_C_Ctrl        ), enable_flag)
            EnableWindow(GetDlgItem(calc_hdlg, Calc_B_Ctrl        ), enable_flag)
            EnableWindow(GetDlgItem(calc_hdlg, Calc_A_Ctrl        ), enable_flag)
          case decimal :
            EnableWindow(GetDlgItem(calc_hdlg, Calc_9_Ctrl        ), enable_flag)
            EnableWindow(GetDlgItem(calc_hdlg, Calc_8_Ctrl        ), enable_flag)
          case oct :
            EnableWindow(GetDlgItem(calc_hdlg, Calc_7_Ctrl        ), enable_flag)
            EnableWindow(GetDlgItem(calc_hdlg, Calc_6_Ctrl        ), enable_flag)
            EnableWindow(GetDlgItem(calc_hdlg, Calc_5_Ctrl        ), enable_flag)
            EnableWindow(GetDlgItem(calc_hdlg, Calc_4_Ctrl        ), enable_flag)
            EnableWindow(GetDlgItem(calc_hdlg, Calc_3_Ctrl        ), enable_flag)
            EnableWindow(GetDlgItem(calc_hdlg, Calc_2_Ctrl        ), enable_flag)
          case bin :
            EnableWindow(GetDlgItem(calc_hdlg, Calc_1_Ctrl        ), enable_flag)
            EnableWindow(GetDlgItem(calc_hdlg, Calc_0_Ctrl        ), enable_flag)
            break;
        }
      } else {
        EnableWindow(GetDlgItem(calc_hdlg, Calc_F_Ctrl        ), false)
        EnableWindow(GetDlgItem(calc_hdlg, Calc_E_Ctrl        ), false)
        EnableWindow(GetDlgItem(calc_hdlg, Calc_D_Ctrl        ), false)
        EnableWindow(GetDlgItem(calc_hdlg, Calc_C_Ctrl        ), false)
        EnableWindow(GetDlgItem(calc_hdlg, Calc_B_Ctrl        ), false)
        EnableWindow(GetDlgItem(calc_hdlg, Calc_A_Ctrl        ), false)
        EnableWindow(GetDlgItem(calc_hdlg, Calc_9_Ctrl        ), false)
        EnableWindow(GetDlgItem(calc_hdlg, Calc_8_Ctrl        ), false)
        EnableWindow(GetDlgItem(calc_hdlg, Calc_7_Ctrl        ), false)
        EnableWindow(GetDlgItem(calc_hdlg, Calc_6_Ctrl        ), false)
        EnableWindow(GetDlgItem(calc_hdlg, Calc_5_Ctrl        ), false)
        EnableWindow(GetDlgItem(calc_hdlg, Calc_4_Ctrl        ), false)
        EnableWindow(GetDlgItem(calc_hdlg, Calc_3_Ctrl        ), false)
        EnableWindow(GetDlgItem(calc_hdlg, Calc_2_Ctrl        ), false)
        EnableWindow(GetDlgItem(calc_hdlg, Calc_1_Ctrl        ), false)
        EnableWindow(GetDlgItem(calc_hdlg, Calc_0_Ctrl        ), false)
      }
      EnableWindow(GetDlgItem(calc_hdlg, Calc_Paste_Ctrl    ), enable_flag)
//      EnableWindow(GetDlgItem(calc_hdlg, Calc_Help_Ctrl     ), enable_flag)
      if (calc_tape_off) {
        EnableWindow(GetDlgItem(calc_hdlg, Calc_ClrTape_Ctrl  ), false)
      } else {
        EnableWindow(GetDlgItem(calc_hdlg, Calc_ClrTape_Ctrl  ), enable_flag)
      }
      EnableWindow(GetDlgItem(calc_hdlg, Calc_And_Ctrl      ), enable_flag)
      EnableWindow(GetDlgItem(calc_hdlg, Calc_Or_Ctrl       ), enable_flag)
      EnableWindow(GetDlgItem(calc_hdlg, Calc_Xor_Ctrl      ), enable_flag)
      EnableWindow(GetDlgItem(calc_hdlg, Calc_Mod_Ctrl      ), enable_flag)
      EnableWindow(GetDlgItem(calc_hdlg, Calc_Not_Ctrl      ), enable_flag)
      EnableWindow(GetDlgItem(calc_hdlg, Calc_Shl_Ctrl      ), enable_flag)
      EnableWindow(GetDlgItem(calc_hdlg, Calc_Shr_Ctrl      ), enable_flag)
      EnableWindow(GetDlgItem(calc_hdlg, Calc_add_Ctrl      ), enable_flag)
      EnableWindow(GetDlgItem(calc_hdlg, Calc_subtract_Ctrl ), enable_flag)
      EnableWindow(GetDlgItem(calc_hdlg, Calc_Multiply_Ctrl ), enable_flag)
      EnableWindow(GetDlgItem(calc_hdlg, Calc_Divide_Ctrl   ), enable_flag)
      EnableWindow(GetDlgItem(calc_hdlg, Calc_Equals_Ctrl   ), enable_flag)
      EnableWindow(GetDlgItem(calc_hdlg, Calc_CE_Ctrl       ), enable_flag)
      EnableWindow(GetDlgItem(calc_hdlg, Calc_PlusMinus_Ctrl), enable_flag)
//      EnableWindow(GetDlgItem(calc_hdlg, Calc_Point_Ctrl    ), enable_flag)
      if (base == decimal) {
          EnableWindow(GetDlgItem(calc_hdlg, Calc_Point_Ctrl    ), enable_flag)
      }
      EnableWindow(GetDlgItem(calc_hdlg, Calc_Clear_Ctrl    ), enable_flag)
      EnableWindow(GetDlgItem(calc_hdlg, Calc_Close_Ctrl    ), enable_flag)
//      EnableWindow(GetDlgItem(calc_hdlg, Calc_Base_Ctrl    ), enable_flag)
      break;
    case 1 :

      break;

  }
}

void CalcWriteDisplay() {
  struct calc_struct cs;
  str t_str[2048] = calc_struct_str;
  Str_To_Struct(cs, t_str);
/*
  if (cs.memory == 0.0) {
// disable m+ and mrec buttons
    Calc_enable_btns(calc_mem_btns, false);
//    ShowWindow(GetDlgItem(calc_hdlg,calc_mem_stat_ctrl), SW_HIDE);
//    SendDlgItemMessage(calc_hdlg,calc_disp_frame_ctrl,WM_PAINT, 0, 0);
  } else {
    Calc_enable_btns(calc_mem_btns, True);
//    ShowWindow(GetDlgItem(calc_hdlg,calc_mem_stat_ctrl), SW_SHOW);
  }
*/
  SetDlgItemText(Calc_Hdlg, calc_display_ctrl,
    remove_space(disp_str) + " ");

//set_global_str("!XXX!",calc_struct_str);

}

void Calc_Clear_Func() {
/*
  ShowWindow(GetDlgItem(calc_hdlg,calc_function_ctrl), SW_HIDE);
  SendDlgItemMessage(calc_hdlg,calc_disp_frame_ctrl,WM_PAINT, 0, 0);
*/
  SetWindowText(GetDlgItem(calc_hdlg,calc_function_ctrl)," ");
}

void Calc_Write_Func() {
  int hFunc = GetDlgItem(calc_hdlg,calc_function_ctrl);
  ShowWindow(hFunc, SW_SHOW);
  SetWindowText(hFunc,remove_space(func_str1));
}

void Calc_Clear_Entry() {
  struct calc_struct cs;
  str t_str[2048] = calc_struct_str;
  Str_To_Struct(cs, t_str);

  cs.Entry = 0.0;
  cs.T_Real = 0.0;
  Decimal_Places = 0;
  Decimal_Point = False;
//  Goto DISPLAY_AND_GET_KEY;
  Struct_To_Str(t_str, cs);
  calc_struct_str = t_str;
  CalcMakeDisplay();
  CalcWriteDisplay();
}

void Calc_Complement(int t_mode = parse_int("/M=",mparm_str)) {
  struct calc_struct cs;
  str t_str[2048] = calc_struct_str;
  Str_To_Struct(cs, t_str);

  if (t_mode) {
    cs.Entry = real_i(int_r(cs.entry) ^ 0xFFFFFFFF);
  } else {
    cs.Entry = 0.0 - cs.Entry;
  }
  cs.T_Real = cs.Entry;
//  Goto DISPLAY_AND_GET_KEY;
  Struct_To_Str(t_str, cs);
  calc_struct_str = t_str;
  CalcMakeDisplay();
  CalcWriteDisplay();
}

void CalcInputNumeric(flag) {
  Real x_real;
  int t_int;

/*
make_message("[" + str(ascii(input_char)) + "]");
read_key;
*/
  struct calc_struct cs;
  str t_str[2048] = calc_struct_str;

  Str_To_Struct(cs, t_str);

  if (flag == true) {
    goto STRING_TO_REAL;
  }


INPUT_NUMERIC:
//  Call MAKE_DISPLAY;
  CalcMAKEDISPLAY();
	Return_Str = Remove_Space(Disp_Str);
  if (Base == Bin) {
//    Call STRIP_SPACES;
    CalcSTRIP_SPACES();
	}
  if (Base == Decimal) {
		if(  ((Decimal_Point == True) & (Input_Char != '.'))  ) {
			if(  (Input_Char == '|8')  ) {
				if(  (Decimal_Places == 0)  ) {
					Decimal_Point = False;
					Goto DELETE_DEC;
				}
				--Decimal_Places;
				Goto DELETE_DEC;
			} else {
				++Decimal_Places;
			}
		} else {
			if(  (Input_Char == '|8')  ) {
DELETE_DEC:
				Return_Str = Copy(Return_Str,1,Length(Return_Str) - 1);
			}
		}
	} else {
		if(  (Input_Char == '|8')  ) {
			Return_Str = Copy('0' + Return_Str,1,Length(Return_Str));
		} else {
			Return_Str = Copy(Return_Str,2,31);
		}
	}
	if(  (XPos(Input_Char,'.|8',1) == 0)  ) {
		Return_Str = Return_Str + Input_Char;
	}
/* now, convert it back to a real */
	Return_Int = Base;
/* We are storing Base into Return_Int just so we can accomodate a call to the
following label */
STRING_TO_REAL:
  if (Return_Int == Decimal) {
    Return_Int = RVal(x_Real,Return_Str);
    cs.T_Real = x_real;
	} else {
    cs.T_Real = 0.0;
		T_Int = Length(Return_Str);
		while(  (T_Int > 0)  ) {
      cs.T_Real = cs.T_Real + Real_I((XPos(Copy(Return_Str,Length(Return_Str) - T_Int
					+ 1,1),'0123456789ABCDEF',1) - 1) << (Shift_Places * (T_Int - 1)));
			--T_Int;
		}
	}

  if ((cs.T_Real > Real_I(Max_Pos)) | (cs.T_Real < Real_I(Min_Neg))) {
    if (word_length != 32) {
      if (cs.T_Real > Real_I(Max_Pos)) {
//        cs.t_real = 0.0 - cs.t_real;
        goto WRAP;
      }
    }
		Error_Flag = True;
	} else {
		Error_Flag = False;
	}

WRAP:

  Struct_To_Str(t_str, cs);
  calc_struct_str = t_str;
}

void calc_displaytape() {
  if (calc_tape_off) {
    RETURN();
  }
  int active_window = window_id;

  if (switch_win_id(calc_tape_window)) {
    while ((c_line > 1) && (xpos("@=",get_line,1))) {
      up;
    }
    sendmessage(calc_tape_hdlg, LB_SETCURSEL, c_line - 1, 0);
    SendMessage(calc_tape_hdlg, WM_SETREDRAW, 1, 0);
    sendmessage(calc_tape_hdlg, WM_ML2_REDRAW,0,0 );
  }
  switch_win_id(active_window);
}

void calc_pad_tape() {
  if (calc_tape_off) {
    RETURN();
  }

  int actual_tape_length,
      active_window = window_id;

  if (switch_win_id(calc_tape_window)) {

PAD_TAPE:
    eof;
    if (c_col == 1) {
      up;
    }
    actual_tape_length = c_line;
    tof;
    while (actual_tape_length < 5) {
      insert_mode = true;
      cr;
      up;
      put_line('|0                                        |254');
      ++actual_tape_length;
    }
    eof;
    if (c_col == 1) {
      up;
    }
    goto_col(1);
  }
  switch_win_id(active_window);
}

void calc_Clear_tape() {
  if (calc_tape_off) {
    RETURN();
  }
  int active_window = window_id;
  calc_result_flag = false;

  if (switch_win_id(calc_tape_window)) {
CLEAR_TAPE:
    Tof;
    while (not(at_eof)) {
      del_line;
      sendmessage(calc_tape_hdlg, LB_DELETESTRING, 0, 0);

    }
    calc_displaytape();
  }

  switch_win_id(active_window);
}

void Calc_Push_Tape(str t_str) {
  if (calc_tape_off) {
    RETURN();
  }
  if (calc_result_flag) {
    calc_result_flag = false;
    calc_push_tape("");
  }

  int active_window = window_id,
      actual_tape_Length;
  str t_tape;

  if (switch_win_id(calc_tape_window)) {
PUSH_TAPE:
    mark_pos;
    actual_tape_length = c_line;
    tof;
    if ((actual_tape_length >= tape_length) || (cur_char == '|0')) {
      del_line;
      sendmessage(calc_tape_hdlg, LB_DELETESTRING, 0, 0);
//      calc_displaytape();
    }
//    goto_mark;
    eof;
    if (c_col > 1) {
      down;
    }
    goto_col(1);
     if (t_Str == '') {
//      t_tape = '|254';
      t_tape = '@= ';
    } else {
       t_tape = "TAPE=/TX=" + Disp_Str +
          "/FT=" + str(calc_font)
          + "/FC=" + str(GetSysColor(Color_WindowText))
          + "/BC=" + str(GetSysColor(Color_Window))
          + "OP=/TX=" + t_Str +
          "/FT=" + str(calc_font)
          + "/FC=" + str(GetSysColor(Color_WindowText))
          + "/BC=" + str(GetSysColor(Color_Window))
          ;
    }
    put_line(t_tape + 'B=' + Str(base));

    sendmessage(calc_tape_hdlg, LB_ADDSTRING, 0, 0);
    calc_displaytape();
  }

  switch_win_id(active_window);
}


void calc_tape_select() {
  if (calc_tape_off) {
    RETURN();
  }
  int active_window = window_id,
      t_int;
  struct calc_struct cs;
  str t_str[2048] = calc_struct_str;
  Str_To_Struct(cs, t_str);

  if (switch_win_id(calc_tape_window)) {
/* Turn the string into a real value, then stuff it into the entry */
//    Return_Str = Remove_Space(Copy(get_line,1,39));
    Return_str = parse_str("/TX=",get_line);
//    T_Int = Parse_Int('/B=',get_line);
    T_Int = Parse_Int('B=',get_line);
    if (T_Int == Bin) {
      calcstrip_Spaces();
//      Call STRIP_SPACES;
		}
		Return_Int = T_Int;
    if (Base == Decimal) {
			Decimal_Point = XPos('.',Return_Str,1);
			if(  (Decimal_Point)  ) {
				Decimal_Places = Length(Return_Str) - Decimal_Point;
				Decimal_Point = True;
			}
		}

//    Call STRING_TO_REAL;
    Struct_To_Str(t_str, cs);
    calc_struct_str = t_str;
    CalcInputNumeric(True);
    t_str = calc_struct_Str;
    Str_To_Struct(cs, t_str);

    cs.Entry = cs.T_Real;
    Which_One = 0;
    Func_Str2 = '';

//    Call FILL_FACEPLATE;
    SetFocus(GetDlgItem(calc_hdlg,Calc_Equals_ctrl));

    if ((Which_One) && (function_pending)) {
//      call WRITE_FUNC_STR;
      Calc_Write_Func();
    }
//    Call RESTORE_SHIFT_STAT;
//    Call DISPLAY_TAPE;
    Calc_DisplayTape();
    CalcMakeDisplay();
    CalcWriteDisplay();
  }
  switch_win_id(active_window);
  Struct_To_Str(t_str, cs);
  calc_struct_str = t_str;
}

void Calc_Clear() {
  struct calc_struct cs;
  str t_str[2048] = calc_struct_str;
  Str_To_Struct(cs, t_str);

CLEAR:
	Which_One = 0;
	Decimal_Places = 0;
	Decimal_Point = False;
  cs.Accumulator = 0.0;
  cs.Entry = 0.0;
  cs.T_Real = 0.0;
	Func_Str1 = '';
	Func_Str2 = '';
	Last_Key_Type = 0;
	Function_Pending = False;
//  call CLEAR_FUNC_STR;
  Calc_Clear_Func();
//  Return_Str = 'C';
//  Call PUSH_TAPE;
  Struct_To_Str(t_str, cs);
  calc_struct_str = t_str;
  CalcMakeDisplay();
  calc_result_flag = false;
  Calc_Push_Tape("C");
  CalcWriteDisplay();
}

int CalcDecimalPlace(real x_real) {
  struct calc_struct cs;
  str t_str[2048] = calc_struct_str;
  int t_int;

  Str_To_Struct(cs, t_str);
/*
cs.t_real = 2.5;
*/
  T_Str = RStr(x_real,0,10);
  T_Str = Copy(T_Str,XPos('.',T_Str,1),11);
	T_Int = 11;
  while (Str_char(T_Str,T_Int) == '0') {
		--T_Int;
	}
  --t_int;
/*
make_message(str(t_int));
*/
  return(T_Int);
}

void calc_error() trans2 {
  RM("MEERROR^MESSAGEBOX /T=Calculator/M=Error in entry or operation!");
  Calc_Clear();
}

void Calc_Do_Function() {
  struct calc_struct cs;
  str t_str[2048] = calc_struct_str;
//real xx;

  Str_To_Struct(cs, t_str);

DO_FUNCTION:
	Error_Flag = False;
  if (Func_Str1 == ' + ') {
    cs.T_Real = cs.T_Real + cs.Entry;
    if (cs.T_Real > Real_I(Max_Pos)) {
			Error_Flag = True;
		}
	}
  if (Func_Str1 == ' - ') {
    cs.T_Real = cs.T_Real - cs.Entry;
    if (cs.T_Real < Real_I(Min_Neg)) {
			Error_Flag = True;
		}
	}
  if (Func_Str1 == ' * ') {
    cs.T_Real = cs.T_Real * cs.Entry;
    if (cs.T_Real > Real_I(Max_Pos)) {
			Error_Flag = True;
		}
	}
  if (Func_Str1 == ' / ') {
    if (cs.Entry == 0.0) {
			Error_Flag = True;
      calc_error();
      Return();
		}
//xx = cs.T_Real / cs.Entry;
    cs.T_Real = cs.T_Real / cs.Entry;
/*
beep;
make_message(rstr(cs.t_real , 10 ,10) + " " +
    rstr(cs.entry, 10, 10) + " " +
    rstr(xx, 10, 10));
*/
	}
/* if we are doing And Or Xor Mod, we need to convert to integer type first,
do the operation, then convert back to real. */
  if (Func_Str1 == 'And') {
    cs.T_Real = Real_I(Int_R(cs.T_Real) & Int_R(cs.Entry));
	}
  if (Func_Str1 == 'Or ') {
    cs.T_Real = Real_I(Int_R(cs.T_Real) | Int_R(cs.Entry));
	}
  if (Func_Str1 == 'Xor') {
    cs.T_Real = Real_I(Int_R(cs.T_Real) ^ Int_R(cs.Entry));
	}
  if (Func_Str1 == 'Mod') {
    cs.T_Real = Real_I(Int_R(cs.T_Real) % Int_R(cs.Entry));
	}
  if (Func_Str1 == 'Shl') {
    cs.T_Real = Real_I(Int_R(cs.T_Real) << Int_R(cs.Entry));
	}
  if (Func_Str1 == 'Shr') {
    cs.T_Real = Real_I(Int_R(cs.T_Real) >> Int_R(cs.Entry));
	}
  if ((Base == Decimal) & (Error_Flag == False)) {
/* Adjust Decimal_Places */
//    Call GET_DECIMAL_PLACES;
//    Decimal_Places = Return_Int;
    Decimal_Places = CalcDecimalPlace(cs.t_real);
/*
RM("MEERROR^MESSAGEBOX /T=calcdofunction/M=decimal_places=" + str(decimal_places));
*/
	}

  Struct_To_Str(t_str, cs);
  calc_struct_str = t_str;
}

int CalcChkWordLen() {
  struct calc_struct cs;
  str t_str[2048] = calc_struct_str;

  Str_To_Struct(cs, t_str);
  int ret_value;
  if (Base == Decimal) {
    cs.T_Real = cs.Entry;
//    Call GET_DECIMAL_PLACES;
    return_int = CalcDecimalPlace(cs.t_real);
/*
beep;
make_message("calcchkwordlen[" + str(return_int) + "]");
*/
    Return_Str = RStr(cs.Entry,0,Return_Int);
    Ret_Value = ((Length(Return_Str) - (XPos('.',Return_Str,1) > 0) -
      (cs.Entry < 1.0)) > 9);
	} else {
    Ret_Value = (Copy(Remove_Space(Disp_Str),1,1) != '0');
	}
  Struct_To_Str(t_str, cs);
  calc_struct_str = t_str;
  RETURN(Ret_Value);
}


void CalcNumChar() {

  int ctrl_id = parse_int("/CTRL=",mparm_str);
  struct calc_struct cs;
  str t_str[2048] = calc_struct_str;

  input_char = caps(char(ctrl_id - 1000));

/*
make_message("INPUT_CHAR=" + input_char);
*/
  Str_To_Struct(cs, t_str);

  Func_Str2 = '';
/* Be sure that we are not about to exceed the amount of significant digits */
//  if ((Input_Char != '|8') && (Last_Key_Type == 1)) { will we process the backspace key?
  if (Last_Key_Type == 1) {
//    Call CHECK_WORD_LENGTH;

    if (CalcChkWordLen()) {
//      Goto GET_KEY;
      Return();
    }

  }
  if (Last_Key_Type != 1) {
    cs.Entry = 0.0;
    cs.T_Real = 0.0;

//    if (Input_Char != '.') {
    if (ctrl_id != calc_point_ctrl) {
      Decimal_Point = 0;
    }
    Decimal_Places = 0;
    Disp_Str = '0';

  }

  calc_CLEAR_FUNC();

  Which_One = 0;
//  Call INPUT_NUMERIC;
  Struct_To_Str(t_str, cs);
  calc_struct_Str = t_str;
  CalcINPUTNUMERIC(False);
  t_str = calc_struct_str;
  Str_To_Struct(cs, t_str);

  if (Error_Flag) {
    Calc_Error();
    Return();
//    Goto ERROR;
  }

  cs.Entry = cs.T_Real;
  Last_Key_Type = 1;
//  Goto DISPLAY_AND_GET_KEY;
/*
make_message("cs.t_real=" + rstr(cs.t_real,0,0));
*/
  Struct_To_Str(t_str, cs);
  calc_struct_Str = t_str;

  CalcMakeDisplay();
  CalcWriteDisplay();

  Return();
}

void CalcMathOp() {
  int ctrl_id = parse_int("/CTRL=",mparm_str);
  struct calc_struct cs;
  str t_str[2048] = calc_struct_str;
  input_char = char(ctrl_id - 1000);
  Str_To_Struct(cs, t_str);
  Func_Str2 = parse_str("/FS=",mparm_str);
/*
make_message("[" + input_char + "][" + func_str2 + "]");
*/
MATH_OPERATION:
  cs.T_Real = cs.Entry;
//  Return_Str = Input_Char;
//      Call PUSH_TAPE;
  switch (ctrl_id) {
    case calc_and_ctrl :
      input_char = "A";
      break;
    case calc_or_ctrl :
      input_char = "O";
      break;
    case calc_Xor_ctrl :
      input_char = "X";
      break;
    case calc_Mod_ctrl :
      input_char = "M";
      break;
    case calc_Shl_ctrl :
      input_char = "L";
      break;
    case calc_Shr_ctrl :
      input_char = "R";
      break;
  }
  Calc_Push_Tape(input_char);

  if (Function_Pending) {
    cs.T_Real = cs.Accumulator;
//    Call DO_FUNCTION;
    Struct_To_Str(t_str, cs);
    calc_struct_Str = t_str;
    Calc_Do_Function();
    t_str = calc_struct_str;
    Str_To_Struct(cs, t_str);

    if (Error_Flag) {
      Calc_Error();
      Return();
//      Goto ERROR;
    }
    cs.Accumulator = cs.T_Real;

//    Call MAKE_DISPLAY;
//    Call WRITE_TO_DISPLAY;

    Struct_To_Str(t_str, cs);
    calc_struct_Str = t_str;
    CalcMakeDisplay();
    CalcWriteDisplay();
  } else {
    Function_Pending = True;
    cs.Accumulator = cs.Entry;
  }
  Which_One = 1;
  Decimal_Point = False;
  Decimal_Places = 0;
  Func_Str1 = Func_Str2;
  cs.Entry = 0.0;
  cs.T_Real = 0.0;
  calc_WRITE_FUNC();
  Last_Key_Type = 2;
//  Goto GET_KEY;
  Struct_To_Str(t_str, cs);
  calc_struct_Str = t_str;

}

void CalcDecimalPoint() {
  if ((Decimal_Point == False) | (Last_Key_Type == 3)) {
    Decimal_Point = True;
//    Goto NUMERIC_CHAR;
    RM("CalcNumChar /CTRL=" + str(Calc_Point_Ctrl));
  }
}

/*
void calc_show_mem_bt(int flag) trans2 {
  if (flag == SW_SHOW) {
    SetWindowText(calc_hdlg, "Memory");
  } else {
    SetWindowText(calc_hdlg, calc_title);
  }
  ShowWindow(GetDlgItem(calc_hdlg, Calc_Mem_In_Ctrl  ), flag);
  ShowWindow(GetDlgItem(calc_hdlg, Calc_Mem_Plus_Ctrl), flag);
  ShowWindow(GetDlgItem(calc_hdlg, Calc_Mem_Rec_Ctrl ), flag);
  ShowWindow(GetDlgItem(calc_hdlg, Calc_Mem_Exit_Ctrl), flag);
}
*/

void Calc_Memory(int ctrl_id = parse_int("/ID=",mparm_str)) {
  struct tmsg msg;
  int memory_done = false;

  struct calc_struct cs;
  str t_str[2048] = calc_struct_str;
  Str_To_Struct(cs, t_str);

  switch (ctrl_id) {
    case calc_mem_clear_ctrl :
      cs.Memory = 0.0;
      memory_done = true;
      SetFocus(GetDlgItem(calc_hdlg, Calc_Equals_ctrl));
      break;

    case calc_mem_in_ctrl :
      if(  (Which_One == 1)  ) {
        cs.Memory = cs.Accumulator;
      } else {
        cs.Memory = cs.Entry;
      }
      memory_done = true;
      break;

    case calc_mem_Plus_ctrl :
      if(  (Which_One == 1)  ) {
        cs.Memory = cs.Memory + cs.Accumulator;
      } else {
        cs.Memory = cs.Memory + cs.Entry;
      }
      memory_done = true;
      break;

    case calc_mem_Rec_ctrl :
      cs.Entry = cs.Memory;
      cs.T_Real = cs.Memory;
      Which_One = 0;
      Func_Str2 = '';
      calc_CLEAR_FUNC();
      memory_done = true;
      break;
  }

  Struct_To_Str(t_str, cs);
  calc_struct_Str = t_str;

  Calc_enable_btns(calc_mem_btns, (cs.memory != 0.0));

  CalcMakeDisplay();
  CalcWriteDisplay();

}

/*
void Calc_Memory() {
  struct tmsg msg;
  int memory_done = false;

  struct calc_struct cs;
  str t_str[2048] = calc_struct_str;
  Str_To_Struct(cs, t_str);

  Calc_enable_btns(calc_main_btns, false);
// hide the base button
  ShowWindow(GetDlgItem(calc_hdlg, calc_base_ctrl), SW_HIDE);
  //calc_show_mem_bt(SW_SHOW);
  //Calc_enable_btns(calc_mem_btns, true);

  while(getmessage( &msg, 0, 0, 0 ) && !memory_done )
	{
 //       make_message( str(getdefaultbutton( main_dlg )) + " " + hex_str( msg.message ) );
    if ( msg.message == WM_USER )
		{
      switch (msg.wparam) {
        case calc_mem_in_ctrl :
          if(  (Which_One == 1)  ) {
            cs.Memory = cs.Accumulator;
          } else {
            cs.Memory = cs.Entry;
          }
          memory_done = true;
          break;

        case calc_mem_Plus_ctrl :
          if(  (Which_One == 1)  ) {
            cs.Memory = cs.Memory + cs.Accumulator;
          } else {
            cs.Memory = cs.Memory + cs.Entry;
          }
          memory_done = true;
          break;

        case calc_mem_Rec_ctrl :
          cs.Entry = cs.Memory;
          cs.T_Real = cs.Memory;
          Which_One = 0;
          Func_Str2 = '';
          calc_CLEAR_FUNC();
          memory_done = true;
          break;
/*
        case calc_mem_exit_ctrl :
          memory_done = true;
          break;
*/
      }
		}
/*
    else if ((msg.message == WM_KEYDOWN) && (msg.wparam == VK_F1))
    {
      Call GET_HELP;
    }
*/
    else if( !IsDialogMessage( calc_hdlg, &msg) )
	 	{
        translatemessage( &msg );
        dispatchmessage( &msg );
	 	}
	}

// unhide the base button
//  Calc_enable_btns(calc_main_btns, true);
//  Calc_enable_btns(calc_mem_btns, false);
//  calc_show_mem_bt(SW_HIDE);
//  ShowWindow(GetDlgItem(calc_hdlg, calc_base_ctrl), SW_SHOW);

  Struct_To_Str(t_str, cs);
  calc_struct_Str = t_str;

  CalcMakeDisplay();
  CalcWriteDisplay();

//MEMORY_MENU:
//  Write('MEM:',Calc_X + 2,Calc_Y - 3,0,M_T_Color);
//  Set_Global_Str('MEMEV1','/T=MIn/KC=<ENTER>/W=10/K1=13/K2=28/R=13/Y=' +
//      Str(Calc_Y - 3) + '/X=' + Str(Calc_X + 7));
//  Set_Global_Str('MEMEV2','/T=M+/KC=<+>/W=5/K1=43/K2=78/R=43/Y=' +
//      Str(Calc_Y - 3) + '/X=' + Str(Calc_X + 18));
//  Set_Global_Str('MEMEV3','/T=MRec/KC=<R>/W=7/K1=82/K2=19/R=82/Y=' +
//      Str(Calc_Y - 3) + '/X=' + Str(Calc_X + 24));
//  Set_Global_Str('MEMEV4','/T=Exit/KC=<ESC>/W=9/K1=27/K2=1/R=27/Y=' +
//      Str(Calc_Y - 3) + '/X=' + Str(Calc_X + 32));
//  RM('USERIN^CHECKEVENTS /M=2/G=MEMEV/#=4');
//
//  Read_Key;
//  if(  ((Key1 == 0) & (key2 == 250))  ) {
//    RM('USERIN^CHECKEVENTS /M=1/G=MEMEV/#=4');
//    if(  (Return_Int)  ) {
//      Key1 = Parse_Int('/R=',Global_Str('MEMEV' + Str(Return_Int)));
//    } else {
//      Push_Key(Key1,Key2);
//      Goto MEMORY_EXIT;
//    }
//  }
//  if(  (Key1 == 27)  ) {
//    Goto MEMORY_EXIT;
//  }
//  if(  (Key1 == 13)  ) {
//    if(  (Which_One == 1)  ) {
//      Memory = Accumulator;
//    } else {
//      Memory = Entry;
//    }
//    Goto MEMORY_EXIT;
//  }
//  if(  (Key1 == 43)  ) {
//    if(  (Which_One == 1)  ) {
//      Memory = Memory + Accumulator;
//    } else {
//      Memory = Memory + Entry;
//    }
//    Goto MEMORY_EXIT;
//  }
//  if(  ((Key1 == 114) | (Key1 == 82))  ) {
//    Entry = Memory;
//    T_Real = Memory;
//    Which_One = 0;
//    Func_Str2 = '';
//    call CLEAR_FUNC_STR;
//    Goto MEMORY_EXIT;
//  }
//  Goto MEMORY_MENU;
//
//MEMORY_EXIT:
//  Write('<F7>',Calc_X + 7,Calc_Y - 3,0,M_B_Color);
//  RET;
}
*/

void calc_change_base(int t_base) {
/*
  if (Base == Bin) {
    Base = Oct;
  } else if (Base == Oct) {
    Base = Decimal;
  } else if (Base == Decimal) {
    Base = Hex;
  } else if (Base == Hex) {
    Base = Bin;
  }
*/

  base = t_base;

/*
  SetDlgItemText(Calc_Hdlg, calc_base_ctrl,
    calc_base_title + global_str("Calc_Base_Display" + str(base)));
*/
//      Goto DISPLAY_AND_GET_KEY;
  SendMessage(GetDlgItem(calc_hdlg, Calc_Bin_Ctrl), BM_SETCHECK, 0, 0);
  SendMessage(GetDlgItem(calc_hdlg, Calc_Oct_Ctrl), BM_SETCHECK, 0, 0);
  SendMessage(GetDlgItem(calc_hdlg, Calc_Dec_Ctrl), BM_SETCHECK, 0, 0);
  SendMessage(GetDlgItem(calc_hdlg, Calc_Hex_Ctrl), BM_SETCHECK, 0, 0);
  SendMessage(GetDlgItem(calc_hdlg, 1200 + base), BM_SETCHECK, 1, 0);
  Calc_Enable_Btns(Calc_main_Btns, true)
  CalcMakeDisplay();
  CalcWriteDisplay();
}

void Calc_Result() {
  struct calc_struct cs;
  str t_str[2048] = calc_struct_str;
  Str_To_Struct(cs, t_str);

      if (Func_Str2 != '') {
        calc_CLEAR_FUNC();
//        call CLEAR_FUNC_STR;
        cs.Entry = cs.Accumulator;
			}
			Which_One = 1;

//      Return_Str = '=';
//      Call PUSH_TAPE;
      calc_result_flag = false;
      calc_push_tape("=");

      if ((Func_Str1 != '') & (Function_Pending == True)) {
        cs.T_Real = cs.Accumulator;
				Function_Pending = False;

//        Call DO_FUNCTION;
        Struct_To_Str(t_str, cs);
        calc_struct_Str = t_str;
        Calc_Do_Function();
        t_str = calc_struct_str;
        Str_To_Struct(cs, t_str);

        if (Error_Flag) {
          Calc_Error();
          Return();
//          Goto ERROR;
				}
			} else {
        cs.T_Real = cs.Entry;
			}

      cs.Accumulator = cs.T_Real;
      cs.Entry = cs.T_Real;
      Struct_To_Str(t_str, cs);
      calc_struct_Str = t_str;
      CalcMakeDisplay();

      calc_Push_tape(" ");
//      calc_push_tape("");

      calc_result_flag = true;

			Func_Str2 = ' = ';
			Last_Key_Type = 3;
//      Goto DISPLAY_AND_GET_KEY;
      CalcWriteDisplay();

  Struct_To_Str(t_str, cs);
  calc_struct_Str = t_str;
}

int Calc_BTN_Proc( int &retval, int window, int message, int wparam, int lparam, str parms ) no_break {
/*
if (
(message != 0x2B) &&
(message != 0xC) &&
(message != 0xF) &&
(message != 0x20) &&
(message != 0x19) &&
true
)
{
  make_message(hex_str(message));
}
*/
  int result = 0,
      do_change_focus = 0;

  if (message == WM_KEYDOWN) {
    switch (wParam) {
      case vk_up :  // up arrow
      case vk_down :  // down arrow
      case vk_left :  // left arrow
      case vk_right :  // right arrow
        if (GetFocus != calc_tape_hdlg) {
          SetFocus(calc_tape_hdlg);
        }
      break;
    }
  } else {
    switch (message) {
      case WM_SYSCHAR :
      case WM_CHAR :
        if (GetFocus == calc_tape_hdlg) {
          if (wParam != VK_RETURN) {
            SetFocus(Calc_Equals_hdlg);
          }
        }
        break;
    }
  }


  switch (message) {
    case WM_GETDLGCODE :
          retval = DLGC_WANTCHARS | DLGC_WANTALLKEYS | DLGC_RADIOBUTTON;
//      retval = DLGC_WANTARROWS;
          result = 1;
          break;
/* This was moved to an IF statement above to accomodate focus issues
    case WM_KEYDOWN :
      switch (wParam) {
        case vk_up :  // up arrow
        case vk_down :  // down arrow
        case vk_left :  // left arrow
        case vk_right :  // right arrow
          SetFocus(calc_tape_hdlg);
        break;
      }

    break;
*/
    case WM_SYSCHAR :
      if (lparam & 0x20000000) { // check for alt
        switch (wParam) {

          case 49 : // alt 1. (alt !)
            Calc_Complement(1);
            Retval = 0;
            result = 1;
            break;
          case 60 : // alt <.
            RM("CalcMathOp /FS=Shl/CTRL=" + str(Calc_Shl_Ctrl));
            Retval = 0;
            result = 1;
            break;
          case 62 : // alt >.
            RM("CalcMathOp /FS=Shr/CTRL=" + str(Calc_Shr_Ctrl));
            Retval = 0;
            result = 1;
            break;
          case 98 : // alt b.
            Calc_Change_Base(2);
            Retval = 0;
            result = 1;
            break;
          case 99 : // alt c.
            Calc_Change_Base(10);
            Retval = 0;
            result = 1;
            break;

          case 100 : // alt d.
            RM("CalcMathOp /FS=Mod/CTRL=" + str(Calc_Mod_Ctrl));
            Retval = 0;
            result = 1;
            break;
          case 101 : // alt e.
            Calc_Clear_entry();
            Retval = 0;
            result = 1;
            break;
          case 104 : // alt h.
            Calc_Change_Base(16);
            Retval = 0;
            result = 1;
            break;
          case 105 : // alt i.
            Calc_Memory(Calc_mem_in_ctrl);
            Retval = 0;
            result = 1;
            break;
          case 108 : // alt l.
            calc_clear();
            Retval = 0;
            result = 1;
            break;
          case 109 : // alt m.
            Calc_Memory(Calc_mem_plus_ctrl);
            Retval = 0;
            result = 1;
            break;
          case 110 : // alt n.
            RM("CalcMathOp /FS=And/CTRL=" + str(Calc_And_Ctrl));
            Retval = 0;
            result = 1;
            break;
          case 111 : // alt o.
            RM("CalcMathOp /FS=Or /CTRL=" + str(Calc_Or_Ctrl));
            Retval = 0;
            result = 1;
            break;
/*
          case 112 : // alt p.
            SendMessage(calc_hdlg,WM_COMMAND,calc_paste_ctrl ,0);
            Retval = 0;
            result = 1;
            break;
*/
          case 114 : // alt r.
            Calc_Memory(Calc_mem_rec_ctrl);
            Retval = 0;
            result = 1;
            break;
          case 115 : // alt s.
            SendMessage(calc_hdlg,WM_COMMAND,calc_paste_ctrl ,0);
            Retval = 0;
            result = 1;
            break;
          case 116 : // alt t.
            calc_Change_Base(8);
            Retval = 0;
            result = 1;
            break;
          case 120 : // alt x.
            RM("CalcMathOp /FS=Xor/CTRL=" + str(Calc_Xor_Ctrl));
            Retval = 0;
            result = 1;
            break;
        }
      }
      break;
    case WM_CHAR :
    {
      str t_str[1] = "";
      switch (wParam) {
        case 33 :
          Calc_Complement(1);
          retval = 0;
          result = 1;
          break;
        case 60 : // <.
          RM("CalcMathOp /FS=Shl/CTRL=" + str(Calc_Shl_Ctrl));
          Retval = 0;
          result = 1;
          break;
        case 62 : // >.
          RM("CalcMathOp /FS=Shr/CTRL=" + str(Calc_Shr_Ctrl));
          Retval = 0;
          result = 1;
          break;
        case 13 :
        case 61 :
          if (GetFocus() == Calc_Tape_Hdlg) {
            calc_tape_select();
          } else {
            calc_result();
          }
          break;
        case VK_BACK : // backspace
          RM("CalcNumChar /CTRL=" + str(1000 + wparam));
          retval = 0;
          result = 1;
          break;
        case 48 : // 0
        case 49 : // 1
        case 50 : // 2
        case 51 : // 3
        case 52 : // 4
        case 53 : // 5
        case 54 : // 6
        case 55 : // 7
        case 56 : // 8
        case 57 : // 9
        case 97 : // a
        case 98 : // b
        case 99 : // c
        case 100 : // d
        case 101 : // e
        case 102 : // f
          RM("CalcNumChar /CTRL=" + str(1000 + wparam));
          retval = 0;
          result = 1;
          break;
        case 47 : // /
          t_str = "/"; // takes care of imbedded slash
        case 42 : // *
        case 43 : // +
        case 45 : // -
          RM("CalcMathOp /FS= " + char(wparam) + t_str + " /CTRL=" + str(1000 + wparam));
          retval = 0;
          result = 1;
          break;
        case 46 : // .
          RM("CalcDecimalPoint /CTRL=" + str(Calc_Point_Ctrl));
          retval = 0;
          result = 1;
          break;
        case 105 : // i.
          Calc_Memory(Calc_mem_in_ctrl);
          Retval = 0;
          result = 1;
          break;
        case 108 : // l.
          calc_clear();
          Retval = 0;
          result = 1;
          break;
        case 109 : // m.
          Calc_Memory(Calc_mem_plus_ctrl);
          Retval = 0;
          result = 1;
          break;
        case 110 : // n
          RM("CalcMathOp /FS=And/CTRL=" + str(Calc_And_Ctrl));
          retval = 0;
          result = 1;
          break;
        case 111 : // o
          RM("CalcMathOp /FS=Or /CTRL=" + str(Calc_Or_Ctrl));
          retval = 0;
          result = 1;
          break;
        case 112 : // p
          SendMessage(calc_hdlg,WM_COMMAND,calc_paste_ctrl ,0);
          retval = 0;
          result = 1;
          break;
        case 114 : // r.
          Calc_Memory(Calc_mem_rec_ctrl);
          Retval = 0;
          result = 1;
          break;
        case 116 : // t.
          calc_clear_tape();
          Retval = 0;
          result = 1;
          break;
        case 120 : // x
          RM("CalcMathOp /FS=Xor/CTRL=" + str(Calc_Xor_ctrl));
          retval = 0;
          result = 1;
          break;
      }
      break;
    }

    case WM_COMMAND :
         switch (wparam) {

          case CALC_TAPE_CTRL2 :
            if (((lparam >> 16) & 0xFFFF) == LBN_DBLCLK) {
              calc_tape_select();
              retval = 0;
              result = 1;
            }
            break;

         }
  }


  return(Result);
}

int CalcMsgProc( int &retval, int window, int message, int wparam, int lparam, str parms ) no_break {
/*
if (
(message != 0x2B) &&
(message != 0xC) &&
(message != 0xF) &&
(message != 0x20) &&
(message != 0x19) &&
true
)
{
  make_message(hex_str(message));
}
*/
  switch (message) {

      case WM_CTLCOLOR :
        int dc = wParam,
            hwnd = lparam & 0xFFFF;

        if ((hwnd == calc_display_hdlg) || (hwnd == calc_function_hdlg)) {
          Retval = 0;
          Return(GetStockObject(WHITE_BRUSH));
        }

        break;

    case WM_DESTROY :
      if(Calc_font) {
        DeleteObject(Calc_font);

      }
	    retval = 0;
      if (calc_modeless) {
//        DlgKill(Calc_dlg);
        Calc_dlg = 0;
      }

      struct calc_struct cs;
      str t_str[2048] = calc_struct_str;
      Str_To_Struct(cs, t_str);
      Set_Global_Str('Calc_Params',
//          '/X=' + Str(Calc_X) +
//          '/Y=' + Str(Calc_Y) +
        '/WO=' + Str(Which_One) +
        '/LK=' + Str(Last_Key_Type) +
        '/BASE=' + Str(Base) +
        '/DPL=' + Str(Decimal_Places) +
        '/DPO=' + Str(Decimal_Point) +
        '/FS1=' + Func_Str1 +
        '/FS2=' + Func_Str2 +
        '/FP=' + Str(Function_Pending) +
        '/MEM=' + RStr(cs.Memory,10,10) +
        '/ACC=' + RStr(cs.Accumulator,10,10) +
        '/ENT=' + RStr(cs.Entry,10,10)
      );
/*
beep;
make_message(rstr(cs.accumulator,10,10) + " " + rstr(cs.entry,10,10));
read_key;
*/


// deallocate globals
//      Calc_Active_Window    = 0;  !!!! DON'T DEALLOCATE THIS ONE HERE
      Calc_hdlg             = 0;
      Calc_display_hdlg     = 0;
      Calc_function_hdlg    = 0;
      Calc_disp_frame_hdlg  = 0;
      Calc_equals_hdlg  = 0;
      Calc_Tape_Window      = 0;
      Calc_Tape_hdlg        = 0;
//      Calc_Tape_hdlg2       = 0;
//      Calc_dlg              = 0;  !!!! DON'T DEALLOCATE THIS ONE HERE
      Calc_font             = 0;
      Disp_Str              = "";
      Func_Str1             = "";
      Func_Str2             = "";
      calc_struct_str       = "";
      last_key_type         = 0;
      decimal_point         = 0;
      decimal_places        = 0;
      which_one             = 0;
      base                  = 0;
      shift_places          = 0;
      input_char            = "";
      error_flag            = 0;
      function_pending      = 0;
			break;
    case WM_COMMAND :

         switch (wparam) {

          case CALC_EQUALS_CTRL :
            if (getfocus() == calc_tape_hdlg) {
              calc_tape_select();
              retval = 1;
              return(retval);
            }
            break;
          case CALC_TAPE_CTRL2 :
            if (((lparam >> 16) & 0xFFFF) == LBN_DBLCLK) {
              calc_tape_select();
            }
            break;

          case CALC_BIN_CTRL :
          case CALC_OCT_CTRL :
          case CALC_DEC_CTRL :
          case CALC_HEX_CTRL :
            Calc_Change_Base(wparam - 1200);
            retval = 1;
            Return(0);
            break;

				  case DLG_WCMD_INIT :
            calc_hdlg = window;
            Calc_Display_hdlg = GetDlgItem(window, calc_display_ctrl);
            Calc_Equals_hdlg = GetDlgItem(window, calc_Equals_ctrl);
            Calc_Function_hdlg = GetDlgItem(window, calc_function_ctrl);
            Calc_disp_frame_hdlg = GetDlgItem(window, calc_disp_frame_ctrl);
            if (calc_tape_off) {
              Calc_Tape_Hdlg = 0;
            } else {
              Calc_Tape_hdlg = GetDlgItem(window, calc_tape_ctrl);
              SetFocus(calc_tape_hdlg);
// this gets around the problem of the list box "phantom" control
              calc_tape_hdlg = GetFocus();
              Subclass_With_Macro(GetDlgItem(window, Calc_ClrTape_Ctrl   ), "Calc_BTN_Proc", "/ID=" + str(Calc_ClrTape_Ctrl   ));
//EnableWindow(GetDlgItem(calc_hdlg, Calc_ClrTape_Ctrl   ), false)
            }
            Subclass_With_Macro(Calc_Tape_hdlg  , "Calc_BTN_Proc", "/ID=" + str(Calc_Tape_Ctrl   ));
//            Subclass_With_Macro(Calc_Tape_hdlg2 , "Calc_BTN_Proc", "/ID=" + str(Calc_Tape_Ctrl2  ));

            Subclass_With_Macro(GetDlgItem(window, Calc_Display_Ctrl   ), "Calc_BTN_Proc", "/ID=" + str(Calc_Display_Ctrl   ));
            Subclass_With_Macro(GetDlgItem(window, Calc_Paste_Ctrl     ), "Calc_BTN_Proc", "/ID=" + str(Calc_Paste_Ctrl     ));
            Subclass_With_Macro(GetDlgItem(window, Calc_Help_Ctrl      ), "Calc_BTN_Proc", "/ID=" + str(Calc_Help_Ctrl      ));
//            Subclass_With_Macro(GetDlgItem(window, Calc_ClrTape_Ctrl   ), "Calc_BTN_Proc", "/ID=" + str(Calc_ClrTape_Ctrl   ));
            Subclass_With_Macro(GetDlgItem(window, Calc_And_Ctrl       ), "Calc_BTN_Proc", "/ID=" + str(Calc_And_Ctrl       ));
            Subclass_With_Macro(GetDlgItem(window, Calc_Or_Ctrl        ), "Calc_BTN_Proc", "/ID=" + str(Calc_Or_Ctrl        ));
            Subclass_With_Macro(GetDlgItem(window, Calc_Xor_Ctrl       ), "Calc_BTN_Proc", "/ID=" + str(Calc_Xor_Ctrl       ));
            Subclass_With_Macro(GetDlgItem(window, Calc_Mod_Ctrl       ), "Calc_BTN_Proc", "/ID=" + str(Calc_Mod_Ctrl       ));
            Subclass_With_Macro(GetDlgItem(window, Calc_Not_Ctrl       ), "Calc_BTN_Proc", "/ID=" + str(Calc_Not_Ctrl       ));
            Subclass_With_Macro(GetDlgItem(window, Calc_Shl_Ctrl       ), "Calc_BTN_Proc", "/ID=" + str(Calc_Shl_Ctrl       ));
            Subclass_With_Macro(GetDlgItem(window, Calc_Shr_Ctrl       ), "Calc_BTN_Proc", "/ID=" + str(Calc_Shr_Ctrl       ));
            Subclass_With_Macro(GetDlgItem(window, Calc_A_Ctrl         ), "Calc_BTN_Proc", "/ID=" + str(Calc_A_Ctrl         ));
            Subclass_With_Macro(GetDlgItem(window, Calc_B_Ctrl         ), "Calc_BTN_Proc", "/ID=" + str(Calc_B_Ctrl         ));
            Subclass_With_Macro(GetDlgItem(window, Calc_C_Ctrl         ), "Calc_BTN_Proc", "/ID=" + str(Calc_C_Ctrl         ));
            Subclass_With_Macro(GetDlgItem(window, Calc_D_Ctrl         ), "Calc_BTN_Proc", "/ID=" + str(Calc_D_Ctrl         ));
            Subclass_With_Macro(GetDlgItem(window, Calc_E_Ctrl         ), "Calc_BTN_Proc", "/ID=" + str(Calc_E_Ctrl         ));
            Subclass_With_Macro(GetDlgItem(window, Calc_F_Ctrl         ), "Calc_BTN_Proc", "/ID=" + str(Calc_F_Ctrl         ));
            Subclass_With_Macro(GetDlgItem(window, Calc_0_Ctrl         ), "Calc_BTN_Proc", "/ID=" + str(Calc_0_Ctrl         ));
            Subclass_With_Macro(GetDlgItem(window, Calc_1_Ctrl         ), "Calc_BTN_Proc", "/ID=" + str(Calc_1_Ctrl         ));
            Subclass_With_Macro(GetDlgItem(window, Calc_2_Ctrl         ), "Calc_BTN_Proc", "/ID=" + str(Calc_2_Ctrl         ));
            Subclass_With_Macro(GetDlgItem(window, Calc_3_Ctrl         ), "Calc_BTN_Proc", "/ID=" + str(Calc_3_Ctrl         ));
            Subclass_With_Macro(GetDlgItem(window, Calc_4_Ctrl         ), "Calc_BTN_Proc", "/ID=" + str(Calc_4_Ctrl         ));
            Subclass_With_Macro(GetDlgItem(window, Calc_5_Ctrl         ), "Calc_BTN_Proc", "/ID=" + str(Calc_5_Ctrl         ));
            Subclass_With_Macro(GetDlgItem(window, Calc_6_Ctrl         ), "Calc_BTN_Proc", "/ID=" + str(Calc_6_Ctrl         ));
            Subclass_With_Macro(GetDlgItem(window, Calc_7_Ctrl         ), "Calc_BTN_Proc", "/ID=" + str(Calc_7_Ctrl         ));
            Subclass_With_Macro(GetDlgItem(window, Calc_8_Ctrl         ), "Calc_BTN_Proc", "/ID=" + str(Calc_8_Ctrl         ));
            Subclass_With_Macro(GetDlgItem(window, Calc_9_Ctrl         ), "Calc_BTN_Proc", "/ID=" + str(Calc_9_Ctrl         ));
            Subclass_With_Macro(GetDlgItem(window, Calc_add_Ctrl       ), "Calc_BTN_Proc", "/ID=" + str(Calc_add_Ctrl       ));
            Subclass_With_Macro(GetDlgItem(window, Calc_subtract_Ctrl  ), "Calc_BTN_Proc", "/ID=" + str(Calc_subtract_Ctrl  ));
            Subclass_With_Macro(GetDlgItem(window, Calc_Multiply_Ctrl  ), "Calc_BTN_Proc", "/ID=" + str(Calc_Multiply_Ctrl  ));
            Subclass_With_Macro(GetDlgItem(window, Calc_Divide_Ctrl    ), "Calc_BTN_Proc", "/ID=" + str(Calc_Divide_Ctrl    ));
            Subclass_With_Macro(GetDlgItem(window, Calc_Equals_Ctrl    ), "Calc_BTN_Proc", "/ID=" + str(Calc_Equals_Ctrl    ));
            Subclass_With_Macro(GetDlgItem(window, Calc_CE_Ctrl        ), "Calc_BTN_Proc", "/ID=" + str(Calc_CE_Ctrl        ));
            Subclass_With_Macro(GetDlgItem(window, Calc_PlusMinus_Ctrl ), "Calc_BTN_Proc", "/ID=" + str(Calc_PlusMinus_Ctrl ));
            Subclass_With_Macro(GetDlgItem(window, Calc_Point_Ctrl     ), "Calc_BTN_Proc", "/ID=" + str(Calc_Point_Ctrl     ));
            Subclass_With_Macro(GetDlgItem(window, Calc_Clear_Ctrl     ), "Calc_BTN_Proc", "/ID=" + str(Calc_Clear_Ctrl     ));
            Subclass_With_Macro(GetDlgItem(window, Calc_Close_Ctrl     ), "Calc_BTN_Proc", "/ID=" + str(Calc_Close_Ctrl     ));
//            Subclass_With_Macro(GetDlgItem(window, Calc_Base_Ctrl      ), "Calc_BTN_Proc", "/ID=" + str(Calc_Base_Ctrl      ));
//            Subclass_With_Macro(GetDlgItem(window, Calc_Base_t_Ctrl    ), "Calc_BTN_Proc", "/ID=" + str(Calc_Base_t_Ctrl    ));

            Subclass_With_Macro(GetDlgItem(window, Calc_Bin_Ctrl      ), "Calc_BTN_Proc", "/ID=" + str(Calc_Bin_Ctrl      ));
            Subclass_With_Macro(GetDlgItem(window, Calc_Oct_Ctrl      ), "Calc_BTN_Proc", "/ID=" + str(Calc_Oct_Ctrl      ));
            Subclass_With_Macro(GetDlgItem(window, Calc_Dec_Ctrl      ), "Calc_BTN_Proc", "/ID=" + str(Calc_Dec_Ctrl      ));
            Subclass_With_Macro(GetDlgItem(window, Calc_Hex_Ctrl      ), "Calc_BTN_Proc", "/ID=" + str(Calc_Hex_Ctrl      ));

            Subclass_With_Macro(GetDlgItem(window, Calc_Function_Ctrl  ), "Calc_BTN_Proc", "/ID=" + str(Calc_Function_Ctrl  ));
            Subclass_With_Macro(GetDlgItem(window, Calc_Disp_Frame_Ctrl), "Calc_BTN_Proc", "/ID=" + str(Calc_Disp_Frame_Ctrl));
            if (!calc_tape_off) {
              Subclass_With_Macro(GetDlgItem(window, Calc_Tape_Ctrl      ), "Calc_BTN_Proc", "/ID=" + str(Calc_Tape_Ctrl      ));
            }
            Subclass_With_Macro(GetDlgItem(window, Calc_Mem_In_Ctrl    ), "Calc_BTN_Proc", "/ID=" + str(Calc_Mem_In_Ctrl    ));
            Subclass_With_Macro(GetDlgItem(window, Calc_Mem_Plus_Ctrl  ), "Calc_BTN_Proc", "/ID=" + str(Calc_Mem_Plus_Ctrl  ));
            Subclass_With_Macro(GetDlgItem(window, Calc_Mem_Rec_Ctrl   ), "Calc_BTN_Proc", "/ID=" + str(Calc_Mem_Rec_Ctrl   ));

            Subclass_With_Macro(GetDlgItem(window, Calc_Config_Ctrl   ), "Calc_BTN_Proc", "/ID=" + str(Calc_Config_Ctrl   ));

            SendDlgItemMessage(window, Calc_display_ctrl, WM_SETFONT, Calc_Font, 1);
            SendDlgItemMessage(window, Calc_function_ctrl, WM_SETFONT, Calc_Font, 1);
//            SendDlgItemMessage(window, Calc_mem_stat_ctrl, WM_SETFONT, Calc_Font, 1);


//            SetWindowText(GetDlgItem(window, calc_mem_Stat_ctrl),"M");
//            ShowWindow(GetDlgItem(window, Calc_Function_ctrl), SW_HIDE);
//            calc_show_mem_bt(SW_HIDE);
            CalcMakeDisplay();
            CalcWriteDisplay();
            Calc_enable_btns(calc_main_btns, true);
//            Calc_enable_btns(calc_mem_btns, (cs.memory != 0.0));
            Calc_Memory(0);
						break;

          case calc_paste_ctrl :
          case calc_close_ctrl :
            int t_win_id = window_id,
                t_int;
/*
beep;
make_message(str(length(calc_struct_str)));
read_key;
*/
            if (!calc_tape_off) {
              if (switch_win_id(calc_tape_window)) {
                eof;
                if (c_col > 1) {
                  down;
                }
                goto_col(1);
                t_int = 0;
                while (c_line > 1) {
                  up;
                  if (cur_char != '|0') {
                    ++t_int;
                    Set_Global_Str("Calc_Tape" + Str(t_int),get_line);
                  }
                }
                delete_window;
              }
            }


            if (!Calc_Modeless) {
              t_win_id = Calc_Active_window;
						}
            Calc_Active_Window = 0;  // deallocate the global

						switch_win_id(t_win_id);
            if (wparam == calc_Paste_ctrl) {
              text(remove_space(disp_str));
            }
//          case calc_close_ctrl :
            if (Calc_Modeless) {
            	DestroyWindow( window );
              return (1);
            }
         }
  }
  return(DlgMessageProc(retval, window,message,wparam,lparam, parms ));
}

void CALC_SETUP() {
  int calc_was_running = 0,
      unsigned_style = 0;

// exit calculator if we were in it
  if (calc_hdlg) {
     SendMessage(calc_hdlg, WM_COMMAND, calc_close_ctrl, 0);
     calc_was_running = 1;
  }
  int dlg;
  DlgCreate(dlg);

  DlgAddCtrl(dlg, DLG_Static, "Word Length:",
            1,
            1,
            0,
            0,
            1001,
            0,"");

  DlgAddCtrl( dlg, DLG_RadioButton,
              "&8",
              Dlg_PosOffset | 1,
              Dlg_PosOffset | 1,
              0,
              0,
              1002,
              0,
              "");
  DlgSetInt(dlg, 1002, (Word_Length == 8));

  DlgAddCtrl( dlg, DLG_RadioButton,
              "&16",
              Dlg_PosOffset | 7,
              Dlg_PosOffset,
              0,
              0,
              1003,
              0,
              "");
  DlgSetInt(dlg, 1003, (Word_Length == 16));

  DlgAddCtrl( dlg, DLG_RadioButton,
              "&32",
              Dlg_PosOffset | 7,
              Dlg_PosOffset,
              0,
              0,
              1004,
              0,
              "");
  DlgSetInt(dlg, 1004, !(DlgGetInt(dlg, 1002) | DlgGetInt(dlg, 1003)));


  DlgAddCtrl( dlg, DLG_CheckBox,
              '&Enable tape',
              DLG_PosOffset | 13,
              DLG_NegOffset | 1,
              0,
              0,
              1010,
              0,
              "");
  DlgSetInt(dlg, 1010, !Calc_tape_off);

  if (DlgGetInt(dlg, 1004)) {
    unsigned_style = DLGF_DISABLE;
  }
  DlgAddCtrl( dlg, DLG_CheckBox,
              '&Unsigned',
              DLG_PosOffset,
              DLG_PosOffset | 1,
              0,
              0,
              1011,
              unsigned_style,
              "");
  DlgSetInt(dlg, 1011, Calc_Unsigned);


  DlgAddCtrl( dlg, DLG_PushButton, "Ok",
              1,
              Dlg_PosOffset | 2,
              DLG_StanBtnWidth,0,
              2001,0,"/R=1");

  DlgAddCtrl( dlg, DLG_PushButton, "Close",
              Dlg_PosOffset + Dlg_StanBtnWidth + 2,
              Dlg_PosOffset,
              DLG_StanBtnWidth,0,
              2002,0,"/R=0");

  DlgAddCtrl( dlg, DLG_PushButton, "Help",
              Dlg_PosOffset + Dlg_StanBtnWidth + 4,
              Dlg_PosOffset,DLG_StanBtnWidth, 0,
              2003,0,"/R=2");

  if (DlgExecute(dlg, 2001, "Calculator Setup", calc_help_link,"/LOOPMAC=CALC_SET_LOOPMAC",0)) {

    if (DlgGetInt(dlg, 1002)) {
      Word_Length = 8;
    } else if (DlgGetInt(dlg, 1003)) {
      Word_Length = 16;
    } else {
      Word_Length = 32;
    }

    Calc_Tape_Off = !DlgGetInt(dlg, 1010);
    Set_Global_Int( "SETUP_CHANGED", Global_Int( "SETUP_CHANGED" ) | 0x01 );

  }
  if (Calc_was_running) {
// restart calculator if already on
    Calc();
  }
}

int calc_set_loopmac() {
  int hdlg = parse_int("/HDLG=",Mparm_Str); // the WINDOWS handle of the main dialog

  EnableWindow(GetDlgItem(hdlg, 1011), !IsDlgButtonChecked(hdlg, 1004));
  RETURN(0);
}