From stillson@mitre.org Mon May 23 20:02:31 PDT 1994
Article: 330 of comp.home.automation
Xref: conexch comp.home.automation:330
Path: conexch!wilbur!vax.cerritos.edu!news.Cerritos.edu!nic-nac.CSU.net!usc!sol.ctr.columbia.edu!news.kei.com!eff!blanket.mitre.org!linus.mitre.org!newsflash.mitre.org!sparcle!stillson
Newsgroups: comp.home.automation
Subject: Here's some PD x-10 source code...
Message-ID: <stillson.769721350@sparcle>
From: stillson@mitre.org (Ken Stillson)
Date: 23 May 94 19:29:10 GMT
Organization: The MITRE Corporation
NNTP-Posting-Host: sparcle.mitre.org
Lines: 399

  A present for you..  I wrote those really small and simple programs a few
  years ago when I had a working x-10 to IBM PC interface.  The source is
  in 8086 assmebler.  I compiled it with "A86" (a shareware assembler), but
  I believe it is compatible with MASM.

  I can't offer any guarantee or support- but I hereby submit the code to
  the public domain; do with it what you wish.

	- Ken Stillson, stillson@mitre.org

  ------------------------------------------------------------  

  There are two programs, both send simple X10 commands.  The first takes
  it instructions from the command line.  The second is a simple TSR that
  uses a "hot-key".  Enjoy!

**********************************************************************
Program 1: x10.asm
**********************************************************************


	Page 63,132
	Title	Send direct X10 commands - by Ken Stillson

; ---- strt area ----------------------------------------------------------

Code		segment	para public	'CODE'
		Org	100h

		Assume cs:code,ds:code

Start:		Jmp program

; ---- data area ----------------------------------------------------------

Default		equ	070h	; default house code code
PortReady	equ	03fdh	; port number for com port status
IOData		equ	03f8h	; port to send com port data to/from

Dat_bffr	Db	16 dup (0ffh)	; synch signals
		Db	01h		; direct send command
Lvl_fnct	Db	0		; level & function
H_Code		Db	0		; housecode
		Db	0		; high units not allowed
Units		Db	0		; low units list
Checksum	Db	0		; checksum of Lvl_fnct -> Units

Table		Db	060h,0e0h,020h,0a0h	; housecode lookup table
		Db	010h,090h,050h,0d0h
		Db	070h,0f0h,030h,0b0h
		Db	000h,080h,040h,0c0h

Message		db	'X10 direct command sender program.',13,10
		Db	'Usage:  X10 {brightness} {unit list} [/{housecode}]',13,10
		Db	'                                         ^ housecode letter to send (opt)',13,10
		Db	'                             ^ simply list of 1 digit units to do to',13,10
		Db	'                ^ - for off, + for on, 0 for bright -> F for dim',13,10,'$'
;

Card		equ	00h

; ---- code area ----------------------------------------------------------

Program:	push	ds		; standard init routine
		Sub	ax,ax
		Push	ax
		Push	cs		; move cs -> ds
		Pop	ds

; check for no paramiters, if so, tell user they're a fool.

		Mov	al,cs:080h
		Cmp	al,03
		Jg	step1	; cont if okay

		Lea	dx,message
		Mov	ah,09h
		Int	21h
		Jmp	finish

; extract paramiter #1: command (/level)

Step1:		Mov	al,cs:082h	; taken from psp
		Cmp	al,'-'		; off command?
		Je	off
		Cmp	al,'+'		; on command?
		Je	on
					; else, dim command
		Cmp	al,'A'		; a hex digit?
		Jl	normal
					; else, a hexadecimal digit
		Sub	al,7		; change to relative number string
Normal:		sub	al,'0'		; $ -> #
		Mov	cl,04		; shift left 4 bits for command
		Shl	al,cl
		Add	al,0101b	; add in DIM command
		Mov	Lvl_fnct,al	; store into send buffer
		Jmp	Step2		; done with this...

Off:		Mov	al,00000011b	; off command
		Mov	Lvl_fnct,al	; store into send buffer
		Jmp	Step2		; done with this...

On:		Mov	al,00000010b	; on command
		Mov	Lvl_fnct,al	; store into send buffer

; extract paramiter #2: unit list

Step2:		Mov	bl,1 		; start scanning for unit #1
		Mov	al,'1'		; string form of bl
		Push	cs		; cs -> es for source segment
		Pop	es
		Cld			; scan forward

Scanloop:	Mov	di,0084h	; offset of unit list
		Mov	cx,8		; max len of paramiter unit list
		Repne	Scasb		; scan while not equal to al
		Je	yes		; found
Cont:		inc	bl		; next unit
		Inc	al		; and it's scan string
		Cmp	bl,9		; last unit yet?
		Jl	scanloop	; repeat until done.
		Jmp	step3		; finished scanning

Yes:		mov	cl,8
		Sub	cl,bl		; shift left this many bits
		Mov	dl,00000001b	; start with a 1
		Shl	dl,cl
		Or	Units,dl	; merge in found unit code.
		Jmp	Cont		; do next scan

; extract paramiter 3: optional house code.

Step3:		mov	cx,10h		; scan 10 bytes from unit list
		Mov	al,'/'		; look for indicator
		Mov	ah,default	; load default
		Mov	di,083h		; begin of possible params
		Repne	Scasb
		Jne	Cont3
					; else, must do lookup table
		Mov	bx,di
		Mov	bl,cs:0[bx]	; load housecode byte
		And	bl,11011111b	; elimintate lowercase
		Sub	bl,'A'		; lower to offset value
		Cmp	bl,16		; check for out of range
		Jge	Cont3
		Mov	bh,0		; eliminate bh for bx
		Mov	ah,table[bx]	; do lookup table

Cont3:		mov	H_code,ah	; save housecode.

; compute check-sum:

		Mov	al,Lvl_fnct
		Add	al,H_Code
		Add	al,Units
		Mov	Checksum,al	; save check sum

; and finally, send the x10 command to the asynch channel via INT 14h:
	; initialize asynch port for x10 commands:
		Mov	dx,card		; Rs232 port 1
		Mov	ax,01100011b	; 600-8-n-1, ah=0 => open command
		Int	14h		; do init command

	; send the command:
		Mov	cx,22		; len of command (bytes)
		Mov	bx,0		; offset from Dat_bffr
Sendloop:	; wait for port to signal it's ready:
Waitloop:	Mov	dx,PortReady	; get port addr
		In	al,dx		; get port stat value
		And	al,32d		; clear to send?
		Je	Waitloop	; wait until ok.

	; send the next byte:
		Mov	ah,01		; INT send byte command
		Mov	al,Dat_bffr[bx] ; load data to send
		Mov	dx,IoData	; use com1:
		Out	dx,al

		Inc	bx		; inc offset ptr
		Loop	sendloop

Finish:		mov	ah,0		; program term command
		Int	21h		; all done!

code		ends
		end	start



**********************************************************************
Program 2: x10tsr.asm
**********************************************************************

 	Page 63,132
 	Title	Send direct X10 commands from TSR - by Ken Stillson

; how to run:

; TSR activiatoin key (to be set upon re-compilation with PD utility LDRES)
; is used to enter program, then hit command:
;    + for on,   -  for off,  of a number 1-8 for bright/dim-ness

; then hit list of modules on number pad.  Hit enter when done.

; house code is hardcoded at I.  Must re-assemble this source to change.
;   ( see Default equ below)..

; ---- strt area ----------------------------------------------------------

Code	 	segment	para public	'CODE'
 	 	Org	100h

 	 	Assume cs:code,ds:code

Start:	 	Jmp program

; ---- data area ----------------------------------------------------------

Default	 	equ	070h	; default house code code
PortReady	equ	03fdh	; port number for com port status
IOData	 	equ	03f8h	; port to send com port data to/from
Card	 	equ	0h	; card number 0 - ie: COM1. Cannot be changed.
Beep1		equ	080h	; initial beep
Beep2		equ	060h	; command ack
Beep3		equ	040h	; unit ack
Beep4		equ	020h	; command complete ack

Dat_bffr	Db	16 dup (0ffh)	; synch signals
 	 	Db	01h	 	; direct send command
Lvl_fnct	Db	0	 	; level & function
H_Code	 	Db	Default	 	; housecode
 	 	Db	0	 	; high units not allowed
Units	 	Db	0	 	; low units list
Checksum	Db	0	 	; checksum of Lvl_fnct -> Units

; ---- code area ----------------------------------------------------------

Program:	cli		; turn off interupts
		push	cs	; ds:=cs
 	 	Pop	ds

 	; speaker init:
 	 	In	al,061h	 	; init port 
		Push	ax
 	 	Or	al,3	 	; on sprk & chan 2
		Out	061h,al

 	 	Mov	al,0b6h	 	; set timer chan 2
 	 	Out	43h,al

; at this point, program has been activated:
;	so beep to tell user that TSR is active, and wait for command key

		Mov	al,beep1
 	 	Call beep

InCmnd:	 	call	GetKey		; returns Al ASCII code

 	 	Cmp	al,'+'
 	 	Je	on
 	 	Cmp	al,'-'
 	 	Je	off	 	; if not, must be a dim command
 	 	Cmp	al,'1'	 	; if too low, keystroke invalid.
 	 	Jl	InCmnd
 	 	Cmp	al,'8'	 	; if too high, "
 	 	Jg	InCmnd

; interprite command:
 	 	Sub	al,'1'	 	; turn into hex offset
 	 	Mov	cl,05	 	; shift left 5 bits:
 	 	 	 	 	; 1 for mult level by two
 	 	Shl	al,cl	 	; 4 for addition of dim command
 	 	Add	al,0101b	; add in DIM command
 	 	Mov	Lvl_fnct,al	; store into send buffer
 	 	Jmp	short Step2	; done with this...

Off:	 	Mov	al,00000011b	; off command
 	 	Mov	Lvl_fnct,al	; store into send buffer
 	 	Jmp	short Step2	; done with this...

On:	 	Mov	al,00000010b	; on command
 	 	Mov	Lvl_fnct,al	; store into send buffer


; now beel for Ack, and wait for list of units, terminated by ENTER.

Step2: 	 	mov	al,beep2
		Call 	beep

UnitLoop:	Call	GetKey		; return AL ASCII

 	 	Cmp	al,13d	 	; return char?
 	 	Je	DoneUnits	; if so, exit input routine.

 	 	Sub	al,'0'	 	; turn into hex offset
 	 	Jle	UnitLoop	; <0 => invalid keystroke
 	 	Cmp	al,9
 	 	Jg	Unitloop	; >9 => "

 	; otherwise, unit code is valid, so encode into command list:

	   ; beep to ack valid keystroke:
		Push	ax		; save keystroke
		Mov	al,beep3	; beep pitch
		Call	beep
		Pop	ax		; restore keystoke

	; add in this unit:
 	 	mov	cl,8
 	 	Sub	cl,al	 	; shift left this many bits
 	 	Mov	al,00000001b	; start with a 1
 	 	Shl	al,cl
 	 	Or	Units,al	; merge in found unit code.
 	 	Jmp	short unitloop	; repeat process.

; now compute checksum, and send the command:

DoneUnits:
		; beep to ack completetion of commands:
		Mov	al,beep4
		Call	beep

; compute check-sum:
 	 	Mov	al,Lvl_fnct
 	 	Add	al,H_Code
 	 	Add	al,Units
 	 	Mov	Checksum,al	; save check sum

; and finally, send the x10 command to the asynch channel via INT 14h:

 	; initialize asynch port for x10 commands:
 	 	Mov	dx,card	 	; Rs232 port 1
 	 	Mov	ax,01100011b	; 600-8-n-1, ah=0 => open command
 	 	Int	14h	 	; do init command

 	; send the command:
 	 	Mov	cx,22	 	; len of command (bytes)
 	 	Mov	bx,0	 	; offset from Dat_bffr
Sendloop:	; wait for port to signal it's ready:
Waitloop:	Mov	dx,PortReady	; get port addr
 	 	In	al,dx	 	; get port stat value
 	 	And	al,32d	 	; clear to send?
 	 	Je	Waitloop	; wait until ok.

 	; send the next byte:
 	 	Mov	ah,01	 	; INT send byte command
 	 	Mov	al,Dat_bffr[bx] ; load data to send
 	 	Mov	dx,IoData	; use com1:
 	 	Out	dx,al

 	 	Inc	bx	 	; inc offset ptr
 	 	Loop	sendloop

; no all done, so exit.. This exit will be changed in debug for LDRES.

	; first, restore sound stuff
		Pop	ax
		Out	061h,al

		Sti		; restore other interrupts

 	 	Int	20h	 	; all done!
		Nop
		Nop		; leave space for exit modification
		Nop		; of exit routine.

; ----- subroutine beep:

Beep:	 	; no registers need to be conserved...
	; input: al = pitch to send

 	 	Out	42h,al
 	 	Out	42h,al

		Mov	cx,0ffffh	; do delay
Delay:		Loop	Delay

 	 	Mov	al,0b6h	 	; turn off speaker
 	 	Out	43h,al

 	 	Ret	 	 	; end subroutine..

; ----- subroutine GetKey:

GetKey:		; no input, output AL = ASCII of keypressed
		mov	ah,0		; wait for keystroke
		Int	16h
		Cli
		Ret

; -------
code	 	ends
 	 	end	start
--
           ______             |      The Pledge of Allegiance says
           \    /             |      "Liberty and Justice for All"
     stillson@mitre.org       | Which part of "All" don't you understand?
             \/               |           - Rep. Pat Schroeder


