From byron@gemini.cc.gatech.edu Tue Dec 27 16:31:53 PST 1994
Article: 3208 of comp.home.automation
Xref: conexch comp.home.automation:3208
Path: conexch!wilbur!vax.cerritos.edu!news.Cerritos.edu!nic-nac.CSU.net!usc!howland.reston.ans.net!gatech!gt-news!cc.gatech.edu!gemini.cc.gatech.edu!byron
Newsgroups: comp.home.automation
Subject: Re: Home automation via Ethernet?
Message-ID: <3d80k0$54j@solaria.cc.gatech.edu>
From: byron@gemini.cc.gatech.edu (Byron A Jeff)
Date: 21 Dec 1994 01:32:48 GMT
References: <pburgessD0Mvvs.Kxq@netcom.com> <787576261snz@wookie.demon.co.uk> <3d2f07$h1d@solaria.cc.gatech.edu> <D14v98.46o@acsu.buffalo.edu>
Organization: none
NNTP-Posting-Host: gemini.cc.gatech.edu
NNTP-Posting-User: byron
Lines: 77

In article <D14v98.46o@acsu.buffalo.edu>,
Chris Kalisiak <kalisiak@cs.buffalo.edu> wrote:
>In article <3d2f07$h1d@solaria.cc.gatech.edu> you wrote:
>>In article <787576261snz@wookie.demon.co.uk>,
>>-And you've got an IP stack for the PIC 16C84 ?
>
>>Hell No! No need to run IP for this. Any old simple packet protocol should
>>do just fine. Less than 20 lines of C code on the Linux box to read and
>>write packets.
>
>Do you have said 20 lines of code handy? I am not a networking protocol
>guru, and wouldn't know how to program one of these things. If you don't,
>do you know of anyone else that might have?

I just had to open my big mouth!

The protocol is:
<FF><node address><size><data...><checksum>

This is off the top of my head.
----------------------------------------------------------
/* The module will send a receive packets on a RS-485 network */
/* All bugs due to code error ;-) */
int open_channel(char *device)
{
   return open(device,O_RDWR);
   /* Also need to do an IOCTL to set up the serial channel properly */
}

int close_channel(int channel_num)
{
   close(channel_num);
}

write_packet(int channel,int node,char *buf,int size)
{
   register int i;
   unsigned char c,checksum;

   checksum = 0;
   c = 0xff; /* Beginning of packet */
   write(channel,&c,1);
   
   checksum += c = node;
   write(channel,&c,1);
   
   checksum += c = size; /* Can't be more than 255 characters */
   write(channel,&c,1);

   for(;size;size--,buf++) {
      write(channel,buf,1);
      checksum += *buf;
   }

   checksum ^= 255; /* Ones completment of the checksum */
   write(channel,&checksum,1);
}
----------------------------------------------------------------

Read packet would follow simularly waiting for a FF flag then reading
the node number. If the node number doesn't match the current node then
you can ignore the rest of the packet.

Point being that any protocol that the nodes can agree on is sufficient.
Generally if you have the basic elements that I have above in each
packet you'll be fine.

You may want to add more flags in front of the packet and disallow flag
bytes in the packet. This will give you auto syncronization.

Later,

BAJ
-- 
Another random extraction from the mental bit stream of...
Byron A. Jeff - PhD student operating in parallel - And Using Linux!
Georgia Tech, Atlanta GA 30332   Internet: byron@cc.gatech.edu


From map@NIC.DSI.Net Tue Dec 27 16:32:24 PST 1994
Article: 3219 of comp.home.automation
Xref: conexch comp.home.automation:3219
Path: conexch!wilbur!vax.cerritos.edu!news.Cerritos.edu!nic-nac.CSU.net!usc!howland.reston.ans.net!news.sprintlink.net!hookup!news.mathworks.com!news2.near.net!info-server.bbn.com!news.bbn.com!map
Newsgroups: comp.home.automation
Subject: Re: Home automation via Ethernet?
Message-ID: <MAP.94Dec22002918@gaak.NIC.DSI.Net>
From: map@NIC.DSI.Net (Michael Patton)
Date: 22 Dec 1994 05:29:18 GMT
References: <pburgessD0Mvvs.Kxq@netcom.com> 
 <787576261snz@wookie.demon.co.uk><3d2f07$h1d@solaria.cc.gatech.edu> <D14v98.46o@acsu.buffalo.edu><3d80k0$54j@solaria.cc.gatech.edu>
Organization: Bolt Beranek and Newman, Inc.
NNTP-Posting-Host: gaak.bbn.com
In-reply-to: byron@gemini.cc.gatech.edu's message of 21 Dec 1994 01:32:48 GMT
Lines: 19

In article <3d80k0$54j@solaria.cc.gatech.edu> byron@gemini.cc.gatech.edu (Byron A Jeff) described a protocol...

WARNING!  WARNING!  The protocol you describe has several classic
failures built into it.  The protocol is not transparent to the data
being sent, particular patterns of data can cause complete failure
(including lockup with no recovery) in the face of even the most
trivial errors (including detected single bit transmission errors).
There are also transmission errors that I would expect to be quite
likely in this physical environment and which that particular style of
checksum does not detect.

Additionally, the packet framing is only the first (and most trivial)
part of any protocol design.  There are many good books on these
topics (unfortunately I can't think of any off hand, I haven't needed
to reference any of them in a decade or so), and I suggest anyone
contemplating designing their own should consult these before risking
their house on the design...  Remember the humorous post that keeps
coming back about the house gone berserk?  You may be designing that
very house.


From byron@gemini.cc.gatech.edu Tue Dec 27 16:33:00 PST 1994
Article: 3240 of comp.home.automation
Xref: conexch comp.home.automation:3240
Path: conexch!wilbur!vax.cerritos.edu!news.Cerritos.edu!nic-nac.CSU.net!usc!howland.reston.ans.net!gatech!gt-news!cc.gatech.edu!gemini.cc.gatech.edu!byron
Newsgroups: comp.home.automation
Subject: Re: Home automation via Ethernet?
Message-ID: <3ddk6n$6br@solaria.cc.gatech.edu>
From: byron@gemini.cc.gatech.edu (Byron A Jeff)
Date: 23 Dec 1994 04:37:43 GMT
References: <pburgessD0Mvvs.Kxq@netcom.com> <D14v98.46o@acsu.buffalo.edu> 
 <3d80k0$54j@solaria.cc.gatech.edu> <MAP.94Dec22002918@gaak.nic.dsi.net>
Organization: none
NNTP-Posting-Host: gemini.cc.gatech.edu
NNTP-Posting-User: byron
Lines: 62

In article <MAP.94Dec22002918@gaak.nic.dsi.net>,
Michael Patton <map@NIC.DSI.Net> wrote:
>In article <3d80k0$54j@solaria.cc.gatech.edu> byron@gemini.cc.gatech.edu (Byron A Jeff) described a protocol...
>
>WARNING!  WARNING!  The protocol you describe has several classic
>failures built into it.  The protocol is not transparent to the data
>being sent, particular patterns of data can cause complete failure
>(including lockup with no recovery) in the face of even the most
>trivial errors (including detected single bit transmission errors).
>There are also transmission errors that I would expect to be quite
>likely in this physical environment and which that particular style of
>checksum does not detect.

Michael I never claimed to be a network protocol engineer. I've used this
exact same protocol on several projects. It's worked fine.

- For data transparency you can add bit-stuffing.

- For error detection and correction you can add CRC instead of a simple
  checksum.

- To forego lockup without recovery you have acknoledgements and timeouts
  if the ACK isn't received.

This protocol isn't the least bit original. It's the basis for ASCII
based object code formats for both Motorola and Intel. (S-Records and
Intel BINHEX respectively)

The point was not to show how to build the perfect protocol,  The point
was to show how to implment a simple protocol over the serial line,
which I believe the poster originally asked for.

>
>Additionally, the packet framing is only the first (and most trivial)
>part of any protocol design.  There are many good books on these
>topics (unfortunately I can't think of any off hand, I haven't needed
>to reference any of them in a decade or so), and I suggest anyone
>contemplating designing their own should consult these before risking
>their house on the design...  Remember the humorous post that keeps
>coming back about the house gone berserk?  You may be designing that
>very house.

I didn't say I was going to use this in my house. However all of the features
you pointed out adds code complexity to the point of missing the point.

Ok hotshot, you're using microcontroller that has 1K of program memory,
36 bytes of RAM, and a 400 ns instruction cycle. It can send and receive
asyncronous serial data at 19200 bps. It lives on a multi node serial
network and it doesn't have the hardware to ignore packets that aren't
destined for it. You need to design a robust network protocol so that
your house won't go berserk. However you cannot use all of the program or
data memory or all of the instruction cycles in the process. The only
additional hardware you have is the network interface chip.

What do you do?
WHAT DO YOU DO!!!???? ;-)

BAJ
-- 
Another random extraction from the mental bit stream of...
Byron A. Jeff - PhD student operating in parallel - And Using Linux!
Georgia Tech, Atlanta GA 30332   Internet: byron@cc.gatech.edu


