
{*******************************************************}
{                                                       }
{       Delphi Visual Component Library                 }
{                                                       }
{       Copyright (c) 1995 Borland International        }
{                                                       }
{*******************************************************}

unit Qbinddlg;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, DB, DBTables;

type
  TQueryParams = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    ParamValue: TEdit;
    Label2: TLabel;
    NullValue: TCheckBox;
    OkBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Label3: TLabel;
    TypeList: TComboBox;
    ParamList: TListBox;
    HelpBtn: TBitBtn;
    procedure ParamListChange(Sender: TObject);
    procedure TypeListChange(Sender: TObject);
    procedure ParamValueExit(Sender: TObject);
    procedure NullValueClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure OkBtnClick(Sender: TObject);
  private
    InitList: TParams;
    PressedOK: Boolean;
    InValueExit: Boolean;
    InParamChange: Boolean;
    function AcceptFieldClass(Value: TFieldClass): Boolean;
    procedure CheckValue;
    procedure Edit;
    procedure Unbind;
  end;

function EditQueryParams(DataSet: TDataSet; List: TParams): Boolean;

implementation

uses Dbconsts, LibHelp;

{$R *.DFM}

var
  FieldTypes: array[TFieldType] of PString;

procedure FillFieldTypes;
var
  ParamString: string;
  I: Integer;
  J: TFieldType;
begin
  ParamString := LoadStr(SDataTypes);
  J := Low(TFieldType);
  I := 1;
  while I <= Length(ParamString) do
  begin
    AssignStr(FieldTypes[J], ExtractFieldName(ParamString, I));
    Inc(J);
  end;
end;

function GetFieldType(const Value: string): TFieldType;
begin
  for Result := Low(TFieldType) to High(TFieldType) do
    if FieldTypes[Result]^ = Value then Exit;
  Result := ftUnknown;
end;

procedure ClearFieldTypes;
var
  I: TFieldType;
begin
  for I := Low(TFieldType) to High(TFieldType) do
    DisposeStr(FieldTypes[I]);
end;

function EditQueryParams(DataSet: TDataSet; List: TParams): Boolean;
begin
  with TQueryParams.Create(Application) do
  try
    Caption := Format(LoadStr(SParamEditor), [DataSet.Owner.Name, DataSet.Name]);
    InitList := List;
    Edit;
    Result := PressedOk;
  finally
    Free;
  end;
end;

function TQueryParams.AcceptFieldClass(Value: TFieldClass): Boolean;
begin
  Result := (Value <> TBlobField) and (Value <> TGraphicField) and
    (Value <> TMemoField);
end;

procedure TQueryParams.Edit;
var
  I: Integer;
  J: TFieldType;
begin
  for J := Low(TFieldType) to High(TFieldType) do
    if FieldTypes[J]^ <> '' then TypeList.Items.Add(FieldTypes[J]^);
  if InitList.Count = 0 then
  begin
    ParamValue.Enabled := False;
    NullValue.Enabled := False;
    TypeList.Enabled := False;
    ParamList.Enabled := False;
  end
  else begin
    for I := 0 to InitList.Count - 1 do
      if ParamList.Items.IndexOf(InitList[I].Name) = -1 then
        ParamList.Items.Add(InitList[I].Name);
    ParamList.ItemIndex := 0;
    ParamListChange(Self);
    ActiveControl := OkBtn;
  end;
  PressedOk := ShowModal = mrOK;
end;

procedure TQueryParams.ParamListChange(Sender: TObject);
begin
  InParamChange := True;
  try
    with InitList.ParamByName(ParamList.Items[ParamList.ItemIndex]) do
    begin
      if FieldTypes[DataType]^ <> '' then
      begin
        with TypeList do ItemIndex := Items.IndexOf(FieldTypes[DataType]^);
        if Bound then ParamValue.Text := AsString
        else ParamValue.Text := '';
      end
      else begin
        TypeList.ItemIndex := -1;
        ParamValue.Text := '';
      end;
      NullValue.Checked := IsNull;
    end;
  finally
    InParamChange := False;
  end;
end;

procedure TQueryParams.TypeListChange(Sender: TObject);
begin
  with InitList.ParamByName(ParamList.Items[ParamList.ItemIndex]) do
  begin
    DataType := GetFieldType(TypeList.Text);
    ParamValue.Text := '';
    NullValue.Checked := IsNull;
  end;
end;

procedure TQueryParams.ParamValueExit(Sender: TObject);
begin
  if InValueExit or (ActiveControl = CancelBtn) then Exit;
  InValueExit := True;
  try
    if ParamValue.Text <> '' then NullValue.Checked := False;
    if TypeList.Text = '' then
    begin
      TypeList.SetFocus;
      raise Exception.Create(LoadStr(SInvalidParamFieldType));
    end;
    if ParamValue.Text = '' then
      with InitList.ParamByName(ParamList.Items[ParamList.ItemIndex]) do
      begin
        if NullValue.Checked then Clear
        else Unbind;
      end
    else CheckValue;
  finally
    InValueExit := False;
  end;
end;

procedure TQueryParams.CheckValue;
begin
  try
    InitList.ParamByName(ParamList.Items[ParamList.ItemIndex]).Text := ParamValue.Text;
  except
    with ParamValue do
    begin
      SetFocus;
      SelectAll;
    end;
    raise;
  end;
end;

procedure TQueryParams.Unbind;
begin
  with InitList.ParamByName(ParamList.Items[ParamList.ItemIndex]) do
  begin
    AsInteger := 1;
    DataType := GetFieldType(TypeList.Text);
    Bound := False;
  end;
end;

procedure TQueryParams.NullValueClick(Sender: TObject);
begin
  if InParamChange then Exit;
  if NullValue.Checked then
    with InitList.ParamByName(ParamList.Items[ParamList.ItemIndex]) do
    begin
      Clear;
      ParamValue.Text := '';
    end
  else Unbind;
end;

procedure TQueryParams.OkBtnClick(Sender: TObject);
begin
  if not TypeList.Enabled then Exit;
  try
    ParamValueExit(Sender);
  except
    ModalResult := 0;
    raise;
  end;
end;

procedure DoneQBind; far;
begin
  ClearFieldTypes;
end;

procedure TQueryParams.FormCreate(Sender: TObject);
begin
  HelpContext := hcDQuery;
end;

begin
  FillFieldTypes;
  AddExitProc(DoneQBind);
end.
