
{*******************************************************}
{                                                       }
{       Delphi Visual Component Library                 }
{                                                       }
{       Copyright (c) 1995 Borland International        }
{                                                       }
{*******************************************************}

unit DBLogDlg;

{$P+}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Buttons, StdCtrls, ExtCtrls;

type
  TLoginDialog = class(TForm)
    Panel: TPanel;
    Bevel: TBevel;
    DatabaseName: TLabel;
    UserName: TEdit;
    Password: TEdit;
    OKButton: TBitBtn;
    CancelButton: TBitBtn;
  end;

function LoginDialog(const ADatabaseName: string;
  var AUserName, APassword: string): Boolean;

implementation

{$R *.DFM}

function LoginDialog(const ADatabaseName: string;
  var AUserName, APassword: string): Boolean;
begin
  with TLoginDialog.Create(Application) do
  try
    DatabaseName.Caption := ADatabaseName;
    UserName.Text := AUserName;
    Result := False;
    if AUserName = '' then ActiveControl := UserName;
    if ShowModal = mrOk then
    begin
      AUserName := UserName.Text;
      APassword := Password.Text;
      Result := True;
    end;
  finally
    Free;
  end;
end;

end.
