
; *******************************************************
; *							*
; *     Delphi Runtime Library                          *
; *	String formatter				*
; *							*
; *	Copyright (c) 1994,95 Borland International	*
; *							*
; *******************************************************

	TITLE	SFMT

	INCLUDE	SE.ASM

ffGeneral	EQU	0
ffExponent	EQU	1
ffFixed		EQU	2
ffNumber	EQU	3
ffCurrency	EQU	4

DATA	SEGMENT	WORD PUBLIC

	EXTRN	CurrencyDecimals:BYTE

DATA	ENDS

	EXTRN	FloatToText:FAR

CODE	SEGMENT	BYTE PUBLIC

	ASSUME	CS:CODE

	EXTRN	FormatError:NEAR

	PUBLIC	FormatBuf

FormatBuf:

	ARG	Buffer,DWORD,1
	ARG	BufLen,WORD,1
	ARG	Format,DWORD,1
	ARG	FmtLen,WORD,1
	ARG	Args,DWORD,1
	ARG	ArgLast,WORD,1
	LOC	DataSeg,WORD,1
	LOC	ArgIndex,WORD,1
	LOC	Width,WORD,1
	LOC	Prec,WORD,1
	LOC	JustFlag,BYTE,2
	LOC	FormatOrg,WORD,1
	LOC	StrBuf,BYTE,40

	ENTRY	FAR
	MOV	DataSeg,DS
	LES	DI,Buffer
	MOV	DX,BufLen
	LDS	SI,Format
	MOV	CX,FmtLen
	MOV	ArgIndex,0
	CLD
@@0:	OR	DX,DX
	JE	@@3
@@1:	JCXZ	@@3
	LODSB
	DEC	CX
	CMP	AL,'%'
	JE	@@10
@@2:	STOSB
	DEC	DX
	JNE	@@1
@@3:	MOV	DS,DataSeg
	MOV	AX,DI
	SUB	AX,Buffer.ofs
	EXIT
@@10:	JCXZ	@@3
	LODSB
	DEC	CX
	CMP	AL,'%'
	JE	@@2
	LEA	BX,[SI-2]
	MOV	FormatOrg,BX
	MOV	JustFlag,AL
	CMP	AL,'-'
	JNE	@@11
	JCXZ	@@3
	LODSB
	DEC	CX
@@11:	CALL	@@30
	CMP	AL,':'
	JNE	@@12
	MOV	ArgIndex,BX
	JMP	@@10
@@12:	MOV	Width,BX
        MOV     BX,-1
	CMP	AL,'.'
	JNE	@@20
	JCXZ	@@3
	LODSB
	DEC	CX
	CALL	@@30
@@20:	MOV	Prec,BX
	MOV	Format.ofs,SI
	PUSH	CX
	PUSH	DX
	CALL	Convert
	POP	DX
	MOV	BX,Width
	SUB	BX,CX
	JAE	@@21
	XOR	BX,BX
@@21:	CMP	JustFlag,'-'
	JNE	@@23
	SUB	DX,CX
	JAE	@@22
	ADD	CX,DX
	XOR	DX,DX
@@22:	REP	MOVSB
@@23:	XCHG	BX,CX
	SUB	DX,CX
	JAE	@@24
	ADD	CX,DX
	XOR	DX,DX
@@24:	MOV	AL,' '
	REP	STOSB
	XCHG	BX,CX
	SUB	DX,CX
	JAE	@@25
	ADD	CX,DX
	XOR	DX,DX
@@25:	REP	MOVSB
	POP	CX
	LDS	SI,Format
	JMP	@@0
@@30:	XOR	BX,BX
	CMP	AL,'*'
	JE	@@32
@@31:	CMP	AL,'0'
	JB	@@34
	CMP	AL,'9'
	JA	@@34
	SUB	AL,'0'
	XOR	AH,AH
	PUSH	AX
	SHL	BX,1
	MOV	AX,BX
	SHL	BX,1
	SHL	BX,1
	ADD	BX,AX
	POP	AX
	ADD	BX,AX
	JCXZ	@@35
	LODSB
	DEC	CX
	JMP	@@31
@@32:	MOV	AX,ArgIndex
	CMP	AX,ArgLast
	JA	@@33
	INC	ArgIndex
	SHL	AX,1
	SHL	AX,1
	SHL	AX,1
	PUSH	DS
	PUSH	SI
	LDS	SI,Args
	ADD	SI,AX
	CMP	[SI].b4,0
	JNE	@@36
	MOV	BX,[SI]
@@36:	POP	SI
	POP	DS
@@33:	JCXZ	@@35
	LODSB
	DEC	CX
@@34:	RET
@@35:	POP	AX
	JMP	@@3

Convert:

	AND	AL,0DFH
	MOV	CL,AL
	MOV	AX,1
	MOV	BX,ArgIndex
	CMP	BX,ArgLast
	JA	ErrorExit
	INC	ArgIndex
	SHL	BX,1
	SHL	BX,1
	SHL	BX,1
	LDS	SI,Args
	ADD	SI,BX
	MOV	AX,[SI].w0
	MOV	DX,[SI].w2
	MOV	BL,[SI].b4
	XOR	BH,BH
	SHL	BX,1
	JMP	CS:CvtVector[BX]

CvtVector	LABEL	WORD

	DW	CvtInteger
	DW	CvtBoolean
	DW	CvtChar
	DW	CvtExtended
	DW	CvtString
	DW	CvtPointer
	DW	CvtPChar
	DW	CvtObject
	DW	CvtClass

CvtBoolean:
CvtObject:
CvtClass:
CvtError:

	XOR	AX,AX

ErrorExit:

	MOV	DS,DataSeg
	PUSH	AX
	PUSH	Format.seg
	PUSH	FormatOrg
	MOV	AX,Format.ofs
	SUB	AX,FormatOrg
	PUSH	AX
	CALL	FormatError

CvtInteger:

	CMP	CL,'D'
	JE	@@1
	CMP	CL,'U'
	JE	@@2
	CMP	CL,'X'
	JNE	CvtError
	MOV	CX,16
	JMP	SHORT CvtLong
@@1:	OR	DX,DX
	JNS	@@2
	NEG	DX
	NEG	AX
	SBB	DX,0
	CALL	@@2
	MOV	AL,'-'
	INC	CX
	DEC	SI
	MOV	[SI],AL
	RET
@@2:	MOV	CX,10
;	JMP	CvtLong

CvtLong:

	LEA	SI,StrBuf[16]
	MOV	BX,SS
	MOV	DS,BX
	MOV	BX,DX
@@1:	XOR	DX,DX
	XCHG	AX,BX
	DIV	CX
	XCHG	AX,BX
	DIV	CX
	ADD	DL,'0'
	CMP	DL,'0'+10
	JB	@@2
	ADD	DL,'A'-'0'-10
@@2:	DEC	SI
	MOV	[SI],DL
	MOV	DX,AX
	OR	DX,BX
	JNE	@@1
	LEA	CX,StrBuf[16]
	SUB	CX,SI
	MOV	DX,Prec
	CMP	DX,16
	JB	@@3
	RET
@@3:	SUB	DX,CX
	JBE	@@5
	ADD	CX,DX
	MOV	AL,'0'
@@4:	DEC	SI
	MOV	[SI],AL
	DEC	DX
	JNE	@@4
@@5:	RET

CvtChar:

	CMP	CL,'S'
	JNE	CvtError2
	MOV	CX,1
	RET

CvtString:

	CMP	CL,'S'
	JNE	CvtError2
	MOV	SI,AX
	MOV	DS,DX
	LODSB
	MOV	CL,AL
	XOR	CH,CH
	CMP	CX,Prec
	JA	@@1
	RET
@@1:	MOV	CX,Prec
	RET

CvtError2:

	JMP	CvtError

CvtPChar:

	CMP	CL,'S'
	JNE	CvtError2
	MOV	SI,AX
	MOV	DS,DX
	PUSH	ES
	PUSH	DI
	MOV	DI,AX
	MOV	ES,DX
	XOR	AL,AL
	MOV	CX,Prec
	JCXZ	@@1
	REPNE	SCASB
	JNE	@@1
	DEC	DI
@@1:	MOV	CX,DI
	SUB	CX,SI
	POP	DI
	POP	ES
	RET

CvtPointer:

	CMP	CL,'P'
	JNE	CvtError2
	MOV	Prec,8
	MOV	CX,16
	CALL	CvtLong
	INC	CX
	DEC	SI
	MOV	AX,[SI+1]
	MOV	[SI],AX
	MOV	AX,[SI+3]
	MOV	[SI+2],AX
	MOV	[SI+4].b0,':'
	RET

CvtExtended:

	MOV	SI,AX
	MOV	DS,DX
	MOV	BL,ffGeneral
	CMP	CL,'G'
	JE	@@1
	MOV	BL,ffExponent
	CMP	CL,'E'
	JE	@@1
	MOV	BL,ffFixed
	CMP	CL,'F'
	JE	@@0
	MOV	BL,ffNumber
	CMP	CL,'N'
	JE	@@0
	CMP	CL,'M'
	JNE	CvtError2
	MOV	BL,ffCurrency
@@0:	MOV	AX,18
	MOV	DX,Prec
	CMP	DX,AX
	JBE	@@2
	MOV	DX,2
	CMP	CL,'M'
	JNE	@@2
	PUSH	DS
	MOV	DS,DataSeg
	MOV	DL,DS:CurrencyDecimals
	POP	DS
	JMP	SHORT @@2
@@1:	MOV	AX,Prec
	MOV	DX,3
	CMP	AX,18
	JBE	@@2
	MOV	AX,15
@@2:	PUSH	ES
	PUSH	DI
	LEA	DI,StrBuf
	PUSH	SS
	PUSH	DI
	PUSH	[SI].w8
	PUSH	[SI].w6
	PUSH	[SI].w4
	PUSH	[SI].w2
	PUSH	[SI].w0
	PUSH	BX
	PUSH	AX
	PUSH	DX
	MOV	DS,DataSeg
	CALL	FloatToText
	MOV	CX,AX
	LEA	SI,StrBuf
	PUSH	SS
	POP	DS
	POP	DI
	POP	ES
	RET

CODE	ENDS

	END
