
; *******************************************************
; *							*
; *     Delphi Runtime Library                          *
; *	Floating point formatting routines		*
; *							*
; *	Copyright (c) 1994,95 Borland International	*
; *							*
; *******************************************************

	TITLE	FFMT

	INCLUDE	SE.ASM

; TFloatRec layout

fdExponent	EQU	(WORD PTR 0)
fdNegative	EQU	(BYTE PTR 2)
fdDigits	EQU	(BYTE PTR 3)
fdRecSize	EQU	22

; TFloatFormat constants

ffGeneral	EQU	0
ffExponent	EQU	1
ffFixed		EQU	2
ffNumber	EQU	3
ffCurrency	EQU	4

DATA	SEGMENT	WORD PUBLIC

	EXTRN	CurrencyString:BYTE
	EXTRN	CurrencyFormat:BYTE
	EXTRN	NegCurrFormat:BYTE
	EXTRN	ThousandSeparator:BYTE
	EXTRN	DecimalSeparator:BYTE

DATA	ENDS

; Externals

	EXTRN	FSafeDivide:FAR

CODE	SEGMENT	BYTE PUBLIC

	ASSUME	CS:CODE

; Publics

	PUBLIC	FloatToText,FloatToTextFmt,FloatToDecimal,TextToFloat

; Constants

DCon10		DW	10

DCon1E0		DD	1
DCon1E1		DD	10
DCon1E2		DD	100
DCon1E3		DD	1000
DCon1E4		DD	10000
DCon1E5		DD	100000
DCon1E6		DD	1000000
DCon1E7		DD	10000000

FCon1E8		DT	1E8
FCon1E16	DT	1E16
FCon1E32	DT	1E32
FCon1E64	DT	1E64
FCon1E128	DT	1E128
FCon1E256	DT	1E256
FCon1E512	DT	1E512
FCon1E1024	DT	1E1024
FCon1E2048	DT	1E2048
FCon1E4096	DT	1E4096
FCon1E18	DT	1E18
FConINF		DT	07FFF8000000000000000R

; 8087 control word

CWNear		DW	133FH

; NAN and INF strings

NANINF		DB	'NANINF'

; function FloatToText(Buffer: PChar; Value: Extended; Format: TFloatFormat;
;   Precision, Digits: Integer): Integer;

FloatToText:

	ARG	Buffer,DWORD,1
	ARG	Value,TBYTE,1
	ARG	Format,BYTE,2
	ARG	Precision,WORD,1
	ARG	Digits,WORD,1
	LOC	DataSeg,WORD,1
	LOC	CurrFormats,WORD,1
	LOC	Separators,WORD,1
	LOC	FloatRec,BYTE,fdRecSize

	ENTRY	FAR
	MOV	DataSeg,DS
	MOV	AX,WORD PTR DS:CurrencyFormat
	MOV	CurrFormats,AX
	MOV	AX,WORD PTR DS:ThousandSeparator
	MOV	Separators,AX
	CMP	Precision,2
	JGE	@@1
	MOV	Precision,2
@@1:	CMP	Precision,18
	JLE	@@2
	MOV	Precision,18
@@2:	LEA	AX,FloatRec
	PUSH	SS
	PUSH	AX
	PUSH	Value.w8
	PUSH	Value.w6
	PUSH	Value.w4
	PUSH	Value.w2
	PUSH	Value.w0
	PUSH	Precision
	MOV	AX,9999
	CMP	Format,ffFixed
	JB	@@3
	MOV	AX,Digits
@@3:	PUSH	AX
	PUSH	CS
	CALL	FloatToDecimal
	PUSH	DS
	LES	DI,Buffer
	CLD
	MOV	AX,FloatRec.fdExponent
	SUB	AX,7FFFH
	CMP	AX,2
	JAE	@@4
	MOV	SI,OFFSET CS:NANINF
	PUSH	CS
	POP	DS
	ADD	SI,AX
	ADD	SI,AX
	ADD	SI,AX
	MOV	CX,3
	REP	MOVSB
	JMP	SHORT @@7
@@4:	LEA	SI,FloatRec.fdDigits
	PUSH	SS
	POP	DS
	MOV	BL,Format
	CMP	BL,ffExponent
	JE	@@6
	CMP	BL,ffCurrency
	JA	@@5
	MOV	AX,FloatRec.fdExponent
	CMP	AX,Precision
	JLE	@@6
@@5:	MOV	BL,ffGeneral
@@6:	XOR	BH,BH
	ADD	BX,BX
	CALL	CS:FormatVector[BX]
@@7:	MOV	DS,DataSeg
	MOV	AX,DI
	SUB	AX,Buffer.ofs
	EXIT

FormatVector	LABEL	WORD

	DW	PutFGeneral
	DW	PutFExponent
	DW	PutFFixed
	DW	PutFNumber
	DW	PutFCurrency

; Get digit or '0' if at end of digit string

GetDigit:

	LODSB
	OR	AL,AL
	JNE	@@1
	MOV	AL,'0'
	DEC	SI
@@1:	RET

; Store '-' if number is negative

PutSign:

	CMP	FloatRec.fdNegative,0
	JE	@@1
	MOV	AL,'-'
	STOSB
@@1:	RET

; Convert number using ffGeneral format

PutFGeneral:

	CALL	PutSign
	MOV	CX,FloatRec.fdExponent
	XOR	DX,DX
	CMP	CX,Precision
	JG	@@1
	CMP	CX,-3
	JL	@@1
	OR	CX,CX
	JG	@@2
	MOV	AL,'0'
	STOSB
	CMP	BYTE PTR [SI],0
	JE	@@6
	MOV	AL,Separators.b1
	STOSB
	NEG	CX
	MOV	AL,'0'
	REP	STOSB
	JMP	SHORT @@3
@@1:	MOV	CX,1
	INC	DX
@@2:	LODSB
	OR	AL,AL
	JE	@@4
	STOSB
	LOOP	@@2
	LODSB
	OR	AL,AL
	JE	@@5
	MOV	AH,AL
	MOV	AL,Separators.b1
	STOSW
@@3:	LODSB
	OR	AL,AL
	JE	@@5
	STOSB
	JMP	@@3
@@4:	MOV	AL,'0'
	REP	STOSB
@@5:	OR	DX,DX
	JE	@@6
	XOR	AH,AH
	XOR	CX,CX
	JMP	PutFloatExp
@@6:	RET

; Convert number using ffExponent format

PutFExponent:

	CALL	PutSign
	CALL	GetDigit
	MOV	AH,Separators.b1
	STOSW
	MOV	CX,Precision
	DEC	CX
@@1:	CALL	GetDigit
	STOSB
	LOOP	@@1
	MOV	AH,'+'
	MOV	CX,Digits
	CMP	CX,4
	JB	PutFloatExp
	XOR	CX,CX
;	JMP	PutFloatExp

; Store exponent
; In	AH = Positive sign character ('+' or 0)
;	CX = Minimum number of digits (0..4)

PutFloatExp:

	MOV	AL,'E'
	MOV	BL,FloatRec.fdDigits
	MOV	DX,FloatRec.fdExponent
	DEC	DX
;	JMP	PutExponent

; Store exponent
; In	AL = Exponent character ('E' or 'e')
;	AH = Positive sign character ('+' or 0)
;	BL = Zero indicator
;	CX = Minimum number of digits (0..4)
;	DX = Exponent

PutExponent:

	STOSB
	OR	BL,BL
	JNE	@@0
	XOR	DX,DX
	JMP	SHORT @@1
@@0:	OR	DX,DX
	JGE	@@1
	MOV	AL,'-'
	NEG	DX
	JMP	SHORT @@2
@@1:	OR	AH,AH
	JE	@@3
	MOV	AL,AH
@@2:	STOSB
@@3:	XCHG	AX,DX
	SUB	SP,4
	MOV	BX,SP
@@4:	XOR	DX,DX
	DIV	DCon10
	ADD	DL,'0'
	MOV	SS:[BX],DL
	INC	BX
	DEC	CX
	OR	AX,AX
	JNE	@@4
	OR	CX,CX
	JG	@@4
@@5:	DEC	BX
	MOV	AL,SS:[BX]
	STOSB
	CMP	BX,SP
	JNE	@@5
	ADD	SP,4
	RET

; Convert number using ffFixed or ffNumber format

PutFFixed:
PutFNumber:

	CALL	PutSign

; Store number in fixed point format

PutNumber:

	MOV	DX,Digits
	CMP	DX,18
	JB	@@1
	MOV	DX,18
@@1:	MOV	CX,FloatRec.fdExponent
	OR	CX,CX
	JG	@@2
	MOV	AL,'0'
	STOSB
	JMP	SHORT @@4
@@2:	XOR	BX,BX
	CMP	Format,ffFixed
	JE	@@3
	MOV	AX,CX
	DEC	AX
	MOV	BL,3
	DIV	BL
	MOV	BL,AH
	INC	BX
@@3:	CALL	GetDigit
	STOSB
	DEC	CX
	JE	@@4
	DEC	BX
	JNE	@@3
	MOV	AL,Separators.b0
	STOSB
	MOV	BL,3
	JMP	@@3
@@4:	OR	DX,DX
	JE	@@7
	MOV	AL,Separators.b1
	STOSB
	JCXZ	@@6
	MOV	AL,'0'
@@5:	STOSB
	DEC	DX
	JE	@@7
	INC	CX
	JNE	@@5
@@6:	CALL	GetDigit
	STOSB
	DEC	DX
	JNE	@@6
@@7:	RET

; Convert number using ffCurrency format

PutFCurrency:

	MOV	BL,CurrFormats.b0
	MOV	CX,0003H
	CMP	FloatRec.fdNegative,0
	JE	@@1
	MOV	BL,CurrFormats.b1
	MOV	CX,040AH
@@1:	CMP	BL,CL
	JBE	@@2
	MOV	BL,CL
@@2:	ADD	BL,CH
	XOR	BH,BH
	SHL	BX,1
	SHL	BX,1
	MOV	CX,4
@@10:	MOV	AL,CS:MoneyFormats[BX]
	CMP	AL,'@'
	JE	@@14
	PUSH	CX
	PUSH	BX
	CMP	AL,'$'
	JE	@@11
	CMP	AL,'*'
	JE	@@12
	STOSB
	JMP	SHORT @@13
@@11:	CALL	PutCurSym
	JMP	SHORT @@13
@@12:	CALL	PutNumber
@@13:	POP	BX
	POP	CX
	INC	BX
	LOOP	@@10
@@14:	RET

; Store currency symbol string

PutCurSym:

	PUSH	DS
	PUSH	SI
	MOV	DS,DataSeg
	MOV	SI,OFFSET DS:CurrencyString
	LODSB
	MOV	CL,AL
	XOR	CH,CH
	REP	MOVSB
	POP	SI
	POP	DS
	RET

; Currency formatting templates

MoneyFormats	LABEL	BYTE

	DB	'$*@@'
	DB	'*$@@'
	DB      '$ *@'
	DB	'* $@'
	DB	'($*)'
	DB	'-$*@'
	DB	'$-*@'
	DB	'$*-@'
	DB	'(*$)'
	DB	'-*$@'
	DB	'*-$@'
	DB	'*$-@'
	DB	'-* $'
	DB	'-$ *'
	DB	'$ *-'

; function FloatToTextFmt(Buffer: PChar; Value: Extended;
;   Format: PChar): Integer;

FloatToTextFmt:

	ARG	Buffer,DWORD,1
	ARG	Value,TBYTE,1
	ARG	Format,DWORD,1
	LOC	ThousandSep,BYTE,1
	LOC	Scientific,BYTE,1
	LOC	Separators,WORD,1
	LOC	Section,WORD,1
	LOC	DigitCount,WORD,1
	LOC	DecimalIndex,WORD,1
	LOC	FirstDigit,WORD,1
	LOC	LastDigit,WORD,1
	LOC	DigitPlace,WORD,1
	LOC	DigitDelta,WORD,1
	LOC	FloatRec,BYTE,fdRecSize

	ENTRY	FAR
	CLD
	MOV	AX,WORD PTR DS:ThousandSeparator
	MOV	Separators,AX
	MOV	CX,2
	MOV	AX,Value.w0
	OR	AX,Value.w2
	OR	AX,Value.w4
	OR	AX,Value.w6
	OR	AX,Value.w8
	JE	@@1
	MOV	CX,Value.w8
	SHR	CX,15
@@1:	CALL	FindSection
	JE	@@4
	MOV	Section,SI
	CALL	ScanSection
	LEA	AX,FloatRec
	PUSH	SS
	PUSH	AX
	PUSH	Value.w8
	PUSH	Value.w6
	PUSH	Value.w4
	PUSH	Value.w2
	PUSH	Value.w0
	MOV	AX,DigitCount
	MOV	DX,9999
	CMP	Scientific,0
	JNE	@@2
	SUB	AX,DecimalIndex
	MOV	DX,AX
	MOV	AX,18
@@2:	PUSH	AX
	PUSH	DX
	PUSH	CS
	CALL	FloatToDecimal
	MOV	AX,FloatRec.fdExponent
	CMP	AX,8000H
	JE	@@4
	CMP	AX,7FFFH
	JE	@@4
	CMP	AX,18
	JLE	@@5
	CMP	Scientific,0
	JNE	@@5
@@4:	PUSH	Buffer.seg
	PUSH	Buffer.ofs
	PUSH	Value.w8
	PUSH	Value.w6
	PUSH	Value.w4
	PUSH	Value.w2
	PUSH	Value.w0
	PUSH	ffGeneral
	PUSH	15
	PUSH	0
	PUSH	CS
	CALL	FloatToText
	JMP	SHORT @@7
@@5:	CMP	FloatRec.fdDigits,0
	JNE	@@6
	MOV	CX,2
	CALL	FindSection
	JE	@@4
	CMP	SI,Section
	JE	@@6
	CALL	ScanSection
@@6:	CALL	ApplyFormat
@@7:	EXIT

; Find format section
; In	CX = Section index
; Out	SI = Section offset
;	ZF = 1 if section is empty

FindSection:

	PUSH	DS
	LDS	SI,Format
	JCXZ	@@2
@@1:	LODSB
	CMP	AL,"'"
	JE	@@4
	CMP	AL,'"'
	JE	@@4
	OR	AL,AL
	JE	@@2
	CMP	AL,';'
	JNE	@@1
	LOOP	@@1
	MOV	AL,[SI]
	OR	AL,AL
	JE	@@2
	CMP	AL,';'
	JNE	@@3
@@2:	MOV	SI,Format.ofs
	MOV	AL,[SI]
	OR	AL,AL
	JE	@@3
	CMP	AL,';'
@@3:	POP	DS
	RET
@@4:	MOV	AH,AL
@@5:	LODSB
	CMP	AL,AH
	JE	@@1
	OR	AL,AL
	JNE	@@5
	JMP	@@2

; Scan format section

ScanSection:

	PUSH	DS
	MOV	DS,Format.seg
	MOV	Section,SI
	MOV	BX,32767
	XOR	CX,CX
	XOR	DX,DX
	MOV	DecimalIndex,-1
	MOV	Scientific.w0,DX
@@1:	LODSB
@@2:	CMP	AL,'#'
	JE	@@10
	CMP	AL,'0'
	JE	@@11
	CMP	AL,'.'
	JE	@@13
	CMP	AL,','
	JE	@@14
	CMP	AL,"'"
	JE	@@15
	CMP	AL,'"'
	JE	@@15
	CMP	AL,'E'
	JE	@@20
	CMP	AL,'e'
	JE	@@20
	CMP	AL,';'
	JE	@@30
	OR	AL,AL
	JNE	@@1
	JMP	SHORT @@30
@@10:	INC	DX
	JMP	@@1
@@11:	CMP	DX,BX
	JGE	@@12
	MOV	BX,DX
@@12:	INC	DX
	MOV	CX,DX
	JMP	@@1
@@13:	CMP	DecimalIndex,-1
	JNE	@@1
	MOV	DecimalIndex,DX
	JMP	@@1
@@14:	MOV	ThousandSep,1
	JMP	@@1
@@15:	MOV	AH,AL
@@16:	LODSB
	CMP	AL,AH
	JE	@@1
	OR	AL,AL
	JNE	@@16
	JMP	SHORT @@30
@@20:	LODSB
	CMP	AL,'-'
	JE	@@21
	CMP	AL,'+'
	JNE	@@2
@@21:	MOV	Scientific,1
@@22:	LODSB
	CMP	AL,'0'
	JE	@@22
	JMP	@@2
@@30:	POP	DS
	MOV	DigitCount,DX
	CMP	DecimalIndex,-1
	JNE	@@31
	MOV	DecimalIndex,DX
@@31:	MOV	AX,DecimalIndex
	SUB	AX,CX
	JLE	@@32
	XOR	AX,AX
@@32:	MOV	LastDigit,AX
	MOV	AX,DecimalIndex
	SUB	AX,BX
	JGE	@@33
	XOR	AX,AX
@@33:	MOV	FirstDigit,AX
	RET

; Apply format string

ApplyFormat:

	PUSH	DS
	CMP	Scientific,0
	JE	@@1
	MOV	AX,DecimalIndex
	XOR	DX,DX
	JMP	SHORT @@3
@@1:	MOV	AX,FloatRec.fdExponent
	CMP	AX,DecimalIndex
	JG	@@2
	MOV	AX,DecimalIndex
@@2:	MOV	DX,FloatRec.fdExponent
	SUB	DX,DecimalIndex
@@3:	MOV	DigitPlace,AX
	MOV	DigitDelta,DX
	MOV	DS,Format.seg
	MOV	SI,Section
	LES	DI,Buffer
	LEA	BX,FloatRec.fdDigits
	CMP	FloatRec.fdNegative,0
	JE	@@10
	CMP	SI,Format.ofs
	JNE	@@10
	MOV	AL,'-'
	STOSB
@@10:	LODSB
	CMP	AL,'#'
	JE	@@20
	CMP	AL,'0'
	JE	@@20
	CMP	AL,'.'
	JE	@@10
	CMP	AL,','
	JE	@@10
	CMP	AL,"'"
	JE	@@25
	CMP	AL,'"'
	JE	@@25
	CMP	AL,'E'
	JE	@@30
	CMP	AL,'e'
	JE	@@30
	CMP	AL,';'
	JE	@@40
	OR	AL,AL
	JE	@@40
@@11:	STOSB
	JMP	@@10
@@20:	CALL	PutFmtDigit
	JMP	@@10
@@25:	MOV	AH,AL
@@26:	LODSB
	CMP	AL,AH
	JE	@@10
	OR	AL,AL
	JE	@@40
	STOSB
	JMP	@@26
@@30:	MOV	AH,[SI]
	CMP	AH,'+'
	JE	@@31
	CMP	AH,'-'
	JNE	@@11
	XOR	AH,AH
@@31:	MOV	CX,-1
@@32:	INC	CX
	INC	SI
	CMP	[SI].b0,'0'
	JE	@@32
	CMP	CX,4
	JB	@@33
	MOV	CX,4
@@33:	PUSH	BX
	MOV	BL,FloatRec.fdDigits
	MOV	DX,FloatRec.fdExponent
	SUB	DX,DecimalIndex
	CALL	PutExponent
	POP	BX
	JMP	@@10
@@40:	POP	DS
	MOV	AX,DI
	SUB	AX,Buffer.ofs
	RET

; Store formatted digit

PutFmtDigit:

	CMP	DigitDelta,0
	JE	@@3
	JL	@@2
@@1:	CALL	@@3
	DEC	DigitDelta
	JNE	@@1
	JMP	SHORT @@3
@@2:	INC	DigitDelta
	MOV	AX,DigitPlace
	CMP	AX,FirstDigit
	JLE	@@4
	JMP	SHORT @@7
@@3:	MOV	AL,SS:[BX]
	INC	BX
	OR	AL,AL
	JNE	@@5
	DEC	BX
	MOV	AX,DigitPlace
	CMP	AX,LastDigit
	JLE	@@7
@@4:	MOV	AL,'0'
@@5:	CMP	DigitPlace,0
	JNE	@@6
	MOV	AH,AL
	MOV	AL,Separators.b1
	STOSW
	JMP	SHORT @@7
@@6:	STOSB
	CMP	ThousandSep,0
	JE	@@7
	MOV	AX,DigitPlace
	CMP	AX,1
	JLE	@@7
	MOV	DL,3
	DIV	DL
	CMP	AH,1
	JNE	@@7
	MOV	AL,Separators.b0
	STOSB
@@7:	DEC	DigitPlace
	RET

; procedure FloatToDecimal(var Result: TFloatDecimal; Value: Extended;
;   Precision, Decimals: Integer);

FloatToDecimal:

	ARG	Result,DWORD,1
	ARG	Value,TBYTE,1
	ARG	Precision,WORD,1
	ARG	Decimals,WORD,1
	LOC	CtrlWord,WORD,1
	LOC	StatWord,WORD,1
	LOC	Exponent,WORD,1
	LOC	Sign,WORD,1
	LOC	BCDValue,TBYTE,1

	ENTRY   FAR
	FSTCW	CtrlWord
	FLDCW	CWNear
	LES	DI,Result
	MOV	AX,Value.w8
	MOV	Sign,AX
	MOV	DX,AX
	AND	AX,7FFFH
	JE	@@1
	CMP	AX,7FFFH
	JNE	@@10
	CMP	Value.w6,8000H
	JE	@@2
	INC	AX
@@1:	XOR	DX,DX
@@2:	MOV	ES:[DI].fdDigits,0
	JMP	@@31
@@10:	MOV	Value.w8,AX
	FLD	Value
	SUB	AX,3FFFH
	MOV	DX,19728
	IMUL	DX
	INC	DX
	MOV	Exponent,DX
	MOV	AX,18
	SUB	AX,DX
	CALL	Power10
	FRNDINT
	FLD	FCon1E18
	FCOMP
	FSTSW	StatWord
	FWAIT
	TEST	StatWord,mC0+mC3
	JE	@@11
	FIDIV	DCon1E1
	INC	Exponent
@@11:	LES	DI,Result
	ADD	DI,OFFSET fdDigits
    IF WindowsVersion
	CMP	BYTE PTR CS:@@12,0CDH
	JNE	@@12
	CALL	FStoreBCD
	JMP	SHORT @@20
    ENDIF
@@12:	FBSTP	BCDValue
	MOV	CL,4
	MOV	SI,9
	FWAIT
@@13:	MOV	AL,BCDValue[SI-1].b0
	MOV	AH,AL
	SHR	AL,CL
	AND	AH,0FH
	ADD	AX,'00'
	STOSW
	DEC	SI
	JNE	@@13
	XOR	AL,AL
	STOSB
@@20:	LES	DI,Result
	MOV	BX,Decimals
	ADD	BX,Exponent
	JNS	@@21
@@29:	XOR	AX,AX
	JMP	@@1
@@21:	CMP	BX,Precision
	JB	@@22
	MOV	BX,Precision
@@22:	CMP	BX,18
	JAE	@@26
	CMP	ES:[DI].fdDigits[BX],'5'
	JB	@@25
@@23:	MOV	ES:[DI].fdDigits[BX],0
	DEC	BX
	JS	@@24
	INC	ES:[DI].fdDigits[BX]
	CMP	ES:[DI].fdDigits[BX],'9'
	JA	@@23
	JMP	SHORT @@30
@@24:	MOV	ES:[DI].fdDigits.w0,'1'
	INC	Exponent
	JMP	@@30
@@26:	MOV	BX,18
@@25:	MOV	ES:[DI].fdDigits[BX],0
	DEC	BX
	JS	@@29
	CMP	ES:[DI].fdDigits[BX],'0'
	JE	@@25
@@30:	MOV	AX,Exponent
	MOV	DX,Sign
@@31:	MOV	ES:[DI].fdExponent,AX
	XOR	AX,AX
	ADD	DX,DX
	ADC	AX,AX
	MOV	ES:[DI].fdNegative,AL
	FCLEX
	FLDCW	CtrlWord
	FWAIT
	EXIT

; function TextToFloat(Buffer: PChar; var Value: Extended): Boolean;

TextToFloat:

	ARG	Buffer,DWORD,1
	ARG	Value,DWORD,1
	LOC	CtrlWord,WORD,1
	LOC	TempWord,WORD,1
	LOC	SignChar,BYTE,2
	LOC	Temporary,TBYTE,1

	ENTRY	FAR
	FSTCW	CtrlWord
	FCLEX
	FLDCW	CWNear
	FLDZ
	PUSH	DS
	MOV	CL,DS:DecimalSeparator
	LDS	SI,Buffer
	CLD
	CALL	SkipBlanks
	MOV	AL,[SI]
	MOV	SignChar,AL
	CMP	AL,'+'
	JE	@@1
	CMP	AL,'-'
	JNE	@@2
@@1:	INC	SI
@@2:	MOV	DX,SI
	CALL	GetDigitStr
	XOR	BX,BX
	CMP	CL,[SI]
	JNE	@@3
	INC	SI
	CALL	GetDigitStr
	NEG	BX
@@3:	CMP	SI,DX
	JE	@@6
	MOV	AL,[SI]
	AND	AL,0DFH
	CMP	AL,'E'
	JNE	@@4
	INC	SI
	PUSH	BX
	CALL	GetExponent
	POP	BX
	ADD	BX,AX
@@4:	CALL	SkipBlanks
	CMP	[SI].b0,0
	JNE	@@6
	MOV	AX,BX
	CALL	Power10
	CMP	SignChar,'-'
	JNE	@@5
	FCHS
@@5:	FSTSW	TempWord
	FWAIT
	TEST	TempWord,mIE+mOE
	JE	@@7
@@6:	FSTP	Temporary		;FSTP ST(0)
	XOR	AX,AX
	JMP	SHORT @@8
@@7:	LES	DI,Value
	FSTP	TBYTE PTR ES:[DI]
	MOV	AL,1
@@8:	POP	DS
	FCLEX
	FLDCW	CtrlWord
	FWAIT
	EXIT

; Skip blanks

SkipBlanks:

@@1:	LODSB
	CMP	AL,' '
	JE	@@1
	DEC	SI
	RET

; Process string of digits
; Out	BX = Digit count

GetDigitStr:

	XOR	BX,BX
@@1:	LODSB
	SUB	AL,'0'+10
	ADD	AL,10
	JNC	@@2
	FIMUL	DCon1E1
	CBW
	MOV	TempWord,AX
	FIADD	TempWord
	INC	BX
	JMP	@@1
@@2:	DEC	SI
	RET

; Get exponent
; Out	AX = Exponent (-4999..4999)

GetExponent:

	XOR	AX,AX
	MOV	BL,[SI]
	CMP	BL,'+'
	JE	@@1
	CMP	BL,'-'
	JNE	@@2
@@1:	INC	SI
@@2:	MOV	CL,[SI]
	SUB	CL,'0'+10
	ADD	CL,10
	JNC	@@3
	MOV	DX,10
	MUL	DX
	XOR	CH,CH
	ADD	AX,CX
	INC	SI
	CMP	AX,500
	JB	@@2
@@3:	CMP	BL,'-'
	JNE	@@4
	NEG	AX
@@4:	RET

; Multiply ST(0) by 10^AX
; In	AX = Power of 10

Power10:

	CMP	AX,4096
	JLE	@@1
	FLD	FCon1E4096
	FMUL
	SUB	AX,4096
@@1:	CMP	AX,-4096
	JGE	@@2
	FLD	FCon1E4096
	CALL	FSafeDivide
	ADD	AX,4096
@@2:	MOV	BX,AX
	OR	AX,AX
	JE	@@8
	JNS	@@3
	NEG	AX
@@3:	MOV	SI,AX
	AND	SI,7
	SHL	SI,1
	SHL	SI,1
	FILD	DCon1E0[SI]
	SHR	AX,1
	SHR	AX,1
	SHR	AX,1
	MOV	SI,OFFSET FCon1E8
	JMP	SHORT @@6
@@4:	SHR	AX,1
	JNC	@@5
	FLD	TBYTE PTR CS:[SI]
	FMUL
@@5:	ADD	SI,10
@@6:	OR	AX,AX
	JNE	@@4
	OR	BX,BX
	JS	@@7
	FMUL
	RET
@@7:	CALL	FSafeDivide
@@8:	RET

    IF WindowsVersion

; Store ST(0) as 18 decimal digits
; In	ES:DI = Digit buffer pointer

FStoreBCD:

	MOV	ES:[DI+18].b0,0
	ADD	DI,16
	STD
	SUB	SP,8
	MOV	SI,SP
	FISTP	QWORD PTR SS:[SI]
	FWAIT
	POP	BX
	POP	CX
	POP	AX
	POP	DX
	MOV	SI,10000
	DIV	SI		;CX:BX:AX = DX:AX:CX:BX div 10000
	XCHG	AX,CX
	DIV	SI
	XCHG	AX,BX
	DIV	SI
	CALL	StoreDigits
	XOR	DX,DX		;BX:CX:AX = CX:BX:AX div 10000
	XCHG	AX,CX
	DIV	SI
	XCHG	AX,BX
	DIV	SI
	XCHG	AX,CX
	DIV	SI
	CALL	StoreDigits
	MOV	DX,BX		;CX:AX = BX:CX:AX div 10000
	XCHG	AX,CX
	DIV	SI
	XCHG	AX,CX
	DIV	SI
	CALL	StoreDigits
	MOV	DX,CX		;AX = CX:AX div 10000
	DIV	SI
	CALL	StoreDigits
	AAM
	XCHG	AL,AH
	ADD	AX,'00'
	STOSW
	CLD
	RET

; Store four BCD digits

StoreDigits:

	PUSH	AX
	MOV	AL,100
	XCHG	AX,DX
	DIV	DL
	MOV	DL,AH
	AAM
	ADD	AX,'00'
	XCHG	AL,AH
	XCHG	AX,DX
	AAM
	ADD	AX,'00'
	XCHG	AL,AH
	STOSW
	XCHG	AX,DX
	STOSW
	POP	AX
	RET

    ENDIF

CODE	ENDS

	END
