
; *******************************************************
; *							*
; *     Delphi Runtime Library                          *
; *	Pentium-safe floating-point divide support	*
; *							*
; *	Copyright (c) 1995 Borland International	*
; *							*
; *******************************************************

	TITLE	FDIV

	.286

	INCLUDE	SE.ASM

CONST	SEGMENT	WORD PUBLIC

; FDIV constants

FDIVRiscTable	DB	0,1,0,0,4,0,0,7,0,0,10,0,0,13,0,0

FDIVScale1	DD	3F700000H		;0.9375
FDIVScale2	DD	3F880000H		;1.0625
FDIV1SHL63	DD	5F000000H		;1 SHL 63

TestDividend	DQ	4150017EC0000000H	;4195835.0
TestDivisor	DQ	4147FFFF80000000H	;3145727.0
TestOne		DQ	3FF0000000000000H	;1.0

CONST	ENDS

DATA	SEGMENT	WORD PUBLIC

; Externals

	EXTRN	TestFDIV:BYTE

DATA	ENDS

DGROUP	GROUP	CONST,DATA

CODE	SEGMENT	BYTE PUBLIC

	ASSUME	CS:CODE,DS:DGROUP

; Publics

	PUBLIC	FSafeDivide,FSafeDivideR

Dividend	EQU	(TBYTE PTR [BP-10])
Divisor		EQU	(TBYTE PTR [BP-20])

; Flawed FDIV detection

FDivideDetect:

	MOV	TestFDIV,1		;Indicate correct FDIV
    IF WindowsVersion
	CMP	BYTE PTR CS:FSafeDivideR,0CDH ;Emulating?
	JE	FSafeDivide		;Yes, skip
    ELSE
@@1:	FNOP
	CMP	BYTE PTR CS:@@1,0CDH	;Emulating?
	JE	FSafeDivide		;Yes, skip
    ENDIF
    NOEMUL
	PUSH	BP
	MOV	BP,SP
	SUB	SP,10
	PUSH	AX
	FSTP	TBYTE PTR [BP-10]	;Save off ST
	FLD	TestDividend		;Ok if x - (x / y) * y < 1.0
	FWAIT
	FDIV	TestDivisor
	FWAIT
	FMUL	TestDivisor
	FWAIT
	FSUBR	TestDividend
	FWAIT
	FCOMP	TestOne
	FWAIT
	FSTSW	AX
	FWAIT
	AND	AX,0100H		;Zero if FDIV is flawed
	SHR	AX,7
	DEC	AX
	MOV	TestFDIV,AL		;1 means Ok, -1 means flawed
	FLD	TBYTE PTR [BP-10]	;Restore ST
	POP	AX
	MOV	SP,BP
	POP	BP
	JMP	SHORT FSafeDivide
    EMUL

; Floating-point divide reverse routine
; ST(1) = ST(0) / ST(1), pop ST

FSafeDivideR:

	FXCH

; Floating-point divide routine
; ST(1) = ST(1) / ST(0), pop ST

FSafeDivide:

	CMP	TestFDIV,0		;Check FDIV indicator
	JLE	FDivideChecked		;Jump if flawed or don't know
	FDIV				;Known to be ok, so just do FDIV
	RETF

FDivideChecked:

	JE	FDivideDetect		;Do detection if TestFDIV = 0
    NOEMUL
@@1:	PUSH	BP
	MOV	BP,SP
	SUB	SP,20
	PUSH	AX
	FSTP	Divisor			;Store Divisor and Dividend
	FSTP	Dividend
	FLD	Dividend
	FLD	Divisor
@@2:	MOV	AX,Divisor.w6		;Is Divisor a denormal?
	ADD	AX,AX
	JNC	@@20			;Yes, @@20
	XOR	AX,0E00H		;If these three bits are not all
	TEST	AX,0E00H		;ones, FDIV will work
	JZ	@@10			;Jump if all ones
@@3:	FDIV				;Do FDIV and exit
	POP	AX
	MOV	SP,BP
	POP	BP
	RETF
@@10:	SHR	AX,12			;If the four bits following the MSB
	PUSH	BX			;of the mantissa have a decimal
	MOV	BX,AX			;of 1, 4, 7, 10, or 13, FDIV may
	CMP	FDIVRiscTable[BX],0	;not work correctly
	POP	BX
	JZ	@@3			;Do FDIV if not 1, 4, 7, 10, or 13
	MOV	AX,Divisor.w8		;Get Divisor exponent
	AND	AX,7FFFH
	JZ	@@3			;Ok to FDIV if denormal
	CMP	AX,7FFFH
	JE	@@3			;Ok to FDIV if NAN or INF
	MOV	AX,Dividend.w8		;Get Dividend exponent
	AND	AX,7FFFH
	CMP	AX,1			;Small number?
	JE	@@11			;Yes, @@11
	FMUL	FDIVScale1		;Scale by 15/16
	FXCH
	FMUL	FDIVScale1
	FXCH
	JMP	@@3			;FDIV is now safe
@@11:	FMUL	FDIVScale2		;Scale by 17/16
	FXCH
	FMUL	FDIVScale2
	FXCH
	JMP	@@3			;FDIV is now safe
@@20:	MOV	AX,Divisor.w0		;Is entire Divisor zero?
	OR	AX,Divisor.w2
	OR	AX,Divisor.w4
	OR	AX,Divisor.w6
	JZ	@@3			;Yes, ok to FDIV
	MOV	AX,Divisor.w8		;Get Divisor exponent
	AND	AX,7FFFH		;Non-zero exponent is invalid
	JNZ	@@3			;Ok to FDIV if invalid
	MOV	AX,Dividend.w8		;Get Dividend exponent
	AND	AX,7FFFH		;Denormal?
	JZ	@@21			;Yes, @@21
	CMP	AX,7FFFH		;NAN or INF?
	JE	@@3			;Yes, ok to FDIV
	MOV	AX,Dividend.w6		;If MSB of mantissa is zero, the
	ADD	AX,AX			;number is invalid
	JNC	@@3			;Ok to FDIV if invalid
	JMP	SHORT @@22
@@21:	MOV	AX,Dividend.w6		;If MSB of mantissa is non-zero, the
	ADD	AX,AX			;number is invalid
	JC	@@3			;Ok to FDIV if invalid
@@22:	FXCH				;Scale stored Divisor image by
	FSTP	ST(0)			;1 SHL 63 and restart
	FLD	ST(0)
	FMUL	FDIV1SHL63
	FSTP	Divisor
	FLD	Dividend
	FXCH
	FWAIT
	JMP	@@2
    EMUL

	RETF

CODE	ENDS

	END
