
{*******************************************************}
{                                                       }
{       Delphi Visual Component Library                 }
{                                                       }
{       Copyright (c) 1995 Borland International        }
{                                                       }
{*******************************************************}

unit Pageinfo;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls;

type
  TPageInfoDlg = class(TForm)
    edPageName: TEdit;
    edPageContext: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    procedure OKClick(Sender: TObject);
  private
    { Private declarations }
    procedure SetPageName(const Name: string);
    function GetPageName: string;
    procedure SetPageContext(Context: THelpContext);
    function GetPageContext: THelpContext;
  public
    { Public declarations }
    property PageName: string read GetPageName write SetPageName;
    property PageContext: THelpContext read GetPageContext write SetPageContext;
  end;

implementation

uses SysUtils;

{$R *.DFM}

procedure TPageInfoDlg.SetPageName(const Name: string);
begin
  edPageName.Text := Name;
  edPageName.SelectAll;
end;

function TPageInfoDlg.GetPageName: string;
begin
  Result := edPageName.Text;
end;

procedure TPageInfoDlg.SetPageContext(Context: THelpContext);
begin
  edPageContext.Text := IntToStr(Context);
  edPageContext.SelectAll;
end;

function TPageInfoDlg.GetPageContext: THelpContext;
begin
  Result := StrToInt(edPageContext.Text);
end;

procedure TPageInfoDlg.OKClick(Sender: TObject);
var
  H: THelpContext;
begin
  try
    H := StrToInt(edPageContext.Text);
  except
    ModalResult := 0;
    ActiveControl := edPageContext;
    edPageContext.SelectAll;
    raise;
  end;
end;

end.
