
{*******************************************************}
{                                                       }
{       Delphi Visual Component Library                 }
{                                                       }
{       Copyright (c) 1995 Borland International        }
{                                                       }
{*******************************************************}

unit PageEdit;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Grids,
  Buttons, StdCtrls, ExtCtrls;

type
  TNotebookEditDlg = class(TForm)
    Header1: THeader;
    Grid: TDrawGrid;
    EditButton: TButton;
    AddButton: TButton;
    DeleteButton: TButton;
    CloseButton: TBitBtn;
    DownButton: TBitBtn;
    UpButton: TBitBtn;
    HelpBtn: TBitBtn;
    procedure GridDrawCell(Sender: TObject; Col, Row: Longint; Rect: TRect;
      State: TGridDrawState);
    procedure FormCreate(Sender: TObject);
    procedure MoveClick(Sender: TObject);
    procedure EditClick(Sender: TObject);
    procedure AddClick(Sender: TObject);
    procedure DeleteClick(Sender: TObject);
    procedure HeaderSized(Sender: TObject; ASection, AWidth: Integer);
  private
    { Private declarations }
    PageList: TStrings;
  public
    { Public declarations }
    Modified: Boolean;
    procedure SetPageList(Value: TStrings);
  end;

implementation

{$R *.DFM}

uses SysUtils, PageInfo, Dialogs, LibConst, LibHelp;

procedure TNotebookEditDlg.SetPageList(Value: TStrings);
begin
  PageList := Value;
  Grid.RowCount := PageList.Count;
end;

procedure TNotebookEditDlg.GridDrawCell(Sender: TObject; Col, Row: Longint;
  Rect: TRect; State: TGridDrawState);
var
  R: TRect;
  C: array[0..255] of Char;
  W: TWinControl;
begin
  if Row < PageList.Count then
  begin
    R := Rect;
    Rect.Right := Rect.Left + Header1.SectionWidth[0];
    ExtTextOut(Grid.Canvas.Handle, Rect.Left + 2, Rect.Top + 2, ETO_CLIPPED,
      @Rect, StrPCopy(C, PageList[Row]), Length(PageList[Row]), nil);
    Rect.Left := Rect.Right + 1;
    Rect.Right := R.Right;
    W := PageList.Objects[Row] as TWinControl;
    ExtTextOut(Grid.Canvas.Handle, Rect.Left + 2, Rect.Top + 2, ETO_CLIPPED,
      @Rect, StrPCopy(C, IntToStr(W.HelpContext)),
      StrLen(C), nil);
  end;
end;

procedure TNotebookEditDlg.FormCreate(Sender: TObject);
begin
  HelpContext := hcDNotebookEditor;
  Grid.DefaultRowHeight := Grid.Canvas.TextHeight('W');
  Grid.DefaultColWidth := Grid.ClientWidth;
end;

procedure TNotebookEditDlg.MoveClick(Sender: TObject);
var
  NewIndex: Integer;
begin
  NewIndex := Grid.Row;
  if Sender = UpButton then Dec(NewIndex)
  else Inc(NewIndex);
  if (NewIndex >= 0) and (NewIndex < PageList.Count) then
  begin
    PageList.Move(Grid.Row, NewIndex);
    Grid.Row := NewIndex;
    Grid.Invalidate;
  end;
  Grid.SetFocus;
  Modified := True;
end;

procedure TNotebookEditDlg.EditClick(Sender: TObject);
var
  D: TPageInfoDlg;
  W: TWinControl;
begin
  { edit the current entry }
  D := TPageInfoDlg.Create(Application);
  try
    W := PageList.Objects[Grid.Row] as TWinControl;

    D.Caption := LoadStr(sEditPage);
    D.PageName := PageList[Grid.Row];
    D.PageContext := W.HelpContext;
    D.HelpContext := hcDEditNotebookPage;
    if D.ShowModal = mrOK then
    begin
      PageList[Grid.Row] := D.PageName;
      W.HelpContext := D.PageContext;
      Grid.Invalidate;
      Modified := True;
    end;
  finally
    D.Free;
  end;
end;

procedure TNotebookEditDlg.AddClick(Sender: TObject);
var
  D: TPageInfoDlg;
  W: TWinControl;
begin
  { add a new entry }
  D := TPageInfoDlg.Create(Application);
  try
    D.Caption := LoadStr(sAddPage);
    D.PageName := '';
    D.PageContext := 0;
    D.HelpContext := hcDAddNoteBookPage;
    if D.ShowModal = mrOK then
    begin
      PageList.Add(D.PageName);
      W := PageList.Objects[PageList.Count - 1] as TWinControl;
      W.HelpContext := D.PageContext;
      Grid.RowCount := PageList.Count;
      Grid.DefaultColWidth := Grid.ClientWidth; { in case scrollbar appears }
      Grid.Invalidate;
      Modified := True;
    end;
  finally
    D.Free;
  end;
end;

procedure TNotebookEditDlg.DeleteClick(Sender: TObject);
begin
  { delete the current entry }
  if Grid.RowCount = 1 then
  begin
    MessageDlg(LoadStr(sOnePage), mtInformation, [mbOK], 0);
    Exit;
  end;

  if MessageDlg(FmtLoadStr(sQDelete, [PageList[Grid.Row]]), mtConfirmation,
    [mbYes, mbNo], 0) = mrYes then
  begin
    PageList.Delete(Grid.Row);
    Grid.RowCount := PageList.Count;
    Grid.DefaultColWidth := Grid.ClientWidth; { in case scrollbar disappears }
    Grid.Invalidate;
    Modified := True;
  end;
end;

procedure TNotebookEditDlg.HeaderSized(Sender: TObject; ASection,
  AWidth: Integer);
begin
  Grid.Repaint;
end;

end.
