
{*******************************************************}
{                                                       }
{       Delphi Visual Component Library                 }
{                                                       }
{       Copyright (c) 1995 Borland International        }
{                                                       }
{*******************************************************}

unit MaskText;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, StdCtrls,
     Buttons, DsgnIntf, Mask;

type

{ TMaskTextProperty
  Property editor for the Caption and Text properties.  Removes auto-update
  feature of normal text property to allow validation. }

  TMaskTextProperty = class(TStringProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
  end;

type
  TMaskTextForm = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    HelpBtn: TBitBtn;
    Label3:    TLabel;
    TestEdit:  TMaskEdit;
    Label1: TLabel;
    EditMask: TLabel;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MaskTextForm: TMaskTextForm;

implementation

uses SysUtils, LibHelp;

{$R *.DFM}

{-----------}
{ TMaskTextForm }
procedure TMaskTextForm.FormCreate(Sender: TObject);
begin
  HelpContext := hcDMaskedTextEditor;
end;

{-----------}
{ TMaskTextProperty }

function TMaskTextProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog];
end;

procedure TMaskTextProperty.Edit;
var
  Ed  : TMaskEdit;
  Frm : TMaskTextForm;
  Str : String;
begin
  Ed := TMaskEdit (GetComponent(0));
  Frm := TMaskTextForm.Create (Application);
  try
    Frm.TestEdit.EditMask  := Ed.EditMask;
    Frm.TestEdit.Text      := Ed.Text;
    Frm.TestEdit.SelectAll;

    if Ed.EditMask <> EmptyStr then
      Frm.EditMask.Caption := Ed.EditMask;

    if Frm.ShowModal = idOK then
    begin
      Ed.Text := Frm.TestEdit.Text;
    end;
  finally
    Frm.Free;
  end;
end;


{------}

end.

