{
  Status dialog for RCEXPERT resource compiler.

  Copyright (c) 1995 by Borland International
}
unit Rcstatus;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Buttons, rcimport;

const    { application-defined message }
  am_RCStatusDoWork = wm_User + 101;

type
  TRCCompileStatus = class(TForm)
    GroupBox1: TGroupBox;
    RCFile: TLabel;
    GroupBox2: TGroupBox;
    ActionLabel: TLabel;
    CurrentFile: TLabel;
    GroupBox3: TGroupBox;
    CurrentLine: TLabel;
    GroupBox4: TGroupBox;
    TotalLinesLabel: TLabel;
    CancelBtn: TBitBtn;
  private
    { Private declarations }
    FWorkProc: TNotifyEvent;
    procedure DoWork(var M); message am_RCStatusDoWork;
  public
    { Public declarations }
    TotalLines: Longint;
    procedure ShowStatus(Sender: TObject; MsgType: TRCStatusType;
                         const Msg: String; MoreLines: Integer);
    function Execute(WorkProc: TNotifyEvent): Integer;
  end;

implementation

{$R *.DFM}

procedure TRCCompileStatus.ShowStatus(Sender: TObject;
                                      MsgType: TRCStatusType;
                                      const Msg: String;
                                      MoreLines: Integer);
begin
  case MsgType of
    stProjectName: RCFile.Caption := UpperCase(Msg);
    stActionLabel: ActionLabel.Caption := Msg;
    stFileName   : CurrentFile.Caption := UpperCase(Msg);
  end;
  if Assigned(Sender) and (Sender is TRCParser) then
    CurrentLine.Caption := IntToStr(TRCParser(Sender).CurrentLine);
  Inc(TotalLines, MoreLines);
  TotalLinesLabel.Caption := IntToStr(TotalLines);
  Application.ProcessMessages;
end;

function TRCCompileStatus.Execute(WorkProc: TNotifyEvent): Integer;
begin
  if Assigned(FWorkProc) then
    raise EInvalidOperation.Create('RCStatus dialog already executing.');
  FWorkProc := WorkProc;
  try
    PostMessage(Handle, am_RCStatusDoWork, 0, 0);
    Result := ShowModal;
  finally
    FWorkProc := nil;
  end;
end;

procedure TRCCompileStatus.DoWork(var M);
begin
  try
    try
      if Assigned(FWorkProc) then
        FWorkProc(Self);
      ActionLabel.Caption := 'Done.';
    except
      ActionLabel.Caption := 'Aborted with errors.';
      raise;
    end;
  finally
    if ModalResult <> mrCancel then
    begin            { Change Cancel button to Ok, wait for user to click }
      CancelBtn.Kind := bkOk;
      CurrentFile.Hide;
      BringToFront;
    end;
  end;
end;


end.
