Option Explicit

Global Const A4WidthInTwips = 11905 '21cm in twips
Global Const A4LengthInTwips = 15307 '27cm in twips
Global Const TWIPS_IN_MM = 56.7
Global Const TWIPS_IN_CM = 567

Type FormState
    Deleted As Integer
    Dirty As Integer
    Ignore As Integer
End Type

Global FState()  As FormState
Global Document() As New frmMDIChild
Global gFindString, gFindCase As Integer, gFindDirection As Integer
Global gCurPos As Integer, gFirstTime As Integer
Global ArrayNum As Integer

' API functions used to read and write to MDINOTE.INI.
' Used for handling the recent files list.
Declare Function GetPrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer, ByVal lpFileName As String) As Integer
Declare Function WritePrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpString As String, ByVal lplFileName As String) As Integer

'-------------------------------------------------------------------------
' AnyPadsLeft
'
' looks for an free entry in the document array
'-------------------------------------------------------------------------
Function AnyPadsLeft () As Integer
    Dim i As Integer

    ' Cycle throught the document array.
    ' Return True if there is at least one
    ' open document remaining.
    For i = 1 To UBound(Document)
        If Not FState(i).Deleted Then
            AnyPadsLeft = True
            Exit Function
        End If
    Next
End Function

'-------------------------------------------------------------------------
' EditCopyProc
'
' copies selected contents to clipboard
'-------------------------------------------------------------------------
Sub EditCopyProc ()
    frmMDIParent.ActiveForm.TextControl1.Clip = CLIP_COPY
End Sub

'-------------------------------------------------------------------------
' EditCutProc
'
' cuts selected contents to clipboard
'-------------------------------------------------------------------------
Sub EditCutProc ()
    frmMDIParent.ActiveForm.TextControl1.Clip = CLIP_CUT
End Sub

'-------------------------------------------------------------------------
' EditDeleteProc
'
' deletes selected contents (or next character)
'-------------------------------------------------------------------------
Sub EditDeleteProc ()
    frmMDIParent.ActiveForm.TextControl1.Clip = CLIP_CLEAR
End Sub

'-------------------------------------------------------------------------
' EditFindReplaceProc
'
' calls find or replace dialog
'
' Parameters: 1 find dialog
'             2 replace dialog
'-------------------------------------------------------------------------
Sub EditFindReplaceProc (Flag As Integer)
    frmMDIParent.ActiveForm.TextControl1.FindReplace = Flag
End Sub

'-------------------------------------------------------------------------
' EditPasteProc
'
' pastes clipboard data
'-------------------------------------------------------------------------
Sub EditPasteProc ()
    ' Place text from Clipboard into active control.
    frmMDIParent.ActiveForm.TextControl1.Clip = CLIP_PASTE
End Sub

'-------------------------------------------------------------------------
' EditSelectAll
'
' selects whole contents
'-------------------------------------------------------------------------
Sub EditSelectAll ()
    Dim nPointer As Integer     'MousePointer proterty value

    nPointer = frmMDIParent.ActiveForm.TextControl1.MousePointer
    frmMDIParent.ActiveForm.TextControl1.MousePointer = 11
    frmMDIParent.ActiveForm.TextControl1.SelStart = 0
    frmMDIParent.ActiveForm.TextControl1.SelLength = -1
    frmMDIParent.ActiveForm.TextControl1.MousePointer = nPointer
End Sub

'-------------------------------------------------------------------------
' EnableToolbarButtons
'
'-------------------------------------------------------------------------
Sub EnableToolbarButtons ()
    If AnyPadsLeft() Then
        frmMDIParent!imgFileSaveButton.Picture = frmMDIParent!imgFileSaveButtonUp.Picture
        frmMDIParent!imgFileSaveButton.Enabled = True
        frmMDIParent!imgCutButton.Picture = frmMDIParent!imgCutButtonUp.Picture
        frmMDIParent!imgCutButton.Enabled = True
        frmMDIParent!imgCopyButton.Picture = frmMDIParent!imgCopyButtonUp.Picture
        frmMDIParent!imgCopyButton.Enabled = True
        frmMDIParent!imgPasteButton.Picture = frmMDIParent!imgPasteButtonUp.Picture
        frmMDIParent!imgPasteButton.Enabled = True
    Else
        frmMDIParent!imgFileSaveButton.Picture = frmMDIParent!imgFileSaveButtonDis.Picture
        frmMDIParent!imgFileSaveButton.Enabled = False
        frmMDIParent!imgCutButton.Picture = frmMDIParent!imgCutButtonDis.Picture
        frmMDIParent!imgCutButton.Enabled = False
        frmMDIParent!imgCopyButton.Picture = frmMDIParent!imgCopyButtonDis.Picture
        frmMDIParent!imgCopyButton.Enabled = False
        frmMDIParent!imgPasteButton.Picture = frmMDIParent!imgPasteButtonDis.Picture
        frmMDIParent!imgPasteButton.Enabled = False
    End If
End Sub

'-------------------------------------------------------------------------
' FileNewProc
'
' inits new window
'-------------------------------------------------------------------------
Sub FileNewProc ()
    Dim fIndex As Integer

    fIndex = FindFreeIndex()
    If fIndex <> 0 Then
        Document(fIndex).Tag = fIndex
        Document(fIndex).Caption = "Untitled:" & fIndex
        Document(fIndex).TXRuler1.ScaleUnits = SCALE_MM
        Document(fIndex).Show

        ' Make sure toolbar edit buttons are visible
        frmMDIParent!imgCutButton.Visible = True
        frmMDIParent!imgCopyButton.Visible = True
        frmMDIParent!imgPasteButton.Visible = True
    End If
    
End Sub

'-------------------------------------------------------------------------
' FindFreeIndex
'
'-------------------------------------------------------------------------
Function FindFreeIndex () As Integer
    Dim i As Integer
    Dim ArrayCount As Integer

    ArrayCount = UBound(Document)

    ' Cycle throught the document array. If one of the
    ' documents has been deleted, then return that
    ' index.
    For i = 1 To ArrayCount
        If FState(i).Deleted Then
            FindFreeIndex = i
            FState(i).Deleted = False
            FState(i).Ignore = False
            Exit Function
        End If
    Next

    ' If none of the elements in the document array have
    ' been deleted, then increment the document and the
    ' state arrays by one and return the index to the
    ' new element.

    ReDim Preserve Document(ArrayCount + 1)
    ReDim Preserve FState(ArrayCount + 1)
    FindFreeIndex = UBound(Document)
End Function

'-------------------------------------------------------------------------
' FormatColorProc
'
' sets text or background color
'-------------------------------------------------------------------------
Sub FormatColorProc (Index As Integer)
    Dim lOldColor As Long

    On Error Resume Next

    If Index = COLOR_TEXT Then
        lOldColor = frmMDIParent.ActiveForm.TextControl1.TextColor
    Else
        lOldColor = frmMDIParent.ActiveForm.TextControl1.BackColor
    End If

    If lOldColor = -1 Then
        frmMDIParent.CMDialog1.Color = 0  'use black if different colors
    Else
        frmMDIParent.CMDialog1.Color = lOldColor
    End If

    frmMDIParent.CMDialog1.Flags = CC_RGBINIT Or CC_PREVENTFULLOPEN
    frmMDIParent.CMDialog1.CancelError = True
    frmMDIParent.CMDialog1.Action = DLG_COLOR
    If Err Then Exit Sub

    'set new color

    If lOldColor = -1 Or frmMDIParent.CMDialog1.Color <> lOldColor Then
        If Index = COLOR_TEXT Then
            frmMDIParent.ActiveForm.TextControl1.TextColor = frmMDIParent.CMDialog1.Color
        Else
            frmMDIParent.ActiveForm.TextControl1.BackColor = frmMDIParent.CMDialog1.Color
        End If
    End If
End Sub

'-------------------------------------------------------------------------
' FormatDocProc
'
' calls the document format dialog
'-------------------------------------------------------------------------
Sub FormatDocProc ()
    frmDocDlg.Show 1
End Sub

'-------------------------------------------------------------------------
' FormatFramesProc
'
' calls the paragraph frames dialog
'-------------------------------------------------------------------------
Sub FormatFramesProc ()
    frmFramesDlg.Show 1
End Sub

'-------------------------------------------------------------------------
' ResizeChild
'
' resizes the current text window
'-------------------------------------------------------------------------
Sub ResizeChild (FrmCurrent As Form)
    'Resize TX window when MDI child is resized.
    'Do not resize if window is too small.

    If FrmCurrent.WindowState <> 1 Then
        FrmCurrent!TextControl1.Width = FrmCurrent.ScaleWidth
        FrmCurrent!TXButtonBar1.Width = FrmCurrent.ScaleWidth
        FrmCurrent!TXRuler1.Width = FrmCurrent.ScaleWidth
        If (FrmCurrent!TXButtonBar1.Visible) And (FrmCurrent!TXRuler1.Visible) Then
            FrmCurrent!TextControl1.Top = FrmCurrent.ScaleTop + (FrmCurrent!TXButtonBar1.Height + FrmCurrent!TXRuler1.Height)
            FrmCurrent!TextControl1.Height = FrmCurrent.ScaleHeight - (FrmCurrent!TXButtonBar1.Height + FrmCurrent!TXRuler1.Height)
        ElseIf (FrmCurrent!TXButtonBar1.Visible) And Not (FrmCurrent!TXRuler1.Visible) Then
            FrmCurrent!TextControl1.Top = FrmCurrent.ScaleTop + FrmCurrent!TXButtonBar1.Height
            FrmCurrent!TextControl1.Height = FrmCurrent.ScaleHeight - FrmCurrent!TXButtonBar1.Height
        ElseIf Not (FrmCurrent!TXButtonBar1.Visible) And (FrmCurrent!TXRuler1.Visible) Then
            FrmCurrent!TextControl1.Top = FrmCurrent.ScaleTop + FrmCurrent!TXRuler1.Height
            FrmCurrent!TextControl1.Height = FrmCurrent.ScaleHeight - FrmCurrent!TXRuler1.Height
        Else
            FrmCurrent!TextControl1.Top = FrmCurrent.ScaleTop
            FrmCurrent!TextControl1.Height = FrmCurrent.ScaleHeight
        End If
    End If

End Sub

'-------------------------------------------------------------------------
' ViewParagraphBarProc
'
' switches button bar visible state
'-------------------------------------------------------------------------
Sub ViewParagraphBarProc (FrmCurrent As Form)
    FrmCurrent!TXButtonBar1.Visible = Not FrmCurrent!TXButtonBar1.Visible
    FrmCurrent!mnuView_ParagraphBar.Checked = FrmCurrent!TXButtonBar1.Visible
    If (FrmCurrent!TXButtonBar1.Visible) Then
        FrmCurrent!TXButtonBar1.Top = 0
        If (FrmCurrent!TXRuler1.Visible) Then
            FrmCurrent!TXRuler1.Top = FrmCurrent!TXButtonBar1.Top + FrmCurrent!TXButtonBar1.Height
        End If
    Else
        If (FrmCurrent!TXRuler1.Visible) Then
            FrmCurrent!TXRuler1.Top = 0
        End If
    End If
    ResizeChild FrmCurrent
End Sub

'-------------------------------------------------------------------------
' ViewRulerProc
'
' switches the ruler visible state
'-------------------------------------------------------------------------
Sub ViewRulerProc (FrmCurrent As Form)
    FrmCurrent!TXRuler1.Visible = Not FrmCurrent!TXRuler1.Visible
    FrmCurrent!mnuView_Ruler.Checked = FrmCurrent!TXRuler1.Visible
    If (FrmCurrent!TXButtonBar1.Visible) Then
        FrmCurrent!TXButtonBar1.Top = 0
        If (FrmCurrent!TXRuler1.Visible) Then
            FrmCurrent!TXRuler1.Top = FrmCurrent!TXButtonBar1.Top + FrmCurrent!TXButtonBar1.Height
        End If
    Else
        If (FrmCurrent!TXRuler1.Visible) Then
            FrmCurrent!TXRuler1.Top = 0
        End If
    End If
    ResizeChild FrmCurrent
End Sub

'-------------------------------------------------------------------------
' ViewStatusBarProc
'
' switches the status bar visible state
'-------------------------------------------------------------------------
Sub ViewStatusBarProc (FrmCurrent As Form)
    frmMDIParent!TXStatusBar1.Visible = Not frmMDIParent!TXStatusBar1.Visible
    FrmCurrent!mnuView_StatusBar.Checked = frmMDIParent!TXStatusBar1.Visible
End Sub

'-------------------------------------------------------------------------
' ViewToolBarProc
'
' switches the toolbar visible state
'-------------------------------------------------------------------------
Sub ViewToolBarProc (FrmCurrent As Form)
    frmMDIParent!picToolbar.Visible = Not frmMDIParent!picToolbar.Visible
    FrmCurrent!mnuView_Toolbar.Checked = frmMDIParent!picToolbar.Visible
    frmMDIParent!picToolbar.Top = 0
End Sub

