unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, VBXCtrl, Mhcd200, StdCtrls;

type
  TForm1 = class(TForm)
    MhCardDeck2: TMhCardDeck;
    MhCardDeck3: TMhCardDeck;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    procedure MhCardDeck2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    NumTurned: integer;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
var
  CardArray: array[1..52] of boolean;
  { Clubs = 1 - 13, Diamonds = 14 - 26,
    Hearts = 27 - 39, Spades = 40 - 52 }

{$R *.DFM}

procedure TForm1.MhCardDeck2Click(Sender: TObject);
var
  value: integer;
begin
  repeat
    value := random(52) + 1;
  until CardArray[Value] <> true;

  CardArray[Value] := true;

  if Value <= 13 then
  begin
    MhCardDeck3.Suit := 0;
    MhCardDeck3.Value := Value;
  end
  else if Value <= 26 then
  begin
    MhCardDeck3.Suit := 1;
    MhCardDeck3.Value := Value - 13;
  end
  else if Value <= 39 then
  begin
    MhCardDeck3.Suit := 2;
    MhCardDeck3.Value := Value - 26;
  end
  else
  begin
    MhCardDeck3.Suit := 3;
    MhCardDeck3.Value := Value - 39;
  end;
  MhCardDeck3.Visible := true;
  inc(NumTurned);

  if NumTurned = 52 then
    MhCardDeck2.Visible := false;
  Label3.Caption := IntToStr(StrToInt(Label3.Caption)-1);
  Label4.Caption := IntToStr(StrToInt(Label4.Caption)+1);
end;

procedure TForm1.FormCreate(Sender: TObject);
var
 i: integer;
begin
  for i := 1 to 52 do
    CardArray[i] := false;
  Randomize;
  NumTurned := 0;
  Label3.Caption := '52';
  Label4.Caption := '0';
end;

end.
