
#	
#	Table and Index definitions for BOOKSHOP database
#	
#	Copyright 1993, Coromandel Industries, Inc.
#

#	
#	TITLES table:  Maintains information about the titles 
#	in the bookshop. 
# 

# Drop Table TITLES Cascade ;

Create Table TITLES (
	ISBN		Character(13) Not Null, # ISBN of book - 
						# Primary Key
	Title		Character(50) Not Null,	# Book title
	Author		Character(128),		# Author Name(s);  if 
						# there is more than
						# one, separate each
						# name using a comma
	Publisher	Character(20),		# Publisher name
	Stock		Integer,		# Available stock of title
	Price		Numeric(10,2),		# Selling price of title
	Discount	Smallint,		# Discount percentage.
						# Used only 
						# if OnSale is 1
	OnSale		Character(1),		# 1 or 0 - if 1, the 
						# title is on sale;  if 0, 
						# it is not
	TitleDesc	VarChar(255),		# Description of title
	TitlePic	Character(128)		# Path name of file
						# that stores the bitmap
						# of the book title page
#	TitlePic	VarBinary		Used only if the database  
#						supports the data type	
) ;

Create Unique Index Titles on TITLES ( ISBN ) ;

#
#	SUBJECTS table:  Lists subjects covered by each title.
#			 One title may cover many subjects. 

# Drop Table SUBJECTS Cascade ;

Create Table SUBJECTS (
	ISBN		Character(13) Not Null, # ISBN of book - 
						# 1st Part of 
						# Primary Key
	Subject		Character(20) Not Null	# Subject name - 
						# should exist
						# in CODELIST table.
						# 2nd part of
						# Primary Key
) ;

Create Unique Index Subjects on SUBJECTS ( ISBN, Subject ) ;
Create Index Subject on SUBJECTS ( Subject ) ;

#
#	CUSTOMER table:  Maintains information about customers.
# 

# 	Drop Table CUSTOMER Cascade ;

Create Table CUSTOMER (
	CustomerId	Integer Not Null,	# Customer Id - 
						# automatically
						# generated for a
						# new customer.
						# Primary Key
	FirstName	Character(20),		# First name
	LastName	Character(20) Not Null,	# Last name.  Also used
						# if the customer is
						# a company
	Address1	Character(50),
	Address2	Character(50),
	City		Character(20),
	State		Character(2),
	ZIP		Character(10),
	PhoneNo		Character(20),
	Fax		Character(20),
	Balance		Numeric(10,2),		# Amount due from customer
	CreditLmt	Numeric(10,2)		# Credit limit of customer
) ;

Create Unique Index Customer on CUSTOMER ( CustomerId ) ;

#
#	ORDERS table:  Maintains information about orders.
#

#	Drop Table ORDERS Cascade ;

Create Table ORDERS (
	OrderId		Integer Not Null,	# Order Id - automatically
						# generated for a new
						# order.  Primary Key
	CustomerId	Integer Not Null,	# Customer Id - should
						# exist in CUSTOMER table
	OrderDate	Timestamp,		# Date and time of
						# order - automatically 
						# updated by system
	Tax		Numeric(10,2),		# Tax amount for order.
						# Calculated as 8.25% of
						# total (Quantity *
						# SalePrice) from the
						# DETAILS table
	OrdTakenBy	Character(12)		# Id of user who entered
						# the order - automatically
						# updated by system
) ;

Create Unique Index Orders on ORDERS ( OrderId ) ;

#
#	DETAILS table:  Maintains information about items
#	in the order.  ( OrderId, ItemNo ) together form
#	the primary key.
#

#	Drop Table DETAILS Cascade ;

Create Table DETAILS (
	OrderId		Integer Not Null,	# Order Id - should
						# exist in ORDERS table.
						# 1st part
						# of Primary Key
	ItemNo		Integer Not Null,	# Order item number - 
						# automatically 
						# generated 
						# for each new order
						# item.  2nd part of
						# Primary Key
	ISBN		Character(13) Not Null,	# ISBN of title - should
						# exist in TITLES table
	Quantity	Integer Not Null,	# No. of titles ordered
	Discount	Numeric(10,2),		# Discount given 
	SalePrice	Numeric(10,2)		# Price at which the item
						# was sold
) ;

Create Unique Index Details on DETAILS ( OrderId, ItemNo );

#
#	SHIPPING table:	 Maintains shipping information about an
#	order, including Ship To address and order status.
#

#	Drop Table SHIPPING Cascade ;

Create Table SHIPPING (
	OrderId		Integer Not Null,	# Order Id - Primary Key
	FirstName	Character(20),		
	LastName	Character(20),
	Address1	Character(50),
	Address2	Character(50),
	City		Character(20),
	State		Character(2),
	ZIP		Character(10),
	PhoneNo		Character(20),
	Fax		Character(20),
	Status		Character(1), 		# Shipping status 
	ShipMethod	Character(20)		# Shipping method - should
						# exist in CODELIST table 
) ;

Create Unique Index Shipping on SHIPPING ( OrderId ) ;

#
#	CODELIST table:  Maintains enumerated lists for code lookups.
#

#	Drop Table CODELIST Cascade ;

Create Table CODELIST (
	CodeVal		Character(20) Not Null,	# Primary Key
	CodeType	Character(10) Not Null,	# Code type
	CodeDesc	Character(50) Not Null	# Description
) ;

Create Unique Index CodeList on CODELIST ( CodeVal ) ;
Create Index CodeType on CODELIST ( CodeType ) ;

#
#	PARAMS table:  Maintains system-wide parameters.
# 

#	Drop Table PARAMS Cascade ;

Create Table PARAMS (
	ParamId		Integer Not Null,	# Primary Key
	CustomerId	Integer,		# Last Customer Id used
	OrderId		Integer			# Last Order Id used
) ;

Create Unique Index Params on PARAMS ( ParamId ) ;


SELECT * FROM PARAMS ;	

#	Load data


IMPORT TITLES.DBF,DBASE3 TITLES ;
IMPORT SUBJECTS.DBF,DBASE3 SUBJECTS ;
IMPORT CUSTOMER.DBF,DBASE3 CUSTOMER ;
IMPORT DETAILS.DBF,DBASE3 DETAILS ;
IMPORT ORDERS.DBF,DBASE3 ORDERS ;
IMPORT SHIPPING.DBF,DBASE3 SHIPPING ;
IMPORT CODELIST.DBF,DBASE3 CODELIST ;
IMPORT PARAMS.DBF,DBASE3 PARAMS ;
